/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectView;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRemoteLibrariesNode
extends PsiDirectoryNode {
    @NotNull
    private final RemoteSdkProperties myRemoteSdkData;

    private PyRemoteLibrariesNode(@NotNull Project project, @NotNull RemoteSdkProperties sdkAdditionalData, @NotNull PsiDirectory value, ViewSettings viewSettings) {
        if (project == null) {
            PyRemoteLibrariesNode.$$$reportNull$$$0(0);
        }
        if (sdkAdditionalData == null) {
            PyRemoteLibrariesNode.$$$reportNull$$$0(1);
        }
        if (value == null) {
            PyRemoteLibrariesNode.$$$reportNull$$$0(2);
        }
        super(project, value, viewSettings);
        this.myRemoteSdkData = sdkAdditionalData;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            PyRemoteLibrariesNode.$$$reportNull$$$0(3);
        }
        data.setPresentableText(PyBundle.message("python.project.view.remote.libraries", new Object[0]));
        data.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    @Nullable
    public static PyRemoteLibrariesNode create(@NotNull Project project, @NotNull Sdk sdk2, ViewSettings settings) {
        SdkAdditionalData sdkAdditionalData;
        if (project == null) {
            PyRemoteLibrariesNode.$$$reportNull$$$0(4);
        }
        if (sdk2 == null) {
            PyRemoteLibrariesNode.$$$reportNull$$$0(5);
        }
        if ((sdkAdditionalData = sdk2.getSdkAdditionalData()) instanceof RemoteSdkProperties && sdkAdditionalData instanceof PythonSdkAdditionalData) {
            VirtualFile remoteLibrary = PythonSdkUtil.findAnyRemoteLibrary((Sdk)sdk2);
            if (remoteLibrary != null && remoteLibrary.getFileType() instanceof ArchiveFileType) {
                remoteLibrary = JarFileSystem.getInstance().getLocalByEntry(remoteLibrary);
            }
            if (remoteLibrary != null) {
                VirtualFile remoteLibraries = remoteLibrary.getParent();
                PsiDirectory remoteLibrariesDirectory = PsiManager.getInstance((Project)project).findDirectory(remoteLibraries);
                if (remoteLibrariesDirectory != null) {
                    return new PyRemoteLibrariesNode(project, (RemoteSdkProperties)sdkAdditionalData, remoteLibrariesDirectory, settings);
                }
            }
        }
        return null;
    }

    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])((PsiDirectory)this.getValue()).getChildren())).transform(input -> {
            if (input instanceof PsiFileSystemItem) {
                PsiDirectory dir;
                String path2 = ((PsiFileSystemItem)input).getVirtualFile().getPath();
                PsiDirectory psiDirectory = dir = input instanceof PsiDirectory ? (PsiDirectory)input : this.getDirectoryForJar((PsiFile)input);
                if (this.myRemoteSdkData.getPathMappings().canReplaceLocal(path2) && dir != null) {
                    return new PyRemoteRootNode(this.myRemoteSdkData.getPathMappings().convertToRemote(path2), this.getProject(), dir, this.getSettings());
                }
            }
            return null;
        }).filter(Predicates.notNull()).toList();
    }

    @Nullable
    private PsiDirectory getDirectoryForJar(PsiFile input) {
        VirtualFile jarRoot = PyRemoteLibrariesNode.getJarRoot(input);
        if (this.myProject != null && jarRoot != null) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(jarRoot);
        }
        return null;
    }

    @Nullable
    private static VirtualFile getJarRoot(PsiFile input) {
        VirtualFile file = input.getVirtualFile();
        if (file == null || !file.isValid() || !(file.getFileType() instanceof ArchiveFileType)) {
            return null;
        }
        return JarFileSystem.getInstance().getJarRootForLocalFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/projectView/PyRemoteLibrariesNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PyRemoteRootNode
    extends PsiDirectoryNode {
        private final String myRemotePath;

        public PyRemoteRootNode(String remotePath, Project project, @NotNull PsiDirectory value, ViewSettings viewSettings) {
            if (value == null) {
                PyRemoteRootNode.$$$reportNull$$$0(0);
            }
            super(project, value, viewSettings);
            this.myRemotePath = remotePath;
        }

        protected void updateImpl(@NotNull PresentationData data) {
            if (data == null) {
                PyRemoteRootNode.$$$reportNull$$$0(1);
            }
            data.setPresentableText(this.myRemotePath);
            data.setIcon(PlatformIcons.FOLDER_ICON);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/projectView/PyRemoteLibrariesNode$PyRemoteRootNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

