/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.codeInsight.typing.PyBundledStubs;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.remote.UnsupportedPythonSdkTypeException;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTargetsIntrospectionFacade;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.headless.PythonActivityKey;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.awt.Component;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PythonSdkUpdater {
    private static final Logger LOG = Logger.getInstance(PythonSdkUpdater.class);
    private static final Object ourLock = new Object();
    private static final Set<Sdk> ourUnderRefresh = new HashSet<Sdk>();
    private static final Map<Sdk, PyUpdateSdkRequestData> ourToBeRefreshed = new HashMap<Sdk, PyUpdateSdkRequestData>();
    private static final String NOTIFICATION_GROUP_ID = "Python SDK Updater";
    private static volatile boolean ourEnabledInTests = false;

    @ApiStatus.Internal
    @TestOnly
    public static void setEnabledInTests(boolean enabled) {
        ourEnabledInTests = enabled;
    }

    @ApiStatus.Internal
    public static boolean updateVersionAndPathsSynchronouslyAndScheduleRemaining(@NotNull Sdk sdk2, @Nullable Project project) {
        boolean isSavedSdk;
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(0);
        }
        Application application = ApplicationManager.getApplication();
        try {
            if (application.isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    PythonSdkUpdater.updateLocalSdkVersionAndPaths(sdk2, project);
                    return null;
                }, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false, project);
            } else {
                LOG.assertTrue(!application.holdsReadLock(), (Object)"Synchronous SDK update should not be run under read action");
                PythonSdkUpdater.updateLocalSdkVersionAndPaths(sdk2, project);
            }
        }
        catch (InvalidSdkException e) {
            LOG.warn("Error while evaluating path and version: ", (Throwable)e);
            return false;
        }
        if (project == null) {
            return true;
        }
        PyUpdateSdkRequestData request = new PyUpdateSdkRequestData(true);
        boolean bl = isSavedSdk = PythonSdkUtil.findSdkByKey((String)PythonSdkType.getSdkKey(sdk2)) != null;
        if (application.isWriteIntentLockAcquired() && !isSavedSdk) {
            application.invokeLaterOnWriteThread(() -> PythonSdkUpdater.scheduleUpdate(sdk2, project, request));
        } else {
            PythonSdkUpdater.scheduleUpdate(sdk2, project, request);
        }
        return true;
    }

    private static void scheduleUpdate(@NotNull Sdk sdk2, @NotNull Project project, @NotNull PyUpdateSdkRequestData requestData) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(2);
        }
        if (requestData == null) {
            PythonSdkUpdater.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return;
        }
        if (!ourEnabledInTests && ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("Skipping background update for '" + String.valueOf(sdk2) + "' in unit test mode");
            return;
        }
        TrackingUtil.trackActivity((Project)project, (ActivityKey)PythonActivityKey.INSTANCE, () -> {
            Object object = ourLock;
            synchronized (object) {
                if (ourUnderRefresh.contains(sdk2)) {
                    PyUpdateSdkRequestData previousRequest;
                    if (Trigger.LOG.isDebugEnabled() && (previousRequest = ourToBeRefreshed.get(sdk2)) != null) {
                        String cause = Trigger.getCauseByTrace(previousRequest.myTraceback);
                        Trigger.LOG.debug("Discarding previous update for " + String.valueOf(sdk2) + " triggered by " + cause);
                    }
                    ourToBeRefreshed.merge(sdk2, requestData, PyUpdateSdkRequestData::merge);
                    return;
                }
                ourUnderRefresh.add(sdk2);
            }
            if (project.isDisposed()) {
                return;
            }
            ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(project, sdk2, requestData));
        });
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean update(@NotNull Sdk sdk2, @Nullable Project project, @Nullable Component ownerComponent) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(4);
        }
        return PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(sdk2, project);
    }

    public static void scheduleUpdate(@NotNull Sdk sdk2, @NotNull Project project) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(6);
        }
        PythonSdkUpdater.scheduleUpdate(sdk2, project, true);
    }

    @ApiStatus.Internal
    public static void scheduleUpdate(@NotNull Sdk sdk2, @NotNull Project project, Boolean withPackageUpdate) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(8);
        }
        PythonSdkUpdater.scheduleUpdate(sdk2, project, new PyUpdateSdkRequestData(withPackageUpdate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureUpdateScheduled(@NotNull Sdk sdk2, @NotNull Project project) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(9);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(10);
        }
        Object object = ourLock;
        synchronized (object) {
            if (ourUnderRefresh.contains(sdk2) || ourToBeRefreshed.containsKey(sdk2)) {
                return;
            }
            ourUnderRefresh.add(sdk2);
        }
        ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(project, sdk2, new PyUpdateSdkRequestData(true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateScheduled(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(11);
        }
        Object object = ourLock;
        synchronized (object) {
            return ourUnderRefresh.contains(sdk2) || ourToBeRefreshed.containsKey(sdk2);
        }
    }

    @ApiStatus.Internal
    public static void updateOrShowError(@NotNull Sdk sdk2, @Nullable Project project, @Nullable Component ownerComponent) {
        boolean versionAndPathsUpdated;
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(12);
        }
        if (!(versionAndPathsUpdated = PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(sdk2, project))) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)PyBundle.message("python.sdk.cannot.setup.sdk", PythonSdkUpdater.getSdkPresentableName(sdk2)), (String)PyBundle.message("python.sdk.invalid.python.sdk", new Object[0])));
        }
    }

    private static void updateLocalSdkVersionAndPaths(@NotNull Sdk sdk2, @Nullable Project project) throws InvalidSdkException {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(13);
        }
        PythonSdkUpdater.updateLocalSdkVersion(sdk2);
        if (!PythonSdkUtil.isRemote((Sdk)sdk2)) {
            try {
                PythonSdkUpdater.updateSdkPaths(sdk2, PythonSdkUpdater.evaluateSysPath(sdk2, project != null ? project : ProjectManager.getInstance().getDefaultProject()), project);
            }
            catch (ExecutionException e) {
                throw new InvalidSdkException(PyBundle.message("python.sdk.cannot.evaluate.sdk.version.error.message", new Object[0]), (Throwable)e);
            }
        }
    }

    private static void updateLocalSdkVersion(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(14);
        }
        if (!PythonSdkUtil.isRemote((Sdk)sdk2)) {
            ProgressManager.progress((String)PyBundle.message("sdk.updating.interpreter.version", new Object[0]));
            String versionString = sdk2.getSdkType().getVersionString(sdk2);
            PythonSdkUpdater.commitSdkVersionIfChanged(sdk2, versionString);
        }
    }

    private static void commitSdkVersionIfChanged(@NotNull Sdk sdk2, @Nullable String versionString) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(15);
        }
        if (!StringUtil.equals((CharSequence)versionString, (CharSequence)sdk2.getVersionString())) {
            PythonSdkUpdater.changeSdkModificator(sdk2, (Processor<? super SdkModificator>)((Processor)modificatorToWrite -> {
                modificatorToWrite.setVersionString(versionString);
                return true;
            }));
        }
    }

    private static void updateSdkPaths(@NotNull Sdk sdk2, @NotNull List<String> paths, @Nullable Project project) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(16);
        }
        if (paths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(17);
        }
        Set<VirtualFile> moduleRoots = PythonSdkUpdater.getModuleRoots(project);
        Collection<VirtualFile> excludedPaths = PythonSdkUpdater.getExcludedPaths(sdk2);
        Pair<List<VirtualFile>, List<VirtualFile>> sdkRoots = PythonSdkUpdater.splitIntoLibraryAndSourceRoots(sdk2, paths, moduleRoots, excludedPaths, it -> PythonSdkUpdater.sdkPathToRoot(sdk2, it));
        Pair<List<VirtualFile>, List<VirtualFile>> userAddedRoots = PythonSdkUpdater.splitIntoLibraryAndSourceRoots(sdk2, PythonSdkUpdater.getUserAddedPaths(sdk2), moduleRoots, excludedPaths, Function.identity());
        boolean forceCommit = PythonSdkUpdater.ensureBinarySkeletonsDirectoryExists(sdk2);
        List<VirtualFile> localSdkPaths = PythonSdkUpdater.buildSdkPaths(sdk2, (List)sdkRoots.first, (List)userAddedRoots.first);
        PythonSdkUpdater.commitSdkPathsIfChanged(sdk2, localSdkPaths, forceCommit);
        if (Registry.is((String)"python.detect.cross.module.dependencies")) {
            HashSet transferredPathCandidates = new HashSet();
            transferredPathCandidates.addAll((Collection)sdkRoots.second);
            transferredPathCandidates.addAll((Collection)userAddedRoots.second);
            if (project != null) {
                PyTransferredSdkRootsKt.updateTransferredRoots(project, sdk2, transferredPathCandidates);
            }
        } else {
            HashSet pathsToTransfer = new HashSet();
            pathsToTransfer.addAll((Collection)sdkRoots.second);
            pathsToTransfer.addAll((Collection)userAddedRoots.second);
            HashSet<VirtualFile> nonTransferredModuleRoots = new HashSet<VirtualFile>(moduleRoots);
            nonTransferredModuleRoots.removeAll(PyTransferredSdkRootsKt.getPathsToTransfer(sdk2));
            pathsToTransfer.removeAll(nonTransferredModuleRoots);
            if (!pathsToTransfer.equals(PyTransferredSdkRootsKt.getPathsToTransfer(sdk2))) {
                if (project != null) {
                    PyTransferredSdkRootsKt.removeTransferredRootsFromModulesWithSdk(project, sdk2);
                }
                PyTransferredSdkRootsKt.setPathsToTransfer(sdk2, pathsToTransfer);
                if (project != null) {
                    PyTransferredSdkRootsKt.transferRootsToModulesWithSdk(project, sdk2);
                }
            }
        }
    }

    private static boolean ensureBinarySkeletonsDirectoryExists(Sdk sdk2) {
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath((Sdk)sdk2);
        return skeletonsPath != null && new File(skeletonsPath).mkdirs();
    }

    @NotNull
    private static List<VirtualFile> buildSdkPaths(@NotNull Sdk sdk2, @NotNull List<VirtualFile> sdkRoots, @NotNull List<VirtualFile> userAddedRoots) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(18);
        }
        if (sdkRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(19);
        }
        if (userAddedRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(20);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(sdkRoots).addAll(PythonSdkUpdater.getSkeletonsPaths(sdk2)).addAll(userAddedRoots).addAll((Iterable)PyTypeShed.INSTANCE.findStdlibRootsForSdk(sdk2)).build();
        if (immutableList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(21);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> getUserAddedPaths(@NotNull Sdk sdk2) {
        SdkAdditionalData additionalData;
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(22);
        }
        ArrayList arrayList = (pythonAdditionalData = (PythonSdkAdditionalData)PyUtil.as((Object)(additionalData = sdk2.getSdkAdditionalData()), PythonSdkAdditionalData.class)) != null ? Lists.newArrayList((Iterable)pythonAdditionalData.getAddedPathFiles()) : Collections.emptyList();
        if (arrayList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getRemoteSdkMappedPaths(@NotNull Sdk sdk2) {
        SdkAdditionalData additionalData;
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(24);
        }
        if ((additionalData = sdk2.getSdkAdditionalData()) instanceof RemoteSdkProperties) {
            RemoteSdkProperties remoteSdkData = (RemoteSdkProperties)additionalData;
            ArrayList<String> paths = new ArrayList<String>();
            for (PathMappingSettings.PathMapping mapping : remoteSdkData.getPathMappings().getPathMappings()) {
                paths.add(mapping.getLocalRoot());
            }
            ArrayList<String> arrayList = paths;
            if (arrayList == null) {
                PythonSdkUpdater.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkUpdater.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static <T> @NotNull Pair<@NotNull List<VirtualFile>, @NotNull List<VirtualFile>> splitIntoLibraryAndSourceRoots(@NotNull Sdk sdk2, @NotNull List<T> paths, @NotNull Set<VirtualFile> moduleRoots, @NotNull Collection<VirtualFile> excludedPaths, @NotNull Function<T, @Nullable VirtualFile> mapper) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(27);
        }
        if (paths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(28);
        }
        if (moduleRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(29);
        }
        if (excludedPaths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(30);
        }
        if (mapper == null) {
            PythonSdkUpdater.$$$reportNull$$$0(31);
        }
        ArrayList<VirtualFile> lib = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> source = new ArrayList<VirtualFile>();
        for (T path2 : paths) {
            VirtualFile rootFile = mapper.apply(path2);
            if (rootFile != null && !excludedPaths.contains(rootFile)) {
                if (PythonSdkUpdater.isUnderModuleRootsButNotSdk(rootFile, moduleRoots, sdk2)) {
                    source.add(rootFile);
                    continue;
                }
                lib.add(rootFile);
                continue;
            }
            LOG.info("Bogus sys.path entry " + String.valueOf(path2));
        }
        Pair.NonNull nonNull = Pair.createNonNull(lib, source);
        if (nonNull == null) {
            PythonSdkUpdater.$$$reportNull$$$0(32);
        }
        return nonNull;
    }

    @ApiStatus.Internal
    @NotNull
    public static Set<VirtualFile> getModuleRoots(@Nullable Project project) {
        if (project != null) {
            Module[] modules;
            HashSet<VirtualFile> moduleRoots = new HashSet<VirtualFile>();
            for (Module module2 : modules = ModuleManager.getInstance((Project)project).getModules()) {
                moduleRoots.addAll(PyUtil.getSourceRoots((Module)module2));
            }
            HashSet<VirtualFile> hashSet = moduleRoots;
            if (hashSet == null) {
                PythonSdkUpdater.$$$reportNull$$$0(33);
            }
            return hashSet;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            PythonSdkUpdater.$$$reportNull$$$0(34);
        }
        return set;
    }

    @NotNull
    private static Collection<VirtualFile> getExcludedPaths(@NotNull Sdk sdk2) {
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(35);
        }
        Collection<Object> collection = (pythonAdditionalData = (PythonSdkAdditionalData)PyUtil.as((Object)sdk2.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? pythonAdditionalData.getExcludedPathFiles() : Collections.emptyList();
        if (collection == null) {
            PythonSdkUpdater.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @Nullable
    private static VirtualFile sdkPathToRoot(@NotNull Sdk sdk2, @Nullable String path2) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(37);
        }
        if (path2 != null && !FileUtilRt.extensionEquals((String)path2, (String)"egg-info")) {
            VirtualFile condaFolder = PythonSdkUtil.isConda((Sdk)sdk2) ? PythonSdkUtil.getCondaDirectory((Sdk)sdk2) : null;
            VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(path2);
            if (virtualFile != null && !virtualFile.equals(condaFolder)) {
                return PythonSdkType.getSdkRootVirtualFile(virtualFile);
            }
        }
        return null;
    }

    private static boolean isUnderModuleRootsButNotSdk(@NotNull VirtualFile file, @NotNull Set<VirtualFile> moduleRoots, @NotNull Sdk sdk2) {
        if (file == null) {
            PythonSdkUpdater.$$$reportNull$$$0(38);
        }
        if (moduleRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(39);
        }
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(40);
        }
        if (VfsUtilCore.isUnder((VirtualFile)file, moduleRoots)) {
            VirtualFile envRoot = PySdkExtKt.getInnerVirtualEnvRoot(sdk2);
            if (envRoot == null) {
                return true;
            }
            return !VfsUtilCore.isAncestor((VirtualFile)envRoot, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    @NotNull
    private static List<VirtualFile> getSkeletonsPaths(@NotNull Sdk sdk2) {
        VirtualFile skeletonsDir;
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(41);
        }
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath((Sdk)sdk2);
        if (skeletonsPath != null && (skeletonsDir = StandardFileSystems.local().refreshAndFindFileByPath(skeletonsPath)) != null) {
            results.add(skeletonsDir);
            LOG.info("Binary skeletons directory for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk2) + "): " + skeletonsDir.getPath());
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @NotNull
    private static String getSdkPresentableName(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(43);
        }
        String homePath = sdk2.getHomePath();
        String name2 = sdk2.getName();
        Object object = homePath != null ? name2 + " (" + homePath + ")" : name2;
        if (object == null) {
            PythonSdkUpdater.$$$reportNull$$$0(44);
        }
        return object;
    }

    @NotNull
    private static List<String> evaluateSysPath(@NotNull Sdk sdk2, @NotNull Project project) throws ExecutionException {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(45);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(46);
        }
        long startTime = System.currentTimeMillis();
        ProgressManager.progress((String)PyBundle.message("sdk.updating.interpreter.paths", new Object[0]));
        if (ApplicationManager.getApplication().isUnitTestMode() && PythonSdkType.isMock(sdk2)) {
            List<String> list = PythonSdkType.getMockPath(sdk2);
            if (list == null) {
                PythonSdkUpdater.$$$reportNull$$$0(47);
            }
            return list;
        }
        List<String> sysPath = new PyTargetsIntrospectionFacade(sdk2, project).getInterpreterPaths((ProgressIndicator)new EmptyProgressIndicator());
        LOG.info("Updating sys.path took " + (System.currentTimeMillis() - startTime) + " ms");
        List<String> list = sysPath;
        if (list == null) {
            PythonSdkUpdater.$$$reportNull$$$0(48);
        }
        return list;
    }

    private static void commitSdkPathsIfChanged(@NotNull Sdk sdk2, @NotNull List<VirtualFile> sdkPaths, boolean forceCommit) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(49);
        }
        if (sdkPaths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(50);
        }
        List<VirtualFile> currentSdkPaths = Arrays.asList(sdk2.getRootProvider().getFiles(OrderRootType.CLASSES));
        if (forceCommit || !Sets.newHashSet(sdkPaths).equals(Sets.newHashSet(currentSdkPaths))) {
            PythonSdkUpdater.changeSdkModificator(sdk2, (Processor<? super SdkModificator>)((Processor)effectiveModificator -> {
                effectiveModificator.removeAllRoots();
                for (VirtualFile sdkPath : sdkPaths) {
                    effectiveModificator.addRoot(PythonSdkType.getSdkRootVirtualFile(sdkPath), OrderRootType.CLASSES);
                }
                return true;
            }));
        }
    }

    private static void changeSdkModificator(@NotNull Sdk sdk2, @NotNull Processor<? super SdkModificator> processor) {
        if (sdk2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            PythonSdkUpdater.$$$reportNull$$$0(52);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            SdkModificator effectiveModificator = sdk2.getSdkModificator();
            if (processor.process((Object)effectiveModificator)) {
                ApplicationManager.getApplication().runWriteAction(() -> effectiveModificator.commitChanges());
            }
        });
    }

    @NotNull
    static Set<Sdk> getPythonSdks(@NotNull Project project) {
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(53);
        }
        LinkedHashSet<Sdk> pythonSdks = new LinkedHashSet<Sdk>();
        ReadAction.run(() -> {
            for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)module2);
                if (sdk2 == null || !(sdk2.getSdkType() instanceof PythonSdkType)) continue;
                pythonSdks.add(sdk2);
            }
        });
        LinkedHashSet<Sdk> linkedHashSet = pythonSdks;
        if (linkedHashSet == null) {
            PythonSdkUpdater.$$$reportNull$$$0(54);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 23, 25, 26, 32, 33, 34, 36, 42, 44, 47, 48, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestData";
                break;
            }
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoots";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAddedRoots";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoots";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPaths";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPaths";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSdkPaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAddedPaths";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkMappedPaths";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIntoLibraryAndSourceRoots";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRoots";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPaths";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPresentableName";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSysPath";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateVersionAndPathsSynchronouslyAndScheduleRemaining";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpdateScheduled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateScheduled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateOrShowError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersionAndPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "commitSdkVersionIfChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkPaths";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkPaths";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 54: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUserAddedPaths";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkMappedPaths";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "splitIntoLibraryAndSourceRoots";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedPaths";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sdkPathToRoot";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isUnderModuleRootsButNotSdk";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPaths";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPresentableName";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSysPath";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "commitSdkPathsIfChanged";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "changeSdkModificator";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 23, 25, 26, 32, 33, 34, 36, 42, 44, 47, 48, 54 -> new IllegalStateException(string);
        };
    }

    private static class PyUpdateSdkRequestData {
        final Instant myTimestamp;
        final Throwable myTraceback;
        final boolean withPackagesUpdate;

        private PyUpdateSdkRequestData(boolean withPackagesUpdate) {
            this(Instant.now(), new Throwable(), withPackagesUpdate);
        }

        private PyUpdateSdkRequestData(@NotNull Instant timestamp, @NotNull Throwable traceback, boolean withPackagesUpdate) {
            if (timestamp == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(0);
            }
            if (traceback == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(1);
            }
            this.myTimestamp = timestamp;
            this.myTraceback = traceback;
            this.withPackagesUpdate = withPackagesUpdate;
        }

        @NotNull
        private static PyUpdateSdkRequestData merge(@NotNull PyUpdateSdkRequestData oldRequest, @NotNull PyUpdateSdkRequestData newRequest) {
            if (oldRequest == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(2);
            }
            if (newRequest == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(3);
            }
            return new PyUpdateSdkRequestData(oldRequest.myTimestamp, newRequest.myTraceback, oldRequest.withPackagesUpdate || newRequest.withPackagesUpdate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traceback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRequest";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRequest";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$PyUpdateSdkRequestData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PyUpdateSdkTask
    extends Task.Backgroundable {
        @NotNull
        private final Sdk mySdk;
        @NotNull
        private final PyUpdateSdkRequestData myRequestData;
        @NotNull
        private final Project myProject;

        PyUpdateSdkTask(@NotNull Project project, @NotNull Sdk sdk2, @NotNull PyUpdateSdkRequestData requestData) {
            if (project == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(0);
            }
            if (sdk2 == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(1);
            }
            if (requestData == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(2);
            }
            super(project, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false);
            this.mySdk = sdk2;
            this.myRequestData = requestData;
            this.myProject = project;
        }

        private boolean isSdkDisposed() {
            return this.mySdk instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)this.mySdk));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(3);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.isSdkDisposed()) {
                return;
            }
            Disposable indicatorDisposable = this.getIndicatorDisposable(indicator);
            Disposer.register((Disposable)PythonPluginDisposable.getInstance((Project)this.myProject), (Disposable)indicatorDisposable);
            if (Trigger.LOG.isDebugEnabled()) {
                Trigger.LOG.debug("Starting SDK refresh for '" + this.mySdk.getName() + "' triggered by " + Trigger.getCauseByTrace(this.myRequestData.myTraceback));
            }
            try {
                PyTargetsIntrospectionFacade targetsFacade = new PyTargetsIntrospectionFacade(this.mySdk, this.myProject);
                String version2 = targetsFacade.getInterpreterVersion(indicator);
                PythonSdkUpdater.commitSdkVersionIfChanged(this.mySdk, version2);
                if (targetsFacade.isLocalTarget()) {
                    List<String> paths = targetsFacade.getInterpreterPaths(indicator);
                    PythonSdkUpdater.updateSdkPaths(this.mySdk, paths, this.myProject);
                } else {
                    targetsFacade.synchronizeRemoteSourcesAndSetupMappings(indicator);
                }
                this.generateSkeletons(this.mySdk, indicator);
                if (this.myRequestData.withPackagesUpdate) {
                    this.refreshPackages(this.mySdk, indicator);
                }
                this.addBundledPyiStubsToInterpreterPaths(this.mySdk);
            }
            catch (ExecutionException e) {
                LOG.warn("Update for SDK " + this.mySdk.getName() + " failed", (Throwable)e);
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    Disposer.dispose((Disposable)indicatorDisposable);
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart((Object)this);
                }, this.myProject.getDisposed());
            }
        }

        private void addBundledPyiStubsToInterpreterPaths(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(4);
            }
            ArrayList allStubRoots = new ArrayList();
            ContainerUtil.addIfNotNull(allStubRoots, (Object)PyTypeShed.INSTANCE.getThirdPartyStubRoot());
            ContainerUtil.addIfNotNull(allStubRoots, (Object)PyBundledStubs.INSTANCE.getRoot());
            PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(this.myProject, sdk2);
            Set installedPackageNames = ContainerUtil.map2Set(packageManager.listInstalledPackagesSnapshot(), PythonPackage::getName);
            List bundledStubRoots = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(allStubRoots).flatArray(root -> root.getChildren()).filter(VirtualFile::isDirectory)).filter(stubPkgRoot -> {
                String stubPkgName = stubPkgRoot.getName();
                String stubPkgAlias = PyPsiPackageUtil.INSTANCE.moduleToPackageName(stubPkgName, stubPkgName);
                return installedPackageNames.contains(stubPkgName) || installedPackageNames.contains(stubPkgAlias);
            })).filter(stubPkgRoot -> {
                String pypiStubPkgName = stubPkgRoot.getName().toLowerCase(Locale.ROOT) + "-stubs";
                String typeshedStubPkgName = "types-" + stubPkgRoot.getName();
                return !installedPackageNames.contains(pypiStubPkgName) && !installedPackageNames.contains(typeshedStubPkgName);
            })).toList();
            LOG.info("Bundled .pyi stub roots for SDK " + String.valueOf(sdk2) + ":" + String.valueOf(bundledStubRoots));
            PythonSdkUpdater.changeSdkModificator(sdk2, (Processor<? super SdkModificator>)((Processor)effectiveModificator -> {
                VirtualFile[] currentRoots = effectiveModificator.getRoots(OrderRootType.CLASSES);
                effectiveModificator.removeAllRoots();
                for (VirtualFile sdkPath : ContainerUtil.concat(List.of(currentRoots), (List)bundledStubRoots)) {
                    effectiveModificator.addRoot(PythonSdkType.getSdkRootVirtualFile(sdkPath), OrderRootType.CLASSES);
                }
                return true;
            }));
        }

        @NotNull
        private Disposable getIndicatorDisposable(final @NotNull ProgressIndicator indicator) {
            Disposable disposable;
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(5);
            }
            return indicator instanceof Disposable ? (disposable = (Disposable)indicator) : new Disposable(){

                public void dispose() {
                    LOG.info("Cancelling update for " + String.valueOf(mySdk));
                    if (indicator.isRunning()) {
                        indicator.cancel();
                    }
                }
            };
        }

        private void refreshPackages(@NotNull Sdk sdk2, @NotNull ProgressIndicator indicator) {
            if (sdk2 == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(6);
            }
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(7);
            }
            try {
                LOG.info("Performing background scan of packages for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk2));
                indicator.setIndeterminate(true);
                indicator.setText(PyBundle.message("python.sdk.scanning.installed.packages", new Object[0]));
                indicator.setText2("");
                if (Disposer.isDisposed((Disposable)((Disposable)sdk2))) {
                    return;
                }
                PythonPackageManager manager = PythonPackageManager.Companion.forSdk(this.myProject, sdk2);
                PythonPackageManagerExt.reloadPackagesBlocking(manager);
            }
            catch (Throwable e) {
                LOG.warn(e.getMessage());
            }
        }

        private void generateSkeletons(@NotNull Sdk sdk2, @NotNull ProgressIndicator indicator) {
            if (sdk2 == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(8);
            }
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(9);
            }
            String skeletonsPath = PythonSdkUtil.getSkeletonsPath((Sdk)sdk2);
            try {
                String sdkPresentableName = PythonSdkUpdater.getSdkPresentableName(sdk2);
                LOG.info("Performing background update of skeletons for SDK " + sdkPresentableName);
                indicator.setText(PyBundle.message("python.sdk.updating.skeletons", new Object[0]));
                PySkeletonRefresher.refreshSkeletonsOfSdk(this.myProject, null, skeletonsPath, sdk2);
                if (PythonSdkUtil.isRemote((Sdk)sdk2)) {
                    PythonSdkUpdater.updateSdkPaths(sdk2, PythonSdkUpdater.getRemoteSdkMappedPaths(sdk2), this.getProject());
                }
            }
            catch (UnsupportedPythonSdkTypeException | InvalidSdkException e) {
                this.notifyOfGenerationFailure((Exception)e, sdk2);
            }
        }

        private void notifyOfGenerationFailure(@NotNull Exception exception, @NotNull Sdk sdk2) {
            if (exception == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(10);
            }
            if (sdk2 == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(11);
            }
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                LOG.warn((Throwable)exception);
                return;
            }
            if (exception instanceof UnsupportedPythonSdkTypeException) {
                NotificationGroupManager.getInstance().getNotificationGroup(PythonSdkUpdater.NOTIFICATION_GROUP_ID).createNotification(PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), PyBundle.message("remote.interpreter.support.is.not.available", sdk2.getName()), NotificationType.WARNING).setDisplayId("remote.interpreter.support.is.not.available").notify(this.myProject);
            } else if (exception instanceof InvalidSdkException) {
                if (PythonSdkUtil.isRemote((Sdk)this.mySdk)) {
                    PythonSdkType.notifyRemoteSdkSkeletonsFail((InvalidSdkException)((Object)exception), () -> {
                        if (!this.isSdkDisposed()) {
                            PythonSdkUpdater.update(this.mySdk, this.myProject, null);
                        }
                    });
                } else if (PySdkExtKt.getSdkSeemsValid(sdk2)) {
                    LOG.error((Throwable)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFinished() {
            PyUpdateSdkRequestData requestData;
            if (Trigger.LOG.isDebugEnabled()) {
                Trigger.LOG.debug("Finishing SDK refresh for '" + this.mySdk.getName() + "' originally scheduled at " + String.valueOf(this.myRequestData.myTimestamp) + " by " + Trigger.getCauseByTrace(this.myRequestData.myTraceback));
            }
            Object object = ourLock;
            synchronized (object) {
                boolean existed = ourUnderRefresh.remove(this.mySdk);
                LOG.assertTrue(existed, (Object)"Error in SDK refresh scheduling: refreshed SDK is not in the set.");
                requestData = ourToBeRefreshed.remove(this.mySdk);
                if (requestData != null) {
                    ourUnderRefresh.add(this.mySdk);
                }
            }
            if (requestData != null) {
                if (Disposer.isDisposed((Disposable)this.myProject)) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(this.myProject, this.mySdk, requestData));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestData";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$PyUpdateSdkTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addBundledPyiStubsToInterpreterPaths";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getIndicatorDisposable";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshPackages";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateSkeletons";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyOfGenerationFailure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Trigger {
        STARTUP_ACTIVITY("com.jetbrains.python.sdk.PythonSdkUpdateProjectActivity.execute"),
        CHANGE_UNDER_INTERPRETER_ROOTS("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$subscribeToLocalChanges"),
        REFRESH_AFTER_PACKAGING_OPERATION("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$refresh"),
        NEW_SDK_GENERATION("com.jetbrains.python.sdk.PySdkExtKt.createSdkByGenerateTask"),
        CHANGED_SDK_CONFIGURATION("com.jetbrains.python.configuration.PyActiveSdkConfigurable.apply"),
        SDK_RELOAD_IN_SETTINGS("com.jetbrains.python.configuration.PythonSdkDetailsDialog.reloadSdk"),
        START_SDK_UPDATES_ACTION("com.jetbrains.python.sdk.PyUpdateProjectSdkAction.lambda$actionPerformed");

        private static final Logger LOG;
        private final String myFrameMarker;

        private Trigger(String frameMarker) {
            if (frameMarker == null) {
                Trigger.$$$reportNull$$$0(0);
            }
            this.myFrameMarker = frameMarker;
        }

        @NotNull
        public static String getCauseByTrace(@NotNull Throwable trace) {
            Trigger trigger;
            if (trace == null) {
                Trigger.$$$reportNull$$$0(1);
            }
            if ((trigger = Trigger.findTriggerByTrace(trace)) != null) {
                String string = trigger.name();
                if (string == null) {
                    Trigger.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = "Unknown trigger:\n" + ExceptionUtil.getThrowableText((Throwable)trace);
            if (string == null) {
                Trigger.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public static Trigger findTriggerByTrace(@NotNull Throwable trace) {
            if (trace == null) {
                Trigger.$$$reportNull$$$0(4);
            }
            String traceText = ExceptionUtil.getThrowableText((Throwable)trace);
            for (Trigger value : Trigger.values()) {
                if (!traceText.contains(value.myFrameMarker)) continue;
                return value;
            }
            return null;
        }

        static {
            LOG = Logger.getInstance(Trigger.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameMarker";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdater$Trigger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$Trigger";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCauseByTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCauseByTrace";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findTriggerByTrace";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

