/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors.conda;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.pathValidation.PathValidatorKt;
import com.jetbrains.python.pathValidation.PlatformAndRoot;
import com.jetbrains.python.pathValidation.ValidationRequest;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.PyCondaFlavorData;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public final class CondaEnvSdkFlavor
extends CPythonSdkFlavor<PyCondaFlavorData> {
    private CondaEnvSdkFlavor() {
    }

    public static CondaEnvSdkFlavor getInstance() {
        return (CondaEnvSdkFlavor)((Object)PythonSdkFlavor.EP_NAME.findExtension(CondaEnvSdkFlavor.class));
    }

    public boolean providePyCharmHosted() {
        return false;
    }

    public boolean isPlatformIndependent() {
        return true;
    }

    public boolean supportsEmptyData() {
        return false;
    }

    @NotNull
    public Class<PyCondaFlavorData> getFlavorDataClass() {
        return PyCondaFlavorData.class;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    protected @NotNull Collection<@NotNull Path> suggestLocalHomePathsImpl(@Nullable Module module2, @Nullable UserDataHolder context) {
        List<Path> list = Collections.emptyList();
        if (list == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    public boolean sdkSeemsValid(@NotNull Sdk sdk2, @NotNull PyCondaFlavorData flavorData, @Nullable TargetEnvironmentConfiguration targetConfig) {
        if (sdk2 == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        if (flavorData == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(2);
        }
        String condaPath = flavorData.getEnv().getFullCondaPathOnTarget();
        return CondaEnvSdkFlavor.isFileExecutable((String)condaPath, (TargetEnvironmentConfiguration)targetConfig);
    }

    @NotNull
    public String getUniqueId() {
        return "Conda";
    }

    public boolean isValidSdkPath(@NotNull String pathStr2) {
        if (pathStr2 == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(3);
        }
        if (!super.isValidSdkPath(pathStr2)) {
            return false;
        }
        return PythonSdkUtil.isConda((String)pathStr2);
    }

    @Nullable
    public static File getCondaEnvRoot(@NotNull String binaryPath) {
        File binary;
        File parent;
        if (binaryPath == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(4);
        }
        if ((parent = (binary = new File(binaryPath)).getParentFile()) == null) {
            return null;
        }
        File parent2 = parent.getParentFile();
        if (parent2 == null) {
            return null;
        }
        File parent3 = parent2.getParentFile();
        if (parent3 != null && "envs".equals(parent3.getName())) {
            return parent2;
        }
        if ("envs".equals(parent2.getName())) {
            return parent;
        }
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Anaconda;
        if (icon == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @RequiresBackgroundThread
    @Nullable
    public static ValidationInfo validateCondaPath(@Nullable @SystemDependent String condaExecutable, @NotNull PlatformAndRoot platformAndRoot) {
        if (platformAndRoot == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertBackgroundThread();
        return PathValidatorKt.validateExecutableFile((ValidationRequest)new ValidationRequest(condaExecutable, PyBundle.message("python.add.sdk.conda.executable.path.is.empty", new Object[0]), platformAndRoot, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/conda/CondaEnvSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathStr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformAndRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePathsImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/conda/CondaEnvSdkFlavor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sdkSeemsValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCondaEnvRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateCondaPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

