/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageName;
import com.jetbrains.python.packaging.common.PythonOutdatedPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "PoetryFileVisitor", "intellij.python.community.impl"})
public final class PoetryPackageVersionsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new PoetryFileVisitor(holder, session);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection$PoetryFileVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "guessModule", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "pyProjectTomlBlocking", "Lcom/intellij/openapi/vfs/VirtualFile;", "visitFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPoetryPackageVersionsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoetryPackageVersionsInspection.kt\ncom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection$PoetryFileVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1#2:74\n1#2:91\n3919#3:75\n4434#3,2:76\n11879#3,9:81\n13805#3:90\n13806#3:92\n11888#3:93\n1374#4:78\n1460#4,2:79\n1462#4,3:94\n1869#4,2:97\n*S KotlinDebug\n*F\n+ 1 PoetryPackageVersionsInspection.kt\ncom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection$PoetryFileVisitor\n*L\n61#1:91\n58#1:75\n58#1:76,2\n61#1:81,9\n61#1:90\n61#1:92\n61#1:93\n60#1:78\n60#1:79,2\n60#1:94,3\n62#1:97,2\n*E\n"})
    public static final class PoetryFileVisitor
    extends PsiElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public PoetryFileVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @RequiresBackgroundThread
        private final Module guessModule(PsiElement element) {
            Object object = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (object == null) {
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Module[] it = ModuleManager.Companion.getInstance(project).getModules();
                boolean bl = false;
                object = it.length != 1 ? null : it[0];
            }
            return object;
        }

        @RequiresBackgroundThread
        private final VirtualFile pyProjectTomlBlocking(Module $this$pyProjectTomlBlocking) {
            return BasePySdkExtKt.findAmongRoots((Module)$this$pyProjectTomlBlocking, (String)"pyproject.toml");
        }

        /*
         * WARNING - void declaration
         */
        @RequiresBackgroundThread
        public void visitFile(@NotNull PsiFile psiFile) {
            void $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Module module2 = this.guessModule((PsiElement)psiFile);
            if (module2 == null) {
                return;
            }
            Module module3 = module2;
            Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)module3);
            if (sdk2 == null) {
                return;
            }
            Sdk sdk3 = sdk2;
            if (!PoetryKt.isPoetry(sdk3)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)psiFile.getVirtualFile(), (Object)this.pyProjectTomlBlocking(module3))) {
                return;
            }
            PsiElement[] psiElementArray = psiFile.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] objectArray = psiElementArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                TomlTable tomlTable;
                PsiElement element = (PsiElement)element$iv$iv;
                boolean bl = false;
                Object[] objectArray2 = new String[]{"tool.poetry.dependencies", "tool.poetry.dev-dependencies"};
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray2), (tomlTable = element instanceof TomlTable ? (TomlTable)element : null) != null && (tomlTable = tomlTable.getHeader()) != null && (tomlTable = tomlTable.getKey()) != null ? tomlTable.getText() : null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl = false;
                PsiElement[] psiElementArray2 = it.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                Object[] $this$mapNotNull$iv = psiElementArray2;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray3 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    TomlKeyValue it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl2 = false;
                    PsiElement line = (PsiElement)element$iv$iv2;
                    boolean bl3 = false;
                    if ((line instanceof TomlKeyValue ? (TomlKeyValue)line : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TomlKeyValue keyValue = (TomlKeyValue)element$iv;
                boolean bl = false;
                String string = keyValue.getKey().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String packageName = PyPackageName.Companion.normalizePackageName(string);
                Project project = module3.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PythonOutdatedPackage outdatedVersion = PythonPackageManager.Companion.forSdk(project, sdk3).listOutdatedPackagesSnapshot().get(packageName);
                if (outdatedVersion == null) continue;
                Object[] objectArray4 = new Object[]{packageName, outdatedVersion.getVersion(), outdatedVersion.getLatestVersion()};
                String string2 = PyBundle.message("python.sdk.inspection.message.version.outdated.latest", objectArray4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String message = string2;
                this.holder.registerProblem((PsiElement)keyValue, message, ProblemHighlightType.WARNING, new LocalQuickFix[0]);
            }
        }
    }
}

