/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.VolumeCopyingRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0003J\f\u0010\u0015\u001a\u00060\u0016R\u00020\u0001H\u0016J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\n\u0010\u001a\u001a\u00060\u0016R\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator;", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator;", "skeletonPath", "", "pySdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "currentFolder", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "pyRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "targetEnvRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetEnvRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "foundBinaries", "", "isLocalTarget", "", "commandBuilder", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder;", "runGeneration", "", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator$GenerationResult;", "builder", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "exists", "name", "TargetedBuilder", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyTargetsSkeletonGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTargetsSkeletonGenerator.kt\ncom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class PyTargetsSkeletonGenerator
extends PySkeletonGenerator {
    @NotNull
    private final HelpersAwareTargetEnvironmentRequest pyRequest;
    @NotNull
    private final Set<String> foundBinaries;

    public PyTargetsSkeletonGenerator(@NotNull String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)skeletonPath, (String)"skeletonPath");
        Intrinsics.checkNotNullParameter((Object)pySdk, (String)"pySdk");
        super(skeletonPath, pySdk, currentFolder);
        Sdk sdk2 = this.mySdk;
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"mySdk");
        Project project2 = project;
        if (project2 == null) {
            Project project3 = ProjectManager.getInstance().getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getDefaultProject(...)");
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(sdk2, project2);
        if (helpersAwareTargetEnvironmentRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.pyRequest = helpersAwareTargetEnvironmentRequest;
        this.foundBinaries = new HashSet();
    }

    private final TargetEnvironmentRequest getTargetEnvRequest() {
        return this.pyRequest.getTargetEnvironmentRequest();
    }

    @Deprecated(message="There should be no difference in your code between local and remote")
    private final boolean isLocalTarget() {
        return this.getTargetEnvRequest() instanceof LocalTargetEnvironmentRequest;
    }

    @NotNull
    public PySkeletonGenerator.Builder commandBuilder() {
        TargetedBuilder builder;
        block0: {
            Sdk sdk2 = this.mySdk;
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"mySdk");
            String string = this.mySkeletonsPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mySkeletonsPath");
            builder = new TargetedBuilder(sdk2, string);
            String string2 = this.myCurrentFolder;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            builder.workingDir(it);
        }
        return builder;
    }

    @NotNull
    protected List<PySkeletonGenerator.GenerationResult> runGeneration(@NotNull PySkeletonGenerator.Builder builder, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.foundBinaries.clear();
        List list = super.runGeneration(builder, indicator);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runGeneration(...)");
        List results = list;
        SequencesKt.toCollection((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)results), PyTargetsSkeletonGenerator::runGeneration$lambda$0), PyTargetsSkeletonGenerator::runGeneration$lambda$1), (Collection)this.foundBinaries);
        return results;
    }

    public boolean exists(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.isLocalTarget()) {
            return FileUtil.exists((String)name2);
        }
        return this.foundBinaries.contains(name2);
    }

    private static final String runGeneration$lambda$0(PySkeletonGenerator.GenerationResult it) {
        return it.getModuleOrigin();
    }

    private static final boolean runGeneration$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)"(built-in)", (Object)it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator$TargetedBuilder;", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder;", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "skeletonsPaths", "", "<init>", "(Lcom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;)V", "runProcessWithLineOutputListener", "Lcom/intellij/execution/process/ProcessOutput;", "listener", "Lcom/jetbrains/python/sdk/skeletons/LineWiseProcessOutputListener;", "runProcess", "doRunProcess", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyTargetsSkeletonGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTargetsSkeletonGenerator.kt\ncom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator$TargetedBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1869#2,2:167\n1869#2,2:170\n1#3:169\n*S KotlinDebug\n*F\n+ 1 PyTargetsSkeletonGenerator.kt\ncom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator$TargetedBuilder\n*L\n129#1:167,2\n139#1:170,2\n*E\n"})
    private final class TargetedBuilder
    extends PySkeletonGenerator.Builder {
        @NotNull
        private final Sdk sdk;
        @NotNull
        private final String skeletonsPaths;

        public TargetedBuilder(@NotNull Sdk sdk2, String skeletonsPaths) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            Intrinsics.checkNotNullParameter((Object)skeletonsPaths, (String)"skeletonsPaths");
            super((PySkeletonGenerator)PyTargetsSkeletonGenerator.this);
            this.sdk = sdk2;
            this.skeletonsPaths = skeletonsPaths;
        }

        @NotNull
        public ProcessOutput runProcessWithLineOutputListener(@NotNull LineWiseProcessOutputListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return this.doRunProcess(listener2);
        }

        @NotNull
        public ProcessOutput runProcess() throws InvalidSdkException {
            return this.doRunProcess(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ProcessOutput doRunProcess(LineWiseProcessOutputListener listener2) {
            PythonScriptExecution generatorScriptExecution = PythonScripts.prepareHelperScriptExecution(PythonHelper.GENERATOR3, PyTargetsSkeletonGenerator.this.pyRequest);
            generatorScriptExecution.addParameter("-d");
            TargetEnvironment.DownloadRoot skeletonsDownloadRoot = new TargetEnvironment.DownloadRoot(Paths.get(this.skeletonsPaths, new String[0]), (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), null, 4, null);
            ((Collection)PyTargetsSkeletonGenerator.this.getTargetEnvRequest().getDownloadVolumes()).add(skeletonsDownloadRoot);
            TargetEnvironmentRequest targetEnvironmentRequest = PyTargetsSkeletonGenerator.this.getTargetEnvRequest();
            VolumeCopyingRequest volumeCopyingRequest = targetEnvironmentRequest instanceof VolumeCopyingRequest ? (VolumeCopyingRequest)targetEnvironmentRequest : null;
            if (volumeCopyingRequest != null) {
                volumeCopyingRequest.setShouldCopyVolumes(true);
            }
            generatorScriptExecution.addParameter(TargetEnvironmentFunctions.getTargetDownloadPath((TargetEnvironment.DownloadRoot)skeletonsDownloadRoot));
            List list = this.myAssemblyRefs;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"myAssemblyRefs");
            if (!((Collection)list).isEmpty()) {
                generatorScriptExecution.addParameter("-c");
                List list2 = this.myAssemblyRefs;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myAssemblyRefs");
                generatorScriptExecution.addParameter(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)";", null, null, (int)0, null, null, (int)62, null));
            }
            List list3 = this.myExtraSysPath;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"myExtraSysPath");
            if (!((Collection)list3).isEmpty()) {
                generatorScriptExecution.addParameter("-s");
                char pathSeparatorOnTarget = ((PyTargetsSkeletonGenerator)PyTargetsSkeletonGenerator.this).getTargetEnvRequest().getTargetPlatform().getPlatform().pathSeparator;
                List list4 = this.myExtraSysPath;
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"myExtraSysPath");
                generatorScriptExecution.addParameter(CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)String.valueOf(pathSeparatorOnTarget), null, null, (int)0, null, null, (int)62, null));
            }
            for (Object extraArg : this.myExtraArgs) {
                Intrinsics.checkNotNull((Object)extraArg);
                generatorScriptExecution.addParameter((String)extraArg);
            }
            Object pathSeparatorOnTarget = this.myTargetModuleName;
            if (!(pathSeparatorOnTarget == null || pathSeparatorOnTarget.length() == 0)) {
                String string = this.myTargetModuleName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myTargetModuleName");
                generatorScriptExecution.addParameter(string);
                pathSeparatorOnTarget = this.myTargetModulePath;
                if (!(pathSeparatorOnTarget == null || pathSeparatorOnTarget.length() == 0)) {
                    String string2 = this.myTargetModulePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myTargetModulePath");
                    generatorScriptExecution.addParameter(string2);
                }
            }
            if (!PyTargetsSkeletonGenerator.this.isLocalTarget()) {
                Object extraArg;
                Path path2 = Paths.get(PyTargetsSkeletonGenerator.this.getSkeletonsPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                extraArg = path2;
                Path path3 = extraArg.resolve(".state.json");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                Path existingStateFile = path3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(existingStateFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    Path localRootPath = Files.createTempDirectory("generator3", new FileAttribute[0]);
                    if (Files.getFileStore(localRootPath).supportsFileAttributeView("posix")) {
                        Intrinsics.checkNotNull((Object)localRootPath);
                        Path path4 = localRootPath;
                        Set<PosixFilePermission> set = PosixFilePermissions.fromString("rwxr-xr-x");
                        Intrinsics.checkNotNullExpressionValue(set, (String)"fromString(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions(path4, set), (String)"setPosixFilePermissions(...)");
                    }
                    Intrinsics.checkNotNull((Object)localRootPath);
                    TargetEnvironment.UploadRoot stateFileUploadRoot = new TargetEnvironment.UploadRoot(localRootPath, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
                    ((Collection)PyTargetsSkeletonGenerator.this.getTargetEnvRequest().getUploadVolumes()).add(stateFileUploadRoot);
                    Path path5 = stateFileUploadRoot.getLocalRootPath().resolve(".state.json");
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
                    Files.copy(existingStateFile, path5, new CopyOption[0]);
                    generatorScriptExecution.addParameter("--state-file");
                    generatorScriptExecution.addParameter(TargetEnvironmentFunctions.getRelativeTargetPath((Function)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)stateFileUploadRoot), (String)".state.json"));
                } else {
                    generatorScriptExecution.addParameter("--init-state-file");
                }
            }
            generatorScriptExecution.addEnvironmentVariable("PYTHONDONTWRITEBYTECODE", "1");
            TargetEnvironmentRequest targetEnvironmentRequest2 = PyTargetsSkeletonGenerator.this.getTargetEnvRequest();
            TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"EMPTY");
            TargetEnvironment targetEnvironment2 = targetEnvironmentRequest2.prepareEnvironment(targetProgressIndicator);
            try {
                Iterable $this$forEach$iv = targetEnvironment2.getUploadVolumes().values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TargetEnvironment.UploadableVolume it = (TargetEnvironment.UploadableVolume)element$iv;
                    boolean bl = false;
                    TargetProgressIndicator targetProgressIndicator2 = TargetProgressIndicator.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator2, (String)"EMPTY");
                    it.upload(".", targetProgressIndicator2);
                }
                TargetedCommandLine targetedCommandLine = PythonScripts.buildTargetedCommandLine$default(generatorScriptExecution, targetEnvironment2, this.sdk, CollectionsKt.emptyList(), false, 8, null);
                Process process2 = targetEnvironment2.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
                String commandPresentation = targetedCommandLine.getCommandPresentation(targetEnvironment2);
                CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(process2, targetedCommandLine.getCharset(), commandPresentation);
                LineWiseProcessOutputListener lineWiseProcessOutputListener = listener2;
                if (lineWiseProcessOutputListener != null) {
                    LineWiseProcessOutputListener it = lineWiseProcessOutputListener;
                    boolean bl = false;
                    capturingProcessHandler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter(it));
                }
                ProcessOutput processOutput = capturingProcessHandler.runProcess();
                Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
                ProcessOutput result2 = processOutput;
                Iterable $this$forEach$iv2 = targetEnvironment2.getDownloadVolumes().values();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    TargetEnvironment.DownloadableVolume it = (TargetEnvironment.DownloadableVolume)element$iv;
                    boolean bl = false;
                    it.download(".", (ProgressIndicator)new EmptyProgressIndicator());
                }
                ProcessOutput processOutput2 = result2;
                return processOutput2;
            }
            finally {
                targetEnvironment2.shutdown();
            }
        }
    }
}

