/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.bugzilla;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.bugzilla.BugzillaTask;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import org.apache.xmlrpc.CommonsXmlRpcTransport;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcTransport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Bugzilla")
public class BugzillaRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(BugzillaRepository.class);
    private Version myVersion;
    private boolean myAuthenticated;
    private String myAuthenticationToken;
    private String myProductName = "";
    private String myComponentName = "";

    public BugzillaRepository() {
    }

    public BugzillaRepository(TaskRepositoryType type) {
        super(type);
        this.setUseHttpAuthentication(false);
        this.setUrl("http://myserver.com/xmlrpc.cgi");
    }

    public BugzillaRepository(BugzillaRepository other) {
        super(other);
        this.myProductName = other.myProductName;
        this.myComponentName = other.myComponentName;
    }

    @Override
    @NotNull
    public BaseRepository clone() {
        return new BugzillaRepository(this);
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator cancelled) throws Exception {
        if (cancelled == null) {
            BugzillaRepository.$$$reportNull$$$0(0);
        }
        Hashtable response = (Hashtable)this.createIssueSearchRequest(query, offset, limit, withClosed).execute();
        Vector bugs = (Vector)response.get("bugs");
        return (Task[])ContainerUtil.map2Array((Collection)bugs, BugzillaTask.class, hashTable -> new BugzillaTask((Hashtable<String, Object>)hashTable, this));
    }

    private BugzillaXmlRpcRequest createIssueSearchRequest(String query, int offset, int limit, boolean withClosed) throws Exception {
        return new BugzillaXmlRpcRequest("Bug.search").requireAuthentication(true).withParameter("summary", StringUtil.isNotEmpty((String)query) ? BugzillaRepository.newVector(query.split("\\s+")) : null).withParameter("product", StringUtil.nullize((String)this.myProductName)).withParameter("component", StringUtil.nullize((String)this.myComponentName)).withParameter("offset", offset).withParameter("limit", limit).withParameter("assigned_to", this.getUsername()).withParameter("resolution", !withClosed ? "" : null);
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        Hashtable<String, Object> table;
        if (id == null) {
            BugzillaRepository.$$$reportNull$$$0(1);
        }
        return (table = this.findBugInfoById(id)) != null ? new BugzillaTask(table, this) : null;
    }

    @Nullable
    private Hashtable<String, Object> findBugInfoById(@NotNull String id) throws Exception {
        Hashtable response;
        if (id == null) {
            BugzillaRepository.$$$reportNull$$$0(2);
        }
        try {
            response = (Hashtable)new BugzillaXmlRpcRequest("Bug.get").requireAuthentication(true).withParameter("ids", BugzillaRepository.newVector(id)).execute();
        }
        catch (XmlRpcException e) {
            if (e.code == 101 && e.getMessage().contains("does not exist")) {
                return null;
            }
            throw e;
        }
        Vector bugs = (Vector)response.get("bugs");
        if (bugs == null || bugs.isEmpty()) {
            return null;
        }
        return (Hashtable)bugs.get(0);
    }

    private void ensureVersionDiscovered() throws Exception {
        if (this.myVersion == null) {
            Hashtable result = (Hashtable)new BugzillaXmlRpcRequest("Bugzilla.version").execute();
            if (result == null) {
                throw new RequestFailedException(TaskBundle.message((String)"bugzilla.failure.no.version", (Object[])new Object[0]));
            }
            String version = (String)result.get("version");
            String[] parts = version.split("\\.", 3);
            this.myVersion = new Version(Integer.parseInt(parts[0]), parts.length > 1 ? Integer.parseInt(parts[1]) : 0, parts.length > 2 ? Integer.parseInt(parts[2]) : 0);
            if (this.myVersion.lessThan(Integer.valueOf(3), Integer.valueOf(4))) {
                throw new RequestFailedException("Bugzilla before 3.4 is not supported");
            }
        }
    }

    private void ensureUserAuthenticated() throws Exception {
        this.ensureVersionDiscovered();
        if (!this.myAuthenticated) {
            Hashtable response = (Hashtable)new BugzillaXmlRpcRequest("User.login").withParameter("login", this.getUsername()).withParameter("password", this.getPassword()).execute();
            this.myAuthenticated = true;
            this.myAuthenticationToken = (String)response.get("token");
        }
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        if (task == null) {
            BugzillaRepository.$$$reportNull$$$0(3);
        }
        if (state == null) {
            BugzillaRepository.$$$reportNull$$$0(4);
        }
        BugzillaXmlRpcRequest request = new BugzillaXmlRpcRequest("Bug.update").requireAuthentication(true).withParameter("ids", BugzillaRepository.newVector(task.getId()));
        if (state.getId().contains(":")) {
            String[] parts = state.getId().split(":", 2);
            request.withParameter("status", parts[0]).withParameter("resolution", parts[1]);
        } else {
            request.withParameter("status", state.getId());
        }
        request.execute();
    }

    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        class Status {
            final boolean isOpen;
            final String name;
            final Iterable<String> canChangeTo;

            Status(BugzillaRepository this$0, String name, boolean isOpen, Iterable<String> canChangeTo) {
                this.isOpen = isOpen;
                this.name = name;
                this.canChangeTo = canChangeTo;
            }
        }
        Status status;
        if (task == null) {
            BugzillaRepository.$$$reportNull$$$0(5);
        }
        Hashtable response = (Hashtable)new BugzillaXmlRpcRequest("Bug.fields").withParameter("names", BugzillaRepository.newVector("bug_status", "resolution")).requireAuthentication(true).execute();
        Vector fields = (Vector)response.get("fields");
        Hashtable statusesInfo = (Hashtable)fields.get(0);
        Hashtable resolutionsInfo = (Hashtable)fields.get(1);
        List<String> resolutions = BugzillaRepository.extractNotEmptyNames((Vector)resolutionsInfo.get("values"));
        HashMap<String, Status> statuses = new HashMap<String, Status>();
        for (Hashtable statusInfo : (Vector)statusesInfo.get("values")) {
            String name = (String)statusInfo.get("name");
            if (StringUtil.isEmpty((String)name)) continue;
            List<String> targetStateNames = BugzillaRepository.extractNotEmptyNames((Vector)statusInfo.get("can_change_to"));
            statuses.put(name, new Status(this, name, (Boolean)statusInfo.get("is_open"), targetStateNames));
        }
        String currentState = this.getCustomStateName(task);
        if (currentState != null && (status = (Status)statuses.get(currentState)) != null) {
            HashSet<CustomTaskState> result = new HashSet<CustomTaskState>();
            for (String targetStatusName : status.canChangeTo) {
                Status targetStatus = (Status)statuses.get(targetStatusName);
                if (targetStatus == null) continue;
                if (targetStatus.isOpen) {
                    result.add(new CustomTaskState(targetStatusName, targetStatusName));
                    continue;
                }
                for (String resolution : resolutions) {
                    result.add(new CustomTaskState(targetStatusName + ":" + resolution, targetStatusName + " (" + resolution + ")"));
                }
            }
            HashSet<CustomTaskState> hashSet = result;
            if (hashSet == null) {
                BugzillaRepository.$$$reportNull$$$0(6);
            }
            return hashSet;
        }
        Set<CustomTaskState> set = Collections.emptySet();
        if (set == null) {
            BugzillaRepository.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Nullable
    private String getCustomStateName(@NotNull Task task) throws Exception {
        Hashtable<String, Object> found;
        if (task == null) {
            BugzillaRepository.$$$reportNull$$$0(8);
        }
        return (found = this.findBugInfoById(task.getId())) != null ? (String)found.get("status") : null;
    }

    @NotNull
    private static List<String> extractNotEmptyNames(@NotNull Vector<Hashtable<String, ?>> vector) {
        if (vector == null) {
            BugzillaRepository.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.mapNotNull(vector, table -> StringUtil.nullize((String)((String)table.get("name"))));
        if (list == null) {
            BugzillaRepository.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            BugzillaRepository.$$$reportNull$$$0(11);
        }
        if (timeSpent == null) {
            BugzillaRepository.$$$reportNull$$$0(12);
        }
        if (comment == null) {
            BugzillaRepository.$$$reportNull$$$0(13);
        }
        LOG.debug(String.format("Last post: %s, time spent from last: %s, time spent: %s", task.getLastPost(), task.getTimeSpentFromLastPost(), timeSpent));
        Matcher matcher = TIME_SPENT_PATTERN.matcher(timeSpent);
        if (matcher.find()) {
            int hours = Integer.parseInt(matcher.group(1));
            int minutes = Integer.parseInt(matcher.group(2));
            BugzillaXmlRpcRequest request = new BugzillaXmlRpcRequest("Bug.update").requireAuthentication(true).withParameter("ids", BugzillaRepository.newVector(task.getId())).withParameter("work_time", (double)hours + (double)minutes / 60.0);
            if (!StringUtil.isEmptyOrSpaces((String)comment)) {
                request.withParameter("comment", BugzillaRepository.newHashTable("body", comment, "is_private", false));
            }
            request.execute();
        } else {
            LOG.error("Illegal time spent format: " + timeSpent);
        }
    }

    @NotNull
    public Pair<List<String>, List<String>> fetchProductAndComponentNames() throws Exception {
        Hashtable productIdsResponse = (Hashtable)new BugzillaXmlRpcRequest("Product.get_selectable_products").requireAuthentication(true).execute();
        Hashtable productInfoResponse = (Hashtable)new BugzillaXmlRpcRequest("Product.get").requireAuthentication(true).withParameter("ids", productIdsResponse.get("ids")).execute();
        ArrayList<String> productNames = new ArrayList<String>();
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Hashtable info : (Vector)productInfoResponse.get("products")) {
            productNames.add((String)info.get("name"));
            if (this.myVersion == null || !this.myVersion.isOrGreaterThan(Integer.valueOf(4), Integer.valueOf(2))) continue;
            for (Hashtable component : (Vector)info.get("components")) {
                componentNames.add((String)component.get("name"));
            }
        }
        Pair pair = Pair.create(productNames, componentNames);
        if (pair == null) {
            BugzillaRepository.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            BugzillaXmlRpcRequest myRequest;

            protected void doTest() throws Exception {
                BugzillaRepository.this.myVersion = null;
                BugzillaRepository.this.myAuthenticated = false;
                BugzillaRepository.this.myAuthenticationToken = null;
                this.myRequest = BugzillaRepository.this.createIssueSearchRequest(null, 0, 1, true);
                this.myRequest.execute();
            }

            public void cancel() {
                this.myRequest.cancel();
            }
        };
    }

    private static <T> Vector<T> newVector(T ... elements) {
        return new Vector<T>(Arrays.asList(elements));
    }

    private static <K, V> Hashtable<K, V> newHashTable(Object ... pairs) {
        assert (pairs.length % 2 == 0);
        Hashtable<Object, Object> table = new Hashtable<Object, Object>();
        for (int i = 0; i < pairs.length; i += 2) {
            if (pairs[i + 1] == null) continue;
            table.put(pairs[i], pairs[i + 1]);
        }
        return table;
    }

    @Override
    @Nullable
    public String extractId(@NotNull String taskName) {
        String id;
        if (taskName == null) {
            BugzillaRepository.$$$reportNull$$$0(15);
        }
        return (id = taskName.trim()).matches("\\d+") ? id : null;
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.getUsername()) && StringUtil.isNotEmpty((String)this.getPassword());
    }

    protected int getFeatures() {
        int features = super.getFeatures();
        if (this.myVersion != null && this.myVersion.isOrGreaterThan(Integer.valueOf(4), Integer.valueOf(0))) {
            return features | 8 | 4;
        }
        return features;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof BugzillaRepository)) {
            return false;
        }
        BugzillaRepository repository = (BugzillaRepository)((Object)o);
        if (!Objects.equals(this.myProductName, repository.getProductName())) {
            return false;
        }
        return Objects.equals(this.myComponentName, repository.getComponentName());
    }

    @NotNull
    public String getProductName() {
        String string = this.myProductName;
        if (string == null) {
            BugzillaRepository.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void setProductName(@NotNull String productName) {
        if (productName == null) {
            BugzillaRepository.$$$reportNull$$$0(17);
        }
        this.myProductName = productName;
    }

    @NotNull
    public String getComponentName() {
        String string = this.myComponentName;
        if (string == null) {
            BugzillaRepository.$$$reportNull$$$0(18);
        }
        return string;
    }

    public void setComponentName(@NotNull String componentName) {
        if (componentName == null) {
            BugzillaRepository.$$$reportNull$$$0(19);
        }
        this.myComponentName = componentName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 14, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/bugzilla/BugzillaRepository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vector";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/bugzilla/BugzillaRepository";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNotEmptyNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchProductAndComponentNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findBugInfoById";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCustomStateName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractNotEmptyNames";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setProductName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setComponentName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 14, 16, 18 -> new IllegalStateException(string);
        };
    }

    private class BugzillaXmlRpcRequest {
        private final String myMethodName;
        private boolean myRequireAuthentication;
        private final HashMap<String, Object> myParameters;
        private final Transport myTransport;

        BugzillaXmlRpcRequest(String methodName) throws MalformedURLException {
            if (methodName == null) {
                BugzillaXmlRpcRequest.$$$reportNull$$$0(0);
            }
            this.myParameters = new HashMap();
            this.myMethodName = methodName;
            this.myTransport = new Transport(this);
        }

        public BugzillaXmlRpcRequest withParameter(@NotNull String name, @Nullable Object value) {
            if (name == null) {
                BugzillaXmlRpcRequest.$$$reportNull$$$0(1);
            }
            if (value != null) {
                this.myParameters.put(name, value);
            }
            return this;
        }

        public BugzillaXmlRpcRequest requireAuthentication(boolean require) {
            this.myRequireAuthentication = require;
            return this;
        }

        public void cancel() {
            this.myTransport.cancel();
        }

        public <T> T execute() throws Exception {
            if (this.myRequireAuthentication) {
                BugzillaRepository.this.ensureUserAuthenticated();
                if (BugzillaRepository.this.myVersion.isOrGreaterThan(Integer.valueOf(4), Integer.valueOf(4)) && BugzillaRepository.this.myAuthenticationToken != null) {
                    this.myParameters.put("Bugzilla_token", BugzillaRepository.this.myAuthenticationToken);
                }
            }
            Vector<Hashtable<String, Object>> parameters = new Vector<Hashtable<String, Object>>();
            parameters.add(new Hashtable<String, Object>(this.myParameters));
            try {
                return (T)new XmlRpcClient(BugzillaRepository.this.getUrl()).execute((XmlRpcClientRequest)new XmlRpcRequest(this.myMethodName, parameters), (XmlRpcTransport)this.myTransport);
            }
            catch (XmlRpcClientException e) {
                if (e.getMessage().equals("Error decoding XML-RPC response")) {
                    throw new RequestFailedException(TaskBundle.message((String)"bugzilla.failure.malformed.response", (Object[])new Object[0]), (Throwable)e);
                }
                throw e;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/tasks/bugzilla/BugzillaRepository$BugzillaXmlRpcRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class Transport
        extends CommonsXmlRpcTransport {
            Transport(BugzillaXmlRpcRequest bugzillaXmlRpcRequest) throws MalformedURLException {
                super(new URL(bugzillaXmlRpcRequest.BugzillaRepository.this.getUrl()), bugzillaXmlRpcRequest.BugzillaRepository.this.getHttpClient());
            }

            public void cancel() {
                this.method.abort();
            }
        }
    }
}

