/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.ui;

import com.intellij.dataspell.jupyter.customCells.JupyterCustomCellsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterChangeListener;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterEvent;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.NotebookChanged;
import com.intellij.notebooks.ui.SteadyUIPanel;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.core.api.psi.NotebookCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001cH$J\n\u0010 \u001a\u0004\u0018\u00010!H$J\b\u0010\"\u001a\u00020#H$J\b\u0010$\u001a\u00020%H$J\b\u0010&\u001a\u00020\u0016H\u0004J\b\u0010'\u001a\u00020\u001cH\u0004J\b\u0010(\u001a\u00020\u001cH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020%H\u0004J\b\u0010,\u001a\u00020\u001cH\u0002J\b\u0010-\u001a\u00020\u001cH\u0002J\n\u0010.\u001a\u0004\u0018\u00010/H\u0004J\n\u00100\u001a\u0004\u0018\u000101H\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/ui/JupyterVariableCellToolbarPanelBase;", "Lcom/intellij/notebooks/ui/SteadyUIPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "cellType", "Lorg/jetbrains/plugins/notebooks/psi/core/api/psi/NotebookCellType;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCell;Lorg/jetbrains/plugins/notebooks/psi/core/api/psi/NotebookCellType;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "getCellType", "()Lorg/jetbrains/plugins/notebooks/psi/core/api/psi/NotebookCellType;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "infoLabel", "Ljavax/swing/JLabel;", "getInfoLabel", "()Ljavax/swing/JLabel;", "setInfoLabel", "(Ljavax/swing/JLabel;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "initializeMetadata", "getMetadata", "", "isNewVariableCell", "", "buildMainPanel", "Ljavax/swing/JComponent;", "createInfoLabel", "disableInfoLabelIfCellQueued", "onCellChanged", "createWrapperPanel", "Ljavax/swing/JPanel;", "detailsPanel", "setCellSource", "setupChangeListener", "getNotebookCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "getIntervalPointer", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "intellij.dataspell.jupyter.customCells"})
@SourceDebugExtension(value={"SMAP\nJupyterVariableCellToolbarPanelBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVariableCellToolbarPanelBase.kt\ncom/intellij/dataspell/jupyter/customCells/ui/JupyterVariableCellToolbarPanelBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public abstract class JupyterVariableCellToolbarPanelBase
extends SteadyUIPanel
implements UiDataProvider {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final NotebookCellType cellType;
    @NotNull
    private final JupyterNotebook notebook;
    protected JLabel infoLabel;

    public JupyterVariableCellToolbarPanelBase(@NotNull EditorImpl editor, @NotNull EditorCell cell, @NotNull NotebookCellType cellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        super(new PanelUI(){});
        this.editor = editor;
        this.cell = cell;
        this.cellType = cellType;
        this.notebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)((Editor)this.editor)).getNotebook();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.initializeMetadata();
        this.setCellSource();
        this.createInfoLabel();
        JComponent detailsPanel = this.buildMainPanel();
        JPanel wrapperPanel = this.createWrapperPanel(detailsPanel);
        if (this.isNewVariableCell()) {
            SwingUtilities.invokeLater(() -> JupyterVariableCellToolbarPanelBase._init_$lambda$0(this, detailsPanel));
        }
        this.add(wrapperPanel, "Center");
        this.setupChangeListener();
    }

    @NotNull
    protected final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    protected final EditorCell getCell() {
        return this.cell;
    }

    @NotNull
    protected final NotebookCellType getCellType() {
        return this.cellType;
    }

    @NotNull
    protected final JupyterNotebook getNotebook() {
        return this.notebook;
    }

    @NotNull
    protected final JLabel getInfoLabel() {
        JLabel jLabel = this.infoLabel;
        if (jLabel != null) {
            return jLabel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"infoLabel");
        return null;
    }

    protected final void setInfoLabel(@NotNull JLabel jLabel) {
        Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
        this.infoLabel = jLabel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = CommonDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        sink.setNull(dataKey);
        DataKey dataKey2 = CommonDataKeys.HOST_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"HOST_EDITOR");
        sink.setNull(dataKey2);
        DataKey dataKey3 = InjectedDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"EDITOR");
        sink.setNull(dataKey3);
    }

    protected abstract void initializeMetadata();

    @Nullable
    protected abstract Object getMetadata();

    protected abstract boolean isNewVariableCell();

    @NotNull
    protected abstract JComponent buildMainPanel();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final JLabel createInfoLabel() {
        void $this$createInfoLabel_u24lambda_u240;
        JBLabel jBLabel;
        JBLabel jBLabel2 = jBLabel = new JBLabel(JupyterCustomCellsBundle.message("variable.cell.cell.updated.info.label", new Object[0]), AllIcons.General.Information, 10);
        JupyterVariableCellToolbarPanelBase jupyterVariableCellToolbarPanelBase = this;
        boolean bl = false;
        $this$createInfoLabel_u24lambda_u240.setOpaque(false);
        $this$createInfoLabel_u24lambda_u240.setForeground(UIUtil.getLabelForeground());
        $this$createInfoLabel_u24lambda_u240.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        jupyterVariableCellToolbarPanelBase.setInfoLabel((JLabel)jBLabel);
        return this.getInfoLabel();
    }

    protected final void disableInfoLabelIfCellQueued() {
        if (((EditorCell.ExecutionStatus)this.cell.getExecutionStatus().get()).getStatus() == ProgressStatus.QUEUED) {
            this.getInfoLabel().setVisible(false);
        }
    }

    public void onCellChanged() {
        this.disableInfoLabelIfCellQueued();
    }

    @NotNull
    protected final JPanel createWrapperPanel(@NotNull JComponent detailsPanel) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)detailsPanel, (String)"detailsPanel");
        JPanel $this$createWrapperPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createWrapperPanel_u24lambda_u240.setOpaque(false);
        $this$createWrapperPanel_u24lambda_u240.add((Component)detailsPanel, "Center");
        if (!(detailsPanel instanceof JupyterVariableCellToolbarPanelBase)) {
            JPanel jPanel2;
            JPanel $this$createWrapperPanel_u24lambda_u240_u240 = jPanel2 = new JPanel(new BorderLayout());
            boolean bl2 = false;
            $this$createWrapperPanel_u24lambda_u240_u240.setOpaque(false);
            $this$createWrapperPanel_u24lambda_u240_u240.add((Component)this.getInfoLabel(), "North");
            JPanel infoLabelPanel = jPanel2;
            $this$createWrapperPanel_u24lambda_u240.add((Component)infoLabelPanel, "East");
        }
        return jPanel;
    }

    private final void setCellSource() {
        JupyterCell notebookCell = this.notebook.getCell(this.cell.getInterval().getOrdinal());
        notebookCell.setSource(JupyterCustomCellsBundle.message("jupyter.custom.cell.variable.cell.source", new Object[0]));
    }

    private final void setupChangeListener() {
        JupyterChangeListener listener = arg_0 -> JupyterVariableCellToolbarPanelBase.setupChangeListener$lambda$0(this, arg_0);
        this.notebook.getListeners().getChangeListeners().addListener((EventListener)listener, (Disposable)this.cell);
    }

    @Nullable
    protected final JupyterCell getNotebookCell() {
        JupyterCell jupyterCell;
        NotebookCellLines.Interval interval = this.getIntervalPointer();
        if (interval != null) {
            int it = interval.getOrdinal();
            boolean bl = false;
            jupyterCell = this.notebook.getCell(it);
        } else {
            jupyterCell = null;
        }
        return jupyterCell;
    }

    @Nullable
    protected final NotebookCellLines.Interval getIntervalPointer() {
        return this.cell.getIntervalPointer().get();
    }

    private static final void _init_$lambda$0(JupyterVariableCellToolbarPanelBase this$0, JComponent $detailsPanel) {
        IdeFocusManager.getInstance((Project)this$0.editor.getProject()).requestFocus((Component)$detailsPanel, true);
    }

    private static final void setupChangeListener$lambda$0(JupyterVariableCellToolbarPanelBase this$0, JupyterEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof NotebookChanged)) {
            return;
        }
        if (this$0.getIntervalPointer() == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> JupyterVariableCellToolbarPanelBase.setupChangeListener$lambda$0$0(this$0));
    }

    private static final void setupChangeListener$lambda$0$0(JupyterVariableCellToolbarPanelBase this$0) {
        this$0.onCellChanged();
    }
}

