/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.visualization;

import com.intellij.dataspell.jupyter.customCells.visualization.JupyterVisualizationInputNamePopup;
import com.intellij.dataspell.jupyter.customCells.visualization.JupyterVisualizationInputVariableName;
import com.intellij.dataspell.jupyter.customCells.visualization.VisualizationCellMetadataKt;
import com.intellij.dataspell.jupyter.customCells.visualization.VisualizationCellService;
import com.intellij.dataspell.jupyter.customCells.visualization.actions.OpenAiChatAction;
import com.intellij.dataspell.jupyter.customCells.visualization.letsPlot.LetsPlotEDAViewer;
import com.intellij.ide.DataManager;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/visualization/JupyterLetsPlotCellToolbarInlayController;", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "currentViewer", "Lcom/intellij/dataspell/jupyter/customCells/visualization/letsPlot/LetsPlotEDAViewer;", "prevMetadata", "", "rebuildIfNeeded", "", "buildLetsPlotPanel", "Ljavax/swing/JComponent;", "addPopup", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "notebookCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "createActionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionEvent", "Ljava/awt/event/ActionEvent;", "component", "intellij.dataspell.jupyter.customCells.visualization"})
@SourceDebugExtension(value={"SMAP\nJupyterVisualizationCellToolbarInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVisualizationCellToolbarInlayController.kt\ncom/intellij/dataspell/jupyter/customCells/visualization/JupyterLetsPlotCellToolbarInlayController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n1#2:133\n30#3,2:134\n*S KotlinDebug\n*F\n+ 1 JupyterVisualizationCellToolbarInlayController.kt\ncom/intellij/dataspell/jupyter/customCells/visualization/JupyterLetsPlotCellToolbarInlayController\n*L\n114#1:134,2\n*E\n"})
public final class JupyterLetsPlotCellToolbarInlayController
extends NonOpaquePanel {
    @NotNull
    private final Editor editor;
    @NotNull
    private final EditorCell cell;
    @Nullable
    private LetsPlotEDAViewer currentViewer;
    @Nullable
    private String prevMetadata;

    public JupyterLetsPlotCellToolbarInlayController(@NotNull Editor editor, @NotNull EditorCell cell) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            super((LayoutManager)new BorderLayout());
            this.editor = editor;
            this.cell = cell;
            JupyterNotebook notebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)this.editor).getNotebook();
            JupyterCell notebookCell = notebook.getCell(this.cell.getInterval().getOrdinal());
            this.prevMetadata = VisualizationCellMetadataKt.getVisualizationMetadataOrDefault(notebookCell).getVegaSpec();
            this.addPopup(notebook, notebookCell);
            JComponent jComponent = this.buildLetsPlotPanel();
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            this.add(it, "Center");
        }
    }

    @NotNull
    public final EditorCell getCell() {
        return this.cell;
    }

    public final void rebuildIfNeeded(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterNotebook notebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor).getNotebook();
        JupyterCell notebookCell = notebook.getCell(this.cell.getInterval().getOrdinal());
        if (Intrinsics.areEqual((Object)VisualizationCellMetadataKt.getVisualizationMetadataOrDefault(notebookCell).getVegaSpec(), (Object)this.prevMetadata)) {
            return;
        }
        this.prevMetadata = VisualizationCellMetadataKt.getVisualizationMetadataOrDefault(notebookCell).getVegaSpec();
        this.removeAll();
        this.addPopup(notebook, notebookCell);
        JComponent jComponent = this.buildLetsPlotPanel();
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            this.add(it, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    @Nullable
    public final JComponent buildLetsPlotPanel() {
        LetsPlotEDAViewer lpedaViewer;
        JupyterNotebook notebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)this.editor).getNotebook();
        JupyterCell notebookCell = notebook.getCell(this.cell.getInterval().getOrdinal());
        String string = VisualizationCellMetadataKt.getVisualizationMetadataOrDefault(notebookCell).getVegaSpec();
        if (string == null) {
            return null;
        }
        String vegaSpecContent = string;
        this.currentViewer = lpedaViewer = new LetsPlotEDAViewer((Disposable)this.cell);
        lpedaViewer.setJsonStringSpecification(vegaSpecContent);
        return lpedaViewer;
    }

    private final void addPopup(JupyterNotebook notebook, JupyterCell notebookCell) {
        NonOpaquePanel nonOpaquePanel;
        JupyterVisualizationInputVariableName inputVariableName = new JupyterVisualizationInputVariableName(notebookCell, notebook.getLanguage());
        Object[] objectArray = new AnAction[]{new JupyterVisualizationInputNamePopup(this.editor, this.cell, inputVariableName, JupyterVisualizationInputVariableName.Companion.getNameGenerator())};
        List actions = CollectionsKt.mutableListOf((Object[])objectArray);
        AnAction anAction = ActionManager.getInstance().getAction("VisualizationCellToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        DefaultActionGroup actionGroup = (DefaultActionGroup)anAction;
        Collection collection = actions;
        AnAction[] anActionArray = actionGroup.getChildren(ActionManager.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
        CollectionsKt.addAll((Collection)collection, (Object[])anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorTab", (ActionGroup)new DefaultActionGroup(actions), true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.getComponent().setOpaque(false);
        toolbar.getComponent().setCursor(Cursor.getPredefinedCursor(0));
        toolbar.getComponent().setBorder(null);
        toolbar.setTargetComponent(this.editor.getContentComponent());
        this.add(toolbar.getComponent(), "North");
        NonOpaquePanel $this$addPopup_u24lambda_u240 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new FlowLayout(0, JBUIScale.scale((int)4), 4));
        boolean bl = false;
        $this$addPopup_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        NonOpaquePanel panel2 = nonOpaquePanel;
        Project project = this.editor.getProject();
        if (project != null) {
            Project project2 = project;
            boolean bl2 = false;
            OpenAiChatAction openAiChatAction = (OpenAiChatAction)CollectionsKt.firstOrNull((List)OpenAiChatAction.Companion.getEP().getExtensionList());
            if (openAiChatAction != null) {
                OpenAiChatAction action = openAiChatAction;
                boolean bl3 = false;
                panel2.add((Component)new ActionLink(action.getName(), arg_0 -> JupyterLetsPlotCellToolbarInlayController.addPopup$lambda$1$0$0(this, toolbar, action, project2, arg_0)));
            }
        }
        this.add((Component)panel2, "Center");
    }

    private final AnActionEvent createActionEvent(ActionEvent actionEvent, JComponent component) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Object object = actionEvent.getSource();
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext2, (Presentation)new Presentation(), (String)"unknown", (ActionUiKind)ActionUiKind.NONE, (InputEvent)(object instanceof InputEvent ? (InputEvent)object : null));
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        return anActionEvent;
    }

    private static final Unit addPopup$lambda$1$0$0(JupyterLetsPlotCellToolbarInlayController this$0, ActionToolbar $toolbar, OpenAiChatAction $action, Project $project, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        JComponent jComponent = $toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        AnActionEvent anActionEvent = this$0.createActionEvent(actionEvent, jComponent);
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<VisualizationCellService> serviceClass$iv = VisualizationCellService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope coroutineScope = ((VisualizationCellService)object).getCoroutineScope();
        JComponent jComponent2 = $toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        $action.perform(anActionEvent, coroutineScope, jComponent2);
        return Unit.INSTANCE;
    }
}

