/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.GreaterPredicateOperation;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LessPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.MultiPredicateValue;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.ObjectPredicateValue;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.mongo.MongoPredicatesHelperKt;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J-\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010\u0015\u001a\u00020 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001e0\"\u00a2\u0006\u0002\b#H\u0002JP\u0010$\u001a\u0004\u0018\u00010\u00102\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0015\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010*\u001a\u00020\u0018H\u0014J\"\u0010+\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020,2\u0006\u0010%\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J&\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J2\u0010/\u001a\u00020.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001c012\u0006\u00102\u001a\u00020\u00182\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002040\"H\u0002J$\u00105\u001a\u0004\u0018\u00010'2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/mongo/MongoPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "objectFormatter", "Lcom/intellij/database/extractors/DbObjectFormatter;", "idPattern", "Lkotlin/text/Regex;", "uuidPattern", "mode", "Lcom/intellij/database/extractors/ObjectFormatterMode;", "getMode", "()Lcom/intellij/database/extractors/ObjectFormatterMode;", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "operation", "", "Lcom/intellij/database/util/DdlBuilder;", "Lcom/intellij/database/data/types/PredicateOperation;", "rightOperand", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "likePredicate", "columnRef", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "literal", "Lcom/intellij/database/data/types/StringPredicateValue;", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "typeWithConstructor", "classNames", "", "isQuotedValue", "testUnwrapped", "Lcom/intellij/database/data/types/FormatTestResult;", "getDomain", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoPredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoPredicatesHelper.kt\ncom/intellij/database/dialects/mongo/MongoPredicatesHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n1761#3,3:181\n*S KotlinDebug\n*F\n+ 1 MongoPredicatesHelper.kt\ncom/intellij/database/dialects/mongo/MongoPredicatesHelper\n*L\n165#1:181,3\n*E\n"})
public final class MongoPredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final DbObjectFormatter objectFormatter;
    @NotNull
    private final Regex idPattern;
    @NotNull
    private final Regex uuidPattern;
    @NotNull
    private final ObjectFormatterMode mode;

    public MongoPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.objectFormatter = new DbObjectFormatter(dbms);
        this.idPattern = new Regex("[0-9a-f]{24}", RegexOption.IGNORE_CASE);
        this.uuidPattern = new Regex("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", RegexOption.IGNORE_CASE);
        this.mode = ObjectFormatterMode.JS_SCRIPT;
    }

    @NotNull
    public ObjectFormatterMode getMode() {
        return this.mode;
    }

    @NotNull
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column), value, (PredicateOperation)op, arg_0 -> MongoPredicatesHelper.equalsPredicate$lambda$0(column, this, op, value, quote, version, arg_0));
    }

    private final void operation(DdlBuilder $this$operation, PredicateOperation op, Function1<? super DdlBuilder, Unit> rightOperand) {
        Ref.ObjectRef rightOperand2 = new Ref.ObjectRef();
        rightOperand2.element = rightOperand;
        if (op instanceof EqualsPredicateOperation) {
            ((Function1)rightOperand2.element).invoke((Object)$this$operation);
        } else {
            Object object;
            PredicateOperation predicateOperation = op;
            if (predicateOperation instanceof NotEqualsPredicateOperation) {
                object = "$ne";
            } else if (predicateOperation instanceof LessPredicateOperation) {
                object = "$lt";
            } else if (predicateOperation instanceof GreaterPredicateOperation) {
                object = "$gt";
            } else if (predicateOperation instanceof LikePredicateOperation) {
                if (((LikePredicateOperation)op).isNotLike()) {
                    Function1 operand = (Function1)rightOperand2.element;
                    rightOperand2.element = arg_0 -> MongoPredicatesHelper.operation$lambda$0(this, op, operand, arg_0);
                    object = "$ne";
                } else {
                    object = "$regex";
                }
            } else {
                object = "unknown_operation_" + op;
            }
            String operator = object;
            MongoScriptUtilKt.inCurly$default($this$operation, false, false, () -> MongoPredicatesHelper.operation$lambda$1(rightOperand2, $this$operation, operator), 3, null);
        }
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder) || op.getLikeType() == LikeOpType.MATCHES) {
            return null;
        }
        Domain domain2 = domain;
        if (!(domain2 != null ? domain2.supports(OperationKt.LIKE_OPERATION) : false)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (PredicateOperation)op, arg_0 -> MongoPredicatesHelper.likePredicate$lambda$0(columnRef, this, op, value, arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String literal(StringPredicateValue value, ColumnRef columnRef, Version version) {
        String string;
        String string2;
        Domain domain;
        String str = value.getStr();
        Domain domain2 = domain = this.getDomain(columnRef, (PredicateValue)value, version);
        String string3 = string2 = domain2 != null ? domain2.simpleName() : null;
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case -1480407629: {
                    if (!string2.equals("ISODate")) break;
                    n = 1;
                    break;
                }
                case 155139290: {
                    if (!string2.equals("ObjectId")) break;
                    n = 2;
                    break;
                }
                case 1555471665: {
                    if (!string2.equals("BinData")) break;
                    n = 3;
                    break;
                }
                case 9271654: {
                    if (!string2.equals("Decimal128")) break;
                    n = 4;
                    break;
                }
                case 2616251: {
                    if (!string2.equals("UUID")) break;
                    n = 5;
                    break;
                }
                case -1984193210: {
                    if (!string2.equals("decimal128")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    string = "new ObjectId(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case 1: {
                    string = "new ISODate(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case 4: {
                    string = "new NumberDecimal(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case 5: {
                    string = "new UUID(\"" + str + "\")";
                    return string;
                }
                case 3: {
                    string = "new BinData(\"" + str + "\")";
                    return string;
                }
            }
        }
        string = "\"" + StringUtil.escapeStringCharacters((String)str) + "\"";
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        if (domain2 == null) return null;
        String string = domain2.simpleName();
        String string2 = string;
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 63537721: {
                if (string2.equals("Array")) {
                    n = 1;
                }
                break;
            }
            case -1480407629: {
                if (string2.equals("ISODate")) {
                    n = 2;
                }
                break;
            }
            case -1850931927: {
                if (string2.equals("Regexp")) {
                    n = 3;
                }
                break;
            }
            case 70807245: {
                if (string2.equals("Int64")) {
                    n = 4;
                }
                break;
            }
            case 155139290: {
                if (string2.equals("ObjectId")) {
                    n = 5;
                }
                break;
            }
            case 70807150: {
                if (string2.equals("Int32")) {
                    n = 4;
                }
                break;
            }
            case 1555471665: {
                if (string2.equals("BinData")) {
                    n = 6;
                }
                break;
            }
            case -1939501217: {
                if (string2.equals("Object")) {
                    n = 1;
                }
                break;
            }
            case 9271654: {
                if (string2.equals("Decimal128")) {
                    n = 7;
                }
                break;
            }
            case 2616251: {
                if (string2.equals("UUID")) {
                    n = 8;
                }
                break;
            }
            case 1729365000: {
                if (string2.equals("Boolean")) {
                    n = 9;
                }
                break;
            }
            case 2059094262: {
                if (string2.equals("Timestamp")) {
                    n = 10;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                FormatTester formatTester2 = new FormatTester(false, false, MongoPredicatesHelper::getFormatTester$lambda$0, 2, null);
                return formatTester2;
            }
            case 7: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"NumberDecimal"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)MongoPredicatesHelper::getFormatTester$lambda$1));
                return formatTester2;
            }
            case 4: {
                Object[] objectArray = new String[]{"NumberLong", "NumberInt"};
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object[])objectArray), false, (Function1<? super String, ? extends FormatTestResult>)((Function1)MongoPredicatesHelper::getFormatTester$lambda$2));
                return formatTester2;
            }
            case 5: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"ObjectId"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)arg_0 -> MongoPredicatesHelper.getFormatTester$lambda$3(this, arg_0)));
                return formatTester2;
            }
            case 8: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"UUID"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)arg_0 -> MongoPredicatesHelper.getFormatTester$lambda$4(this, arg_0)));
                return formatTester2;
            }
            case 6: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"BinData"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)MongoPredicatesHelper::getFormatTester$lambda$5));
                return formatTester2;
            }
            case 9: {
                FormatTester formatTester2 = new FormatTester(false, false, MongoPredicatesHelper::getFormatTester$lambda$6, 2, null);
                return formatTester2;
            }
            case 1: {
                FormatTester formatTester2 = new FormatTester(false, false, MongoPredicatesHelper::getFormatTester$lambda$7, 2, null);
                return formatTester2;
            }
            case 10: {
                FormatTester formatTester2 = new FormatTester(false, false, MongoPredicatesHelper::getFormatTester$lambda$8, 2, null);
                return formatTester2;
            }
            case 2: {
                List list = CollectionsKt.listOf((Object)"ISODate");
                FormatTester formatTester = PredicatesUtilKt.getFormatTester((ColumnRef)columnRef, (Dbms)this.getDbms(), (LogicalType)LogicalType.TIMESTAMP);
                Intrinsics.checkNotNull((Object)formatTester);
                FormatTester formatTester2 = this.typeWithConstructor(list, true, (Function1<? super String, ? extends FormatTestResult>)formatTester.getTest());
                return formatTester2;
            }
            default: {
                return null;
            }
        }
    }

    private final FormatTester typeWithConstructor(List<String> classNames, boolean isQuotedValue, Function1<? super String, ? extends FormatTestResult> testUnwrapped) {
        return new FormatTester(isQuotedValue, false, arg_0 -> MongoPredicatesHelper.typeWithConstructor$lambda$0(classNames, testUnwrapped, arg_0), 2, null);
    }

    @Nullable
    protected Domain getDomain(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Version version) {
        Domain domain;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof ObjectPredicateValue) {
            Object v2;
            block3: {
                String string = MongoJdbcHelper.getTypeName((Object)((ObjectPredicateValue)value).getO());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
                String typeName = string;
                Collection collection = BaseDomainRegistry.get((Dbms)this.getDbms(), (Version)version).getDomains();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDomains(...)");
                Iterable iterable = collection;
                for (Object t : iterable) {
                    Domain it = (Domain)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.simpleName(), (Object)typeName)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            domain = v2;
        } else {
            domain = super.getDomain(columnRef, value, version);
        }
        return domain;
    }

    private static final Unit equalsPredicate$lambda$0(ColumnRef $column, MongoPredicatesHelper this$0, ComparePredicateOperation $op, PredicateValue $value, boolean $quote, Version $version, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)$column).symbol(":").space();
        this$0.operation(builder, (PredicateOperation)$op, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> MongoPredicatesHelper.equalsPredicate$lambda$0$0($value, $quote, this$0, $column, $version, builder, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit equalsPredicate$lambda$0$0(PredicateValue $value, boolean $quote, MongoPredicatesHelper this$0, ColumnRef $column, Version $version, DdlBuilder $builder, DdlBuilder $this$operation) {
        Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$this$operation");
        PredicateValue predicateValue = $value;
        if (Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) {
            v0 = $this$operation.literal("null");
        } else if (Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) {
            v0 = $this$operation.plain("$placeholder$");
        } else if (predicateValue instanceof CustomPlaceholder) {
            v0 = $this$operation.plain(((CustomPlaceholder)$value).getPlaceholder());
        } else if (predicateValue instanceof StringPredicateValue) {
            v0 = $this$operation.literal($quote ? this$0.literal((StringPredicateValue)$value, $column, $version) : ((StringPredicateValue)$value).getStr());
        } else if (predicateValue instanceof ObjectPredicateValue) {
            String literal = this$0.objectFormatter.objectToString(((ObjectPredicateValue)$value).getO(), PredicatesUtilKt.toGridColumn((ColumnRef)$column), DatabaseObjectFormatterConfig.get((ObjectFormatterMode)ObjectFormatterMode.JS_SCRIPT));
            v0 = literal == null ? $builder.plain("null") : ($quote ? $builder.plain(DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(literal, this$0.getDbms())) : $builder.plain(literal));
        } else if (predicateValue instanceof MultiPredicateValue) {
            v0 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit operation$lambda$0(MongoPredicatesHelper this$0, PredicateOperation $op, Function1 $operand, DdlBuilder ddlBuilder) {
        Intrinsics.checkNotNullParameter((Object)ddlBuilder, (String)"<this>");
        this$0.operation(ddlBuilder, (PredicateOperation)new LikePredicateOperation(((LikePredicateOperation)$op).getLikeType(), ((LikePredicateOperation)$op).getMatchCase(), false), (Function1<? super DdlBuilder, Unit>)$operand);
        return Unit.INSTANCE;
    }

    private static final Unit operation$lambda$1(Ref.ObjectRef $rightOperand, DdlBuilder $this_operation, String $operator) {
        Function1 function1 = (Function1)$rightOperand.element;
        DdlBuilder ddlBuilder = $this_operation.plain($operator).symbol(":").space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        function1.invoke((Object)ddlBuilder);
        return Unit.INSTANCE;
    }

    private static final Unit likePredicate$lambda$0(ColumnRef $columnRef, MongoPredicatesHelper this$0, LikePredicateOperation $op, PredicateValue $value, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)$columnRef).symbol(":").space();
        this$0.operation(builder, (PredicateOperation)$op, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> MongoPredicatesHelper.likePredicate$lambda$0$0($value, $op, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit likePredicate$lambda$0$0(PredicateValue $value, LikePredicateOperation $op, MongoPredicatesHelper this$0, DdlBuilder $this$operation) {
        Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$this$operation");
        PredicateValue predicateValue = $value;
        Object object = Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE) ? $this$operation.plain("$placeholder$") : (predicateValue instanceof CustomPlaceholder ? $this$operation.plain(((CustomPlaceholder)$value).getPlaceholder()) : (predicateValue instanceof StringPredicateValue ? $this$operation.literal($op.getLikeType().getDecorator().decorate(((StringPredicateValue)$value).getStr(), this$0.getDbms())) : Unit.INSTANCE));
        return Unit.INSTANCE;
    }

    private static final FormatTestResult getFormatTester$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MongoPredicatesHelperKt.access$getREGEX_PATTERN$p().matches((CharSequence)it) ? FormatTestResult.NOT_QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NumberUtils.isCreatable((String)it) || StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)"nan") || StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)"infinity") || StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)"-infinity") ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NumberUtils.isCreatable((String)it) ? FormatTestResult.NOT_QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$3(MongoPredicatesHelper this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.idPattern.matches((CharSequence)it) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$4(MongoPredicatesHelper this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.uuidPattern.matches((CharSequence)it) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)"false") ? FormatTestResult.NOT_QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JsonUtilKt.isJsonString((String)it) ? FormatTestResult.NOT_QUOTE : (NumberUtils.isCreatable((String)it) ? FormatTestResult.NOT_QUOTE : (StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)"false") ? FormatTestResult.NOT_QUOTE : FormatTestResult.QUOTE));
    }

    private static final FormatTestResult getFormatTester$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.endsWith$default((String)it, (String)")", (boolean)false, (int)2, null) && (StringsKt.startsWith$default((String)it, (String)"new Timestamp(", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"Timestamp(", (boolean)false, (int)2, null)) ? FormatTestResult.NOT_QUOTE : FormatTestResult.NOT_MATCHED;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final FormatTestResult typeWithConstructor$lambda$0(List $classNames, Function1 $testUnwrapped, String it) {
        FormatTestResult formatTestResult;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (StringsKt.endsWith$default((String)it, (String)")", (boolean)false, (int)2, null)) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = $classNames;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String name2 = (String)element$iv;
                        boolean bl2 = false;
                        if (!(StringsKt.startsWith$default((String)it, (String)(name2 + "("), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)("new " + name2 + "("), (boolean)false, (int)2, null))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                formatTestResult = FormatTestResult.NOT_QUOTE;
                return formatTestResult;
            }
        }
        formatTestResult = (FormatTestResult)$testUnwrapped.invoke((Object)it);
        return formatTestResult;
    }
}

