/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class MongoJSStringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private int[] outSourceOffsets;

    public MongoJSStringLiteralEscaper(T host) {
        super(host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            MongoJSStringLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            MongoJSStringLiteralEscaper.$$$reportNull$$$0(1);
        }
        String subText = rangeInsideHost.substring(this.myHost.getText());
        Ref sourceOffsetsRef = new Ref();
        boolean result = MongoJSStringLiteralEscaper.parseStringCharacters(subText, outChars, (Ref<int[]>)sourceOffsetsRef, this.isRegExpLiteral(), !this.isOneLine());
        this.outSourceOffsets = (int[])sourceOffsetsRef.get();
        return result;
    }

    protected abstract boolean isRegExpLiteral();

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            MongoJSStringLiteralEscaper.$$$reportNull$$$0(2);
        }
        int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return Math.min(result, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    public static boolean parseStringCharacters(String chars, StringBuilder outChars, Ref<int[]> sourceOffsetsRef, boolean regExp, boolean escapeBacktick) {
        int[] sourceOffsets = new int[chars.length() + 1];
        sourceOffsetsRef.set((Object)sourceOffsets);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            for (int i = 0; i < sourceOffsets.length; ++i) {
                sourceOffsets[i] = i;
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            sourceOffsets[outChars.length() - outOffset] = index - 1;
            sourceOffsets[outChars.length() + 1 - outOffset] = index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            if (escapeBacktick && c == '`') {
                outChars.append(c);
            } else if (regExp) {
                if (c != '/') {
                    outChars.append('\\');
                }
                outChars.append(c);
            } else {
                switch (c) {
                    case 'b': {
                        outChars.append('\b');
                        break;
                    }
                    case 't': {
                        outChars.append('\t');
                        break;
                    }
                    case 'n': {
                        outChars.append('\n');
                        break;
                    }
                    case 'f': {
                        outChars.append('\f');
                        break;
                    }
                    case 'r': {
                        outChars.append('\r');
                        break;
                    }
                    case '\"': {
                        outChars.append('\"');
                        break;
                    }
                    case '/': {
                        outChars.append('/');
                        break;
                    }
                    case '\n': {
                        outChars.append('\n');
                        break;
                    }
                    case '\'': {
                        outChars.append('\'');
                        break;
                    }
                    case '\\': {
                        outChars.append('\\');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char startC = c;
                        int v2 = c - 48;
                        if (index < chars.length()) {
                            if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                v2 <<= 3;
                                v2 += c - 48;
                                if (startC <= '3' && index < chars.length()) {
                                    if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                        v2 <<= 3;
                                        v2 += c - 48;
                                    }
                                }
                            } else {
                                --index;
                            }
                        }
                        outChars.append((char)v2);
                        break;
                    }
                    case 'x': {
                        int v;
                        if (index + 2 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index, index + 2), 16);
                                outChars.append((char)v);
                                index += 2;
                                break;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    case 'u': {
                        int v;
                        int v2;
                        if (index + 3 <= chars.length() && chars.charAt(index) == '{') {
                            int end = chars.indexOf(125, index + 1);
                            if (end < 0) {
                                return false;
                            }
                            try {
                                v2 = Integer.parseInt(chars.substring(index + 1, end), 16);
                                c = chars.charAt(index + 1);
                                if (c == '+' || c == '-') {
                                    return false;
                                }
                                outChars.appendCodePoint(v2);
                                index = end + 1;
                                break;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        if (index + 4 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index, index + 4), 16);
                                c = chars.charAt(index);
                                if (c == '+' || c == '-') {
                                    return false;
                                }
                                outChars.append((char)v);
                                index += 4;
                                break;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    default: {
                        outChars.append(c);
                    }
                }
            }
            sourceOffsets[outChars.length() - outOffset] = --index;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/mongo/js/MongoJSStringLiteralEscaper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetInHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

