/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.popup;

import com.intellij.diagram.DiagramProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UmlElementsListCellRenderer
extends JPanel
implements ListCellRenderer {
    private final DiagramProvider myUmlProvider;

    protected UmlElementsListCellRenderer(DiagramProvider umlProvider) {
        super(new BorderLayout());
        this.myUmlProvider = umlProvider;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        DefaultListCellRenderer rightRenderer = UmlElementsListCellRenderer.getRightCellRenderer(value);
        Component leftCellRendererComponent = new LeftRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (rightRenderer != null) {
            Component rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            rightCellRendererComponent.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : leftCellRendererComponent.getBackground());
            this.add(rightCellRendererComponent, "East");
            JPanel spacer = new JPanel();
            spacer.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
            spacer.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : leftCellRendererComponent.getBackground());
            this.add((Component)spacer, "Center");
        }
        this.add(leftCellRendererComponent, "West");
        this.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : leftCellRendererComponent.getBackground());
        return this;
    }

    @Nullable
    protected static DefaultListCellRenderer getRightCellRenderer(Object value) {
        if (UISettings.getInstance().getShowIconInQuickNavigation()) {
            return ModuleRendererFactory.findInstance((Object)value).getModuleRenderer();
        }
        return null;
    }

    @Nls
    public String getElementText(Object element) {
        String text = this.myUmlProvider.getElementManager().getElementTitle(element);
        return text == null ? "" : text;
    }

    @Iconable.IconFlags
    protected abstract int getIconFlags();

    protected Icon getIcon(PsiElement element) {
        return element.getIcon(this.getIconFlags());
    }

    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.getText(o1).compareTo(this.getText(o2));
            }

            private String getText(Object element) {
                return UmlElementsListCellRenderer.this.getElementText(element);
            }
        };
    }

    private class LeftRenderer
    extends ColoredListCellRenderer {
        LeftRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                LeftRenderer.$$$reportNull$$$0(0);
            }
            Color bgColor = UIUtil.getListBackground();
            if (value instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                VirtualFile vFile;
                PsiElement element = (PsiElement)value;
                String name = UmlElementsListCellRenderer.this.getElementText(value);
                Color color = list.getForeground();
                PsiFile psiFile = element.getContainingFile();
                boolean isProblemFile = false;
                if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                    if (WolfTheProblemSolver.getInstance((Project)psiFile.getProject()).isProblemFile(vFile)) {
                        isProblemFile = true;
                    }
                    FileStatus status = FileStatusManager.getInstance((Project)psiFile.getProject()).getStatus(vFile);
                    color = status.getColor();
                    FileColorManager colorManager = FileColorManager.getInstance((Project)psiFile.getProject());
                    if (psiFile.isValid()) {
                        Color fileBgColor = colorManager.getRendererBackground(psiFile);
                        bgColor = fileBgColor == null ? bgColor : fileBgColor;
                    }
                }
                TextAttributes attributes = null;
                if (value instanceof NavigationItem) {
                    TextAttributesKey attributesKey = null;
                    ItemPresentation presentation = ((NavigationItem)value).getPresentation();
                    if (presentation instanceof ColoredItemPresentation) {
                        attributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
                    }
                    if (attributesKey != null) {
                        attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
                    }
                }
                if (isProblemFile) {
                    attributes = TextAttributes.merge((TextAttributes)new TextAttributes(color, null, (Color)JBColor.red, EffectType.WAVE_UNDERSCORE, 0), attributes);
                }
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes(attributes) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                assert (name != null) : "Null name for PSI element " + String.valueOf(element);
                this.append(name, nameAttributes);
                this.setIcon(UmlElementsListCellRenderer.this.getIcon(element));
            } else {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value == null ? "" : value.toString(), new SimpleTextAttributes(0, list.getForeground()));
            }
            this.setPaintFocusBorder(false);
            this.setBackground(selected ? UIUtil.getListSelectionBackground((boolean)true) : bgColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/uml/core/actions/popup/UmlElementsListCellRenderer$LeftRenderer", "customizeCellRenderer"));
        }
    }
}

