/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.chooser.importProgress.ImportProgressPage;
import com.intellij.ide.startup.importSettings.chooser.productChooser.ProductChooserPage;
import com.intellij.ide.startup.importSettings.chooser.settingChooser.SettingChooserPage;
import com.intellij.ide.startup.importSettings.chooser.ui.BaseControllerImpl;
import com.intellij.ide.startup.importSettings.chooser.ui.ImportSettingsController;
import com.intellij.ide.startup.importSettings.chooser.ui.ImportSettingsControllerKt;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingDialog;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingPage;
import com.intellij.ide.startup.importSettings.chooser.ui.SettingsImportOrigin;
import com.intellij.ide.startup.importSettings.data.ActionsDataProvider;
import com.intellij.ide.startup.importSettings.data.BaseService;
import com.intellij.ide.startup.importSettings.data.DataForSave;
import com.intellij.ide.startup.importSettings.data.DataToApply;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.NotificationData;
import com.intellij.ide.startup.importSettings.data.PluginService;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.data.StartupWizardService;
import com.intellij.ide.startup.importSettings.statistics.ImportSettingsEventsCollector;
import com.intellij.ide.startup.importSettings.wizard.pluginChooser.WizardPluginsPage;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.OnboardingBackgroundImageProvider;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\f\u001a\u00020\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J2\u0010\u001e\u001a\u00020\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsControllerImpl;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsController;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/BaseControllerImpl;", "dialog", "Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;", "skipImportAction", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;Lkotlin/jvm/functions/Function0;)V", "getSkipImportAction", "()Lkotlin/jvm/functions/Function0;", "goToSettingsPage", "provider", "Lcom/intellij/ide/startup/importSettings/data/ActionsDataProvider;", "product", "Lcom/intellij/ide/startup/importSettings/data/Product;", "goToProductChooserPage", "canShowFeaturedPluginsPage", "", "origin", "Lcom/intellij/ide/startup/importSettings/chooser/ui/SettingsImportOrigin;", "shouldShowFeaturedPluginsPage", "productId", "", "dataForSave", "", "Lcom/intellij/ide/startup/importSettings/data/DataForSave;", "productService", "Lcom/intellij/ide/startup/importSettings/data/BaseService;", "goToFeaturedPluginsPage", "goToProgressPage", "importFromProduct", "Lcom/intellij/ide/startup/importSettings/data/DialogImportData;", "dataToApply", "Lcom/intellij/ide/startup/importSettings/data/DataToApply;", "skipImport", "configChosen", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nImportSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportSettingsController.kt\ncom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsControllerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1761#2,3:167\n*S KotlinDebug\n*F\n+ 1 ImportSettingsController.kt\ncom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsControllerImpl\n*L\n106#1:167,3\n*E\n"})
final class ImportSettingsControllerImpl
extends BaseControllerImpl
implements ImportSettingsController {
    @NotNull
    private final Function0<Unit> skipImportAction;

    public ImportSettingsControllerImpl(@NotNull OnboardingDialog dialog2, @NotNull Function0<Unit> skipImportAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        Intrinsics.checkNotNullParameter(skipImportAction, (String)"skipImportAction");
        super(dialog2);
        this.skipImportAction = skipImportAction;
        SettingsService settService = SettingsService.Companion.getInstance();
        settService.getDoClose().advise(this.getLifetime(), arg_0 -> ImportSettingsControllerImpl._init_$lambda$0(dialog2, arg_0));
        InterfacesKt.viewNotNull((IViewable)((IViewable)settService.getNotification()), (Lifetime)this.getLifetime(), (arg_0, arg_1) -> ImportSettingsControllerImpl._init_$lambda$1(dialog2, arg_0, arg_1));
    }

    @Override
    @NotNull
    public Function0<Unit> getSkipImportAction() {
        return this.skipImportAction;
    }

    @Override
    public void goToSettingsPage(@NotNull ActionsDataProvider<?> provider, @NotNull Product product) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        OnboardingPage page = SettingChooserPage.Companion.createPage$intellij_ide_startup_importSettings(provider, product, this);
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page);
        provider.productSelected(product);
        this.getDialog().changePage(page);
    }

    @Override
    public void goToProductChooserPage() {
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        boolean isDark = uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.isDark() : true;
        ProductChooserPage page = new ProductChooserPage(this, OnboardingBackgroundImageProvider.Companion.getInstance().getImage(isDark));
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page);
        ImportSettingsEventsCollector.INSTANCE.productPageShown();
        this.getDialog().changePage(page);
    }

    @Override
    public boolean canShowFeaturedPluginsPage(@NotNull SettingsImportOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)((Object)origin), (String)"origin");
        return switch (WhenMappings.$EnumSwitchMapping$0[origin.ordinal()]) {
            case 1, 2 -> {
                if (StartupWizardService.Companion.getInstance() != null) {
                    yield true;
                }
                yield false;
            }
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean shouldShowFeaturedPluginsPage(@NotNull String productId, @NotNull List<DataForSave> dataForSave, @NotNull BaseService productService) {
        boolean bl;
        Object pluginService;
        block5: {
            Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
            Intrinsics.checkNotNullParameter(dataForSave, (String)"dataForSave");
            Intrinsics.checkNotNullParameter((Object)productService, (String)"productService");
            Object object = StartupWizardService.Companion.getInstance();
            if (object == null || (object = object.getPluginService()) == null) {
                ImportSettingsControllerImpl $this$shouldShowFeaturedPluginsPage_u24lambda_u240 = this;
                boolean bl2 = false;
                ImportSettingsControllerKt.access$getLogger$p().info("No wizard service registered, not going to show the featured plugins page.");
                return false;
            }
            pluginService = object;
            Iterable $this$any$iv = dataForSave;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataForSave it = (DataForSave)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"plugins")) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean installPlugins2 = bl;
        List<String> pluginIdsMarkedForInstallation = installPlugins2 ? productService.getImportablePluginIds(productId) : CollectionsKt.emptyList();
        ImportSettingsControllerKt.access$getLogger$p().info(pluginIdsMarkedForInstallation.size() + " plugins marked for installation so far.");
        if (!pluginService.shouldShowPage(pluginIdsMarkedForInstallation)) {
            ImportSettingsControllerKt.access$getLogger$p().info("Plugin service reported that showing the featured plugin page is unnecessary.");
            return false;
        }
        ImportSettingsControllerKt.access$getLogger$p().info("Going to show the featured plugin installation page.");
        return true;
    }

    @Override
    public void goToFeaturedPluginsPage(@NotNull ActionsDataProvider<?> provider, @NotNull BaseService productService, @NotNull Product product, @NotNull List<DataForSave> dataForSave) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)productService, (String)"productService");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter(dataForSave, (String)"dataForSave");
        StartupWizardService startupWizardService = StartupWizardService.Companion.getInstance();
        if (startupWizardService == null) {
            throw new IllegalStateException("Cannot find the wizard service.".toString());
        }
        StartupWizardService wizardService = startupWizardService;
        PluginService pluginService = wizardService.getPluginService();
        WizardPluginsPage page = new WizardPluginsPage(this, pluginService, (Function0<Unit>)((Function0)() -> ImportSettingsControllerImpl.goToFeaturedPluginsPage$lambda$0(wizardService, this, provider, product)), (Function1<? super List<String>, Unit>)((Function1)arg_0 -> ImportSettingsControllerImpl.goToFeaturedPluginsPage$lambda$1(dataForSave, productService, product, this, arg_0)), ImportSettingsBundle.INSTANCE.message("onboarding.wizard.finish-button", new Object[0]));
        ImportSettingsEventsCollector.INSTANCE.featuredPluginsPageShown();
        wizardService.onEnter();
        this.getDialog().changePage(page);
    }

    @Override
    public void goToProgressPage(@NotNull DialogImportData importFromProduct, @NotNull DataToApply dataToApply) {
        Intrinsics.checkNotNullParameter((Object)importFromProduct, (String)"importFromProduct");
        Intrinsics.checkNotNullParameter((Object)dataToApply, (String)"dataToApply");
        String dialogTitleOverride = !((Collection)dataToApply.getFeaturedPluginIds()).isEmpty() ? ImportSettingsBundle.INSTANCE.message("onboarding.wizard.getting-ready", new Object[0]) : null;
        ImportProgressPage page = new ImportProgressPage(importFromProduct, this, dialogTitleOverride);
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page);
        ImportSettingsEventsCollector.INSTANCE.importProgressPageShown();
        this.getDialog().changePage(page);
    }

    @Override
    public void skipImport() {
        this.getDialog().dialogClose();
    }

    @Override
    public void configChosen() {
        SettingsService.Companion.getInstance().configChosen();
    }

    private static final Unit _init_$lambda$0(OnboardingDialog $dialog, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $dialog.dialogClose();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(OnboardingDialog $dialog, Lifetime lt, NotificationData it) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $dialog.showOverlay(it, lt);
        return Unit.INSTANCE;
    }

    private static final Unit goToFeaturedPluginsPage$lambda$0(StartupWizardService $wizardService, ImportSettingsControllerImpl this$0, ActionsDataProvider $provider, Product $product) {
        $wizardService.onExit();
        this$0.goToSettingsPage($provider, $product);
        return Unit.INSTANCE;
    }

    private static final Unit goToFeaturedPluginsPage$lambda$1(List $dataForSave, BaseService $productService, Product $product, ImportSettingsControllerImpl this$0, List featuredPluginIds) {
        Intrinsics.checkNotNullParameter((Object)featuredPluginIds, (String)"featuredPluginIds");
        DataToApply dataToApply = new DataToApply($dataForSave, featuredPluginIds);
        DialogImportData importSettings2 = $productService.importSettings($product.getId(), dataToApply);
        this$0.goToProgressPage(importSettings2, dataToApply);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SettingsImportOrigin.values().length];
            try {
                nArray[SettingsImportOrigin.ThirdPartyProduct.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsImportOrigin.JetBrainsProduct.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsImportOrigin.Sync.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

