/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.cell;

import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadata;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadataKt;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellSettings;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellTypeProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/cell/JupyterNotebookDataWranglerCellConverter;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookConverter;", "<init>", "()V", "convertAfterLoading", "", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "convertBeforeSave", "notebookCopy", "intellij.dataWrangler.jupyterPython"})
final class JupyterNotebookDataWranglerCellConverter
implements JupyterNotebookConverter {
    public void convertAfterLoading(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        if (!JupyterDataWranglerCellSettings.INSTANCE.isEnabled()) {
            return;
        }
        for (JupyterCell cell : notebook.computeCells()) {
            Object metadataSource;
            if (!Intrinsics.areEqual((Object)cell.getCellTypeProvider().getJupyterCellType(), (Object)JupyterCellType.Companion.getCODE()) || JupyterDataWranglerCellMetadataKt.getDataWranglerMetadata(cell) == null) continue;
            Object object = JupyterDataWranglerCellMetadataKt.getDataWranglerMetadata(cell);
            if (object == null || (object = ((JupyterDataWranglerCellMetadata)object).getSource()) == null) {
                object = "";
            }
            if (Intrinsics.areEqual((Object)(metadataSource = object), (Object)cell.getSource())) {
                cell.setCellTypeProvider(JupyterCellTypeProvider.Companion.providerByType(JupyterCellType.Companion.getDATA_WRANGLER()));
                continue;
            }
            JupyterDataWranglerCellMetadataKt.setDataWranglerMetadata(cell, null);
        }
    }

    public void convertBeforeSave(@NotNull JupyterNotebook notebookCopy) {
        Intrinsics.checkNotNullParameter((Object)notebookCopy, (String)"notebookCopy");
        if (!JupyterDataWranglerCellSettings.INSTANCE.isEnabled()) {
            return;
        }
        for (JupyterCell cell : notebookCopy.computeCells()) {
            if (!Intrinsics.areEqual((Object)cell.getCellTypeProvider().getJupyterCellType(), (Object)JupyterCellType.Companion.getDATA_WRANGLER())) continue;
            cell.setCellTypeProvider(JupyterCellTypeProvider.Companion.providerByType(JupyterCellType.Companion.getCODE()));
            JupyterDataWranglerCellMetadata metadata = JupyterDataWranglerCellMetadataKt.getDataWranglerMetadataOrDefault(cell);
            String string = metadata.getSource();
            if (string == null) {
                string = "";
            }
            cell.setSource(string);
        }
    }
}

