/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.diff.DiffContext;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.backend.split.DumbDiffContext;
import com.intellij.platform.vcs.backend.split.OneSideRemoteDiffViewer;
import com.intellij.platform.vcs.backend.split.TwoSideRemoteDiffViewer;
import com.intellij.platform.vcs.backend.split.VcsBackendSplitBundle;
import com.intellij.platform.vcs.backend.split.diff.BackendServerDiffManagerKt;
import com.intellij.platform.vcs.common.split.TextDiffSettingsExKt;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.diffViewer.DiffRequestChainEditorModel;
import com.jetbrains.rd.ide.model.diffViewer.DiffViewerContentModel;
import com.jetbrains.rd.ide.model.diffViewer.DiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.ErrorDiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.OneSideDiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.OneSideState;
import com.jetbrains.rd.ide.model.diffViewer.TwoSideDiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.TwoSideState;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\b\u0010\u001e\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/platform/vcs/backend/split/DiffRequestChainModelHandler;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "chain", "Lcom/intellij/diff/chains/DiffRequestChain;", "chainModel", "Lcom/jetbrains/rd/ide/model/diffViewer/DiffRequestChainEditorModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/diff/chains/DiffRequestChain;Lcom/jetbrains/rd/ide/model/diffViewer/DiffRequestChainEditorModel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getChainModel", "()Lcom/jetbrains/rd/ide/model/diffViewer/DiffRequestChainEditorModel;", "index", "", "context", "Lcom/intellij/platform/vcs/backend/split/DumbDiffContext;", "activeRequest", "Lcom/intellij/diff/requests/DiffRequest;", "pendingViewerState", "updateRequest", "", "navigateTo", "chainIndex", "viewerState", "updateViewerState", "Companion", "intellij.platform.vcs.backend.split"})
@SourceDebugExtension(value={"SMAP\nDiffRequestChainModelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffRequestChainModelHandler.kt\ncom/intellij/platform/vcs/backend/split/DiffRequestChainModelHandler\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n42#2,10:226\n13#3:236\n*S KotlinDebug\n*F\n+ 1 DiffRequestChainModelHandler.kt\ncom/intellij/platform/vcs/backend/split/DiffRequestChainModelHandler\n*L\n93#1:226,10\n136#1:236\n*E\n"})
public final class DiffRequestChainModelHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final DiffRequestChain chain;
    @NotNull
    private final DiffRequestChainEditorModel chainModel;
    private int index;
    @NotNull
    private final DumbDiffContext context;
    @Nullable
    private DiffRequest activeRequest;
    @Nullable
    private Object pendingViewerState;
    @NotNull
    private static final Logger LOG;

    public DiffRequestChainModelHandler(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull DiffRequestChain chain, @NotNull DiffRequestChainEditorModel chainModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)chainModel, (String)"chainModel");
        this.lifetime = lifetime;
        this.session = session;
        this.chain = chain;
        this.chainModel = chainModel;
        this.context = new DumbDiffContext(this.session.getProject(), this.chain);
        this.lifetime.onTermination(() -> DiffRequestChainModelHandler._init_$lambda$0(this));
        this.chainModel.getViewer().view(this.lifetime, (arg_0, arg_1) -> DiffRequestChainModelHandler._init_$lambda$1(this, arg_0, arg_1));
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.chainModel.getGoPrev()), null, null, arg_0 -> DiffRequestChainModelHandler._init_$lambda$2(this, arg_0), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.chainModel.getGoNext()), null, null, arg_0 -> DiffRequestChainModelHandler._init_$lambda$3(this, arg_0), (int)3, null);
        if (this.chain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.chain).addListener(() -> DiffRequestChainModelHandler._init_$lambda$4(this), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null));
            ((AsyncDiffRequestChain)this.chain).onAssigned(true);
            this.lifetime.onTermination(() -> DiffRequestChainModelHandler._init_$lambda$5(this));
        }
        this.index = this.chain.getIndex();
        this.chainModel.getIndex().set((Object)this.index);
        this.updateRequest();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final DiffRequestChainEditorModel getChainModel() {
        return this.chainModel;
    }

    private final void updateRequest() {
        ListSelection listSelection = ListSelection.createAt((List)this.chain.getRequests(), (int)this.index);
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"createAt(...)");
        ListSelection listSelection2 = listSelection;
        this.chainModel.getHasNext().set((Object)(this.index < listSelection2.getList().size() - 1 ? 1 : 0));
        this.chainModel.getHasPrev().set((Object)(this.index > 0 ? 1 : 0));
        this.chainModel.getIndex().set((Object)this.index);
        DiffRequestProducer selectedProducer = (DiffRequestProducer)listSelection2.getList().get(listSelection2.getSelectedIndex());
        String string = DiffBundle.message((String)"progress.title.loading.requests", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title$iv = string;
        Project project$iv = null;
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, title$iv, cancellable$iv, selectedProducer, this){
            final /* synthetic */ DiffRequestProducer $selectedProducer$inlined;
            final /* synthetic */ DiffRequestChainModelHandler this$0;
            {
                this.$selectedProducer$inlined = diffRequestProducer;
                this.this$0 = diffRequestChainModelHandler;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                DiffRequest diffRequest = this.$selectedProducer$inlined.process((UserDataHolder)DiffRequestChainModelHandler.access$getContext$p(this.this$0), indicator2);
                Intrinsics.checkNotNullExpressionValue((Object)diffRequest, (String)"process(...)");
                DiffRequest request = diffRequest;
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0, request){
                    final /* synthetic */ DiffRequestChainModelHandler this$0;
                    final /* synthetic */ DiffRequest $request;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                    }

                    public final void invoke() {
                        DiffViewerModel diffViewerModel;
                        DiffRequest diffRequest = DiffRequestChainModelHandler.access$getActiveRequest$p(this.this$0);
                        if (diffRequest != null) {
                            diffRequest.onAssigned(false);
                        }
                        DiffRequestChainModelHandler.access$setActiveRequest$p(this.this$0, this.$request);
                        DiffRequest diffRequest2 = DiffRequestChainModelHandler.access$getActiveRequest$p(this.this$0);
                        if (diffRequest2 != null) {
                            diffRequest2.onAssigned(true);
                        }
                        if ((diffViewerModel = com.intellij.platform.vcs.backend.split.DiffRequestChainModelHandler$Companion.access$createViewerModel(DiffRequestChainModelHandler.Companion, this.this$0.getSession(), DiffRequestChainModelHandler.access$getContext$p(this.this$0), this.$request)) == null) {
                            String string = DiffBundle.message((String)"error.message.cannot.show.diff", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            diffViewerModel = (DiffViewerModel)new ErrorDiffViewerModel(string);
                        }
                        DiffViewerModel viewerModel = diffViewerModel;
                        this.this$0.getChainModel().getViewer().set((Object)viewerModel);
                        IOptProperty iOptProperty = this.this$0.getChainModel().getName();
                        String string = this.$request.getTitle();
                        if (string == null) {
                            String string2 = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        }
                        iOptProperty.set((Object)BackendServerDiffManagerKt.getDiffEditorTabName(string));
                        DiffRequestChainModelHandler.access$updateViewerState(this.this$0);
                    }
                }), (int)1, null);
            }
        });
    }

    public final void navigateTo(int chainIndex, @Nullable Object viewerState) {
        this.pendingViewerState = viewerState;
        if (chainIndex != this.index) {
            this.index = chainIndex;
            this.updateRequest();
        } else {
            this.updateViewerState();
        }
    }

    private final void updateViewerState() {
        DiffViewerModel diffViewerModel = (DiffViewerModel)this.chainModel.getViewer().getValueOrNull();
        if (diffViewerModel == null) {
            return;
        }
        DiffViewerModel model = diffViewerModel;
        Object newState = this.pendingViewerState;
        this.pendingViewerState = null;
        if (model instanceof TwoSideDiffViewerModel && newState instanceof TwoSideState) {
            ((TwoSideDiffViewerModel)model).getState().set(newState);
        }
        if (model instanceof OneSideDiffViewerModel && newState instanceof OneSideState) {
            ((OneSideDiffViewerModel)model).getState().set(newState);
        }
    }

    private static final Unit _init_$lambda$0(DiffRequestChainModelHandler this$0) {
        DiffRequest diffRequest = this$0.activeRequest;
        if (diffRequest != null) {
            diffRequest.onAssigned(false);
        }
        this$0.activeRequest = null;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(DiffRequestChainModelHandler this$0, Lifetime viewerLifetime, DiffViewerModel viewerModel) {
        Intrinsics.checkNotNullParameter((Object)viewerLifetime, (String)"viewerLifetime");
        Intrinsics.checkNotNullParameter((Object)viewerModel, (String)"viewerModel");
        if (viewerModel instanceof OneSideDiffViewerModel) {
            new OneSideRemoteDiffViewer(this$0.session, viewerLifetime, (OneSideDiffViewerModel)viewerModel);
        }
        if (viewerModel instanceof TwoSideDiffViewerModel) {
            new TwoSideRemoteDiffViewer(this$0.session, viewerLifetime, (TwoSideDiffViewerModel)viewerModel);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(DiffRequestChainModelHandler this$0, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        this$0.index = Math.max(this$0.index - 1, 0);
        this$0.updateRequest();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(DiffRequestChainModelHandler this$0, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        this$0.index = Math.min(this$0.index + 1, this$0.chain.getRequests().size());
        this$0.updateRequest();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$4(DiffRequestChainModelHandler this$0) {
        this$0.index = ((AsyncDiffRequestChain)this$0.chain).getIndex();
        this$0.updateRequest();
    }

    private static final Unit _init_$lambda$5(DiffRequestChainModelHandler this$0) {
        ((AsyncDiffRequestChain)this$0.chain).onAssigned(false);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ DumbDiffContext access$getContext$p(DiffRequestChainModelHandler $this) {
        return $this.context;
    }

    public static final /* synthetic */ DiffRequest access$getActiveRequest$p(DiffRequestChainModelHandler $this) {
        return $this.activeRequest;
    }

    public static final /* synthetic */ void access$setActiveRequest$p(DiffRequestChainModelHandler $this, DiffRequest diffRequest) {
        $this.activeRequest = diffRequest;
    }

    public static final /* synthetic */ void access$updateViewerState(DiffRequestChainModelHandler $this) {
        $this.updateViewerState();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DiffRequestChainModelHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J/\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\r\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/vcs/backend/split/DiffRequestChainModelHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createViewerModel", "Lcom/jetbrains/rd/ide/model/diffViewer/DiffViewerModel;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "context", "Lcom/intellij/diff/DiffContext;", "request", "Lcom/intellij/diff/requests/DiffRequest;", "createDiffContentModel", "Lcom/jetbrains/rd/ide/model/diffViewer/DiffViewerContentModel;", "documentContent", "Lcom/intellij/diff/contents/DocumentContent;", "title", "", "Lorg/jetbrains/annotations/Nls;", "readOnly", "", "canOpenDocument", "content", "intellij.platform.vcs.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        private final DiffViewerModel createViewerModel(ClientProjectSession session, DiffContext context, DiffRequest request) {
            try {
                if (!(request instanceof ContentDiffRequest) || ((ContentDiffRequest)request).getContents().size() != 2) {
                    LOG.warn("Request is not supported by backend: " + request);
                    return null;
                }
                DiffContent content1 = (DiffContent)((ContentDiffRequest)request).getContents().get(0);
                DiffContent content2 = (DiffContent)((ContentDiffRequest)request).getContents().get(1);
                TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings((DiffContext)context);
                Intrinsics.checkNotNullExpressionValue((Object)textDiffSettings, (String)"getTextSettings(...)");
                TextDiffSettingsHolder.TextDiffSettings textSettings = textDiffSettings;
                boolean[] blArray = TextDiffViewerUtil.checkForceReadOnly((DiffContext)context, (ContentDiffRequest)((ContentDiffRequest)request));
                Intrinsics.checkNotNullExpressionValue((Object)blArray, (String)"checkForceReadOnly(...)");
                boolean[] readOnlyFlags = blArray;
                if (content1 instanceof DocumentContent && content2 instanceof DocumentContent) {
                    TwoSideDiffViewerModel twoSideDiffViewerModel;
                    if (!this.canOpenDocument(session, (DocumentContent)content1)) {
                        return (DiffViewerModel)new ErrorDiffViewerModel(VcsBackendSplitBundle.INSTANCE.message("diff.error.permission.cant.open.file", new Object[0]));
                    }
                    if (!this.canOpenDocument(session, (DocumentContent)content2)) {
                        return (DiffViewerModel)new ErrorDiffViewerModel(VcsBackendSplitBundle.INSTANCE.message("diff.error.permission.cant.open.file", new Object[0]));
                    }
                    DiffViewerContentModel contentModel1 = this.createDiffContentModel(session, (DocumentContent)content1, (String)((ContentDiffRequest)request).getContentTitles().get(0), readOnlyFlags[0]);
                    DiffViewerContentModel contentModel2 = this.createDiffContentModel(session, (DocumentContent)content2, (String)((ContentDiffRequest)request).getContentTitles().get(1), readOnlyFlags[1]);
                    TwoSideDiffViewerModel $this$createViewerModel_u24lambda_u240 = twoSideDiffViewerModel = new TwoSideDiffViewerModel(contentModel1, contentModel2);
                    boolean bl = false;
                    $this$createViewerModel_u24lambda_u240.getSettings().set((Object)TextDiffSettingsExKt.toRdModel((TextDiffSettingsHolder.TextDiffSettings)textSettings));
                    return (DiffViewerModel)twoSideDiffViewerModel;
                }
                if (content1 instanceof DocumentContent && content2 instanceof EmptyContent) {
                    if (!this.canOpenDocument(session, (DocumentContent)content1)) {
                        return (DiffViewerModel)new ErrorDiffViewerModel(VcsBackendSplitBundle.INSTANCE.message("diff.error.permission.cant.open.file", new Object[0]));
                    }
                    DiffViewerContentModel contentModel = this.createDiffContentModel(session, (DocumentContent)content1, (String)((ContentDiffRequest)request).getContentTitles().get(0), readOnlyFlags[0]);
                    return (DiffViewerModel)new OneSideDiffViewerModel(contentModel, true);
                }
                if (content1 instanceof EmptyContent && content2 instanceof DocumentContent) {
                    if (!this.canOpenDocument(session, (DocumentContent)content2)) {
                        return (DiffViewerModel)new ErrorDiffViewerModel(VcsBackendSplitBundle.INSTANCE.message("diff.error.permission.cant.open.file", new Object[0]));
                    }
                    DiffViewerContentModel contentModel = this.createDiffContentModel(session, (DocumentContent)content2, (String)((ContentDiffRequest)request).getContentTitles().get(1), readOnlyFlags[1]);
                    return (DiffViewerModel)new OneSideDiffViewerModel(contentModel, false);
                }
                LOG.warn("Request is not supported by backend: " + request);
                return null;
            }
            catch (Throwable e) {
                LOG.error(e);
                return null;
            }
        }

        private final DiffViewerContentModel createDiffContentModel(ClientProjectSession session, DocumentContent documentContent, String title, boolean readOnly) {
            Document document = documentContent.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            EditorEx editorEx = DiffUtil.createEditor((Document)document2, (Project)session.getProject(), (readOnly || !document2.isWritable() ? 1 : 0) != 0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
            EditorEx editor = editorEx;
            DiffUtil.configureEditor((EditorEx)editor, (DocumentContent)documentContent, (Project)session.getProject());
            TextControlId textControlId = BackendEditorHost.bindEditor$default((BackendEditorHost)BackendEditorHost.Companion.getInstance(session.getAppSession()), (Editor)((Editor)editor), (boolean)false, (int)2, null);
            return new DiffViewerContentModel(textControlId, title);
        }

        private final boolean canOpenDocument(ClientProjectSession session, DocumentContent content) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(content.getDocument());
            if (file == null) {
                return true;
            }
            return ClientPermissionManager.Companion.getInstance(session).isVisible(file);
        }

        public static final /* synthetic */ DiffViewerModel access$createViewerModel(Companion $this, ClientProjectSession session, DiffContext context, DiffRequest request) {
            return $this.createViewerModel(session, context, request);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

