/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRunLineMarkerProviderBase
extends RunLineMarkerContributor {
    @Nullable
    protected static RunLineMarkerContributor.Info createInfo(@NotNull PsiElement psiElement, @NotNull Icon icon, @NotNull BiFunction<? super PsiElement, AnAction[], String> tooltipProvider, final @NotNull @NotNull Function<? super @NotNull VirtualFile, AnAction[]> computeActionGroup) {
        VirtualFile vFile;
        if (psiElement == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(1);
        }
        if (tooltipProvider == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(2);
        }
        if (computeActionGroup == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(3);
        }
        if ((vFile = (VirtualFile)Optional.of(psiElement.getContainingFile()).map(PsiFile::getVirtualFile).orElse(null)) == null) {
            return null;
        }
        Function tooltip = e -> (String)tooltipProvider.apply((PsiElement)e, (AnAction[])computeActionGroup.fun((Object)vFile));
        return new RunLineMarkerContributor.Info(icon, tooltip, new AnAction[]{new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                AnAction[] actions;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((actions = (AnAction[])computeActionGroup.fun((Object)vFile)).length == 1) {
                    actions[0].actionPerformed(e);
                    return;
                }
                Optional.ofNullable(e.getInputEvent()).map(event -> (MouseEvent)ObjectUtils.tryCast((Object)event, MouseEvent.class)).ifPresent(mouseEvent -> {
                    ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, new ActionGroup(this){

                        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                            if (actions == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return actions;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerRunLineMarkerProviderBase$1$1", "getChildren"));
                        }
                    }, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                    popup.show(new RelativePoint(mouseEvent));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/DockerRunLineMarkerProviderBase$1", "actionPerformed"));
            }
        }});
    }

    protected static List<RemoteServer<DockerCloudConfiguration>> listAllDockerAccounts(@Nullable Project project) {
        return RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance()).stream().filter(server -> ((DockerCloudConfiguration)server.getConfiguration()).isVisibleInProject(project)).toList();
    }

    @Nls
    public static String getGenericTooltip() {
        return DockerBundle.message((String)"DockerRunLineMarkerProviderBase.tooltip", (Object[])new Object[0]);
    }

    protected static AnAction @Nullable [] combineActions(@NotNull List<? extends AnAction> existingRunConfigsActions, @NotNull List<? extends AnAction> newRunConfigActions) {
        if (existingRunConfigsActions == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(4);
        }
        if (newRunConfigActions == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(5);
        }
        if (existingRunConfigsActions.isEmpty() && newRunConfigActions.isEmpty()) {
            return null;
        }
        ArrayList<? extends AnAction> result2 = new ArrayList<AnAction>(existingRunConfigsActions);
        if (!existingRunConfigsActions.isEmpty() && !newRunConfigActions.isEmpty()) {
            result2.add((AnAction)new Separator());
        }
        result2.addAll(newRunConfigActions);
        return (AnAction[])result2.toArray(AnAction[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeActionGroup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingRunConfigsActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRunConfigActions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "combineActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

