/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.images;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.action.images.CreateContainerAction;
import com.intellij.docker.action.images.ImageActionBase;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/action/images/CreateContainerAction;", "Lcom/intellij/docker/action/images/ImageActionBase;", "<init>", "()V", "doPerformAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "runtime", "Lcom/intellij/docker/runtimes/DockerImageRuntime;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/docker/runtimes/DockerImageRuntime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Case", "intellij.clouds.docker"})
public final class CreateContainerAction
extends ImageActionBase {
    @Override
    @Nullable
    protected Object doPerformAction(@NotNull AnActionEvent e, @NotNull DockerImageRuntime runtime, @NotNull Continuation<? super Unit> $completion) {
        MouseEvent inputEvent;
        String theOnlyTag;
        Project project = e.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        Set<String> tags = runtime.getImageRepoTags();
        String string = theOnlyTag = tags.size() == 1 ? (String)CollectionsKt.firstOrNull((Iterable)tags) : null;
        if (Intrinsics.areEqual((Object)"<none>:<none>", (Object)theOnlyTag)) {
            theOnlyTag = null;
        }
        RemoteServer<DockerCloudConfiguration> server = runtime.getContext().getServer();
        ListPopup popup = new Case(project2, server, runtime.getId(), theOnlyTag).createPopup();
        InputEvent inputEvent2 = e.getInputEvent();
        MouseEvent mouseEvent = inputEvent = inputEvent2 instanceof MouseEvent ? (MouseEvent)inputEvent2 : null;
        if ((mouseEvent != null ? mouseEvent.getComponent() : null) instanceof ActionButton) {
            popup.show(new RelativePoint(inputEvent));
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/action/images/CreateContainerAction$Case;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "myImageId", "", "myOptionalImageTag", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/remoteServer/configuration/RemoteServer;Ljava/lang/String;Ljava/lang/String;)V", "myCloudType", "Lcom/intellij/docker/DockerCloudType;", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "createAndRunImageConfiguration", "", "isForTheSameServerAndImage", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isForTheSameImage", "configuration", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "Companion", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nCreateContainerAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateContainerAction.kt\ncom/intellij/docker/action/images/CreateContainerAction$Case\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n774#2:138\n865#2,2:139\n1563#2:141\n1634#2,3:142\n*S KotlinDebug\n*F\n+ 1 CreateContainerAction.kt\ncom/intellij/docker/action/images/CreateContainerAction$Case\n*L\n66#1:138\n66#1:139,2\n70#1:141\n70#1:142,3\n*E\n"})
    private static final class Case {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Project myProject;
        @NotNull
        private final RemoteServer<DockerCloudConfiguration> myServer;
        @NotNull
        private final String myImageId;
        @Nullable
        private final String myOptionalImageTag;
        @NotNull
        private final DockerCloudType myCloudType;

        public Case(@NotNull Project myProject, @NotNull RemoteServer<DockerCloudConfiguration> myServer, @NotNull String myImageId, @Nullable String myOptionalImageTag) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter(myServer, (String)"myServer");
            Intrinsics.checkNotNullParameter((Object)myImageId, (String)"myImageId");
            this.myProject = myProject;
            this.myServer = myServer;
            this.myImageId = myImageId;
            this.myOptionalImageTag = myOptionalImageTag;
            DockerCloudType dockerCloudType = DockerCloudType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerCloudType), (String)"getInstance(...)");
            this.myCloudType = dockerCloudType;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ListPopup createPopup() {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            DeploymentConfigurationManager deploymentConfigurationManager = DeploymentConfigurationManager.getInstance((Project)this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)deploymentConfigurationManager, (String)"getInstance(...)");
            DeploymentConfigurationManager configurationManager = deploymentConfigurationManager;
            Ref CREATE_NEW = new Ref();
            List list = configurationManager.getDeploymentConfigurations((ServerType)this.myCloudType);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDeploymentConfigurations(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                if (!this.isForTheSameServerAndImage(settings)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List existing = (List)destination$iv$iv;
            Iterable $this$map$iv = existing;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void value;
                RunnerAndConfigurationSettings bl = (RunnerAndConfigurationSettings)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(Ref.create((Object)value));
            }
            List list2 = CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)CollectionsKt.listOf((Object)CREATE_NEW));
            String $i$f$map22 = DockerBundle.message((String)"CreateContainerAction.popup.title", (Object[])new Object[0]);
            BaseListPopupStep<Ref<RunnerAndConfigurationSettings>> theOnlyStep2 = new BaseListPopupStep<Ref<RunnerAndConfigurationSettings>>((List<? extends Ref<RunnerAndConfigurationSettings>>)list2, this, $i$f$map22){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $list);
                }

                public Icon getIconFor(Ref<RunnerAndConfigurationSettings> value) {
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    return null;
                }

                public String getTextFor(Ref<RunnerAndConfigurationSettings> value) {
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    Object object = (RunnerAndConfigurationSettings)value.get();
                    if (object == null || (object = object.getName()) == null) {
                        String string = DockerBundle.message((String)"CreateContainerAction.popup.defaultAction", (Object[])new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    }
                    return object;
                }

                public PopupStep<?> onChosen(Ref<RunnerAndConfigurationSettings> selectedValue, boolean finalChoice) {
                    Intrinsics.checkNotNullParameter(selectedValue, (String)"selectedValue");
                    RunnerAndConfigurationSettings value = (RunnerAndConfigurationSettings)selectedValue.get();
                    return this.doFinalStep(() -> createPopup.theOnlyStep.1.onChosen$lambda$0(value, this.this$0));
                }

                private static final void onChosen$lambda$0(RunnerAndConfigurationSettings $value, Case this$0) {
                    if ($value != null) {
                        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)$value, (Executor)DefaultRunExecutor.getRunExecutorInstance());
                    } else {
                        Case.access$createAndRunImageConfiguration(this$0);
                    }
                }
            };
            if (existing.isEmpty()) {
                theOnlyStep2.setDefaultOptionIndex(list2.indexOf(CREATE_NEW));
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)theOnlyStep2);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
            ListPopup result2 = listPopup;
            result2.setHandleAutoSelectionBeforeShow(true);
            return result2;
        }

        private final void createAndRunImageConfiguration() {
            DockerImageDeploymentSourceType imageType = DockerImageDeploymentSourceType.getInstance();
            DeploymentSource deploymentSource = imageType.getSingletonSource();
            Intrinsics.checkNotNullExpressionValue((Object)deploymentSource, (String)"getSingletonSource(...)");
            DeploymentSource imageSource = deploymentSource;
            DockerRunConfigurationCreator creator = new DockerRunConfigurationCreator(this.myProject);
            DockerDeploymentConfiguration deploymentConfiguration = Optional.ofNullable(creator.createDeploymentConfigurationFromTemplate(imageType)).orElseGet(() -> Case.createAndRunImageConfiguration$lambda$0(this, imageSource));
            String string = this.myOptionalImageTag;
            if (string == null) {
                string = this.myImageId;
            }
            deploymentConfiguration.setTheOnlyImageTag(string);
            creator.setupAndFireDeployment(imageSource, deploymentConfiguration, this.myServer);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isForTheSameServerAndImage(RunnerAndConfigurationSettings settings) {
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration<*, *>");
            DeployToServerRunConfiguration configuration = (DeployToServerRunConfiguration)runConfiguration;
            if (!StringUtil.equals((CharSequence)this.myServer.getName(), (CharSequence)configuration.getServerName())) return false;
            if (configuration.getDeploymentSource() == null) return false;
            if (!(configuration.getDeploymentSource().getType() instanceof DockerImageDeploymentSourceType)) return false;
            DeploymentConfiguration deploymentConfiguration = configuration.getDeploymentConfiguration();
            Intrinsics.checkNotNull((Object)deploymentConfiguration, (String)"null cannot be cast to non-null type com.intellij.docker.DockerDeploymentConfiguration");
            if (!this.isForTheSameImage((DockerDeploymentConfiguration)deploymentConfiguration)) return false;
            return true;
        }

        private final boolean isForTheSameImage(DockerDeploymentConfiguration configuration) {
            String thatIdOrTag = Case.Companion.getTheOnlyItem(configuration.getSeparateImageTags());
            return Intrinsics.areEqual((Object)this.myImageId, (Object)thatIdOrTag) || this.myOptionalImageTag != null && Intrinsics.areEqual((Object)this.myOptionalImageTag, (Object)thatIdOrTag);
        }

        private static final DockerDeploymentConfiguration createAndRunImageConfiguration$lambda$0(Case this$0, DeploymentSource $imageSource) {
            return DockerCloudType.getInstance().createDeploymentConfigurator(this$0.myProject).createDefaultConfiguration($imageSource);
        }

        public static final /* synthetic */ void access$createAndRunImageConfiguration(Case $this) {
            $this.createAndRunImageConfiguration();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/action/images/CreateContainerAction$Case$Companion;", "", "<init>", "()V", "getTheOnlyItem", "", "items", "", "([Ljava/lang/String;)Ljava/lang/String;", "intellij.clouds.docker"})
        public static final class Companion {
            private Companion() {
            }

            private final String getTheOnlyItem(String[] items) {
                return items.length == 1 ? items[0] : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

