/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNamesKt;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableParameterListType;
import com.jetbrains.python.psi.types.PyCallableParameterListTypeImpl;
import com.jetbrains.python.psi.types.PyCallableParameterVariadicType;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCloningTypeVisitor;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNamedTupleType;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PyPositionalVariadicType;
import com.jetbrains.python.psi.types.PyRecursiveTypeVisitor;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeCheckerExtension;
import com.jetbrains.python.psi.types.PyTypeParameterMapping;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyTypedResolveResult;
import com.jetbrains.python.psi.types.PyTypingNewType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyUnsafeUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeChecker {
    private PyTypeChecker() {
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(0);
        }
        @NotNull GenericSubstitutions substitutions = new GenericSubstitutions();
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull Map<? extends PyTypeParameterType, PyType> typeVars) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(1);
        }
        if (typeVars == null) {
            PyTypeChecker.$$$reportNull$$$0(2);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions(typeVars);
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(3);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(4);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    @NotNull
    private static Optional<Boolean> match(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> result;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(5);
        }
        Optional<Boolean> optional = (result = (Optional<Boolean>)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)expected, (Object)actual), (boolean)false, () -> PyTypeChecker.matchImpl(expected, actual, context))) == null ? Optional.of(true) : result;
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(6);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchImpl(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        PyUnsafeUnionType weakUnionType;
        PyTypeVarType typeVarType;
        Optional<Boolean> match;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(7);
        }
        if (Objects.equals(expected, actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(8);
            }
            return optional;
        }
        for (PyTypeCheckerExtension extension : PyTypeCheckerExtension.EP_NAME.getExtensionList()) {
            Optional<Boolean> result = extension.match(expected, actual, context.context, context.mySubstitutions);
            if (!result.isPresent()) continue;
            Optional<Boolean> optional = result;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(9);
            }
            return optional;
        }
        if (expected instanceof PyClassType && (match = PyTypeChecker.matchObject((PyClassType)expected, actual)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(10);
            }
            return optional;
        }
        if (actual instanceof PyNarrowedType) {
            PyNarrowedType actualNarrowedType = (PyNarrowedType)actual;
            if (expected instanceof PyNarrowedType) {
                PyNarrowedType expectedNarrowedType = (PyNarrowedType)expected;
                return PyTypeChecker.match(expectedNarrowedType, actualNarrowedType, context);
            }
        }
        if (actual instanceof PyTypeVarTupleType) {
            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)actual;
            if (context.reversedSubstitutions) {
                Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyPositionalVariadicType)typeVarTupleType, expected, context));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(11);
                }
                return optional;
            }
        }
        if (expected instanceof PyPositionalVariadicType) {
            PyPositionalVariadicType variadic = (PyPositionalVariadicType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(variadic, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(12);
            }
            return optional;
        }
        if (actual instanceof PyTypeVarType) {
            typeVarType = (PyTypeVarType)actual;
            if (context.reversedSubstitutions) {
                Optional<Boolean> optional = Optional.of(PyTypeChecker.match(typeVarType, expected, context));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(13);
                }
                return optional;
            }
        }
        if (expected instanceof PyTypeVarType) {
            typeVarType = (PyTypeVarType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(typeVarType, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(14);
            }
            return optional;
        }
        if (expected instanceof PySelfType) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, actual, context);
        }
        if (actual instanceof PySelfType && context.reversedSubstitutions) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, expected, context);
        }
        if (expected instanceof PyParamSpecType) {
            PyParamSpecType paramSpecType = (PyParamSpecType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(paramSpecType, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(15);
            }
            return optional;
        }
        if (expected instanceof PyConcatenateType) {
            PyConcatenateType concatenateType = (PyConcatenateType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(concatenateType, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(16);
            }
            return optional;
        }
        if (expected == null || actual == null || PyTypeChecker.isUnknown(actual, context.context)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(17);
            }
            return optional;
        }
        if (expected instanceof PyCallableParameterListType) {
            PyCallableParameterListType callableParameterListType = (PyCallableParameterListType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(callableParameterListType, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(18);
            }
            return optional;
        }
        if (actual instanceof PyNeverType) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(19);
            }
            return optional;
        }
        if (expected instanceof PyNeverType) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(20);
            }
            return optional;
        }
        if (actual instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(expected, (PyUnionType)actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(21);
            }
            return optional;
        }
        if (expected instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyUnionType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(22);
            }
            return optional;
        }
        if (actual instanceof PyUnsafeUnionType) {
            weakUnionType = (PyUnsafeUnionType)actual;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(expected, weakUnionType, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(23);
            }
            return optional;
        }
        if (expected instanceof PyUnsafeUnionType) {
            weakUnionType = (PyUnsafeUnionType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(weakUnionType, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(24);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyClassType && (match = PyTypeChecker.match((PyClassType)expected, (PyClassType)actual, context)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(25);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && ((PyStructuralType)actual).isInferredFromUsages()) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(26);
            }
            return optional;
        }
        if (expected instanceof PyStructuralType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyStructuralType)expected, actual, context.context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(27);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && expected instanceof PyClassType) {
            Set expectedAttributes = ((PyClassType)expected).getMemberNames(true, context.context);
            Optional<Boolean> optional = Optional.of(expectedAttributes.containsAll(((PyStructuralType)actual).getAttributeNames()));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(28);
            }
            return optional;
        }
        if (actual instanceof PyCallableType) {
            PyCallableType expectedCallable;
            Optional<Boolean> match2;
            PyCallableType actualCallable = (PyCallableType)actual;
            if (expected instanceof PyCallableType && (match2 = PyTypeChecker.match(expectedCallable = (PyCallableType)expected, actualCallable, context)).isPresent()) {
                Optional<Boolean> optional = match2;
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(29);
                }
                return optional;
            }
        }
        if (expected instanceof PyModuleType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyModuleType && ((PyModuleType)expected).getModule() == ((PyModuleType)actual).getModule());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(30);
            }
            return optional;
        }
        if (expected instanceof PyClassType) {
            PyClassType classType = (PyClassType)expected;
            if (actual instanceof PyModuleType) {
                PyModuleType moduleType = (PyModuleType)actual;
                if (PyProtocolsKt.isProtocol((PyClassLikeType)classType, context.context)) {
                    Optional<Boolean> optional = Optional.of(PyTypeChecker.match(classType, moduleType, context));
                    if (optional == null) {
                        PyTypeChecker.$$$reportNull$$$0(31);
                    }
                    return optional;
                }
                return PyTypeChecker.match(expected, (PyType)moduleType.getModuleClassType(), context);
            }
        }
        Optional<Boolean> optional = Optional.of(PyTypeChecker.matchNumericTypes(expected, actual));
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(32);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> match(PyNarrowedType expectedNarrowedType, PyNarrowedType actualNarrowedType, @NotNull MatchContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(33);
        }
        if (expectedNarrowedType.getTypeIs() != actualNarrowedType.getTypeIs()) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(34);
            }
            return optional;
        }
        if (expectedNarrowedType.getTypeIs()) {
            Optional<Boolean> optional = Optional.of(Objects.equals(expectedNarrowedType.getNarrowedType(), actualNarrowedType.getNarrowedType()));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(35);
            }
            return optional;
        }
        return PyTypeChecker.match(expectedNarrowedType.getNarrowedType(), actualNarrowedType.getNarrowedType(), context);
    }

    @NotNull
    private static Optional<Boolean> matchObject(@NotNull PyClassType expected, @Nullable PyType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(36);
        }
        if (ArrayUtil.contains((String)expected.getName(), (String[])new String[]{"object", "type"})) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)expected.getPyClass());
            if (expected.equals((Object)builtinCache.getObjectType())) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(37);
                }
                return optional;
            }
            if (expected.equals((Object)builtinCache.getTypeType()) && actual instanceof PyInstantiableType && ((PyInstantiableType)actual).isDefinition()) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(38);
                }
                return optional;
            }
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(39);
        }
        return optional;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean match(@NotNull PyTypeVarType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        PyType safeActual;
        PyType defaultType;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(40);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(41);
        }
        if (expected.isDefinition() && actual instanceof PyInstantiableType && !((PyInstantiableType)actual).isDefinition()) {
            return false;
        }
        Ref<PyType> substitutedRef = context.mySubstitutions.typeVars.get(expected);
        Ref defaultTypeRef = expected.getDefaultType();
        if (defaultTypeRef != null && (defaultType = (PyType)defaultTypeRef.get()) != null && defaultType.equals(Ref.deref(substitutedRef))) {
            substitutedRef = null;
        }
        PyType substitution = (PyType)Ref.deref(substitutedRef);
        PyType bound = expected.getBound();
        @Nullable List constraints = expected.getConstraints();
        int matchedConstraintIndex = -1;
        if (expected.isDefinition()) {
            bound = PyTypeChecker.toClass(bound);
            constraints = ContainerUtil.map((Collection)constraints, PyTypeChecker::toClass);
        }
        PyType pyType = safeActual = constraints.isEmpty() && bound instanceof PyLiteralStringType ? actual : PyTypeChecker.replaceLiteralStringWithStr(actual);
        if (constraints.isEmpty() ? (match = PyTypeChecker.match(bound, safeActual, context)).isPresent() && match.get() == false : (matchedConstraintIndex = ContainerUtil.indexOf((List)constraints, constraint -> PyTypeChecker.match(constraint, safeActual, context).orElse(true))) == -1) {
            return false;
        }
        if (substitutedRef != null) {
            if (expected.equals((Object)safeActual) || expected.equals((Object)substitution)) {
                return true;
            }
            Optional recursiveMatch = (Optional)RecursionManager.doPreventingRecursion((Object)expected, (boolean)false, (Computable)(context.reversedSubstitutions ? () -> PyTypeChecker.match(safeActual, substitution, context) : () -> PyTypeChecker.match(substitution, safeActual, context)));
            return recursiveMatch != null ? recursiveMatch.orElse(false) : false;
        }
        if (safeActual != null) {
            PyType type = constraints.isEmpty() ? safeActual : (PyType)constraints.get(matchedConstraintIndex);
            context.mySubstitutions.typeVars.put(expected, (Ref<PyType>)Ref.create((Object)type));
        } else {
            PyType effectiveBound = PyTypeUtil.getEffectiveBound(expected);
            if (effectiveBound != null) {
                context.mySubstitutions.typeVars.put(expected, (Ref<PyType>)Ref.create((Object)PyUnionType.createWeakType(effectiveBound)));
            }
        }
        return true;
    }

    @Nullable
    private static PyType toClass(@Nullable PyType type) {
        return (PyType)PyTypeUtil.toStream(type).map(t -> {
            PyType pyType;
            if (t instanceof PyInstantiableType) {
                PyInstantiableType instantiableType = (PyInstantiableType)t;
                pyType = instantiableType.toClass();
            } else {
                pyType = t;
            }
            return pyType;
        }).collect(PyTypeUtil.toUnion(type));
    }

    private static boolean match(@NotNull PyPositionalVariadicType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(42);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(43);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyPositionalVariadicType)) {
            return false;
        }
        PyPositionalVariadicType actualVariadic = (PyPositionalVariadicType)actual;
        if (expected instanceof PyUnpackedTupleType) {
            PyUnpackedTupleType expectedUnpackedTupleType = (PyUnpackedTupleType)expected;
            if (!(actualVariadic instanceof PyUnpackedTupleType)) {
                return false;
            }
            PyUnpackedTupleType actualUnpackedTupleType = (PyUnpackedTupleType)actualVariadic;
            if (expectedUnpackedTupleType.isUnbound()) {
                PyType repeatedExpectedType = (PyType)expectedUnpackedTupleType.getElementTypes().get(0);
                if (actualUnpackedTupleType.isUnbound()) {
                    return PyTypeChecker.match(repeatedExpectedType, (PyType)actualUnpackedTupleType.getElementTypes().get(0), context).orElse(false);
                }
                return ContainerUtil.all((Collection)actualUnpackedTupleType.getElementTypes(), singleActualType -> PyTypeChecker.match(repeatedExpectedType, singleActualType, context).orElse(false));
            }
            if (actualUnpackedTupleType.isUnbound()) {
                PyType repeatedActualType = (PyType)actualUnpackedTupleType.getElementTypes().get(0);
                return ContainerUtil.all((Collection)expectedUnpackedTupleType.getElementTypes(), singleExpectedType -> PyTypeChecker.match(singleExpectedType, repeatedActualType, context).orElse(false));
            }
            return PyTypeChecker.matchTypeParameters(expectedUnpackedTupleType.getElementTypes(), actualUnpackedTupleType.getElementTypes(), context);
        }
        PyPositionalVariadicType substitution = context.mySubstitutions.typeVarTuples.get(expected);
        if (substitution != null && !substitution.equals((Object)PyUnpackedTupleTypeImpl.UNSPECIFIED)) {
            if (expected.equals((Object)actual) || substitution.equals((Object)expected)) {
                return true;
            }
            return context.reversedSubstitutions ? PyTypeChecker.match(actualVariadic, (PyType)substitution, context) : PyTypeChecker.match(substitution, (PyType)actualVariadic, context);
        }
        context.mySubstitutions.typeVarTuples.put((PyTypeVarTupleType)expected, actualVariadic);
        return true;
    }

    @Nullable
    private static PyType replaceLiteralStringWithStr(@Nullable PyType actual) {
        if (actual instanceof PyLiteralStringType) {
            PyLiteralStringType literalStringType = (PyLiteralStringType)actual;
            return new PyClassTypeImpl(literalStringType.getPyClass(), false);
        }
        if (actual instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)actual;
            return unionType.map(PyTypeChecker::replaceLiteralStringWithStr);
        }
        if (actual instanceof PyNamedTupleType) {
            return actual;
        }
        if (actual instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)actual;
            return new PyTupleType(tupleType.getPyClass(), ContainerUtil.map(tupleType.getElementTypes(), PyTypeChecker::replaceLiteralStringWithStr), tupleType.isHomogeneous(), tupleType.isDefinition());
        }
        if (actual instanceof PyCollectionType) {
            PyCollectionType generic = (PyCollectionType)actual;
            return new PyCollectionTypeImpl(generic.getPyClass(), generic.isDefinition(), ContainerUtil.map(generic.getElementTypes(), PyTypeChecker::replaceLiteralStringWithStr));
        }
        return actual;
    }

    private static boolean match(@NotNull PyParamSpecType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(44);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(45);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyCallableParameterVariadicType)) {
            return false;
        }
        PyCallableParameterVariadicType actualParameters = (PyCallableParameterVariadicType)actual;
        context.mySubstitutions.paramSpecs.put(expected, actualParameters);
        return true;
    }

    private static boolean match(@NotNull PyConcatenateType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(46);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(47);
        }
        if (actual == null) {
            return true;
        }
        List<PyType> expectedFirstTypes = expected.getFirstTypes();
        int expectedPrefixSize = expectedFirstTypes.size();
        PyParamSpecType expectedParamSpec = expected.getParamSpec();
        if (actual instanceof PyConcatenateType) {
            PyConcatenateType actualConcatenateType = (PyConcatenateType)actual;
            if (expectedPrefixSize > actualConcatenateType.getFirstTypes().size()) {
                return false;
            }
            List<PyType> actualFirstTypes = actualConcatenateType.getFirstTypes().subList(0, expectedPrefixSize);
            if (!PyTypeChecker.match(expectedFirstTypes, actualFirstTypes, context)) {
                return false;
            }
            if (expectedParamSpec == null) {
                return true;
            }
            if (actualFirstTypes.size() > expectedPrefixSize) {
                return PyTypeChecker.match(expectedParamSpec, (PyType)new PyConcatenateType(ContainerUtil.subList(expectedFirstTypes, (int)actualFirstTypes.size()), actualConcatenateType.getParamSpec()), context);
            }
            return PyTypeChecker.match(expectedParamSpec, (PyType)actualConcatenateType.getParamSpec(), context);
        }
        if (actual instanceof PyCallableParameterListType) {
            PyCallableParameterListType actualParameters = (PyCallableParameterListType)actual;
            if (expectedPrefixSize > actualParameters.getParameters().size()) {
                return false;
            }
            List actualFirstParamTypes = ContainerUtil.map(actualParameters.getParameters().subList(0, expectedPrefixSize), it -> it.getType(context.context));
            if (!PyTypeChecker.match(expectedFirstTypes, actualFirstParamTypes, context)) {
                return false;
            }
            if (expectedParamSpec == null) {
                return true;
            }
            return PyTypeChecker.match(expectedParamSpec, (PyType)new PyCallableParameterListTypeImpl(ContainerUtil.subList((List)actualParameters.getParameters(), (int)expectedPrefixSize)), context);
        }
        return false;
    }

    private static boolean match(@NotNull PyCallableParameterListType expectedParameters, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expectedParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(48);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(49);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyCallableParameterListType)) {
            return false;
        }
        PyCallableParameterListType actualParameters = (PyCallableParameterListType)actual;
        return PyTypeChecker.matchCallableParameters(expectedParameters.getParameters(), actualParameters.getParameters(), context);
    }

    private static boolean match(@NotNull PyType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        PyTupleType expectedTupleType;
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(50);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(51);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(52);
        }
        if (expected instanceof PyTupleType && (match = PyTypeChecker.match(expectedTupleType = (PyTupleType)expected, actual, context)).isPresent()) {
            return match.get();
        }
        if (!PyUnionType.isStrictSemanticsEnabled()) {
            if (ContainerUtil.exists(actual.getMembers(), x -> x instanceof PyLiteralStringType || x instanceof PyLiteralType)) {
                return ContainerUtil.and(actual.getMembers(), type -> PyTypeChecker.match(expected, type, context).orElse(false));
            }
            return ContainerUtil.or(actual.getMembers(), type -> PyTypeChecker.match(expected, type, context).orElse(false));
        }
        return ContainerUtil.and(actual.getMembers(), type -> PyTypeChecker.match(expected, type, context).orElse(false));
    }

    private static boolean match(@NotNull PyType expected, @NotNull PyUnsafeUnionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(53);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(54);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(55);
        }
        return ContainerUtil.or(actual.getMembers(), type -> PyTypeChecker.match(expected, type, context).orElse(false));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        PyTupleType widenedActual;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(56);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(57);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(58);
        }
        int elementCount = expected.getElementCount();
        if (!expected.isHomogeneous() && (widenedActual = PyTypeChecker.widenUnionOfTuplesToTupleOfUnions(actual, elementCount)) != null) {
            return PyTypeChecker.match(expected, widenedActual, context);
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(59);
        }
        return optional;
    }

    private static boolean match(@NotNull PyUnionType expected, @NotNull PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(60);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(62);
        }
        if (expected.getMembers().contains(actual)) {
            return true;
        }
        return ContainerUtil.or(expected.getMembers(), type -> PyTypeChecker.match(type, actual, context).orElse(true));
    }

    private static boolean match(@NotNull PyUnsafeUnionType expected, @NotNull PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(63);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(64);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(65);
        }
        if (expected.getMembers().contains(actual)) {
            return true;
        }
        return ContainerUtil.or(expected.getMembers(), type -> PyTypeChecker.match(type, actual, context).orElse(true));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyTypedDictType typedDictType;
        Boolean matchResult;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(66);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(67);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(68);
        }
        if (expected.equals((Object)actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(69);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected.isDefinition() ^ actual.isDefinition() && !PyProtocolsKt.isProtocol((PyClassLikeType)expected, context)) {
            if (!expected.isDefinition() && actual.isDefinition()) {
                PyClassLikeType metaClass = actual.getMetaClassType(context, true);
                Optional<Boolean> optional = Optional.of(metaClass != null && PyTypeChecker.match((PyType)expected, (PyType)metaClass.toInstance(), matchContext).orElse(true) != false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(70);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(71);
            }
            return optional;
        }
        if (expected instanceof PyTupleType && actual instanceof PyTupleType) {
            return PyTypeChecker.match((PyTupleType)expected, (PyTupleType)actual, matchContext);
        }
        if (expected instanceof PyLiteralType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyLiteralType && PyLiteralType.Companion.match((PyLiteralType)expected, (PyLiteralType)actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(72);
            }
            return optional;
        }
        if (expected instanceof PyTypedDictType && !(actual instanceof PyTypedDictType)) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(73);
            }
            return optional;
        }
        if (actual instanceof PyTypedDictType && (matchResult = PyTypedDictType.match((PyType)expected, typedDictType = (PyTypedDictType)actual, context)) != null) {
            Optional<Boolean> optional = Optional.of(matchResult);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(74);
            }
            return optional;
        }
        if (expected instanceof PyLiteralStringType) {
            Optional<Boolean> optional = Optional.of(PyLiteralStringType.Companion.match((PyLiteralStringType)expected, actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(75);
            }
            return optional;
        }
        PyClass superClass = expected.getPyClass();
        PyClass subClass = actual.getPyClass();
        if (!subClass.isSubclass(superClass, context) && PyProtocolsKt.isProtocol((PyClassLikeType)expected, context)) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.matchProtocols(expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(76);
            }
            return optional;
        }
        if (expected instanceof PyCollectionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyCollectionType)expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(77);
            }
            return optional;
        }
        if (PyTypeChecker.matchClasses(superClass, subClass, context)) {
            if (expected instanceof PyTypingNewType && !expected.equals((Object)actual) && superClass.equals((Object)subClass)) {
                Optional<Boolean> optional = Optional.of(actual.getAncestorTypes(context).contains(expected));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(78);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(79);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(80);
        }
        return optional;
    }

    private static boolean matchProtocols(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyCollectionType genericSuperClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(81);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(82);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(83);
        }
        GenericSubstitutions substitutions = PyTypeChecker.collectTypeSubstitutions(actual, matchContext.context);
        MatchContext protocolContext = new MatchContext(matchContext.context, new GenericSubstitutions(), matchContext.reversedSubstitutions);
        for (kotlin.Pair<PyTypedElement, List<PyTypedResolveResult>> pair : PyProtocolsKt.inspectProtocolSubclass(expected, actual, matchContext.context)) {
            List subclassElementTypes = ContainerUtil.map((Collection)((Collection)pair.getSecond()), member -> member.getType());
            if (ContainerUtil.isEmpty((Collection)subclassElementTypes)) {
                return false;
            }
            PyType protocolElementType = PyTypeChecker.dropSelfIfNeeded(expected, matchContext.context.getType((PyTypedElement)pair.getFirst()), matchContext.context);
            boolean elementResult = StreamEx.of((Collection)subclassElementTypes).map(type -> PyTypeChecker.dropSelfIfNeeded(actual, type, matchContext.context)).map(type -> PyTypeChecker.substitute(type, substitutions, matchContext.context)).anyMatch(subclassElementType -> {
                PyCallableType callableProtocolElement;
                boolean matched;
                block7: {
                    block6: {
                        matched = PyTypeChecker.match(protocolElementType, subclassElementType, protocolContext).orElse(true);
                        if (!matched) {
                            return false;
                        }
                        if (!(protocolElementType instanceof PyCallableType)) break block6;
                        callableProtocolElement = (PyCallableType)protocolElementType;
                        if (subclassElementType instanceof PyCallableType) break block7;
                    }
                    return matched;
                }
                PyCallableType callableSubclassElement = (PyCallableType)subclassElementType;
                PyType protocolReturnType = callableProtocolElement.getReturnType(protocolContext.context);
                if (protocolReturnType instanceof PySelfType) {
                    PyType subclassReturnType = callableSubclassElement.getReturnType(protocolContext.context);
                    if (subclassReturnType instanceof PySelfType) {
                        return true;
                    }
                    return PyTypeChecker.match((PyType)actual, subclassReturnType, matchContext).orElse(true);
                }
                return matched;
            });
            if (elementResult) continue;
            return false;
        }
        if (expected instanceof PyCollectionType && (genericSuperClass = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), matchContext.context)) != null) {
            PyCollectionType concreteSuperClass = (PyCollectionType)PyTypeChecker.substitute((PyType)genericSuperClass, protocolContext.mySubstitutions, protocolContext.context);
            assert (concreteSuperClass != null);
            return PyTypeChecker.matchGenericClassesParameterWise((PyCollectionType)expected, concreteSuperClass, matchContext);
        }
        return true;
    }

    private static boolean match(PyClassType expectedProtocol, PyModuleType actualModule, MatchContext matchContext) {
        PyFile module = actualModule.getModule();
        Map moduleElements = ((StreamEx)StreamEx.of((Collection)ContainerUtil.concat((List)module.getTopLevelAttributes(), (List)module.getTopLevelFunctions())).filter(e -> {
            String name = ((PyQualifiedNameOwner)e).getName();
            return name != null && !PyNamesKt.isPrivate((String)name) && !PyNamesKt.isProtected((String)name);
        })).toMap(rec$ -> ((NavigationItem)rec$).getName(), v -> (PyTypedElement)v);
        List<kotlin.Pair<PyTypedElement, List<PyTypedResolveResult>>> protocolElements = PyProtocolsKt.inspectProtocolSubclass(expectedProtocol, expectedProtocol, matchContext.context);
        if (protocolElements.size() != moduleElements.size()) {
            return false;
        }
        GenericSubstitutions substitutions = PyTypeChecker.collectTypeSubstitutions(expectedProtocol, matchContext.context);
        for (kotlin.Pair<PyTypedElement, List<PyTypedResolveResult>> pair : protocolElements) {
            PyTypedElement protocolMember = (PyTypedElement)pair.getFirst();
            String name = protocolMember.getName();
            PyTypedElement moduleElement = (PyTypedElement)moduleElements.get(name);
            if (moduleElement != null) {
                PyType actualModuleElementType;
                PyType expectedProtocolMemberType = PyTypeChecker.substitute(PyTypeChecker.dropSelfIfNeeded(expectedProtocol, matchContext.context.getType((PyTypedElement)pair.getFirst()), matchContext.context), substitutions, matchContext.context);
                if (PyTypeChecker.match(expectedProtocolMemberType, actualModuleElementType = matchContext.context.getType(moduleElement), matchContext.context)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static PyType dropSelfIfNeeded(@NotNull PyClassType classType, @Nullable PyType elementType, @NotNull TypeEvalContext context) {
        PyFunctionType functionType;
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(84);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(85);
        }
        if (elementType instanceof PyFunctionType && (PyUtil.isInitOrNewMethod((PsiElement)(functionType = (PyFunctionType)elementType).getCallable()) || !classType.isDefinition())) {
            return functionType.dropSelf(context);
        }
        return elementType;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        PyType elementType;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(86);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(87);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(88);
        }
        if (actual.isHomogeneous() && (elementType = actual.getIteratedItemType()) == null) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(89);
            }
            return optional;
        }
        if (!expected.isHomogeneous() && !actual.isHomogeneous()) {
            Condition isUnbound = type -> {
                PyUnpackedTupleType unpacked;
                return type instanceof PyUnpackedTupleType && (unpacked = (PyUnpackedTupleType)type).isUnbound() || type instanceof PyTypeVarTupleType;
            };
            boolean expectedContainsUnboundTypes = ContainerUtil.exists(expected.getElementTypes(), (Condition)isUnbound);
            boolean actualContainsUnboundTypes = ContainerUtil.exists(actual.getElementTypes(), (Condition)isUnbound);
            if (actualContainsUnboundTypes && !expectedContainsUnboundTypes) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(90);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(PyTypeChecker.matchTypeParameters(expected.getElementTypes(), actual.getElementTypes(), context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(91);
            }
            return optional;
        }
        if (expected.isHomogeneous() && !actual.isHomogeneous()) {
            PyType expectedElementType = expected.getIteratedItemType();
            Optional<Boolean> optional = Optional.of(PyTypeUtil.toStream(actual.getIteratedItemType()).allMatch(type -> PyTypeChecker.match(expectedElementType, type, context).orElse(true)));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(92);
            }
            return optional;
        }
        if (!expected.isHomogeneous() && actual.isHomogeneous()) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(93);
            }
            return optional;
        }
        return PyTypeChecker.match(expected.getIteratedItemType(), actual.getIteratedItemType(), context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        PyClass subClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(94);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(95);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(96);
        }
        if (actual instanceof PyTupleType) {
            return PyTypeChecker.match(expected, (PyTupleType)actual, context);
        }
        PyClass superClass = expected.getPyClass();
        return PyTypeChecker.matchClasses(superClass, subClass = actual.getPyClass(), context.context) && PyTypeChecker.matchGenerics(expected, actual, context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(97);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(98);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(99);
        }
        if (!PyTypeChecker.matchClasses(expected.getPyClass(), actual.getPyClass(), context.context)) {
            return false;
        }
        PyType superElementType = expected.getIteratedItemType();
        PyType subElementType = actual.getIteratedItemType();
        return PyTypeChecker.match(superElementType, subElementType, context).orElse(true);
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyType actual, @NotNull TypeEvalContext context) {
        PyFile module;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(100);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(101);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(102);
        }
        if (actual instanceof PyStructuralType) {
            return PyTypeChecker.match(expected, (PyStructuralType)actual);
        }
        if (actual instanceof PyClassType) {
            return PyTypeChecker.match(expected, (PyClassType)actual, context);
        }
        if (actual instanceof PyModuleType && (module = ((PyModuleType)actual).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37) && PyTypeChecker.definesGetAttr(module, context)) {
            return true;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        return !ContainerUtil.exists(expected.getAttributeNames(), attribute -> ContainerUtil.isEmpty((Collection)actual.resolveMember(attribute, null, AccessDirection.READ, resolveContext)));
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyStructuralType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(103);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(104);
        }
        if (expected.isInferredFromUsages()) {
            return true;
        }
        return expected.getAttributeNames().containsAll(actual.getAttributeNames());
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyClassType actual, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(105);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(106);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(107);
        }
        if (PyTypeChecker.overridesGetAttr(actual.getPyClass(), context)) {
            return true;
        }
        Set actualAttributes = actual.getMemberNames(true, context);
        return actualAttributes.containsAll(expected.getAttributeNames());
    }

    private static boolean matchCallableParameters(@NotNull List<PyCallableParameter> expectedParameters, @NotNull List<PyCallableParameter> actualParameters, @NotNull MatchContext matchContext) {
        List expectedElementTypes;
        List expectedElementTypes2;
        PyTypeParameterMapping mapping;
        boolean hasParamSpec;
        if (expectedParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(108);
        }
        if (actualParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(109);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(110);
        }
        TypeEvalContext context = matchContext.context;
        if (expectedParameters.size() == 1) {
            PyType onlyExpectedParamType = expectedParameters.get(0).getType(context);
            if (onlyExpectedParamType instanceof PyParamSpecType) {
                PyType actualOnlyParamType;
                PyParamSpecType expectedParamSpecType = (PyParamSpecType)onlyExpectedParamType;
                if (actualParameters.size() == 1 && ((actualOnlyParamType = actualParameters.get(0).getType(context)) instanceof PyParamSpecType || actualOnlyParamType instanceof PyConcatenateType)) {
                    return PyTypeChecker.match(expectedParamSpecType, actualOnlyParamType, matchContext);
                }
                return PyTypeChecker.match(expectedParamSpecType, (PyType)new PyCallableParameterListTypeImpl(actualParameters), matchContext);
            }
            if (onlyExpectedParamType instanceof PyConcatenateType) {
                PyType actualOnlyParamType;
                PyConcatenateType expectedConcatenateType = (PyConcatenateType)onlyExpectedParamType;
                if (actualParameters.size() == 1 && ((actualOnlyParamType = actualParameters.get(0).getType(context)) instanceof PyParamSpecType || actualOnlyParamType instanceof PyConcatenateType)) {
                    return PyTypeChecker.match(expectedConcatenateType, actualOnlyParamType, matchContext);
                }
                return PyTypeChecker.match(expectedConcatenateType, (PyType)new PyCallableParameterListTypeImpl(actualParameters), matchContext);
            }
        }
        int startIndex = 0;
        if (!expectedParameters.isEmpty() && !actualParameters.isEmpty()) {
            PyCallableParameter firstExpectedParam = expectedParameters.get(0);
            PyCallableParameter firstActualParam = actualParameters.get(0);
            if (firstExpectedParam.isSelf() && firstActualParam.isSelf()) {
                if (!PyTypeChecker.match(firstExpectedParam.getType(context), firstActualParam.getType(context), matchContext).orElse(true).booleanValue()) {
                    return false;
                }
                startIndex = 1;
            }
        }
        if (!(hasParamSpec = ContainerUtil.exists(expectedParameters, it -> it.getType(context) instanceof PyParamSpecType))) {
            boolean shouldAcceptUnlimitedPositionalArgs = ContainerUtil.exists(expectedParameters, PyCallableParameter::isPositionalContainer);
            boolean canAcceptUnlimitedPositionalArgs = ContainerUtil.exists(actualParameters, PyCallableParameter::isPositionalContainer);
            if (shouldAcceptUnlimitedPositionalArgs && !canAcceptUnlimitedPositionalArgs) {
                return false;
            }
            boolean shouldAcceptArbitraryKeywordArgs = ContainerUtil.exists(expectedParameters, PyCallableParameter::isKeywordContainer);
            boolean canAcceptArbitraryKeywordArgs = ContainerUtil.exists(actualParameters, PyCallableParameter::isKeywordContainer);
            if (shouldAcceptArbitraryKeywordArgs && !canAcceptArbitraryKeywordArgs) {
                return false;
            }
        }
        if ((mapping = PyTypeParameterMapping.mapWithParameterList(ContainerUtil.subList((List)(expectedElementTypes2 = ContainerUtil.filter((Collection)(expectedElementTypes = ((StreamEx)StreamEx.of(expectedParameters).filter(cp -> !(cp.getParameter() instanceof PySlashParameter) && !(cp.getParameter() instanceof PySingleStarParameter))).map(cp -> {
            PyType argType = cp.getArgumentType(context);
            if (cp.isPositionalContainer() && !(argType instanceof PyPositionalVariadicType)) {
                return PyUnpackedTupleTypeImpl.createUnbound(argType);
            }
            return argType;
        }).toList()), it -> !(it instanceof PyParamSpecType))), (int)startIndex), ContainerUtil.subList(actualParameters, (int)startIndex), context)) == null) {
            return false;
        }
        for (Couple<PyType> pair : mapping.getMappedTypes()) {
            Optional<Boolean> matched = matchContext.reverseSubstitutions().reversedSubstitutions ? PyTypeChecker.match((PyType)pair.getSecond(), (PyType)pair.getFirst(), matchContext.reverseSubstitutions()) : PyTypeChecker.match((PyType)pair.getFirst(), (PyType)pair.getSecond(), matchContext.reverseSubstitutions());
            if (matched.orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyCallableType expected, @NotNull PyCallableType actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(111);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(112);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(113);
        }
        if (actual instanceof PyFunctionType && expected instanceof PyClassType && "function".equals(expected.getName()) && expected.equals((Object)PyBuiltinCache.getInstance((PsiElement)actual.getCallable()).getObjectType("function"))) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(114);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected instanceof PyClassLikeType && !PyTypeChecker.isCallableProtocol((PyClassLikeType)expected, context)) {
            Optional<Boolean> optional = "typing.Callable".equals(((PyClassLikeType)expected).getClassQName()) ? Optional.of(actual.isCallable()) : Optional.empty();
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(115);
            }
            return optional;
        }
        if (expected.isCallable() && actual.isCallable()) {
            List expectedParameters = expected.getParameters(context);
            List actualParameters = actual.getParameters(context);
            if (expectedParameters != null && actualParameters != null && !PyTypeChecker.matchCallableParameters(expectedParameters, actualParameters, matchContext)) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(116);
                }
                return optional;
            }
            if (!PyTypeChecker.match(expected.getReturnType(context), PyTypeChecker.getActualReturnType(actual, context), matchContext).orElse(true).booleanValue()) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(117);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(118);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(119);
        }
        return optional;
    }

    private static boolean match(@NotNull List<PyType> expected, @NotNull List<PyType> actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(120);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(121);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(122);
        }
        if (expected.size() != actual.size()) {
            return false;
        }
        for (int i = 0; i < expected.size(); ++i) {
            if (PyTypeChecker.match(expected.get(i), actual.get(i), matchContext).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean isCallableProtocol(@NotNull PyClassLikeType expected, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(123);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(124);
        }
        return PyProtocolsKt.isProtocol(expected, context) && expected.getMemberNames(false, context).contains("__call__");
    }

    @Nullable
    private static PyType getActualReturnType(@NotNull PyCallableType actual, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(125);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(126);
        }
        if ((callable = actual.getCallable()) instanceof PyFunction) {
            return PyUtil.getReturnTypeToAnalyzeAsCallType((PyFunction)callable, context);
        }
        return actual.getReturnType(context);
    }

    @Nullable
    private static PyTupleType widenUnionOfTuplesToTupleOfUnions(@NotNull PyUnionType unionType, int elementCount) {
        boolean consistsOfSameSizeTuples;
        if (unionType == null) {
            PyTypeChecker.$$$reportNull$$$0(127);
        }
        if (!(consistsOfSameSizeTuples = ContainerUtil.all(unionType.getMembers(), member -> {
            PyTupleType tupleType;
            return member instanceof PyTupleType && !(tupleType = (PyTupleType)member).isHomogeneous() && elementCount == tupleType.getElementCount();
        }))) {
            return null;
        }
        List newTupleElements = IntStreamEx.range((int)elementCount).mapToObj(index -> (PyType)PyTypeUtil.toStream(unionType).select(PyTupleType.class).map(tupleType -> tupleType.getElementType(index)).collect(PyTypeUtil.toUnion())).toList();
        PyClass tupleClass = ((PyTupleType)ContainerUtil.getFirstItem(unionType.getMembers())).getPyClass();
        return new PyTupleType(tupleClass, newTupleElements, false);
    }

    private static boolean matchGenerics(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(128);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(129);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(130);
        }
        if (actual instanceof PyCollectionType && expected.getPyClass().equals((Object)actual.getPyClass())) {
            return PyTypeChecker.matchGenericClassesParameterWise(expected, (PyCollectionType)actual, context);
        }
        PyCollectionType expectedGenericType = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), context.context);
        if (expectedGenericType != null) {
            GenericSubstitutions actualSubstitutions = PyTypeChecker.collectTypeSubstitutions(actual, context.context);
            PyCollectionType concreteExpected = (PyCollectionType)PyTypeChecker.substitute((PyType)expectedGenericType, actualSubstitutions, context.context);
            assert (concreteExpected != null);
            return PyTypeChecker.matchGenericClassesParameterWise(expected, concreteExpected, context);
        }
        return true;
    }

    @NotNull
    private static GenericSubstitutions collectTypeSubstitutions(@NotNull PyClassType classType, @NotNull TypeEvalContext context) {
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(131);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(132);
        }
        GenericSubstitutions result = new GenericSubstitutions();
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            Map substitutionsFromClassDefinition = provider.getGenericSubstitutions(classType.getPyClass(), context);
            for (Map.Entry entry : substitutionsFromClassDefinition.entrySet()) {
                Object object = entry.getKey();
                if (object instanceof PyTypeVarType) {
                    PyTypeVarType typeVarType = (PyTypeVarType)object;
                    result.typeVars.put(typeVarType, (Ref<PyType>)Ref.create((Object)((PyType)entry.getValue())));
                    continue;
                }
                object = entry.getKey();
                if (object instanceof PyTypeVarTupleType) {
                    PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)object;
                    assert (entry.getValue() instanceof PyPositionalVariadicType);
                    result.typeVarTuples.put(typeVarTuple, (PyPositionalVariadicType)entry.getValue());
                    continue;
                }
                object = entry.getKey();
                if (!(object instanceof PyParamSpecType)) continue;
                PyParamSpecType specType = (PyParamSpecType)object;
                object = entry.getValue();
                if (!(object instanceof PyCallableParameterVariadicType)) continue;
                PyCallableParameterVariadicType paramSpecType = (PyCallableParameterVariadicType)object;
                result.paramSpecs.put(specType, paramSpecType);
            }
            PyCollectionType genericDefinitionType = PyUtil.as(provider.getGenericType(classType.getPyClass(), context), PyCollectionType.class);
            if (genericDefinitionType != null) {
                List<PyType> definitionTypeParameters = genericDefinitionType.getElementTypes();
                if (!(classType instanceof PyCollectionType)) {
                    for (PyType typeParameter : definitionTypeParameters) {
                        if (typeParameter instanceof PyTypeVarTupleType) {
                            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)typeParameter;
                            result.typeVarTuples.put(typeVarTupleType, null);
                            continue;
                        }
                        if (typeParameter instanceof PyParamSpecType) {
                            PyParamSpecType paramSpecType = (PyParamSpecType)typeParameter;
                            result.paramSpecs.put(paramSpecType, null);
                            continue;
                        }
                        if (!(typeParameter instanceof PyTypeVarType)) continue;
                        PyTypeVarType typeVarType = (PyTypeVarType)typeParameter;
                        result.typeVars.put(typeVarType, null);
                    }
                } else {
                    PyCollectionType genericType = (PyCollectionType)classType;
                    PyTypeChecker.mapTypeParametersToSubstitutions(result, definitionTypeParameters, genericType.getElementTypes(), PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY);
                }
            }
            if (result.typeVars.isEmpty() && result.typeVarTuples.isEmpty() && result.paramSpecs.isEmpty()) continue;
            GenericSubstitutions genericSubstitutions = result;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(133);
            }
            return genericSubstitutions;
        }
        GenericSubstitutions genericSubstitutions = result;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(134);
        }
        return genericSubstitutions;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyCollectionType findGenericDefinitionType(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypeChecker.$$$reportNull$$$0(135);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(136);
        }
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyType definitionType = provider.getGenericType(pyClass, context);
            if (!(definitionType instanceof PyCollectionType)) continue;
            return (PyCollectionType)definitionType;
        }
        return null;
    }

    private static boolean matchGenericClassesParameterWise(@NotNull PyCollectionType expected, @NotNull PyCollectionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(137);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(138);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(139);
        }
        if (expected.equals(actual)) {
            return true;
        }
        if (!expected.getPyClass().equals((Object)actual.getPyClass())) {
            return false;
        }
        List<PyType> expectedElementTypes = expected.getElementTypes();
        List<PyType> actualElementTypes = actual.getElementTypes();
        if (context.reversedSubstitutions) {
            return PyTypeChecker.matchTypeParameters(actualElementTypes, expectedElementTypes, context.resetSubstitutions());
        }
        return PyTypeChecker.matchTypeParameters(expectedElementTypes, actualElementTypes, context);
    }

    private static boolean matchTypeParameters(@NotNull List<PyType> expectedTypeParameters, @NotNull List<PyType> actualTypeParameters, @NotNull MatchContext context) {
        PyTypeParameterMapping mapping;
        if (expectedTypeParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(140);
        }
        if (actualTypeParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(141);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(142);
        }
        if ((mapping = PyTypeParameterMapping.mapByShape(expectedTypeParameters, actualTypeParameters, PyTypeParameterMapping.Option.USE_DEFAULTS)) == null) {
            return false;
        }
        for (Couple<PyType> pair : mapping.getMappedTypes()) {
            Optional<Boolean> matched = context.reversedSubstitutions ? PyTypeChecker.match((PyType)pair.getSecond(), (PyType)pair.getFirst(), context) : PyTypeChecker.match((PyType)pair.getFirst(), (PyType)pair.getSecond(), context);
            if (matched.orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean matchNumericTypes(PyType expected, PyType actual) {
        if (expected instanceof PyClassType && actual instanceof PyClassType) {
            String superName = ((PyClassType)expected).getPyClass().getName();
            String subName = ((PyClassType)actual).getPyClass().getName();
            boolean subIsBool = "bool".equals(subName);
            boolean subIsInt = "int".equals(subName);
            boolean subIsLong = "long".equals(subName);
            boolean subIsFloat = "float".equals(subName);
            boolean subIsComplex = "complex".equals(subName);
            if (superName == null || subName == null || superName.equals(subName) || "int".equals(superName) && subIsBool || ("long".equals(superName) || "Integral".equals(superName)) && (subIsBool || subIsInt) || ("float".equals(superName) || "Real".equals(superName)) && (subIsBool || subIsInt || subIsLong) || ("complex".equals(superName) || "Complex".equals(superName)) && (subIsBool || subIsInt || subIsLong || subIsFloat) || "Number".equals(superName) && (subIsBool || subIsInt || subIsLong || subIsFloat || subIsComplex)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnknown(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(143);
        }
        return PyTypeChecker.isUnknown(type, true, context);
    }

    public static boolean isUnknown(@Nullable PyType type, boolean genericsAreUnknown, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(144);
        }
        if (type == null || genericsAreUnknown && type instanceof PyTypeParameterType) {
            return true;
        }
        if (type instanceof PyFunctionType && (callable = ((PyFunctionType)type).getCallable()) instanceof PyDecoratable && PyKnownDecoratorUtil.hasChangingReturnTypeDecorator((PyDecoratable)callable, context)) {
            return true;
        }
        if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            if (!PyUnionType.isStrictSemanticsEnabled()) {
                return ContainerUtil.exists(union.getMembers(), member -> PyTypeChecker.isUnknown(member, genericsAreUnknown, context));
            }
            return ContainerUtil.all(union.getMembers(), member -> PyTypeChecker.isUnknown(member, genericsAreUnknown, context));
        }
        if (type instanceof PyUnsafeUnionType) {
            PyUnsafeUnionType weakUnion = (PyUnsafeUnionType)type;
            return ContainerUtil.exists(weakUnion.getMembers(), member -> PyTypeChecker.isUnknown(member, genericsAreUnknown, context));
        }
        return false;
    }

    @NotNull
    public static GenericSubstitutions getSubstitutionsWithUnresolvedReturnGenerics(@NotNull Collection<PyCallableParameter> parameters, @Nullable PyType returnType, @Nullable GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        boolean isAlreadyBound;
        boolean canGetBoundFromArguments;
        if (parameters == null) {
            PyTypeChecker.$$$reportNull$$$0(145);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(146);
        }
        GenericSubstitutions existingSubstitutions = substitutions == null ? new GenericSubstitutions() : substitutions;
        Generics typeParamsFromReturnType = PyTypeChecker.collectGenerics(returnType, context);
        if (typeParamsFromReturnType.typeVars.isEmpty() && typeParamsFromReturnType.paramSpecs.isEmpty()) {
            GenericSubstitutions genericSubstitutions = existingSubstitutions;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(147);
            }
            return genericSubstitutions;
        }
        Generics typeParamsFromParameterTypes = new Generics();
        for (PyCallableParameter parameter : parameters) {
            PyTypeChecker.collectGenerics(parameter.getArgumentType(context), context, typeParamsFromParameterTypes);
        }
        for (PyTypeVarType returnTypeParam : typeParamsFromReturnType.typeVars) {
            canGetBoundFromArguments = typeParamsFromParameterTypes.typeVars.contains(returnTypeParam) || typeParamsFromParameterTypes.typeVars.contains(PyTypeChecker.invert(returnTypeParam));
            boolean bl = isAlreadyBound = existingSubstitutions.typeVars.containsKey(returnTypeParam) || existingSubstitutions.typeVars.containsKey(PyTypeChecker.invert(returnTypeParam));
            if (!canGetBoundFromArguments || isAlreadyBound) continue;
            existingSubstitutions.typeVars.put(returnTypeParam, (Ref<PyType>)returnTypeParam.getDefaultType());
        }
        for (PyParamSpecType paramSpecType : typeParamsFromReturnType.paramSpecs) {
            canGetBoundFromArguments = typeParamsFromParameterTypes.paramSpecs.contains(paramSpecType);
            isAlreadyBound = existingSubstitutions.paramSpecs.containsKey(paramSpecType);
            if (!canGetBoundFromArguments || isAlreadyBound) continue;
            if (paramSpecType.getDefaultType() != null) {
                existingSubstitutions.paramSpecs.put(paramSpecType, (PyCallableParameterVariadicType)Ref.deref(paramSpecType.getDefaultType()));
                continue;
            }
            existingSubstitutions.paramSpecs.put(paramSpecType, (PyCallableParameterVariadicType)new PyCallableParameterListTypeImpl(List.of(PyCallableParameterImpl.positionalNonPsi("args", null), PyCallableParameterImpl.keywordNonPsi("kwargs", null))));
        }
        GenericSubstitutions genericSubstitutions = existingSubstitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(148);
        }
        return genericSubstitutions;
    }

    @NotNull
    private static <T extends PyInstantiableType<T>> T invert(@NotNull PyInstantiableType<T> instantiable) {
        if (instantiable == null) {
            PyTypeChecker.$$$reportNull$$$0(149);
        }
        PyInstantiableType pyInstantiableType = instantiable.isDefinition() ? instantiable.toInstance() : instantiable.toClass();
        if (pyInstantiableType == null) {
            PyTypeChecker.$$$reportNull$$$0(150);
        }
        return (T)pyInstantiableType;
    }

    public static boolean hasGenerics(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(151);
        }
        return !PyTypeChecker.collectGenerics(type, context).isEmpty();
    }

    @ApiStatus.Internal
    @NotNull
    public static Generics collectGenerics(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(152);
        }
        Generics result = new Generics();
        PyTypeChecker.collectGenerics(type, context, result);
        Generics generics = result;
        if (generics == null) {
            PyTypeChecker.$$$reportNull$$$0(153);
        }
        return generics;
    }

    private static void collectGenerics(@Nullable PyType type, @NotNull TypeEvalContext context, final @NotNull Generics generics) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(154);
        }
        if (generics == null) {
            PyTypeChecker.$$$reportNull$$$0(155);
        }
        PyRecursiveTypeVisitor.traverse(type, context, new PyRecursiveTypeVisitor.PyTypeTraverser(){

            @NotNull
            public PyRecursiveTypeVisitor.Traversal visitPyTypeVarType(@NotNull PyTypeVarType typeVarType) {
                if (typeVarType == null) {
                    1.$$$reportNull$$$0(0);
                }
                generics.typeVars.add(typeVarType);
                PyRecursiveTypeVisitor.Traversal traversal = (PyRecursiveTypeVisitor.Traversal)((Object)super.visitPyTypeVarType(typeVarType));
                if (traversal == null) {
                    1.$$$reportNull$$$0(1);
                }
                return traversal;
            }

            @NotNull
            public PyRecursiveTypeVisitor.Traversal visitPyTypeVarTupleType(@NotNull PyTypeVarTupleType typeVarTupleType) {
                if (typeVarTupleType == null) {
                    1.$$$reportNull$$$0(2);
                }
                generics.typeVarTuples.add(typeVarTupleType);
                PyRecursiveTypeVisitor.Traversal traversal = (PyRecursiveTypeVisitor.Traversal)((Object)super.visitPyTypeVarTupleType(typeVarTupleType));
                if (traversal == null) {
                    1.$$$reportNull$$$0(3);
                }
                return traversal;
            }

            @Override
            @NotNull
            public PyRecursiveTypeVisitor.Traversal visitPySelfType(@NotNull PySelfType selfType) {
                if (selfType == null) {
                    1.$$$reportNull$$$0(4);
                }
                generics.self = selfType;
                PyRecursiveTypeVisitor.Traversal traversal = (PyRecursiveTypeVisitor.Traversal)((Object)super.visitPySelfType(selfType));
                if (traversal == null) {
                    1.$$$reportNull$$$0(5);
                }
                return traversal;
            }

            @Override
            @NotNull
            public PyRecursiveTypeVisitor.Traversal visitPyParamSpecType(@NotNull PyParamSpecType paramSpecType) {
                if (paramSpecType == null) {
                    1.$$$reportNull$$$0(6);
                }
                generics.paramSpecs.add(paramSpecType);
                PyRecursiveTypeVisitor.Traversal traversal = (PyRecursiveTypeVisitor.Traversal)((Object)super.visitPyParamSpecType(paramSpecType));
                if (traversal == null) {
                    1.$$$reportNull$$$0(7);
                }
                return traversal;
            }

            @NotNull
            public PyRecursiveTypeVisitor.Traversal visitPyTypeParameterType(@NotNull PyTypeParameterType typeParameterType) {
                if (typeParameterType == null) {
                    1.$$$reportNull$$$0(8);
                }
                generics.allTypeParameters.add(typeParameterType);
                PyRecursiveTypeVisitor.Traversal traversal = PyRecursiveTypeVisitor.Traversal.PRUNE;
                if (traversal == null) {
                    1.$$$reportNull$$$0(9);
                }
                return traversal;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5, 7, 9 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeVarType";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeVarTupleType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selfType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "paramSpecType";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeParameterType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitPyTypeVarType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitPyTypeVarTupleType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitPySelfType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitPyParamSpecType";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitPyTypeParameterType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyTypeVarType";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyTypeVarTupleType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPySelfType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyParamSpecType";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyTypeParameterType";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5, 7, 9 -> new IllegalStateException(string);
                };
            }
        });
    }

    @Nullable
    public static PyType substitute(@Nullable PyType type, final @NotNull GenericSubstitutions substitutions, final @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(156);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(157);
        }
        return PyCloningTypeVisitor.clone(type, new PyCloningTypeVisitor(context){

            private static @NotNull List<@Nullable PyType> flattenUnpackedTuple(@Nullable PyType type) {
                PyUnpackedTupleType unpackedTupleType;
                if (type instanceof PyUnpackedTupleType && !(unpackedTupleType = (PyUnpackedTupleType)type).isUnbound()) {
                    List list = unpackedTupleType.getElementTypes();
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                List<PyType> list = Collections.singletonList(type);
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            public PyType visitPyUnpackedTupleType(@NotNull PyUnpackedTupleType unpackedTupleType) {
                if (unpackedTupleType == null) {
                    2.$$$reportNull$$$0(2);
                }
                return new PyUnpackedTupleTypeImpl(ContainerUtil.flatMap((Iterable)unpackedTupleType.getElementTypes(), t -> 2.flattenUnpackedTuple(this.clone((PyType)t))), unpackedTupleType.isUnbound());
            }

            @Override
            public PyType visitPyTypeVarTupleType(@NotNull PyTypeVarTupleType typeVarTupleType) {
                if (typeVarTupleType == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (!substitutions.typeVarTuples.containsKey(typeVarTupleType)) {
                    return typeVarTupleType;
                }
                PyPositionalVariadicType substitution = substitutions.typeVarTuples.get(typeVarTupleType);
                if (!typeVarTupleType.equals((Object)substitution) && PyTypeChecker.hasGenerics((PyType)substitution, context)) {
                    return this.clone((PyType)substitution);
                }
                return substitution == null ? PyUnpackedTupleTypeImpl.UNSPECIFIED : substitution;
            }

            @Override
            public PyType visitPyTypeVarType(@NotNull PyTypeVarType typeVarType) {
                Object invertedTypeVar;
                PyInstantiableType invertedSubstitution;
                if (typeVarType == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (!substitutions.typeVars.containsKey(typeVarType) && !substitutions.typeVars.containsKey(PyTypeChecker.invert(typeVarType))) {
                    PyTypeVarType substitution = StreamEx.of(substitutions.typeVars.keySet()).findFirst(typeVarType2 -> typeVarType2.getDeclarationElement() != null && (typeVarType.getScopeOwner() == null || typeVarType2.getScopeOwner() == typeVarType.getScopeOwner()) && typeVarType2.getDeclarationElement().equals((Object)typeVarType.getDeclarationElement())).orElse(null);
                    if (substitution != null) {
                        return this.clone((PyType)substitution);
                    }
                    return typeVarType;
                }
                Ref<PyType> substitutionRef = substitutions.typeVars.get(typeVarType);
                Object substitution = (PyType)Ref.deref(substitutionRef);
                if (substitutionRef == null && (invertedSubstitution = PyUtil.as(Ref.deref(substitutions.typeVars.get(invertedTypeVar = PyTypeChecker.invert(typeVarType))), PyInstantiableType.class)) != null) {
                    substitution = PyTypeChecker.invert(invertedSubstitution);
                }
                if (substitution instanceof PyTypeVarType) {
                    PyTypeVarType typeVarSubstitution = (PyTypeVarType)substitution;
                    PyTypeVarType sameScopeSubstitution = StreamEx.of(substitutions.typeVars.keySet()).findFirst(typeVarType2 -> typeVarType2.getDeclarationElement() != null && typeVarType2.getDeclarationElement().equals((Object)typeVarSubstitution.getDeclarationElement())).orElse(null);
                    if (sameScopeSubstitution != null && typeVarSubstitution.getDefaultType() != null) {
                        return this.clone((PyType)sameScopeSubstitution);
                    }
                }
                if (!typeVarType.equals(substitution) && PyTypeChecker.hasGenerics(substitution, context)) {
                    return this.clone((PyType)substitution);
                }
                return substitution;
            }

            @Override
            public PyType visitPyParamSpecType(@NotNull PyParamSpecType paramSpecType) {
                if (paramSpecType == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (!substitutions.paramSpecs.containsKey(paramSpecType)) {
                    PyParamSpecType sameScopeSubstitution = StreamEx.of(substitutions.paramSpecs.keySet()).findFirst(typeVarType -> typeVarType.getDeclarationElement() != null && typeVarType.getDeclarationElement().equals((Object)paramSpecType.getDeclarationElement())).orElse(null);
                    if (sameScopeSubstitution != null) {
                        return this.clone((PyType)sameScopeSubstitution);
                    }
                    return paramSpecType;
                }
                PyCallableParameterVariadicType substitution = substitutions.paramSpecs.get(paramSpecType);
                if (substitution != null && !substitution.equals((Object)paramSpecType) && PyTypeChecker.hasGenerics((PyType)substitution, context)) {
                    return this.clone((PyType)substitution);
                }
                return substitution;
            }

            @Override
            public PyType visitPySelfType(@NotNull PySelfType selfType) {
                if (selfType == null) {
                    2.$$$reportNull$$$0(6);
                }
                PyType qualifierType = substitutions.qualifierType;
                PyClassLikeType selfScopeClassType = selfType.getScopeClassType();
                if (qualifierType == null) {
                    return selfType;
                }
                return (PyType)((StreamEx)PyTypeUtil.toStream(qualifierType).filter(memberType -> PyTypeChecker.match((PyType)selfScopeClassType, memberType, context))).collect(PyTypeUtil.toUnion(qualifierType));
            }

            @Override
            public PyType visitPyGenericType(@NotNull PyCollectionType genericType) {
                if (genericType == null) {
                    2.$$$reportNull$$$0(7);
                }
                return new PyCollectionTypeImpl(genericType.getPyClass(), genericType.isDefinition(), ContainerUtil.flatMap(genericType.getElementTypes(), t -> 2.flattenUnpackedTuple(this.clone((PyType)t))));
            }

            @Override
            public PyType visitPyTupleType(@NotNull PyTupleType tupleType) {
                if (tupleType == null) {
                    2.$$$reportNull$$$0(8);
                }
                PyClass tupleClass = tupleType.getPyClass();
                List<PyType> oldElementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
                return new PyTupleType(tupleClass, ContainerUtil.flatMap(oldElementTypes, elementType -> 2.flattenUnpackedTuple(this.clone((PyType)elementType))), tupleType.isHomogeneous());
            }

            @Override
            public PyType visitPyFunctionType(@NotNull PyFunctionType functionType) {
                if (functionType == null) {
                    2.$$$reportNull$$$0(9);
                }
                if (PyTypeChecker.hasGenerics((PyType)functionType, context)) {
                    return super.visitPyFunctionType(functionType);
                }
                return functionType;
            }

            @Override
            public PyType visitPyCallableType(@NotNull PyCallableType callableType) {
                List<PyCallableParameter> list;
                PyCallableParameterListTypeImpl parametersSubs;
                List parameters;
                if (callableType == null) {
                    2.$$$reportNull$$$0(10);
                }
                if ((parameters = callableType.getParameters(context)) != null) {
                    PyType pyType;
                    PyCallableParameter onlyParam = (PyCallableParameter)ContainerUtil.getOnlyItem((Collection)parameters);
                    if (onlyParam != null && (pyType = onlyParam.getType(context)) instanceof PyParamSpecType) {
                        PyParamSpecType paramSpecType = (PyParamSpecType)pyType;
                        parametersSubs = (PyCallableParameterListTypeImpl)this.clone((PyType)paramSpecType);
                    } else if (onlyParam != null && (pyType = onlyParam.getType(context)) instanceof PyConcatenateType) {
                        PyConcatenateType concatenateType = (PyConcatenateType)pyType;
                        parametersSubs = (PyCallableParameterListTypeImpl)this.clone((PyType)concatenateType);
                    } else {
                        parametersSubs = new PyCallableParameterListTypeImpl(StreamEx.of((Collection)parameters).mapToEntry(param -> param.getType(context)).flatMapKeyValue((param, paramType) -> {
                            PyParameter paramPsi = param.getParameter();
                            return StreamEx.of(Collections.singletonList(param.getType(context))).flatCollection(t -> 2.flattenUnpackedTuple(this.clone((PyType)t))).map(paramSubType -> paramPsi != null ? PyCallableParameterImpl.psi(paramPsi, paramSubType) : PyCallableParameterImpl.nonPsi(param.getName(), paramSubType, param.getDefaultValue()));
                        }).toList());
                    }
                } else {
                    parametersSubs = null;
                }
                if (parametersSubs instanceof PyCallableParameterListType) {
                    PyCallableParameterListType parameterList = parametersSubs;
                    list = parameterList.getParameters();
                } else if (parametersSubs instanceof PyConcatenateType) {
                    PyConcatenateType concat = (PyConcatenateType)((Object)parametersSubs);
                    list = List.of(PyCallableParameterImpl.nonPsi((PyType)concat));
                } else if (parametersSubs instanceof PyParamSpecType) {
                    PyParamSpecType paramSpec = (PyParamSpecType)((Object)parametersSubs);
                    list = List.of(PyCallableParameterImpl.nonPsi((PyType)paramSpec));
                } else {
                    list = null;
                }
                return new PyCallableTypeImpl(list, (PyType)this.clone(callableType.getReturnType(context)));
            }

            @Override
            public PyCallableParameterVariadicType visitPyConcatenateType(@NotNull PyConcatenateType concatenateType) {
                if (concatenateType == null) {
                    2.$$$reportNull$$$0(11);
                }
                List firstParamTypeSubs = ContainerUtil.flatMap(concatenateType.getFirstTypes(), t -> 2.flattenUnpackedTuple(this.clone((PyType)t)));
                PyCallableParameterVariadicType paramSpecSubs = (PyCallableParameterVariadicType)this.clone((PyType)concatenateType.getParamSpec());
                if (paramSpecSubs instanceof PyCallableParameterListType) {
                    PyCallableParameterListType callableParams = (PyCallableParameterListType)paramSpecSubs;
                    return new PyCallableParameterListTypeImpl(StreamEx.of((Collection)firstParamTypeSubs).map(PyCallableParameterImpl::nonPsi).append((Collection)callableParams.getParameters()).toList());
                }
                if (paramSpecSubs instanceof PyParamSpecType) {
                    PyParamSpecType paramSpecType = (PyParamSpecType)paramSpecSubs;
                    return new PyConcatenateType(firstParamTypeSubs, paramSpecType);
                }
                if (paramSpecSubs instanceof PyConcatenateType) {
                    PyConcatenateType concatenateType2 = (PyConcatenateType)paramSpecSubs;
                    return new PyConcatenateType(ContainerUtil.concat((List)firstParamTypeSubs, concatenateType2.getFirstTypes()), concatenateType2.getParamSpec());
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "unpackedTupleType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeVarTupleType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeVarType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "paramSpecType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selfType";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "genericType";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tupleType";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionType";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callableType";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "concatenateType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "flattenUnpackedTuple";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyUnpackedTupleType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyTypeVarTupleType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyTypeVarType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyParamSpecType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPySelfType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyGenericType";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyTupleType";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyFunctionType";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyCallableType";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyConcatenateType";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
                };
            }
        });
    }

    @Nullable
    public static GenericSubstitutions unifyGenericCall(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(158);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(159);
        }
        GenericSubstitutions substitutions = PyTypeChecker.unifyReceiver(receiver, context);
        for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType promotedToLiteral;
            PyType actualType;
            PyType expectedType;
            PyCallableParameter paramWrapper = entry.getValue();
            boolean matchedByTypes = PyTypeChecker.matchParameterArgumentTypes(paramWrapper, expectedType = paramWrapper.getArgumentType(context), actualType = (promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(entry.getKey(), expectedType, context, substitutions)) != null ? promotedToLiteral : context.getType((PyTypedElement)entry.getKey()), substitutions, context);
            if (matchedByTypes) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedPositionalContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), substitutions, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedKeywordContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), substitutions, context)) {
            return null;
        }
        return substitutions;
    }

    @Nullable
    public static GenericSubstitutions unifyGenericCallOnArgumentTypes(@Nullable PyType receiverType, @NotNull Map<Ref<PyType>, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(160);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(161);
        }
        GenericSubstitutions substitutions = PyTypeChecker.unifyReceiver(receiverType, context);
        for (Map.Entry<Ref<PyType>, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType actualType;
            PyType expectedType;
            PyCallableParameter paramWrapper = entry.getValue();
            boolean matchedByTypes = PyTypeChecker.matchParameterArgumentTypes(paramWrapper, expectedType = paramWrapper.getArgumentType(context), actualType = (PyType)Ref.deref(entry.getKey()), substitutions, context);
            if (matchedByTypes) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainerByType(PyCallExpressionHelper.getMappedPositionalContainer(arguments), ContainerUtil.map(PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), Ref::deref), substitutions, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainerByType(PyCallExpressionHelper.getMappedKeywordContainer(arguments), ContainerUtil.map(PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), Ref::deref), substitutions, context)) {
            return null;
        }
        return substitutions;
    }

    @Nullable
    private static PyType processSelfParameter(@NotNull PyCallableParameter paramWrapper, @Nullable PyType expectedType, @Nullable PyType actualType, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (paramWrapper == null) {
            PyTypeChecker.$$$reportNull$$$0(162);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(163);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(164);
        }
        PyParameter param = paramWrapper.getParameter();
        PyFunction function = PyUtil.as(ScopeUtil.getScopeOwner((PsiElement)param), PyFunction.class);
        assert (function != null);
        if (function.getModifier() == PyAstFunction.Modifier.CLASSMETHOD) {
            actualType = PyTypeUtil.toStream(actualType).select(PyClassLikeType.class).map(PyInstantiableType::toClass).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
        } else if (PyUtil.isInitMethod((PsiElement)function)) {
            actualType = PyTypeUtil.toStream(actualType).select(PyInstantiableType.class).map(PyInstantiableType::toInstance).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
        }
        if (PyUnionType.isStrictSemanticsEnabled()) {
            PyClass pyClass = function.getContainingClass();
            assert (pyClass != null);
            PyClassLikeType classType = PyUtil.as(context.getType((PyTypedElement)pyClass), PyClassLikeType.class);
            assert (classType != null);
            PyClassLikeType superType = function.getModifier() == PyAstFunction.Modifier.CLASSMETHOD || PyUtil.isNewMethod((PsiElement)function) ? classType : (PyClassLikeType)classType.toInstance();
            actualType = (PyType)((StreamEx)PyTypeUtil.toStream(actualType).filter(type -> PyTypeChecker.match((PyType)superType, type, context))).collect(PyTypeUtil.toUnion(actualType));
        }
        PyClass containingClass = function.getContainingClass();
        assert (containingClass != null);
        PyCollectionType genericClass = PyTypeChecker.findGenericDefinitionType(containingClass, context);
        if (genericClass instanceof PyInstantiableType) {
            PyInstantiableType instantiableType = (PyInstantiableType)genericClass;
            if (PyUtil.isNewMethod((PsiElement)function) || function.getModifier() == PyAstFunction.Modifier.CLASSMETHOD) {
                genericClass = instantiableType.toClass();
            }
        }
        if (genericClass != null && !PyTypeChecker.match((PyType)genericClass, expectedType, context, substitutions)) {
            return null;
        }
        return actualType;
    }

    private static boolean matchParameterArgumentTypes(@NotNull PyCallableParameter paramWrapper, @Nullable PyType expectedType, @Nullable PyType actualType, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (paramWrapper == null) {
            PyTypeChecker.$$$reportNull$$$0(165);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(166);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(167);
        }
        if (paramWrapper.isSelf() && (actualType = PyTypeChecker.processSelfParameter(paramWrapper, expectedType, actualType, substitutions, context)) == null) {
            return false;
        }
        return PyTypeChecker.match(expectedType, actualType, context, substitutions);
    }

    private static boolean matchContainer(@Nullable PyCallableParameter container, @NotNull List<? extends PyExpression> arguments, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(168);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(169);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(170);
        }
        if (container == null) {
            return true;
        }
        List actualArgumentTypes = ContainerUtil.map(arguments, arg_0 -> ((TypeEvalContext)context).getType(arg_0));
        return PyTypeChecker.matchContainerByType(container, actualArgumentTypes, substitutions, context);
    }

    private static boolean matchContainerByType(@Nullable PyCallableParameter container, @NotNull List<PyType> actualArgumentTypes, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (actualArgumentTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(171);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(172);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(173);
        }
        if (container == null) {
            return true;
        }
        PyType expectedArgumentType = container.getArgumentType(context);
        if (container.isPositionalContainer() && expectedArgumentType instanceof PyPositionalVariadicType) {
            PyPositionalVariadicType variadicType = (PyPositionalVariadicType)expectedArgumentType;
            return PyTypeChecker.match(variadicType, (PyType)PyUnpackedTupleTypeImpl.create(actualArgumentTypes), new MatchContext(context, substitutions, false));
        }
        return PyTypeChecker.match(expectedArgumentType, PyUnionType.union(actualArgumentTypes), context, substitutions);
    }

    @NotNull
    public static GenericSubstitutions unifyReceiver(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(174);
        }
        if (receiver != null) {
            PyType receiverType = context.getType((PyTypedElement)receiver);
            return PyTypeChecker.unifyReceiver(receiverType, context);
        }
        return new GenericSubstitutions();
    }

    @NotNull
    public static GenericSubstitutions unifyReceiver(@Nullable PyType receiverType, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(175);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions();
        if (receiverType != null) {
            substitutions.qualifierType = receiverType instanceof PyClassType ? ((PyClassType)receiverType).toInstance() : receiverType;
            PyTypeUtil.toStream(receiverType).select(PyClassType.class).map(type -> PyTypeChecker.collectTypeSubstitutions(type, context)).forEach(newSubstitutions -> {
                for (Map.Entry<PyTypeVarType, Ref<PyType>> entry : newSubstitutions.typeVars.entrySet()) {
                    substitutions.typeVars.putIfAbsent(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<PyTypeVarType, Ref<PyType>> entry : newSubstitutions.typeVarTuples.entrySet()) {
                    substitutions.typeVarTuples.putIfAbsent((PyTypeVarTupleType)entry.getKey(), (PyPositionalVariadicType)entry.getValue());
                }
                for (Map.Entry<Object, Object> entry : newSubstitutions.paramSpecs.entrySet()) {
                    substitutions.paramSpecs.putIfAbsent((PyParamSpecType)entry.getKey(), (PyCallableParameterVariadicType)entry.getValue());
                }
            });
        }
        GenericSubstitutions genericSubstitutions = substitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(176);
        }
        return genericSubstitutions;
    }

    private static boolean matchClasses(@Nullable PyClass superClass, @Nullable PyClass subClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(177);
        }
        if (superClass == null || subClass == null || subClass.isSubclass(superClass, context) || PyABCUtil.isSubclass(subClass, superClass, context) || PyTypeChecker.isStrUnicodeMatch(subClass, superClass) || PyTypeChecker.isBytearrayBytesStringMatch(subClass, superClass) || PyUtil.hasUnresolvedAncestors(subClass, context)) {
            return true;
        }
        String superName = superClass.getName();
        return superName != null && superName.equals(subClass.getName());
    }

    private static boolean isStrUnicodeMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(178);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(179);
        }
        return "str".equals(subClass.getName()) && "unicode".equals(superClass.getName());
    }

    private static boolean isBytearrayBytesStringMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(180);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(181);
        }
        if (!"bytearray".equals(subClass.getName())) {
            return false;
        }
        PsiFile subClassFile = subClass.getContainingFile();
        boolean isPy2 = subClassFile instanceof PyiFile ? PythonRuntimeService.getInstance().getLanguageLevelForSdk(PythonSdkUtil.findPythonSdk((PsiElement)subClassFile)).isPython2() : LanguageLevel.forElement((PsiElement)subClass).isPython2();
        String superClassName = superClass.getName();
        return isPy2 && "str".equals(superClassName) || !isPy2 && "bytes".equals(superClassName);
    }

    @Nullable
    public static Boolean isCallable(@Nullable PyType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType) {
            return PyTypeChecker.isUnionCallable((PyUnionType)type);
        }
        if (type instanceof PyCallableType) {
            return ((PyCallableType)type).isCallable();
        }
        if (type instanceof PyStructuralType && ((PyStructuralType)type).isInferredFromUsages()) {
            return true;
        }
        if (type instanceof PyTypeVarType) {
            PyTypeVarType typeVarType = (PyTypeVarType)type;
            if (typeVarType.isDefinition()) {
                return true;
            }
            return PyTypeChecker.isCallable(PyTypeUtil.getEffectiveBound(typeVarType));
        }
        return false;
    }

    @Nullable
    private static Boolean isUnionCallable(@NotNull PyUnionType type) {
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(182);
        }
        for (PyType member : type.getMembers()) {
            Boolean callable = PyTypeChecker.isCallable(member);
            if (callable == null) {
                return null;
            }
            if (!callable.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean definesGetAttr(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        PyType type;
        if (file == null) {
            PyTypeChecker.$$$reportNull$$$0(183);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(184);
        }
        if (file instanceof PyTypedElement && (type = context.getType((PyTypedElement)file)) != null) {
            return PyTypeChecker.resolveTypeMember(type, "__getattr__", context) != null;
        }
        return false;
    }

    public static boolean overridesGetAttr(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyType type;
        if (cls == null) {
            PyTypeChecker.$$$reportNull$$$0(185);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(186);
        }
        if ((type = context.getType((PyTypedElement)cls)) != null) {
            if (PyTypeChecker.resolveTypeMember(type, "__getattr__", context) != null) {
                return true;
            }
            PsiElement method = PyTypeChecker.resolveTypeMember(type, "__getattribute__", context);
            if (method != null && !PyBuiltinCache.getInstance((PsiElement)cls).isBuiltin(method)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement resolveTypeMember(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List results;
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(187);
        }
        if (name == null) {
            PyTypeChecker.$$$reportNull$$$0(188);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(189);
        }
        return !ContainerUtil.isEmpty((Collection)(results = type.resolveMember(name, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context)))) ? ((RatedResolveResult)results.get(0)).getElement() : null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyExpression target, @NotNull PySequenceExpression parentTupleOrList, @NotNull PyTupleType assignedTupleType) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(190);
        }
        if (parentTupleOrList == null) {
            PyTypeChecker.$$$reportNull$$$0(191);
        }
        if (assignedTupleType == null) {
            PyTypeChecker.$$$reportNull$$$0(192);
        }
        int count = assignedTupleType.getElementCount();
        Object[] elements = parentTupleOrList.getElements();
        if (elements.length == count || assignedTupleType.isHomogeneous()) {
            int index = ArrayUtil.indexOf((Object[])elements, (Object)target);
            if (index >= 0) {
                return assignedTupleType.getElementType(index);
            }
            for (int i = 0; i < count; ++i) {
                PyTupleType nestedAssignedTupleType;
                PyType result;
                PyType elementType;
                PyExpression element = PyPsiUtils.flattenParens((PyExpression)elements[i]);
                if (!(element instanceof PyTupleExpression) && !(element instanceof PyListLiteralExpression) || !((elementType = assignedTupleType.getElementType(i)) instanceof PyTupleType) || (result = PyTypeChecker.getTargetTypeFromTupleAssignment(target, (PySequenceExpression)element, nestedAssignedTupleType = (PyTupleType)elementType)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType parameterizeType(@NotNull PyType genericType, @NotNull List<PyType> actualTypeParams, @NotNull TypeEvalContext context) {
        Generics typeParams;
        if (genericType == null) {
            PyTypeChecker.$$$reportNull$$$0(193);
        }
        if (actualTypeParams == null) {
            PyTypeChecker.$$$reportNull$$$0(194);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(195);
        }
        if (!(typeParams = PyTypeChecker.collectGenerics(genericType, context)).isEmpty()) {
            ArrayList<PyTypeParameterType> expectedTypeParams = new ArrayList<PyTypeParameterType>(new LinkedHashSet<PyTypeParameterType>(typeParams.getAllTypeParameters()));
            GenericSubstitutions substitutions = PyTypeChecker.mapTypeParametersToSubstitutions(expectedTypeParams, actualTypeParams, PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY, PyTypeParameterMapping.Option.USE_DEFAULTS);
            if (substitutions == null) {
                return null;
            }
            return PyTypeChecker.substitute(genericType, substitutions, context);
        }
        if (genericType instanceof PyCollectionType) {
            return genericType;
        }
        if (genericType instanceof PyClassType) {
            PyClass cls = ((PyClassType)genericType).getPyClass();
            return new PyCollectionTypeImpl(cls, false, actualTypeParams);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static GenericSubstitutions mapTypeParametersToSubstitutions(@NotNull List<? extends PyType> expectedTypes, @NotNull List<? extends PyType> actualTypes, PyTypeParameterMapping.Option ... options) {
        if (expectedTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(196);
        }
        if (actualTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(197);
        }
        if (options == null) {
            PyTypeChecker.$$$reportNull$$$0(198);
        }
        return PyTypeChecker.mapTypeParametersToSubstitutions(new GenericSubstitutions(), expectedTypes, actualTypes, options);
    }

    @Nullable
    private static GenericSubstitutions mapTypeParametersToSubstitutions(@NotNull GenericSubstitutions substitutions, @NotNull List<? extends PyType> expectedTypes, @NotNull List<? extends PyType> actualTypes, PyTypeParameterMapping.Option ... options) {
        PyTypeParameterMapping mapping;
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(199);
        }
        if (expectedTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(200);
        }
        if (actualTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(201);
        }
        if (options == null) {
            PyTypeChecker.$$$reportNull$$$0(202);
        }
        if ((mapping = PyTypeParameterMapping.mapByShape(expectedTypes, actualTypes, options)) != null) {
            for (Couple<PyType> pair : mapping.getMappedTypes()) {
                Object object = pair.getFirst();
                if (object instanceof PyTypeVarType) {
                    PyTypeVarType typeVar = (PyTypeVarType)object;
                    substitutions.typeVars.put(typeVar, (Ref<PyType>)Ref.create((Object)((PyType)pair.getSecond())));
                    continue;
                }
                object = pair.getFirst();
                if (object instanceof PyTypeVarTupleType) {
                    PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)object;
                    substitutions.typeVarTuples.put(typeVarTuple, PyUtil.as(pair.getSecond(), PyPositionalVariadicType.class));
                    continue;
                }
                object = pair.getFirst();
                if (!(object instanceof PyParamSpecType)) continue;
                PyParamSpecType paramSpec = (PyParamSpecType)object;
                substitutions.paramSpecs.put(paramSpec, PyUtil.as(pair.getSecond(), PyCallableParameterVariadicType.class));
            }
            return substitutions;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType convertToType(@Nullable PyType type, @NotNull PyClassType superType, @NotNull TypeEvalContext context) {
        MatchContext matchContext;
        Optional<Boolean> matched;
        if (superType == null) {
            PyTypeChecker.$$$reportNull$$$0(203);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(204);
        }
        if ((matched = PyTypeChecker.match((PyType)superType, type, matchContext = new MatchContext(context, new GenericSubstitutions(), false))).orElse(false).booleanValue()) {
            return PyTypeChecker.substitute((PyType)superType, matchContext.mySubstitutions, context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 37, 38, 39, 59, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 89, 90, 91, 92, 93, 114, 115, 116, 117, 118, 119, 133, 134, 147, 148, 150, 153, 176 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVars";
                break;
            }
            case 4: 
            case 156: 
            case 163: 
            case 166: 
            case 169: 
            case 172: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 59: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 133: 
            case 134: 
            case 147: 
            case 148: 
            case 150: 
            case 153: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 36: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 50: 
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 81: 
            case 86: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 105: 
            case 111: 
            case 120: 
            case 123: 
            case 128: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 48: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedParameters";
                break;
            }
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 67: 
            case 82: 
            case 87: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 106: 
            case 112: 
            case 121: 
            case 125: 
            case 129: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 68: 
            case 83: 
            case 110: 
            case 113: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchContext";
                break;
            }
            case 84: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeParameters";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParameters";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiable";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 158: 
            case 160: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 162: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramWrapper";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualArgumentTypes";
                break;
            }
            case 178: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 179: 
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 182: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTupleOrList";
                break;
            }
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTupleType";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParams";
                break;
            }
            case 196: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 197: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypes";
                break;
            }
            case 198: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 6: 
            case 34: 
            case 35: 
            case 59: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "matchImpl";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "matchObject";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeSubstitutions";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGenerics";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 59: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 133: 
            case 134: 
            case 147: 
            case 148: 
            case 150: 
            case 153: 
            case 176: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchImpl";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "matchObject";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "matchProtocols";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "dropSelfIfNeeded";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "matchCallableParameters";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isCallableProtocol";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getActualReturnType";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "widenUnionOfTuplesToTupleOfUnions";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "matchGenerics";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeSubstitutions";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "findGenericDefinitionType";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericClassesParameterWise";
                break;
            }
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeParameters";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "invert";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "hasGenerics";
                break;
            }
            case 152: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "collectGenerics";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCall";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCallOnArgumentTypes";
                break;
            }
            case 162: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "processSelfParameter";
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "matchParameterArgumentTypes";
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "matchContainer";
                break;
            }
            case 171: 
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "matchContainerByType";
                break;
            }
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "unifyReceiver";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "matchClasses";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "isStrUnicodeMatch";
                break;
            }
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "isBytearrayBytesStringMatch";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "isUnionCallable";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "definesGetAttr";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "overridesGetAttr";
                break;
            }
            case 187: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeMember";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromTupleAssignment";
                break;
            }
            case 193: 
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "parameterizeType";
                break;
            }
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "mapTypeParametersToSubstitutions";
                break;
            }
            case 203: 
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "convertToType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 37, 38, 39, 59, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 89, 90, 91, 92, 93, 114, 115, 116, 117, 118, 119, 133, 134, 147, 148, 150, 153, 176 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Experimental
    public static class GenericSubstitutions {
        private final @NotNull Map<PyTypeVarType, @Nullable Ref<@Nullable PyType>> typeVars;
        private final @NotNull Map<PyTypeVarTupleType, @Nullable PyPositionalVariadicType> typeVarTuples;
        private final @NotNull Map<PyParamSpecType, @Nullable PyCallableParameterVariadicType> paramSpecs;
        @Nullable
        private PyType qualifierType;

        public GenericSubstitutions(@NotNull Map<? extends PyTypeParameterType, PyType> typeParameters) {
            if (typeParameters == null) {
                GenericSubstitutions.$$$reportNull$$$0(0);
            }
            this(EntryStream.of(typeParameters).selectKeys(PyTypeVarType.class).mapValues(Ref::create).toCustomMap(LinkedHashMap::new), EntryStream.of(typeParameters).selectKeys(PyTypeVarTupleType.class).selectValues(PyPositionalVariadicType.class).toCustomMap(LinkedHashMap::new), EntryStream.of(typeParameters).selectKeys(PyParamSpecType.class).selectValues(PyCallableParameterVariadicType.class).toCustomMap(LinkedHashMap::new), null);
        }

        public GenericSubstitutions() {
            this(new LinkedHashMap<PyTypeVarType, Ref<PyType>>(), new LinkedHashMap<PyTypeVarTupleType, PyPositionalVariadicType>(), new LinkedHashMap<PyParamSpecType, PyCallableParameterVariadicType>(), null);
        }

        private GenericSubstitutions(@NotNull Map<PyTypeVarType, Ref<PyType>> typeVars, @NotNull Map<PyTypeVarTupleType, PyPositionalVariadicType> typeVarTuples, @NotNull Map<PyParamSpecType, PyCallableParameterVariadicType> paramSpecs, @Nullable PyType qualifierType) {
            if (typeVars == null) {
                GenericSubstitutions.$$$reportNull$$$0(1);
            }
            if (typeVarTuples == null) {
                GenericSubstitutions.$$$reportNull$$$0(2);
            }
            if (paramSpecs == null) {
                GenericSubstitutions.$$$reportNull$$$0(3);
            }
            this.typeVars = typeVars;
            this.typeVarTuples = typeVarTuples;
            this.paramSpecs = paramSpecs;
            this.qualifierType = qualifierType;
        }

        @NotNull
        public Map<PyParamSpecType, PyCallableParameterVariadicType> getParamSpecs() {
            Map<PyParamSpecType, PyCallableParameterVariadicType> map = Collections.unmodifiableMap(this.paramSpecs);
            if (map == null) {
                GenericSubstitutions.$$$reportNull$$$0(4);
            }
            return map;
        }

        @NotNull
        public Map<PyTypeVarType, Ref<PyType>> getTypeVars() {
            Map<PyTypeVarType, Ref<PyType>> map = Collections.unmodifiableMap(this.typeVars);
            if (map == null) {
                GenericSubstitutions.$$$reportNull$$$0(5);
            }
            return map;
        }

        @NotNull
        public Map<PyTypeVarTupleType, PyPositionalVariadicType> getTypeVarTuples() {
            Map<PyTypeVarTupleType, PyPositionalVariadicType> map = Collections.unmodifiableMap(this.typeVarTuples);
            if (map == null) {
                GenericSubstitutions.$$$reportNull$$$0(6);
            }
            return map;
        }

        @Nullable
        public PyType getQualifierType() {
            return this.qualifierType;
        }

        public String toString() {
            return "GenericSubstitutions{typeVars=" + String.valueOf(this.typeVars) + ", typeVarTuples" + String.valueOf(this.typeVarTuples) + ", paramSpecs=" + String.valueOf(this.paramSpecs) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVars";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVarTuples";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpecs";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVars";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVarTuples";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class MatchContext {
        @NotNull
        private final TypeEvalContext context;
        @NotNull
        private final GenericSubstitutions mySubstitutions;
        private final boolean reversedSubstitutions;

        MatchContext(@NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions, boolean reversedSubstitutions) {
            if (context == null) {
                MatchContext.$$$reportNull$$$0(0);
            }
            if (substitutions == null) {
                MatchContext.$$$reportNull$$$0(1);
            }
            this.context = context;
            this.mySubstitutions = substitutions;
            this.reversedSubstitutions = reversedSubstitutions;
        }

        @NotNull
        public MatchContext reverseSubstitutions() {
            return new MatchContext(this.context, this.mySubstitutions, !this.reversedSubstitutions);
        }

        @NotNull
        public MatchContext resetSubstitutions() {
            return new MatchContext(this.context, this.mySubstitutions, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/types/PyTypeChecker$MatchContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class Generics {
        @NotNull
        private final Set<PyTypeVarType> typeVars = new LinkedHashSet<PyTypeVarType>();
        @NotNull
        private final Set<PyTypeVarTupleType> typeVarTuples = new LinkedHashSet<PyTypeVarTupleType>();
        @NotNull
        private final List<PyTypeParameterType> allTypeParameters = new ArrayList<PyTypeParameterType>();
        @NotNull
        private final Set<PyParamSpecType> paramSpecs = new LinkedHashSet<PyParamSpecType>();
        @Nullable
        private PySelfType self;

        @NotNull
        public Set<PyTypeVarType> getTypeVars() {
            Set<PyTypeVarType> set = Collections.unmodifiableSet(this.typeVars);
            if (set == null) {
                Generics.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public Set<PyTypeVarTupleType> getTypeVarTuples() {
            Set<PyTypeVarTupleType> set = Collections.unmodifiableSet(this.typeVarTuples);
            if (set == null) {
                Generics.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public List<PyTypeParameterType> getAllTypeParameters() {
            List<PyTypeParameterType> list = Collections.unmodifiableList(this.allTypeParameters);
            if (list == null) {
                Generics.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public Set<PyParamSpecType> getParamSpecs() {
            Set<PyParamSpecType> set = Collections.unmodifiableSet(this.paramSpecs);
            if (set == null) {
                Generics.$$$reportNull$$$0(3);
            }
            return set;
        }

        public boolean isEmpty() {
            return this.typeVars.isEmpty() && this.typeVarTuples.isEmpty() && this.paramSpecs.isEmpty() && this.self == null;
        }

        public String toString() {
            return "Generics{typeVars=" + String.valueOf(this.typeVars) + ", typeVarTuples" + String.valueOf(this.typeVarTuples) + ", paramSpecs=" + String.valueOf(this.paramSpecs) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/psi/types/PyTypeChecker$Generics";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVars";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVarTuples";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllTypeParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

