/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.sdk.CustomSdkHomePattern;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import com.jetbrains.python.sdk.PyRemoteSdkValidator;
import com.jetbrains.python.sdk.skeleton.PySkeletonHeader;
import com.jetbrains.python.venvReader.VirtualEnvReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PythonSdkUtil {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE = OrderRootType.CLASSES;
    static final String[] WINDOWS_EXECUTABLE_SUFFIXES = new String[]{"cmd", "exe", "bat", "com"};
    private static final Predicate<Sdk> REMOTE_SDK_PREDICATE = PythonSdkUtil::isRemote;
    private static final Key<PySkeletonHeader> CACHED_SKELETON_HEADER = Key.create((String)"CACHED_SKELETON_HEADER");

    public static boolean isPythonSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(0);
        }
        return PythonSdkUtil.isPythonSdk(sdk, false);
    }

    @ApiStatus.Internal
    public static boolean isPythonSdk(@NotNull Sdk sdk, boolean allowRemoteInFreeTier) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(1);
        }
        if (!"Python SDK".equals(sdk.getSdkType().getName())) {
            return false;
        }
        if (PythonSdkUtil.isFreeTier()) {
            return allowRemoteInFreeTier || !PythonSdkUtil.isRemote(sdk);
        }
        return true;
    }

    @ApiStatus.Internal
    public static boolean isFreeTier() {
        return PlatformUtils.isPyCharm() && !PlatformUtils.isDataSpell() && PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    @NotNull
    public static @Unmodifiable @NotNull List<@NotNull Sdk> getAllSdks() {
        return PythonSdkUtil.getAllSdks(false);
    }

    @ApiStatus.Internal
    @NotNull
    public static @Unmodifiable @NotNull List<@NotNull Sdk> getAllSdks(boolean allowRemoteInFreeTier) {
        List list = ContainerUtil.filter((Object[])ProjectJdkTable.getInstance().getAllJdks(), sdk -> PythonSdkUtil.isPythonSdk(sdk, allowRemoteInFreeTier));
        if (list == null) {
            PythonSdkUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static PySkeletonHeader readSkeletonHeader(@NotNull VirtualFile file, @NotNull Sdk pythonSdk) {
        VirtualFile skeletonsDir;
        if (file == null) {
            PythonSdkUtil.$$$reportNull$$$0(3);
        }
        if (pythonSdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(4);
        }
        if ((skeletonsDir = PythonSdkUtil.findSkeletonsDir(pythonSdk)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)file, (boolean)false)) {
            PySkeletonHeader skeletonHeader = (PySkeletonHeader)file.getUserData(CACHED_SKELETON_HEADER);
            if (skeletonHeader == null) {
                skeletonHeader = PySkeletonHeader.readSkeletonHeader(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                file.putUserData(CACHED_SKELETON_HEADER, (Object)skeletonHeader);
            }
            return skeletonHeader;
        }
        return null;
    }

    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk) {
        if (vFile == null) {
            PythonSdkUtil.$$$reportNull$$$0(5);
        }
        if (pythonSdk != null) {
            VirtualFile libDir;
            @Nullable VirtualFile originFile = vFile;
            @NotNull String originPath = vFile.getPath();
            boolean checkOnRemoteFS = false;
            PySkeletonHeader header = PythonSdkUtil.readSkeletonHeader(originFile, pythonSdk);
            if (header != null) {
                if (ApplicationManager.getApplication().isUnitTestMode() && Objects.equals(vFile.getParent(), PythonSdkUtil.findSkeletonsDir(pythonSdk))) {
                    return true;
                }
                String binaryPath = header.getBinaryFile();
                if (binaryPath.equals("(built-in)") || binaryPath.equals("(pre-generated)")) {
                    return true;
                }
                if (PythonSdkUtil.isRemote(pythonSdk)) {
                    checkOnRemoteFS = true;
                    originFile = null;
                } else {
                    originFile = VfsUtil.findFileByIoFile((File)new File(binaryPath), (boolean)true);
                }
                originPath = binaryPath;
            }
            if (originFile != null) {
                originFile = (VirtualFile)ObjectUtils.notNull((Object)originFile.getCanonicalFile(), (Object)originFile);
                originPath = originFile.getPath();
            }
            if ((libDir = PySearchUtilBase.findLibDir(pythonSdk)) != null && PythonSdkUtil.isUnderLibDirButNotSitePackages(originFile, originPath, libDir, pythonSdk, checkOnRemoteFS)) {
                return true;
            }
            VirtualFile venvLibDir = PySearchUtilBase.findVirtualEnvLibDir(pythonSdk);
            if (venvLibDir != null && PythonSdkUtil.isUnderLibDirButNotSitePackages(originFile, originPath, venvLibDir, pythonSdk, checkOnRemoteFS)) {
                return true;
            }
            if (PyTypeShed.INSTANCE.isInStandardLibrary(vFile)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && PythonSdkUtil.isPythonSdk(sdk)) {
            return sdk;
        }
        sdk = PyModuleService.getInstance().findPythonSdk(module);
        if (sdk != null && PythonSdkUtil.isPythonSdk(sdk)) {
            return sdk;
        }
        return null;
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataMarker;
    }

    @NlsSafe
    public static String getUserSite() {
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            return appdata + File.separator + "Python";
        }
        String userHome = SystemProperties.getUserHome();
        return userHome + File.separator + ".local";
    }

    public static boolean isFileInSkeletons(@NotNull VirtualFile virtualFile, @NotNull Sdk sdk) {
        VirtualFile skeletonsDir;
        if (virtualFile == null) {
            PythonSdkUtil.$$$reportNull$$$0(6);
        }
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(7);
        }
        return (skeletonsDir = PythonSdkUtil.findSkeletonsDir(sdk)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    public static boolean isElementInSkeletons(@NotNull PsiElement element) {
        Sdk sdk;
        VirtualFile virtualFile;
        PsiFile file;
        if (element == null) {
            PythonSdkUtil.$$$reportNull$$$0(8);
        }
        return (file = element.getContainingFile()) != null && (virtualFile = file.getVirtualFile()) != null && (sdk = PythonSdkUtil.findPythonSdk(element)) != null && PythonSdkUtil.isFileInSkeletons(virtualFile, sdk);
    }

    @NotNull
    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String sep = File.separator;
        String string = PythonSdkUtil.getSkeletonsRootPath(basePath) + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static String getSkeletonsPath(@NotNull Sdk sdk) {
        String path;
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(10);
        }
        return (path = sdk.getHomePath()) != null ? PythonSdkUtil.getSkeletonsPath(PathManager.getSystemPath(), path) : null;
    }

    @NotNull
    public static String getSkeletonsRootPath(String basePath) {
        String string = basePath + File.separator + SKELETON_DIR_NAME;
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findSkeletonsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(12);
        }
        return PythonSdkUtil.findLibraryDir(sdk, SKELETON_DIR_NAME, BUILTIN_ROOT_TYPE);
    }

    @Nullable
    public static VirtualFile findAnyRemoteLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(13);
        }
        return PythonSdkUtil.findLibraryDir(sdk, REMOTE_SOURCES_DIR_NAME, OrderRootType.CLASSES);
    }

    private static VirtualFile findLibraryDir(Sdk sdk, String dirName, OrderRootType rootType) {
        VirtualFile[] virtualFiles;
        for (VirtualFile virtualFile : virtualFiles = sdk.getRootProvider().getFiles(rootType)) {
            if (!virtualFile.isValid() || !virtualFile.getPath().contains(dirName)) continue;
            return virtualFile;
        }
        return null;
    }

    @NotNull
    private static String mapToRemote(@NotNull String localRoot, @NotNull Sdk sdk) {
        if (localRoot == null) {
            PythonSdkUtil.$$$reportNull$$$0(14);
        }
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(15);
        }
        String string = PythonRuntimeService.getInstance().mapToRemote(localRoot, sdk);
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean isUnderLibDirButNotSitePackages(@Nullable VirtualFile file, @NotNull String path, @NotNull VirtualFile libDir, @NotNull Sdk sdk, boolean checkOnRemoteFS) {
        String originLibDirPath;
        VirtualFile originLibDir;
        if (path == null) {
            PythonSdkUtil.$$$reportNull$$$0(17);
        }
        if (libDir == null) {
            PythonSdkUtil.$$$reportNull$$$0(18);
        }
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(19);
        }
        if (checkOnRemoteFS) {
            originLibDir = libDir;
            originLibDirPath = PythonSdkUtil.mapToRemote(originLibDir.getPath(), sdk);
        } else {
            originLibDir = (VirtualFile)ObjectUtils.notNull((Object)libDir.getCanonicalFile(), (Object)libDir);
            originLibDirPath = originLibDir.getPath();
        }
        if (checkOnRemoteFS || file == null) {
            String normalizedLidDirPath = FileUtil.toSystemIndependentName((String)originLibDirPath);
            String sitePackagesPath = normalizedLidDirPath + "/site-packages";
            String normalizedPath = FileUtil.toSystemIndependentName((String)path);
            return FileUtil.startsWith((String)normalizedPath, (String)normalizedLidDirPath) && !FileUtil.startsWith((String)normalizedPath, (String)sitePackagesPath);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)originLibDir, (VirtualFile)file, (boolean)false)) {
            VirtualFile sitePackagesDir = originLibDir.findChild("site-packages");
            return sitePackagesDir == null || !VfsUtilCore.isAncestor((VirtualFile)sitePackagesDir, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    public static boolean hasValidSdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!PythonSdkUtil.isPythonSdk(sdk)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(20);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            return PyRemoteSdkValidator.Companion.isInvalid(sdk);
        }
        VirtualFile interpreter = sdk.getHomeDirectory();
        return interpreter == null || !interpreter.exists();
    }

    public static boolean isDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(21);
        }
        return sdk instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)sdk));
    }

    public static List<Sdk> getAllLocalCPythons() {
        return PythonSdkUtil.getAllSdks().stream().filter(REMOTE_SDK_PREDICATE.negate()).collect(Collectors.toList());
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        Path python;
        if (rootPath == null) {
            PythonSdkUtil.$$$reportNull$$$0(22);
        }
        return (python = VirtualEnvReader.getInstance().findPythonInPythonRoot(Path.of(rootPath, new String[0]))) != null ? python.toString() : null;
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        Path path;
        if (homeDirectory == null) {
            PythonSdkUtil.$$$reportNull$$$0(23);
        }
        if (name == null) {
            PythonSdkUtil.$$$reportNull$$$0(24);
        }
        return (path = PythonSdkUtil.getExecutablePath(Path.of(homeDirectory, new String[0]), name)) != null ? path.toString() : null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static Path getExecutablePath(@NotNull Path homeDirectory, @NotNull String name) {
        String resolvedPath;
        String homeDirectoryAbsolutePath;
        Path binDir;
        if (homeDirectory == null) {
            PythonSdkUtil.$$$reportNull$$$0(25);
        }
        if (name == null) {
            PythonSdkUtil.$$$reportNull$$$0(26);
        }
        if ((binDir = homeDirectory.getParent()) == null) {
            return null;
        }
        Path runner = binDir.resolve(name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        runner = binDir.resolve("Scripts").resolve(name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        if (binDir.getParent() != null) {
            runner = binDir.getParent().resolve("Scripts").resolve(name);
            if (Files.exists(runner, new LinkOption[0])) {
                return runner;
            }
            runner = binDir.getParent().resolve("local").resolve(name);
            if (Files.exists(runner, new LinkOption[0])) {
                return runner;
            }
            runner = binDir.getParent().resolve("local").resolve("bin").resolve(name);
            if (Files.exists(runner, new LinkOption[0])) {
                return runner;
            }
        }
        if (FileSystemUtil.isSymLink((String)(homeDirectoryAbsolutePath = homeDirectory.toAbsolutePath().toString())) && (resolvedPath = FileSystemUtil.resolveSymLink((String)homeDirectoryAbsolutePath)) != null && !resolvedPath.equals(homeDirectoryAbsolutePath)) {
            return PythonSdkUtil.getExecutablePath(Path.of(resolvedPath, new String[0]), name);
        }
        runner = Path.of("/usr", "bin", name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        runner = Path.of("/usr", "local", "bin", name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        return null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        String rootPath;
        if (binaryPath == null) {
            PythonSdkUtil.$$$reportNull$$$0(27);
        }
        SlowOperations.assertSlowOperationsAreAllowed();
        File bin = new File(binaryPath).getParentFile();
        if (bin != null && (rootPath = bin.getParent()) != null) {
            File activate;
            File root = new File(rootPath);
            File activateThis = new File(bin, "activate_this.py");
            if (activateThis.exists() && (activate = PythonSdkUtil.findExecutableFile(bin, "activate")) != null) {
                return root;
            }
            if (new File(root, "pyvenv.cfg").exists()) {
                return root;
            }
        }
        return null;
    }

    @Nullable
    public static File findExecutableFile(File parent, String name) {
        File file;
        if (SystemInfo.isWindows) {
            for (String suffix : WINDOWS_EXECUTABLE_SUFFIXES) {
                File file2 = new File(parent, name + "." + suffix);
                if (!file2.exists()) continue;
                return file2;
            }
        } else if (SystemInfo.isUnix && (file = new File(parent, name)).exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkUtil.$$$reportNull$$$0(28);
        }
        return ProjectJdkTable.getInstance().findJdk(key);
    }

    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkUtil.$$$reportNull$$$0(29);
        }
        return PythonSdkUtil.findPythonSdk(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Deprecated
    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        if (path != null) {
            return PythonSdkUtil.findSdkByPath(PythonSdkUtil.getAllSdks(), path);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Sdk findSdkByPath(List<? extends Sdk> sdkList, @Nullable String path) {
        if (path != null) {
            for (Sdk sdk : sdkList) {
                if (sdk == null || !FileUtil.pathsEqual((String)path, (String)sdk.getHomePath())) continue;
                return sdk;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk) {
        if (pythonSdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(30);
        }
        VirtualFile libDir = PythonSdkUtil.isVirtualEnv(pythonSdk) ? PySearchUtilBase.findVirtualEnvLibDir(pythonSdk) : PySearchUtilBase.findLibDir(pythonSdk);
        return libDir != null ? libDir.findChild("site-packages") : null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(31);
        }
        String path = sdk.getHomePath();
        return PythonSdkUtil.isVirtualEnv(path);
    }

    @Contract(value="null -> false")
    public static boolean isVirtualEnv(@Nullable String path) {
        return path != null && PythonSdkUtil.getVirtualEnvRoot(path) != null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static VirtualFile getCondaDirectory(@NotNull Sdk sdk) {
        VirtualFile homeDirectory;
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(32);
        }
        if ((homeDirectory = sdk.getHomeDirectory()) == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return homeDirectory.getParent();
        }
        return homeDirectory.getParent().getParent();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(33);
        }
        return PythonSdkUtil.isCondaVirtualEnv(sdk.getHomePath());
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isCondaVirtualEnv(@Nullable String sdkPath) {
        SlowOperations.assertSlowOperationsAreAllowed();
        VirtualFile condaMeta = PythonSdkUtil.findCondaMeta(sdkPath);
        if (condaMeta == null) {
            return false;
        }
        VirtualFile envs = condaMeta.getParent().findChild("envs");
        return envs == null;
    }

    @Deprecated
    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(34);
        }
        return PythonSdkUtil.isConda(sdk.getHomePath());
    }

    @Deprecated
    public static boolean isConda(@Nullable String sdkPath) {
        return PythonSdkUtil.findCondaMeta(sdkPath) != null;
    }

    @Deprecated
    public static boolean isBaseConda(@Nullable String sdkPath) {
        VirtualFile condaMeta = PythonSdkUtil.findCondaMeta(sdkPath);
        if (condaMeta == null) {
            return false;
        }
        VirtualFile parent = condaMeta.getParent();
        if (parent == null) {
            return false;
        }
        VirtualFile condaBin = parent.findChild("condabin");
        if (condaBin != null) {
            return true;
        }
        return parent.findChild("envs") != null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @ApiStatus.Internal
    @Nullable
    public static VirtualFile findCondaMeta(@Nullable String sdkPath) {
        SlowOperations.assertSlowOperationsAreAllowed();
        if (sdkPath == null || CustomSdkHomePattern.isCustomPythonSdkHomePath((String)sdkPath)) {
            return null;
        }
        VirtualFile homeDirectory = StandardFileSystems.local().findFileByPath(sdkPath);
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile parentDirectory = homeDirectory.getParent();
        if (parentDirectory == null) {
            return null;
        }
        VirtualFile condaParent = SystemInfo.isWindows ? parentDirectory : parentDirectory.getParent();
        return condaParent != null ? condaParent.findChild("conda-meta") : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSdks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsRootPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPythonSdk";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFileInSkeletons";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isElementInSkeletons";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findSkeletonsDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAnyRemoteLibrary";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mapToRemote";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isUnderLibDirButNotSitePackages";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInvalid";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvRoot";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCondaDirectory";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 11, 16 -> new IllegalStateException(string);
        };
    }
}

