/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSPropertyAccessorChecker;
import com.intellij.lang.javascript.psi.resolve.processors.JSCandidateResultProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SinkResolveProcessor<T extends ResultSink>
extends ResolveProcessor
implements JSSinkResolveProcessor,
JSCandidateResultProcessor {
    private final boolean myToStopOnAssignment;
    @NotNull
    private final T myResultSink;
    private PsiElement placeTopParent;
    private String myPackageName;
    private boolean myForcedPackage;
    private boolean encounteredFunctionExpression;

    public SinkResolveProcessor(@NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(0);
        }
        this(((ResultSink)sink).getName(), ((ResultSink)sink).place, sink);
    }

    public SinkResolveProcessor(String name, T sink) {
        this(name, null, sink);
    }

    public SinkResolveProcessor(String name, boolean toStopOnAssignment, @NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(1);
        }
        this(name, null, toStopOnAssignment, sink);
    }

    public SinkResolveProcessor(String name, PsiElement _place, @NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(2);
        }
        this(name, _place, false, sink);
    }

    public SinkResolveProcessor(String name, PsiElement _place, boolean stopOnAssignment, @NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(3);
        }
        super(name, _place);
        this.myResultSink = sink;
        this.myToStopOnAssignment = stopOnAssignment;
    }

    public PsiElement getResult() {
        return ((ResultSink)this.myResultSink).getResult();
    }

    @Override
    @Nullable
    public List<PsiElement> getResults() {
        return ((ResultSink)this.myResultSink).getResults();
    }

    public PsiElement getPlaceTopParent() {
        return this.placeTopParent;
    }

    public void setForcedPackageName(String forcedPackageName) {
        this.myPackageName = forcedPackageName;
        this.myForcedPackage = forcedPackageName != null;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            SinkResolveProcessor.$$$reportNull$$$0(5);
        }
        if (!((ResultSink)this.myResultSink).accepts(element)) {
            return true;
        }
        if (!this.accessibilityProcessingHandler.accepts(element, this)) {
            return true;
        }
        return this.executeAcceptedElement(element, state);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiElement ownNameIdentifier;
        block19: {
            block18: {
                JSResolveResult.ProblemKind propertyAccessError;
                if (element == null) {
                    SinkResolveProcessor.$$$reportNull$$$0(6);
                }
                if (state == null) {
                    SinkResolveProcessor.$$$reportNull$$$0(7);
                }
                if ((propertyAccessError = JSPropertyAccessorChecker.getPropertyAccessError(this.place, element, this.myName == null)) != null) {
                    ((ResultSink)this.myResultSink).addCandidateResult(element, false, propertyAccessError);
                    return true;
                }
                if (!this.isPlaceConstructorCall()) break block18;
                if (element instanceof JSClass && this.myName != null) {
                    PsiElement constructor = this.getConstructor(element);
                    if (constructor == null) {
                        return true;
                    }
                    if (((ResultSink)this.myResultSink).isActionScript()) {
                        element = constructor;
                    }
                    break block19;
                } else if (JSResolveUtil.isConstructorFunction(element) && this.myName == null) {
                    return true;
                }
                break block19;
            }
            if (this.isElementClassConstructor(element) && !(this.place instanceof JSClass)) {
                return true;
            }
        }
        if (this.placeTopParent == null && this.place != null) {
            this.placeTopParent = JSResolveUtil.getTopReferenceExpression(this.place);
        }
        if (element instanceof JSFunctionExpression && (ownNameIdentifier = ((JSFunctionExpression)element).getOwnNameIdentifier()) == null) {
            return true;
        }
        boolean addCandidateUnconditionally = false;
        if (element instanceof JSDefinitionExpression && this.isWalkingUpTree) {
            boolean toProcess = false;
            JSExpression expression = ((JSDefinitionExpression)element).getExpression();
            if (!(this.accessibilityProcessingHandler.isProcessStatics() || !(expression instanceof JSReferenceExpression) || ((JSReferenceExpression)expression).getQualifier() != null || ((ResultSink)this.myResultSink).isActionScript() || !this.myToStopOnAssignment && JSResolveUtil.isEcmaScript5(element) && DialectDetector.dialectOfElement(element) != DialectOptionHolder.OTHER)) {
                toProcess = true;
            }
            if (!toProcess) {
                return true;
            }
            boolean bl = addCandidateUnconditionally = !this.myToStopOnAssignment;
        }
        if (SinkResolveProcessor.isField(element) && !this.isToProcessMembers()) {
            return true;
        }
        if (this.resolvedVariableShadowsParameter(element)) {
            return true;
        }
        if (!(element instanceof PsiNamedElement)) {
            if (!(element instanceof ES6ExportDefaultAssignment)) return true;
            return ((ResultSink)this.myResultSink).addResult(element, state, this.getPlaceTopParent());
        }
        element = SinkResolveProcessor.getNameElementIfElementIsXmlTag(element);
        if (addCandidateUnconditionally) {
            this.addPossibleCandidateResult(element, null);
            return true;
        }
        if (this.checkAccessibleInActionScript(element)) return ((ResultSink)this.myResultSink).addResult(element, state, this.getPlaceTopParent());
        return true;
    }

    protected boolean checkAccessibleInActionScript(@NotNull PsiElement element) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(8);
        }
        if (!((ResultSink)this.myResultSink).isActionScript()) {
            return true;
        }
        if (this.myPackageName == null) {
            String string = this.myPackageName = this.place != null ? JSResolveUtil.getPackageNameFromPlace(this.place) : "";
        }
        if (this.myForcedPackage ? !ActionScriptResolveUtil.isAccessibleFromActionScriptPackage(element, this.myPackageName) : !ActionScriptResolveUtil.isAccessibleFromCurrentActionScriptPackage(element, this.myPackageName, this.place)) {
            this.elementIsNotAccessible(element);
            return false;
        }
        return true;
    }

    private boolean resolvedVariableShadowsParameter(@NotNull PsiElement element) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(9);
        }
        if (!(element instanceof JSVariable) || !(this.place instanceof JSReferenceExpression)) {
            return false;
        }
        JSVarStatement varStatement = ((JSVariable)element).getStatement();
        if (varStatement == null || varStatement.getVarKeyword() != JSVarStatement.VarKeyword.VAR) {
            return false;
        }
        if (((JSReferenceExpression)this.place).getQualifier() != null) {
            return false;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)this.place, (boolean)true)) {
            return false;
        }
        PsiElement lexicalScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)varStatement);
        if (!(lexicalScope instanceof JSFunction)) {
            return false;
        }
        Object[] parameters = ((JSFunction)lexicalScope).getParameterVariables();
        return this.myName != null && ContainerUtil.find((Object[])parameters, p -> this.myName.equals(p.getName())) != null;
    }

    private static boolean isField(@Nullable PsiElement element) {
        return element instanceof JSField && (!DialectDetector.isActionScript(element) || JSUtils.getMemberContainingClass(element) != null);
    }

    @Nullable
    protected PsiElement getConstructor(@NotNull PsiElement element) {
        JSFunction constructor;
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(10);
        }
        return (constructor = ((JSClass)element).getConstructor()) == null ? element : constructor;
    }

    protected boolean isElementClassConstructor(@NotNull PsiElement element) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(11);
        }
        return element instanceof JSFunction && ((JSFunction)element).isConstructor() && JSUtils.getMemberContainingClass(element) != null;
    }

    protected boolean isPlaceConstructorCall() {
        return this.place != null && (SinkResolveProcessor.completeConstructorName(this.place) || this.place instanceof JSSuperExpression);
    }

    public void addPossibleCandidateResult(PsiElement element, JSResolveResult.ProblemKind problemKind) {
        ((ResultSink)this.myResultSink).addCandidateResult(element, false, problemKind);
    }

    @Override
    public void executeCandidateResult(PsiElement element, JSResolveResult.ProblemKind problemKind) {
        if (((ResultSink)this.myResultSink).accepts(element)) {
            ((ResultSink)this.myResultSink).addCandidateResult(element, false, problemKind);
        }
    }

    protected void elementIsNotAccessible(PsiElement element) {
        this.addPossibleCandidateResult(element, JSResolveResult.ProblemKind.ELEMENT_IS_NOT_ACCESSIBLE);
    }

    @Override
    protected void startingParent(PsiElement associated) {
        ((ResultSink)this.myResultSink).startingParent(associated, this.isToProcessMembers());
        super.startingParent(associated);
    }

    private static PsiElement getNameElementIfElementIsXmlTag(PsiElement element) {
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttribute("name").getValueElement().getChildren()[1];
        }
        return element;
    }

    public ResolveResult @NotNull [] getResultsAsResolveResults() {
        ResolveResult[] resolveResultArray = ((ResolveResultSink)this.myResultSink).getResultsAsResolveResults();
        if (resolveResultArray == null) {
            SinkResolveProcessor.$$$reportNull$$$0(12);
        }
        return resolveResultArray;
    }

    public void addResult(@NotNull PsiElement element) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(13);
        }
        ((ResultSink)this.myResultSink).addResult(element, ResolveState.initial(), this.placeTopParent);
    }

    @NotNull
    public final T getResultSink() {
        T t = this.myResultSink;
        if (t == null) {
            SinkResolveProcessor.$$$reportNull$$$0(14);
        }
        return t;
    }

    @Override
    public boolean skipTopLevelItems() {
        return ((ResultSink)this.myResultSink).skipTopLevelItems();
    }

    @Override
    public boolean processingEncounteredAnyTypeAccess() {
        return this.encounteredFunctionExpression;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            SinkResolveProcessor.$$$reportNull$$$0(15);
        }
        super.handleEvent(event, associated);
        this.handleActionScriptFunctionExpressionEvents(event, associated);
    }

    protected void handleActionScriptFunctionExpressionEvents(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            SinkResolveProcessor.$$$reportNull$$$0(16);
        }
        if (!((ResultSink)this.getResultSink()).isActionScript()) {
            return;
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER) {
            if (associated instanceof JSFunctionExpression && !ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)associated)) {
                this.encounteredFunctionExpression = true;
            }
        } else if (event == SCOPE_CHANGE && associated instanceof JSFunction && this.place != null && !(JSResolveUtil.findParent((PsiElement)associated) instanceof JSClass) && PsiTreeUtil.isAncestor((PsiElement)((JSFunction)associated), (PsiElement)this.place, (boolean)true)) {
            this.encounteredFunctionExpression = true;
        }
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        return ((ResultSink)this.myResultSink).needTopLevelClassName(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsAsResolveResults";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultSink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeAcceptedElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessibleInActionScript";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolvedVariableShadowsParameter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isElementClassConstructor";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleActionScriptFunctionExpressionEvents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14 -> new IllegalStateException(string);
        };
    }
}

