/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0007\u001a\b\u0010\u0013\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0015H\u0002\u001a\n\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"CONDA_DEFAULT_ROOTS", "", "", "CONDA_ENVS_DIR", "CONDA_BAT_NAME", "CONDA_BINARY_NAME", "WIN_CONDA_BIN_DIR_NAME", "UNIX_CONDA_BIN_DIR_NAME", "PYTHON_EXE_NAME", "PYTHON_UNIX_BINARY_NAME", "WIN_CONTINUUM_DIR_PATH", "WIN_PROGRAM_DATA_PATH", "WIN_C_ROOT_PATH", "UNIX_OPT_PATH", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCondaBasePython", "systemCondaExecutable", "getPythonName", "findCondaExecutableRelativeToEnv", "Ljava/nio/file/Path;", "pyExecutable", "getCondaExecutableByName", "condaName", "findExecutable", "condaFolder", "getSystemCondaExecutable", "intellij.python.sdk"})
@JvmName(name="CondaExecutablesLocator")
public final class CondaExecutablesLocator {
    @NotNull
    private static final List<String> CONDA_DEFAULT_ROOTS;
    @NotNull
    private static final String CONDA_ENVS_DIR = "envs";
    @NotNull
    private static final String CONDA_BAT_NAME = "conda.bat";
    @NotNull
    private static final String CONDA_BINARY_NAME = "conda";
    @NotNull
    private static final String WIN_CONDA_BIN_DIR_NAME = "condabin";
    @NotNull
    private static final String UNIX_CONDA_BIN_DIR_NAME = "bin";
    @NotNull
    private static final String PYTHON_EXE_NAME = "python.exe";
    @NotNull
    private static final String PYTHON_UNIX_BINARY_NAME = "python";
    @NotNull
    private static final String WIN_CONTINUUM_DIR_PATH = "AppData\\Local\\Continuum\\";
    @NotNull
    private static final String WIN_PROGRAM_DATA_PATH = "C:\\ProgramData\\";
    @NotNull
    private static final String WIN_C_ROOT_PATH = "C:\\";
    @NotNull
    private static final String UNIX_OPT_PATH = "/opt/";
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    @Nullable
    public static final String getCondaBasePython(@NotNull String systemCondaExecutable) {
        VirtualFile condaDir;
        VirtualFile python;
        Intrinsics.checkNotNullParameter((Object)systemCondaExecutable, (String)"systemCondaExecutable");
        VirtualFile condaFile = LocalFileSystem.getInstance().findFileByPath(systemCondaExecutable);
        if (condaFile != null && (python = (condaDir = SystemInfo.isWindows ? condaFile.getParent().getParent() : condaFile.getParent()).findChild(CondaExecutablesLocator.getPythonName())) != null) {
            return python.getPath();
        }
        return null;
    }

    private static final String getPythonName() {
        return SystemInfo.isWindows ? PYTHON_EXE_NAME : PYTHON_UNIX_BINARY_NAME;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Path findCondaExecutableRelativeToEnv(@NotNull Path pyExecutable) {
        Intrinsics.checkNotNullParameter((Object)pyExecutable, (String)"pyExecutable");
        if (!Files.exists(pyExecutable, new LinkOption[0])) {
            return null;
        }
        Path path = pyExecutable.getParent();
        if (path == null) {
            return null;
        }
        Path pyExecutableDir = path;
        Path path2 = pyExecutableDir.resolve(CONDA_ENVS_DIR);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        boolean isBaseConda = Files.exists(path2, new LinkOption[0]);
        String condaName = null;
        Path condaFolder = null;
        if (SystemInfo.isWindows) {
            condaName = CONDA_BAT_NAME;
            condaFolder = pyExecutableDir;
        } else {
            condaName = CONDA_BINARY_NAME;
            Path path3 = pyExecutableDir.getParent();
            if (path3 == null) {
                return null;
            }
            condaFolder = path3;
        }
        String localCondaName = SystemInfo.isWindows && !isBaseConda ? CONDA_BAT_NAME : condaName;
        Path immediateConda = CondaExecutablesLocator.findExecutable(localCondaName, condaFolder);
        if (immediateConda != null) {
            return immediateConda;
        }
        Path path4 = condaFolder.getParent();
        if (path4 == null) {
            return null;
        }
        Path envsDir = path4;
        if (!isBaseConda) {
            Path path5 = envsDir.getFileName();
            if (Intrinsics.areEqual((Object)(path5 != null ? ((Object)path5).toString() : null), (Object)CONDA_ENVS_DIR)) {
                Path path6 = envsDir.getParent();
                if (path6 == null) {
                    return null;
                }
                Path envsDirParent = path6;
                return CondaExecutablesLocator.findExecutable(condaName, envsDirParent);
            }
        }
        return null;
    }

    private static final Path getCondaExecutableByName(String condaName) {
        Path userHome = Path.of(SystemProperties.getUserHome(), new String[0]);
        for (String root : CONDA_DEFAULT_ROOTS) {
            String[] stringArray;
            Path executableFile;
            Intrinsics.checkNotNull((Object)userHome);
            Path path = userHome.resolve(root);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path condaFolder = path;
            Path path2 = executableFile = CondaExecutablesLocator.findExecutable(condaName, condaFolder);
            if (path2 != null) {
                return path2;
            }
            if (SystemInfo.isWindows) {
                Path path3 = userHome.resolve(WIN_CONTINUUM_DIR_PATH);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                Path path4 = path3.resolve(root);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                condaFolder = path4;
                Path path5 = executableFile = CondaExecutablesLocator.findExecutable(condaName, condaFolder);
                if (path5 != null) {
                    return path5;
                }
                stringArray = new String[]{root};
                Path path6 = Path.of(WIN_PROGRAM_DATA_PATH, stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"of(...)");
                condaFolder = path6;
                Path path7 = executableFile = CondaExecutablesLocator.findExecutable(condaName, condaFolder);
                if (path7 != null) {
                    return path7;
                }
                stringArray = new String[]{root};
                Path path8 = Path.of(WIN_C_ROOT_PATH, stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"of(...)");
                condaFolder = path8;
                Path path9 = executableFile = CondaExecutablesLocator.findExecutable(condaName, condaFolder);
                if (path9 == null) continue;
                return path9;
            }
            stringArray = new String[]{root};
            Path path10 = Path.of(UNIX_OPT_PATH, stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"of(...)");
            condaFolder = path10;
            executableFile = CondaExecutablesLocator.findExecutable(condaName, condaFolder);
            if (executableFile == null) continue;
            return executableFile;
        }
        return null;
    }

    private static final Path findExecutable(String condaName, Path condaFolder) {
        String binFolderName = SystemInfo.isWindows ? WIN_CONDA_BIN_DIR_NAME : UNIX_CONDA_BIN_DIR_NAME;
        Path path = condaFolder.resolve(binFolderName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve(condaName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path bin = path2;
        if (!Files.exists(bin, new LinkOption[0])) {
            return null;
        }
        return PythonSdkUtil.getExecutablePath((Path)bin, (String)condaName);
    }

    @Nullable
    public static final Path getSystemCondaExecutable() {
        String condaName = SystemInfo.isWindows ? CONDA_BAT_NAME : CONDA_BINARY_NAME;
        File condaInPath = PathEnvironmentVariableUtil.findInPath((String)condaName);
        if (condaInPath != null) {
            LOG.info("Using " + condaInPath + " as a conda executable (found in PATH)");
            return condaInPath.toPath();
        }
        Path condaInRoots = CondaExecutablesLocator.getCondaExecutableByName(condaName);
        if (condaInRoots != null) {
            LOG.info("Using " + condaInRoots + " as a conda executable (found by visiting possible conda roots)");
            return condaInRoots;
        }
        LOG.info("System conda executable is not found");
        return null;
    }

    static {
        Object[] objectArray = new String[]{"anaconda", "anaconda3", "miniconda", "miniconda3", "Anaconda", "Anaconda3", "Miniconda", "Miniconda3"};
        CONDA_DEFAULT_ROOTS = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = Logger.getInstance((String)"#com.jetbrains.python.packaging");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

