/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetConfigurationWithId;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PatternUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.parser.icons.PythonParserIcons;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.sdk.CustomSdkHomePattern;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PySdkFlavorUtilKt;
import com.jetbrains.python.sdk.flavors.PythonFlavorProvider;
import com.jetbrains.python.venvReader.ResolveUtilKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonSdkFlavor<D extends PyFlavorData> {
    @ApiStatus.Internal
    public static final ExtensionPointName<PythonSdkFlavor<?>> EP_NAME = ExtensionPointName.create((String)"Pythonid.pythonSdkFlavor");
    @ApiStatus.Internal
    public static final String PYTHON_VERSION_STRING_PREFIX = "Python ";
    private static final Cache<@NotNull String, @NotNull Boolean> ourExecutableFiles = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private static final Pattern VERSION_RE = Pattern.compile("(Python \\S+).*");
    private static final Logger LOG = Logger.getInstance(PythonSdkFlavor.class);

    @ApiStatus.Internal
    public boolean providePyCharmHosted() {
        return true;
    }

    @NotNull
    public Class<D> getFlavorDataClass() {
        return this.getEmptyFlavorForBackwardCompatibility();
    }

    @NotNull
    private Class<D> getEmptyFlavorForBackwardCompatibility() {
        LOG.warn("getFlavorDataClass is not implemented, please implement it");
        return PyFlavorData.Empty.class;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    protected @NotNull Collection<@NotNull Path> suggestLocalHomePathsImpl(@Nullable Module module, @Nullable UserDataHolder context) {
        List<Path> list = Collections.emptyList();
        if (list == null) {
            PythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public final @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        List<Path> list = this.suggestLocalHomePathsImpl(module, context).stream().filter(path -> {
            boolean correctFlavor;
            PythonSdkFlavor<?> flavor = PythonSdkFlavor.tryDetectFlavorByLocalPath(path.toString());
            boolean bl = correctFlavor = flavor != null && flavor.getClass().equals(this.getClass());
            if (!correctFlavor) {
                LOG.info(String.format("Path %s has a wrong flavor, not %s, skipping", path, this));
                return false;
            }
            return true;
        }).collect(Collectors.toSet()).stream().sorted().toList();
        if (list == null) {
            PythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @ApiStatus.Internal
    public boolean isApplicable() {
        return false;
    }

    @ApiStatus.Internal
    public boolean isPlatformIndependent() {
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    public String envPathParam() {
        return null;
    }

    @ApiStatus.Internal
    public boolean supportsEmptyData() {
        return true;
    }

    public boolean sdkSeemsValid(@NotNull Sdk sdk, @NotNull D flavorData, @Nullable TargetEnvironmentConfiguration targetConfig) {
        String path;
        if (sdk == null) {
            PythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (flavorData == null) {
            PythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if ((path = sdk.getHomePath()) == null) {
            LOG.warn("Sdk doesn't have homepath:" + sdk.getName());
            return false;
        }
        return PythonSdkFlavor.isFileExecutable(path, targetConfig);
    }

    protected static boolean isFileExecutable(@NotNull String fullPath, @Nullable TargetEnvironmentConfiguration targetEnvConfig) {
        String error;
        String id;
        Boolean executable;
        if (fullPath == null) {
            PythonSdkFlavor.$$$reportNull$$$0(4);
        }
        if ((executable = (Boolean)ourExecutableFiles.getIfPresent((Object)(id = PythonSdkFlavor.getIdForCache(fullPath, targetEnvConfig)))) != null) {
            return executable;
        }
        String string = error = SwingUtilities.isEventDispatchThread() ? PySdkFlavorUtilKt.getFileExecutionErrorOnEdt(fullPath, targetEnvConfig) : PySdkFlavorUtilKt.getFileExecutionError(fullPath, targetEnvConfig);
        if (error != null) {
            Logger.getInstance(PythonSdkFlavor.class).warn(String.format("%s is not executable: %s", fullPath, error));
        }
        boolean newValue = error == null;
        ourExecutableFiles.put((Object)id, (Object)newValue);
        return newValue;
    }

    @ApiStatus.Internal
    public static void clearExecutablesCache() {
        ourExecutableFiles.invalidateAll();
    }

    @NotNull
    private static String getIdForCache(@NotNull String fullPath, @Nullable TargetEnvironmentConfiguration configuration) {
        if (fullPath == null) {
            PythonSdkFlavor.$$$reportNull$$$0(5);
        }
        StringBuilder builder = new StringBuilder(fullPath);
        builder.append(" ");
        if (configuration instanceof TargetConfigurationWithId) {
            Pair typeAndTargetId = ((TargetConfigurationWithId)configuration).getTargetAndTypeId();
            builder.append(typeAndTargetId.component1());
            builder.append((String)typeAndTargetId.getSecond());
        } else if (configuration != null) {
            builder.append(configuration.getClass().getName());
        } else {
            builder.append("local");
        }
        String string = builder.toString();
        if (string == null) {
            PythonSdkFlavor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static List<PythonSdkFlavor<?>> getApplicableFlavors(boolean addPlatformIndependent) {
        ArrayList result = new ArrayList();
        for (PythonSdkFlavor flavor : EP_NAME.getExtensionList()) {
            if (!flavor.isApplicable() && (!addPlatformIndependent || !flavor.isPlatformIndependent())) continue;
            result.add(flavor);
        }
        result.addAll(PythonSdkFlavor.getPlatformFlavorsFromExtensions());
        if (addPlatformIndependent) {
            result.sort((f1, f2) -> Boolean.compare(f2.isPlatformIndependent(), f1.isPlatformIndependent()));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PythonSdkFlavor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static List<PythonSdkFlavor<?>> getPlatformFlavorsFromExtensions() {
        ArrayList result = new ArrayList();
        for (PythonFlavorProvider provider : PythonFlavorProvider.EP_NAME.getExtensionList()) {
            PythonSdkFlavor<?> flavor = provider.getFlavor();
            result.add(flavor);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PythonSdkFlavor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<PythonSdkFlavor<?>> getPlatformIndependentFlavors() {
        ArrayList result = new ArrayList();
        for (PythonSdkFlavor flavor : EP_NAME.getExtensionList()) {
            if (!flavor.isPlatformIndependent()) continue;
            result.add(flavor);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PythonSdkFlavor.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    @Nullable
    public static PythonSdkFlavor<?> getFlavor(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            PythonSdkFlavor.$$$reportNull$$$0(10);
        }
        if ((data = sdk.getSdkAdditionalData()) instanceof PythonSdkAdditionalData) {
            return ((PythonSdkAdditionalData)data).getFlavor();
        }
        if (data instanceof PyRemoteSdkAdditionalDataMarker) {
            return null;
        }
        return PythonSdkFlavor.getFlavor(sdk.getHomePath());
    }

    @Deprecated(forRemoval=true)
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static PythonSdkFlavor<?> getFlavor(@Nullable String sdkPath) {
        if (sdkPath == null || CustomSdkHomePattern.isCustomPythonSdkHomePath((String)sdkPath)) {
            return null;
        }
        return PythonSdkFlavor.tryDetectFlavorByLocalPath(sdkPath);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static PythonSdkFlavor<?> tryDetectFlavorByLocalPath(@NotNull String sdkPath) {
        if (sdkPath == null) {
            PythonSdkFlavor.$$$reportNull$$$0(11);
        }
        for (PythonSdkFlavor<?> flavor : PythonSdkFlavor.getApplicableFlavors(true)) {
            if (!flavor.isValidSdkPath(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static PythonSdkFlavor<?> getPlatformIndependentFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor<?> flavor : PythonSdkFlavor.getPlatformIndependentFlavors()) {
            if (!flavor.isValidSdkPath(sdkPath)) continue;
            return flavor;
        }
        for (PythonSdkFlavor<?> flavor : PythonSdkFlavor.getPlatformFlavorsFromExtensions()) {
            if (!flavor.isValidSdkPath(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    @ApiStatus.Internal
    public boolean isValidSdkPath(@NotNull String pathStr) {
        Path path;
        if (pathStr == null) {
            PythonSdkFlavor.$$$reportNull$$$0(12);
        }
        if ((path = ResolveUtilKt.tryResolvePath((String)pathStr)) == null) {
            return false;
        }
        return Files.exists(path, new LinkOption[0]) && Files.isExecutable(path);
    }

    @Deprecated(forRemoval=true)
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        return PythonSdkFlavor.getVersionStringStatic(sdkHome);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String getVersionStringStatic(@Nullable String sdkHome) {
        if (sdkHome == null) {
            return null;
        }
        String runDirectory = new File(sdkHome).getParent();
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(runDirectory, new String[]{sdkHome, "--version"}, 10000);
        return PythonSdkFlavor.getVersionStringFromOutput(processOutput);
    }

    @ApiStatus.Internal
    @Nullable
    public static String getVersionStringFromOutput(@NotNull ProcessOutput processOutput) {
        if (processOutput == null) {
            PythonSdkFlavor.$$$reportNull$$$0(13);
        }
        if (processOutput.getExitCode() != 0) {
            String errors = processOutput.getStderr();
            if (StringUtil.isEmpty((String)errors)) {
                errors = processOutput.getStdout();
            }
            LOG.warn("Couldn't get interpreter version: process exited with code " + processOutput.getExitCode() + "\n" + errors);
            return null;
        }
        String result = PythonSdkFlavor.getVersionStringFromOutput(processOutput.getStderr());
        if (result != null) {
            return result;
        }
        return PythonSdkFlavor.getVersionStringFromOutput(processOutput.getStdout());
    }

    @ApiStatus.Internal
    @Nullable
    public static String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            PythonSdkFlavor.$$$reportNull$$$0(14);
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE);
    }

    @ApiStatus.Internal
    @NotNull
    public Collection<String> getExtraDebugOptions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkFlavor.$$$reportNull$$$0(15);
        }
        return list;
    }

    @ApiStatus.Internal
    public void initPythonPath(@NotNull GeneralCommandLine cmd, boolean passParentEnvs, @NotNull Collection<String> path) {
        if (cmd == null) {
            PythonSdkFlavor.$$$reportNull$$$0(16);
        }
        if (path == null) {
            PythonSdkFlavor.$$$reportNull$$$0(17);
        }
        this.initPythonPath(path, passParentEnvs, cmd.getEnvironment());
    }

    @NotNull
    public abstract String getName();

    @ApiStatus.Internal
    @NotNull
    public String getUniqueId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            PythonSdkFlavor.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkFlavor.$$$reportNull$$$0(19);
        }
        return PythonSdkFlavor.getLanguageLevelFromVersionStringStatic(sdk.getVersionString());
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkFlavor.$$$reportNull$$$0(20);
        }
        return PythonSdkFlavor.getLanguageLevelFromVersionStringStatic(this.getVersionString(sdkHome));
    }

    @NotNull
    public static LanguageLevel getLanguageLevelFromVersionStringStatic(@Nullable String version) {
        if (version == null) {
            LanguageLevel languageLevel = LanguageLevel.getDefault();
            if (languageLevel == null) {
                PythonSdkFlavor.$$$reportNull$$$0(21);
            }
            return languageLevel;
        }
        LanguageLevel result = PythonSdkFlavor.getLanguageLevelFromVersionStringStaticSafe(version);
        LanguageLevel languageLevel = result == null ? LanguageLevel.getDefault() : result;
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(22);
        }
        return languageLevel;
    }

    @Nullable
    public static LanguageLevel getLanguageLevelFromVersionStringStaticSafe(@NotNull String versionString) {
        if (versionString == null) {
            PythonSdkFlavor.$$$reportNull$$$0(23);
        }
        if (versionString.startsWith(PYTHON_VERSION_STRING_PREFIX)) {
            return LanguageLevel.fromPythonVersionSafe((String)versionString.substring(PYTHON_VERSION_STRING_PREFIX.length()));
        }
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PythonParserIcons.PythonFile;
        if (icon == null) {
            PythonSdkFlavor.$$$reportNull$$$0(24);
        }
        return icon;
    }

    @ApiStatus.Internal
    public void initPythonPath(@NotNull Collection<String> path, boolean passParentEnvs, @NotNull Map<String, String> env) {
        if (path == null) {
            PythonSdkFlavor.$$$reportNull$$$0(25);
        }
        if (env == null) {
            PythonSdkFlavor.$$$reportNull$$$0(26);
        }
        PythonEnvUtil.initPythonPath(env, (boolean)passParentEnvs, path);
    }

    @ApiStatus.Internal
    @Nullable
    public VirtualFile getSdkPath(@NotNull VirtualFile path) {
        if (path == null) {
            PythonSdkFlavor.$$$reportNull$$$0(27);
        }
        return path;
    }

    @ApiStatus.Internal
    @Nullable
    public CommandLinePatcher commandLinePatcher() {
        return null;
    }

    @ApiStatus.Internal
    public void dropCaches() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 10, 11, 12, 13, 14, 16, 17, 19, 20, 23, 25, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 2: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorData";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathStr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 17: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePathsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableFlavors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformFlavorsFromExtensions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformIndependentFlavors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraDebugOptions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelFromVersionStringStatic";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sdkSeemsValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileExecutable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIdForCache";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFlavor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectFlavorByLocalPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 16: 
            case 17: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelFromVersionStringStaticSafe";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 10, 11, 12, 13, 14, 16, 17, 19, 20, 23, 25, 26, 27 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static final class UnknownFlavor
    extends PythonSdkFlavor<PyFlavorData.Empty> {
        public static final UnknownFlavor INSTANCE = new UnknownFlavor();

        private UnknownFlavor() {
        }

        @Override
        @NotNull
        public Class<PyFlavorData.Empty> getFlavorDataClass() {
            return PyFlavorData.Empty.class;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }
    }
}

