/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.commons.data.DataType;
import org.jetbrains.letsPlot.core.plot.base.FormatterUtil;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\b \u0018\u0000 @*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002?@B\u000f\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0014\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u0013H$J\u0010\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020+H\u0004J\u0006\u0010;\u001a\u00020\u0011J\u0010\u0010<\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u0013H\u0002J\u0006\u0010=\u001a\u00020\u0011J\b\u0010>\u001a\u00020\u0013H\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\"\u0010)\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u0004\u0018\u00010*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001c\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010(R\u0016\u00100\u001a\u0004\u0018\u00010\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00105\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010-\u00a8\u0006A"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale;", "DomainT", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "name", "", "(Ljava/lang/String;)V", "b", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder;)V", "<set-?>", "", "additiveExpand", "getAdditiveExpand", "()D", "setAdditiveExpand", "(D)V", "createdScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "createdScaleBreaksShortened", "", "dataType", "Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "getDataType", "()Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "getExpFormat", "()Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "labelLengthLimit", "", "getLabelLengthLimit", "()I", "multiplicativeExpand", "getMultiplicativeExpand", "setMultiplicativeExpand", "getName", "()Ljava/lang/String;", "providedBreaks", "", "getProvidedBreaks", "()Ljava/util/List;", "providedFormatter", "Lkotlin/Function1;", "", "getProvidedFormatter", "()Lkotlin/jvm/functions/Function1;", "providedLabels", "getProvidedLabels", "providedScaleBreaks", "getProvidedScaleBreaks", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "userFormatter", "getUserFormatter", "createScaleBreaks", "shortenLabels", "formatValue", "value", "getScaleBreaks", "getScaleBreaksIntern", "getShortenedScaleBreaks", "hasBreaks", "AbstractBuilder", "Companion", "plot-base"})
public abstract class AbstractScale<DomainT>
implements Scale {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private final List<DomainT> providedBreaks;
    @Nullable
    private final List<String> providedLabels;
    @Nullable
    private final ScaleBreaks providedScaleBreaks;
    @Nullable
    private final Function1<Object, String> providedFormatter;
    @NotNull
    private final DataType dataType;
    private final int labelLengthLimit;
    @NotNull
    private final StringFormat.ExponentFormat expFormat;
    @Nullable
    private final TimeZone tz;
    @Nullable
    private ScaleBreaks createdScaleBreaks;
    private boolean createdScaleBreaksShortened;
    private double multiplicativeExpand;
    private double additiveExpand;

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    protected final List<DomainT> getProvidedBreaks() {
        return this.providedBreaks;
    }

    @Nullable
    protected final List<String> getProvidedLabels() {
        return this.providedLabels;
    }

    @Nullable
    protected final ScaleBreaks getProvidedScaleBreaks() {
        return this.providedScaleBreaks;
    }

    @Nullable
    protected final Function1<Object, String> getProvidedFormatter() {
        return this.providedFormatter;
    }

    @NotNull
    protected final DataType getDataType() {
        return this.dataType;
    }

    protected final int getLabelLengthLimit() {
        return this.labelLengthLimit;
    }

    @NotNull
    protected final StringFormat.ExponentFormat getExpFormat() {
        return this.expFormat;
    }

    @Override
    public final double getMultiplicativeExpand() {
        return this.multiplicativeExpand;
    }

    protected final void setMultiplicativeExpand(double d) {
        this.multiplicativeExpand = d;
    }

    @Override
    public final double getAdditiveExpand() {
        return this.additiveExpand;
    }

    protected final void setAdditiveExpand(double d) {
        this.additiveExpand = d;
    }

    protected AbstractScale(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.providedBreaks = null;
        this.providedLabels = null;
        this.providedScaleBreaks = null;
        this.providedFormatter = null;
        this.dataType = DataType.UNKNOWN;
        this.tz = null;
        this.labelLengthLimit = 0;
        this.expFormat = StringFormat.ExponentFormat.Companion.getDEF_EXPONENT_FORMAT();
    }

    protected AbstractScale(@NotNull AbstractBuilder<DomainT> b2) {
        Intrinsics.checkNotNullParameter(b2, (String)"b");
        this.name = b2.getMyName();
        this.providedBreaks = b2.getProvidedBreaks();
        this.providedLabels = b2.getProvidedLabels();
        this.providedScaleBreaks = b2.getProvidedScaleBreaks();
        this.providedFormatter = b2.getProvidedFormatter();
        this.dataType = b2.getDataType();
        this.tz = b2.getTz();
        this.labelLengthLimit = b2.getMyLabelLengthLimit();
        this.expFormat = b2.getMyExpFormat();
        this.multiplicativeExpand = b2.getMyMultiplicativeExpand();
        this.additiveExpand = b2.getMyAdditiveExpand();
    }

    @Override
    @Nullable
    public Function1<Object, String> getUserFormatter() {
        return this.providedFormatter;
    }

    @Override
    public boolean hasBreaks() {
        return this.providedBreaks != null || this.providedScaleBreaks != null;
    }

    @Override
    @NotNull
    public final ScaleBreaks getScaleBreaks() {
        return this.getScaleBreaksIntern(false);
    }

    @Override
    @NotNull
    public final ScaleBreaks getShortenedScaleBreaks() {
        return this.getScaleBreaksIntern(true);
    }

    private final ScaleBreaks getScaleBreaksIntern(boolean shortenLabels) {
        ScaleBreaks scaleBreaks;
        if (this.createdScaleBreaks != null && this.createdScaleBreaksShortened == shortenLabels) {
            ScaleBreaks scaleBreaks2 = this.createdScaleBreaks;
            scaleBreaks = scaleBreaks2;
            Intrinsics.checkNotNull((Object)scaleBreaks2);
        } else {
            this.createdScaleBreaks = this.createScaleBreaks(shortenLabels);
            this.createdScaleBreaksShortened = shortenLabels;
            ScaleBreaks scaleBreaks3 = this.createdScaleBreaks;
            scaleBreaks = scaleBreaks3;
            Intrinsics.checkNotNull((Object)scaleBreaks3);
        }
        return scaleBreaks;
    }

    @NotNull
    protected abstract ScaleBreaks createScaleBreaks(boolean var1);

    @NotNull
    protected final String formatValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Function1<Object, String> function1 = this.providedFormatter;
        if (function1 == null) {
            function1 = FormatterUtil.INSTANCE.byDataType(this.dataType, this.expFormat, this.tz);
        }
        Function1<Object, String> formatter2 = function1;
        return (String)formatter2.invoke(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b$\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\rH\u0016J\u0016\u0010E\u001a\u00020\u00022\f\u0010F\u001a\b\u0012\u0004\u0012\u00020/0(H\u0016J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\u0007H\u0016J\u0010\u0010G\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\u0013H\u0016J\u001c\u0010H\u001a\u00020\u00022\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\"0.H\u0016J\u0010\u0010I\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\u0019H\u0016J\u0016\u0010J\u001a\u00020\u00022\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\"0(H\u0016J\u0010\u0010K\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\rH\u0016J\u0010\u0010L\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\"H\u0016J\u0010\u0010M\u001a\u00020\u00022\u0006\u0010D\u001a\u000208H\u0016J\u0010\u0010N\u001a\u00020\u00022\u0006\u0010D\u001a\u00020>H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010'\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010-\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\"\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00104\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010*\"\u0004\b6\u0010,R\u001c\u00107\u001a\u0004\u0018\u000108X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001c\u0010=\u001a\u0004\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006O"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder;", "DomainT", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale;)V", "dataType", "Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "getDataType", "()Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "setDataType", "(Lorg/jetbrains/letsPlot/core/commons/data/DataType;)V", "myAdditiveExpand", "", "getMyAdditiveExpand", "()D", "setMyAdditiveExpand", "(D)V", "myExpFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "getMyExpFormat", "()Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "setMyExpFormat", "(Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;)V", "myLabelLengthLimit", "", "getMyLabelLengthLimit", "()I", "setMyLabelLengthLimit", "(I)V", "myMultiplicativeExpand", "getMyMultiplicativeExpand", "setMyMultiplicativeExpand", "myName", "", "getMyName", "()Ljava/lang/String;", "setMyName", "(Ljava/lang/String;)V", "providedBreaks", "", "getProvidedBreaks", "()Ljava/util/List;", "setProvidedBreaks", "(Ljava/util/List;)V", "providedFormatter", "Lkotlin/Function1;", "", "getProvidedFormatter", "()Lkotlin/jvm/functions/Function1;", "setProvidedFormatter", "(Lkotlin/jvm/functions/Function1;)V", "providedLabels", "getProvidedLabels", "setProvidedLabels", "providedScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "getProvidedScaleBreaks", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "setProvidedScaleBreaks", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;)V", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "getTz", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "setTz", "(Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;)V", "additiveExpand", "v", "breaks", "l", "exponentFormat", "labelFormatter", "labelLengthLimit", "labels", "multiplicativeExpand", "name", "scaleBreaks", "timeZone", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nAbstractScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1549#2:190\n1620#2,3:191\n*S KotlinDebug\n*F\n+ 1 AbstractScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder\n*L\n136#1:190\n136#1:191,3\n*E\n"})
    protected static abstract class AbstractBuilder<DomainT>
    implements Scale.Builder {
        @NotNull
        private String myName;
        @Nullable
        private List<? extends DomainT> providedBreaks;
        @Nullable
        private List<String> providedLabels;
        @Nullable
        private ScaleBreaks providedScaleBreaks;
        @Nullable
        private Function1<Object, String> providedFormatter;
        @NotNull
        private DataType dataType;
        @Nullable
        private TimeZone tz;
        private int myLabelLengthLimit;
        @NotNull
        private StringFormat.ExponentFormat myExpFormat;
        private double myMultiplicativeExpand;
        private double myAdditiveExpand;

        public AbstractBuilder(@NotNull AbstractScale<DomainT> scale) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            this.myName = scale.getName();
            this.providedBreaks = scale.getProvidedBreaks();
            this.providedLabels = scale.getProvidedLabels();
            this.providedScaleBreaks = scale.getProvidedScaleBreaks();
            this.providedFormatter = scale.getProvidedFormatter();
            this.dataType = scale.getDataType();
            this.tz = ((AbstractScale)scale).tz;
            this.myLabelLengthLimit = scale.getLabelLengthLimit();
            this.myExpFormat = scale.getExpFormat();
            this.myMultiplicativeExpand = scale.getMultiplicativeExpand();
            this.myAdditiveExpand = scale.getAdditiveExpand();
        }

        @NotNull
        public final String getMyName() {
            return this.myName;
        }

        public final void setMyName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.myName = string;
        }

        @Nullable
        public final List<DomainT> getProvidedBreaks() {
            return this.providedBreaks;
        }

        public final void setProvidedBreaks(@Nullable List<? extends DomainT> list2) {
            this.providedBreaks = list2;
        }

        @Nullable
        public final List<String> getProvidedLabels() {
            return this.providedLabels;
        }

        public final void setProvidedLabels(@Nullable List<String> list2) {
            this.providedLabels = list2;
        }

        @Nullable
        public final ScaleBreaks getProvidedScaleBreaks() {
            return this.providedScaleBreaks;
        }

        public final void setProvidedScaleBreaks(@Nullable ScaleBreaks scaleBreaks) {
            this.providedScaleBreaks = scaleBreaks;
        }

        @Nullable
        public final Function1<Object, String> getProvidedFormatter() {
            return this.providedFormatter;
        }

        public final void setProvidedFormatter(@Nullable Function1<Object, String> function1) {
            this.providedFormatter = function1;
        }

        @NotNull
        public final DataType getDataType() {
            return this.dataType;
        }

        public final void setDataType(@NotNull DataType dataType) {
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"<set-?>");
            this.dataType = dataType;
        }

        @Nullable
        public final TimeZone getTz() {
            return this.tz;
        }

        public final void setTz(@Nullable TimeZone timeZone) {
            this.tz = timeZone;
        }

        public final int getMyLabelLengthLimit() {
            return this.myLabelLengthLimit;
        }

        public final void setMyLabelLengthLimit(int n) {
            this.myLabelLengthLimit = n;
        }

        @NotNull
        public final StringFormat.ExponentFormat getMyExpFormat() {
            return this.myExpFormat;
        }

        public final void setMyExpFormat(@NotNull StringFormat.ExponentFormat exponentFormat) {
            Intrinsics.checkNotNullParameter((Object)exponentFormat, (String)"<set-?>");
            this.myExpFormat = exponentFormat;
        }

        public final double getMyMultiplicativeExpand() {
            return this.myMultiplicativeExpand;
        }

        public final void setMyMultiplicativeExpand(double d) {
            this.myMultiplicativeExpand = d;
        }

        public final double getMyAdditiveExpand() {
            return this.myAdditiveExpand;
        }

        public final void setMyAdditiveExpand(double d) {
            this.myAdditiveExpand = d;
        }

        @Override
        @NotNull
        public Scale.Builder name(@NotNull String v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myName = v;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Scale.Builder breaks(@NotNull List<? extends Object> l) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(l, (String)"l");
            Iterable iterable = l;
            AbstractBuilder abstractBuilder = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it);
            }
            abstractBuilder.providedBreaks = (List)destination$iv$iv;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder labels(@NotNull List<String> l) {
            Intrinsics.checkNotNullParameter(l, (String)"l");
            this.providedLabels = l;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder scaleBreaks(@NotNull ScaleBreaks v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.providedScaleBreaks = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder labelLengthLimit(int v) {
            this.myLabelLengthLimit = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder labelFormatter(@NotNull Function1<Object, String> v) {
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.providedFormatter = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder dataType(@NotNull DataType v) {
            Intrinsics.checkNotNullParameter((Object)((Object)v), (String)"v");
            this.dataType = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder timeZone(@NotNull TimeZone v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.tz = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder exponentFormat(@NotNull StringFormat.ExponentFormat v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myExpFormat = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder multiplicativeExpand(double v) {
            this.myMultiplicativeExpand = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder additiveExpand(double v) {
            this.myAdditiveExpand = v;
            return this;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$Companion;", "", "()V", "alignLablesAndBreaks", "", "", "breaks", "labels", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nAbstractScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> alignLablesAndBreaks(@NotNull List<? extends Object> breaks, @NotNull List<String> labels) {
            List list2;
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            if (labels.isEmpty()) {
                int n = breaks.size();
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<String> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add("");
                }
                list2 = arrayList;
            } else if (breaks.size() <= labels.size()) {
                list2 = labels.subList(0, breaks.size());
            } else {
                int n = breaks.size() - labels.size();
                Collection collection = labels;
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n5 = 0;
                while (n5 < n) {
                    int n6;
                    int it = n6 = n5++;
                    ArrayList<String> arrayList3 = arrayList;
                    boolean bl = false;
                    arrayList3.add("");
                }
                list2 = CollectionsKt.plus((Collection)collection, (Iterable)arrayList);
            }
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

