/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.MultiRootMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.ArrayUtilRt;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class GitFetcher {
    private static final Logger LOG = Logger.getInstance(GitFetcher.class);
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;
    private final ProgressIndicator myProgressIndicator;
    private final boolean myFetchAll;
    private final GitVcs myVcs;
    private final Collection<Exception> myErrors;

    public GitFetcher(@NotNull Project project, @NotNull ProgressIndicator progressIndicator, boolean fetchAll) {
        if (project == null) {
            GitFetcher.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            GitFetcher.$$$reportNull$$$0(1);
        }
        this.myErrors = new ArrayList<Exception>();
        this.myProject = project;
        this.myProgressIndicator = progressIndicator;
        this.myFetchAll = fetchAll;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcs = GitVcs.getInstance(project);
    }

    @Deprecated(forRemoval=true)
    private GitFetchResult fetch(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitFetcher.$$$reportNull$$$0(2);
        }
        GitFetchResult fetchResult2 = this.myFetchAll ? GitFetcher.fetchAll(repository2) : GitFetcher.fetchCurrentRemote(repository2);
        repository2.update();
        repository2.getRepositoryFiles().refreshTagsFiles();
        return fetchResult2;
    }

    @NotNull
    private static GitFetchResult fetchCurrentRemote(@NotNull GitRepository repository2) {
        FetchParams fetchParams;
        if (repository2 == null) {
            GitFetcher.$$$reportNull$$$0(3);
        }
        if ((fetchParams = GitFetcher.getFetchParams(repository2)).isError()) {
            GitFetchResult gitFetchResult = fetchParams.getError();
            if (gitFetchResult == null) {
                GitFetcher.$$$reportNull$$$0(4);
            }
            return gitFetchResult;
        }
        GitRemote remote = fetchParams.getRemote();
        return GitFetcher.fetchRemote(repository2, remote, null);
    }

    @NotNull
    private static GitFetchResult fetchRemote(@NotNull GitRepository repository2, @NotNull GitRemote remote, @Nullable String branch) {
        if (repository2 == null) {
            GitFetcher.$$$reportNull$$$0(5);
        }
        if (remote == null) {
            GitFetcher.$$$reportNull$$$0(6);
        }
        return GitFetcher.fetchNatively(repository2, remote, branch);
    }

    @NotNull
    private static GitFetchResult fetchCurrentBranch(@NotNull GitRepository repository2) {
        FetchParams fetchParams;
        if (repository2 == null) {
            GitFetcher.$$$reportNull$$$0(7);
        }
        if ((fetchParams = GitFetcher.getFetchParams(repository2)).isError()) {
            GitFetchResult gitFetchResult = fetchParams.getError();
            if (gitFetchResult == null) {
                GitFetcher.$$$reportNull$$$0(8);
            }
            return gitFetchResult;
        }
        GitRemote remote = fetchParams.getRemote();
        String remoteBranch = fetchParams.getRemoteBranch().getNameForRemoteOperations();
        return GitFetcher.fetchNatively(repository2, remote, remoteBranch);
    }

    @NotNull
    private static FetchParams getFetchParams(@NotNull GitRepository repository2) {
        GitLocalBranch currentBranch;
        if (repository2 == null) {
            GitFetcher.$$$reportNull$$$0(9);
        }
        if ((currentBranch = repository2.getCurrentBranch()) == null) {
            String message = "Current branch can't be null here. \nRepository: " + String.valueOf(repository2);
            LOG.error(message);
            return new FetchParams(GitFetchResult.error(new Exception(message)));
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository2, currentBranch);
        if (trackInfo == null) {
            String message = "Tracked info is null for branch " + String.valueOf((Object)currentBranch) + "\n Repository: " + String.valueOf(repository2);
            LOG.error(message);
            return new FetchParams(GitFetchResult.error(new Exception(message)));
        }
        GitRemote remote = trackInfo.getRemote();
        return new FetchParams(remote, trackInfo.getRemoteBranch());
    }

    @NotNull
    private static GitFetchResult fetchAll(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitFetcher.$$$reportNull$$$0(10);
        }
        GitFetchResult fetchResult2 = GitFetchResult.success();
        for (GitRemote remote : repository2.getRemotes()) {
            String url = remote.getFirstUrl();
            if (url == null) {
                LOG.error("URL is null for remote " + remote.getName());
                continue;
            }
            GitFetchResult res = GitFetcher.fetchNatively(repository2, remote, null);
            res.addPruneInfo(fetchResult2.getPrunedRefs());
            fetchResult2 = res;
            if (fetchResult2.isSuccess()) continue;
            break;
        }
        GitFetchResult gitFetchResult = fetchResult2;
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(11);
        }
        return gitFetchResult;
    }

    @NotNull
    private static GitFetchResult fetchNatively(@NotNull GitRepository repository2, @NotNull GitRemote remote, @Nullable String branch) {
        GitFetchResult fetchResult2;
        String[] stringArray;
        if (repository2 == null) {
            GitFetcher.$$$reportNull$$$0(12);
        }
        if (remote == null) {
            GitFetcher.$$$reportNull$$$0(13);
        }
        Git git = Git.getInstance();
        if (branch != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = GitFetcher.getFetchSpecForBranch(branch, remote.getName());
        } else {
            stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] additionalParams = stringArray;
        GitFetchPruneDetector pruneDetector = new GitFetchPruneDetector();
        GitCommandResult result2 = git.fetch(repository2, remote, Collections.singletonList(pruneDetector), additionalParams);
        if (result2.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)repository2.getProject(), GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository2, remote);
            fetchResult2 = GitFetchResult.success();
        } else {
            fetchResult2 = GitFetchResult.error(result2.getErrorOutputAsJoinedString());
        }
        fetchResult2.addPruneInfo(pruneDetector.getPrunedRefs());
        GitFetchResult gitFetchResult = fetchResult2;
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(14);
        }
        return gitFetchResult;
    }

    private static String getRidOfPrefixIfExists(String branch) {
        if (branch.startsWith("refs/heads/")) {
            return branch.substring("refs/heads/".length());
        }
        return branch;
    }

    @NotNull
    private static String getFetchSpecForBranch(@NotNull String branch, @NotNull String remoteName) {
        if (branch == null) {
            GitFetcher.$$$reportNull$$$0(15);
        }
        if (remoteName == null) {
            GitFetcher.$$$reportNull$$$0(16);
        }
        branch = GitFetcher.getRidOfPrefixIfExists(branch);
        String string = "refs/heads/" + branch + ":refs/remotes/" + remoteName + "/" + branch;
        if (string == null) {
            GitFetcher.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public Collection<Exception> getErrors() {
        Collection<Exception> collection = this.myErrors;
        if (collection == null) {
            GitFetcher.$$$reportNull$$$0(18);
        }
        return collection;
    }

    public static void displayFetchResult(@NotNull Project project, @NotNull GitFetchResult result2, @NlsContexts.NotificationTitle @Nullable String errorNotificationTitle, @NotNull Collection<? extends Exception> errors) {
        if (project == null) {
            GitFetcher.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            GitFetcher.$$$reportNull$$$0(20);
        }
        if (errors == null) {
            GitFetcher.$$$reportNull$$$0(21);
        }
        VcsNotifier notifier = VcsNotifier.getInstance((Project)project);
        if (result2.isSuccess()) {
            notifier.notifySuccess("git.fetch.success", "", GitBundle.message((String)"notification.content.fetched.successfully", (Object[])new Object[0]) + result2.getAdditionalInfo());
        } else if (result2.isNotAuthorized()) {
            if (errorNotificationTitle != null) {
                notifier.notifyError("git.fetch.error", errorNotificationTitle, GitBundle.message((String)"notification.content.fetch.failed.couldn.t.authorize", (Object[])new Object[0]) + result2.getAdditionalInfo());
            } else {
                notifier.notifyError("git.fetch.error", GitBundle.message((String)"notification.title.fetch.failed", (Object[])new Object[0]), GitBundle.message((String)"notification.content.couldn.t.authorize", (Object[])new Object[0]) + result2.getAdditionalInfo());
            }
        } else {
            VcsNotifier.getInstance((Project)project).notifyError("git.fetch.error", GitBundle.message((String)"notification.title.fetch.failed", (Object[])new Object[0]), result2.getAdditionalInfo(), errors);
        }
    }

    @Deprecated(forRemoval=true)
    public boolean fetchRootsAndNotify(@NotNull Collection<? extends GitRepository> roots, @NlsContexts.NotificationTitle @Nullable String errorNotificationTitle, boolean notifySuccess) {
        if (roots == null) {
            GitFetcher.$$$reportNull$$$0(22);
        }
        MultiRootMessage additionalInfo = new MultiRootMessage(this.myProject, GitUtil.getRootsFromRepositories(roots), false, true);
        for (GitRepository gitRepository : roots) {
            LOG.info("fetching " + String.valueOf(gitRepository));
            GitFetchResult result2 = this.fetch(gitRepository);
            String ai = result2.getAdditionalInfo();
            if (!StringUtil.isEmptyOrSpaces((String)ai)) {
                additionalInfo.append((Object)gitRepository.getRoot(), ai);
            }
            if (result2.isSuccess()) continue;
            ArrayList<Exception> errors = new ArrayList<Exception>(this.getErrors());
            errors.addAll(result2.getErrors());
            GitFetcher.displayFetchResult(this.myProject, result2, errorNotificationTitle, errors);
            return false;
        }
        if (notifySuccess) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.fetch.success", "", GitBundle.message((String)"notification.content.fetched.successfully", (Object[])new Object[0]));
        }
        if (!additionalInfo.asString().isEmpty()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorInfo("git.fetch.details", GitBundle.message((String)"notification.title.fetch.details", (Object[])new Object[0]), additionalInfo.asString());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 11, 14, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitFetcher";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitFetcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCurrentRemote";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCurrentBranch";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchAll";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchNatively";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFetchSpecForBranch";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fetchCurrentRemote";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fetchRemote";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetchCurrentBranch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFetchParams";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchAll";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fetchNatively";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFetchSpecForBranch";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "displayFetchResult";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fetchRootsAndNotify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 11, 14, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static class FetchParams {
        private GitRemote myRemote;
        private GitRemoteBranch myRemoteBranch;
        private GitFetchResult myError;

        FetchParams(GitFetchResult error) {
            this.myError = error;
        }

        FetchParams(GitRemote remote, GitRemoteBranch remoteBranch) {
            this.myRemote = remote;
            this.myRemoteBranch = remoteBranch;
        }

        boolean isError() {
            return this.myError != null;
        }

        public GitFetchResult getError() {
            return this.myError;
        }

        public GitRemote getRemote() {
            return this.myRemote;
        }

        public GitRemoteBranch getRemoteBranch() {
            return this.myRemoteBranch;
        }
    }

    private static class GitFetchPruneDetector
    implements GitLineHandlerListener {
        private static final Pattern PRUNE_PATTERN = Pattern.compile("\\s*x\\s*\\[deleted\\].*->\\s*(\\S*)");
        @NotNull
        private final Collection<String> myPrunedRefs = new ArrayList<String>();

        private GitFetchPruneDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PRUNE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myPrunedRefs.add(matcher.group(1));
            }
        }

        @NotNull
        public Collection<String> getPrunedRefs() {
            Collection<String> collection = this.myPrunedRefs;
            if (collection == null) {
                GitFetchPruneDetector.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher$GitFetchPruneDetector", "getPrunedRefs"));
        }
    }
}

