/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.lang.css.rearranger.CssRearranger;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0011\u001a\f0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0014J\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u001a\u001a\u00020\u00192\u000e\b\u0001\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0012\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010\u0002\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u00020\u00192\b\b\u0001\u0010\u0002\u001a\u00020\u0003H\u0016J\r\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b\u0014H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c2\u0006\u0010$\u001a\u00020\u0012H\u0002J\u0016\u0010%\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0002J\u000f\u0010&\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0017H\u0014J\b\u0010'\u001a\u00020(H\u0014J\r\u0010)\u001a\u00070*\u00a2\u0006\u0002\b\u0014H\u0014J\u0019\u0010+\u001a\t\u0018\u00010,\u00a2\u0006\u0002\b\u00172\b\b\u0001\u0010-\u001a\u00020.H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/psi/css/codeStyle/CssArrangementSettingsPanel;", "Lcom/intellij/application/options/CodeStyleAbstractPanel;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/lang/Language;)V", "sortPropertiesCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "sortByNameRadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "customOrderRadioButton", "customOrderField", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "mainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getTabTitle", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "Lorg/jetbrains/annotations/NotNull;", "getPanel", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/Nullable;", "resetImpl", "", "resetCustomListByRules", "rules", "", "Lcom/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule;", "isModified", "", "apply", "getSettingsFromUI", "Lcom/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings;", "splitPropertiesList", "propertiesList", "joinPropertiesList", "getPreviewText", "getRightMargin", "", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "createHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Companion", "intellij.css.common"})
@SourceDebugExtension(value={"SMAP\nCssArrangementSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssArrangementSettingsPanel.kt\ncom/intellij/psi/css/codeStyle/CssArrangementSettingsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,200:1\n1#2:201\n37#3,2:202\n*S KotlinDebug\n*F\n+ 1 CssArrangementSettingsPanel.kt\ncom/intellij/psi/css/codeStyle/CssArrangementSettingsPanel\n*L\n176#1:202,2\n*E\n"})
public final class CssArrangementSettingsPanel
extends CodeStyleAbstractPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    private JBCheckBox sortPropertiesCheckBox;
    private JBRadioButton sortByNameRadioButton;
    private JBRadioButton customOrderRadioButton;
    @NotNull
    private final ExpandableTextField customOrderField;
    @NotNull
    private final DialogPanel mainPanel;
    @VisibleForTesting
    @NotNull
    public static final String VENDOR_PREFIX_PATTERN = "(-[a-z]+-)?";

    /*
     * WARNING - void declaration
     */
    public CssArrangementSettingsPanel(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        void $this$mainPanel_u24lambda_u241;
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        super(settings);
        this.language = language;
        this.customOrderField = new ExpandableTextField(arg_0 -> CssArrangementSettingsPanel.customOrderField$lambda$0((Function1)new Function1<String, List<? extends String>>((Object)this){

            public final List<String> invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CssArrangementSettingsPanel.access$splitPropertiesList((CssArrangementSettingsPanel)((Object)this.receiver), p0);
            }
        }, arg_0), arg_0 -> CssArrangementSettingsPanel.customOrderField$lambda$1((Function1)new Function1<List<? extends String>, String>((Object)this){

            public final String invoke(List<String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return CssArrangementSettingsPanel.access$joinPropertiesList((CssArrangementSettingsPanel)((Object)this.receiver), p0);
            }
        }, arg_0));
        DialogPanel dialogPanel2 = dialogPanel = BuilderKt.panel(arg_0 -> CssArrangementSettingsPanel.mainPanel$lambda$0(this, arg_0));
        CssArrangementSettingsPanel cssArrangementSettingsPanel = this;
        boolean bl = false;
        $this$mainPanel_u24lambda_u241.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBInsets.create((int)10, (int)10))));
        cssArrangementSettingsPanel.mainPanel = dialogPanel;
    }

    @NotNull
    protected String getTabTitle() {
        String string = ApplicationBundle.message((String)"arrangement.title.settings.tab", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public JComponent getPanel() {
        return (JComponent)this.mainPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        ArrangementSettings arrangementSettings = settings.getCommonSettings(this.language).getArrangementSettings();
        CssSupportedFileTypesProvider provider = CssSupportedFileTypesProvider.findProvider((Language)this.language);
        if (provider == null) {
            boolean $i$a$-requireNotNull-CssArrangementSettingsPanel$resetImpl$22 = false;
            Language $i$a$-requireNotNull-CssArrangementSettingsPanel$resetImpl$22 = this.language;
            throw new IllegalArgumentException($i$a$-requireNotNull-CssArrangementSettingsPanel$resetImpl$22.toString());
        }
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(provider.getCustomCodeStyleSettingsClass());
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        CssCodeStyleSettings customSettings = (CssCodeStyleSettings)customCodeStyleSettings;
        if (arrangementSettings == null || arrangementSettings.getSections().isEmpty()) {
            JBCheckBox jBCheckBox = this.sortPropertiesCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortPropertiesCheckBox");
                jBCheckBox = null;
            }
            jBCheckBox.setSelected(false);
            JBRadioButton jBRadioButton = this.sortByNameRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortByNameRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
            this.customOrderField.setText(customSettings.PROPERTIES_ORDER);
        } else if (CssRearranger.isSortPropertiesByName(arrangementSettings)) {
            JBCheckBox jBCheckBox = this.sortPropertiesCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortPropertiesCheckBox");
                jBCheckBox = null;
            }
            jBCheckBox.setSelected(true);
            JBRadioButton jBRadioButton = this.sortByNameRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortByNameRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
            this.customOrderField.setText(customSettings.PROPERTIES_ORDER);
        } else {
            JBCheckBox jBCheckBox = this.sortPropertiesCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortPropertiesCheckBox");
                jBCheckBox = null;
            }
            jBCheckBox.setSelected(true);
            JBRadioButton jBRadioButton = this.customOrderRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customOrderRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
            List list = ArrangementUtil.collectMatchRules((List)arrangementSettings.getSections());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectMatchRules(...)");
            this.resetCustomListByRules(list);
        }
        this.customOrderField.setCaretPosition(0);
    }

    private final void resetCustomListByRules(@NotNull List<? extends StdArrangementMatchRule> rules) {
        List list;
        List $this$resetCustomListByRules_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (StdArrangementMatchRule stdArrangementMatchRule : rules) {
            ArrangementMatchCondition condition;
            Intrinsics.checkNotNullExpressionValue((Object)stdArrangementMatchRule.getMatcher().getCondition(), (String)"getCondition(...)");
            if (!(condition instanceof ArrangementAtomMatchCondition) || !Intrinsics.areEqual((Object)((ArrangementAtomMatchCondition)condition).getType(), (Object)StdArrangementTokens.Regexp.NAME)) continue;
            String namePattern = ((ArrangementAtomMatchCondition)condition).getValue().toString();
            String propertyName = StringsKt.removePrefix((String)namePattern, (CharSequence)VENDOR_PREFIX_PATTERN);
            $this$resetCustomListByRules_u24lambda_u240.add(propertyName);
        }
        List customOrder = CollectionsKt.build((List)list);
        this.customOrderField.setText(this.joinPropertiesList(customOrder));
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CssSupportedFileTypesProvider provider = CssSupportedFileTypesProvider.findProvider((Language)this.language);
        if (provider == null) {
            boolean $i$a$-requireNotNull-CssArrangementSettingsPanel$isModified$22 = false;
            Language $i$a$-requireNotNull-CssArrangementSettingsPanel$isModified$22 = this.language;
            throw new IllegalArgumentException($i$a$-requireNotNull-CssArrangementSettingsPanel$isModified$22.toString());
        }
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(provider.getCustomCodeStyleSettingsClass());
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        CssCodeStyleSettings customSettings = (CssCodeStyleSettings)customCodeStyleSettings;
        String currentCustomOrder = this.customOrderField.getText();
        if (Intrinsics.areEqual((Object)currentCustomOrder, (Object)CssCodeStyleSettings.DEFAULT_PROPERTIES_ORDER) && !Intrinsics.areEqual((Object)currentCustomOrder, (Object)customSettings.PROPERTIES_ORDER)) {
            return true;
        }
        StdArrangementSettings saved = (StdArrangementSettings)settings.getCommonSettings(this.language).getArrangementSettings();
        StdArrangementSettings fromUI = this.getSettingsFromUI();
        if (saved == null || saved.getRules().isEmpty()) {
            List list = fromUI.getRules();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRules(...)");
            return !((Collection)list).isEmpty();
        }
        return !Intrinsics.areEqual((Object)saved, (Object)fromUI);
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        block8: {
            CssSupportedFileTypesProvider provider;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                    settings.getCommonSettings(this.language).setArrangementSettings((ArrangementSettings)this.getSettingsFromUI());
                    JBCheckBox jBCheckBox = this.sortPropertiesCheckBox;
                    if (jBCheckBox == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"sortPropertiesCheckBox");
                        jBCheckBox = null;
                    }
                    if (!jBCheckBox.isSelected()) break block6;
                    JBRadioButton jBRadioButton = this.customOrderRadioButton;
                    if (jBRadioButton == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"customOrderRadioButton");
                        jBRadioButton = null;
                    }
                    if (jBRadioButton.isSelected()) break block7;
                }
                if (!Intrinsics.areEqual((Object)this.customOrderField.getText(), (Object)CssCodeStyleSettings.DEFAULT_PROPERTIES_ORDER)) break block8;
            }
            if ((provider = CssSupportedFileTypesProvider.findProvider((Language)this.language)) == null) {
                boolean $i$a$-requireNotNull-CssArrangementSettingsPanel$apply$22 = false;
                Language $i$a$-requireNotNull-CssArrangementSettingsPanel$apply$22 = this.language;
                throw new IllegalArgumentException($i$a$-requireNotNull-CssArrangementSettingsPanel$apply$22.toString());
            }
            CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(provider.getCustomCodeStyleSettingsClass());
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            CssCodeStyleSettings customSettings = (CssCodeStyleSettings)customCodeStyleSettings;
            customSettings.PROPERTIES_ORDER = this.customOrderField.getText();
        }
    }

    private final StdArrangementSettings getSettingsFromUI() {
        StdArrangementSettings stdArrangementSettings;
        JBCheckBox jBCheckBox = this.sortPropertiesCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortPropertiesCheckBox");
            jBCheckBox = null;
        }
        if (!jBCheckBox.isSelected()) {
            stdArrangementSettings = new StdArrangementSettings();
        } else {
            JBRadioButton jBRadioButton = this.sortByNameRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortByNameRadioButton");
                jBRadioButton = null;
            }
            if (jBRadioButton.isSelected()) {
                StdArrangementMatchRule[] stdArrangementMatchRuleArray = new StdArrangementMatchRule[]{CssRearranger.SORT_BY_NAME_RULE};
                StdArrangementSettings stdArrangementSettings2 = new StdArrangementSettings(CollectionsKt.listOf((Object)ArrangementSectionRule.create((StdArrangementMatchRule[])stdArrangementMatchRuleArray)));
                stdArrangementSettings = stdArrangementSettings2;
            } else {
                String string = this.customOrderField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                List<String> properties = this.splitPropertiesList(string);
                ArrayList<StdArrangementMatchRule> rules = new ArrayList<StdArrangementMatchRule>(properties.size());
                for (String propertyName : properties) {
                    String namePattern = VENDOR_PREFIX_PATTERN + propertyName;
                    rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)namePattern)), StdArrangementTokens.Order.BY_NAME));
                }
                Collection $this$toTypedArray$iv = rules;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                StdArrangementMatchRule[] stdArrangementMatchRuleArray = thisCollection$iv.toArray(new StdArrangementMatchRule[0]);
                StdArrangementSettings stdArrangementSettings3 = new StdArrangementSettings(CollectionsKt.listOf((Object)ArrangementSectionRule.create((StdArrangementMatchRule[])Arrays.copyOf(stdArrangementMatchRuleArray, stdArrangementMatchRuleArray.length))));
                stdArrangementSettings = stdArrangementSettings3;
            }
        }
        return stdArrangementSettings;
    }

    private final List<String> splitPropertiesList(String propertiesList) {
        char[] cArray = new char[]{' '};
        return StringsKt.split$default((CharSequence)StringsKt.replace$default((String)propertiesList, (char)',', (char)' ', (boolean)false, (int)4, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    private final String joinPropertiesList(List<String> propertiesList) {
        return CollectionsKt.joinToString$default((Iterable)propertiesList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    protected String getPreviewText() {
        return null;
    }

    protected int getRightMargin() {
        Logger.getInstance(CssArrangementSettingsPanel.class).error("This method should not be called because getPreviewText() returns null");
        return 0;
    }

    @NotNull
    protected FileType getFileType() {
        Logger.getInstance(CssArrangementSettingsPanel.class).error("This method should not be called because getPreviewText() returns null");
        FileType fileType = FileTypes.UNKNOWN;
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"UNKNOWN");
        return fileType;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return null;
    }

    private static final List customOrderField$lambda$0(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final String customOrderField$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit mainPanel$lambda$0(CssArrangementSettingsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CssArrangementSettingsPanel.mainPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> CssArrangementSettingsPanel.mainPanel$lambda$0$1(this$0, arg_0), (int)3, null);
        JBCheckBox jBCheckBox = this$0.sortPropertiesCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortPropertiesCheckBox");
            jBCheckBox = null;
        }
        buttonsGroup.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox)));
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$0(CssArrangementSettingsPanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CssBundle.message((String)"settings.sort.css.properties", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = $this$row.checkBox(string);
        boolean bl = false;
        this$0.sortPropertiesCheckBox = (JBCheckBox)it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1(CssArrangementSettingsPanel this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> CssArrangementSettingsPanel.mainPanel$lambda$0$1$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> CssArrangementSettingsPanel.mainPanel$lambda$0$1$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1$0(CssArrangementSettingsPanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CssBundle.message((String)"settings.by.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null);
        boolean bl = false;
        this$0.sortByNameRadioButton = (JBRadioButton)it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1$1(CssArrangementSettingsPanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CssBundle.message((String)"settings.custom.order", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null);
        boolean bl = false;
        this$0.customOrderRadioButton = (JBRadioButton)it.getComponent();
        cell.onChanged(arg_0 -> CssArrangementSettingsPanel.mainPanel$lambda$0$1$1$1(this$0, arg_0));
        Cell cell2 = $this$row.cell((JComponent)this$0.customOrderField);
        JBRadioButton jBRadioButton = this$0.customOrderRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customOrderRadioButton");
            jBRadioButton = null;
        }
        Cell.comment$default((Cell)cell2.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton))).align((Align)AlignX.FILL.INSTANCE), (String)CssBundle.message((String)"settings.comma.separated.list.of.css.properties.without.vendor.prefix", (Object[])new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1$1$1(CssArrangementSettingsPanel this$0, JBRadioButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JBRadioButton jBRadioButton = this$0.customOrderRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customOrderRadioButton");
            jBRadioButton = null;
        }
        if (jBRadioButton.isSelected()) {
            IdeFocusManager.findInstance().requestFocus((Component)this$0.customOrderField, true);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$splitPropertiesList(CssArrangementSettingsPanel $this, String propertiesList) {
        return $this.splitPropertiesList(propertiesList);
    }

    public static final /* synthetic */ String access$joinPropertiesList(CssArrangementSettingsPanel $this, List propertiesList) {
        return $this.joinPropertiesList(propertiesList);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/psi/css/codeStyle/CssArrangementSettingsPanel$Companion;", "", "<init>", "()V", "VENDOR_PREFIX_PATTERN", "", "intellij.css.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

