/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.providers.SqlCompletionProviderBase;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlParameterNamesCompletionProvider
extends SqlCompletionProviderBase {
    private final Set<String> EMPTY_STRING_SET = new HashSet<String>();

    @Override
    protected void doAddCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        SqlLanguageDialectEx dialect;
        String separator;
        if (parameters == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((separator = SqlParameterNamesCompletionProvider.getSeparator(dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)parameters.getOriginalFile()))) == null) {
            return;
        }
        PsiElement position = parameters.getPosition();
        int offset = position.getTextRange().getStartOffset();
        SqlExpressionList params = (SqlExpressionList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlExpressionList.class);
        SqlFunctionCallExpressionImpl foo = (SqlFunctionCallExpressionImpl)((Object)ObjectUtils.tryCast((Object)(params == null ? null : params.getParent()), SqlFunctionCallExpressionImpl.class));
        if (foo == null) {
            return;
        }
        SqlExpression slot = (SqlExpression)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)params).expand(e -> e == params)).filter(SqlExpression.class).filter(e -> e.getTextRange().contains(offset)).first();
        if (slot == null || slot instanceof SqlNamedParameterValueExpression) {
            return;
        }
        PsiElement nonEmpty = (PsiElement)JBIterable.generate((Object)position, PsiTreeUtil::prevVisibleLeaf).skip(1).skipWhile(e -> e instanceof PsiComment || e instanceof PsiWhiteSpace).first();
        if (nonEmpty != null && slot.getTextRange().contains(nonEmpty.getTextRange().getStartOffset())) {
            return;
        }
        SqlExpressionList list = foo.getParameterList();
        Set<String> existingParams = this.getExistingParamNames(separator, list);
        LinkedHashMap entries = new LinkedHashMap();
        SqlFunctionCallExpressionImpl.processParameters(foo.getNameElement(), (Processor<? super DasSymbol>)((Processor)p2 -> {
            String objectName = p2.getName();
            if (StringUtil.isEmpty((String)objectName) || existingParams.contains(objectName)) {
                return true;
            }
            entries.put(objectName, p2);
            return true;
        }), position);
        int priority = 150;
        Icon icon = DbPresentationCore.getIcon((ObjectKind)ObjectKind.ARGUMENT);
        if (existingParams.isEmpty() && !entries.isEmpty()) {
            String allParamText = StringUtil.join(entries.values(), symbol -> {
                String name = symbol.getName();
                if (!SqlParameterNamesCompletionProvider.avoidQuoting(symbol)) {
                    name = SqlCompletionUtil.getNameQuotationSettingAware(name, symbol.getKind(), parameters.getOriginalFile());
                }
                return name + " " + separator + " _";
            }, (String)", ");
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)allParamText).withIcon(icon).withInsertHandler((ctx, item) -> {
                SqlExpressionList originalParams = (SqlExpressionList)PsiTreeUtil.getParentOfType((PsiElement)parameters.getOriginalPosition(), SqlExpressionList.class);
                if (originalParams == null) {
                    return;
                }
                TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)originalParams);
                for (SqlExpression expression : originalParams.getExpressionList()) {
                    SqlExpression argument;
                    if (!(expression instanceof SqlNamedParameterValueExpression) || (argument = ((SqlNamedParameterValueExpression)expression).getROperand()) == null) continue;
                    builder.replaceElement((PsiElement)argument, argument.getText());
                }
                Template template = builder.buildInlineTemplate();
                Editor editor = ctx.getEditor();
                editor.getCaretModel().moveToOffset(originalParams.getTextRange().getStartOffset());
                TemplateManager.getInstance((Project)ctx.getProject()).startTemplate(editor, template);
            }), (double)priority));
        }
        for (Map.Entry entry : entries.entrySet()) {
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)((String)entry.getKey())).appendTailText(" " + separator, true).withIcon(icon).withInsertHandler((ctx, item) -> {
                if (!SqlParameterNamesCompletionProvider.avoidQuoting((DasSymbol)entry.getValue())) {
                    SqlInsertHandlers.QUOT_INSERT_HANDLER.handleInsert(ctx, item);
                }
                String suffix = " " + separator + " ";
                ctx.getDocument().insertString(ctx.getTailOffset(), (CharSequence)suffix);
                ctx.getEditor().getCaretModel().moveCaretRelatively(suffix.length(), 0, false, false, false);
            }), (double)(priority - 1)));
        }
    }

    @NotNull
    private Set<String> getExistingParamNames(@NotNull String separator, @Nullable SqlExpressionList list) {
        if (separator == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(3);
        }
        if (list == null) {
            Set<String> set = this.EMPTY_STRING_SET;
            if (set == null) {
                SqlParameterNamesCompletionProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        List expressionList = list.getExpressionList();
        HashSet<String> result = new HashSet<String>(expressionList.size());
        for (SqlExpression expression : expressionList) {
            String name;
            if (!(expression instanceof SqlNamedParameterValueExpression) || (name = expression.getName()) == null) continue;
            if (name.contains(separator)) {
                name = name.split(separator)[0].trim();
            }
            result.add(name);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static boolean avoidQuoting(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(6);
        }
        return SqlCompletionUtil.hasPlainIdentifier(symbol);
    }

    @Nullable
    private static String getSeparator(SqlLanguageDialectEx dialect) {
        if (dialect.getDbms().isTransactSql()) {
            return "=";
        }
        if (dialect.getDbms().isPostgres()) {
            return ":=";
        }
        if (dialect.getDbms().isOracle()) {
            return "=>";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlParameterNamesCompletionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlParameterNamesCompletionProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingParamNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doAddCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExistingParamNames";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "avoidQuoting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

