/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.ObjectKind;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.formatter.SqlFormatterHelper;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FindPhraseResult;
import com.intellij.sql.formatter.model.NodeBlockFactoryRecord;
import com.intellij.sql.formatter.model.SqlAS;
import com.intellij.sql.formatter.model.SqlAliasBlock;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlAlterTableBlock;
import com.intellij.sql.formatter.model.SqlArrayAccessBlock;
import com.intellij.sql.formatter.model.SqlAssignmentBlock;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockCommentBlock;
import com.intellij.sql.formatter.model.SqlBlockStatementBlock;
import com.intellij.sql.formatter.model.SqlCaseExpressionBlock;
import com.intellij.sql.formatter.model.SqlCaseStatementBlock;
import com.intellij.sql.formatter.model.SqlColumnAliasCortegeBlock;
import com.intellij.sql.formatter.model.SqlColumnBlock;
import com.intellij.sql.formatter.model.SqlColumnDefaultBlock;
import com.intellij.sql.formatter.model.SqlColumnNullabilityBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlComplexTextBlock;
import com.intellij.sql.formatter.model.SqlConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlConstraintDetailBlock;
import com.intellij.sql.formatter.model.SqlCortegeBlock;
import com.intellij.sql.formatter.model.SqlCreateExoticObjectBlock;
import com.intellij.sql.formatter.model.SqlCreateSchemaBlock;
import com.intellij.sql.formatter.model.SqlCreateTableBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlDeclareSectionBlock;
import com.intellij.sql.formatter.model.SqlDropRoutineBlock;
import com.intellij.sql.formatter.model.SqlElsifSectionBlock;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlExistsClauseBlock;
import com.intellij.sql.formatter.model.SqlExplainPlanBlock;
import com.intellij.sql.formatter.model.SqlExternalParameterBlock;
import com.intellij.sql.formatter.model.SqlFileBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlForeignKeyReferencesBlock;
import com.intellij.sql.formatter.model.SqlForkBlock;
import com.intellij.sql.formatter.model.SqlForkSectionBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFunctionCallBlock;
import com.intellij.sql.formatter.model.SqlHeadLoopBlock;
import com.intellij.sql.formatter.model.SqlIdentifierBlock;
import com.intellij.sql.formatter.model.SqlInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlLiteralBlock;
import com.intellij.sql.formatter.model.SqlLiteralInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlLoopBlock;
import com.intellij.sql.formatter.model.SqlMergeBlock;
import com.intellij.sql.formatter.model.SqlMonolithBlock;
import com.intellij.sql.formatter.model.SqlNamedConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlNullabilityCheckBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedExpressionBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPgDoStatementBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReferenceBlock;
import com.intellij.sql.formatter.model.SqlRepeatLoopBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.model.SqlRoutineBlockKt;
import com.intellij.sql.formatter.model.SqlShortPhraseBlock;
import com.intellij.sql.formatter.model.SqlSimpleLoopBlock;
import com.intellij.sql.formatter.model.SqlSimpleSettingAssignmentBlock;
import com.intellij.sql.formatter.model.SqlSimpleTypeBlock;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import com.intellij.sql.formatter.model.SqlSizeBlock;
import com.intellij.sql.formatter.model.SqlStatementBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.model.SqlTableTypeBlock;
import com.intellij.sql.formatter.model.SqlTriggerBlock;
import com.intellij.sql.formatter.model.SqlTypeParameterListBlock;
import com.intellij.sql.formatter.model.SqlUnsortedBlock;
import com.intellij.sql.formatter.model.SqlViewBlock;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStubElementType;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlTableElementType;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00fc\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0019*\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a(\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0006H\u0002\u001a\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020+H\u0002\u001a\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020.H\u0002\u001aI\u00104\u001a\u0002H5\"\b\b\u0000\u00105*\u00020\u0004*\u0002H52,\u00106\u001a(\u0012\u0004\u0012\u0002H5\u0012\u0013\u0012\u0011H5\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020;07\u00a2\u0006\u0002\b<H\u0000\u00a2\u0006\u0002\u0010=\u001a\f\u0010A\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a \u0010B\u001a\u0004\u0018\u0001H5\"\n\b\u0000\u00105\u0018\u0001*\u00020\u0004*\u00020\u0004H\u0080\b\u00a2\u0006\u0002\u0010C\u001a\u000e\u0010D\u001a\u0004\u0018\u00010\u0014*\u00020\u0004H\u0000\u001a\u000e\u0010E\u001a\u0004\u0018\u00010\u0002*\u00020\u0004H\u0000\u001a\u0012\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a*\u00020\u0014H\u0000\u001a&\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a*\u00020\u00142\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020?0HH\u0000\u001a\u0018\u0010I\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a \u0010J\u001a\u00020?*\u00020\u00142\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020?0HH\u0002\u001a\n\u0010L\u001a\u00020?*\u00020\u0014\u001a6\u0010M\u001a\u00020N*\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001d\u001a\u00020\u00022\b\b\u0002\u0010O\u001a\u00020N2\b\b\u0002\u0010P\u001a\u00020N2\b\b\u0002\u0010Q\u001a\u00020N\u001a<\u0010M\u001a\u00020N*\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\b\b\u0002\u0010O\u001a\u00020N2\b\b\u0002\u0010P\u001a\u00020N2\b\b\u0002\u0010Q\u001a\u00020N\u001a0\u0010S\u001a\u0004\u0018\u00010T*\b\u0012\u0004\u0012\u00020\u00140\u001a2\b\b\u0002\u0010O\u001a\u00020N2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020?0H\u001a5\u0010U\u001a\u0004\u0018\u00010V*\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010W\u001a\u00020N2\u0014\u0010X\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020Y0Y\u00a2\u0006\u0002\u0010Z\u001a\u0006\u0010^\u001a\u00020_\u001a\u0006\u0010`\u001a\u00020_\u001a\u0006\u0010a\u001a\u00020_\u001a\u0006\u0010b\u001a\u00020_\u001a\u000e\u0010c\u001a\u0004\u0018\u00010d*\u0004\u0018\u00010e\u001a\f\u0010f\u001a\u00020?*\u0004\u0018\u00010e\u001a+\u0010g\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040h\u00a2\u0006\u0002\bi*\b\u0012\u0004\u0012\u00020\u00040j2\u0006\u0010k\u001a\u00020N\u001a\u001a\u0010l\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040j2\u0006\u0010m\u001a\u00020n\u001a\u001a\u0010l\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040j2\u0006\u0010\u001d\u001a\u00020\u0002\u001a&\u0010l\u001a\u0004\u0018\u0001H5\"\n\b\u0000\u00105\u0018\u0001*\u00020o*\b\u0012\u0004\u0012\u00020o0jH\u0086\b\u00a2\u0006\u0002\u0010p\u001a+\u0010q\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040h\u00a2\u0006\u0002\bi*\b\u0012\u0004\u0012\u00020\u00040j2\u0006\u0010m\u001a\u00020n\u001a3\u0010q\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040h\u00a2\u0006\u0002\bi*\b\u0012\u0004\u0012\u00020\u00040j2\u0006\u0010r\u001a\u00020n2\u0006\u0010s\u001a\u00020n\u001a;\u0010q\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040h\u00a2\u0006\u0002\bi*\b\u0012\u0004\u0012\u00020\u00040j2\u0006\u0010r\u001a\u00020n2\u0006\u0010s\u001a\u00020n2\u0006\u0010t\u001a\u00020n\u001a+\u0010q\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040h\u00a2\u0006\u0002\bi*\b\u0012\u0004\u0012\u00020\u00040j2\u0006\u0010\u001d\u001a\u00020\u0002\u001a<\u0010q\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040h\u00a2\u0006\u0002\bi*\b\u0012\u0004\u0012\u00020\u00040j2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020Y\"\u00020\u0002\u00a2\u0006\u0002\u0010u\u001a%\u0010q\u001a\b\u0012\u0004\u0012\u0002H50h\"\n\b\u0000\u00105\u0018\u0001*\u00020o*\b\u0012\u0004\u0012\u00020o0jH\u0086\b\u001a(\u0010{\u001a\u0004\u0018\u00010\u0004*\u00020\u00042\u0006\u0010W\u001a\u00020N2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020?0H\"\"\u0010\u0000\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"6\u0010\u0005\u001a$\u0012\u0004\u0012\u00020\u0006\u0012\u001a\u0012\u0018\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u00a5\u0001\u0010\t\u001a\u0092\u0001\u0012\u008d\u0001\u0012\u008a\u0001\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0014\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*D\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0014\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\u000b0\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u001c\u0010/\u001a\u0004\u0018\u000100*\u0004\u0018\u0001018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\"\u0018\u0010>\u001a\u00020?*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010@\"\u0016\u0010[\u001a\u00020N*\u00020T8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]\",\u0010v\u001a\b\u0012\u0004\u0012\u0002H50h\"\b\b\u0000\u00105*\u00020o*\b\u0012\u0004\u0012\u0002H50j8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bw\u0010x\"\u0018\u0010m\u001a\u00020n*\u0004\u0018\u00010\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\by\u0010z\u00a8\u0006|"}, d2={"COMMON_SIMPLE_ELEMENT_BLOCKS", "", "Lcom/intellij/psi/tree/IElementType;", "Lkotlin/reflect/KClass;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "DIALECT_SPECIFIC_BLOCKS", "Lcom/intellij/database/Dbms;", "getDIALECT_SPECIFIC_BLOCKS", "()Ljava/util/Map;", "CONSTRAINT_TYPES", "", "Lcom/intellij/sql/psi/stubs/SqlDefinitionStubElementType;", "Lcom/intellij/sql/psi/stubs/SqlNamedElementStub;", "Lcom/intellij/sql/psi/SqlDefinition;", "kotlin.jvm.PlatformType", "getCONSTRAINT_TYPES", "()Ljava/util/Set;", "makeDefaultBlock", "parent", "node", "Lcom/intellij/lang/ASTNode;", "instantiateDefaultBlock", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "findCreatorFor", "Lkotlin/reflect/KFunction0;", "", "Lcom/intellij/sql/formatter/model/NodeBlockFactoryRecord;", "instantiateCommonDefaultBlock", "type", "dbms", "createBlockForUnspecifiedLoop", "Lcom/intellij/sql/formatter/model/SqlLoopBlock;", "createBlockForParenthesizedExpression", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "createBlockForBinaryExpression", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "createBlockForStatement", "createBlockForIdentifier", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "createBlockForConstraint", "createDropBlock", "createUnaryExpressionBlock", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "createFunctionCallOrSubqueryClause", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "lowerName", "", "Lcom/intellij/database/model/DasNamed;", "getLowerName", "(Lcom/intellij/database/model/DasNamed;)Ljava/lang/String;", "init", "B", "initializer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "that", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/sql/formatter/model/SqlBlock;Lkotlin/jvm/functions/Function2;)Lcom/intellij/sql/formatter/model/SqlBlock;", "isRoutine", "", "(Lcom/intellij/psi/tree/IElementType;)Z", "adjust", "findParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)Lcom/intellij/sql/formatter/model/SqlBlock;", "primaryNode", "primaryElementType", "listChildren", "flatten", "Lkotlin/Function1;", "handleStringLiteral", "hasOnlyOneChild", "predicate", "hasInjection", "indexOf", "", "since", "till", "notFound", "types", "findConsequence", "Lkotlin/ranges/IntRange;", "findPhrase", "Lcom/intellij/sql/formatter/model/FindPhraseResult;", "offset", "patterns", "", "(Ljava/util/List;I[[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/sql/formatter/model/FindPhraseResult;", "finish", "getFinish", "(Lkotlin/ranges/IntRange;)I", "makeLeftAlignment", "Lcom/intellij/formatting/Alignment;", "makeLeftAlignmentBS", "makeRightAlignment", "makeRightAlignmentBS", "getType", "Lcom/intellij/formatting/WrapImpl$Type;", "Lcom/intellij/formatting/Wrap;", "isAlways", "skip", "Lcom/intellij/util/containers/JBIterable;", "Lorg/jetbrains/annotations/NotNull;", "", "count", "find", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "Lcom/intellij/formatting/Block;", "(Ljava/lang/Iterable;)Lcom/intellij/formatting/Block;", "filter", "role1", "role2", "role3", "(Ljava/lang/Iterable;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/util/containers/JBIterable;", "jbi", "getJbi", "(Ljava/lang/Iterable;)Lcom/intellij/util/containers/JBIterable;", "getRole", "(Lcom/intellij/sql/formatter/model/SqlBlock;)Lcom/intellij/sql/formatter/model/BlockRole;", "findFirstInnerBlockOnTheSameLine", "intellij.database.sql.core.impl"})
@JvmName(name="SqlFormattingModelFun")
@SourceDebugExtension(value={"SMAP\nSqlFormattingModelFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,489:1\n470#1:498\n470#1:500\n470#1:501\n470#1:502\n470#1:503\n470#1:504\n470#1:505\n831#2,2:490\n1022#2,2:492\n945#2,2:494\n1112#2,2:496\n1#3:499\n*S KotlinDebug\n*F\n+ 1 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n*L\n450#1:498\n458#1:500\n460#1:501\n462#1:502\n464#1:503\n466#1:504\n468#1:505\n118#1:490,2\n119#1:492,2\n120#1:494,2\n121#1:496,2\n*E\n"})
public final class SqlFormattingModelFun {
    @NotNull
    private static final Map<IElementType, KClass<? extends SqlBlock>> COMMON_SIMPLE_ELEMENT_BLOCKS;
    @NotNull
    private static final Map<Dbms, Map<? extends IElementType, KClass<? extends SqlBlock>>> DIALECT_SPECIFIC_BLOCKS;
    @NotNull
    private static final Set<SqlDefinitionStubElementType<? extends SqlNamedElementStub<? extends SqlDefinition>, ? extends SqlDefinition>> CONSTRAINT_TYPES;

    @NotNull
    public static final Map<Dbms, Map<? extends IElementType, KClass<? extends SqlBlock>>> getDIALECT_SPECIFIC_BLOCKS() {
        return DIALECT_SPECIFIC_BLOCKS;
    }

    @NotNull
    public static final Set<SqlDefinitionStubElementType<? extends SqlNamedElementStub<? extends SqlDefinition>, ? extends SqlDefinition>> getCONSTRAINT_TYPES() {
        return CONSTRAINT_TYPES;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SqlBlock makeDefaultBlock(@NotNull SqlBlock parent, @NotNull ASTNode node) {
        SqlBlock block;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        KClass<? extends SqlBlock> specificBlockClass = parent.getContext().getDialectSpecificBlocks().get(type);
        SqlBlock sqlBlock = block = specificBlockClass == null ? SqlFormattingModelFun.instantiateDefaultBlock(node, parent.getContext()) : (SqlBlock)KClasses.createInstance(specificBlockClass);
        if (sqlBlock instanceof SqlNodeBlock) {
            void parent$iv;
            void $this$withSetup$iv;
            SqlNodeBlock sqlNodeBlock = (SqlNodeBlock)block;
            SqlBlock sqlBlock2 = parent;
            ASTNode mainNode$iv = node;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl((SqlBlock)parent$iv, mainNode$iv);
        } else if (sqlBlock instanceof SqlLeafBlock) {
            SqlLeafBlock $this$withSetup$iv = (SqlLeafBlock)block;
            SqlBlock parent$iv = parent;
            ASTNode node$iv = node;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup(parent$iv, node$iv);
        } else if (sqlBlock instanceof SqlRangeBlock) {
            SqlRangeBlock $this$withSetup$iv = (SqlRangeBlock)block;
            SqlBlock parent$iv = parent;
            ASTNode outerNode$iv = node;
            boolean $i$f$withSetup = false;
            TextRange textRange = outerNode$iv.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, textRange, SqlFormattingModelFun.listChildren(outerNode$iv));
        } else if (sqlBlock instanceof SqlInjectionHostBlock) {
            SqlInjectionHostBlock $this$withSetup$iv = (SqlInjectionHostBlock)block;
            SqlBlock parent$iv = parent;
            ASTNode node$iv = node;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, node$iv);
        }
        return block;
    }

    @NotNull
    public static final SqlBlock instantiateDefaultBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context) {
        KClass<? extends SqlBlock> simpleBlockClass;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Dbms dbms = context.getDialect().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = SqlFormattingModelFun.adjust(iElementType);
        SqlFormatterHelper dialectHelper = context.getDialectHelper();
        SqlBlock block = null;
        if (dialectHelper != null) {
            KFunction<SqlBlock> creator = dialectHelper.getBasicBlockCreation().get(type);
            if (creator == null) {
                creator = SqlFormattingModelFun.findCreatorFor(dialectHelper.getComplexBlockCreation(), node);
            }
            if (creator != null) {
                block = (SqlBlock)((Function0)creator).invoke();
            }
        }
        if (block == null && (simpleBlockClass = COMMON_SIMPLE_ELEMENT_BLOCKS.get(type)) != null) {
            block = (SqlBlock)KClasses.createInstance(simpleBlockClass);
        }
        if (block == null) {
            block = SqlFormattingModelFun.instantiateCommonDefaultBlock(type, node, dbms2, context);
        }
        return block;
    }

    private static final KFunction<SqlBlock> findCreatorFor(List<NodeBlockFactoryRecord> $this$findCreatorFor, ASTNode node) {
        for (NodeBlockFactoryRecord r : $this$findCreatorFor) {
            if (!r.getMatcher().matches(node)) continue;
            return r.getCreator();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final SqlBlock instantiateCommonDefaultBlock(IElementType type, ASTNode node, Dbms dbms, SqlFormattingContext context) {
        SqlBlock sqlBlock;
        if (type instanceof SqlKeywordTokenType) {
            sqlBlock = Intrinsics.areEqual((Object)((SqlKeywordTokenType)type), (Object)SqlCommonKeywords.SQL_AS) ? (SqlKeyword)new SqlAS() : new SqlKeyword();
            return sqlBlock;
        }
        if (SqlUtilFun.isSymbol(node)) {
            sqlBlock = Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_COMMA) ? (SqlSymbol)new SqlComma() : new SqlSymbol();
            return sqlBlock;
        }
        if (node instanceof IsExternal) {
            sqlBlock = new SqlLeafBlock();
            return sqlBlock;
        }
        if (node instanceof PsiErrorElement) {
            sqlBlock = new SqlErrorNodeBlock();
            return sqlBlock;
        }
        if (node instanceof SqlColumnAliasListImpl) {
            sqlBlock = new SqlColumnAliasCortegeBlock();
            return sqlBlock;
        }
        if (node instanceof SqlUnaryExpression) {
            sqlBlock = SqlFormattingModelFun.createUnaryExpressionBlock((SqlUnaryExpression)node);
            return sqlBlock;
        }
        if (node instanceof SqlFunctionCallExpression) {
            sqlBlock = SqlFormattingModelFun.createFunctionCallOrSubqueryClause((SqlFunctionCallExpression)node);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.BIGQUERY)) {
            char[] cArray = new char[]{'`'};
            if (SqlUtilFun.isSymbol(node.getFirstChildNode(), cArray)) {
                cArray = new char[]{'`'};
                if (SqlUtilFun.isSymbol(node.getLastChildNode(), cArray)) {
                    sqlBlock = new SqlMonolithBlock();
                    return sqlBlock;
                }
            }
        }
        if (type instanceof IsExternal) {
            sqlBlock = new SqlLeafBlock();
            return sqlBlock;
        }
        if (type instanceof SqlReferenceElementType) {
            sqlBlock = (SqlBlock)(type == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE ? (Block)new SqlExternalParameterBlock() : (Block)new SqlReferenceBlock());
            return sqlBlock;
        }
        if (SqlFormattingFunKt.getLITERAL_TYPES().contains(type)) {
            sqlBlock = new SqlLiteralBlock();
            return sqlBlock;
        }
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLINE_COMMENT_TYPES(), (Object)type)) {
            sqlBlock = new SqlLineCommentBlock();
            return sqlBlock;
        }
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getBLOCK_COMMENT_TYPES(), (Object)type)) {
            sqlBlock = new SqlBlockCommentBlock();
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) {
            sqlBlock = SqlFormattingModelFun.handleStringLiteral(node, context);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
            sqlBlock = SqlFormattingModelFun.createBlockForIdentifier(node);
            return sqlBlock;
        }
        if (SqlCompositeElementTypes.SQL_BINARY_EXPRESSION.contains(type)) {
            sqlBlock = SqlFormattingModelFun.createBlockForBinaryExpression(node);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_PARENTHESIZED_EXPRESSION)) {
            sqlBlock = SqlFormattingModelFun.createBlockForParenthesizedExpression(node);
            return sqlBlock;
        }
        if (SqlFormattingModelFun.isRoutine(type)) {
            sqlBlock = SqlRoutineBlockKt.createRoutineBlock(dbms);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_PROCEDURE_DEFINITION)) || Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_FUNCTION_DEFINITION))) {
            sqlBlock = SqlRoutineBlockKt.createRoutineBlock(dbms);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_LOOP_STATEMENT)) {
            sqlBlock = SqlFormattingModelFun.createBlockForUnspecifiedLoop(node);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_STATEMENT) || Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_CALL_STATEMENT))) {
            sqlBlock = SqlFormattingModelFun.createBlockForStatement(node, dbms);
            return sqlBlock;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_GENERIC_DROP_STATEMENT)) {
            sqlBlock = SqlFormattingModelFun.createDropBlock(node);
            return sqlBlock;
        }
        if (SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(type)) {
            sqlBlock = new SqlSimpleTypeBlock();
            return sqlBlock;
        }
        if (SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT.contains(type)) {
            sqlBlock = new SqlTableTypeBlock();
            return sqlBlock;
        }
        if (CollectionsKt.contains((Iterable)CONSTRAINT_TYPES, (Object)type)) {
            sqlBlock = SqlFormattingModelFun.createBlockForConstraint(node);
            return sqlBlock;
        }
        if (type instanceof SqlFileElementType || type instanceof TemplateDataElementType) {
            sqlBlock = new SqlFileBlock();
            return sqlBlock;
        }
        if (node instanceof SqlBlockStatementImpl) {
            sqlBlock = new SqlBlockStatementBlock();
            return sqlBlock;
        }
        if (node instanceof SqlDdlStatement) {
            sqlBlock = new SqlDdlStatementBlock();
            return sqlBlock;
        }
        if (SqlUtilFun.isKeyWord(node)) {
            sqlBlock = new SqlKeyword();
            return sqlBlock;
        }
        if (SqlUtilFun.isComplex(node)) {
            sqlBlock = new SqlUnsortedBlock();
            return sqlBlock;
        }
        sqlBlock = new SqlLeafBlock();
        return sqlBlock;
    }

    private static final SqlLoopBlock createBlockForUnspecifiedLoop(ASTNode node) {
        ASTNode c;
        for (c = node.getFirstChildNode(); c != null && !CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLOOP_PRIMARY_WORD_TYPES(), (Object)c.getElementType()); c = c.getTreeNext()) {
        }
        ASTNode aSTNode = c;
        return (aSTNode != null ? aSTNode.getElementType() : null) == SqlCommonKeywords.SQL_LOOP ? (SqlLoopBlock)new SqlSimpleLoopBlock() : (SqlLoopBlock)new SqlHeadLoopBlock();
    }

    private static final SqlRangeBlock createBlockForParenthesizedExpression(ASTNode node) {
        return SqlUtilFun.getMeaningfulChildType(node, 2) == SqlCommonTokens.SQL_COMMA ? (SqlRangeBlock)new SqlCortegeBlock() : (SqlRangeBlock)new SqlParenthesizedExpressionBlock();
    }

    private static final SqlNodeBlock createBlockForBinaryExpression(ASTNode node) {
        IElementType t3;
        IElementType t2;
        ASTNode n2;
        ASTNode aSTNode = n2 = SqlUtilFun.getMeaningfulChild(node, 1);
        Object object = t2 = aSTNode != null ? aSTNode.getElementType() : null;
        if (t2 == SqlCommonTokens.SQL_OP_ASSIGN) {
            return new SqlAssignmentBlock();
        }
        if (t2 == SqlCommonTokens.SQL_LEFT_BRACKET) {
            return new SqlArrayAccessBlock();
        }
        if (t2 == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT) {
            IElementType t21;
            ASTNode aSTNode2 = n2;
            Object object2 = t21 = aSTNode2 != null ? SqlUtilFun.getMeaningfulChildType(aSTNode2, 0) : null;
            if (t21 == SqlCommonKeywords.SQL_IS) {
                return new SqlNullabilityCheckBlock();
            }
        }
        if (!((t3 = SqlUtilFun.getMeaningfulChildType(node, 2)) != SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && t3 != SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL || t2 != SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && t2 != SqlCommonKeywords.SQL_IS)) {
            return new SqlNullabilityCheckBlock();
        }
        return new SqlBinaryExpressionBlock();
    }

    private static final SqlBlock createBlockForStatement(ASTNode node, Dbms dbms) {
        ASTNode aSTNode = node.getFirstChildNode();
        if (aSTNode == null || (aSTNode = aSTNode.getElementType()) == null) {
            return new SqlStatementBlock();
        }
        ASTNode firstChildType = aSTNode;
        return Intrinsics.areEqual((Object)firstChildType, (Object)SqlCompositeElementTypes.SQL_WITH_CLAUSE) ? (SqlBlock)new SqlQueryBlock() : (Intrinsics.areEqual((Object)firstChildType, (Object)SqlCommonKeywords.SQL_DO) && dbms.isPostgres() ? (SqlBlock)new SqlPgDoStatementBlock() : (SqlBlock)new SqlStatementBlock());
    }

    private static final SqlLeafBlock createBlockForIdentifier(ASTNode node) {
        return node.getTreeParent().getElementType() == SqlCompositeElementTypes.SQL_AS_EXPRESSION ? (SqlLeafBlock)new SqlAliasBlock() : (SqlLeafBlock)new SqlIdentifierBlock();
    }

    private static final SqlBlock createBlockForConstraint(ASTNode node) {
        IElementType iElementType = SqlUtilFun.firstLeaf(node).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType firstLeafElementType = iElementType;
        IElementType iElementType2 = SqlUtilFun.lastLeaf(node).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
        IElementType lastLeafElementType = iElementType2;
        return firstLeafElementType == SqlCommonKeywords.SQL_CONSTRAINT ? (SqlBlock)new SqlNamedConstraintDefinitionBlock() : (firstLeafElementType == SqlCommonKeywords.SQL_DEFAULT ? (SqlBlock)new SqlColumnDefaultBlock() : (lastLeafElementType == SqlCommonKeywords.SQL_NULL ? (SqlBlock)new SqlColumnNullabilityBlock() : (SqlBlock)new SqlConstraintDefinitionBlock()));
    }

    private static final SqlBlock createDropBlock(ASTNode node) {
        SqlDropStatementImpl sqlDropStatementImpl = node instanceof SqlDropStatementImpl ? (SqlDropStatementImpl)node : null;
        if (sqlDropStatementImpl == null || (sqlDropStatementImpl = sqlDropStatementImpl.getTargetType()) == null) {
            sqlDropStatementImpl = ObjectKind.UNKNOWN_OBJECT;
        }
        return Intrinsics.areEqual((Object)((Object)sqlDropStatementImpl), (Object)ObjectKind.ROUTINE) ? (SqlBlock)new SqlDropRoutineBlock() : (SqlBlock)new SqlStatementBlock();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final SqlBlock createUnaryExpressionBlock(SqlUnaryExpression node) {
        SqlBlock sqlBlock;
        IElementType iElementType = node.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOpSign(...)");
        IElementType operation = iElementType;
        SqlExpression operand = node.getOperand();
        if (Intrinsics.areEqual((Object)operation, (Object)SqlCommonKeywords.SQL_NOT) && operand instanceof SqlFunctionCallExpression) {
            BuiltinFunction builtinFunction = ((SqlFunctionCallExpression)operand).getFunctionDefinition();
            if (Intrinsics.areEqual((Object)(builtinFunction != null ? SqlFormattingModelFun.getLowerName((DasNamed)builtinFunction) : null), (Object)"exists")) {
                sqlBlock = new SqlExistsClauseBlock();
                return sqlBlock;
            }
        }
        sqlBlock = new SqlUnsortedBlock();
        return sqlBlock;
    }

    private static final SqlFlowBlock createFunctionCallOrSubqueryClause(SqlFunctionCallExpression node) {
        BuiltinFunction builtinFunction = node.getFunctionDefinition();
        return Intrinsics.areEqual((Object)(builtinFunction != null ? SqlFormattingModelFun.getLowerName((DasNamed)builtinFunction) : null), (Object)"exists") ? (SqlFlowBlock)new SqlExistsClauseBlock() : (SqlFlowBlock)new SqlFunctionCallBlock();
    }

    private static final String getLowerName(DasNamed $this$lowerName) {
        String string;
        Object object = $this$lowerName;
        if (object != null && (object = object.getName()) != null && (object = StringKt.nullize$default((String)object, (boolean)false, (int)1, null)) != null) {
            Object object2 = object;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = ((String)object2).toLowerCase(locale);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final <B extends SqlBlock> B init(@NotNull B $this$init, @NotNull Function2<? super B, ? super B, Unit> initializer) {
        Intrinsics.checkNotNullParameter($this$init, (String)"<this>");
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        initializer.invoke($this$init, $this$init);
        return $this$init;
    }

    private static final boolean isRoutine(IElementType $this$isRoutine) {
        String string = $this$isRoutine.getDebugName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
        String name = string;
        return StringsKt.endsWith$default((String)name, (String)"_CREATE_FUNCTION_STATEMENT", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_CREATE_PROCEDURE_STATEMENT", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_CREATE_METHOD_STATEMENT", (boolean)false, (int)2, null);
    }

    private static final IElementType adjust(IElementType $this$adjust) {
        IElementType iElementType;
        String string = $this$adjust.getDebugName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
        String name = string;
        if (StringsKt.endsWith$default((String)name, (String)"_CREATE_TABLE_STATEMENT", (boolean)false, (int)2, null)) {
            SqlTableElementType sqlTableElementType = SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTableElementType), (String)"SQL_CREATE_TABLE_STATEMENT");
            iElementType = (IElementType)sqlTableElementType;
        } else if (StringsKt.endsWith$default((String)name, (String)"_CREATE_VIEW_STATEMENT", (boolean)false, (int)2, null)) {
            SqlTableElementType sqlTableElementType = SqlCompositeElementTypes.SQL_CREATE_VIEW_STATEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTableElementType), (String)"SQL_CREATE_VIEW_STATEMENT");
            iElementType = (IElementType)sqlTableElementType;
        } else if (StringsKt.endsWith$default((String)name, (String)"_CREATE_MATERIALIZED_VIEW_STATEMENT", (boolean)false, (int)2, null)) {
            SqlTableElementType sqlTableElementType = SqlCompositeElementTypes.SQL_CREATE_MATERIALIZED_VIEW_STATEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTableElementType), (String)"SQL_CREATE_MATERIALIZED_VIEW_STATEMENT");
            iElementType = (IElementType)sqlTableElementType;
        } else {
            iElementType = $this$adjust;
        }
        return iElementType;
    }

    public static final /* synthetic */ <B extends SqlBlock> B findParent(SqlBlock $this$findParent) {
        Intrinsics.checkNotNullParameter((Object)$this$findParent, (String)"<this>");
        boolean $i$f$findParent = false;
        for (SqlBlock p2 = $this$findParent.getParent(); p2 != null; p2 = p2.getParent()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"B");
            if (!(p2 instanceof SqlBlock)) continue;
            return (B)p2;
        }
        return null;
    }

    @Nullable
    public static final ASTNode primaryNode(@NotNull SqlBlock $this$primaryNode) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$primaryNode, (String)"<this>");
        SqlBlock sqlBlock = $this$primaryNode;
        if (sqlBlock instanceof SqlLeafBlock) {
            object = ((SqlLeafBlock)$this$primaryNode).getNode();
        } else if (sqlBlock instanceof SqlNodeBlock) {
            object = ((SqlNodeBlock)$this$primaryNode).getBlockNode();
        } else if (sqlBlock instanceof SqlRangeBlock) {
            object = ((SqlRangeBlock)$this$primaryNode).getNestedBlocks().size() == 1 ? SqlFormattingModelFun.primaryNode(((SqlRangeBlock)$this$primaryNode).getNestedBlocks().get(0)) : null;
        } else if (sqlBlock instanceof SqlInjectionHostBlock) {
            object = ((SqlInjectionHostBlock)$this$primaryNode).getBlockNode();
        } else if (sqlBlock instanceof SqlRootBlock) {
            object = ((SqlRootBlock)$this$primaryNode).getBlockNode();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final IElementType primaryElementType(@NotNull SqlBlock $this$primaryElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$primaryElementType, (String)"<this>");
        ASTNode aSTNode = SqlFormattingModelFun.primaryNode($this$primaryElementType);
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $this$listChildren) {
        Intrinsics.checkNotNullParameter((Object)$this$listChildren, (String)"<this>");
        return SqlFormattingModelFun.listChildren($this$listChildren, (Function1<? super ASTNode, Boolean>)((Function1)SqlFormattingModelFun::listChildren$lambda$0));
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $this$listChildren, @NotNull Function1<? super ASTNode, Boolean> flatten) {
        Intrinsics.checkNotNullParameter((Object)$this$listChildren, (String)"<this>");
        Intrinsics.checkNotNullParameter(flatten, (String)"flatten");
        List list = new ArrayList();
        SqlFormattingModelFun.listChildren$listChildrenRecursively(flatten, list, $this$listChildren);
        return list;
    }

    private static final SqlBlock handleStringLiteral(ASTNode node, SqlFormattingContext context) {
        return SqlUtilFun.doesntIntersect(node, context.getInterestingRange()) ? (SqlBlock)new SqlLiteralBlock() : (SqlFormattingModelFun.hasInjection(node) ? (SqlBlock)new SqlLiteralInjectionHostBlock() : (SqlUtilFun.isLeaf(node) || SqlFormattingModelFun.hasOnlyOneChild(node, (Function1<? super IElementType, Boolean>)((Function1)SqlFormattingModelFun::handleStringLiteral$lambda$0)) ? (SqlBlock)new SqlLiteralBlock() : (SqlBlock)new SqlComplexTextBlock()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasOnlyOneChild(ASTNode $this$hasOnlyOneChild, Function1<? super IElementType, Boolean> predicate) {
        ASTNode aSTNode = $this$hasOnlyOneChild.getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode child1 = aSTNode;
        if (child1.getTreeNext() != null) return false;
        IElementType iElementType = child1.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        if ((Boolean)predicate.invoke((Object)iElementType) == false) return false;
        return true;
    }

    public static final boolean hasInjection(@NotNull ASTNode $this$hasInjection) {
        Intrinsics.checkNotNullParameter((Object)$this$hasInjection, (String)"<this>");
        if (!Registry.Companion.is("sql.formatter.consider.language.injection")) {
            return false;
        }
        Ref.BooleanRef result = new Ref.BooleanRef();
        PsiElement element = $this$hasInjection.getPsi();
        InjectedLanguageManager.getInstance((Project)element.getContainingFile().getProject()).enumerate(element, (arg_0, arg_1) -> SqlFormattingModelFun.hasInjection$lambda$0(result, arg_0, arg_1));
        return result.element;
    }

    public static final int indexOf(@NotNull List<? extends ASTNode> $this$indexOf, @NotNull IElementType type, int since, int till, int notFound) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int n = $this$indexOf.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw new IllegalArgumentException("Negative since = " + since);
        }
        int n2 = Math.min(till, n);
        for (int i = since; i < n2; ++i) {
            if ($this$indexOf.get(i).getElementType() != type) continue;
            return i;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, IElementType iElementType, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = list.size();
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return SqlFormattingModelFun.indexOf((List<? extends ASTNode>)list, iElementType, n, n2, n3);
    }

    public static final int indexOf(@NotNull List<? extends ASTNode> $this$indexOf, @NotNull Set<? extends IElementType> types, int since, int till, int notFound) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        int n = $this$indexOf.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw new IllegalArgumentException("Negative since = " + since);
        }
        int n2 = Math.min(till, n);
        for (int i = since; i < n2; ++i) {
            if (!types.contains($this$indexOf.get(i).getElementType())) continue;
            return i;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, Set set, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = list.size();
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return SqlFormattingModelFun.indexOf((List<? extends ASTNode>)list, set, n, n2, n3);
    }

    @Nullable
    public static final IntRange findConsequence(@NotNull List<? extends ASTNode> $this$findConsequence, int since, @NotNull Function1<? super ASTNode, Boolean> predicate) {
        int f;
        int s;
        Intrinsics.checkNotNullParameter($this$findConsequence, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int n = $this$findConsequence.size();
        for (s = since; s < n && !((Boolean)predicate.invoke((Object)$this$findConsequence.get(s))).booleanValue(); ++s) {
        }
        if (s == n) {
            return null;
        }
        for (f = s + 1; f < n && ((Boolean)predicate.invoke((Object)$this$findConsequence.get(f))).booleanValue(); ++f) {
        }
        return RangesKt.until((int)s, (int)f);
    }

    public static /* synthetic */ IntRange findConsequence$default(List list, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return SqlFormattingModelFun.findConsequence(list, n, (Function1<? super ASTNode, Boolean>)function1);
    }

    @Nullable
    public static final FindPhraseResult findPhrase(@NotNull List<? extends ASTNode> $this$findPhrase, int offset, @NotNull IElementType[][] patterns2) {
        Intrinsics.checkNotNullParameter($this$findPhrase, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)patterns2, (String)"patterns");
        int n = $this$findPhrase.size();
        int k = offset;
        while (k < n) {
            int begin;
            ASTNode node;
            if (SqlUtilFun.isWhitespaceOrComment(node = $this$findPhrase.get(begin = k++))) continue;
            int n2 = ((Object[])patterns2).length;
            for (int i = 0; i < n2; ++i) {
                IElementType[] iElementTypeArray = patterns2[i];
                int m = SqlUtilFun.matchPhrase($this$findPhrase, begin, Arrays.copyOf(iElementTypeArray, iElementTypeArray.length));
                if (m <= 0) continue;
                return new FindPhraseResult(i, begin, begin + m);
            }
        }
        return null;
    }

    public static final int getFinish(@NotNull IntRange $this$finish) {
        Intrinsics.checkNotNullParameter((Object)$this$finish, (String)"<this>");
        boolean $i$f$getFinish = false;
        return $this$finish.getEndInclusive();
    }

    @NotNull
    public static final Alignment makeLeftAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeLeftAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeRightAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeRightAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"createAlignment(...)");
        return alignment;
    }

    @Nullable
    public static final WrapImpl.Type getType(@Nullable Wrap $this$getType) {
        WrapImpl wrapImpl = $this$getType instanceof WrapImpl ? (WrapImpl)$this$getType : null;
        return wrapImpl != null ? wrapImpl.getType() : null;
    }

    public static final boolean isAlways(@Nullable Wrap $this$isAlways) {
        return SqlFormattingModelFun.getType($this$isAlways) == WrapImpl.Type.WRAP_ALWAYS;
    }

    @NotNull
    public static final JBIterable<SqlBlock> skip(@NotNull Iterable<? extends SqlBlock> $this$skip, int count) {
        Intrinsics.checkNotNullParameter($this$skip, (String)"<this>");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$skip;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.skip(count);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"skip(...)");
        return jBIterable2;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $this$find, @NotNull BlockRole role) {
        SqlBlock sqlBlock;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            Iterable<? extends SqlBlock> iterable = $this$find;
            Iterator<? extends SqlBlock> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                SqlBlock sqlBlock2;
                SqlBlock it = sqlBlock2 = iterator.next();
                boolean bl = false;
                if (!(it.getRole() == role)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $this$find, @NotNull IElementType type) {
        SqlBlock sqlBlock;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Iterable<? extends SqlBlock> iterable = $this$find;
            Iterator<? extends SqlBlock> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                SqlBlock sqlBlock2;
                SqlBlock it = sqlBlock2 = iterator.next();
                boolean bl = false;
                if (!(SqlFormattingModelFun.primaryElementType(it) == type)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    public static final /* synthetic */ <B extends Block> B find(Iterable<? extends Block> $this$find) {
        Block block;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"<this>");
            boolean $i$f$find = false;
            Iterable<? extends Block> iterable = $this$find;
            Iterator<? extends Block> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Block block2;
                Block it = block2 = iterator.next();
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"B");
                if (!(it instanceof Block)) continue;
                block = block2;
                break block1;
            }
            block = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"B");
        return (B)block;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$1(arg_0 -> SqlFormattingModelFun.filter$lambda$0(role, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role1, @NotNull BlockRole role2) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)role1), (String)"role1");
        Intrinsics.checkNotNullParameter((Object)((Object)role2), (String)"role2");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$3(arg_0 -> SqlFormattingModelFun.filter$lambda$2(role1, role2, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role1, @NotNull BlockRole role2, @NotNull BlockRole role3) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)role1), (String)"role1");
        Intrinsics.checkNotNullParameter((Object)((Object)role2), (String)"role2");
        Intrinsics.checkNotNullParameter((Object)((Object)role3), (String)"role3");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$5(arg_0 -> SqlFormattingModelFun.filter$lambda$4(role1, role2, role3, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$7(arg_0 -> SqlFormattingModelFun.filter$lambda$6(type, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, IElementType ... types) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> SqlFormattingModelFun.filter$lambda$9(arg_0 -> SqlFormattingModelFun.filter$lambda$8(types, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    public static final /* synthetic */ <B extends Block> JBIterable<B> filter(Iterable<? extends Block> $this$filter) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        boolean $i$f$filter = false;
        Iterable<? extends Block> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        Intrinsics.reifiedOperationMarker((int)4, (String)"B");
        JBIterable jBIterable2 = jBIterable.filter(Block.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return jBIterable2;
    }

    @NotNull
    public static final <B extends Block> JBIterable<B> getJbi(@NotNull Iterable<? extends B> $this$jbi) {
        Intrinsics.checkNotNullParameter($this$jbi, (String)"<this>");
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return jBIterable;
    }

    @NotNull
    public static final BlockRole getRole(@Nullable SqlBlock $this$role) {
        boolean $i$f$getRole = false;
        Object object = $this$role;
        if (object == null || (object = object.getRole()) == null) {
            object = BlockRole.NOTHING;
        }
        return object;
    }

    @Nullable
    public static final SqlBlock findFirstInnerBlockOnTheSameLine(@NotNull SqlBlock $this$findFirstInnerBlockOnTheSameLine, int offset, @NotNull Function1<? super SqlBlock, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$findFirstInnerBlockOnTheSameLine, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        SqlBlock candidate = null;
        int n = $this$findFirstInnerBlockOnTheSameLine.getNestedBlocks().size();
        for (int i = n - 1; -1 < i; --i) {
            SqlBlock b = $this$findFirstInnerBlockOnTheSameLine.getNestedBlocks().get(i);
            int x = b.getRange().getStartOffset();
            if (x >= offset) continue;
            if ($this$findFirstInnerBlockOnTheSameLine.getContext().textContains(x, offset, '\n')) break;
            if (!((Boolean)predicate.invoke((Object)b)).booleanValue()) continue;
            candidate = b;
        }
        return candidate;
    }

    private static final boolean listChildren$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final void listChildren$listChildrenRecursively(Function1<? super ASTNode, Boolean> $flatten, List<ASTNode> list, ASTNode parentNode) {
        for (ASTNode node = parentNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType type;
            Intrinsics.checkNotNullExpressionValue((Object)node.getElementType(), (String)"getElementType(...)");
            if (type == SqlElementTypes.SQL_DUMMY_BLOCK || ((Boolean)$flatten.invoke((Object)node)).booleanValue()) {
                SqlFormattingModelFun.listChildren$listChildrenRecursively($flatten, list, node);
                continue;
            }
            if (SqlUtilFun.isWhitespace(node)) continue;
            ((Collection)list).add(node);
        }
    }

    private static final boolean handleStringLiteral$lambda$0(IElementType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SqlFormattingFunKt.getLITERAL_TYPES().contains(it);
    }

    private static final void hasInjection$lambda$0(Ref.BooleanRef $result, PsiFile psiFile, List list) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        $result.element = true;
    }

    private static final boolean filter$lambda$0(BlockRole $role, SqlBlock it) {
        return it.getRole() == $role;
    }

    private static final boolean filter$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$2(BlockRole $role1, BlockRole $role2, SqlBlock it) {
        return it.getRole() == $role1 || it.getRole() == $role2;
    }

    private static final boolean filter$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$4(BlockRole $role1, BlockRole $role2, BlockRole $role3, SqlBlock it) {
        return it.getRole() == $role1 || it.getRole() == $role2 || it.getRole() == $role3;
    }

    private static final boolean filter$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$6(IElementType $type, SqlBlock it) {
        return it instanceof SqlSingleNodeBlock && ((SqlSingleNodeBlock)((Object)it)).getBlockElementTypes() == $type;
    }

    private static final boolean filter$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filter$lambda$8(IElementType[] $types, SqlBlock it) {
        return it instanceof SqlSingleNodeBlock && ArraysKt.contains((Object[])$types, (Object)((SqlSingleNodeBlock)((Object)it)).getBlockElementTypes());
    }

    private static final boolean filter$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)SqlCommonKeywords.SQL_AS, (Object)Reflection.getOrCreateKotlinClass(SqlAS.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SPECIAL_LITERAL, (Object)Reflection.getOrCreateKotlinClass(SqlLeafBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlBlockStatementBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SELECT_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_UNION_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_INSERT_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_UPDATE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_DELETE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlQueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_MERGE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlMergeBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_EXPLAIN_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlExplainPlanBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlParenthesizedSubqueryBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CASE_EXPRESSION, (Object)Reflection.getOrCreateKotlinClass(SqlCaseExpressionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CASE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlCaseStatementBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_REFERENCE_LIST, (Object)Reflection.getOrCreateKotlinClass(SqlCortegeBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlCreateTableBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_SCHEMA_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlCreateSchemaBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_COLUMN_DEFINITION), (Object)Reflection.getOrCreateKotlinClass(SqlColumnBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_REFERENCES_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlForeignKeyReferencesBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_CASCADE_OPTION, (Object)Reflection.getOrCreateKotlinClass(SqlConstraintDetailBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CONSTRAINT_CHARACTERISTIC_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlConstraintDetailBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_ALTER_TABLE_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlAlterTableBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION), (Object)Reflection.getOrCreateKotlinClass(SqlAlterInstructionBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_VIEW_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlViewBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_MATERIALIZED_VIEW_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlViewBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_IF_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlForkBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_THEN_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlForkSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_ELSE_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlForkSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_ELSEIF_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlElsifSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlHeadLoopBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlHeadLoopBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlRepeatLoopBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT, (Object)Reflection.getOrCreateKotlinClass(SqlAssignmentBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK, (Object)Reflection.getOrCreateKotlinClass(SqlBatchBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlTriggerBlock.class)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT), (Object)Reflection.getOrCreateKotlinClass(SqlCreateExoticObjectBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlSimpleSettingAssignmentBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_TYPE_PARAMETER_LIST, (Object)Reflection.getOrCreateKotlinClass(SqlTypeParameterListBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_DECLARE_STATEMENT, (Object)Reflection.getOrCreateKotlinClass(SqlDeclareSectionBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SIZE_WITH_MEASURE, (Object)Reflection.getOrCreateKotlinClass(SqlSizeBlock.class)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_IF_EXISTS_CLAUSE, (Object)Reflection.getOrCreateKotlinClass(SqlShortPhraseBlock.class))};
        COMMON_SIMPLE_ELEMENT_BLOCKS = MapsKt.mapOf((Pair[])objectArray);
        DIALECT_SPECIFIC_BLOCKS = MapsKt.mapOf((Pair)TuplesKt.to((Object)Dbms.CLICKHOUSE, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (Object)Reflection.getOrCreateKotlinClass(SqlIdentifierBlock.class)))));
        objectArray = new SqlDefinitionStubElementType[]{SqlCompositeElementTypes.SQL_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_CHECK_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION, SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION, SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION};
        CONSTRAINT_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

