/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.Case;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.symbols.DasSymbolUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlPsiMiscUtil {
    @NotNull
    public static DdlBuilder addReturnTypeText(@NotNull DdlBuilder builder, @Nullable DasArgument returnArgument) {
        if (builder == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(0);
        }
        DdlBuilder ddlBuilder = returnArgument == null ? builder : builder.type((DasTypedObject)returnArgument);
        if (ddlBuilder == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(1);
        }
        return ddlBuilder;
    }

    public static boolean isDropTarget(@Nullable PsiElement element) {
        SqlDropStatement drop = (SqlDropStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlDropStatement.class);
        return drop != null && PsiTreeUtil.isContextAncestor((PsiElement)drop.getTargetExpression(), (PsiElement)element, (boolean)false);
    }

    @NotNull
    public static Case getAliasCase(@Nullable PsiFile file) {
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(file);
        Case case_ = settings != null ? settings.getAliasCase() : Case.MIXED;
        if (case_ == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(2);
        }
        return case_;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static SqlCodeStyleSettings settings(@Nullable PsiFile file) {
        return file == null ? null : SqlCodeStyles.getSqlSettings((PsiFile)file);
    }

    @NotNull
    public static SqlCodeStyleSettings settings(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(3);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (file = element.getContainingFile()) == null ? SqlCodeStyles.getSqlSettings((Project)element.getProject(), (Language)SqlImplUtil.getSqlDialectSafe(element)) : SqlCodeStyles.getSqlSettings((PsiFile)file);
        if (sqlCodeStyleSettings == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(4);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings settings(@NotNull DasSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(6);
        }
        if (symbol instanceof PsiElement) {
            return SqlPsiMiscUtil.settings((PsiElement)symbol);
        }
        PsiElement source = DasSymbolUtil.getSinglePsiSource(symbol);
        if (source != null) {
            return SqlPsiMiscUtil.settings(source);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)DasSymbolUtil.getSqlDialect(symbol));
        if (sqlCodeStyleSettings == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(7);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static Case getIdentifierCase(@Nullable PsiFile file) {
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(file);
        Case case_ = settings != null ? settings.getIdentifierCase() : Case.MIXED;
        if (case_ == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(8);
        }
        return case_;
    }

    @NotNull
    public static Case getQuotedIdentifierCase(@Nullable PsiFile file) {
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(file);
        Case case_ = settings != null ? settings.getQuotedIdentifierCase() : Case.MIXED;
        if (case_ == null) {
            SqlPsiMiscUtil.$$$reportNull$$$0(9);
        }
        return case_;
    }

    public static boolean isJoinUsingColumn(@Nullable PsiElement element) {
        SqlReferenceList usingList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceList.class);
        return usingList != null && usingList.getParent() instanceof SqlUsingClause && usingList.getParent().getParent() instanceof SqlJoinExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlPsiMiscUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlPsiMiscUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addReturnTypeText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasCase";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "settings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierCase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedIdentifierCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addReturnTypeText";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "settings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

