/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a0\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u001a$\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"createDeclareVariableStatement", "Lcom/intellij/sql/psi/SqlDeclareStatement;", "Lcom/intellij/sql/refactoring/SqlExtractVariableHelper;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "type", "Lcom/intellij/database/model/DataType;", "initializer", "createSetStatement", "Lcom/intellij/sql/psi/SqlStatement;", "text", "addStatementBefore", "Lcom/intellij/psi/PsiElement;", "statement", "anchor", "intellij.database.sql.core.impl"})
public final class SqlIntroduceVariableUtilsKt {
    @Nullable
    public static final SqlDeclareStatement createDeclareVariableStatement(@NotNull SqlExtractVariableHelper $this$createDeclareVariableStatement, @NotNull Project project, @NotNull String name, @NotNull DataType type, @Nullable String initializer) {
        Intrinsics.checkNotNullParameter((Object)$this$createDeclareVariableStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        DdlBuilder ddlBuilder = $this$createDeclareVariableStatement.createBuilder(project);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"createBuilder(...)");
        DdlBuilder builder = ddlBuilder;
        builder.keyword("declare").space().identifier(name, ObjectKind.VARIABLE).space().type(type);
        if (initializer != null) {
            builder.space().symbol("=").space().plain(initializer);
        }
        String string = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String varText = string;
        String statementText = "begin " + varText + "; end";
        SqlCodeFragment sqlCodeFragment = SqlPsiElementFactory.createFragmentFromText(statementText, $this$createDeclareVariableStatement.getDialect(), (IElementType)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT, project, null);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createFragmentFromText(...)");
        SqlCodeFragment block = sqlCodeFragment;
        return (SqlDeclareStatement)PsiTreeUtil.getChildOfType((PsiElement)block.getFirstChild(), SqlDeclareStatement.class);
    }

    public static /* synthetic */ SqlDeclareStatement createDeclareVariableStatement$default(SqlExtractVariableHelper sqlExtractVariableHelper, Project project, String string, DataType dataType, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return SqlIntroduceVariableUtilsKt.createDeclareVariableStatement(sqlExtractVariableHelper, project, string, dataType, string2);
    }

    @Nullable
    public static final SqlStatement createSetStatement(@NotNull SqlExtractVariableHelper $this$createSetStatement, @NotNull Project project, @NotNull String name, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$createSetStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = $this$createSetStatement.createBuilder(project).keyword("set").space().identifier(name, ObjectKind.VARIABLE).space().symbol("=").space().plain(text).getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String statementText = string;
        return SqlPsiElementFactory.createStatementFromText(statementText, $this$createSetStatement.getDialect(), project, null);
    }

    @Nullable
    public static final PsiElement addStatementBefore(@Nullable PsiElement statement, @NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PsiElement psiElement = anchor.getParent();
        PsiElement psiElement2 = statement;
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement createdStatement = psiElement.addBefore(psiElement2, anchor);
        if (createdStatement != null) {
            Project project = anchor.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect(anchor);
            PsiElement psiElement3 = SqlPsiElementFactory.createLeafFromText(project2, dialect, ";");
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"createLeafFromText(...)");
            PsiElement semi = psiElement3;
            PsiElement psiElement4 = SqlPsiElementFactory.newLine(project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"newLine(...)");
            PsiElement newLineNode = psiElement4;
            PsiElement parent = createdStatement.getParent();
            PsiElement psiElement5 = parent.addAfter(semi, createdStatement);
            parent.addAfter(newLineNode, psiElement5);
        }
        return createdStatement;
    }
}

