/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend.hyperlinks;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.backend.hyperlinks.BackendTerminalHyperlinkHighlighterKt;
import com.intellij.terminal.backend.hyperlinks.HighlightTask;
import com.intellij.terminal.backend.hyperlinks.HighlightTaskRunner;
import com.intellij.terminal.backend.hyperlinks.HyperlinkProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLine;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelSnapshot;
import org.jetbrains.plugins.terminal.session.TerminalHyperlinksChangedEvent;
import org.jetbrains.plugins.terminal.session.dto.TerminalFilterResultInfoDto;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020\"H\u0002J\b\u0010/\u001a\u00020\"H\u0002J\u0015\u00100\u001a\u00020\"*\u00020\"2\u0006\u00101\u001a\u00020-H\u0082\u0002J\u0015\u00102\u001a\u00020\"*\u00020\"2\u0006\u00101\u001a\u00020-H\u0082\u0002J\u000e\u00103\u001a\u000204H\u0086@\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u000204H\u0082@\u00a2\u0006\u0002\u00105J\u000e\u00107\u001a\u000204H\u0082@\u00a2\u0006\u0002\u00105J \u00108\u001a\u0004\u0018\u0001092\u0016\u0010:\u001a\u0012\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u00050\rJ*\u0010;\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0<2\u0016\u0010:\u001a\u0012\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u00050\rH\u0002JD\u0010=\u001a\u0002042\u0010\u0010>\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0?2\u0010\u0010@\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0A2\u0016\u0010:\u001a\u0012\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u00050\rH\u0002J\u001c\u0010B\u001a\u0004\u0018\u0001092\u0010\u0010C\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0<H\u0002J\u001a\u0010D\u001a\u00020E2\u0010\u0010F\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0<H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006G"}, d2={"Lcom/intellij/terminal/backend/hyperlinks/HighlightTaskRunner;", "", "hyperlinkId", "Ljava/util/concurrent/atomic/AtomicLong;", "isInAlternateBuffer", "", "task", "Lcom/intellij/terminal/backend/hyperlinks/HighlightTask;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelSnapshot;", "filter", "Lcom/intellij/execution/filters/CompositeFilter;", "continueCondition", "Lkotlin/Function1;", "<init>", "(Ljava/util/concurrent/atomic/AtomicLong;ZLcom/intellij/terminal/backend/hyperlinks/HighlightTask;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelSnapshot;Lcom/intellij/execution/filters/CompositeFilter;Lkotlin/jvm/functions/Function1;)V", "getTask", "()Lcom/intellij/terminal/backend/hyperlinks/HighlightTask;", "getFilter", "()Lcom/intellij/execution/filters/CompositeFilter;", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isFirstEvent", "processor", "Lcom/intellij/terminal/backend/hyperlinks/HyperlinkProcessor;", "topResults", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lorg/jetbrains/plugins/terminal/session/dto/TerminalFilterResultInfoDto;", "Lcom/intellij/terminal/backend/hyperlinks/TaskResult;", "getTopResults", "()Ljava/util/concurrent/LinkedBlockingDeque;", "bottomResults", "getBottomResults", "topStartLine", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;", "bottomStartLine", "topStopLineInclusive", "bottomStopLineInclusive", "currentAbsoluteLine", "", "getCurrentAbsoluteLine", "()J", "setCurrentAbsoluteLine", "(J)V", "resultsCount", "", "firstLine", "lastLine", "plus", "count", "minus", "run", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeBottomResults", "computeTopResults", "getNextOutputEvent", "Lorg/jetbrains/plugins/terminal/session/TerminalHyperlinksChangedEvent;", "predicate", "collectResults", "", "collectValidAndRemoveInvalidResults", "from", "Ljava/util/Deque;", "to", "", "createEvent", "hyperlinks", "describe", "", "results", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nBackendTerminalHyperlinkHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHyperlinkHighlighter.kt\ncom/intellij/terminal/backend/hyperlinks/HighlightTaskRunner\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n60#2,5:522\n60#2,5:527\n60#2,5:532\n60#2,5:537\n60#2,5:542\n60#2,5:547\n60#2,5:552\n1#3:557\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHyperlinkHighlighter.kt\ncom/intellij/terminal/backend/hyperlinks/HighlightTaskRunner\n*L\n302#1:522,5\n316#1:527,5\n323#1:532,5\n333#1:537,5\n347#1:542,5\n367#1:547,5\n398#1:552,5\n*E\n"})
final class HighlightTaskRunner {
    private final boolean isInAlternateBuffer;
    @NotNull
    private final HighlightTask task;
    @NotNull
    private final TerminalOutputModelSnapshot outputModel;
    @NotNull
    private final CompositeFilter filter;
    @NotNull
    private final Function1<HighlightTaskRunner, Boolean> continueCondition;
    @NotNull
    private final AtomicBoolean isRunning;
    private boolean isFirstEvent;
    @NotNull
    private final HyperlinkProcessor processor;
    @NotNull
    private final LinkedBlockingDeque<TerminalFilterResultInfoDto> topResults;
    @NotNull
    private final LinkedBlockingDeque<TerminalFilterResultInfoDto> bottomResults;
    @NotNull
    private final TerminalLine topStartLine;
    @NotNull
    private final TerminalLine bottomStartLine;
    @NotNull
    private final TerminalLine topStopLineInclusive;
    @NotNull
    private final TerminalLine bottomStopLineInclusive;
    private long currentAbsoluteLine;

    public HighlightTaskRunner(@NotNull AtomicLong hyperlinkId, boolean isInAlternateBuffer, @NotNull HighlightTask task, @NotNull TerminalOutputModelSnapshot outputModel, @NotNull CompositeFilter filter, @NotNull Function1<? super HighlightTaskRunner, Boolean> continueCondition) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkId, (String)"hyperlinkId");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter(continueCondition, (String)"continueCondition");
        this.isInAlternateBuffer = isInAlternateBuffer;
        this.task = task;
        this.outputModel = outputModel;
        this.filter = filter;
        this.continueCondition = continueCondition;
        this.isRunning = new AtomicBoolean(true);
        this.isFirstEvent = true;
        this.processor = new HyperlinkProcessor(hyperlinkId);
        this.topResults = new LinkedBlockingDeque();
        this.bottomResults = new LinkedBlockingDeque();
        this.topStartLine = this.outputModel.absoluteLine(this.task.getStartAbsoluteLine());
        this.bottomStartLine = (TerminalLine)RangesKt.coerceAtLeast((Comparable)RangesKt.coerceAtLeast((Comparable)this.minus(this.lastLine().plus(1L), 200), (Comparable)this.firstLine()), (Comparable)this.topStartLine);
        this.topStopLineInclusive = this.minus(this.bottomStartLine, 1);
        this.bottomStopLineInclusive = this.lastLine();
        this.currentAbsoluteLine = this.topStartLine.toAbsolute();
    }

    @NotNull
    public final HighlightTask getTask() {
        return this.task;
    }

    @NotNull
    public final CompositeFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public final LinkedBlockingDeque<TerminalFilterResultInfoDto> getTopResults() {
        return this.topResults;
    }

    @NotNull
    public final LinkedBlockingDeque<TerminalFilterResultInfoDto> getBottomResults() {
        return this.bottomResults;
    }

    public final long getCurrentAbsoluteLine() {
        return this.currentAbsoluteLine;
    }

    public final void setCurrentAbsoluteLine(long l) {
        this.currentAbsoluteLine = l;
    }

    public final boolean isRunning() {
        return this.isRunning.get();
    }

    public final int resultsCount() {
        return this.topResults.size() + this.bottomResults.size();
    }

    private final TerminalLine firstLine() {
        return this.outputModel.getFirstLine();
    }

    private final TerminalLine lastLine() {
        return this.outputModel.getLastLine();
    }

    private final TerminalLine plus(TerminalLine $this$plus, int count) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        return this.outputModel.absoluteLine($this$plus.toAbsolute() + (long)count);
    }

    private final TerminalLine minus(TerminalLine $this$minus, int count) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        return this.outputModel.absoluteLine($this$minus.toAbsolute() - (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object run(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof run.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ HighlightTaskRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.run((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var7_15 = $this$debug_u24default$iv;
                    $i$a$-debug$default-HighlightTaskRunner$run$2 = false;
                    "Started the task " + BackendTerminalHyperlinkHighlighterKt.access$toString(this.task, this.outputModel) + " on the output model " + BackendTerminalHyperlinkHighlighterKt.access$describe(this.outputModel) + ", ";
                    var7_15.debug("will process lines " + this.topStartLine + "-" + this.topStopLineInclusive + " at the top and " + this.bottomStartLine + "-" + this.bottomStopLineInclusive + " at the bottom", e$iv);
                }
                $continuation.label = 1;
                v0 = this.computeBottomResults((Continuation<? super Unit>)$continuation);
                ** if (v0 != var10_4) goto lbl28
lbl27:
                // 1 sources

                return var10_4;
lbl28:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                $continuation.label = 2;
                v1 = this.computeTopResults((Continuation<? super Unit>)$continuation);
                ** if (v1 != var10_4) goto lbl38
lbl37:
                // 1 sources

                return var10_4;
lbl38:
                // 1 sources

                ** GOTO lbl44
            }
            case 2: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Exception e) {
                    if (e instanceof CancellationException) {
                        throw e;
                    }
                    BackendTerminalHyperlinkHighlighterKt.access$getLOG$p().error("Exception in the task " + this.task, (Throwable)e);
                    ** GOTO lbl73
                }
lbl44:
                // 2 sources

                $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var7_15 = $this$debug_u24default$iv;
                    $i$a$-debug$default-HighlightTaskRunner$run$3 = false;
                    var7_15.debug("Finished the task " + this.task, e$iv);
                }
                this.isRunning.set(false);
                ** GOTO lbl73
            }
            {
                finally {
                    $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
                    e$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var7_16 = $this$debug_u24default$iv;
                        $i$a$-debug$default-HighlightTaskRunner$run$3 = false;
                        var7_16.debug("Finished the task " + this.task, (Throwable)e$iv);
                    }
                    this.isRunning.set(false);
                }
            }
lbl73:
            // 2 sources

            return Unit.INSTANCE;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object computeBottomResults(Continuation<? super Unit> $completion) {
        if (!($completion instanceof computeBottomResults.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ HighlightTaskRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HighlightTaskRunner.access$computeBottomResults(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.processor.processBatch(this.outputModel, this.filter, this.bottomStartLine, this.bottomStopLineInclusive, (Continuation<? super List<? extends TerminalFilterResultInfoDto>>)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                results = (List)v0;
                $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var7_9 = $this$debug_u24default$iv;
                    $i$a$-debug$default-HighlightTaskRunner$computeBottomResults$2 = false;
                    var7_9.debug("Produced at the bottom: " + this.describe(results) + " in lines " + this.bottomStartLine + "-" + this.bottomStopLineInclusive, e$iv);
                }
                CollectionsKt.addAll((Collection)this.bottomResults, (Iterable)results);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object computeTopResults(Continuation<? super Unit> $completion) {
        if (!($completion instanceof computeTopResults.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ HighlightTaskRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HighlightTaskRunner.access$computeTopResults(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                firstBatchLine = new Ref.ObjectRef();
                firstBatchLine.element = this.topStartLine;
lbl14:
                // 2 sources

                while (((TerminalLine)firstBatchLine.element).compareTo(this.topStopLineInclusive) <= 0 && ((Boolean)this.continueCondition.invoke((Object)this)).booleanValue()) {
                    lastBatchLine = (TerminalLine)RangesKt.coerceAtMost((Comparable)this.minus(this.plus((TerminalLine)firstBatchLine.element, 200), 1), (Comparable)this.topStopLineInclusive);
                    $continuation.L$0 = firstBatchLine;
                    $continuation.L$1 = lastBatchLine;
                    $continuation.label = 1;
                    v0 = this.processor.processBatch(this.outputModel, this.filter, (TerminalLine)firstBatchLine.element, lastBatchLine, (Continuation<? super List<? extends TerminalFilterResultInfoDto>>)$continuation);
                    if (v0 == var12_4) {
                        return var12_4;
                    }
                    ** GOTO lbl29
                }
                break;
            }
            case 1: {
                lastBatchLine = (TerminalLine)$continuation.L$1;
                firstBatchLine = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                results = (List)v0;
                CollectionsKt.addAll((Collection)this.topResults, (Iterable)results);
                $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var9_12 = $this$debug_u24default$iv;
                    $i$a$-debug$default-HighlightTaskRunner$computeTopResults$2 = false;
                    var9_12.debug("Produced at the top: " + this.describe(results) + " in lines " + firstBatchLine.element + "-" + lastBatchLine, e$iv);
                }
                firstBatchLine.element = lastBatchLine.plus(1L);
                this.currentAbsoluteLine = ((TerminalLine)firstBatchLine.element).toAbsolute();
                ** GOTO lbl14
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final TerminalHyperlinksChangedEvent getNextOutputEvent(@NotNull Function1<? super TerminalFilterResultInfoDto, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this.createEvent(this.collectResults(predicate));
    }

    private final List<TerminalFilterResultInfoDto> collectResults(Function1<? super TerminalFilterResultInfoDto, Boolean> predicate) {
        ArrayList results = new ArrayList(this.topResults.size() + this.bottomResults.size());
        this.collectValidAndRemoveInvalidResults((Deque<TerminalFilterResultInfoDto>)this.topResults, results, predicate);
        this.collectValidAndRemoveInvalidResults((Deque<TerminalFilterResultInfoDto>)this.bottomResults, results, predicate);
        Logger $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Got " + this.describe(results) + " from the task " + this.task, e$iv);
        }
        return results;
    }

    private final void collectValidAndRemoveInvalidResults(Deque<TerminalFilterResultInfoDto> from, List<TerminalFilterResultInfoDto> to, Function1<? super TerminalFilterResultInfoDto, Boolean> predicate) {
        int count = 0;
        int valid = 0;
        while (from.pollFirst() != null) {
            TerminalFilterResultInfoDto nextResult;
            ++count;
            if (!((Boolean)predicate.invoke((Object)nextResult)).booleanValue()) continue;
            ((Collection)to).add(nextResult);
            ++valid;
        }
        Logger $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Processed " + count + " results, removed " + (count - valid) + " invalid ones", e$iv);
        }
    }

    private final TerminalHyperlinksChangedEvent createEvent(List<? extends TerminalFilterResultInfoDto> hyperlinks) {
        boolean send = false;
        boolean remove = false;
        boolean isRunning = this.isRunning();
        if (!((Collection)hyperlinks).isEmpty() && this.isFirstEvent) {
            remove = true;
            send = true;
        } else if (!((Collection)hyperlinks).isEmpty() && !this.isFirstEvent) {
            remove = false;
            send = true;
        } else if (this.isFirstEvent && isRunning) {
            remove = false;
            send = false;
        } else if (this.isFirstEvent && !isRunning) {
            remove = true;
            send = true;
        } else {
            remove = false;
            send = false;
        }
        Logger $this$debug_u24default$iv = BackendTerminalHyperlinkHighlighterKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("createEvent: isNotEmpty=" + !((Collection)hyperlinks).isEmpty() + ", isFirst=" + this.isFirstEvent + ", isRunning=" + isRunning + " => send=" + send + ", remove=" + remove, e$iv);
        }
        if (!send) {
            return null;
        }
        this.isFirstEvent = false;
        TerminalHyperlinksChangedEvent result2 = new TerminalHyperlinksChangedEvent(this.isInAlternateBuffer, this.outputModel.getModificationStamp(), remove ? Long.valueOf(this.task.getStartAbsoluteOffset()) : null, hyperlinks);
        return result2;
    }

    private final String describe(List<? extends TerminalFilterResultInfoDto> results) {
        StringBuilder stringBuilder;
        StringBuilder $this$describe_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (results.isEmpty()) {
            $this$describe_u24lambda_u240.append("no results");
        } else {
            $this$describe_u24lambda_u240.append(results.size()).append(" results with offsets ");
            Iterable iterable = results;
            TerminalOutputModelSnapshot terminalOutputModelSnapshot = this.outputModel;
            Object object = iterable.iterator();
            if (!object.hasNext()) {
                throw new NoSuchElementException();
            }
            Iterator<Object> it = (TerminalFilterResultInfoDto)object.next();
            boolean bl2 = false;
            it = ((TerminalFilterResultInfoDto)((Object)it)).getAbsoluteStartOffset();
            while (object.hasNext()) {
                Object it2 = (TerminalFilterResultInfoDto)object.next();
                $i$a$-minOf-HighlightTaskRunner$describe$1$minOffset$1 = false;
                if (it.compareTo(it2 = (Comparable)Long.valueOf(((TerminalFilterResultInfoDto)it2).getAbsoluteStartOffset())) <= 0) continue;
                it = it2;
            }
            TerminalOffset minOffset = terminalOutputModelSnapshot.absoluteOffset(((Number)((Object)it)).longValue());
            object = results;
            terminalOutputModelSnapshot = this.outputModel;
            it = object.iterator();
            if (!it.hasNext()) {
                throw new NoSuchElementException();
            }
            TerminalFilterResultInfoDto it3 = (TerminalFilterResultInfoDto)it.next();
            boolean bl3 = false;
            Comparable comparable = Long.valueOf(it3.getAbsoluteEndOffset());
            while (it.hasNext()) {
                TerminalFilterResultInfoDto it4 = (TerminalFilterResultInfoDto)it.next();
                $i$a$-maxOf-HighlightTaskRunner$describe$1$maxOffset$1 = false;
                Comparable comparable2 = Long.valueOf(it4.getAbsoluteEndOffset());
                if (comparable.compareTo(comparable2) >= 0) continue;
                comparable = comparable2;
            }
            TerminalOffset maxOffset = terminalOutputModelSnapshot.absoluteOffset(((Number)((Object)comparable)).longValue());
            $this$describe_u24lambda_u240.append(minOffset).append("-").append(maxOffset);
            TerminalLine minLine = this.outputModel.lineByOffset(minOffset);
            TerminalLine maxLine = this.outputModel.lineByOffset(maxOffset);
            $this$describe_u24lambda_u240.append(", lines ").append(minLine).append("-").append(maxLine);
            $this$describe_u24lambda_u240.append(" and IDs ");
            Iterator iterator = ((Iterable)results).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            TerminalFilterResultInfoDto it5 = (TerminalFilterResultInfoDto)iterator.next();
            boolean bl4 = false;
            long l = it5.getId().getValue();
            while (iterator.hasNext()) {
                TerminalFilterResultInfoDto it6 = (TerminalFilterResultInfoDto)iterator.next();
                $i$a$-minOf-HighlightTaskRunner$describe$1$minId$1 = false;
                long l2 = it6.getId().getValue();
                if (l <= l2) continue;
                l = l2;
            }
            long minId = l;
            Iterator iterator2 = ((Iterable)results).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            TerminalFilterResultInfoDto it7 = (TerminalFilterResultInfoDto)iterator2.next();
            boolean bl5 = false;
            long l3 = it7.getId().getValue();
            while (iterator2.hasNext()) {
                TerminalFilterResultInfoDto it8 = (TerminalFilterResultInfoDto)iterator2.next();
                $i$a$-maxOf-HighlightTaskRunner$describe$1$maxId$1 = false;
                long l4 = it8.getId().getValue();
                if (l3 >= l4) continue;
                l3 = l4;
            }
            long maxId = l3;
            $this$describe_u24lambda_u240.append(minId).append("-").append(maxId);
        }
        return stringBuilder.toString();
    }

    public static final /* synthetic */ Object access$computeBottomResults(HighlightTaskRunner $this, Continuation $completion) {
        return $this.computeBottomResults((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$computeTopResults(HighlightTaskRunner $this, Continuation $completion) {
        return $this.computeTopResults((Continuation<? super Unit>)$completion);
    }
}

