/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.codeInsight.highlighting.BackgroundHighlightingUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.actions.ChangeEditorFontSizeStrategy;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.EmptySoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalFontSizeProvider;
import com.intellij.terminal.frontend.view.impl.CopyOnSelectionHandler;
import com.intellij.terminal.frontend.view.impl.TerminalLineWrapPositionStrategy;
import com.intellij.terminal.frontend.view.impl.TerminalOutputTextEditor;
import com.intellij.terminal.frontend.view.impl.TerminalOutputVirtualFile;
import com.intellij.util.CoroutinesKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalFontSettingsListener;
import org.jetbrains.plugins.terminal.TerminalFontSettingsService;
import org.jetbrains.plugins.terminal.TerminalFontSizeProviderImpl;
import org.jetbrains.plugins.terminal.block.ui.ChangeTerminalFontSizeStrategy;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.ui.VerticalSpaceInlayRenderer;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015J(\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalEditorFactory;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createOutputEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "createAlternateBufferEditor", "listenEditorFontChanges", "", "editor", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "onFontChanged", "Lkotlin/Function0;", "createEditor", "document", "Lcom/intellij/openapi/editor/Document;", "createDocument", "withLanguage", "", "configureSoftWraps", "addTopAndBottomInsets", "Lcom/intellij/openapi/editor/Editor;", "intellij.terminal.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalEditorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEditorFactory.kt\ncom/intellij/terminal/frontend/view/impl/TerminalEditorFactory\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n13#2:159\n*S KotlinDebug\n*F\n+ 1 TerminalEditorFactory.kt\ncom/intellij/terminal/frontend/view/impl/TerminalEditorFactory\n*L\n35#1:159\n*E\n"})
public final class TerminalEditorFactory {
    @NotNull
    public static final TerminalEditorFactory INSTANCE = new TerminalEditorFactory();
    @NotNull
    private static final Logger LOG;

    private TerminalEditorFactory() {
    }

    @NotNull
    public final EditorImpl createOutputEditor(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Document document = this.createDocument(true);
        EditorImpl editor = this.createEditor(document, project, settings, coroutineScope);
        editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_OUTPUT_MODEL_EDITOR_KEY(), (Object)true);
        this.addTopAndBottomInsets((Editor)editor);
        BackgroundHighlightingUtil.disableBackgroundHighlightingForeverIn((Editor)((Editor)editor));
        TextEditorProvider.Companion.putTextEditor((Editor)editor, (TextEditor)new TerminalOutputTextEditor((Editor)editor));
        return editor;
    }

    @NotNull
    public final EditorImpl createAlternateBufferEditor(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Document document = this.createDocument(false);
        EditorImpl editor = this.createEditor(document, project, settings, coroutineScope);
        editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_ALTERNATE_BUFFER_MODEL_EDITOR_KEY(), (Object)true);
        editor.getScrollPane().setVerticalScrollBarPolicy(21);
        editor.getScrollPane().setHorizontalScrollBarPolicy(31);
        return editor;
    }

    public final void listenEditorFontChanges(@NotNull EditorImpl editor, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull Disposable parentDisposable, @NotNull Function0<Unit> onFontChanged) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(onFontChanged, (String)"onFontChanged");
        editor.putUserData(ChangeEditorFontSizeStrategy.KEY, (Object)ChangeTerminalFontSizeStrategy.INSTANCE);
        editor.putUserData(TerminalFontSizeProvider.KEY, (Object)TerminalFontSizeProviderImpl.Companion.getInstance());
        TerminalFontSettingsListener fontSettingsListener2 = new TerminalFontSettingsListener(editor, settings, onFontChanged){
            final /* synthetic */ EditorImpl $editor;
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ Function0<Unit> $onFontChanged;
            {
                this.$editor = $editor;
                this.$settings = $settings;
                this.$onFontChanged = $onFontChanged;
            }

            public void fontSettingsChanged() {
                TerminalUiUtilsKt.applyFontSettings(this.$editor, this.$settings);
                this.$editor.reinitSettings();
                this.$onFontChanged.invoke();
            }
        };
        TerminalFontSettingsService.Companion.getInstance().addListener(fontSettingsListener2, parentDisposable);
        TerminalFontSizeProviderImpl.Companion.getInstance().addListener(parentDisposable, new TerminalFontSizeProvider.Listener(editor, onFontChanged){
            final /* synthetic */ EditorImpl $editor;
            final /* synthetic */ Function0<Unit> $onFontChanged;
            {
                this.$editor = $editor;
                this.$onFontChanged = $onFontChanged;
            }

            public void fontChanged(boolean showZoomIndicator) {
                TerminalUiUtilsKt.setTerminalFontSize(this.$editor, TerminalFontSizeProviderImpl.Companion.getInstance().getFontSize(), showZoomIndicator);
                this.$onFontChanged.invoke();
            }
        });
    }

    private final EditorImpl createEditor(Document document, Project project, JBTerminalSystemSettingsProviderBase settings, CoroutineScope coroutineScope) {
        EditorImpl editor = TerminalUiUtils.INSTANCE.createOutputEditor(document, project, settings, false);
        editor.getContentComponent().setFocusTraversalKeysEnabled(false);
        editor.setContextMenuGroupId("Terminal.ReworkedTerminalContextMenu");
        this.configureSoftWraps(editor);
        CopyOnSelectionHandler.Companion.install((Editor)editor, settings);
        CoroutinesKt.awaitCancellationAndInvoke((CoroutineScope)coroutineScope, (CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getUiWithModelAccess((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editor, null){
            int label;
            final /* synthetic */ EditorImpl $editor;
            {
                this.$editor = $editor;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            EditorFactory.getInstance().releaseEditor((Editor)this.$editor);
                        }
                        catch (Exception ex) {
                            List list;
                            if (ex instanceof ExceptionWithAttachments) {
                                void $this$mapTo$iv$iv;
                                Attachment[] attachmentArray = ((ExceptionWithAttachments)ex).getAttachments();
                                Intrinsics.checkNotNullExpressionValue((Object)attachmentArray, (String)"getAttachments(...)");
                                Object[] $this$map$iv = attachmentArray;
                                boolean $i$f$map = false;
                                Object[] objectArray = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                for (void item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    Attachment attachment = (Attachment)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getPath() + "\n" + it.getDisplayText());
                                }
                                list = (List)destination$iv$iv;
                            } else {
                                list = CollectionsKt.emptyList();
                            }
                            List details = list;
                            Collection $this$toTypedArray$iv = details;
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            String[] stringArray = thisCollection$iv.toArray(new String[0]);
                            TerminalEditorFactory.access$getLOG$p().error("Error releasing editor", (Throwable)ex, Arrays.copyOf(stringArray, stringArray.length));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return editor;
    }

    private final Document createDocument(boolean withLanguage) {
        return withLanguage ? (Document)ActionsKt.runReadAction(TerminalEditorFactory::createDocument$lambda$0) : (Document)new DocumentImpl((CharSequence)"", true);
    }

    private final void configureSoftWraps(EditorImpl editor) {
        editor.getSettings().setUseSoftWraps(true);
        editor.getSettings().setUseCustomSoftWrapIndent(false);
        SoftWrapModelImpl softWrapModelImpl = editor.getSoftWrapModel();
        Intrinsics.checkNotNullExpressionValue((Object)softWrapModelImpl, (String)"getSoftWrapModel(...)");
        SoftWrapModelImpl softWrapModel = softWrapModelImpl;
        softWrapModel.getApplianceManager().setLineWrapPositionStrategy((LineWrapPositionStrategy)new TerminalLineWrapPositionStrategy());
        softWrapModel.getApplianceManager().setSoftWrapsUnderScrollBar(true);
        softWrapModel.setSoftWrapPainter((SoftWrapPainter)EmptySoftWrapPainter.INSTANCE);
    }

    private final void addTopAndBottomInsets(Editor editor) {
        InlayModel inlayModel = editor.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
        InlayModel inlayModel2 = inlayModel;
        VerticalSpaceInlayRenderer topRenderer = new VerticalSpaceInlayRenderer(6);
        Intrinsics.checkNotNull((Object)inlayModel2.addBlockElement(0, false, true, 200, (EditorCustomElementRenderer)topRenderer));
        VerticalSpaceInlayRenderer bottomRenderer = new VerticalSpaceInlayRenderer(6);
        inlayModel2.addBlockElement(editor.getDocument().getTextLength(), true, false, 0, (EditorCustomElementRenderer)bottomRenderer);
    }

    private static final Document createDocument$lambda$0() {
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)new TerminalOutputVirtualFile());
        Intrinsics.checkNotNull((Object)document);
        return document;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalEditorFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

