/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.frontend.view.impl.TerminalHeuristicsBasedCommandFinishTracker;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLine;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker;", "", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onCommandFinish", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function0;)V", "curLineInfo", "Lcom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker$LineInfo;", "commandStartRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "modelUpdatesFlow", "Lkotlinx/coroutines/flow/Flow;", "handleKeyPressed", "e", "Ljava/awt/event/KeyEvent;", "doHandleKeyPressed", "updateCurLineInfo", "trackCommandFinish", "lineInfo", "(Lcom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker$LineInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTextBeforeCursor", "", "cursorOffset", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "createModelUpdatesFlow", "LineInfo", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalHeuristicsBasedCommandFinishTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalHeuristicsBasedCommandFinishTracker.kt\ncom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n60#2,5:156\n60#2,5:161\n60#2,5:166\n13#2:171\n*S KotlinDebug\n*F\n+ 1 TerminalHeuristicsBasedCommandFinishTracker.kt\ncom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker\n*L\n77#1:156,5\n101#1:161,5\n118#1:166,5\n153#1:171\n*E\n"})
public final class TerminalHeuristicsBasedCommandFinishTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final Function0<Unit> onCommandFinish;
    @Nullable
    private LineInfo curLineInfo;
    @NotNull
    private final MutableSharedFlow<LineInfo> commandStartRequests;
    @NotNull
    private final Flow<Unit> modelUpdatesFlow;
    private static final long PROMPT_CHECKING_DELAY = 500L;
    private static final int MAX_LINE_LENGTH = 1000;
    @NotNull
    private static final Logger LOG;

    public TerminalHeuristicsBasedCommandFinishTracker(@NotNull TerminalOutputModel outputModel, @NotNull CoroutineScope coroutineScope, @NotNull Function0<Unit> onCommandFinish) {
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(onCommandFinish, (String)"onCommandFinish");
        this.outputModel = outputModel;
        this.onCommandFinish = onCommandFinish;
        this.commandStartRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.modelUpdatesFlow = this.createModelUpdatesFlow(CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"TerminalOutputModel updates", null, (boolean)false, (int)6, null));
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalHeuristicsBasedCommandFinishTracker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.commandStartRequests), (Function2)((Function2)new Function2<LineInfo, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ TerminalHeuristicsBasedCommandFinishTracker this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                LineInfo lineInfo = (LineInfo)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void lineInfo2;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)lineInfo2);
                                        this.label = 1;
                                        Object object2 = this.this$0.trackCommandFinish((LineInfo)lineInfo2, (Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(LineInfo p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @RequiresEdt
    public final void handleKeyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        try {
            this.doHandleKeyPressed(e);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    private final void doHandleKeyPressed(KeyEvent e) {
        this.updateCurLineInfo();
        LineInfo lineInfo = this.curLineInfo;
        if (e.getKeyCode() == 10 && lineInfo != null) {
            TerminalOffset cursorOffset = this.outputModel.getCursorOffset();
            String string = this.getTextBeforeCursor(cursorOffset);
            if (string == null) {
                return;
            }
            String textBeforeCursor = string;
            if (StringsKt.startsWith$default((String)textBeforeCursor, (String)lineInfo.getPromptText(), (boolean)false, (int)2, null) && textBeforeCursor.length() > lineInfo.getPromptText().length()) {
                if (!this.commandStartRequests.tryEmit((Object)lineInfo)) {
                    throw new IllegalStateException("Check failed.");
                }
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Command start detected", e$iv);
                }
            }
        }
    }

    private final void updateCurLineInfo() {
        LineInfo lineInfo = this.curLineInfo;
        TerminalOffset cursorOffset = this.outputModel.getCursorOffset();
        TerminalLine cursorLine = this.outputModel.lineByOffset(cursorOffset);
        String textBeforeCursor = this.getTextBeforeCursor(cursorOffset);
        if (textBeforeCursor == null) {
            this.curLineInfo = null;
        } else {
            LineInfo lineInfo2 = lineInfo;
            if (!Intrinsics.areEqual((Object)(lineInfo2 != null ? lineInfo2.getLine() : null), (Object)cursorLine)) {
                this.curLineInfo = new LineInfo(cursorLine, textBeforeCursor);
            } else if (!StringsKt.startsWith$default((String)textBeforeCursor, (String)lineInfo.getPromptText(), (boolean)false, (int)2, null)) {
                this.curLineInfo = LineInfo.copy$default(lineInfo, null, textBeforeCursor, 1, null);
            }
        }
        if (!Intrinsics.areEqual((Object)this.curLineInfo, (Object)lineInfo)) {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Current line info updated: " + this.curLineInfo, e$iv);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object trackCommandFinish(LineInfo lineInfo, Continuation<? super Unit> $completion) {
        if (!($completion instanceof trackCommandFinish.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalHeuristicsBasedCommandFinishTracker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalHeuristicsBasedCommandFinishTracker.access$trackCommandFinish(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)lineInfo);
                $continuation.label = 1;
                v0 = FlowKt.first((Flow)FlowKt.debounce(this.modelUpdatesFlow, (long)500L), (Function2)((Function2)new Function2<Unit, Continuation<? super Boolean>, Object>(this, lineInfo, null){
                    int label;
                    final /* synthetic */ TerminalHeuristicsBasedCommandFinishTracker this$0;
                    final /* synthetic */ LineInfo $lineInfo;
                    {
                        this.this$0 = $receiver;
                        this.$lineInfo = $lineInfo;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                TerminalOffset cursorOffset = TerminalHeuristicsBasedCommandFinishTracker.access$getOutputModel$p(this.this$0).getCursorOffset();
                                TerminalLine cursorLine = TerminalHeuristicsBasedCommandFinishTracker.access$getOutputModel$p(this.this$0).lineByOffset(cursorOffset);
                                return Boxing.boxBoolean((!Intrinsics.areEqual((Object)cursorLine, (Object)this.$lineInfo.getLine()) && Intrinsics.areEqual((Object)TerminalHeuristicsBasedCommandFinishTracker.access$getTextBeforeCursor(this.this$0, cursorOffset), (Object)this.$lineInfo.getPromptText()) ? 1 : 0) != 0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Unit p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                lineInfo = (LineInfo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.onCommandFinish.invoke();
                $this$debug_u24default$iv = TerminalHeuristicsBasedCommandFinishTracker.LOG;
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var7_9 = $this$debug_u24default$iv;
                    $i$a$-debug$default-TerminalHeuristicsBasedCommandFinishTracker$trackCommandFinish$3 = false;
                    var7_9.debug("Command finish detected", e$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getTextBeforeCursor(TerminalOffset cursorOffset) {
        TerminalLine lineNumber = this.outputModel.lineByOffset(cursorOffset);
        TerminalOffset lineStartOffset = this.outputModel.startOffset(lineNumber);
        long length = cursorOffset.minus(lineStartOffset);
        return length <= 1000L ? this.outputModel.getText(lineStartOffset, lineStartOffset.plus(length)) : null;
    }

    private final Flow<Unit> createModelUpdatesFlow(CoroutineScope coroutineScope) {
        MutableSharedFlow flow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.outputModel.addListener(com.intellij.util.CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new TerminalOutputModelListener((MutableSharedFlow<Unit>)flow){
            final /* synthetic */ MutableSharedFlow<Unit> $flow;
            {
                this.$flow = $flow;
            }

            public void afterContentChanged(TerminalOutputModel model, TerminalOffset startOffset, boolean isTypeAhead) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Intrinsics.checkNotNullParameter((Object)startOffset, (String)"startOffset");
                if (!this.$flow.tryEmit((Object)Unit.INSTANCE)) {
                    throw new IllegalStateException("Check failed.");
                }
            }
        });
        return (Flow)flow;
    }

    public static final /* synthetic */ TerminalOutputModel access$getOutputModel$p(TerminalHeuristicsBasedCommandFinishTracker $this) {
        return $this.outputModel;
    }

    public static final /* synthetic */ String access$getTextBeforeCursor(TerminalHeuristicsBasedCommandFinishTracker $this, TerminalOffset cursorOffset) {
        return $this.getTextBeforeCursor(cursorOffset);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalHeuristicsBasedCommandFinishTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker$Companion;", "", "<init>", "()V", "PROMPT_CHECKING_DELAY", "", "MAX_LINE_LENGTH", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker$LineInfo;", "", "line", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;", "promptText", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;Ljava/lang/String;)V", "getLine", "()Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;", "getPromptText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal.frontend"})
    private static final class LineInfo {
        @NotNull
        private final TerminalLine line;
        @NotNull
        private final String promptText;

        public LineInfo(@NotNull TerminalLine line, @NotNull String promptText) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)promptText, (String)"promptText");
            this.line = line;
            this.promptText = promptText;
        }

        @NotNull
        public final TerminalLine getLine() {
            return this.line;
        }

        @NotNull
        public final String getPromptText() {
            return this.promptText;
        }

        @NotNull
        public final TerminalLine component1() {
            return this.line;
        }

        @NotNull
        public final String component2() {
            return this.promptText;
        }

        @NotNull
        public final LineInfo copy(@NotNull TerminalLine line, @NotNull String promptText) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)promptText, (String)"promptText");
            return new LineInfo(line, promptText);
        }

        public static /* synthetic */ LineInfo copy$default(LineInfo lineInfo, TerminalLine terminalLine, String string, int n, Object object) {
            if ((n & 1) != 0) {
                terminalLine = lineInfo.line;
            }
            if ((n & 2) != 0) {
                string = lineInfo.promptText;
            }
            return lineInfo.copy(terminalLine, string);
        }

        @NotNull
        public String toString() {
            return "LineInfo(line=" + this.line + ", promptText=" + this.promptText + ")";
        }

        public int hashCode() {
            int result2 = this.line.hashCode();
            result2 = result2 * 31 + this.promptText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineInfo)) {
                return false;
            }
            LineInfo lineInfo = (LineInfo)other;
            if (!Intrinsics.areEqual((Object)this.line, (Object)lineInfo.line)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.promptText, (Object)lineInfo.promptText);
        }
    }
}

