/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLine;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLineImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffsetImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelSnapshot;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelSnapshotImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0013H\u0004J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\tH\u0016J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001dH\u0016J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0019H\u0016J\b\u0010/\u001a\u00020\u0001H\u0016J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\f\u00106\u001a\u00020\u0013*\u00020\u0019H\u0004J\f\u00106\u001a\u00020\u0013*\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\u0082\u0001\u000278\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/AbstractTerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelSnapshot;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/editor/Document;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "trimmedCharsCount", "", "getTrimmedCharsCount", "()J", "trimmedLinesCount", "getTrimmedLinesCount", "immutableText", "", "getImmutableText", "()Ljava/lang/CharSequence;", "lineCount", "", "getLineCount", "()I", "modificationStamp", "getModificationStamp", "startOffset", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "getStartOffset", "()Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "firstLine", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;", "getFirstLine", "()Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;", "lastLine", "getLastLine", "relativeOffset", "offset", "absoluteOffset", "absoluteLine", "line", "lineByOffset", "endOffset", "includeEOL", "", "getText", "", "start", "end", "snapshot", "addListener", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelListener;", "toRelative", "Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelSnapshotImpl;", "intellij.terminal"})
@ApiStatus.Internal
public abstract sealed class AbstractTerminalOutputModelImpl
implements TerminalOutputModelSnapshot
permits MutableTerminalOutputModelImpl, TerminalOutputModelSnapshotImpl {
    @NotNull
    private final Document document;

    private AbstractTerminalOutputModelImpl(Document document) {
        this.document = document;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public abstract long getTrimmedCharsCount();

    public abstract long getTrimmedLinesCount();

    @Override
    @NotNull
    public CharSequence getImmutableText() {
        CharSequence charSequence = this.document.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        return charSequence;
    }

    @Override
    public int getLineCount() {
        return this.document.getLineCount();
    }

    @Override
    public long getModificationStamp() {
        return this.document.getModificationStamp();
    }

    @Override
    @NotNull
    public TerminalOffset getStartOffset() {
        return this.relativeOffset(0);
    }

    @Override
    @NotNull
    public TerminalLine getFirstLine() {
        return new TerminalLineImpl(this.getTrimmedLinesCount());
    }

    @Override
    @NotNull
    public TerminalLine getLastLine() {
        return new TerminalLineImpl(this.getTrimmedLinesCount() + (long)this.getLineCount() - 1L);
    }

    @NotNull
    protected final TerminalOffset relativeOffset(int offset) {
        return new TerminalOffsetImpl(this.getTrimmedCharsCount() + (long)offset);
    }

    @Override
    @NotNull
    public TerminalOffset absoluteOffset(long offset) {
        return new TerminalOffsetImpl(offset);
    }

    @Override
    @NotNull
    public TerminalLine absoluteLine(long line) {
        return new TerminalLineImpl(line);
    }

    @Override
    @NotNull
    public TerminalLine lineByOffset(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new TerminalLineImpl(this.getTrimmedLinesCount() + (long)this.document.getLineNumber(this.toRelative(offset)));
    }

    @Override
    @NotNull
    public TerminalOffset startOffset(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.relativeOffset(this.document.getLineStartOffset(this.toRelative(line)));
    }

    @Override
    @NotNull
    public TerminalOffset endOffset(@NotNull TerminalLine line, boolean includeEOL) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int result2 = this.document.getLineEndOffset(this.toRelative(line));
        if (includeEOL && result2 < TerminalOutputModelKt.getTextLength(this)) {
            ++result2;
        }
        return this.relativeOffset(result2);
    }

    @Override
    @NotNull
    public String getText(@NotNull TerminalOffset start2, @NotNull TerminalOffset end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        String string = this.document.getText(new TextRange(this.toRelative(start2), this.toRelative(end)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    @NotNull
    public TerminalOutputModelSnapshot snapshot() {
        return this;
    }

    @Override
    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalOutputModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    protected final int toRelative(@NotNull TerminalOffset $this$toRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$toRelative, (String)"<this>");
        return (int)$this$toRelative.minus(this.getStartOffset());
    }

    private final int toRelative(TerminalLine $this$toRelative) {
        return (int)$this$toRelative.minus(this.getFirstLine());
    }

    public /* synthetic */ AbstractTerminalOutputModelImpl(Document document, DefaultConstructorMarker $constructor_marker) {
        this(document);
    }
}

