/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import ai.grazie.gec.model.CorrectionServiceType;
import ai.grazie.gec.model.problem.ActionSuggestion;
import ai.grazie.gec.model.problem.Category;
import ai.grazie.gec.model.problem.Problem;
import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.gec.model.problem.ProblemHighlighting;
import ai.grazie.gec.model.problem.ProblemKindID;
import ai.grazie.gec.model.settings.Setting;
import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.settings.RuleSetting;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.Parameter;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.utils.attributes.StringProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public abstract class RuleMatch {
    private static final String anyDash = "[\u2013\u2014]";
    private final Rule rule;
    private final String message;

    protected RuleMatch(Rule rule, String message) {
        this.rule = rule;
        this.message = message;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final String message() {
        return this.message;
    }

    public abstract List<ProblemFix> problemFixes();

    @Nullable
    public List<ProblemFix> asciiContextFixes(String fullText) {
        ArrayList<ProblemFix> list = new ArrayList<ProblemFix>();
        for (ProblemFix fix : this.problemFixes()) {
            ProblemFix.Part.Change[] changes = fix.getChanges();
            if (changes.length == 1 && RuleMatch.ignoreDashReplacement(changes[0])) {
                return null;
            }
            ProblemFix adjusted = new ProblemFix((ProblemFix.Part[])Arrays.stream(fix.getParts()).map(part -> {
                ProblemFix.Part part2;
                if (part instanceof ProblemFix.Part.Change) {
                    ProblemFix.Part.Change c = (ProblemFix.Part.Change)part;
                    part2 = new ProblemFix.Part.Change(c.getRange(), RuleMatch.toAscii(c.getText()));
                } else {
                    part2 = part;
                }
                return part2;
            }).toArray(ProblemFix.Part[]::new), fix.getBatchId(), fix.getCustomDisplayName());
            if (adjusted.apply(fullText).equals(fullText)) {
                return null;
            }
            list.add(adjusted);
        }
        return list;
    }

    private static boolean ignoreDashReplacement(ProblemFix.Part.Change change) {
        return change.getRange().getLength() > 1 && change.getText().strip().equals("\u2014");
    }

    private static String toAscii(String text) {
        return text.replaceAll(anyDash, "-").replaceAll("[\u00a0\u2009\u202f]", " ").replaceAll("\u2026", "...").replaceAll("[\u201c\u201d\u201e\u00ab\u00bb]", "\"").replaceAll("[`\u2018\u2019]", "'");
    }

    public abstract List<TextRange> reportedRanges();

    public List<TextRange> hoverReportedRanges() {
        return this.reportedRanges();
    }

    public List<ActionSuggestion> actions() {
        return List.of();
    }

    @Nullable
    public NodeMatch.SuppressableKind suppressableKind() {
        return null;
    }

    public boolean autoFixCapable() {
        return false;
    }

    public boolean hasLowConfidence() {
        return false;
    }

    public boolean concedeToOtherGrammarCheckers() {
        return this.rule().id.startsWith("Style.") || this.problemFixes().isEmpty();
    }

    public List<TextChange> correctionChanges() {
        return this.problemFixes().stream().map(fix -> (TextChange)StreamEx.of((Object[])fix.getChanges()).map(c -> TextChange.replace(c.getRange().getStart(), c.getRange().getEndExclusive(), c.getText())).reduce((Object)TextChange.EMPTY, TextChange::and)).toList();
    }

    public Pair<TextRange, List<String>> singleRangeReplacements(String text) {
        List<TextChange> changes = this.correctionChanges();
        TextRange range = TextRange.spanRanges(changes.isEmpty() ? this.reportedRanges().stream() : changes.stream().map(c -> c.changedRange()));
        return new Pair((Object)range, changes.stream().map(c -> c.performOnRange(text, range)).distinct().toList());
    }

    public Problem toProblem(RuleClient client) {
        try {
            Rule rule = this.rule();
            Language language = rule.language();
            boolean hasSetting = StreamEx.of(LanguageToolkit.forLanguage(language).getSettings(client)).flatCollection(g -> g.settings()).anyMatch(s -> {
                if (!(s instanceof RuleSetting)) return false;
                RuleSetting rs = (RuleSetting)s;
                if (rs.rule != rule) return false;
                return true;
            });
            Problem.KindInfo kindInfo = new Problem.KindInfo(ProblemKindID.Companion.of(CorrectionServiceType.RULE, language, rule.id), this.getCategory(), CorrectionServiceType.RULE, rule.displayName, hasSetting ? rule.globalId() : null, this.hasLowConfidence() ? Problem.Confidence.LOW : Problem.Confidence.HIGH);
            StringProperties experimental = null;
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.autoFixCapable()) {
                map.put("autoFixCapable", "true");
            }
            if (this.concedeToOtherGrammarCheckers()) {
                map.put("concedeToOtherGrammarCheckers", "true");
            }
            if (!map.isEmpty()) {
                experimental = StringProperties.Companion.fromMap(map);
            }
            StringProperties condition = null;
            HashMap<String, String> map2 = new HashMap<String, String>();
            NodeMatch.SuppressableKind kind = this.suppressableKind();
            if (kind != null) {
                map2.put("suppressableKind", kind.toString());
            }
            if (!map2.isEmpty()) {
                condition = StringProperties.Companion.fromMap(map2);
            }
            ArrayList<Object> suggestions = new ArrayList<Object>();
            for (ActionSuggestion action : this.actions()) {
                if (action instanceof ActionSuggestion.ChangeParameter) {
                    ActionSuggestion.ChangeParameter cp = (ActionSuggestion.ChangeParameter)action;
                    Parameter param = cp.parameter();
                    Setting.Value suggestedValue = StreamEx.of(param.possibleValues(client)).findFirst(v -> v.id().equals(cp.suggestedValue())).orElse(null);
                    suggestions.add(new ActionSuggestion.ChangeParameter(param.globalId(), param.displayName(), suggestedValue == null ? null : new Setting.Value(suggestedValue.id(), suggestedValue.displayName()), cp.quickFixText()));
                    continue;
                }
                if (action != ActionSuggestion.SHORTEN) continue;
                suggestions.add(ActionSuggestion.Shorten.INSTANCE);
            }
            return new Problem(kindInfo, Objects.requireNonNull(this.message()), new ProblemHighlighting(RuleMatch.toPlatformRanges(this.reportedRanges()), RuleMatch.toPlatformRanges(this.hoverReportedRanges())), this.problemFixes().toArray(new ProblemFix[0]), experimental, condition, suggestions.isEmpty() ? null : suggestions.toArray(new ai.grazie.gec.model.problem.ActionSuggestion[0]), false);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while running rule " + this.rule.globalId(), e);
        }
    }

    private static ai.grazie.text.TextRange[] toPlatformRanges(List<TextRange> ranges) {
        return (ai.grazie.text.TextRange[])ranges.stream().map(r -> new ai.grazie.text.TextRange(r.start(), r.end())).toArray(ai.grazie.text.TextRange[]::new);
    }

    private Category getCategory() {
        StyleFlavor flavor = this.rule().getStyleFlavor();
        if (flavor != null) {
            return switch (flavor) {
                default -> throw new IncompatibleClassChangeError();
                case StyleFlavor.Readability -> Category.READABILITY;
                case StyleFlavor.Inclusivity -> Category.INCLUSIVITY;
                case StyleFlavor.Tone -> Category.TONE;
                case StyleFlavor.Formality -> Category.FORMALITY;
            };
        }
        return switch (this.rule().id.split("\\.")[0].toLowerCase(Locale.ROOT)) {
            case "grammar" -> Category.GRAMMAR;
            case "punctuation" -> Category.PUNCTUATION;
            case "semantics" -> Category.SEMANTICS;
            case "style" -> Category.STYLE;
            case "typography" -> Category.TYPOGRAPHY;
            case "spelling" -> Category.SPELLING;
            default -> Category.OTHER;
        };
    }
}

