/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.common.FeatureUtil;
import ai.grazie.rules.common.MessageUtil;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.DigraphNormalization;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GermanValences;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SemCompatibility;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

class AgreementSet {
    static final NodePattern wasFuer = NodePattern.N.withDependent("case", NodePattern.N.form("f(ue|\u00fc)r").markAs("Fuer")).andOr(NodePattern.markedNodeMatches("Fuer", NodePattern.N.directlyAfter(NodePattern.N.form("was"))), NodePattern.N.withDependent("cop").withDependent(".*", NodePattern.N.before("Fuer").form("was")), NodePattern.N.withHead("obl", NodePattern.N.withDependent(".*", NodePattern.N.before("Fuer").form("was"))), NodePattern.N.withHead("nmod", NodePattern.N.before("Fuer").form("was").withDependent("cop")));
    private static final NodePattern ohneZu = NodePattern.N.withDependent("case", NodePattern.N.form("ohne")).andOr(NodePattern.N.withHead("obl", NodePattern.or(NodePattern.N.withDependent("mark", NodePattern.N.form("zu")), NodePattern.N.pos("VER:EIZ.*"))), NodePattern.N.withDependent("mark", NodePattern.N.afterHead().form("zu")));
    private static final NodePattern allowedUninflectedNoun = NodePattern.N.potentialPos("SUB:NOM:SIN.*").andOr(NodePattern.N.form(".*(pr\u00e4sident|senator|f\u00fcrst|professor|kosmonaut|k\u00f6nig)").andOr(NodePattern.N.noDependents("amod|det.*"), NodePattern.N.withDependent("appos|flat", NodePattern.N.label("PERSON"))), NodePattern.or(NodePattern.N.form(".*abgeordnete"), NodePattern.N.withDependent("appos|flat", NodePattern.N.label("PERSON")), NodePattern.N.withDependent("case", NodePattern.N.directlyBeforeHead()).directlyAfter(NodePattern.N.form("trotz|laut|inklusive"))).noDependents("amod|det.*"));
    private static final NodePattern conjAttachmentAmbiguity = NodePattern.N.withHeadRelation("conj").andOr(NodePattern.N.withHead(NodePattern.N.withHeadRelation("nmod")).noDependents("case").andNot(NodePattern.N.withDependent("cc").noDependents("det.*").withPrevSibling(NodePattern.N.withHeadRelation("conj"))), NodePattern.N.withHead(NodePattern.N.withHeadRelation("conj")), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nmod").withDependent("conj")), NodePattern.N.withDependent("cc", NodePattern.N.form("aber")).withHead("conj", NodePattern.N.withDependent("case")), NodePattern.N.withHead(NodePattern.N.onlyPos("PRO:PER.*NEU")).pos("SUB.*"));
    private static final NodePattern verbalArg = NodePattern.N.withHeadRelation("i?obj|obl");
    private static final NodePattern misparsedClauseEllipsis = NodePattern.N.withHead("conj", verbalArg.withHead(NodePattern.N.markAs("Verb"))).andOr(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj").withDependent("case")), NodePattern.N.withDependent("nmod", NodePattern.N.afterHead().withDependent("case")).andOr(NodePattern.markedNodeMatches("Verb", NodePattern.N.withPrevSibling(verbalArg)), NodePattern.N.withDependent("cc").withHead(NodePattern.N.withPrevSibling(verbalArg))), NodePattern.N.withDependent("i?obj", NodePattern.N.afterHead().withDependent("det")));
    private static final NodePattern inflectablePronoun = NodePattern.N.pos("PRO.*(NOM|GEN|AKK|DAT).*");
    private static final NodePattern modifierEllipsis = NodePattern.N.pos("ADJ.*|PRO.*").withNextSibling(NodePattern.N.withHeadRelation("conj").withDependent("amod|det.*"));
    private static final NodePattern beforeHyphen = NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE.andNot(NodePattern.N.directlyBefore(Case.misparsedFlatHead)));
    private static final NodePattern abbreviationVocative = NodePattern.N.form("(Dr|Prof)\\.?");
    private static final NodePattern misparsedCaseCombination = NodePattern.N.afterHead().withDependent("case", NodePattern.N.form("bis|statt")).withDependent("nummod").withHead("nmod", NodePattern.or(CommonPatterns.withNumberLikeForm, NodePattern.N.pos("ZAL"), NodePattern.N.lemma("ein")));
    private static final NodePattern foreignEmbedding = NodePattern.or(NodePattern.or(NodePattern.N.withDependent("appos|compound", GermanTreePatterns.englishWord.andNot(abbreviationVocative).afterHead()), NodePattern.N.withDependent("punct", GermanTreePatterns.anyQuotation.beforeHead()).withDependent("punct", GermanTreePatterns.anyQuotation.afterHead()), NodePattern.N.inFormSequence(1, "the", ".*")).and(GermanTreePatterns.englishWord), NodePattern.N.onlyPos("ADJ.*").directlyBefore(NodePattern.N.noPos()), NodePattern.N.form("Agent|Kinds"), NodePattern.N.form("Produkt").withDependent("appos", GermanTreePatterns.englishWord), NodePattern.N.form("Template").directlyAfter(CommonPatterns.HYPHEN_NODE));
    private static final NodePattern sgWithNummodAllowed = NodePattern.or(NodePattern.N.form("Ferrari"), NodePattern.N.form("Mann").withDependent("nummod", NodePattern.N.form("\\d+")));
    private static final NodePattern timeUnit = SemanticRules.timeUnit.pos("SUB:AKK:.*").noDependents("case").andOr(NodePattern.N.noDependents("amod"), NodePattern.N.noDependents("det", NodePattern.N.lemma("ein"))).and(CommonPatterns.possiblyConj(NodePattern.N.withHead(NodePattern.ROOT).noHeadRelation("nsubj.*|nmod(:poss)?")));
    private static final NodePattern gruesse = NodePattern.N.inFormSequence(1, "(lieb|viel|sch\u00f6n|best|herzlich|freundlich).*", "gr\u00fc\u00df.*").noDependents("case");
    private static final NodePattern aufDieseWeise = NodePattern.N.lemma("weise").withDependent("case", NodePattern.N.form("auf")).withDependent("det", NodePattern.N.lemma("dies|solch"));
    private static final NodePattern aufJedenFall = NodePattern.N.form("fall").withDependent("case", NodePattern.N.form("auf")).withDependent("det", NodePattern.N.form("jede[mnsr]?"));
    private static final NodePattern sgPrepAccusativePhrase = NodePattern.or(aufDieseWeise, aufJedenFall, NodePattern.N.lemma("Punkt").withDependent("case", NodePattern.N.form("auf")).withHead("obl", NodePattern.N.lemma("bringen")), NodePattern.N.lemma("Teppich").withDependent("case", NodePattern.N.form("unter")).withHead("obl", NodePattern.N.lemma("kehren")), NodePattern.N.lemma("Geist|Wecker|Senkel|Zeiger").withDependent("case", NodePattern.N.form("auf")).withHead("obl", NodePattern.N.lemma("gehen")));
    private static final NodePattern prepAccusativePhrase = NodePattern.or(sgPrepAccusativePhrase, SpellingRules.noun.markAs("Noun").withDependent("case", NodePattern.N.form("in")).withHead("obl", NodePattern.N.lemma("integrieren").noDependents("cop|aux:pass", NodePattern.N.lemma("sein")).noDependents("obl", NodePattern.not(NodePattern.N.alreadyMarkedAs("Noun"))).andNot(NodePattern.N.withDependent("aux:pass").withDependent("aux", NodePattern.N.pos("VER:MOD.*")))).andNot(NodePattern.N.inFormSequence(2, "in", "der", "Regel")), NodePattern.N.withHead("obl", NodePattern.N.lemma("ziehen").withDependent("compound:prt", NodePattern.N.form("ein"))).withDependent("case", NodePattern.N.form("in")).andNot(timeUnit).andNot(NodePattern.N.inFormSequence(2, "in", ".*", "Folge|Moment")), NodePattern.N.withHead("conj", NodePattern.N.onlyPos(".*:AKK.*").withDependent("case", NodePattern.N.onlyPos(".*:AKK.*"))).withDependent("case", NodePattern.N.form("als")));
    private static final NodePattern sgAccPhrase = NodePattern.or(NodePattern.or(NodePattern.N.inFormSequence(1, "herzlich.*", "gl\u00fcckwunsch"), NodePattern.N.inFormSequence(1, "(viel|herzlich).*", "dank(en?)?"), NodePattern.N.inFormSequence(1, "(gut|sch\u00f6n).*", "((feier)?tag|morgen|abend|nacht|rutsch|wochenend)(en?)?")).noDependents("cop|det"), NodePattern.N.lemma("Bescheid").withHead("obj", NodePattern.N.lemma("sagen")), NodePattern.N.form("mal").withHeadRelation("ob[lj]").withDependent("det").withDependent("a(dv)?mod").noDependents("case").withOnlyDependents(NodePattern.N.beforeHead()));
    static final NodePattern alleXtimeUnit = SemanticRules.timeUnit.pos(".*PLU.*").withDependent("det", NodePattern.N.lemma("all|jed")).withDependent("nummod", NodePattern.N.directlyBeforeHead());
    static final NodePattern accusativePhrase = NodePattern.or(sgAccPhrase, gruesse, prepAccusativePhrase, alleXtimeUnit);
    static final NodePattern ausDemVollen = NodePattern.N.form("Vollen").withDependent("case", NodePattern.N.form("aus")).withDependent("det", NodePattern.N.directlyBeforeHead());
    static final NodePattern dativePhrase = NodePattern.or(NodePattern.N.withHead("iobj", NodePattern.N.lemma("leisten").withDependent("nsubj", NodePattern.N.form("Folge").noDependents())), NodePattern.N.lemma("Interesse").withHead("obj", NodePattern.N.lemma("n\u00fctzen")), NodePattern.N.form("F\u00e4llen?").withDependent("case", NodePattern.N.form("in")).withDependent("det|amod", NodePattern.N.lemma("manch|viel|solch|dies|meist")), ausDemVollen, SemanticRules.timeUnit.withDependent("case", NodePattern.N.form("in")).withDependent("det", NodePattern.N.lemma("ein").directlyBeforeHead()), SemanticRules.languageLevels.withDependent("flat", NodePattern.N.lemma("Niveau")).withHead(NodePattern.N.lemma("sprechen|schreiben|h\u00f6ren|lesen")), NodePattern.N.withHead("nmod", NodePattern.N.lemma("Verh\u00e4ltnis|(Un)?gleichheit|Beziehung|Problem")).withDependent("case", NodePattern.N.form("zwischen")), NodePattern.N.withHead("nmod", NodePattern.N.form("Achtung")).withDependent("case", NodePattern.N.form("vor")), NodePattern.N.withHead("obl", NodePattern.N.lemma("buchen|genie\u00dfen|machen|planen|verbringen").withDependent("obj", NodePattern.N.form("Urlaub"))).withDependent("case", NodePattern.N.form("in")), NodePattern.N.form("sprache").withDependent("amod", NodePattern.N.label("LANGUAGE")).withDependent("case", NodePattern.N.form("in")).withHead("obl", NodePattern.N.lemma("(kommunizier|sprech|schreib)en")));
    private static final NodePattern tagAsDay = NodePattern.N.lemma("Tag").withDependent("amod", NodePattern.N.lemma("gut|sch\u00f6n|ganz|schlecht"));
    private static final NodePattern possibleMisparsedAdverb = NodePattern.N.form("(viel|wenig).+");
    private static final NodePattern singularOnlyDependent = NodePattern.N.withDependent("det", NodePattern.N.lemma("jeder")).noDependents("nummod");
    private static final NodePattern possibleMisparsedDetAsRelativeSubj = NodePattern.N.pos("SUB.*").withHeadRelation("obj").noDependents("det").withPrevSibling(NodePattern.N.withHeadRelation("nsubj.*").pos("ART:DEF:NOM.*"));
    private static final NodePattern expletiveSubj = NodePattern.or(NodePattern.N.form("es|dies|das|welches").withHead(NodePattern.or(NodePattern.N.withDependent("cop"), NodePattern.N.lemma("sein|werden"))), NodePattern.N.form("es").withHead(NodePattern.N.lemma("geben")));
    static final NodePattern possiblyIncorrectSubj = NodePattern.or(NodePattern.N.markAs("Nsubj").withHead("nsubj.*", NodePattern.or(NodePattern.N.withDependent("iobj", Case.possiblyMisshapedSubject), NodePattern.N.pos("VER:IMP.*").andOr(CommonPatterns.firstToken, NodePattern.N.directlyAfter(NodePattern.PUNCT)).withDependent("nsubj", NodePattern.N.pos(".*:AKK.*").noFormCaseSensitive("Sie").afterHead()).noDependents("aux|cop"), NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.alreadyMarkedAs("Nsubj").onlyPos("SUB:AKK:.*"), NodePattern.PUNCT)).pos("VER:PA2.*"))), SemanticRules.timeUnit.pos("SUB:AKK:.*").noDependents("case").withDependent("det").withDependent("nmod", NodePattern.N.withDependent("case").andOr(NodePattern.N.pos(".*NOM.*"), NodePattern.N.withDependent("flat|appos"))), NodePattern.N.withDependent("appos", NodePattern.N.pos("ART.*")), NodePattern.N.withDependent("case"), NodePattern.N.onlyPos("PRO:(DEM|PER):GEN.*"), CommonPatterns.capitalized.label("PERSON").pos("SUB.*PLU.*"), NodePattern.N.directlyBeforeHead().withHead("nsubj", NodePattern.N.pos("ADJ.*").withDependent("cop")).directlyAfter(NodePattern.N.form("so")));
    private static final NodePattern ambiguousNumberPronoun = NodePattern.N.onlyPos("PRO:.*").pos(".*SIN.*").pos(".*PLU.*").noLemma("jed");
    private static final NodePattern verbAgreementWithObjAfterCopula = NodePattern.N.pos("SUB.*").withDependent("cop", NodePattern.N.noPos(".*PLU.*")).andOr(NodePattern.N.withDependent("nsubj|expl", NodePattern.or(expletiveSubj, NodePattern.N.form("er|sie|es"))), NodePattern.N.pos(".*NOG")).noDependents("amod", NodePattern.N.withDependent("advmod", NodePattern.N.form("voll"))).noDependents("case|appos|aux|conj");
    static final NodePattern vocative = NodePattern.or(NodePattern.N.withHeadRelation("vocative"), NodePattern.or(NodePattern.N.pos("EIG:.*"), NodePattern.N.withDependent("flat.*", NodePattern.N.pos("EIG.*")), NodePattern.N.form("Damen?|(Frau|Herr)(en)?")).withDependent("amod", NodePattern.N.form("(lieb|geehrt).*")));
    static final NodePattern pluralVocative = NodePattern.or(NodePattern.N.form("Hee?rr?e?n?").withHead("conj", NodePattern.N.form("Damen?")), NodePattern.N.form("Damen?").withDependent("conj", NodePattern.N.form("Hee?rr?e?n?")));
    static final NodePattern copulaHead = NodePattern.N.pos("(SUB|EIG|ADJ:PRD).*").withDependent("nsubj(:pass)?|expl").andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noPos("VER.*").noDependents("aux(:pass)?"));
    private static final NodePattern possibleGenitiveCopula = copulaHead.form("Meinung|Ansicht|Auffassung|\u00dcberzeugung|Hoffnung|Glaubens|Mute?s|Laune|Abstammung|Ursprunge?s|Blute?s|Dauer|Datums|Alters|Teufels|Herrn|Schlage?s|Amte?s").withDependent("det.*|amod");
    private static final NodePattern nomCopulaArgument = copulaHead.noPos("ADJ:PRD.*").andNot(possibleGenitiveCopula).andNot(NodePattern.N.withDependent("amod", NodePattern.N.withDependent("advmod", NodePattern.N.form("voll"))).noDependents("det"));
    private static final NodePattern withArticle = NodePattern.N.withDependent("det", NodePattern.N.pos("ART.*"));
    private static final NodePattern animateSubstantivizedAdj = NodePattern.N.form("(abgeordnet|angestellt|auszubildend|jugendlich|lernend|obdachlos|prostituiert|studierend|verb\u00fcndet|verd\u00e4chtig|verr\u00fcckt|verurteilt|\u00fcberlebend)e[nrm]?").withHeadRelation("nsubj(:pass)?|ob[lj]|iobj|nmod");
    static final NodePattern substantivizedAdj = NodePattern.or(NodePattern.N.pos("SUB:.*ADJ").noPos("SUB.*(MAS|FEM|NEU|INF)").noForm("idealen?"), NodePattern.N.form("(wievielt|.+intolerant).+").withDependent("det|case"), animateSubstantivizedAdj).andNot(CommonPatterns.lowercasedHasPos("PRO:.*"));
    private static final NodePattern einPaarAkk = NodePattern.N.formCaseSensitive("paar").directlyAfter(NodePattern.N.form("einem")).withHead("det|nmod", NodePattern.N.noLemma("(.*)(schuh|socke|strumpf|stiefel|sandale|hose|auge|ohr|hand|faust|f\u00e4ustling|fu\u00df|brust|ohrring|handschelle)"));
    static final NodePattern bodyParts = NodePattern.N.lemma("Kopf|Gesicht|Rumpf|(Ober)?k\u00f6rper|Nacken|Hals|Brust|Hand(gelenk)?|Arm|R\u00fccken|Schulter|Knie|H\u00fcfte|(Vorder|Hinter)?Bein|Auge|Ohr|Nase|Mund|Finger|Zeh|Bauch|Fu(\u00df|ss)|Wirbels\u00e4ule|Ellbogen|(Ober|Unter)schenkel");
    private static final NodePattern vorbeugenDat = SpellingRules.noun.withHead("obj", NodePattern.N.lemma("vorbeugen")).andNot(bodyParts.noDependents("amod"));
    private static final NodePattern nounWithNummodBeforeHead = SpellingRules.noun.withDependent("nummod", NodePattern.N.directlyBeforeHead().andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u00a7"))));
    private static final NodePattern beforeCompoundEnd = NodePattern.N.directlyBefore(SpellingRules.noun.withHead("conj|nmod", NodePattern.N.alreadyMarkedAs("Head")));
    private static final NodePattern pairedHyphenatedThreeWordCompound = nounWithNummodBeforeHead.andOr(WordSeparation.withDependentsDetCaseAmod.andOr(NodePattern.N.markAs("Head").withDependent("conj", nounWithNummodBeforeHead.and(beforeCompoundEnd)), NodePattern.N.withDependent("conj", NodePattern.or(nounWithNummodBeforeHead.withDependent("flat", NodePattern.N.directlyAfterHead()), SpellingRules.noun.markAs("Head").withDependent("nmod", nounWithNummodBeforeHead.and(beforeCompoundEnd))))), SpellingRules.noun.withHead("conj", nounWithNummodBeforeHead.markAs("Head")).and(beforeCompoundEnd));
    private static final NodePattern singleHyphenatedThreeWordCompound = nounWithNummodBeforeHead.and(WordSeparation.withDependentsDetCaseAmod).withHead("compound", SpellingRules.noun).directlyBeforeHead();
    private static final NodePattern possessiveWithOmittedHead = NodePattern.N.pos("SUB:.*INF").markAs("Obj").directlyAfter(NodePattern.N.withHeadRelation("det.*").pos("PRO:POS.*").markAs("PossessiveElliptical")).withHead("conj|obj", NodePattern.N.pos("VER:INF:(SFT|NON)").directlyBefore(CommonPatterns.skipForward(CommonPatterns.comma, NodePattern.N.form("nicht"))).withDependent("obj", NodePattern.N.directlyBeforeHead().withDependent("det.*|amod", NodePattern.or(NodePattern.N.pos("PRO:POS.*"), NodePattern.N.lemma("eigen")).and((possessiveWithHead, match) -> {
        Node possessiveElliptical = match.getMarkedNode("PossessiveElliptical");
        if (AgreementSet.nodesHaveSameGenderNumber(possessiveWithHead, possessiveElliptical)) {
            return match;
        }
        return null;
    }))).noDependents(NodePattern.N.afterHead().andNot(NodePattern.N.alreadyMarkedAs("Obj")).andNot(NodePattern.PUNCT)));
    private static final NodePattern nonMain = NodePattern.or(misparsedClauseEllipsis, modifierEllipsis, foreignEmbedding, singleHyphenatedThreeWordCompound, pairedHyphenatedThreeWordCompound, NodePattern.N.withHead("obl", NodePattern.N.withDependent("obj", NodePattern.N.lemma("jen")).withDependent("acl")), CommonPatterns.possiblyConj(NodePattern.N.markAs("Obj").withHead("obj", NodePattern.N.withDependent("compound:prt", NodePattern.N.pos("PRP.*").before("Obj")))), NodePattern.N.withDependent("nummod|det", NodePattern.N.withDependent("advmod", NodePattern.N.directlyBeforeHead().inFormSequence(1, "in", "gesamt")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u00a7")))), NodePattern.N.inFormSequence(0, "Bitte|Danke", "sch\u00f6n").and(WordSeparation.withDependentsDetCaseAmod), NodePattern.not(Case.hasMisparsedFlatHeadDependent).withOnlyDependents(NodePattern.or(NodePattern.N.withHeadRelation("case|cc|det"), NodePattern.N.afterHead())).formCaseSensitive(".*\\p{Ll}\\p{Lu}.*"), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withHead("case|aux.*|expl", NodePattern.N)).and(CommonPatterns.touchHierarchy), beforeHyphen, CommonPatterns.possiblyConj(NodePattern.N.withHead(NodePattern.N.lemma("befinden").withDependent("nsubj.*", NodePattern.N.form("sic")))), NodePattern.N.form("(Mute|Bann)s").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("obl|nmod|root"))), NodePattern.N.directlyBefore(NodePattern.N.form("\\|")), SemanticRules.units.potentialPos("SUB:NOM:SIN:.*"), NodePattern.N.markAs("Word").withDependent("case", NodePattern.N.markAs("Case").directlyAfter(NodePattern.N.sameWordAs("Word").noDependents())).noDependents(NodePattern.not(NodePattern.N.alreadyMarkedAs("Case"))), NodePattern.N.withDependent("case", NodePattern.N.form("mit").withNextSibling(NodePattern.N.withHeadRelation("det.*").withNextSibling(NodePattern.N.pos(".*SUP.*")))), NodePattern.N.inFormSequence(1, "kein", ".*ball").withHead(NodePattern.N.lemma("spielen")), NodePattern.N.inFormSequence(2, "zum", "goldenen", "hirschen"), NodePattern.N.inFormSequence(0, "Heroic|H\u00e9ro\u00efc", "-", "Albums"), NodePattern.N.inFormSequence(2, "die|der", "deutschen?", "leasing"), NodePattern.N.inFormSequence(2, "die", "deutsche", "wohnen"), NodePattern.N.inFormSequence(2, "de", "morgansch.*", "gesetz(en?)?|regeln?"), NodePattern.N.inFormSequence(1, "(ei|['`\u00b4\u2019])?n", "paar"), NodePattern.N.inFormSequence(1, "so|immer", "weiter"), NodePattern.N.inFormSequence(2, "in", "beider", ".*").pos("SUB.*PLU.*"), NodePattern.N.inFormSequence(1, "von", "Rechts|wegen"), NodePattern.N.inFormSequence(0, "Wer", "wird", "Million(ae|\u00e4)r"), NodePattern.N.inFormSequence(0, "(Ae|\u00c4)rzte", "ohne", "Grenzen"), NodePattern.N.inFormSequence(1, "aller", "Anfang"), NodePattern.N.inFormSequence(2, "bei", "die", "Fische"), NodePattern.N.inFormSequence(0, "Art", "Nouveau"), NodePattern.N.inFormSequence(2, "\\d+", "-", "Fach(e.?)?"), NodePattern.N.inFormSequence(2, "wegen", "viel", ".*"), NodePattern.N.inFormSequence(2, "in", "mehrerer", "Hinsicht"), NodePattern.N.inFormSequence(2, "in", "aller", "Munde"), NodePattern.N.inFormSequence(2, "Code", "-", "Insight"), NodePattern.N.inFormSequence(0, "benzin", "und", "diesel.*"), NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nummod").withDependent("case"))), NodePattern.N.form(".*aufgaben").noPos(".*(NOM|AKK):PLU.*"), NodePattern.N.formCaseSensitive("Aufkommen").noPos(".*PLU.*"), NodePattern.N.formCaseSensitive("Nichts"), NodePattern.N.form("herze"), NodePattern.N.form("[234]D"), SpellingRules.unlikelyCafeKaffee, possessiveWithOmittedHead, NodePattern.N.withHeadRelation("obj").withPrevSibling(SpellingRules.zu.withHeadRelation("mark")), NodePattern.N.form("Email").noPos(".*FEM.*"), NodePattern.N.form("Demo").noPos(".*NEU.*"), NodePattern.N.form("Copilot").onlyPos(".*NOM.*"), NodePattern.N.form("(Recht|Senior|Grad|Indexe)s").noPos("SUB:.*:PLU:.*"), NodePattern.N.form("Kugeln").noPos("SUB:(NOM|AKK):PLU:FEM").message("Kugeln without Nom/Akk plural morphology"), NodePattern.N.lemma("API").noPos(".*NEU.*"), NodePattern.N.form("Graph").noPos(".*AKK:SIN:MAS.*"), NodePattern.N.form("Layers").noPos(".*PLU.*"), NodePattern.N.form("Silvester").onlyPos(".*MAS.*"), NodePattern.N.form("Top|Lauer"), NodePattern.N.form("Anspiel(en?)?|Ungarn?"), NodePattern.N.form(".+namen?").noDependents("amod|det(:poss)?"), NodePattern.N.form("beide[rmns]?").withDependent("det", NodePattern.N.lemma("all")), NodePattern.N.form("Variablen").message("Variablen"), NodePattern.N.form("(.*)gebaren|unwesen").onlyPos(".*SIN.*"), NodePattern.N.form("leasing").withDependent("amod", NodePattern.N.form("deutsche")), NodePattern.N.form("wetter").withDependent("amod", NodePattern.N.lemma("schlagend|b\u00f6se|giftig|frisch")), NodePattern.N.inFormSequence(0, "films?", "noirs?"), NodePattern.N.lemma("ad.*|marketing|web.*|design.*|app.*|ticket.*|layout.*|media.*|consult.*|blockchain.*|homepage.*|rock.*|metal.*|coach.*").withDependent("amod", NodePattern.N.form("mobile|responsive|progressive|native|agile")), NodePattern.N.withDependent("aux(:pass)?").noDependents("cop"), NodePattern.N.withDependent("flat", NodePattern.not(Case.misparsedFlatHead).noLabel("PERSON")).andOr(NodePattern.N.noDependents("conj"), GermanTreePatterns.englishWord), NodePattern.N.withDependent("flat|dep", NodePattern.N.noPos()), NodePattern.N.withDependent("case", NodePattern.N.form("mit").markAs("Mit")).inPhrase(NodePattern.N.lemma("helfen").before("Mit")), NodePattern.N.withDependent("det", NodePattern.N.withDependent("conj")).andNot(NodePattern.N.withDependent("case").withDependent("det", NodePattern.N.noLemma("(irgend)?ein").noDependents("conj", NodePattern.N.lemma("derselbe|mehrer|andere")))), NodePattern.N.withDependent("nummod", NodePattern.N.withDependent("conj")), NodePattern.N.withDependent("nummod", NodePattern.N.withDependent("advmod", NodePattern.N.pos("PRP.*"))), NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("nummod").form("1")).withDependent("amod"), CommonPatterns.possiblySkipDown("det|nummod|amod", CommonPatterns.beforeSlashOrParenth), NodePattern.N.withDependent("nummod", NodePattern.N.directlyAfter(NodePattern.N.form("\u00a7"))), NodePattern.N.directlyAfter(CommonPatterns.slash), NodePattern.N.directlyBefore(CommonPatterns.colon.noSpaceAfter()), NodePattern.N.pos("ADJ:PRD:KOM").directlyAfter(NodePattern.N.form("oder")), NodePattern.N.onlyPos("PRO:POS:.*"), NodePattern.N.pos("ART:IND.*"), NodePattern.N.pos(".*ABK.*"), CommonPatterns.capitalized.directlyAfter(NodePattern.N.form("das")).noPos("SUB:.*:SIN:NEU.*").andOr(CommonPatterns.lowercasedHasPos("VER.*INF.*"), NodePattern.N.form(".*[elr]n")), NodePattern.N.noDependents("det.*").withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.form("all(e.?)?"))), GermanTreePatterns.possiblyProperName.noLemma("Bild").andNot(vocative).andNot(NodePattern.N.label("PERSON").withOnlyDependents(NodePattern.N.withHeadRelation("conj|cc"))), allowedUninflectedNoun, NodePattern.N.pos("SUB.*ADJ").withDependent("det", NodePattern.N.lemma("alle")), NodePattern.N.withDependent("case").beforeHead().withHead("nmod", NodePattern.N.beforeHead().withHead("amod", NodePattern.N.pos("SUB.*"))), NodePattern.N.withDependent("case", NodePattern.or(NodePattern.N.withDependent("conj|case"), NodePattern.N.inFormSequence(2, "so", "was", "von"), NodePattern.N.inFormSequence(0, "bis", "zu"), NodePattern.N.inFormSequence(1, "es|das", "zu").withNeighbor(-1, NodePattern.N.withHead("obj", NodePattern.N.lemma("lassen"))), NodePattern.N.inFormSequence(2, "an", ".+er", "statt"), NodePattern.N.inFormSequence(0, "mit", ".*", ".*ste"), NodePattern.N.form("zu").directlyBefore(NodePattern.N.pos("ADJ:GEN.*SOL")))), wasFuer, ohneZu, substantivizedAdj.withDependent("amod").noDependents("det"), NodePattern.N.form(".*igen").and(node -> node.tree().treeSupport().tagToken(node.lowForm()).hasPos("ADJ.*")), NodePattern.N.withDependent("appos", NodePattern.or(CommonPatterns.withNumberLikeForm, NodePattern.N.withDependent("flat")).andNot(abbreviationVocative)), NodePattern.N.withDependent("appos", NodePattern.N.markAs("Appos")).withDependent("conj", NodePattern.N.before("Appos")), possibleMisparsedDetAsRelativeSubj, NodePattern.N.withDependent("amod", NodePattern.N.pos("SUB.*").noPos("(ADJ|PA).*").andNot(GermanTreePatterns.englishCompoundEmbeddingToHyphenate).noForm("riesen").andNot(CommonPatterns.lowercasedHasPos("(ADJ|PA).*"))), NodePattern.N.withHeadRelation("compound").withDependent("det|nummod"), NodePattern.N.withHeadRelation("dep").withDependent("nummod"), SpellingRules.noun.withDependent("appos", NodePattern.N.formCaseSensitive("[A-Z\u00c4\u00d6\u00dc]{2,}").directlyAfterHead()), NodePattern.N.withDependent("amod", NodePattern.N.form("Personalverantwortlichen?")), CommonPatterns.capitalizedMiddle.and(CommonPatterns.lowercasedHasPos("PRO.*")).withDependent("compound"), NodePattern.N.withHeadRelation("obj").directlyBefore(NodePattern.N.withHeadRelation("obj")), NodePattern.N.withHeadRelation("nmod").markAs("Nmod").withNextSibling(NodePattern.N.withHeadRelation("nmod").directlyAfter("Nmod")), NodePattern.N.withHeadRelation("iobj").withPhraseStart(NodePattern.N.withHeadRelation("det").form("des").directlyAfter(NodePattern.N.pos("SUB.*"))), NodePattern.N.withHead("nsubj.*", NodePattern.N.withDependent("csubj.*")), CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("\\+"))), CommonPatterns.severalDependents("det").noDependents("det", NodePattern.or(NodePattern.N.inFormSequence(1, "ein", "paar"), NodePattern.N.lemma("beid"), NodePattern.N.inFormSequence(0, "ein(e[mnsr]?)?", "ander(e[mnsr]?)?"), NodePattern.N.inFormSequence(0, "diese[mnsr]?", "eine[mnsr]?"))), NodePattern.N.withDependent("det(:poss)?", NodePattern.not(CommonPatterns.capitalized).noPos().noForm("paar").markAs("Det")).noDependents("det(:poss)?", NodePattern.not(NodePattern.N.alreadyMarkedAs("Det"))), NodePattern.N.withDependent("det(:poss)?|amod|case", NodePattern.N.form("\\p{L}+[^\\p{L}]+\\p{L}+").andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT.directlyAfterHead()))), NodePattern.N.withDependent("det", NodePattern.N.form("das").directlyAfter(NodePattern.N.withHeadRelation("aux|aux:pass|root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noPos("SUB.*").noDependents("mark", NodePattern.N.form("zu")).andOr(NodePattern.N.noPos(".*IMP.*"), GermanTreePatterns.firstInPhraseAfterCommasOrConj).and(CommonPatterns.skipUp("aux(:pass)?", NodePattern.N.noDependents("dep|expl|[cn]subj(:pass)?")).andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("expl|[cn]subj(:pass)?")))))), NodePattern.N.label(".*").andOr(NodePattern.N.withDependent("det", CommonPatterns.capitalizedMiddle.directlyAfter(CommonPatterns.letterWord).and(CommonPatterns.lowercasedHasPos("ART:DEF.*"))), NodePattern.N.withDependent("det", NodePattern.N.markAs("Det")).withDependent("punct", GermanTreePatterns.anyQuotation.after("Det"))), SemanticRules.personalToPersoenlich, WordSeparation.seitenlang, GermanTreePatterns.headInQuotes.andOr(NodePattern.ROOT, NodePattern.N.noDependents(NodePattern.not(CommonPatterns.insideQuotes)).noDependents("det(:poss)?"), NodePattern.N.onlyPos(".*PA[12].*").noPos(".*PRD.*").withDependent("amod"), NodePattern.or(CommonPatterns.capitalized.noPos(), NodePattern.N.onlyPos("SUB.*")).withOnlyDependents(NodePattern.or(NodePattern.PUNCT, NodePattern.not(CommonPatterns.insideQuotes).withHeadRelation("det(:poss)?|cc")))), NodePattern.N.markAs("Labelled").pos("(SUB|EIG).*").label(".+").noDependents(NodePattern.N.beforeHead()).directlyAfter(NodePattern.N.label(".+")).andNot(NodePattern.N.directlyAfterHead()).andNot(NodePattern.N.withPrevSibling(NodePattern.N.directlyBefore("Labelled"))).and(node -> node.nerLabel() == node.neighbor(-1).nerLabel()), NodePattern.N.onlyPos("ADJ:PRD:GRU").withDependent("det"), GermanTreePatterns.firstInPhraseAfterCommasOrConj.form("we[nm]").withHead(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")), SpellingRules.noun.withHead("obj", NodePattern.N.withHeadRelation("acl").noDependents("mark", SpellingRules.zu)).withDependent("det", CommonPatterns.firstChildPhrase.directlyBeforeHead().pos("ART:DEF.*").andNot(NodePattern.N.directlyAfter(CommonPatterns.firstChildPhrase.withHeadRelation("nsubj(:pass)?")))), CommonPatterns.firstChildPhrase.withDependent("det", NodePattern.N.form("das")).withHead(NodePattern.N.withHeadRelation("acl").noDependents("mark")), NodePattern.N.withHeadRelation("obj").withPhraseEnd(CommonPatterns.HYPHEN_LIKE_NODE).withNextSibling(NodePattern.N.withHeadRelation("obj")));
    private static final NodePattern ambiguousAdj = NodePattern.N.afterHead().andOr(NodePattern.N.withDependent("cc", NodePattern.N.form("sowohl")).withDependent("conj"), NodePattern.N.withHead("amod", NodePattern.N.form("alles|vieles|manches")));
    private static final NodePattern misparsedConjAdj = NodePattern.or(NodePattern.N.withHeadRelation("conj").onlyPos("SUB.*"), NodePattern.N.form(".+e").noForm("viele").withHead("amod", NodePattern.N.noDependents("det(:poss)?").onlyPos(".*SIN.*").withDependent("conj", CommonPatterns.closestDepToHead.noDependents("amod|det(:poss)?|case|compound"))), NodePattern.N.withDependent("det(:poss)?"), NodePattern.N.directlyAfter(NodePattern.N.onlyPos("SUB.*").markAs("Head")).pos(".*GEN.*").withHead(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Head"))).withDependent("conj", NodePattern.N.withDependent("cc")));
    private static final NodePattern numeral = NodePattern.N.withHeadRelation("nummod").andNot(inflectablePronoun);
    private static final NodePattern singularAdjPronounInEn = NodePattern.N.pos("PRO:IND:.*:SIN.*").andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.pos("ART:.*").withHeadRelation("det").withHead(NodePattern.N.onlyPos(".*(MAS|NEU).*").withDependent("case", AdjDeclination.anyFusedPreposition))).form(".*en");
    private static final NodePattern betweenDetAndNoun = NodePattern.N.withHead("advmod", NodePattern.N.onlyPos("SUB.*(MAS|FEM|NEU)")).directlyBeforeHead().withPrevSibling(NodePattern.N.withHeadRelation("det").pos(".*(DEF|DEM).*"));
    private static final NodePattern banOrMuteAdjectives = NodePattern.N.lemma("tempor\u00e4r|weltweit|streng|komplett|vor\u00fcbergehend|dauerhaft|politisch|(wirtschaft|staat)lich");
    private static final NodePattern nonAdj = NodePattern.or(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("det:poss")).pos("(SUB|EIG):GEN:SIN:MAS.*"), NodePattern.N.withHead("amod", CommonPatterns.severalDependents("amod").noDependents("det").withDependent("amod", NodePattern.N.form(".*em").markAs("FirstAmod")).noDependents("amod", NodePattern.N.before("FirstAmod"))), NodePattern.N.withHeadRelation("a(dv)?mod").withDependent("punct", CommonPatterns.colon.directlyAfterHead()), NodePattern.N.withHead("advmod", NodePattern.N.onlyPos(".*INF|VER.*")), NodePattern.N.withHeadRelation("advmod").noPos(), NodePattern.N.withHead("amod", NodePattern.N.onlyPos("(PRO|ART).*").noForm("man")), CommonPatterns.lowercasedHasPos("ADV.*").onlyPos("SUB.*").withHeadRelation("advmod"), NodePattern.N.withHeadRelation("advmod").markAs("MisparsedAmod").andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nmod").pos("PRO:.*"))).andNot(betweenDetAndNoun).andNot(NodePattern.N.withHead(NodePattern.N.pos("SUB.*").noDependents(NodePattern.not(NodePattern.N.alreadyMarkedAs("MisparsedAmod"))))).andNot(NodePattern.N.withHead(gruesse)), banOrMuteAdjectives.withHead("amod", NodePattern.N.form("(Mute|Bann)s").withHeadRelation("obj|root|nsubj.*")), NodePattern.N.form("gleich|einzig|kistenweise|weniger|erst|(ex|in)klusive").andNot(betweenDetAndNoun), NodePattern.N.form("besser|lieber").withHead("amod", NodePattern.N.noDependents("det(:poss)?").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("als")))), NodePattern.N.form("viele").withPrevSibling(NodePattern.or(NodePattern.N.withHeadRelation("det"), AdjDeclination.anyFusedPreposition.withHeadRelation("case"))).onlyPos(".*:B/S"), NodePattern.N.form("sp\u00e4ter").andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("det|case"))), NodePattern.N.inFormSequence(0, "halb|viertel", "eins|zw(ei|o|\u00f6lf)|drei|vier|f\u00fcnf|sechs|sieben|acht|neun|zehn|elf"), NodePattern.N.inFormSequence(0, "geistig|psychisch", "behinderte.*|gest\u00f6rte.*|kranke.*"), NodePattern.N.inFormSequence(1, "auf", "gut", "deutsch|gl\u00fcck"), NodePattern.N.inFormSequence(1, "mit", "ordentlich", "holz|kraft"), NodePattern.N.inFormSequence(1, "mit", "ausschlie(\u00df|ss)lich|doppelt|dreifach|zweifach"), NodePattern.N.inFormSequence(1, "vor", "lauter"), NodePattern.N.inFormSequence(1, "f\u00fcr", "lau"), NodePattern.N.inFormSequence(1, "als", ".*", "qualifiziert.*"), NodePattern.N.onlyPos("VER:.*"), NodePattern.N.withHeadRelation("amod").andOr(NodePattern.N.onlyPos("EIG.*"), NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)), NodePattern.N.pos("PRP.*").noPos("ADJ:PRD.*"), NodePattern.N.pos("ADV.*").withDependent("case", NodePattern.N.form("f(\u00fc|ue)r")).withHeadRelation("obl"), NodePattern.or(NodePattern.N.pos("ADJ:.*SUP.*"), NodePattern.N.form("meisten")).withDependent("advmod|case", NodePattern.N.form("am")), NodePattern.N.pos("ADJ:PRD.*").directlyBefore(NodePattern.N.withHeadRelation("amod")), NodePattern.N.pos("ADJ:PRD:KOM").withHead("amod", NodePattern.N.noDependents("case").afterHead().withHeadRelation("i?obj")), NodePattern.N.markAs("misplacedAdj").withHead("amod", NodePattern.N.withDependent("case", NodePattern.N.after("misplacedAdj"))), NodePattern.N.withHeadRelation("amod").withDependent("det"), NodePattern.N.withDependent("nummod", NodePattern.N.withDependent("punct", NodePattern.N.form("-"))), NodePattern.N.withHeadRelation("amod").withDependent("det(:poss)?|cop"), NodePattern.N.withHeadRelation("amod").withDependent("mark", NodePattern.N.form("zu").andNot(NodePattern.N.withPrevSibling(NodePattern.N))), CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("amod").form("ein(e.?)?")), beforeHyphen, NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("conj", CommonPatterns.closestDepToHead.withPhraseStart(CommonPatterns.HYPHEN_LIKE_NODE).afterHead()), NodePattern.N.form("beide").markAs("Beide").withHead("det", NodePattern.N.noDependents("det", NodePattern.not(NodePattern.N.alreadyMarkedAs("Beide")))));
    private static final NodePattern meaninglessAdjForm = NodePattern.N.pos("ADJ.*").form(".*en?");
    private static final NodePattern woPrep = NodePattern.N.form("mit|durch|f(ue|\u00fc)r|gegen|nach|zu|von|bei|vor").directlyAfter(NodePattern.N.form("wo"));
    private static final NodePattern withOrderNumeral = NodePattern.N.withDependent("amod|nummod", NodePattern.N.form("\\d+").noSpaceAfter().directlyBefore(NodePattern.N.form(".")));
    private static final NodePattern preferPlural = NodePattern.N.withDependent("det", NodePattern.N.lemma("manch"));
    private static final NodePattern fixablePredicativeAdj = NodePattern.or(NodePattern.N.pos("(PA2|ADJ):PRD.*"), NodePattern.N.form("viel").noDependents().withHead("amod", NodePattern.N.onlyPos(".*PLU.*")), CommonPatterns.lowercasedHasPos("(PA2|ADJ):PRD.*").noForm(".+e[smnr]?")).andNot(beforeHyphen).noForm("wenig").andNot(NodePattern.N.inFormSequence(1, "bis", "halb", "mittag|lunch|(mittags)?pause")).andOr(NodePattern.N.noForm("selbstst\u00e4ndig"), NodePattern.N.withHead(NodePattern.N.noPos("SUB:.*ADJ"))).beforeHead().markAs("Adj").andOr(NodePattern.N.withDependent("case", NodePattern.N.directlyBeforeHead()), NodePattern.N.form("lieb|geehrt").withHead(NodePattern.N.withDependent("flat|appos")), NodePattern.N.lemma("fantastisch").withHeadRelation("amod"), NodePattern.N.withHead("amod|advmod", NodePattern.or(NodePattern.N.withDependent("nmod", NodePattern.N.before("Adj").pos("PRO:IND.*")), NodePattern.N.withDependent("case|det.*", NodePattern.N.before("Adj")))), NodePattern.N.withDependent("advmod", NodePattern.N.directlyBeforeHead()).noDependents("punct"), CommonPatterns.firstToken.withHead("a(dv)?mod", NodePattern.or(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound"), NodePattern.ROOT.noDependents("cop"))).noPos("PRP.*"));
    private static final NodePattern pluralNumber = NodePattern.or(NodePattern.N.pos("ZAL"), CommonPatterns.withNumberLikeForm.andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT)).andNot(NodePattern.N.form("0.+").noDependents("nummod", NodePattern.N.beforeHead())).andNot(NodePattern.N.withHead(NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION"))).andNot(NodePattern.N.form("\\d{4,10}").markAs("MaybeZipCode").directlyBeforeHead().withHead(NodePattern.N.withPhraseStart(NodePattern.N.alreadyMarkedAs("MaybeZipCode")))), CommonPatterns.lowercasedHasPos("ZAL")).noForm("1|0|null").andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.PUNCT, CommonPatterns.dot.noSpaceBefore())));
    private static final String PLURAL_QUANTIFIER = "PluralQuantifier";
    private static final NodePattern sgNounGoingWithPluralNumerals = NodePattern.or(NodePattern.N.form("Prozent|Uhr|Mal|Paar|Fu(\u00df|ss)"), GermanDateChecker.monthName, SemanticRules.food.pos("SUB:NOM:SIN.*"));
    static final NodePattern detWithPlural = NodePattern.N.form("viele|etliche|einige|mehrere|zahlreiche");
    static final NodePattern lexicallyPlural = NodePattern.or(NodePattern.not(GermanTreePatterns.uncountableNoun).andOr(NodePattern.N.pos("SUB.*:PLU:.*").withDependent("amod|det", NodePattern.N.form("(viele|etliche|einige|mehrere|zahlreiche|meiste).?|mehr|weniger").markAs("PluralQuantifier")), NodePattern.N.pos("SUB.*:PLU:.*").withDependent("det", NodePattern.N.lemma("alle?").pos("PRO:(IND|DEM).*").markAs("PluralQuantifier").andNot(NodePattern.N.withHead(NodePattern.N.lemma("Regel|Hinsicht"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("(PRO|SUB).*PLU.*")))), NodePattern.N.pos(".*:SIN.*").andOr(NodePattern.N.withDependent("amod", detWithPlural.markAs("PluralQuantifier")).noDependents("det"), NodePattern.N.withDependent("det", detWithPlural.markAs("PluralQuantifier")).noForm(".+([hk]eit|ung)"))), NodePattern.N.withDependent("amod|det", NodePattern.N.lemma("beid").markAs("PluralQuantifier")).noDependents("conj"), NodePattern.N.withDependent("amod", NodePattern.N.lemma("verschieden").markAs("PluralQuantifier")).withDependent("det(:poss)?", NodePattern.N.noForm("ein.?|viel|wenig")), NodePattern.N.pos("SUB.*").andOr(NodePattern.N.noLabel(".*"), NodePattern.N.label("MISC")).withDependent("nummod", pluralNumber.beforeHead().markAs("PluralQuantifier")).andNot(CommonPatterns.severalDependents("nummod.*")), NodePattern.N.withHead("nmod", NodePattern.N.form("vielzahl|reihe|f\u00fclle").markAs("PluralQuantifier")).withDependent("case", NodePattern.N.form("von")), NodePattern.N.withDependent("det", NodePattern.N.inFormSequence(1, "ein", "paar").markAs("PluralQuantifier")), NodePattern.N.inFormSequence(2, "mit", "freundlich.*", "gr(\u00fc|ue)(\u00df|ss).*"), NodePattern.N.form("beide").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").noDependents(), NodePattern.N.inFormSequence(1, "Vereinigten?", "Staaten").label("GEO_POLITICAL_ENTITY"), NodePattern.N.withHeadRelation("nmod|obl").withDependent("case", NodePattern.N.form("zwischen").beforeHead()).withDependent("det(:poss)?|amod", NodePattern.N.noDependents("conj")).noDependents("conj").andOr(NodePattern.N.pos("SUB.*PLU.*"), NodePattern.N.pos("SUB.*SIN.*").withOnlyDependents(NodePattern.N.withHeadRelation("det(:poss)?|amod|case").noDependents("conj"))), Case.XXerJahre, NodePattern.N.withHead("nmod", NodePattern.N.form("meisten")).withDependent("case", NodePattern.N.form("von")));
    private static final NodePattern nmodConjAmbiguity = NodePattern.N.withDependent("nmod", CommonPatterns.possiblySkipDown("nmod", NodePattern.N.withDependent("conj", NodePattern.or(NodePattern.N.pos(".*NOM.*"), NodePattern.N.noPos()).andNot(GermanTreePatterns.possiblyProperName.withHead(GermanTreePatterns.possiblyProperName)))));
    private static final NodePattern millionMilliardeEtc = NodePattern.N.formSuffix("[mb]illion(en)?|[mb]illiarden?");
    private static final NodePattern nummodOnArgument = NodePattern.N.withHead(NodePattern.N.withHeadRelation("nsubj(:pass)?|ob[jl]|iobj")).andOr(NodePattern.N.withHeadRelation("nummod"), millionMilliardeEtc);
    private static final NodePattern declinedAppos = NodePattern.or(GermanDateChecker.dottedDateNode, GermanDateChecker.numDotMonth).withHeadRelation("appos").andNot(NodePattern.N.withDependent("det", NodePattern.N.form("den")).withHead("appos", NodePattern.N.withDependent("case", NodePattern.N.form("am"))));
    private static final NodePattern singularFiniteVerb = NodePattern.N.pos("VER.*").andNot(NodePattern.N.onlyPos(".*PA2.*")).noPos("VER.*3:PLU.*").noLabel(".*");
    private static final NodePattern incorrectConjSubjectAgreement = NodePattern.N.markAs("Subj").onlyPos("SUB.*").withDependent("conj", NodePattern.N.onlyPos("SUB.*").withDependent("cc", NodePattern.N.form("und")).noDependents("appos|nmod|advmod").markAs("Conj")).withHead("nsubj", NodePattern.or(NodePattern.N.withDependent("cop", NodePattern.N.onlyPos(".*SIN.*").after("Subj").markAs("Finite")), NodePattern.or(singularFiniteVerb.noDependents("cop|aux").after("Subj").markAs("Finite"), NodePattern.N.pos("SUB.*").withDependent("aux(:pass)?", singularFiniteVerb.after("Subj").markAs("Finite"))).and(NodePattern.markedNodeMatches("Subj", NodePattern.N.withDependent("det(:poss)?").and(NodePattern.markedNodeMatches("Conj", NodePattern.N.withDependent("det(:poss)?")))))).noDependents("conj", NodePattern.N.before("Finite").after("Subj")).noDependents("dep").andNot(CommonPatterns.severalDependents("[nc]subj"))).noDependents("appos|nmod").noDependents("punct", GermanTreePatterns.anyQuotation);
    private static final NodePattern misparsedPredicate = NodePattern.or(NodePattern.N.withDependent("expl|nsubj.*", NodePattern.or(expletiveSubj, NodePattern.N.withDependent("conj|nummod").andNot(incorrectConjSubjectAgreement).andNot(NodePattern.N.withDependent("cc", NodePattern.N.form("entweder"))), NodePattern.N.onlyPos(".*SIN.*").withDependent("amod", NodePattern.N.withDependent("conj")), NodePattern.N.withDependent("det", NodePattern.N.lemma("kein")), nmodConjAmbiguity, NodePattern.N.potentialPos("ZAL"), SemanticRules.group.andNot(NodePattern.N.withHead("nsubj", NodePattern.N.markAs("Pred").andOr(NodePattern.N.withDependent("conj", NodePattern.N.pos("VER:.*3:PLU.*")).and(NodePattern.markedNodeMatches("Pred", NodePattern.N.pos("VER:.*3:SIN.*"))), NodePattern.N.withDependent("conj", NodePattern.N.pos("VER:.*3:SIN.*")).and(NodePattern.markedNodeMatches("Pred", NodePattern.N.pos("VER:.*3:PLU.*")))))), NodePattern.N.withDependent("compound", SemanticRules.group.beforeHead()), NodePattern.N.withDependent("nmod", NodePattern.N.pos(".*:PLU.*").withDependent("case", NodePattern.N.form("von"))), Case.possibleSubjectObjectAmbiguity, NodePattern.N.onlyPos("SUB.*").markAs("MisparsedSubj").noDependents().withHead(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.PUNCT, NodePattern.N.alreadyMarkedAs("MisparsedSubj")))), NodePattern.N.withHead("nsubj:pass", NodePattern.N.pos(".*PA2.*").noDependents("cop|aux.*")), NodePattern.N.anyMatchUntil("FiniteVerb", GermanTreePatterns.anyQuotation), NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE), NodePattern.N.form(".*e").pos("SUB:.*:ADJ").noDependents("det"), CommonPatterns.capitalized.form(".*s").pos(".*NOM:PLU:.*").and(GermanTreePatterns.englishWord), NodePattern.N.form(".*a").lemma(".*um"), CommonPatterns.phraseStartsWithComma.and(CommonPatterns.phraseEndsWithComma))), CommonPatterns.severalDependents("csubj|nsubj.*"), NodePattern.N.inFormSequence(1, "das|es", "hei(\u00df|ss)t"), NodePattern.N.withDependent("cc", NodePattern.N.form("weder")).withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("noch"))), NodePattern.N.pos("PA2.*").withDependent("nsubj.*").withDependent("cop|aux.*").withDependent("conj", NodePattern.N.withDependent("nsubj.*").pos("PA2.*").noDependents("cop|aux.*")), NodePattern.N.withHeadRelation("xcomp|discourse"), NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE).noSpaceAfter(), NodePattern.N.directlyAfter(NodePattern.N.form("zu")).withDependent("nsubj(:pass)?").noDependents("cop|aux(:pass)?"), NodePattern.N.pos(".*(IMP:SIN|2:PLU:PR[\u00c4T]|[13]:SIN:(PR\u00c4|KJ2)).*").and(CommonPatterns.replacementProduces("(.+)", "$1e", "VER(:MOD)?:[13]:SIN:(PR\u00c4|KJ2).*")).withDependent("nsubj", NodePattern.N.form("ich")).noDependents("cop|aux(:pass)?"), NodePattern.N.withHeadRelation("aux(:pass)?|cop").withDependent("nsubj(:pass)?"));
    private static final NodePattern withModalAuxVerb = NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.pos("VER.*:[123]:.*"));
    private static final NodePattern noVerbAgreementCheck = NodePattern.N.markAs("FiniteVerb").andOr(misparsedPredicate, CommonPatterns.skipUp("cop|aux.*", NodePattern.N.withDependent("dep", NodePattern.or(NodePattern.N.pos("PRO:PER.*NOM.*").noPos("ART.*"), GermanTreePatterns.firstPlaceClauseConstituent.directlyBefore("FiniteVerb").withDependent("det(:poss)?").withHead(NodePattern.N.withDependent("nsubj(:pass)?"))))), CommonPatterns.skipUp("cop|aux.*", NodePattern.N.withDependent("nsubj", NodePattern.N.label("GEO_POLITICAL_ENTITY").noDependents("det"))), NodePattern.N.directlyAfter(NodePattern.N.form("zu").withHeadRelation("mark")), NodePattern.N.withHead("cop", NodePattern.N.pos("(SUB|EIG).*").andOr(NodePattern.N.onlyPos(".*PLU.*"), NodePattern.N.withDependent("flat|appos")).withDependent("nsubj", NodePattern.N.onlyPos(".*SIN.*"))), NodePattern.N.withHead("cop", NodePattern.N.withDependent("nsubj", NodePattern.N.label("MISC"))), CommonPatterns.skipUp("cop|aux.*", misparsedPredicate), NodePattern.N.withHead("cop", NodePattern.ROOT.noPos().noDependents("punct", GermanTreePatterns.anyQuotation).and(GermanTreePatterns.englishWord)), NodePattern.N.pos("PA2:PRD.*").andOr(NodePattern.N.withHeadRelation("acl").noDependents(NodePattern.N.pos("ART:DEF.*")), NodePattern.N.withDependent("conj", NodePattern.N.lemma("haben").noDependents("aux"))), NodePattern.N.pos("VER:.*PLU.*").withHead("cop", NodePattern.N.pos("SUB.*PLU.*").withDependent("nsubj", NodePattern.N.noPos("PRO:.*"))), NodePattern.N.inFormSequence(0, ".*t", "'"), NodePattern.N.form("m[\u00fcu]sst|wollt|k[\u00f6o]nnt").noPos("VER:MOD:[13]:SIN.*"), NodePattern.N.form("sehn").withDependent("nsubj", NodePattern.or(NodePattern.N.pos(".*PLU.*"), NodePattern.N.form("sie"))), NodePattern.N.pos("VER.*:INF.*").markAs("Conj").andOr(NodePattern.N.withHead("conj", NodePattern.ROOT.pos("VER:INF.*").and(withModalAuxVerb).andOr(NodePattern.N.noDependents("a(dv)?cl|ccomp"), NodePattern.N.withDependent("advcl").and(NodePattern.markedNodeMatches("Conj", CommonPatterns.lastWord)))), NodePattern.N.withHead("aux:pass", NodePattern.N.withHead("conj", NodePattern.ROOT.pos(".*PA2.*").and(withModalAuxVerb)))).afterHead(), NodePattern.N.pos("VER:INF.*").withHead("conj", NodePattern.N.withHeadRelation("xcomp").and(withModalAuxVerb)), NodePattern.N.withHead(NodePattern.N.withDependent("aux(:pass)?", NodePattern.not(NodePattern.N.alreadyMarkedAs("FiniteVerb")).noPos())), NodePattern.N.withHead("cop", NodePattern.N.pos("SUB.*INF")), CommonPatterns.skipUp("aux.*", NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("mit"))))).andNot(NodePattern.N.pos("VER:AUX.*").noHeadRelation("aux(:pass)?|cop")), Case.definitelyTransitive.withDependent("nsubj", NodePattern.N.pos(".*AKK.*").directlyAfterHead()).noDependents("aux(:pass)?|cop").pos(".*IMP.*"), NodePattern.N.withDependent("nsubj", NodePattern.or(dativePhrase, Case.esGehtArg, NodePattern.N.withDependent("mark"))), CommonPatterns.skipUp("aux(:pass)?|cop", NodePattern.N.withDependent("mark", NodePattern.or(GermanTreePatterns.whPhrase, NodePattern.N.form("wenn")).markAs("Mark"))).before("Mark"));
    private static final NodePattern hasHiddenConjDependent = NodePattern.N.withDependent("appos", NodePattern.N.label("PERSON").and(CommonPatterns.possiblySkipDown("appos", NodePattern.N.withDependent("conj"))));
    private static final NodePattern allowPluralAdjOnSingularNoun = NodePattern.or(NodePattern.N.withDependent("det(:poss)?").withDependent("conj").withDependent("amod", NodePattern.N.potentialPos(".*PLU.*")), sgNounGoingWithPluralNumerals.withDependent("nummod", pluralNumber));
    private static final NodePattern singularByDependentPossessive = NodePattern.N.pos(".*SIN.*").noDependents("det:poss", NodePattern.N.lemma("sein")).withDependent("conj", NodePattern.N.withDependent("det:poss", NodePattern.N.lemma("sein")).markAs("Conj")).noDependents(NodePattern.N.afterHead().andNot(NodePattern.N.alreadyMarkedAs("Conj")));
    private static final NodePattern singularByDependentNummod = NodePattern.or(NodePattern.N.withDependent("nummod", NodePattern.N.form("1|ein(e[mnsr]?)?").noDependents().markAs("NummodDep")).noDependents("nummod", NodePattern.not(NodePattern.N.alreadyMarkedAs("NummodDep"))).noDependents(NodePattern.N.withDependent("case", NodePattern.N.form("bis"))), NodePattern.or(NodePattern.N.withHeadRelation("nummod"), millionMilliardeEtc).andOr(NodePattern.N.withDependent("det", NodePattern.N.form("ein(e[mnsr]?)?")), NodePattern.N.withDependent("amod", NodePattern.N.form("halbe[mnrs]?"))), NodePattern.N.withDependent("amod", NodePattern.N.form("ein(e.?)?").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceBefore()))), NodePattern.N.lemma("Jahrhundert").withDependent("amod", NodePattern.N.form(".+zigsten?")));
    private static final NodePattern lexicallySingular = NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.lemma("jed")).noDependents("nummod"), NodePattern.N.lemma("jed"), SemanticRules.dayOfWeek.withDependent("case", NodePattern.N.form("ab|am|seit")), NodePattern.N.form("herzen").withDependent("amod", NodePattern.N.lemma("schwer")), singularByDependentNummod, singularByDependentPossessive, GermanTreePatterns.onlySingular, sgAccPhrase, ausDemVollen, sgPrepAccusativePhrase);
    private static final NodePattern allowGenInterpretationsOfProperNoun = CommonPatterns.capitalized.withDependent("appos", CommonPatterns.capitalized);
    private static final NodePattern aufGrund = NodePattern.N.inFormSequence(1, "auf", "Grund");
    static final NodePattern possibleGenitiveDependent = NodePattern.N.withHead("nmod", NodePattern.N.markAs("Head").andNot(NodePattern.N.withHeadRelation("flat"))).andOr(NodePattern.N.afterHead().withPhraseStart(NodePattern.or(NodePattern.N.withHeadRelation("det(:poss)?"), NodePattern.N.withHead("amod", NodePattern.not(CommonPatterns.severalDependents("amod"))).pos(".*GEN.*").noDependents()).directlyAfter(NodePattern.N.alreadyMarkedAs("Head"))).andNot(SemanticRules.timeUnit.pos("SUB:AKK:.*").noDependents("case").withDependent("det", NodePattern.N.pos(".*AKK.*"))), NodePattern.N.withPhraseStart(NodePattern.N.form("(d|[mdsk]?ein|ihr|uns|eu)e[rs]")), NodePattern.markedNodeMatches("Head", NodePattern.or(aufGrund, NodePattern.N.form("welche[rmns]?")))).withPhraseStart(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.pos("(SUB|PRO:(IND|RIN)|ZAL).*"), NodePattern.N.noPos()))).noDependents("case").andNot(NodePattern.N.withDependent("appos", NodePattern.N.label(".*"))).andNot(NodePattern.N.withDependent("det", NodePattern.N.lemma("all").directlyBefore(CommonPatterns.withNumberLikeForm))).andNot(NodePattern.N.inFormSequence(2, "aller", "\\d+", "Monate")).andNot(GermanDateChecker.monthName.withDependent("nummod", CommonPatterns.withNumberLikeForm)).andNot(alleXtimeUnit);
    private static final NodePattern onlyPlural = NodePattern.N.onlyPos(".*PLU.*");
    private static final String FEHLERHAFTE_BEUGUNG = "Fehlerhafte Beugung";
    private static final NodePattern looksLikeKJ1 = NodePattern.or(NodePattern.N.withDependent("conj", NodePattern.N.pos(".*3:SIN:KJ1.*")), NodePattern.N.withHead("conj", NodePattern.N.pos(".*3:SIN:KJ1.*")), NodePattern.N.form("sei(en)?"));
    private static final NodePattern welcheDerPlural = NodePattern.N.form("welche").withDependent("nmod", NodePattern.N.pos("SUB.*PLU:(MAS|NEU).*").withDependent("det", NodePattern.N.form("der")).noDependents("nummod").noDependents("det|amod", NodePattern.N.lemma("beid")));
    private static final NodePattern inPartitivePhrase = NodePattern.N.lemma("meist|einig|ein").withDependent("nmod", NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.form("der")), NodePattern.N.withDependent("case", NodePattern.N.form("von"))));
    private final Node main;
    private final Node det;
    private final List<Node> adjectives;
    private final List<Node> verbs;
    private final Map<Node, LinkedHashSet<InflectedForm>> node2Features;
    final FeatureRestriction<Case> possibleCases;
    private final Set<Gender> possibleGenders;
    @NotNull
    private final Person mainPerson;
    final Number numberRestriction;
    @Nullable
    final AdjDeclination adjDeclination;
    @Nullable
    private final Node prep;
    private final List<Node> relatives;
    private final List<Node> conj;
    private static final NodePattern predicativeSuperlativeAdj = NodePattern.N.onlyPos("ADJ.*SUP.*").withDependent("det", NodePattern.N.noForm("das")).withDependent("cop").withDependent("nsubj", NodePattern.N.pos("(SUB|EIG).*")).andNot(CommonPatterns.severalDependents("nsubj"));
    private static final NodePattern subjectOfSuperlative = NodePattern.N.withHead("nsubj", predicativeSuperlativeAdj);
    private static final NodePattern neutralPronoun = NodePattern.N.lemma("derselbe").andOr(NodePattern.N.withDependent("cop").withDependent("nsubj", NodePattern.N.form("das|es")).noDependents("acl"), NodePattern.N.withHeadRelation("nsubj"));
    private static final NodePattern masculineAmbiguous = NodePattern.or(NodePattern.N.lemma("wagen").andOr(NodePattern.N.withHead("obj|nsubj:pass", NodePattern.N.lemma("(an)?halten|bestellen|bewegen|blockieren|fahren|kaufen|nehmen|stehlen|steigen|stoppen|verlassen|ziehen")), NodePattern.N.withHead("nsubj", NodePattern.N.lemma("drehen|fahren|kehren|stoppen|halten"))), NodePattern.N.lemma(".*(abfang|abwehr|schutz)schild"), ausDemVollen);
    private static final NodePattern feminineAmbiguous = aufDieseWeise;
    private static final NodePattern neutralAmbiguous = NodePattern.or(NodePattern.N.lemma(".*(hinweis|namens|verkehrs|verbots|warn)schild"), NodePattern.N.lemma("Bild").noLabel(".+").noDependents("det(:poss)?", NodePattern.N.pos(".*SIN:FEM.*")));
    private static final NodePattern avoidDatInE = NodePattern.N.form(".+e").pos("SUB:DAT:SIN:(MAS|NEU)").pos(".*PLU.*").and(n -> n.form().equals(n.lemmaReadings().stream().findFirst().orElse("") + "e")).andOr(NodePattern.N.withHead("conj", NodePattern.N.onlyPos(".*PLU.*")), SemanticRules.dayOfWeek).noDependents("case", AdjDeclination.datFusedPreposition);
    private static final NodePattern dativeSgMNFormInE = NodePattern.N.form(".+e").pos(".*DAT:SIN:(MAS|NEU).*");
    private static final NodePattern formInE = NodePattern.N.form(".+e").and(node -> {
        if (node.lemmaReadings().isEmpty()) {
            return false;
        }
        String lemma = node.lemmaReadings().get(0);
        return node.form().equals(lemma + "e");
    });
    private static final NodePattern sgByDependentCop = NodePattern.N.onlyPos("SUB.*").noPos(".*NOG.*").withDependent("cop", NodePattern.N.onlyPos(".*SIN.*").beforeHead().markAs("Cop")).withDependent("det(:poss)?").noDependents("punct", CommonPatterns.HYPHEN_LIKE_NODE.after("Cop").beforeHead()).noDependents("case|appos|aux|conj|nummod").andNot(verbAgreementWithObjAfterCopula);
    private static final NodePattern ambiguousInfNoun = NodePattern.N.noDependents().noPos(".+SIN:(MAS|FEM|NEU)").pos(".+SIN:NEU:INF").pos(".+PLU:(MAS|FEM|NEU)").withHead("nsubj", NodePattern.or(NodePattern.N.pos(".*PLU.*").noPos(".*SIN.*").noDependents("aux(:pass)?|cop"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*PLU.*").noPos(".*SIN.*"))));
    private static final NodePattern shouldAgreeWithSgCopula = nomCopulaArgument.withDependent("nsubj", NodePattern.not(expletiveSubj).noDependents("conj|flat").noFormCaseSensitive("Sie").onlyPos(".*SIN.*")).withDependent("cop", NodePattern.N.pos("VER:AUX:[123].*SIN.*")).noDependents("case").noDependents("det|nmod", NodePattern.N.lemma("kein"));
    private static final NodePattern shouldAgreeWithPlCopula = NodePattern.N.withHeadRelation("nsubj").withDependent("cop", NodePattern.N.onlyPos(".*PLU.*"));
    private static final NodePattern withDependentAufGrund = NodePattern.N.withDependent("amod", NodePattern.N.withDependent("nmod", aufGrund));
    private static final NodePattern withDependentHalb = NodePattern.N.withDependent("amod", NodePattern.N.form("halb").markAs("Halb")).withDependent("det(:poss)?", NodePattern.N.after("Halb"));
    private static final NodePattern wieNmod = NodePattern.N.withDependent("case", NodePattern.N.form("wie")).andNot(CommonPatterns.severalDependents("case")).withHead("nmod", NodePattern.N.pos("SUB.*").withHeadRelation("nsubj(:pass)?|obj").noDependents("case"));
    private static final NodePattern wieObl = NodePattern.N.withDependent("case", NodePattern.N.form("wie")).andNot(CommonPatterns.severalDependents("case")).withHead("obl", NodePattern.N.withHeadRelation("root|ccomp").withDependent("obj", ReflexivePronouns.accReflexivPronomen));
    private static final NodePattern badConjVerb = NodePattern.or(NodePattern.N.pos(".*INF.*").noDependents("aux").withHead("conj", NodePattern.N.withHead("ccomp", NodePattern.N.pos(".*INF.*").withDependent("aux")).withDependent("mark")), NodePattern.N.noPos(".*KJ2.*").withHead("conj", NodePattern.N.pos(".*KJ2.*").withHeadRelation("ccomp")), NodePattern.N.form("sprich").withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.PUNCT)), NodePattern.N.withDependent("[nc]subj(:pass)?|expl"), NodePattern.N.noDependents("aux(:pass)?").withHead("conj", NodePattern.N.withDependent("aux(:pass)?")), NodePattern.N.withHead("conj", NodePattern.or(GermanTreePatterns.infinitive, NodePattern.N.form(".+[elr]n")).withDependent("aux", NodePattern.N.pos(".*KJ2.*"))), NodePattern.N.withHead(NodePattern.N.withDependent("csubj|xcomp")), NodePattern.N.form("gibt").withDependent("obj").noDependents("iobj"), NodePattern.N.form("geht").withDependent("iobj"), NodePattern.N.pos("SUB.*INF"), NodePattern.N.withDependent("aux:pass").withDependent("aux").withHead("conj", NodePattern.ROOT.noDependents("aux")), NodePattern.or(NodePattern.N.pos(".*PA2.*"), NodePattern.N.noDependents("cc")).withHead("conj", NodePattern.N.withDependent("aux(:pass)?|cop")), NodePattern.or(NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"), CommonPatterns.severalDependents("conj")).withHead("conj", NodePattern.N.withDependent("aux(:pass)?|cop")), NodePattern.N.withDependent("i?obj", NodePattern.N.noPos().noDependents()), NodePattern.N.withDependent("ccomp", NodePattern.N.noDependents("mark")), NodePattern.N.pos("VER:MOD.*|ADJ:PRD:GRU"), NodePattern.N.pos("VER:IMP.*").withDependent("cc").withDependent("conj", NodePattern.N.pos("VER:IMP.*").noDependents("cc")), NodePattern.N.markAs("Head").withDependent("obj", NodePattern.N.withDependent("appos", NodePattern.N.withDependent("obj").directlyBefore("Head"))), NodePattern.N.withDependent("advmod", NodePattern.N.pos("PRP.*")), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()), NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.noPos()), NodePattern.N.pos(".*INF.*").noDependents("aux(:pass)?|cop|nsubj(:pass)?|i?obj|obl|nmod|compound").markAs("Inf").withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("obl").withNextSibling(NodePattern.N.alreadyMarkedAs("Inf")))));
    private static final String relativeRelations = "ob[lj]|iobj|nsubj(:pass)?|nmod";
    private static final NodePattern relativeHeadCandidate = NodePattern.N.pos("(SUB|EIG|PRO:IND).*").andOr(NodePattern.N.afterHead(), NodePattern.N.after(NodePattern.N.withHeadRelation("aux(:pass)?|cop"))).before("RelativeClause");
    private static final NodePattern probablyMisparsedRelativeClause = NodePattern.or(NodePattern.N.withDependent("nsubj", CommonPatterns.firstChildPhrase.pos("PRO:DEM.*").directlyBefore(NodePattern.N.withHeadRelation("obj"))).withDependent("conj"), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").andOr(NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.noDependents("cop|aux(:pass)?")), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cop|aux(:pass)?")))));
    private static final NodePattern shouldLookForRelatives = NodePattern.not(CommonPatterns.severalDependents("acl")).andOr(NodePattern.N.withDependent("acl", NodePattern.not(probablyMisparsedRelativeClause).markAs("RelativeClause")), NodePattern.N.withHead(NodePattern.N.withDependent("acl", NodePattern.not(probablyMisparsedRelativeClause).markAs("RelativeClause")))).pos("(SUB|PRO:IND).*").noPos("VER.*").noLabel(".*").markAs("RelHead").andNot(CommonPatterns.upperCase.withDependent("compound", NodePattern.N.directlyBeforeHead())).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("ob[lj]|iobj|nsubj(:pass)?|nmod", relativeHeadCandidate.before("RelHead"))).noDependents("punct", NodePattern.N.beforeHead())).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("ob[lj]|iobj|nsubj(:pass)?|nmod", relativeHeadCandidate.after("RelHead")))).andNot(NodePattern.N.inFormSequence(1, "zum", "einen")).andOr(NodePattern.ROOT, NodePattern.N.withHead("ob[lj]|iobj|nsubj(:pass)?", NodePattern.not(NodePattern.N.withHead(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("csubj")))))).noDependents("nmod|conj|ccomp|appos|flat|compound|advmod", NodePattern.N.afterHead());
    static final NodePattern misparsedRelHead = NodePattern.N.markAs("MisparsedRelHead").withHead(NodePattern.N.pos("VER.*").noDependents("xcomp").noDependents("advmod", NodePattern.N.withDependent("ob[lj]|iobj|nsubj(:pass)?|nmod")).noDependents("ob[lj]|iobj|nsubj(:pass)?|nmod", NodePattern.not(NodePattern.N.alreadyMarkedAs("MisparsedRelHead")).andOr(NodePattern.N.onlyPos("(SUB|EIG).*"), NodePattern.N.pos("PRO:IND.*"), NodePattern.N.noPos(), NodePattern.N.withDependent("nmod")))).noDependents("nmod|conj|ccomp|flat|compound|appos|advmod", NodePattern.N.afterHead());
    private static final NodePattern acceptableMainWithoutFeatures = CommonPatterns.letterWord.withDependent("det(:poss)?").withDependent("amod").andNot(CommonPatterns.upperCase).andNot(NodePattern.not(CommonPatterns.capitalized).noPos().and(CommonPatterns.capitalizedHasPos(".*")));
    static final NodePattern agreementIssues = NodePattern.custom(node -> {
        AgreementSet set = AgreementSet.createRelaxed(node);
        return set != null && (set.hasGovernmentIssue() || set.hasAgreementIssue());
    });
    private static final NodePattern headInQuotesNoDet = GermanTreePatterns.headInQuotes.noDependents("det(:poss)?");
    private static final NodePattern redundantInfMorpho = NodePattern.N.pos("SUB.*(MAS|FEM|PLU:NEU)").pos(".*NEU:INF").noPos(".*SIN:NEU");
    private static final NodePattern concatenationCandidateNoun = NodePattern.N.pos("SUB.*").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root|xcomp"))).directlyAfter(NodePattern.N.withHeadRelation("amod|case").and(CommonPatterns.lowercasedHasPos("(ADJ|PA2):PRD:GRU(:VER)?")).andNot(NodePattern.N.form("gro\u00df").label("EVENT").directlyBefore(NodePattern.N.form("Krieg").label("EVENT"))).noForm("sch\u00f6n|super|.*bar|.*end|gleich").noDependents("advmod|compound")).andNot(SemanticRules.humanLike).andNot(GermanTreePatterns.grobVorstellung.andNot(NodePattern.N.withDependent("nmod"))).andNot(GermanTreePatterns.lemmaAfterForm("Arbeit", "neu").withDependent("det(:poss)?|case")).andNot(GermanTreePatterns.freiTag.and(CommonPatterns.capitalized)).andNot(GermanTreePatterns.grossRolle).andNot(GermanTreePatterns.positivProzess.andOr(NodePattern.N.withDependent("det", NodePattern.N.pos("ART:IND.*")), NodePattern.N.pos(".*PLU.*")));
    private static final Set<String> hardcodedConcatenations = Set.of("Paralleluniversum", "Rohzustand", "Gro\u00dfabnehmer", "Alternativmedizin");
    static final WordSet prohibitedCompounds = WordSet.loadResource("de/prohibited_compounds.txt");
    static final NodePattern looksLikeArchaicDatSg = NodePattern.N.form(".+e").pos("SUB:DAT:SIN:(MAS|NEU)").and(node -> {
        String form = node.lowForm();
        return node.lemmaReadings().stream().noneMatch(lemma -> lemma.toLowerCase(Locale.ROOT).equals(form));
    });

    private static boolean nodesHaveSameGenderNumber(Node n1, Node n2) {
        for (Number number : Number.values()) {
            for (Gender gender : Gender.values()) {
                String pattern = ".*" + String.valueOf((Object)number) + ":" + String.valueOf((Object)gender) + ".*";
                if (!n1.hasPos(pattern) || !n2.hasPos(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    private AgreementSet(Node main, @Nullable Node det, List<Node> adjectives, List<Node> verbs, @Nullable Node prep, List<Node> relatives, List<Node> conj, Map<Node, LinkedHashSet<InflectedForm>> node2Features, @Nullable FeatureRestriction<Case> possibleCases, @Nullable AdjDeclination declination) {
        this.main = main;
        this.det = det;
        this.adjectives = adjectives;
        this.verbs = verbs;
        this.prep = prep;
        this.relatives = relatives;
        this.conj = conj;
        this.node2Features = node2Features;
        this.adjDeclination = declination;
        this.possibleCases = possibleCases;
        this.possibleGenders = this.calcPossibleGenders();
        Person singlePerson = (Person)((Object)FeatureUtil.singleOrNull(((StreamEx)StreamEx.of(this.mainFeatures()).map(f -> f.person).filter(Objects::nonNull)).toSet()));
        this.mainPerson = singlePerson != null ? singlePerson : Person.P3;
        this.numberRestriction = this.calcNumberRestriction();
    }

    private LinkedHashSet<InflectedForm> mainFeatures() {
        return this.node2Features.getOrDefault(this.main, new LinkedHashSet(List.of()));
    }

    Set<Gender> calcPossibleGenders() {
        if (this.main.lowForm().equals("etwas") || neutralPronoun.matches(this.main) || neutralAmbiguous.matches(this.main)) {
            return Set.of(Gender.NEU);
        }
        if (feminineAmbiguous.matches(this.main)) {
            return Set.of(Gender.FEM);
        }
        if (masculineAmbiguous.matches(this.main)) {
            return Set.of(Gender.MAS);
        }
        Node subjOfPredicative = predicativeSuperlativeAdj.matches(this.main) ? this.main.findSingleDependent("nsubj") : null;
        StreamEx features = subjOfPredicative != null ? StreamEx.of(InflectedForm.fromNode(subjOfPredicative, null, this.verbs, this.prep)) : StreamEx.of(this.mainFeatures());
        return ((StreamEx)features.map(f -> f.gender).filter(Objects::nonNull)).toSet();
    }

    @Nullable
    private Number calcNumberRestriction() {
        if (predicativeSuperlativeAdj.matches(this.main)) {
            Node nsubj = this.main.findSingleDependent("nsubj");
            return onlyPlural.matches(nsubj) ? Number.PLU : Number.SIN;
        }
        if (subjectOfSuperlative.matches(this.main)) {
            return onlyPlural.matches(this.main) ? Number.PLU : Number.SIN;
        }
        if (welcheDerPlural.matches(this.main) || inPartitivePhrase.matches(this.main)) {
            return Number.PLU;
        }
        if (ambiguousNumberPronoun.matches(this.main) || sgWithNummodAllowed.matches(this.main) || SemanticRules.currencyName.matches(this.main) && this.main.hasDependent("nummod")) {
            return null;
        }
        if (lexicallySingular.matches(this.main) || GermanDateChecker.monthName.matches(this.main) || sgByDependentCop.matches(this.main)) {
            return Number.SIN;
        }
        if (lexicallyPlural.matches(this.main)) {
            return sgNounGoingWithPluralNumerals.matches(this.main) ? null : Number.PLU;
        }
        if (InflectedForm.zimmernNotActivity.matches(this.main) || pluralVocative.matches(this.main) || shouldAgreeWithPlCopula.matches(this.main)) {
            return Number.PLU;
        }
        if (incorrectConjSubjectAgreement.matches(this.main) && !this.verbs.isEmpty()) {
            return Number.PLU;
        }
        Number mainNumber = AgreementSet.singleNumber((StreamEx<InflectedForm>)((StreamEx)StreamEx.of(this.mainFeatures()).filter(f -> f.matchesCase(this.possibleCases.allowed()))));
        if (!(this.node2Features.containsKey(this.det) || !this.verbs.isEmpty() || mainNumber == Number.SIN && formInE.matches(this.main))) {
            return mainNumber;
        }
        if (singularOnlyDependent.matches(this.main)) {
            return Number.SIN;
        }
        if (ambiguousInfNoun.matches(this.main)) {
            return Number.PLU;
        }
        if (shouldAgreeWithSgCopula.matches(this.main)) {
            return Number.SIN;
        }
        return AgreementSet.singleNumber((StreamEx<InflectedForm>)StreamEx.of((Object)this.det).append((Object)(mainNumber == null ? null : this.main)).append(this.verbs).flatCollection(n -> this.node2Features.getOrDefault(n, new LinkedHashSet())));
    }

    @Nullable
    private static Number singleNumber(StreamEx<InflectedForm> forms) {
        return (Number)((Object)FeatureUtil.singleOrNull(((StreamEx)forms.map(f -> f.number).filter(Objects::nonNull)).toSet()));
    }

    public String toString() {
        return "AgreementSet{main=" + String.valueOf(this.main) + "}";
    }

    @NotNull
    static FeatureRestriction<Case> calcPossibleCases(Node node) {
        Node head;
        FeatureRestriction<Case> fromHead;
        Node reason = Objects.requireNonNullElse(node.head(), node);
        if (wieNmod.matches(node)) {
            return FeatureRestriction.restricted((Node)reason, (Enum[])new Case[]{Case.NOM, Case.AKK});
        }
        if (wieObl.matches(node)) {
            return FeatureRestriction.restricted((Node)reason, (Enum[])new Case[]{Case.NOM});
        }
        Node prep = GermanTreePatterns.findPreposition(node);
        if (prep != null && !prepAccusativePhrase.matches(node) && !dativePhrase.matches(node)) {
            return Case.calcPrepositionCases(prep, node);
        }
        if (!conjAttachmentAmbiguity.matches(node) && (AdjDeclination.featureSharingConj.matches(node) || declinedAppos.matches(node) || nummodOnArgument.matches(node)) && (fromHead = AgreementSet.calcConjHeadCases(head = Objects.requireNonNull(node.head()))).isRestricted()) {
            LinkedHashSet<Case> cases = new LinkedHashSet<Case>(fromHead.allowed());
            for (Node nmod : head.findDependents("nmod")) {
                Node anotherPrep;
                if (!nmod.isAfter(head) || !nmod.isBefore(node) || (anotherPrep = GermanTreePatterns.findPreposition(nmod)) == null) continue;
                cases.addAll(Case.calcPrepositionCases(anotherPrep, node).allowed());
            }
            return fromHead.derive(cases);
        }
        if (possibleGenitiveDependent.matches(node) || withDependentAufGrund.matches(node) || withDependentHalb.matches(node)) {
            return FeatureRestriction.restricted((Node)reason, (Enum[])new Case[]{Case.GEN});
        }
        if (dativePhrase.matches(node) || vorbeugenDat.matches(node)) {
            return FeatureRestriction.restricted((Node)reason, (Enum[])new Case[]{Case.DAT});
        }
        if (timeUnit.matches(node) || accusativePhrase.matches(node) || einPaarAkk.matches(node)) {
            return FeatureRestriction.restricted((Node)reason, (Enum[])new Case[]{Case.AKK});
        }
        if (vocative.matches(node) || pluralVocative.matches(node) || nomCopulaArgument.matches(node) || predicativeSuperlativeAdj.matches(node)) {
            return FeatureRestriction.restricted((Node)node, (Enum[])new Case[]{Case.NOM});
        }
        return Case.calcDirectArgumentCases(node);
    }

    @NotNull
    private static FeatureRestriction<Case> calcConjHeadCases(Node head) {
        Set actualCases;
        FeatureRestriction<Case> fromHead = AgreementSet.calcPossibleCases(head);
        LinkedHashSet<Case> headRestrictions = new LinkedHashSet<Case>(fromHead.allowed());
        AgreementSet headSet = AgreementSet.create(head);
        if (headSet != null && !(actualCases = ((StreamEx)StreamEx.of(headSet.commonFeatures(headRestrictions)).map(f -> f.caze).filter(Objects::nonNull)).toSet()).isEmpty()) {
            headRestrictions.retainAll(actualCases);
        }
        return fromHead.isRestricted() ? fromHead.derive(headRestrictions) : new FeatureRestriction<Case>("Der Kontext", headRestrictions);
    }

    Set<Case> possibleCasesRestrictedByArticle() {
        LinkedHashSet<Case> result = new LinkedHashSet<Case>(this.possibleCases.allowed());
        Node caseHolder = this.det != null ? this.det : (AdjDeclination.anyFusedPreposition.matches(this.prep) ? this.prep : null);
        LinkedHashSet<InflectedForm> caseFeatures = this.node2Features.get(caseHolder);
        if (caseFeatures != null) {
            result.retainAll(StreamEx.of(caseFeatures).map(f -> f.caze).nonNull().toSet());
        }
        return result;
    }

    @Nullable
    static AgreementSet create(Node main) {
        return nonMain.matches(main) || nonAdj.matches(main) ? null : AgreementSet.createRelaxed(main);
    }

    static List<Node> findAllConjVerbs(Node verb) {
        ArrayList<Node> result = new ArrayList<Node>();
        Node conjHead = NodePattern.N.withHeadRelation("aux(:pass)?|cop").matches(verb) ? Objects.requireNonNull(verb.head()) : verb;
        List<Node> conjDependents = conjHead.findDependents("conj");
        for (Node conj : conjDependents) {
            Node finiteVerb;
            if (badConjVerb.matches(conj) || (finiteVerb = Case.findFiniteVerb(conj)) == null) break;
            result.add(finiteVerb);
            result.addAll(AgreementSet.findAllConjVerbs(finiteVerb));
        }
        return result;
    }

    private static Node findRelativePronoun(Node relHead) {
        Node firstChild = relHead.allDependents().stream().filter(NodePattern.not(NodePattern.PUNCT)::matches).findFirst().orElse(null);
        return NodePattern.N.pos("ART:DEF.*").noHeadRelation("de[pt]|mark").matches(firstChild) ? firstChild : null;
    }

    @Nullable
    static AgreementSet createRelaxed(@NotNull Node main) {
        Node verb;
        Node flat;
        Node compound;
        Node mainInTree;
        if (misparsedCaseCombination.matches(main) || Case.hasMisparsedFlatHeadDependent.matches(main)) {
            return null;
        }
        Node node = mainInTree = Case.misparsedFlatHead.matches(main) && !nonMain.matches(main.head()) && !nonAdj.matches(main.head()) ? main.head() : main;
        if (mainInTree == null) {
            return null;
        }
        Node det = AdjDeclination.findOwnDet(mainInTree);
        Node prep = GermanTreePatterns.findPreposition(mainInTree);
        List adjectives = ((StreamEx)StreamEx.of(mainInTree.findDependentsWithConj("advmod|amod|nummod|case|det(:poss)?")).filter(a -> (det == null || a.isAfter(det)) && (prep == null || a.isAfter(prep)) && a.isBefore(mainInTree) && (!a.hasHeadRelation("det(:poss)?") || det == null && AdjDeclination.adjDetAmbiguity.matches((Node)a) || det != null && a != det) && !nonAdj.matches((Node)a) && !ambiguousAdj.matches((Node)a) && !numeral.matches((Node)a) && !misparsedConjAdj.matches((Node)a) && CommonPatterns.letterWord.matches((Node)a))).toMutableList();
        List<Node> conj = mainInTree.findDependents("conj");
        List<Node> relatives = new ArrayList();
        if (shouldLookForRelatives.matches(mainInTree)) {
            List<Node> acls = mainInTree.findDependents("acl");
            if (acls.isEmpty() && misparsedRelHead.matches(mainInTree)) {
                acls = Objects.requireNonNull(mainInTree.head()).findDependents("acl");
            }
            relatives = ((StreamEx)((StreamEx)StreamEx.of(acls).filter(r -> r.isAfter(mainInTree))).map(r -> AgreementSet.findRelativePronoun(r)).filter(Objects::nonNull)).toMutableList();
        }
        if ((compound = mainInTree.findSingleDependent("compound")) != null && compound.isBefore(mainInTree) && (flat = compound.findSingleDependent("flat")) != null && flat.hasPos("ADJ.*")) {
            adjectives.add(flat);
        }
        ArrayList<Node> verbs = new ArrayList<Node>();
        if (mainInTree.hasHeadRelation("nsubj.*") || Case.possiblyMisshapedSubject.matches(mainInTree)) {
            Node node2 = verb = mainInTree.hasDependent("cop") ? Case.findFiniteVerb(mainInTree) : Case.findFiniteVerb(Objects.requireNonNull(mainInTree.head()));
            if (!(verb == null || noVerbAgreementCheck.matches(verb) || possiblyIncorrectSubj.matches(mainInTree) || hasHiddenConjDependent.matches(mainInTree))) {
                verbs.add(verb);
            }
        } else {
            verb = mainInTree.findSingleDependent("cop");
            if (verb != null && verbAgreementWithObjAfterCopula.matches(mainInTree)) {
                verbs.add(verb);
            }
        }
        if (!(verbs.isEmpty() || verb.hasDependent("xcomp|ccomp|csubj|a(dv)?cl|parataxis") || verb.hasPos("VER:MOD.*"))) {
            verbs.addAll(AgreementSet.findAllConjVerbs(verb));
        }
        for (Node relative : relatives) {
            AgreementSet relSet = AgreementSet.create(relative);
            if (relSet == null) continue;
            verbs.addAll(relSet.verbs);
        }
        LinkedHashMap<Node, LinkedHashSet<InflectedForm>> node2Features = new LinkedHashMap<Node, LinkedHashSet<InflectedForm>>();
        for (Node node3 : ((StreamEx)StreamEx.of((Object[])new Node[]{main, det}).append((Collection)adjectives).append(verbs).append((Object)prep).append(relatives).filter(Objects::nonNull)).toList()) {
            List<InflectedForm> features = InflectedForm.fromNode(node3, det, verbs, prep);
            if (features.isEmpty()) {
                if (node3 != main || acceptableMainWithoutFeatures.matches(node3)) continue;
                return null;
            }
            node2Features.put(node3, new LinkedHashSet<InflectedForm>(features));
        }
        return new AgreementSet(main, det, adjectives, verbs, prep, relatives, conj, node2Features, AgreementSet.calcPossibleCases(mainInTree), AdjDeclination.fromNPHead(mainInTree));
    }

    @Nullable
    AgreementSet withMain(Node anotherMain) {
        if (nonMain.matches(anotherMain)) {
            return null;
        }
        LinkedHashMap<Node, LinkedHashSet<InflectedForm>> node2Features = new LinkedHashMap<Node, LinkedHashSet<InflectedForm>>(this.node2Features);
        List<InflectedForm> features = InflectedForm.fromNode(anotherMain, this.det, this.verbs, this.prep);
        if (features.isEmpty()) {
            return null;
        }
        node2Features.remove(this.main);
        node2Features.put(anotherMain, new LinkedHashSet<InflectedForm>(features));
        return new AgreementSet(anotherMain, this.det, this.adjectives, this.verbs, this.prep, this.relatives, this.conj, node2Features, this.possibleCases, this.adjDeclination);
    }

    private static NodeMatch suggestConcatenation(NodeMatch match, Node prevNode, Node main) {
        String concat;
        boolean sorglosPaket;
        TreeSupport support = main.tree().treeSupport();
        boolean primaerMinister = prevNode.hasForm("prim\u00e4r") && main.hasLemma("Minister");
        boolean bl = sorglosPaket = prevNode.hasForm("sorglos") && main.hasLemma("Paket");
        if (prevNode.hasForm("schwarzwei(\u00df|ss)")) {
            String ss = prevNode.lowForm().substring("schwarzwei".length());
            match = match.withCorrector(NodeCorrector.replaceNodes(prevNode, main, "Schwarz-Wei" + ss + "-" + StringTools.uppercaseFirstChar((String)main.form())));
        }
        String string = primaerMinister ? "Premierminister" : (concat = sorglosPaket ? "Rundum-sorglos-Paket" : StringTools.uppercaseFirstChar((String)(prevNode.form() + main.lowForm())));
        if (support.isAcceptedBySpellchecker(concat) && !prohibitedCompounds.contains(concat) || hardcodedConcatenations.contains(concat)) {
            match = match.withCorrector(NodeCorrector.replaceNodes(prevNode, main, concat));
        }
        return match;
    }

    static NodePattern agreementApposition() {
        return NodePattern.N.inFormSequence(0, "ein", "der").and(CommonPatterns.reportWithPrevWord).afterHead().withHead("appos", NodePattern.N.withHeadRelation("nsubj").includeIntoReport()).withNeighbor(2, NodePattern.N.withHeadRelation("amod").pos("(PA2:GEN:PLU|ADJ:GEN:PLU.*SUP).*")).withDependent("nmod", NodePattern.N.pos("SUB:GEN:PLU.*").markAs("Nmod").includeIntoReport().withOptionalDependent("nmod", NodePattern.N.afterHead().markAs("SecondNmod"))).message("Unpassender Artikel am \u201e$Nmod\u201c im Genitiv?").and((node, match) -> {
            Node nmod = match.getMarkedNode("Nmod");
            Node secondNmod = match.findMarkedNode("SecondNmod");
            AgreementSet headSet = AgreementSet.create(nmod);
            if (headSet == null) {
                return null;
            }
            List<String> einInGenitive = node.tree().treeSupport().inflectNode(node, "ART:IND.*", "ART:IND:GEN:SIN:" + String.valueOf((Object)StyleRules.pickGender(nmod)));
            if (einInGenitive.isEmpty()) {
                return null;
            }
            NodeCorrector toGenitiveFormAddComma = NodeCorrector.replace(node, ", " + einInGenitive.get(0));
            Node mod = secondNmod != null ? secondNmod : nmod;
            match = mod.nextNode() == null || mod.nextNode().hasHeadRelation("punct") ? match.withCorrector(toGenitiveFormAddComma) : match.withCorrector(toGenitiveFormAddComma.join(NodeCorrector.insertAfter(mod, ",")));
            return match;
        });
    }

    @Nullable
    NodeMatch check(NodeMatch match) {
        boolean governmentIssue = this.hasGovernmentIssue() && (!incorrectConjSubjectAgreement.matches(this.main) || this.verbs.isEmpty());
        boolean agreementIssue = this.hasAgreementIssue();
        if (governmentIssue || agreementIssue) {
            HashSet<Node> allReported = new HashSet<Node>();
            List<InflectedForm> toTry = this.possibleInflections(governmentIssue);
            if (redundantInfMorpho.matches(this.main)) {
                toTry = toTry.stream().filter(form -> form.gender == null || !form.gender.equals((Object)Gender.NEU) || !form.number.equals((Object)Number.SIN)).toList();
            }
            if (agreementIssue) {
                Node prevNode = this.main.prevNode();
                if (concatenationCandidateNoun.matches(this.main) && prevNode != null) {
                    match = AgreementSet.suggestConcatenation(match, prevNode, this.main);
                }
            }
            for (InflectedForm form2 : toTry) {
                Map<Node, NodeCorrector> correctors = this.imposeFeatures(form2, true);
                allReported.addAll(correctors.keySet());
                match = match.withCorrector(NodeCorrector.joinAll(correctors.values())).withReportedNodes(correctors.keySet());
            }
            if (headInQuotesNoDet.matches(this.main)) {
                if (allReported.stream().noneMatch(NodePattern.not(CommonPatterns.insideQuotes)::matches)) {
                    return null;
                }
            }
            if (woPrep.matches(this.prep) && !this.commonFeatures(EnumSet.allOf(Case.class)).isEmpty()) {
                match = match.withCorrector(NodeCorrector.replaceNodes(this.prep.neighbor(-1), this.prep, "wo" + this.prep.lowForm())).withReportedNodes(this.prep);
            }
            if (AdjDeclination.featureSharingConj.matches(this.main)) {
                match = match.withTouchedNode(this.main.head());
            }
            return match.withTouchedNodes(this.node2Features.keySet()).withMessage(governmentIssue ? this.governmentMessage() : this.agreementMessage(allReported, toTry));
        }
        return null;
    }

    boolean hasAgreementIssue() {
        return this.commonFeatures(this.possibleCases.allowed()).isEmpty();
    }

    boolean hasGovernmentIssue() {
        return EntryStream.of(this.node2Features).allMatch((n, s) -> n != this.main && meaninglessAdjForm.matches((Node)n) || this.filterByContext((Collection<InflectedForm>)s, this.possibleCases.allowed()).isEmpty());
    }

    private String governmentMessage() {
        NodeMatch match = lexicallyPlural.match(this.main);
        if (match != null && this.node2Features.containsKey(this.main) && this.node2Features.get(this.main).stream().allMatch(f -> f.number == Number.SIN)) {
            Node reason = match.findMarkedNode(PLURAL_QUANTIFIER);
            return (reason != null ? reason.quotedPresentableText() : "Der Kontext") + " erfordert Plural";
        }
        if (!this.possibleCases.isRestricted()) {
            return FEHLERHAFTE_BEUGUNG;
        }
        return this.possibleCases.reason() + " erfordert " + MessageUtil.coordinate(StreamEx.of(this.possibleCases.allowed()).map(c -> c.presentable).toList(), " oder ", " oder ");
    }

    private String agreementMessage(Set<Node> allReported, List<InflectedForm> triedForms) {
        Node singleNode = FeatureUtil.singleOrNull(allReported);
        if (this.verbs.stream().anyMatch(allReported::contains)) {
            return "Fehlende \u00dcbereinstimmung zwischen Nomen und Verb?";
        }
        Object msg = singleNode == null ? FEHLERHAFTE_BEUGUNG : (singleNode == this.det && singleNode.hasPos("PRO:(IND|DEM|RIN).*") && !singleNode.hasPos("ART.*") ? "Unpassendes Pronomen" : (singleNode == this.det ? "Unpassender Artikel" : (singleNode == this.prep ? "Unpassende verschmolzene Pr\u00e4position" : (this.relatives.contains(singleNode) ? "Unpassendes Relativpronomen" : (singleNode != this.main && this.det != null ? "Falsche Adjektivwortendung" : "Falsche Wortendung")))));
        Case caze = FeatureUtil.singleOrNull(this.possibleCases.allowed());
        if (singleNode != null) {
            Number number;
            Gender gender;
            if (singleNode != this.main && singleNode != this.det && singleNode != this.prep && !this.relatives.contains(singleNode)) {
                msg = (String)msg + (String)(this.det == null ? " des artikellosen " + (singleNode.hasPos("PA.*") ? "Partizips" : "Adjektivs") : (this.det.hasLemma("der") ? " nach bestimmtem Artikel" : (this.det.hasLemma("ein") ? " nach unbestimmtem Artikel" : "")));
            }
            Gender gender2 = gender = (number = AgreementSet.singleNumber((StreamEx<InflectedForm>)StreamEx.of(triedForms))) == null ? null : FeatureUtil.singleOrNull(this.possibleGenders);
            if (number == Number.PLU) {
                msg = (String)msg + " an " + this.main.quotedPresentableText() + " im " + (String)(caze == null ? "" : caze.presentable + "-") + "Plural";
                caze = null;
            } else if (gender != null && gender != Gender.ALG) {
                String mainLemma = FeatureUtil.singleOrNull(new HashSet<String>(this.main.lemmaReadings()));
                String article = this.relatives.contains(singleNode) ? " beim " : " am ";
                msg = (String)msg + article + gender.presentable() + "en " + (String)(mainLemma != null ? "Wort " + this.main.tree().treeSupport().quote(mainLemma) : "Wort");
            }
        }
        if (caze != null) {
            msg = (String)msg + " im " + caze.presentable;
        }
        return (String)msg + "?";
    }

    Set<InflectedForm> commonFeatures(Set<Case> possibleCases) {
        Set<InflectedForm> unified = new HashSet<InflectedForm>(this.filterByContext((Collection<InflectedForm>)(this.node2Features.containsKey(this.main) ? (List<InflectedForm>)((Object)this.node2Features.get(this.main)) : List.of(new InflectedForm(Gender.ALG, null, null, null, Person.P3))), possibleCases));
        if (allowPluralAdjOnSingularNoun.matches(this.main)) {
            unified.addAll(unified.stream().map(f -> f.withNumber(Number.PLU)).toList());
        }
        if (allowGenInterpretationsOfProperNoun.matches(this.main)) {
            unified.addAll(unified.stream().map(f -> f.withCase(Case.GEN)).toList());
        }
        for (Node node : this.relatives) {
            if (this.node2Features.get(node) == null) continue;
            Set<Case> relCases = AgreementSet.calcPossibleCases(node).allowed();
            List<InflectedForm> forms = this.node2Features.get(node).stream().filter(f -> relCases.contains((Object)f.caze)).map(f -> new InflectedForm(f.gender, f.number, null, null, null)).toList();
            unified = AgreementSet.unifyFeatures(unified, forms);
        }
        for (Node node : StreamEx.of(this.adjectives).append(this.verbs).append((Object)this.det).append((Object)this.prep).append(this.conj)) {
            LinkedHashSet<InflectedForm> forms = this.node2Features.get(node);
            if (forms != null) {
                unified = AgreementSet.unifyFeatures(unified, this.filterByContext(forms, possibleCases));
                continue;
            }
            if (!fixablePredicativeAdj.matches(node)) continue;
            return Set.of();
        }
        return unified;
    }

    private List<InflectedForm> possibleInflections(boolean governmentIssue) {
        List<Gender> genders = ((StreamEx)StreamEx.of((Object[])Gender.values()).filter(f -> this.possibleGenders.isEmpty() || this.possibleGenders.contains(f))).toList();
        if (this.mainPerson.equals((Object)Person.P3) && genders.stream().allMatch(g -> g.equals((Object)Gender.ALG))) {
            genders = List.of(Gender.MAS);
        }
        List<Number> numbers = this.numberRestriction != null ? List.of(this.numberRestriction) : (withOrderNumeral.matches(this.main) ? List.of(Number.SIN) : (preferPlural.matches(this.main) ? List.of(Number.PLU) : List.of(Number.values())));
        Node prep = GermanTreePatterns.findPreposition(this.main);
        Node head = this.main.head();
        Set<Case> cases = accusativePhrase.matches(this.main) ? this.possibleCases.allowed() : ((head == null || Case.misparsedFlatHead.matches(this.main) && head.head() == null) && prep == null ? Set.of(Case.NOM) : (GermanTreePatterns.entsprechend.matches(prep) ? Set.of(Case.DAT) : this.possibleCases.allowed()));
        Set<InflectedForm> common = this.commonFeatures(EnumSet.allOf(Case.class));
        ArrayList<InflectedForm> result = new ArrayList<InflectedForm>();
        for (Number number : numbers) {
            for (Case caze : cases) {
                for (Gender gender : number == Number.SIN ? genders : Collections.singletonList(null)) {
                    InflectedForm shouldExist;
                    AdjDeclination declination = this.det != null && this.det.hasPos("ART:IND.*") && number == Number.PLU ? AdjDeclination.SOL : this.adjDeclination;
                    InflectedForm form = new InflectedForm(gender, number, caze, declination, this.mainPerson);
                    InflectedForm inflectedForm = shouldExist = governmentIssue ? new InflectedForm(gender, number, null, this.adjDeclination, this.mainPerson) : form;
                    if (!this.hasAnyCompatibleWord(shouldExist) && !common.stream().anyMatch(f -> f.number == number) && (!incorrectConjSubjectAgreement.matches(this.main) || this.verbs.isEmpty()) && !neutralPronoun.matches(this.main)) continue;
                    result.add(form);
                }
            }
        }
        return result;
    }

    private boolean hasAnyCompatibleWord(InflectedForm form) {
        return EntryStream.of(this.node2Features).anyMatch((node, forms) -> !meaninglessAdjForm.matches((Node)node) && forms.stream().anyMatch(f -> f.unify(form) != null)) || form.number == Number.PLU && lexicallyPlural.matches(this.main) || form.number == Number.SIN && singularByDependentNummod.matches(this.main) || Case.possiblyMisshapedSubject.matches(this.main) || pluralVocative.matches(this.main) || conjAttachmentAmbiguity.matches(this.main) || predicativeSuperlativeAdj.matches(this.main) || dativeSgMNFormInE.matches(this.main) && this.possibleCases.allowed().contains((Object)Case.DAT) || avoidDatInE.matches(this.main);
    }

    private List<InflectedForm> filterByContext(Collection<InflectedForm> forms, Set<Case> cases) {
        return ((StreamEx)StreamEx.of(forms).filter(f -> f.matchesCase(cases) && this.isGenderCompatibleWithContext(f.gender) && FeatureUtil.areCompatible(this.numberRestriction, f.number) && FeatureUtil.areCompatible(this.adjDeclination, f.adjDecl))).toList();
    }

    private boolean isGenderCompatibleWithContext(Gender gender) {
        return gender == null || gender == Gender.ALG || this.possibleGenders.isEmpty() || this.possibleGenders.contains((Object)Gender.ALG) || this.possibleGenders.contains((Object)gender);
    }

    private static boolean forceInflection(@NotNull InflectedForm form, Node target) {
        return form.caze == Case.DAT && (form.gender == Gender.MAS || form.gender == Gender.NEU) && looksLikeArchaicDatSg.matches(target);
    }

    Map<Node, NodeCorrector> imposeFeatures(@NotNull InflectedForm form, Boolean inflectMain) {
        LinkedHashMap<Node, NodeCorrector> result = new LinkedHashMap<Node, NodeCorrector>();
        boolean normalizePrep = AdjDeclination.anyFusedPreposition.matches(this.prep) && (NodePattern.N.withDependent("amod", NodePattern.N.pos("PRO:IND.*")).matches(this.main) || form.number == Number.PLU || this.main.hasPos("PRO.*") || this.det != null);
        for (Map.Entry<Node, LinkedHashSet<InflectedForm>> entry : this.node2Features.entrySet()) {
            Node target = entry.getKey();
            if (!inflectMain.booleanValue() && target.equals(this.main) || incorrectConjSubjectAgreement.matches(this.main) && !this.verbs.contains(target) || this.relatives.contains(target) || entry.getValue().stream().anyMatch(f -> f.unify(form) != null) && !AgreementSet.forceInflection(form, target) && (!entry.getValue().stream().anyMatch(f -> f.adjDecl == AdjDeclination.DEF) || !target.hasPos("PRO:.*") || !AdjDeclination.anyFusedPreposition.matches(this.prep)) && (!normalizePrep || !this.adjectives.contains(target) || this.det != null)) continue;
            if (AdjDeclination.anyFusedPreposition.matches(target)) {
                normalizePrep = true;
                continue;
            }
            NodeCorrector correctors = form.inflect(target, normalizePrep, this.det);
            if (correctors == null) {
                return Collections.emptyMap();
            }
            result.put(target, correctors);
        }
        for (Node adj : this.adjectives) {
            if (possibleMisparsedAdverb.matches(adj) && GermanTreePatterns.uncountableNoun.matches(this.main)) {
                result.put(adj, NodeCorrector.regexReplace(adj, "(viel|wenig|ausreichend).+", "$1"));
            }
            if ((this.node2Features.containsKey(adj) || !fixablePredicativeAdj.matches(adj)) && !this.predicativeUnlikelyCompatible(adj)) continue;
            result.put(adj, form.inflectPredicative(adj));
        }
        for (Node relative : this.relatives) {
            NodeCorrector relCorrector = form.inflectRel(relative);
            if (relCorrector == null) continue;
            result.put(relative, relCorrector);
        }
        for (Node conj : this.conj) {
            AgreementSet conjSet = AgreementSet.create(conj);
            if (conjSet == null || !conjSet.hasAgreementIssue() && !conjSet.hasGovernmentIssue()) continue;
            List<InflectedForm> conjForms = conjSet.possibleInflections(false).stream().filter(conjForm -> conjForm.caze == form.caze).toList();
            if (conjForms.size() > 1) {
                conjForms = conjForms.stream().filter(conjForm -> conjForm.number == form.number).toList();
            }
            for (InflectedForm conjForm2 : conjForms) {
                Map<Node, NodeCorrector> conjResult = conjSet.imposeFeatures(conjForm2, true);
                for (Node n : conjResult.keySet()) {
                    if (conjResult.get(n).calcSuggestions(n.form()).isEmpty()) continue;
                    result.putIfAbsent(n, conjResult.get(n));
                }
            }
        }
        if (this.prep != null && normalizePrep) {
            result.put(this.prep, NodeCorrector.replace(this.prep, GermanValences.normalizePreposition(this.prep)));
        }
        return result;
    }

    private boolean predicativeUnlikelyCompatible(Node adj) {
        String basicForm = adj.lowForm().replaceAll("(.*)e[rsmn]?", "$1");
        boolean isPredicative = adj.tree().treeSupport().tagToken(basicForm).hasPos("ADJ:PRD.*");
        return isPredicative && SemCompatibility.getCompatibility(this.main, adj) == SemCompatibility.Unlikely;
    }

    private static Set<InflectedForm> unifyFeatures(Collection<InflectedForm> forms1, Collection<InflectedForm> forms2) {
        return StreamEx.of(forms1).flatMap(f1 -> StreamEx.of((Collection)forms2).map(f2 -> f1.unify((InflectedForm)f2)).filter(Objects::nonNull)).toSet();
    }

    static enum Number {
        SIN,
        PLU;

    }

    static enum Gender {
        MAS,
        FEM,
        NEU,
        ALG;


        String presentable() {
            return switch (this.ordinal()) {
                case 0 -> "m\u00e4nnlich";
                case 1 -> "weiblich";
                case 2 -> "neutral";
                default -> throw new UnsupportedOperationException();
            };
        }
    }

    static enum Person {
        P1,
        P2,
        P3;


        public String toString() {
            return this.name().substring(1);
        }
    }

    record InflectedForm(Gender gender, Number number, Case caze, AdjDeclination adjDecl, Person person) {
        private static final InflectedForm EMPTY = new InflectedForm(null, null, null, null, null);
        private static final NodePattern zimmernNotActivity = NodePattern.N.formCaseSensitive("Zimmern").withDependent("case", NodePattern.N.form("in"));
        private static final NodePattern punktenNotNoun = NodePattern.N.formCaseSensitive("\\p{Lu}.+punkten");
        private static final Pattern unlikelyLemmas = Pattern.compile("Sitzreihen|\\p{Lu}.+hinweisen|Freunden");
        private static final NodePattern probablyFalseNoVerbMorphoAfterQuote = CommonPatterns.capitalized.directlyAfter(GermanTreePatterns.openingQuotation).noPos("VER:.*").and(GermanTreePatterns.finiteVerb);
        private static final NodePattern definitelyFiniteVerb = NodePattern.or(GermanTreePatterns.finiteVerb, GermanTreePatterns.misspelledFiniteVerb).andOr(NodePattern.not(CommonPatterns.capitalized), NodePattern.not(NodePattern.N.withHeadRelation("nsubj.*|i?obj|obl")));
        private static final NodePattern misparsedSubstantive = NodePattern.N.withHeadRelation("amod").andOr(CommonPatterns.firstToken, NodePattern.not(CommonPatterns.capitalized));
        private static final NodePattern misparsedCapitalizedArticle = CommonPatterns.capitalizedMiddle.noPos().and(CommonPatterns.lowercasedHasPos("ART.*"));
        private static final NodePattern misparsedCapitalizedAdjective = CommonPatterns.capitalizedMiddle.andOr(NodePattern.N.noPos(), NodePattern.N.withHeadRelation("amod")).and(CommonPatterns.lowercasedHasPos("(ADJ|PA[12]).*"));
        private static final NodePattern lowercasedIsPronoun = CommonPatterns.lowercasedHasPos("PRO.*");
        private static final NodePattern needAdjEnding = NodePattern.or(NodePattern.or(NodePattern.N.lemma("ein"), NodePattern.N.pos("PRO:POS.*")).withPrevSibling(NodePattern.N.withHeadRelation("det(:poss)?")), NodePattern.N.lemma("beid"));
        private static final NodePattern strongDeclension = NodePattern.N.withHeadRelation("det:poss").directlyAfter(NodePattern.N.noPos("ART:DEF.*"));
        private static final Map<String, InflectedForm> cache = Collections.synchronizedMap(new HashMap());
        private static final NodePattern beideNeedsAdjMorpho = NodePattern.N.lemma("beid").andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det(:poss)?")), NodePattern.N.withHeadRelation("amod|nsubj(:pass)?|i?obj|obl|nmod|compound"));
        private static final NodePattern einNeedsAdjMorpho = NodePattern.N.lemma("ein").withPrevSibling(NodePattern.N.withHeadRelation("det(:poss)?"));
        private static final NodePattern lohnNoFemMorpho = NodePattern.N.lemma("Lohn");
        private static final NodePattern unlikelyInf = NodePattern.or(NodePattern.N.withDependent("det|amod").noDependents("det|amod", NodePattern.or(NodePattern.N.pos(".*SIN:NEU.*|ADV.*"), NodePattern.N.form(".+es"))).noDependents("case", AdjDeclination.anyFusedPreposition), NodePattern.N.noDependents("det(:poss)?|amod|case|nmod").andOr(NodePattern.N.withHead("nsubj", NodePattern.N.lemma("stehen")).andNot(GermanTreePatterns.headInQuotes), NodePattern.N.withDependent("acl")));
        private static final NodePattern siePluralAgreement = CommonPatterns.capitalizedMiddle.directlyAfter(NodePattern.not(CommonPatterns.colon).andNot(CommonPatterns.punctOrEmoji).andNot(GermanTreePatterns.anyQuotation));

        @Nullable
        InflectedForm unify(InflectedForm another) {
            if (!FeatureUtil.areCompatible(this.caze, another.caze)) {
                return null;
            }
            if (this.gender != Gender.ALG && another.gender != Gender.ALG && !FeatureUtil.areCompatible(this.gender, another.gender)) {
                return null;
            }
            if (!FeatureUtil.areCompatible(this.number, another.number)) {
                return null;
            }
            if (!FeatureUtil.areCompatible(this.adjDecl, another.adjDecl)) {
                return null;
            }
            if (!FeatureUtil.areCompatible(this.person, another.person)) {
                return null;
            }
            Gender commonGender = this.gender == null ? another.gender : (another.gender == null ? this.gender : (this.gender == Gender.ALG ? another.gender : this.gender));
            return new InflectedForm(commonGender, FeatureUtil.unifyValues(this.number, another.number), FeatureUtil.unifyValues(this.caze, another.caze), FeatureUtil.unifyValues(this.adjDecl, another.adjDecl), FeatureUtil.unifyValues(this.person, another.person));
        }

        @Override
        public String toString() {
            return ((StreamEx)StreamEx.of((Object[])new Enum[]{this.gender, this.number, this.caze, this.adjDecl, this.person}).filter(Objects::nonNull)).joining((CharSequence)"+");
        }

        @Nullable
        NodeCorrector inflect(Node target, boolean normalizePrep, @Nullable Node det) {
            if (definitelyFiniteVerb.matches(target)) {
                return this.inflectVerb(target);
            }
            if (needAdjEnding.matches(target)) {
                return this.applyAdjEndings(target);
            }
            if (target.hasPos("(ADJ|PA[12]).*") || misparsedCapitalizedAdjective.matches(target) || substantivizedAdj.matches(target)) {
                return this.inflectAdjLike(target, normalizePrep, det);
            }
            if (target.hasPos("SUB.*") && !lowercasedIsPronoun.matches(target)) {
                return this.inflectNoun(target);
            }
            if (target.hasPos("ART.*") || misparsedCapitalizedArticle.matches(target)) {
                return this.inflectArt(target);
            }
            if (target.hasPos("PRO.*") || lowercasedIsPronoun.matches(target)) {
                return this.inflectPro(target, det);
            }
            return null;
        }

        private NodeCorrector inflectVerb(Node target) {
            String tense = target.hasPos(".*(IMP|[13]:(SIN|PLU):KJ1).*") ? (looksLikeKJ1.matches(target) ? ":KJ1" : ":PR\u00c4") : ":$4";
            return NodeCorrector.inflect(target, "VER(.*):([123]|IMP):(SIN|PLU):(.*)", "VER$1:" + String.valueOf(this.person == null ? "[213]" : this.person) + ":" + String.valueOf(this.number == null ? "(SIN|PLU)" : this.number) + tense + ".*");
        }

        private NodeCorrector inflectNoun(Node target) {
            if (this.number == Number.PLU && target.hasForm("ich")) {
                return null;
            }
            return NodeCorrector.inflect(target, "SUB.*", "SUB.*:" + this.caseNumGenderRegexp() + ".*");
        }

        private NodeCorrector inflectPredicative(Node adj) {
            if (adj.form().equals("anders")) {
                return NodeCorrector.replace(adj, adj.tree().treeSupport().synthesize(adj.form(), "andere", ".+", "ADJ:" + this.caseNumGenderRegexp() + ":GRU:" + String.valueOf((Object)this.adjDecl)));
            }
            return NodeCorrector.inflect(adj, "(ADJ|PA2):PRD:(GRU|KOM|SUP)(:VER)?", "$1:" + this.caseNumGenderRegexp() + ":$2" + (String)(this.adjDecl == null ? ".*" : ":" + String.valueOf((Object)this.adjDecl)) + "$3.*");
        }

        private NodeCorrector applyAdjEndings(Node target) {
            if (target.lemmaReadings().isEmpty()) {
                return null;
            }
            String lemma = target.lemmaReadings().isEmpty() ? target.form().replaceFirst("(.+)(e[mnsr]?)$", "$1") : target.lemmaReadings().get(0).replaceFirst("(.+)e$", "$1");
            List<String> form = target.tree().treeSupport().synthesize("gut", "gut", "ADJ(:...){3}(.*)(IND|DEF|SOL)(.*)", "ADJ:" + this.caseNumGenderRegexp() + ":GRU:" + String.valueOf(strongDeclension.matches(target) ? "SOL" : (this.adjDecl == null ? ".*" : this.adjDecl))).stream().map(adj -> lemma + adj.substring(3)).toList();
            return NodeCorrector.replace(target, form);
        }

        private NodeCorrector inflectAdjLike(Node target, boolean normalizePrep, Node det) {
            NodeCorrector adjCorrector = NodeCorrector.inflect(target, "(ADJ|PA[12])(:...){3}(.*)(IND|DEF|SOL)(.*)", "$1:" + this.caseNumGenderRegexp() + "$3" + String.valueOf(normalizePrep && det == null ? "SOL" : (this.adjDecl == null ? "$4" : this.adjDecl)) + "$5");
            return !adjCorrector.calcSuggestions(target.form()).isEmpty() || SpellingRules.withNominalDependents.matches(target) ? adjCorrector : this.applyAdjEndings(target);
        }

        NodeCorrector inflectArt(Node target) {
            if (target.hasPos("ART:IND.*") && this.number == Number.PLU) {
                return NodeCorrector.removeNode(target);
            }
            return NodeCorrector.inflect(target, "ART.*", "ART.*:" + this.caseNumGenderRegexp() + ".*");
        }

        NodeCorrector inflectRel(Node target) {
            FeatureRestriction<Case> cases = AgreementSet.calcPossibleCases(target);
            List<String> replacements = target.tree().treeSupport().synthesize(target.form(), "der", "ART.*", "ART.*:(" + StreamEx.of(cases.allowed()).map(Enum::name).joining((CharSequence)"|") + "):" + this.numRegex() + ":" + this.genderRegex() + ".*");
            if (this.numRegex().matches(".*PLU.*") && cases.allowed().contains((Object)Case.DAT)) {
                replacements.removeIf(r -> r.equals("den"));
                replacements.add("denen");
            }
            return !replacements.contains(target.form()) ? NodeCorrector.replace(target, replacements) : null;
        }

        NodeCorrector inflectPro(Node target, @Nullable Node det) {
            Object kindSuffix;
            if (target == det && possibleMisparsedAdverb.matches(target) && det.hasLemma("viel") && GermanTreePatterns.uncountableNoun.matches(det.head()) && this.number == Number.SIN) {
                return NodeCorrector.replace(det, "viel");
            }
            String expectedKind = target == det ? "BEG" : "BEG|STV";
            String allowedKinds = (target == det ? "POS|" : "PER|") + "DEM|IND|RIN";
            Object object = kindSuffix = target.hasHeadRelation("nsubj.*") ? "" : "(:(" + expectedKind + "|B/S))?";
            String genderStr = NodePattern.N.onlyPos(".*ALG.*").matches(target) ? "ALG" : (this.gender == null ? ".*" : this.gender.toString());
            String numberStr = !CommonPatterns.lowercasedHasPos(".*(SIN|PLU).*").matches(target) ? "" : ":" + this.numRegex();
            return NodeCorrector.inflect(target, "PRO:(" + allowedKinds + ").*(MAS|FEM|NEU|ALG|NOG)(:(BEG|STV|B/S))?(:[123]:B)?", "PRO:(" + allowedKinds + "):" + this.caseRegex() + numberStr + ":" + genderStr + (String)kindSuffix + "$5");
        }

        private String caseNumGenderRegexp() {
            return this.caseRegex() + ":" + this.numRegex() + ":" + this.genderRegex();
        }

        private String genderRegex() {
            return this.gender == null ? ".*" : this.gender.toString();
        }

        private String numRegex() {
            return this.number == null ? ".*" : this.number.toString();
        }

        private String caseRegex() {
            return this.caze == null ? ".*" : this.caze.toString();
        }

        boolean matchesCase(Set<Case> cases) {
            return this.caze == null || cases.contains((Object)this.caze);
        }

        private InflectedForm withNumber(Number number) {
            return new InflectedForm(this.gender, number, this.caze, this.adjDecl, this.person);
        }

        private InflectedForm withCase(Case caze) {
            return new InflectedForm(this.gender, this.number, caze, this.adjDecl, this.person);
        }

        @Nullable
        static InflectedForm fromPos(String pos) {
            InflectedForm result = cache.computeIfAbsent(pos, InflectedForm::doCreate);
            return result == EMPTY ? null : result;
        }

        @NotNull
        private static InflectedForm doCreate(String pos) {
            Person person;
            AdjDeclination adjDecl;
            HashSet<String> parts = new HashSet<String>(Arrays.asList(pos.split(":")));
            Gender gender = FeatureUtil.findEnumConstant(parts, Gender.values());
            Number number = FeatureUtil.findEnumConstant(parts, Number.values());
            Case caze = FeatureUtil.findEnumConstant(parts, Case.values());
            AdjDeclination adjDeclination = adjDecl = pos.startsWith("ADJ") || pos.startsWith("PA") ? FeatureUtil.findEnumConstant(parts, AdjDeclination.values()) : null;
            Person person2 = parts.contains("1") ? Person.P1 : (parts.contains("2") ? Person.P2 : (parts.contains("3") ? Person.P3 : (parts.contains("IMP") ? Person.P2 : (person = parts.contains("SUB") || parts.contains("PRO") ? Person.P3 : null))));
            if (gender == null && number == null && caze == null && person == null) {
                return EMPTY;
            }
            return new InflectedForm(gender, number, caze, adjDecl, person);
        }

        static List<InflectedForm> fromNode(Node node, @Nullable Node det, List<Node> verbs, Node prep) {
            List<Tree.Reading> allReadings;
            AdjDeclination decl;
            String form;
            switch (form = node.lowForm()) {
                case "vielen": {
                    return List.of(new InflectedForm(Gender.MAS, Number.SIN, Case.AKK, AdjDeclination.SOL, null), new InflectedForm(Gender.MAS, Number.SIN, Case.GEN, AdjDeclination.SOL, null), new InflectedForm(Gender.NEU, Number.SIN, Case.GEN, AdjDeclination.SOL, null), new InflectedForm(Gender.NEU, Number.PLU, Case.DAT, AdjDeclination.SOL, null), new InflectedForm(Gender.MAS, Number.PLU, Case.DAT, AdjDeclination.SOL, null), new InflectedForm(Gender.FEM, Number.PLU, Case.DAT, AdjDeclination.SOL, null), new InflectedForm(Gender.NEU, Number.SIN, Case.GEN, AdjDeclination.IND, null), new InflectedForm(Gender.NEU, Number.SIN, Case.DAT, AdjDeclination.IND, null), new InflectedForm(Gender.MAS, Number.SIN, Case.GEN, AdjDeclination.IND, null), new InflectedForm(Gender.MAS, Number.SIN, Case.DAT, AdjDeclination.IND, null), new InflectedForm(Gender.MAS, Number.SIN, Case.AKK, AdjDeclination.IND, null), new InflectedForm(Gender.FEM, Number.SIN, Case.GEN, AdjDeclination.IND, null), new InflectedForm(Gender.FEM, Number.SIN, Case.DAT, AdjDeclination.IND, null), new InflectedForm(Gender.NEU, Number.SIN, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.SIN, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.SIN, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.SIN, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.SIN, Case.AKK, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.SIN, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.SIN, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.PLU, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.PLU, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.PLU, Case.AKK, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.PLU, Case.NOM, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.PLU, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.PLU, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.PLU, Case.AKK, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.PLU, Case.NOM, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.PLU, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.PLU, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.PLU, Case.AKK, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.PLU, Case.NOM, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.PLU, Case.GEN, AdjDeclination.IND, null), new InflectedForm(Gender.NEU, Number.PLU, Case.DAT, AdjDeclination.IND, null), new InflectedForm(Gender.NEU, Number.PLU, Case.AKK, AdjDeclination.IND, null), new InflectedForm(Gender.NEU, Number.PLU, Case.NOM, AdjDeclination.IND, null), new InflectedForm(Gender.MAS, Number.PLU, Case.GEN, AdjDeclination.IND, null), new InflectedForm(Gender.MAS, Number.PLU, Case.DAT, AdjDeclination.IND, null), new InflectedForm(Gender.MAS, Number.PLU, Case.AKK, AdjDeclination.IND, null), new InflectedForm(Gender.MAS, Number.PLU, Case.NOM, AdjDeclination.IND, null), new InflectedForm(Gender.FEM, Number.PLU, Case.GEN, AdjDeclination.IND, null), new InflectedForm(Gender.FEM, Number.PLU, Case.DAT, AdjDeclination.IND, null), new InflectedForm(Gender.FEM, Number.PLU, Case.AKK, AdjDeclination.IND, null), new InflectedForm(Gender.FEM, Number.PLU, Case.NOM, AdjDeclination.IND, null));
                }
                case "seiner": 
                case "ihrer": 
                case "deiner": 
                case "meiner": {
                    return List.of(new InflectedForm(Gender.ALG, Number.PLU, Case.GEN, null, null), new InflectedForm(Gender.FEM, Number.SIN, Case.GEN, null, null), new InflectedForm(Gender.FEM, Number.SIN, Case.DAT, null, null));
                }
                case "aller": {
                    return List.of(new InflectedForm(Gender.FEM, Number.SIN, Case.DAT, null, null), new InflectedForm(Gender.ALG, Number.PLU, Case.GEN, null, null));
                }
                case "ich": {
                    return List.of(new InflectedForm(null, Number.SIN, Case.NOM, null, Person.P1));
                }
                case "wir": {
                    return List.of(new InflectedForm(null, Number.PLU, Case.NOM, null, Person.P1));
                }
                case "du": {
                    return List.of(new InflectedForm(null, Number.SIN, Case.NOM, null, Person.P2));
                }
                case "sie": {
                    if (siePluralAgreement.matches(node)) {
                        return List.of(new InflectedForm(null, Number.PLU, Case.NOM, null, Person.P3), new InflectedForm(null, Number.PLU, Case.AKK, null, Person.P3));
                    }
                    return List.of(new InflectedForm(null, null, Case.NOM, null, Person.P3), new InflectedForm(null, null, Case.AKK, null, Person.P3));
                }
                case "invalide": 
                case "nafri": 
                case "assi": {
                    return List.of(new InflectedForm(null, null, null, null, Person.P3));
                }
                case "wehrmacht": {
                    return List.of(new InflectedForm(Gender.FEM, Number.SIN, Case.NOM, null, Person.P3), new InflectedForm(Gender.FEM, Number.SIN, Case.GEN, null, Person.P3), new InflectedForm(Gender.FEM, Number.SIN, Case.DAT, null, Person.P3), new InflectedForm(Gender.FEM, Number.SIN, Case.AKK, null, Person.P3));
                }
                case "vaterland": {
                    return List.of(new InflectedForm(Gender.NEU, Number.SIN, Case.NOM, null, Person.P3), new InflectedForm(Gender.NEU, Number.SIN, Case.GEN, null, Person.P3), new InflectedForm(Gender.NEU, Number.SIN, Case.DAT, null, Person.P3), new InflectedForm(Gender.NEU, Number.SIN, Case.AKK, null, Person.P3));
                }
            }
            if (beideNeedsAdjMorpho.matches(node)) {
                switch (form) {
                    case "beide": {
                        return List.of(new InflectedForm(Gender.ALG, Number.PLU, Case.NOM, AdjDeclination.SOL, null), new InflectedForm(Gender.ALG, Number.PLU, Case.AKK, AdjDeclination.SOL, null));
                    }
                    case "beider": {
                        return List.of(new InflectedForm(Gender.ALG, Number.PLU, Case.GEN, AdjDeclination.SOL, null));
                    }
                    case "beiden": {
                        return List.of(new InflectedForm(Gender.ALG, Number.PLU, Case.NOM, AdjDeclination.DEF, null), new InflectedForm(Gender.ALG, Number.PLU, Case.AKK, AdjDeclination.DEF, null), new InflectedForm(Gender.ALG, Number.PLU, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.ALG, Number.PLU, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.ALG, Number.PLU, Case.NOM, AdjDeclination.IND, null), new InflectedForm(Gender.ALG, Number.PLU, Case.AKK, AdjDeclination.IND, null), new InflectedForm(Gender.ALG, Number.PLU, Case.DAT, AdjDeclination.IND, null), new InflectedForm(Gender.ALG, Number.PLU, Case.GEN, AdjDeclination.IND, null), new InflectedForm(Gender.ALG, Number.PLU, Case.DAT, AdjDeclination.SOL, null));
                    }
                }
            }
            if (einNeedsAdjMorpho.matches(node)) {
                switch (form) {
                    case "eine": {
                        return List.of(new InflectedForm(Gender.NEU, Number.SIN, Case.NOM, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.SIN, Case.AKK, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.SIN, Case.NOM, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.SIN, Case.NOM, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.SIN, Case.AKK, AdjDeclination.DEF, null));
                    }
                    case "einen": {
                        return List.of(new InflectedForm(Gender.NEU, Number.SIN, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.NEU, Number.SIN, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.SIN, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.SIN, Case.DAT, AdjDeclination.DEF, null), new InflectedForm(Gender.MAS, Number.SIN, Case.AKK, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.SIN, Case.GEN, AdjDeclination.DEF, null), new InflectedForm(Gender.FEM, Number.SIN, Case.DAT, AdjDeclination.DEF, null));
                    }
                    case "einem": {
                        return List.of(new InflectedForm(Gender.NEU, Number.SIN, Case.DAT, AdjDeclination.SOL, null), new InflectedForm(Gender.MAS, Number.SIN, Case.DAT, AdjDeclination.SOL, null));
                    }
                    case "einer": {
                        return List.of(new InflectedForm(Gender.FEM, Number.SIN, Case.GEN, AdjDeclination.SOL, null), new InflectedForm(Gender.FEM, Number.SIN, Case.DAT, AdjDeclination.SOL, null));
                    }
                }
            }
            if (einPaarAkk.matches(node)) {
                return List.of(new InflectedForm(Gender.NEU, Number.SIN, Case.NOM, null, Person.P3), new InflectedForm(Gender.NEU, Number.SIN, Case.AKK, null, Person.P3));
            }
            if (GermanTreePatterns.noPosNeutralAdj.matches(node)) {
                return List.of(new InflectedForm(Gender.NEU, Number.SIN, Case.NOM, null, Person.P3), new InflectedForm(Gender.NEU, Number.SIN, Case.AKK, null, Person.P3));
            }
            if (GermanDateChecker.dottedDateNode.matches(node) && node.hasHeadRelation("appos")) {
                return List.of(new InflectedForm(Gender.MAS, Number.SIN, Case.NOM, null, Person.P3), new InflectedForm(Gender.MAS, Number.SIN, Case.GEN, null, Person.P3), new InflectedForm(Gender.MAS, Number.SIN, Case.DAT, null, Person.P3), new InflectedForm(Gender.MAS, Number.SIN, Case.AKK, null, Person.P3));
            }
            if (zimmernNotActivity.matches(node)) {
                return List.of(new InflectedForm(Gender.NEU, Number.PLU, Case.DAT, null, Person.P3));
            }
            if (punktenNotNoun.matches(node)) {
                return Arrays.stream(Case.values()).map(c -> new InflectedForm(Gender.MAS, Number.PLU, (Case)((Object)c), null, Person.P3)).toList();
            }
            if (singularAdjPronounInEn.matches(node) && ((decl = AdjDeclination.fromNPHead(node.head())) == AdjDeclination.DEF || decl == AdjDeclination.IND)) {
                return List.of();
            }
            if (form.equals("downie")) {
                return List.of(new InflectedForm(Gender.ALG, null, null, null, Person.P3));
            }
            if (form.equals("ihr") && node.hasHeadRelation("nsubj.*")) {
                return List.of(new InflectedForm(null, Number.PLU, Case.NOM, null, Person.P2), new InflectedForm(Gender.FEM, Number.PLU, Case.AKK, null, null));
            }
            if (node == prep) {
                Node head = node.head();
                if (AdjDeclination.anyFusedPreposition.matches(node) && head != null && head.nerLabel() == null) {
                    Case caze;
                    Case case_ = caze = AdjDeclination.datFusedPreposition.matches(node) ? Case.DAT : Case.AKK;
                    Gender gender = node.form().endsWith("s") ? Gender.NEU : (node.form().endsWith("n") ? Gender.MAS : (node.form().endsWith("r") ? Gender.FEM : null));
                    return List.of(new InflectedForm(gender, Number.SIN, caze, AdjDeclination.DEF, null));
                }
                return List.of();
            }
            boolean missingVerbPos = probablyFalseNoVerbMorphoAfterQuote.matches(node);
            List<Tree.Reading> list = allReadings = missingVerbPos ? node.tagIndependentlyLowForm().tokenReadings() : node.tagIndependently().tokenReadings();
            if (allReadings.isEmpty()) {
                if (GermanParameters.VARIANT.getValue(node.tree()).equals("CH") && node.form().contains("ss")) {
                    TreeSupport support = node.tree().treeSupport();
                    String variant = DigraphNormalization.generateCombinations(node.form(), Map.of("ss", "\u00df")).stream().filter(c -> support.isAcceptedBySpellchecker((String)c)).findFirst().orElse(null);
                    if (variant != null && !variant.equals(node.form())) {
                        allReadings = node.tree().treeSupport().tagToken(variant).tokenReadings();
                    }
                }
                if (allReadings.isEmpty()) {
                    return List.of();
                }
            }
            Set kinds = ((StreamEx)StreamEx.of(node.posReadings()).filter(pos -> !pos.isEmpty())).map(s -> s.substring(0, 3)).toSet();
            boolean avoidPlural = node.form().equalsIgnoreCase("keinen") && node.hasDependent("nmod");
            boolean avoidInf = allReadings.stream().anyMatch(reading -> reading.pos().matches("SUB.+(MAS|FEM|NEU)$")) && unlikelyInf.matches(node);
            return ((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of(allReadings).filter(r -> r.lemma() != null && !unlikelyLemmas.matcher(r.lemma()).matches())).map(r -> r.pos()).filter(p -> p != null && !p.isEmpty())).filter(p -> missingVerbPos && p.startsWith("VER") || p.startsWith("PA") || p.startsWith("ADJ") || kinds.contains(p.substring(0, 3)))).filter(p -> !avoidPlural || !p.contains("PLU"))).filter(p -> !misparsedSubstantive.matches(node) || p.startsWith("ADJ") || p.startsWith("PA") || p.startsWith("PRO"))).filter(p -> !substantivizedAdj.matches(node) || !withArticle.matches(node) || p.contains("IND") || p.contains("DEF") || p.contains("SOL"))).filter(p -> !animateSubstantivizedAdj.matches(node) || p.contains("MAS") || p.contains("FEM"))).filter(p -> node != det || !p.startsWith("PRO") || !p.contains("STV") && !p.contains("PER"))).filter(p -> !verbs.contains(node) || p.startsWith("VER"))).filter(p -> !tagAsDay.matches(node) || !p.contains("NEU"))).filter(p -> !gruesse.matches(node) && !avoidInf || !p.endsWith("INF"))).filter(p -> !lohnNoFemMorpho.matches(node) || !p.contains("FEM"))).filter(p -> !p.matches("SUB:DAT:SIN:(MAS|NEU)") || !avoidDatInE.matches(node))).filter(p -> !node.form().equals("Ideale") && !node.form().equals("Idealen") || !p.contains("ADJ"))).map(InflectedForm::fromPos).filter(Objects::nonNull)).toList();
        }
    }
}

