/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanMetadata;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.document.ConsistencyChecker;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.TreeCache;
import ai.grazie.rules.tree.TreeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import one.util.streamex.StreamEx;
import org.languagetool.tools.StringTools;

class Capitalization {
    private static final NodePattern noMorphoNoun = NodePattern.N.form("(drit|vier|f(\u00fc|ue)nf|sechs|sieb|ach|neun|zehn|elf|zw\u00f6lf|hunderts|tausends)tel|gro\u00dftat|dr\u00fcber(lesen|steigen|fahren|schauen|streuen)|coden");
    private static final NodePattern looksLowerCaseNoun = NodePattern.or(CommonPatterns.capitalizedHasPos("SUB.*"), noMorphoNoun);
    private static final String CAPITALIZATION_MSG = "Substantive werden gro\u00dfgeschrieben";
    private static final String DECAPITALIZATION_MSG = " werden normalerweise kleingeschrieben";
    private static final String DECAPITALIZATION_SIE_MSG = "Wenn es nicht als Anredepronomen dient, wird das Pronomen \u201esie\u201c kleingeschrieben";
    private static final String ADJ_CAPITALIZATION_MSG = "Substantivierte Adjektive werden gro\u00dfgeschrieben";
    private static final String PRONOUN_COHERENCE_MSG = "Schreiben Sie \u201edu\u201c, \u201edir\u201c, \u201edich\u201c und \u201edein\u201c einheitlich gro\u00df oder klein";
    private static final NodePattern noInterveningVerbalDeps = NodePattern.N.noMatchUntil("headLowercase", NodePattern.N.withHeadRelation("i?obj|obl|cc"));
    private static final NodePattern looksLikeListElement = NodePattern.N.withDependent("nummod", NodePattern.N.withDependent("punct", CommonPatterns.dot.directlyAfterHead().noSpaceBefore())).withOnlyDependents(NodePattern.N.withHeadRelation("nummod"));
    private static final NodePattern withNominalDependent = NodePattern.or(NodePattern.N.markAs("headLowercase").andOr(NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.onlyPos("ADJ:(NOM|GEN|DAT|AKK).*"), NodePattern.N.pos("ADJ:(NOM|GEN|DAT|AKK).*|PRO:IND:.*").directlyBeforeHead())), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.beforeHead().noDependents("advmod", NodePattern.N.form("gerade")).and(noInterveningVerbalDeps)), NodePattern.N.withDependent("case|nummod|nmod:poss", NodePattern.N.beforeHead().and(noInterveningVerbalDeps).andOr(NodePattern.N.noHeadRelation("nummod"), NodePattern.not(NodePattern.N.directlyBefore(NodePattern.N.form("alt"))))), NodePattern.N.withDependent("nmod").afterHead().pos("SUB:GEN:.*").withDependent("det", NodePattern.N.pos("ART.*GEN.*"))).unmark("headLowercase"), NodePattern.N.withDependent(".*", NodePattern.or(NodePattern.N.pos("ART.*").noPos("ADJ.*").andOr(NodePattern.not(NodePattern.N.withHeadRelation("nsubj")), NodePattern.N.withHead("nsubj", NodePattern.N.withDependent("nmod"))), NodePattern.N.pos("PRP.*").withHeadRelation("dep"), NodePattern.N.form("kein.*"), NodePattern.N.form("manche[rn]?")).directlyBeforeHead().noDependents("advmod")), NodePattern.N.directlyAfter(NodePattern.N.pos("PRP.*").withHeadRelation("dep"))).noDependents("advmod", NodePattern.N.directlyBeforeHead()).andNot(looksLikeListElement);
    private static final NodePattern hyphenatedCompoundNoun = NodePattern.N.pos("SUB:.*").withHead("flat", NodePattern.or(NodePattern.N.pos("SUB.*"), CommonPatterns.capitalized.label(".*").noPos()).markAs("Head")).directlyAfter(NodePattern.N.form("-").directlyAfter(NodePattern.N.alreadyMarkedAs("Head")));
    private static final NodePattern trueNoun = NodePattern.or(NodePattern.N.pos("SUB:.*SIN:(MAS|FEM|NEU)"), NodePattern.N.pos("SUB:.*").and(withNominalDependent), hyphenatedCompoundNoun);
    private static final NodePattern conjBeforeTrueNoun = NodePattern.N.withDependent("conj", trueNoun.withDependent("cc", NodePattern.N.noForm("&")).noDependents("amod")).noHeadRelation("parataxis");
    private static final NodePattern withCopula = NodePattern.N.withDependent("cop");
    private static final NodePattern conjAfterTrueNoun = NodePattern.N.withHead("conj", trueNoun.andNot(withCopula).andNot(hyphenatedCompoundNoun.withHead(withCopula))).withDependent("cc", NodePattern.N.noForm("&")).noDependents("mark|cop");
    private static final NodePattern capitalizedHasTrueNounMorpho = CommonPatterns.capitalizedHasPos("SUB:.*(MAS|FEM|NEU)");
    private static final NodePattern adjBeforeAfterAdj = NodePattern.N.pos("ADJ:.*").noDependents("amod").andOr(NodePattern.N.withPrevSibling(NodePattern.N.onlyPos("ADJ:.*").andNot(NodePattern.N.directlyBeforeHead()).noHeadRelation("advmod")), NodePattern.N.withNextSibling(NodePattern.or(NodePattern.N.onlyPos("ADJ:.*").andNot(NodePattern.N.directlyBeforeHead()).noHeadRelation("advmod"), NodePattern.N.withDependent("amod"))), NodePattern.N.markAs("adjNP").withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withDependent("amod").andNot(NodePattern.N.withDependent(".*", NodePattern.N.alreadyMarkedAs("adjNP"))))));
    static final NodePattern ordinalToTwelve = NodePattern.N.form("(ers|zwei|drit|vier|f\u00fcnf|sechs|sieb|ach|neun|zehn|elf|zw(\u00f6|oe)lf)te.?");
    static final NodePattern cardinal = NodePattern.N.form("(zw(ei|o|\u00f6lf)|drei|vier|f\u00fcnf|sechs|sieben|acht|neun|zehn|elf)(en?)?");
    private static final NodePattern excludeAdj = NodePattern.or(NodePattern.N.potentialPos("ADJ.*").andOr(NodePattern.or(ordinalToTwelve, SpellingRules.ordinalAfterTwelve), NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("conj")), NodePattern.N.withHeadRelation("appos"), NodePattern.not(withNominalDependent).withDependent("cop").noDependents("case|nmod", NodePattern.N.noDependents("case"))), NodePattern.N.form("welt?meister|gleichen"), NodePattern.N.form(".+ische.?"), NodePattern.N.form(".+farben(en?)?"));
    private static final TreeCache<List<Node>> treeQuotes = new TreeCache<List>("quotes", t -> t.nodes().stream().filter(GermanTreePatterns.anyQuotation::matches).toList());
    static final NodePattern etwasNichtsVielWenig = NodePattern.N.form("(et|so)?was|irgend(et)?was|ni(chts|x)|viel|wenig|nur|(kein|all)erlei|einiges");
    private static final NodePattern compoundWithAdj = NodePattern.N.withDependent("amod", NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceAfter().directlyBefore("LowerCase")));
    static final NodePattern bisZumGehtNichtMehr = NodePattern.or(NodePattern.N.inFormSequence(0, "geht", "nicht", "mehr").withNeighbor(1, NodePattern.N.markAs("Middle")).withNeighbor(2, NodePattern.N.markAs("End")), NodePattern.N.inFormSequence(0, "geht", "-", "nicht", "-", "mehr").withNeighbor(2, NodePattern.N.markAs("Middle")).withNeighbor(4, NodePattern.N.markAs("End"))).withDependent("case|dep", NodePattern.N.inFormSequence(1, "bis", "zum"));
    static final NodePattern eineHandvoll = NodePattern.N.form("handvoll").directlyAfter(NodePattern.or(NodePattern.N.form("einer?|d(ie|er)"), NodePattern.N.inFormSequence(1, "ein", "paar")));
    private static final NodePattern folgendWithHeadParataxis = NodePattern.N.lemma("folgend").withHead("nsubj|obl", NodePattern.N.withHeadRelation("parataxis"));
    private static final NodePattern canBeLowercased = CommonPatterns.capitalized.andNot(NodePattern.custom(node -> TreeSupport.isCapitalizedSentenceStart(node))).andNot(NodePattern.N.markAs("Capitalized").inPhrase(NodePattern.or(NodePattern.N.withHeadRelation("parataxis"), NodePattern.N.withHead("conj", NodePattern.ROOT)).withPhraseStart(NodePattern.N.alreadyMarkedAs("Capitalized"))).directlyAfter(NodePattern.not(NodePattern.PUNCT))).andNot(CommonPatterns.upperCase).andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("[^a-z\u00e4\u00f6\u00fc\u00df\u2019`\u00b4]+").andNot(CommonPatterns.comma.andNot(NodePattern.N.directlyAfter(NodePattern.N.label("PERSON")))).andNot(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceAfter().noSpaceBefore().directlyAfter(CommonPatterns.withNumberLikeForm)), NodePattern.N.form("(\\p{L}+\\.)+"), NodePattern.N.form(".+\\.[^a-z\u00e4\u00f6\u00fc\u00df]+"), NodePattern.N.form("['`\u00b4\u2019]+").directlyAfter(NodePattern.or(NodePattern.N.form("[,:]"), NodePattern.N.form("['`\u00b4\u2019]+"))))));
    private static final ConsistencyChecker<DuStyle> consistency = new ConsistencyChecker<DuStyle>(DuStyle.class, GermanMetadata.duCapitalization){

        @Override
        protected ConsistencyChecker.SingleFix correctStyle(DuStyle style, Node node) {
            TextRange range = node.textRange().shiftRight(node.tree().startOffset());
            TextChange change = TextChange.replace(range, style == DuStyle.low ? node.lowForm() : StringTools.uppercaseFirstChar((String)node.lowForm()));
            return new ConsistencyChecker.SingleFix(change, range);
        }

        @Override
        protected String quickFixMessage(DuStyle style) {
            return style == DuStyle.low ? "\u201edu\u201c kleinschreiben" : "\u201edu\u201c gro\u00dfschreiben";
        }
    };
    static final NodePattern withDependentAm = NodePattern.N.withDependent("case|mark", NodePattern.N.form("am").directlyBeforeHead());
    private static final NodePattern zumal = NodePattern.N.inFormSequence(1, "zu", "Mal");
    static final NodePattern zeitlang = NodePattern.N.form("zeitlang");
    private static final NodePattern imGrossenUndGanzen = NodePattern.N.inFormSequence(1, 3, "im", "gro(ss|\u00df)en", "und", "ganzen").withPhraseEnd(NodePattern.not(NodePattern.N.directlyBefore(NodePattern.N.pos("(SUB|EIG).*"))));
    private static final NodePattern amSuperlative = NodePattern.N.inFormSequence(1, "am", ".+en").withHeadRelation("obl|root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").and(CommonPatterns.lowercasedHasPos("ADJ:PRD:SUP"));
    static final NodePattern beforeHyphen = NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE);
    static final String linkingElement = "(e|s|ens?|er|es)";
    static final NodePattern zumAnderen = NodePattern.N.inFormSequence(1, "zum", "Andere?n").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("obl|nmod")));
    static final String partsOfDayAdv = "((nach|vor)?mittag|abend|nacht|morgen)s";
    private static final NodePattern cardinalNumbers = NodePattern.or(NodePattern.N.form("(ein|zwei|(drei|vier|f\u00fcnf|sechs|sieb(en)?|acht|neun)(zehn)?).*(zig|hundert|tausend)|(zwanz|drei(\u00df|ss))ig|null|hundert|tausend"), cardinal);

    Capitalization() {
    }

    static Rule.PatternRule rule() {
        return new DocumentRule.PatternRule("Grammar.COMMON_CAPITALIZATION", "Gro\u00dfschreibung von Substantiven", "Substantive und substantivierte Adjektive oder Verben werden gro\u00dfgeschrieben.", "https://www.abiweb.de/deutsch-crashkurs/die-deutsche-rechtschreibung/die-gross-und-kleinschreibung/die-grossschreibung-im-deutschen.html", () -> NodePattern.or(Capitalization.wrongCapitalization(), Capitalization.derWievielteNoun(), Capitalization.nounCapitalization(), Capitalization.decapitalization(), Capitalization.specialAdjCapitalization().and(CommonPatterns.lowerCase), Capitalization.specialAbbrCapitalization(), Capitalization.pronounCoherence(), Capitalization.decapitalizeSonntagabends()), new Example[]{new Example("Das ist ein <b>tisch</b>.", "Das ist ein <b>Tisch</b>."), new Example("Ich <b>Schlafe</b> gerne.", "Ich <b>schlafe</b> gerne."), new Example("Morgens geht <b>Sie</b> \u00fcblich zur Arbeit", "Morgens geht <b>sie</b> \u00fcblich zur Arbeit")}){

            @Override
            public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences) {
                ArrayList<RuleMatch> result = new ArrayList<RuleMatch>();
                for (List<DocumentSentence.Analyzed> fragment : DocumentSentence.fragments(ConsistencyChecker.onlyConsistencyEnabledDomains(sentences))) {
                    result.addAll(consistency.checkConsistency(fragment, this, Capitalization.PRONOUN_COHERENCE_MSG));
                }
                return MatchingResult.from(result);
            }
        }.honorCrazyParses();
    }

    private static NodePattern pronounCoherence() {
        return NodePattern.N.form("du|di(ch|r)|dein(e[rsmn]?)?|deinesgleichen|deinerseits|deinetwegen").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE).noSpaceAfter()).andOr(CommonPatterns.lowerCase.and(consistency.record(DuStyle.low)), canBeLowercased.and(consistency.record(DuStyle.upper)));
    }

    private static NodePattern specialAbbrCapitalization() {
        return NodePattern.N.form("m(io|rd)").withDependent("nummod", NodePattern.N.directlyBeforeHead()).andOptionally(NodePattern.N.directlyBefore(CommonPatterns.dot.noSpaceBefore()).markAs("Dot")).andOr(CommonPatterns.lowerCase, NodePattern.not(NodePattern.markedNodeMatches("Dot", NodePattern.N))).and(NodePattern.custom((n, match) -> match.withCorrector(CommonPatterns.capitalizeNode(n).join(match.findMarkedNode("Dot") == null ? NodeCorrector.insertAfter(n, ".") : null)))).message("Diese Abk\u00fcrzung wird gro\u00df und mit Punkt geschrieben");
    }

    private static NodePattern specialAdjCapitalization() {
        NodePattern withDefArticle = NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.lemma("der")), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition));
        return NodePattern.or(NodePattern.or(NodePattern.N.lemma("heilig"), NodePattern.N.form("hl")).markAs("Heilig").withHead("amod", NodePattern.or(NodePattern.N.lemma("Abend|Allianz|Dreifaltigkeit|Familie|Geist|Grab|Jungfrau|Land|Nacht|Schrift|Stadt|Vater").noDependents("nmod"), NodePattern.N.inFormSequence(1, "R\u00f6mische(mns)?", "Reich(e?s)?"), NodePattern.N.inFormSequence(1, "drei", "K\u00f6nigen?"))), NodePattern.N.inFormSequence(2, "tage?s?", "der", "deutschen", "einheit"), NodePattern.N.inFormSequence(0, "wei(\u00df|ss)e[rn]", "sonntage?s?"), NodePattern.N.form("vier").withHead("nummod", NodePattern.N.form("Jahreszeiten").andOr(withDefArticle, NodePattern.N.withHead("appos", NodePattern.N.lemma("hotel")))), NodePattern.N.lemma("rot").withHead("amod", NodePattern.N.lemma("armee|bee?te|milan")), NodePattern.N.lemma("schwarz").withHead("amod", NodePattern.N.lemma("Witwe|Mamba")), NodePattern.N.lemma("a(frikan|siat)isch|indisch").withHead("amod", NodePattern.N.lemma("elefant")), NodePattern.N.lemma("hoch").withHead("amod", NodePattern.N.form("tatra")), NodePattern.N.lemma("(pu|tro[ji]a)nisch|drei(\u00df|ss)igj\u00e4hrig").withHead("amod", NodePattern.N.lemma("krieg")), NodePattern.N.lemma("erst|zweit").withHead("amod", NodePattern.or(NodePattern.N.lemma("weltkrieg"), NodePattern.N.lemma("fernsehen").withDependent("amod", NodePattern.N.lemma("deutsche?")))), NodePattern.N.lemma("zehn").withHead("nummod", NodePattern.N.lemma("gebot")), NodePattern.N.lemma("wilhelminisch").withHead("amod", NodePattern.N.lemma("zeitalter")), NodePattern.N.lemma("chinesisch").withHead("amod", NodePattern.N.lemma("mauer")), NodePattern.N.lemma("(franz\u00f6|rus)sisch").withHead("amod", NodePattern.N.lemma("Revolution")), NodePattern.N.lemma("holsteinisch|fr\u00e4nkisch").withHead("amod", NodePattern.N.lemma("Saale|Schweiz")), NodePattern.N.lemma("s\u00e4chsisch").withHead("amod", NodePattern.N.lemma("Schweiz")), NodePattern.N.lemma("englisch").withHead("amod", NodePattern.N.form("garten").withDependent("det", NodePattern.N.lemma("der"))), NodePattern.N.lemma("h\u00e4ngend").withHead("amod", NodePattern.N.form("g\u00e4rten").withDependent("det", NodePattern.N.lemma("der"))), NodePattern.N.lemma("gro\u00df|klein").withHead("amod", NodePattern.N.lemma("Walachei|Belt")), NodePattern.N.lemma("gro\u00df|klein").withHead("amod", NodePattern.N.lemma("B\u00e4r|Wagen").andOr(NodePattern.N.withHead("appos|nsubj(:pass)?", NodePattern.N.lemma("sternbild")), NodePattern.N.withHead("xcomp", NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.N.lemma("sternbild"))))), NodePattern.N.lemma("transsibirisch").withHead("amod", NodePattern.N.lemma("Eisenbahn")), NodePattern.N.lemma("nah|mittler|fern|weit").withHead("amod", NodePattern.N.lemma("Osten")), NodePattern.N.lemma("statistisch").withHead("amod", NodePattern.N.lemma("(Bund|Land)esamt")), NodePattern.N.lemma("unbefleckt").withHead("amod", NodePattern.N.lemma("Empf\u00e4ngnis")), NodePattern.N.lemma("k\u00f6niglich").withHead("amod", NodePattern.N.lemma("Hoheit")), NodePattern.N.lemma("(inter)?national").withHead("amod", NodePattern.N.lemma("Komitee").withDependent("amod", NodePattern.N.lemma("olympische?"))), NodePattern.N.lemma("olympisch").withHead("amod", NodePattern.N.lemma("Komitee").withDependent("amod", NodePattern.N.lemma("(inter)?nationale?"))), NodePattern.N.lemma("europ\u00e4isch").withHead("amod", NodePattern.N.lemma("Charta|Union|Parlament|Gerichtshof|Patentamt|Wirtschaftsgemeinschaft|Wirtschaftsraum|Kommission|Rat|Zentralbank|Volkspartei|W\u00e4hrungsunion|W\u00e4hrungsfonds|Rechnungshof|Datenschutzgrundverordnung|Investitionsbank")), NodePattern.N.lemma("vereinigt").withHead("amod", NodePattern.N.form("staaten").withDependent("det")), NodePattern.N.lemma("ewig").withHead("amod", NodePattern.N.lemma("Stadt")), NodePattern.N.lemma("pazifisch|indisch|atlantisch|still").withHead("amod", NodePattern.N.lemma("Ozean")), NodePattern.N.lemma("rot|schwarz").withHead("amod", NodePattern.N.lemma("Johannisbeere")), NodePattern.N.lemma("r\u00f6misch").withHead("amod", NodePattern.N.lemma("reich").withDependent("amod", NodePattern.N.lemma("heilige?"))), NodePattern.N.lemma("gelb").withHead("amod", NodePattern.or(NodePattern.N.lemma("engel"), NodePattern.N.form("fluss(es)?|seiten")).and(withDefArticle)), NodePattern.N.form("wiener").withHead("amod", NodePattern.N.lemma("Kongress").withDependent("det", NodePattern.N.lemma("der"))), NodePattern.N.lemma("tot|rot|schwarz").withHead("amod", NodePattern.N.lemma("meer").and(withDefArticle)), NodePattern.N.inFormSequence(2, "kaps?", "der", "guten", "hoffnung"), NodePattern.N.form("deutsche[mnsr]?").withHead("amod", NodePattern.or(NodePattern.N.lemma("Ba(hn|nk)|Bundes(rat|tag)|Gewerkschaftsbund|Fu(ss|\u00df)ball-Bund|Sportpferd|Meister"), NodePattern.N.lemma("Fernsehen").withDependent("amod", NodePattern.N.lemma("erste?|zweite?")), NodePattern.N.lemma("Bund").and(withDefArticle), NodePattern.N.inFormSequence(3, "r\u00f6misch.+", "reich(e?s)?", "deutscher", "nation"))), NodePattern.N.lemma("bayerisch").withHead("amod", NodePattern.N.lemma("Fernsehen|Fu(\u00df|ss)ballverband|Landesamt|Motorenwerke|Rh\u00f6n|Rundfunk|Staatskanzlei|Verwaltungsgericht(shof)?|Verfassung|Wald")), NodePattern.N.lemma("(dominikan|tschech|t\u00fcrk)isch").withHead("amod", NodePattern.N.lemma("Republik")), NodePattern.N.lemma("schief").withHead("amod", NodePattern.N.lemma("Turm").withDependent("nmod", NodePattern.N.form("Pisa|Dausenau|Thorn|Z\u0105bkowice|Frankenstein"))), NodePattern.N.lemma("demokratisch|islamisch").withHead("amod", NodePattern.N.lemma("(Volks)?republik").withDependent("appos", NodePattern.N.lemma("Timor.*|Kongo|Sri|Algerien|Korea|Laos|Iran|Mauretanien|Pakistan").directlyAfterHead())), NodePattern.N.lemma("erst").withHead("amod", NodePattern.N.lemma("mai").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("vom")), NodePattern.N.withDependent("det")).noDependents(NodePattern.N.afterHead()))).and(Capitalization.capitalizeAndSetMessage("Dieses Wort wird als Teil eines Eigennamens gro\u00dfgeschrieben"));
    }

    private static NodePattern wrongCapitalization() {
        return NodePattern.N.formCaseSensitive("[Ww]hatsapp").and(SpellingRules.typoReplacement("WhatsApp"));
    }

    private static NodePattern capitalizeAndSetMessage(String defaultMessage) {
        return NodePattern.N.andOptionally(NodePattern.N.noLabel(".*").andNot(NodePattern.N.inFormSequence(1, "messers", "schneide")).andOr(NodePattern.N.withDependent("case|det(:poss)?"), NodePattern.N.withHead("conj", NodePattern.N.withDependent("case|det(:poss)?"))).andOr(NodePattern.N.withDependent("compound", NodePattern.N.form(".*\\p{L}.*").andNot(NodePattern.or(ordinalToTwelve, SemanticRules.group)).noForm("herr|frau|gr[o\u00f6]\u00df.*").noPos("EIG.*").withOnlyDependents(NodePattern.N.withHeadRelation("det")).directlyBeforeHead().markAs("CompoundStart")), NodePattern.N.withDependent("advmod", NodePattern.N.pos("ZUS").directlyBeforeHead().markAs("CompoundStart")))).and((n, match) -> {
            Node compoundStart = match.findMarkedNode("CompoundStart");
            if (compoundStart != null) {
                String w1 = compoundStart.lowForm();
                String w2 = n.lowForm();
                StreamEx candidates = StreamEx.of((Object[])new String[]{w1 + w2, w1 + "s" + w2}).append(w1.endsWith("ens") ? w1.substring(0, w1.length() - 3) + "s" + w2 : null).nonNull().map(StringTools::uppercaseFirstChar);
                TreeSupport support = n.tree().treeSupport();
                for (String candidate : candidates) {
                    if (!support.tagToken(candidate).hasPos(".*") || !support.isAcceptedBySpellchecker(candidate)) continue;
                    return match.withCorrector(NodeCorrector.replaceNodes(compoundStart, n, candidate)).withMessage("Sollten diese W\u00f6rter zusammengeschrieben werden?");
                }
            }
            return match.withCorrector(CommonPatterns.capitalizeNode(n)).withMessage(defaultMessage);
        });
    }

    private static NodePattern derWievielteNoun() {
        return NodePattern.N.formCaseSensitive("wievielt(e[rsmn]?)").withHeadRelation("nsubj|ob[lj]|root").withDependent("det|case", NodePattern.N.directlyBeforeHead()).message("\u201eWievielte\u201c ersetzt ein ausgelassenes Nomen (z.\u00a0B. Tag, Person) und wird deshalb gro\u00dfgeschrieben").correct(NodeCorrector.regexReplace("w(ievielt.*)", "W$1"));
    }

    private static NodePattern nounCapitalization() {
        NodePattern capitalizedHasMorpho = NodePattern.or(CommonPatterns.capitalizedHasPos(".*"), noMorphoNoun);
        NodePattern nextToSoftHyphen = NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.form("\u00ad").noSpaceBefore()), NodePattern.N.directlyAfter(NodePattern.N.form("\u00ad").noSpaceAfter()));
        NodePattern jaNein = NodePattern.N.form("ja|nein");
        return NodePattern.N.formCaseSensitive("[a-z\u00e4\u00f6\u00fc\u00df]+").markAs("LowerCase").andNot(nextToSoftHyphen).andOr(NodePattern.N.noLemma("andere|letzte|erste|meist|wenig|einig|einzeln|solch|gleich|zur\u00fcck").andNot(Capitalization.decapitalizeSpecificPhrases()).andOr(NodePattern.N.noPos("ZAL").andNot(cardinal), NodePattern.N.pos("ZAL").withDependent("det(:poss)?", NodePattern.N.pos("ART:IND.*"))).noPotentialPos("ART.*").andNot(NodePattern.N.pos("PRO:IND.*").withHead(NodePattern.N.pos("ADJ:PRD:GRU"))).andNot(NodePattern.N.pos("PRO.*").noDependents("det.*").noDependents("amod")).andNot(NodePattern.N.lemma("mal").withDependent("nummod", NodePattern.N.directlyBeforeHead())).andNot(bisZumGehtNichtMehr).andNot(WordSeparation.compoundNounWithInFrage).andNot(NodePattern.N.inFormSequence(1, "ein", "paarmal")).andNot(NodePattern.N.inFormSequence(1, "zu", "viel|wenig").withDependent("det")).andNot(NodePattern.N.onlyPos("ADV:(LOK|TMP)").andOr(NodePattern.N.form(".*s").noDependents("det"), NodePattern.N.withDependent("case", NodePattern.not(AdjDeclination.anyFusedPreposition)))).andNot(NodePattern.custom(n -> {
            List<Node> quotes = n.tree().getCached(treeQuotes);
            return !quotes.isEmpty() && quotes.stream().filter(i -> i.isAfter((Node)n)).count() % 2L != 0L;
        })).noForm("paar|hunderten?|tausenden?|dutzenden?").andNot(NodePattern.N.directlyAfter(CommonPatterns.closingParen.noSpaceAround().directlyAfterHead().withHead(NodePattern.N.directlyAfter(CommonPatterns.openingParen)))).andOr(NodePattern.or(Capitalization.capitalizeVerb(), Capitalization.capitalizeAdj(), Capitalization.capitalizeNounByDependents(), Capitalization.capitalizeFoodItemsNoDependents()).andNot(NodePattern.N.withDependent("conj").andOr(NodePattern.N.withDependent("flat|appos"), NodePattern.N.withDependent("punct", NodePattern.or(GermanTreePatterns.anyQuotation, NodePattern.N.form("[({})]"))), NodePattern.N.pos("PA2.*"), NodePattern.N.pos("ADJ.*").noDependents("det", etwasNichtsVielWenig).withDependent("conj", NodePattern.N.withDependent("amod")))).andOr(NodePattern.N.noDependents("i?obj|obl"), withNominalDependent.withDependent("i?obj|obl"), NodePattern.N.beforeHead()).andOr(withDependentAm, NodePattern.N.noDependents("aux.*"), withCopula, NodePattern.N.noPos("VER:([123]|INF|PA2).*"), NodePattern.N.pos("ADJ.*").withDependent("case", AdjDeclination.anyFusedPreposition)).andOr(NodePattern.N.noDependents("compound"), NodePattern.N.withDependent("compound", CommonPatterns.withNumberLikeForm), NodePattern.not(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.HYPHEN_NODE, CommonPatterns.SOFT_HYPHEN_NODE, GermanTreePatterns.englishWord)))).noDependents("case|det", NodePattern.or(NodePattern.N.form("als").andNot(NodePattern.N.withHead("case", NodePattern.or(NodePattern.N.withHead("nmod", NodePattern.N.pos("SUB:.*")), NodePattern.N.withHeadRelation("obl"), NodePattern.N.form("vielfaches")))), NodePattern.N.anyMatchUntil("LowerCase", NodePattern.PUNCT.andNot(CommonPatterns.HYPHEN_LIKE_NODE)))).andNot(NodePattern.N.pos("VER:INF.*").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("au(\u00df|ss)er|statt|ohne")), NodePattern.N.withDependent("obj", NodePattern.N.directlyBeforeHead()))).andNot(NodePattern.N.pos("ADV.*").withHeadRelation("advmod").noDependents("amod|case")).andNot(NodePattern.N.withHeadRelation("conj").andOr(NodePattern.N.withDependent("punct", CommonPatterns.HYPHEN_LIKE_NODE.directlyBeforeHead()), NodePattern.or(NodePattern.N.withDependent("xcomp"), NodePattern.N.withDependent("conj", NodePattern.N.form("Tags?"))), NodePattern.N.pos("PA2.*").withDependent("nmod", NodePattern.N.pos("ADJ:PRD:GRU")))).andNot(NodePattern.N.noPos("(SUB|ADJ).*").withHead("conj", NodePattern.N.withHeadRelation("amod"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(1, "wie", "lange"))).andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("list", CommonPatterns.lowerCase))).andNot(CommonPatterns.beforeSlashOrParenth).andOr(NodePattern.N.pos("(PA[12]|ADJ).*").form(".+e[sm]"), NodePattern.or(NodePattern.N.anyPos(), noMorphoNoun).noPos("(PRO|PRP).*").andOr(NodePattern.N.withDependent("det.*"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition)), looksLowerCaseNoun).and(capitalizedHasMorpho), Capitalization.capitalizeNounBySyntacticRole().and(capitalizedHasMorpho)).andNot(NodePattern.N.withHead("conj", NodePattern.N.onlyPos("ADV.*").withDependent("case", NodePattern.N.directlyBeforeHead()))).andNot(jaNein.andNot(WordSeparation.withDependentsDetCaseAmod).andNot(NodePattern.N.withHead("conj", jaNein.and(WordSeparation.withDependentsDetCaseAmod)))).andNot(NodePattern.N.form("weg").withDependent("advmod", NodePattern.N.form("etwas").directlyBeforeHead()).withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("vo[nm]")))), Capitalization.capitalizeCopulaHead(), Capitalization.capitalizeSpecificPhrases(), Capitalization.capitalizeSie(), Capitalization.capitalizeIhnen(), Capitalization.capitalizePaar()).andNot(NodePattern.N.form("recht").directlyAfter(SpellingRules.zu).withHead(WordSeparation.verbsWithPrefixZurecht));
    }

    private static NodePattern capitalizeVerb() {
        return NodePattern.N.pos("VER:INF.*").andOr(NodePattern.or(NodePattern.N.withDependent("det(:poss)?", NodePattern.N.pos(".*SIN:NEU.*")), NodePattern.N.withDependent("case|advmod", AdjDeclination.anyFusedPreposition).andNot(ordinalToTwelve), NodePattern.N.withDependent("case", NodePattern.N.form("mit")), withDependentAm, NodePattern.N.withDependent("nmod", CommonPatterns.firstChildPhrase.and(GermanTreePatterns.possessiveLikePronounForm)), NodePattern.N.inFormSequence(0, "l(\u00fc|ue)gen", "(ge)straf.*"), NodePattern.N.withDependent("amod", NodePattern.N.pos("ADJ.*:SIN:.*SOL|PRO:.*"))).andNot(NodePattern.N.withDependent("mark", NodePattern.N.pos("KON:UNT|ADV:.*"))).andNot(compoundWithAdj).andOr(NodePattern.not(NodePattern.ROOT), withCopula, NodePattern.N.withDependent("det", NodePattern.N.pos("ART:IND.*"))), withDependentAm).and(Capitalization.capitalizeAndSetMessage("Substantivierte Verben werden gro\u00dfgeschrieben"));
    }

    private static NodePattern capitalizeAdj() {
        NodePattern adjNeutral = NodePattern.N.pos("(PA[12]|ADJ).*(SIN|PLU).*").form(".+e[sm]");
        NodePattern etwasAdj = adjNeutral.andNot(NodePattern.N.withHead("amod", NodePattern.N.pos("(SUB|EIG).*"))).andOr(NodePattern.N.withHeadRelation("obj|xcomp").noDependents(NodePattern.N.beforeHead()), NodePattern.N.directlyAfter(etwasNichtsVielWenig.noDependents("det(:poss)?")), NodePattern.N.withDependent("det", etwasNichtsVielWenig), NodePattern.N.inFormSequence(2, "ni(chts|x)|etwas", "allzu|ganz", ".*"));
        return NodePattern.or(etwasAdj, adjNeutral.withHead("conj", etwasAdj), NodePattern.N.pos("ADJ.*").form("vielfaches").withDependent("det|case", NodePattern.N.directlyBeforeHead()), NodePattern.N.form("folgendes").withHeadRelation("nsubj"), NodePattern.N.inFormSequence(1, "mit", "folgendem").withHeadRelation("obl"), NodePattern.N.pos("(ADJ|PA2).*").andOr(NodePattern.N.form(".+e").withDependent("det", NodePattern.N.form("manches|alles")), NodePattern.N.form(".+e").withDependent("det", NodePattern.N.form("das")).andOr(withCopula.withDependent("nsubj", NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.form("das|es"), SpellingRules.noun.noPos(".*NEU.*"))), NodePattern.N.form(".*(fach|bar)e|ganze|wichtige|sch\u00f6ne|schlimme"), NodePattern.N.form("richtige").withHead("obj", NodePattern.N.lemma("machen|tun")), NodePattern.N.form("innere").withDependent("nmod"), NodePattern.N.inFormSequence(0, "blaue", "vom", "himmel"), NodePattern.N.pos(".*SUP.*").noDependents("nmod", NodePattern.N.pos(".*NEU.*")).withHeadRelation("nsubj.*|obj")), NodePattern.N.withHead("a(dv)?mod", NodePattern.N.form("alles")).directlyAfterHead().noPos(".*PRD.*"), NodePattern.N.form(".+e").directlyAfter(NodePattern.N.form("das|manches|alles")).withHead("amod", NodePattern.N.pos("PA2:PRD.*")), NodePattern.N.withHeadRelation("vocative"), NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("compound|nummod", CommonPatterns.withNumberLikeForm.beforeHead().noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)), NodePattern.ROOT.withDependent("det", NodePattern.N.pos("(ART:DEF|PRO:POS).*").directlyBeforeHead().markAs("Article")).withDependent("cop").withDependent("nsubj", NodePattern.N.pos("ART:DEF.*")), NodePattern.N.pos("PA2.*").form(".+es").withDependent("case", NodePattern.N.directlyBeforeHead()), NodePattern.N.withHead("nsubj", NodePattern.N.pos("VER.*").noPos("SUB.*").noHeadRelation("conj").noDependents("ob[jl]")).withDependent("det", NodePattern.N.pos("ART:DEF.*").directlyBeforeHead()).noDependents(NodePattern.N.afterHead())), NodePattern.N.pos("ADJ.*(GRU|KOM).*").noPos("VER:.*").noPos(".*:PRD:.*").andOr(NodePattern.or(NodePattern.N.withHead("ob[lj]|nsubj.*", NodePattern.not(NodePattern.N.withHeadRelation("conj"))), NodePattern.ROOT).and(withNominalDependent).noDependents("det", NodePattern.N.form("das|manches|alles")).noDependents("case", NodePattern.N.form("als")).and(capitalizedHasTrueNounMorpho), NodePattern.N.form("(viel|mehr|zig)faches").withDependent("det"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition).andOr(NodePattern.ROOT, NodePattern.N.noDependents(NodePattern.N.pos(".*:PLU:.*").afterHead()).andNot(NodePattern.N.withHead(NodePattern.ROOT.andNot(GermanTreePatterns.clause)).directlyBeforeHead()).andNot(NodePattern.N.withNextSibling(GermanTreePatterns.headInQuotes)))).andNot(adjBeforeAfterAdj).noDependents("flat|conj").andNot(excludeAdj).andNot(NodePattern.ROOT.noDependents("aux|cop")).andNot(NodePattern.N.form("fett").withHead(NodePattern.N.lemma("f(\u00fc|ue)gen"))).noForm("n\u00e4chst.*")).andNot(folgendWithHeadParataxis).and(Capitalization.capitalizeAndSetMessage(ADJ_CAPITALIZATION_MSG));
    }

    private static NodePattern capitalizeNounByDependents() {
        NodePattern inflectedNumber = NodePattern.or(NodePattern.N.pos("ZAL"), NodePattern.N.form(".+en?").and(n -> {
            String form = n.lowForm();
            String base = form.substring(0, form.length() - (form.endsWith("en") ? 2 : 1));
            return n.tree().treeSupport().tagToken(base).hasPos("ZAL");
        }));
        NodePattern notInCompound = NodePattern.not(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceBefore())).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceAfter()));
        NodePattern oneOfOblArguments = NodePattern.N.withHeadRelation("obl").andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obl")), NodePattern.N.withNextSiblingIncludingOtherSide(NodePattern.N.withHeadRelation("obl")));
        NodePattern ptcpCanBeCapitalized = NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.form("das")), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition), capitalizedHasTrueNounMorpho);
        NodePattern capitalizeAdjLike = NodePattern.or(NodePattern.N.lemma("neugeboren|alternativ"), NodePattern.N.form("beste").withDependent("det").withDependent("cop").noDependents("nsubj", NodePattern.N.noPos("PRO:PER.*")).andNot(NodePattern.N.withHead("xcomp", NodePattern.N.withDependent("nsubj"))), NodePattern.N.lemma("jung").pos(".*SUP.*").withDependent("det").withDependent("cop").noDependents("nmod"), NodePattern.N.form("tropfen").withHeadRelation("amod").directlyAfter(NodePattern.N.form("letzte[rn]|kein(en)?|einzige[rn]")), NodePattern.N.form("gewissen").withDependent("det(:poss)?|amod"));
        return NodePattern.or(NodePattern.N.onlyPos("VER:[123].*").withDependent("cop"), capitalizeAdjLike, NodePattern.or(withNominalDependent.andOr(NodePattern.N.noPos("ADJ.*"), CommonPatterns.capitalizedHasPos("SUB.*(MAS|NEU|FEM|INF|PLU:NOG)")), NodePattern.N.withDependent("aux.*")).andNot(excludeAdj), NodePattern.N.withHeadRelation("obj|nmod").andOr(NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.pos("ADJ:[^P].+|ADV:MOD"), NodePattern.N.noPos())), NodePattern.N.withDependent("compound")), NodePattern.not(withNominalDependent).withHeadRelation("nsubj.*"), conjAfterTrueNoun, conjBeforeTrueNoun).andNot(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)").withDependent("case").noForm("dunkel")).noPos("PRO:PER.*").andOr(NodePattern.N.form("tradition(en)?"), NodePattern.not(GermanTreePatterns.englishWord).noForm("helle[mnrs]?"), GermanTreePatterns.englishWord.andOr(NodePattern.N.withDependent("det.*", NodePattern.N.pos("PRO.*|ART.*")).noDependents("flat"), NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.pos("ADJ.*"), NodePattern.N.noPos())), NodePattern.N.withDependent("compound", NodePattern.N.beforeHead()), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition), NodePattern.N.withDependent("acl"), NodePattern.N.anyPos().withDependent("case", NodePattern.N.anyPos().noDependents()), conjAfterTrueNoun, conjBeforeTrueNoun).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("appos"))).noHeadRelation("parataxis").andNot(NodePattern.N.directlyAfter(NodePattern.N.noPos().and(GermanTreePatterns.englishWord)))).andOr(NodePattern.N.noPos(), NodePattern.N.pos("VER.*"), NodePattern.N.form("jenseits|zeit").noHeadRelation("nmod"), NodePattern.or(NodePattern.N.noPos("(ADJ:.*:(SIN|PLU).*|.*:SUP:.*|ABK.*)"), capitalizeAdjLike).andOr(NodePattern.not(NodePattern.N.onlyPos("PRP:.*")), looksLowerCaseNoun.noForm("wegen")).andOr(NodePattern.N.noPos("PA[12]:.*"), ptcpCanBeCapitalized).noForm("mehr|weniger|dpa").andOr(NodePattern.N.noPos("ADJ:PRD:GRU"), NodePattern.not(NodePattern.N.directlyAfter(NodePattern.N.form("als|f(\u00fc|ue)r")))).noDependents("flat", NodePattern.N.directlyAfterHead()).andNot(oneOfOblArguments).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("amod|appos|mark"))).andOr(NodePattern.not(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nmod"))), conjBeforeTrueNoun).andOr(NodePattern.not(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("advmod"))), NodePattern.N.withDependent("det.*").withDependent("amod|case"))).andOr(NodePattern.not(NodePattern.ROOT.withDependent("nsubj|conj")).pos("VER.*").noPotentialPos("(PA2|ADJ).*").noDependents("mark").andOr(NodePattern.not(NodePattern.N.withHeadRelation("xcomp")), NodePattern.N.withDependent("det.*|(a|num)mod|case", NodePattern.N.directlyBeforeHead())), NodePattern.N.pos("ADJ:.*").withDependent("det.*|(a|num)mod|case", NodePattern.N.directlyBeforeHead()).andOr(NodePattern.N.noPos(".*:PRD:.*"), looksLowerCaseNoun), NodePattern.or(NodePattern.not(CommonPatterns.skipConjUp(NodePattern.or(NodePattern.N.withHeadRelation("advcl|[xc]comp|parataxis"), NodePattern.ROOT))), withNominalDependent.andNot(NodePattern.N.withHeadRelation("xcomp").withDependent("obj"))).noPos("VER:.*PRT:SFT|ADJ.*")).andNot(NodePattern.N.pos("VER:INF.*").withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noHeadRelation("xcomp").noDependents("cop|case").andNot(NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("case"))).andOr(NodePattern.N.withDependent("det(:poss)?", NodePattern.N.noPos(".*NEU.*")), NodePattern.N.withDependent("amod", NodePattern.N.withDependent("det(:poss)?", NodePattern.N.noPos(".*SIN:NEU"))))).and(notInCompound).andNot(compoundWithAdj).andNot(GermanTreePatterns.whWord).andNot(NodePattern.N.pos("PA2:PRD.*").inFormSequence(2, "das", "m\u00f6gliche", ".+")).noDependents("punct", NodePattern.N.form("\"")).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()).pos(".*INF.*")).andNot(NodePattern.N.withDependent("nsubj(:pass)?").noDependents("cop|nmod")).andNot(NodePattern.N.withHeadRelation("nsubj(:pass)?").withDependent("obl").noDependents("cop")).noHeadRelation("acl|discourse").andNot(NodePattern.N.noDependents("cop").noDependents("det(:poss)?", NodePattern.N.directlyBeforeHead()).withHead("conj", GermanTreePatterns.clause.withHeadRelation("root|a(dv)?cl|ccomp").withDependent("nsubj(:pass)?|ob[jl]|iobj"))).andNot(NodePattern.N.withHeadRelation("xcomp").withDependent("i?obj|obl")).andNot(NodePattern.N.withHead("compound", NodePattern.N.pos("ZAL"))).andNot(inflectedNumber).andNot(NodePattern.N.inFormSequence(1, "zu", "Folge")).andNot(zumal.andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.form("Mal")))).andNot(zeitlang).andNot(WordSeparation.mass.directlyBefore(NodePattern.or(WordSeparation.wordsStartingWithMass, WordSeparation.halten))).andNot(WordSeparation.alleNaselang).and(Capitalization.capitalizeAndSetMessage(CAPITALIZATION_MSG));
    }

    private static NodePattern capitalizeFoodItemsNoDependents() {
        return SemanticRules.food.andNot(WordSeparation.withDependentsDetCaseAmod).noHeadRelation("compound").and(Capitalization.capitalizeAndSetMessage(CAPITALIZATION_MSG));
    }

    private static NodePattern capitalizeNounBySyntacticRole() {
        NodePattern verbObject = NodePattern.N.withHead("ob[jl]|iobj", NodePattern.N.pos("VER.*")).noPos("(KON|VER:AUX).*").andNot(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)").withDependent("case", NodePattern.N.form("nach"))).andOr(NodePattern.N.noPos("VER:(INF|EIZ):.*"), NodePattern.N.withHead(NodePattern.N.noLemma("lieben|m\u00f6gen|w\u00fcnschen")).noDependents("case", NodePattern.N.form("statt"))).andOr(NodePattern.N.noForm("fett").noPos("(ADV|VER:MOD).*").andOr(NodePattern.N.noPos("PRP.*"), NodePattern.N.form("zeit").noDependents()).andNot(NodePattern.N.pos("ADJ:PRD.*").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("als")), NodePattern.N.withDependent("advmod"))), NodePattern.N.withDependent("det.*"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition), NodePattern.N.withDependent(".*", NodePattern.N.form("k?ein(e[rmns]?)?"))).noDependents("fixed|ob[jl]|iobj|nsubj|mark").andNot(CommonPatterns.capitalizedHasPos(".*ADJ"));
        NodePattern nmod = NodePattern.N.withHeadRelation("nmod").andOr(NodePattern.N.withDependent("case", NodePattern.not(SpellingRules.comparisonNotNounHead)).noDependents("advmod").andOr(NodePattern.N.noPos("ADJ:.*"), NodePattern.N.noDependents("conj")).andNot(NodePattern.N.form("wegen").withOnlyDependents(NodePattern.N.withHeadRelation("case"))).noForm("bar").anyPos().noPos("VER:INF.*"), NodePattern.N.withDependent("det", NodePattern.N.form("de[sr]")).and(CommonPatterns.capitalizedHasPos("SUB:GEN:.*")), NodePattern.N.pos("PRO:IND.*"));
        NodePattern nsubj = withNominalDependent.withHeadRelation("nsubj.*").andOr(conjBeforeTrueNoun, NodePattern.not(CommonPatterns.capitalizedHasPos(".*ADJ")));
        NodePattern obl = NodePattern.N.withHeadRelation("obl").withDependent("det(:poss)?").withOnlyDependents(NodePattern.N.withHeadRelation("det(:poss)?|[an]mod|case")).andNot(NodePattern.N.onlyPos("ADJ.*"));
        return NodePattern.or(verbObject, nmod, nsubj, obl, NodePattern.ROOT.andOr(NodePattern.N.withDependent("case|det(:poss)?", NodePattern.N.pos("(PRP|ART|PRO:(RIN|POS)).*")).noDependents("nsubj(:pass)?|i?obj|obl|nmod|compound").noPos("(ADJ|PRP).*").noLemma("schonen"), NodePattern.N.withDependent("det(:poss)?").withDependent("cop").noPos("(ADJ|PRP|VER:INF).*")), NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("cc|det|amod|nmod")).withDependent(".*").andOr(NodePattern.N.withHead("conj", NodePattern.or(NodePattern.or(CommonPatterns.capitalized, NodePattern.N.pos("PRO:PER.*")).withHeadRelation("(ob[jl]|iobj|nsubj.*)"), nsubj, nmod, verbObject)), NodePattern.N.withHead("conj", NodePattern.N.pos("VER:.*")).withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("obj"))).and(looksLowerCaseNoun.pos("VER:INF:SFT")))).andNot(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)").directlyAfter(NodePattern.N.withHeadRelation("case").directlyAfter(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)")))).andNot(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)").directlyBefore(NodePattern.N.withHeadRelation("case").directlyBefore(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)")))).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(beforeHyphen).andNot(adjBeforeAfterAdj).noDependents("compound|flat").noDependents("punct", NodePattern.N.form("[(){}\\[\\]]")).andNot(GermanTreePatterns.englishWord.withDependent("punct", GermanTreePatterns.anyQuotation)).noPos("(PA[12]|ABK|INJ|NEG).*").andOr(NodePattern.N.anyPos().noPos("(ADJ|ADV|PRO|ZUS|PRP|KON).*"), NodePattern.N.noPos("(ADJ|PRO:DEM).*").andOr(NodePattern.N.withDependent("det.*", NodePattern.N.beforeHead()).withDependent("amod", NodePattern.N.beforeHead()), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition.markAs("Prep")).noDependents("advmod", NodePattern.N.after("Prep")), looksLowerCaseNoun.noForm("(erst|zwei|drei|vier|f\u00fcnf|sechs|sieben|acht|neun|zehn|elf|zw\u00f6lf|dutzend|zwanzig|hundert|tausend|paar)mal|mitten").noForm("all")), NodePattern.N.pos("ADJ.*").andOr(NodePattern.N.form("folgendes").andOr(NodePattern.N.withDependent("det.*"), NodePattern.N.noDependents()), NodePattern.N.form("((\u00fc|ue)brig|best)es").withDependent("det.*"), NodePattern.N.form("ersteres|letzteres|folgendes|neues|altes").withDependent("case", NodePattern.N.form("um")), capitalizedHasTrueNounMorpho), NodePattern.N.lemma("(nie|je)mand").withDependent("det").noHeadRelation("iobj")).andNot(zumal).andNot(NodePattern.N.inFormSequence(1, "an", "Hand").directlyBefore(WordSeparation.vonOrGen)).andNot(zeitlang).andNot(WordSeparation.mass.directlyBefore(NodePattern.or(WordSeparation.wordsStartingWithMass, WordSeparation.halten))).andNot(WordSeparation.alleNaselang).andNot(folgendWithHeadParataxis).and(Capitalization.capitalizeAndSetMessage(CAPITALIZATION_MSG));
    }

    private static NodePattern capitalizeCopulaHead() {
        return NodePattern.N.pos("(SUB|VER).*").noPos("(ZAL|ART|ADJ|.*PA).*").withDependent("nsubj").withDependent("cop").noDependents("case|obj").noDependents("punct|mark", NodePattern.N.directlyBeforeHead()).and(capitalizedHasTrueNounMorpho).and(Capitalization.capitalizeAndSetMessage(CAPITALIZATION_MSG));
    }

    private static NodePattern capitalizeSpecificPhrases() {
        NodePattern clauseAdv = NodePattern.N.withHead("advmod", GermanTreePatterns.clause.noPos("PA2.*"));
        NodePattern npWithAusStart = NodePattern.N.withHead("case|det", NodePattern.N.withDependent("amod", NodePattern.N.withDependent("nmod|obl", NodePattern.N.withDependent("case", NodePattern.N.alreadyMarkedAs("Aus")))));
        NodePattern afterArticlePronomenOrAdj = NodePattern.N.directlyAfter(NodePattern.N.pos("(ART:(DEF|IND)|ADJ|PRO:DEM).*").withHeadRelation("det|amod|nsubj"));
        NodePattern dolmetscher = NodePattern.ROOT.lemma("Dolmetscher|\u00dcbersetzer|Sprachmittler");
        return NodePattern.or(NodePattern.N.inFormSequence(1, "((\u00fcber)?morgen|heute|(vor)?gestern)", "((nach|vor)?mittag|abend|nacht|morgen)"), SemanticRules.job.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|xcomp"), NodePattern.N.form("weg").withNextSibling(NodePattern.N.withHeadRelation("obl").withDependent("case", NodePattern.N.form("vorm?"))), eineHandvoll, NodePattern.N.pos("PRO:POS.*").withDependent("det", NodePattern.N.form("das")), NodePattern.N.form("acht").withDependent("case", NodePattern.N.form("in")).withHead("obl", NodePattern.N.lemma("nehmen")), NodePattern.N.form("((.*deutsch|(alt)?irisch|.*(alban|amhar|arab|aserbaidschan|bask|belarus|bengal|bulgar|chines|d(\u00e4|ae)n|engl|estn|finn|franz(\u00f6|oe)s|f(\u00e4|ae)r(\u00f6|oe)|galic|georg|griech|g(\u00e4|ae)l|haitian|hebr(\u00e4|ae)|holl(\u00e4|ae)nd|indones|isl(\u00e4|ae)nd|italien|japan|javan|jidd|katalan|kirgis|korean|kreol|kurd|lett|litau|luxembourg|malai|maltes|mazedon|mongol|niederl(\u00e4|ae)nd|norweg|paschtun|pers|poln|portugies|rum\u00e4n|russ|serb|singhales|slowak|slowen|span|tadschik|tamil|thail(\u00e4|ae)nd|tschech|turkmen|t(\u00fc|ue)rk|uigur|ukrain|ungar|vietnames|walis)isch))en").withDependent("case", NodePattern.N.form("vom")), NodePattern.or(SemanticRules.languageName, SemanticRules.germanDialect).andOr(NodePattern.N.withHead("advmod|obj", NodePattern.N.lemma("sprechen|lernen")), CommonPatterns.skipConjUp(NodePattern.N.withDependent("case").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")), NodePattern.ROOT.withDependent("cop").withDependent("nsubj", NodePattern.N.form(".*sprache")), NodePattern.N.withDependent("amod"), NodePattern.or(NodePattern.N.withHeadRelation("dep|advmod").directlyAfter(NodePattern.N.lemma(".*(Stunde|Fach)")), NodePattern.N.withHead("appos", SpellingRules.noun).directlyAfterHead(), NodePattern.N.withHeadRelation("nsubj(:pass)?"), NodePattern.N.withHead("xcomp", NodePattern.N.lemma("machen|lehren")), NodePattern.N.withHead("advmod", NodePattern.N.lemma("geben")), NodePattern.N.withHead("compound", SpellingRules.noun), NodePattern.N.withHead(dolmetscher).afterHead(), NodePattern.N.withHead("conj", NodePattern.N.withHead(dolmetscher)).afterHead()).andNot(WordSeparation.withDependentsDetCaseAmod)), NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)").andOr(NodePattern.N.withHead("appos", NodePattern.N.form("farbe")), clauseAdv.withDependent("conj", NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)")), NodePattern.N.withHead("conj", NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)").and(clauseAdv))), NodePattern.N.form("liebe[sr]?").withHead("appos|advmod", NodePattern.N.form("ciao|gr(ue|\u00fc)zi|h(allo|i|ey)|na|moin|servus|morgen|abend|nacht|mittag")).directlyAfterHead(), NodePattern.N.form("grad").withDependent("nummod"), imGrossenUndGanzen, NodePattern.N.inFormSequence(2, "eine", "menge", ".+es"), NodePattern.N.inFormSequence(1, "eines", "besseren").withHead("obj", NodePattern.N.lemma("belehren")), NodePattern.N.inFormSequence(2, "aus", "dem", "vollen").withHead("obl", NodePattern.N.lemma("sch\u00f6pfen")), NodePattern.N.inFormSequence(2, "(Karl|Alexander|Friedrich)s?", "de[rs]", "gro\u00dfen?").withDependent("det").withOnlyDependents(NodePattern.N.withHeadRelation("det")), NodePattern.N.inFormSequence(2, "(Karl|Alexander|Friedrich)s", "des", "gro\u00dfen").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("SUB:GEN:SIN:(MAS|NEU).*"))), NodePattern.N.form("weitere?n|\u00f6ftere?n").withDependent("det", NodePattern.N.form("des")), NodePattern.N.form("ernst").withDependent(".*", NodePattern.N.pos("PRO:POS.*")), NodePattern.N.lemma("inner").withDependent("amod", NodePattern.N.lemma("tief")), NodePattern.N.form("oder").withHead("conj|dep", NodePattern.N.lemma("frankfurt")), NodePattern.N.form("besten").withDependent("case", NodePattern.N.form("zum")).withHead("obl", NodePattern.N.lemma("geben")), NodePattern.N.form("fr(\u00fc|ue)he?").withDependent("case", NodePattern.N.form("in")).withDependent("det"), NodePattern.N.form("(lebend|tot)en").withDependent("case", NodePattern.N.form("unter")).withDependent("det"), NodePattern.N.form("gr\u00fc\u00dfen").withDependent("case", NodePattern.N.form("mit")).withDependent("a(dv)?mod", NodePattern.N.directlyBeforeHead()), NodePattern.N.form("(aller)?sch\u00e4rfste").withDependent("case", NodePattern.N.form("aufs?")).withHead("obl", NodePattern.N.lemma("verurteilen")), NodePattern.N.form("trockenen").withDependent("case", NodePattern.N.form("im")).withDependent("cop"), NodePattern.N.form("guten").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("von")).withHead("nmod", NodePattern.N.form("eine[sr]?")), NodePattern.N.withDependent("case", NodePattern.N.form("zu")).withHead("obl|xcomp", NodePattern.N.lemma("geh\u00f6ren"))).withDependent("det"), NodePattern.N.form("schlimmsten?").andOr(NodePattern.N.withDependent("det"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition)).withHead("obl|xcomp", NodePattern.or(NodePattern.N.lemma("vorbereiten"), NodePattern.N.lemma("rechnen"), NodePattern.N.lemma("bereiten").withDependent("compound:prt", NodePattern.N.form("vor")), NodePattern.N.lemma("gehen").withDependent("compound:prt", NodePattern.N.form("aus")), NodePattern.N.lemma("ausgehen"))), NodePattern.N.form("gr(\u00f6|oe)bsten?").withDependent("det").withDependent("case", NodePattern.N.form("durch|mit")), NodePattern.N.form("pfeife|schlampe|hure|zicke").withDependent("nsubj", NodePattern.N.form("du")), NodePattern.N.form("trockenen").withDependent("det", NodePattern.N.form("dem")), NodePattern.N.form("frische").withDependent("amod", NodePattern.N.lemma("alt")), NodePattern.N.inFormSequence(2, "gl(\u00fc|ue)ck", "de[rs]", "t(\u00fc|ue)chtigen"), NodePattern.N.form("weil").directlyBefore(NodePattern.N.form("am").directlyBefore(NodePattern.N.form("rhein").markAs("Head"))).withHead(NodePattern.N.alreadyMarkedAs("Head")), NodePattern.N.inFormSequence(1, "zu", "schaden").withHead(NodePattern.N.lemma("kommen")), NodePattern.N.inFormSequence(0, "angst", "und", "bange").withHead(NodePattern.N.lemma("machen")), NodePattern.N.inFormSequence(2, "angst", "und", "bange").withHead("conj", NodePattern.N.withHead(NodePattern.N.lemma("machen"))), NodePattern.N.inFormSequence(1, "als", "n\u00e4chstes").withHead(NodePattern.or(NodePattern.N.form("machen|tun"), NodePattern.N.form("nehmen").withDependent("obl", NodePattern.N.inFormSequence(1, "in", "angriff")))), NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.form("vorsicht"))).directlyBefore(NodePattern.N.form("!")), NodePattern.N.inFormSequence(1, "aufs", "gleiche").noHeadRelation("amod"), NodePattern.N.inFormSequence(2, "auf", "dem", "laufenden").noHeadRelation("amod"), NodePattern.N.form("verbleibenden?").withDependent("det", NodePattern.N.form("allen?")).directlyBefore(NodePattern.N.pos("VER:.*")), NodePattern.N.inFormSequence(1, "bei", "rot|gr(\u00fc|ue)n|gelb").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("PA2:(AKK|DAT):.*"))), AgreementSet.wasFuer.withDependent("det", NodePattern.N.directlyBeforeHead()), NodePattern.N.form("dank").andOr(NodePattern.N.withHead(NodePattern.N.form("sei")), NodePattern.N.inFormSequence(2, "gott", "sei", "dank"), NodePattern.N.directlyAfter(NodePattern.N.form("vielen"))), NodePattern.N.form("leid").withDependent("amod", NodePattern.N.directlyBeforeHead()), NodePattern.N.form("m(\u00fc|ue)he").withHead(NodePattern.N.lemma("geben")), NodePattern.N.form("ernst").withHead("xcomp", NodePattern.N.lemma("machen")), NodePattern.N.form("schmiere").withHead("advmod|xcomp", NodePattern.N.lemma("stehen")), NodePattern.N.form("schnupfen").withDependent("aux", NodePattern.N.lemma("haben")), NodePattern.N.form("nachts").withDependent("det", NodePattern.N.form("(d|ein)es")), NodePattern.N.form("gr\u00fc(ss|\u00df)e.*").withDependent("amod"), NodePattern.N.form("nutzen").andOr(NodePattern.N.withHead(NodePattern.N.lemma("ziehen")), NodePattern.N.withDependent("case", NodePattern.N.form("von")).withDependent("cop"), NodePattern.N.directlyAfter(NodePattern.N.lemma("ziehen"))), NodePattern.N.form("falten").withHead(NodePattern.N.lemma("werfen")), NodePattern.N.form("wache").withHead(NodePattern.N.lemma("halten")), NodePattern.N.form("k\u00fcrzeren").withHead(NodePattern.N.lemma("ziehen")), NodePattern.N.form("muss").withDependent("det"), NodePattern.N.form("zur\u00fcck").withDependent("nmod", NodePattern.N.form("kein.*")), NodePattern.N.form("recht").andOr(NodePattern.N.withHeadRelation("advmod").withDependent(".*", NodePattern.N.form("zu")), NodePattern.N.withDependent("case", NodePattern.N.form("im")).withDependent("cop")), NodePattern.N.form("zack").withDependent("case", NodePattern.N.form("auf")), NodePattern.N.form("wert").withHead(NodePattern.N.lemma("legen")), NodePattern.N.form("k\u00f6pfe").withHead(NodePattern.N.lemma("rollen")), NodePattern.N.form("nichts").andOr(NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition), NodePattern.N.withDependent("det")), NodePattern.N.inFormSequence(1, "das|im|ins", "heute").directlyBefore(NodePattern.PUNCT).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.withHeadRelation("cop"))), NodePattern.N.inFormSequence(1, "zu", "kreuze").withHead(NodePattern.N.lemma("kriechen")), NodePattern.N.form("abstand").withHead(NodePattern.N.lemma("nehmen|halten")), AgreementSet.substantivizedAdj.and(withNominalDependent).withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andNot(amSuperlative), NodePattern.N.form("quatsch").andOr(NodePattern.N.withHead(NodePattern.N.lemma("machen")), NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("det"))), NodePattern.N.form("schuld").andOr(NodePattern.N.withHead(NodePattern.N.lemma("tragen|schieben|weisen|haben|geben")).noDependents("cop"), NodePattern.N.withDependent("case", NodePattern.N.directlyBeforeHead()), NodePattern.N.withDependent("nmod", NodePattern.N.pos("PRO:RIN.*").directlyBeforeHead()), NodePattern.N.inFormSequence(1, "keiner", ".*", "bewusst")), NodePattern.N.form("gr\u00fcnen?").withDependent("det").andOr(NodePattern.N.withHead("obj", NodePattern.N.lemma("w\u00e4hlen")), NodePattern.N.withHead("iobj", NodePattern.N.lemma("geben"))), NodePattern.N.form("kl\u00fcgere").withHead(NodePattern.or(NodePattern.N.lemma("geben").withDependent("compound:prt", NodePattern.N.form("nach")), NodePattern.N.lemma("nachgeben"))), NodePattern.N.form("(\u00e4|ae)rger").withHead(NodePattern.N.lemma("machen").noDependents("obj")), NodePattern.N.inFormSequence(0, "milde", "walten").withHead(NodePattern.N.lemma("lassen")), NodePattern.N.form("ende").andOr(NodePattern.N.withHeadRelation("ob[jl]|a(dv)?mod").noDependents(), NodePattern.ROOT.withDependent("nmod", NodePattern.N.onlyPos(".*GEN.*")).noDependents("nsubj.*")), NodePattern.N.inFormSequence(1, "zu", "grabe").withHead(NodePattern.N.lemma("tragen")), NodePattern.N.inFormSequence(2, "in", "(man|sol)che[rn]?", ".*").andNot(NodePattern.N.withHeadRelation("a(dv)?mod")), NodePattern.N.form("\u00fcbel").directlyAfter(NodePattern.N.pos("ADJ.*")).withNeighbor(-2, NodePattern.N.pos("ART.*")), NodePattern.N.form("n\u00f6tigsten").withDependent("case", NodePattern.N.form("a[mn]")), NodePattern.N.form("aus").markAs("Aus").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("i(m|ns)").andNot(npWithAusStart).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE).noSpaceBefore())), NodePattern.N.directlyAfter(NodePattern.N.form("geplante|besiegelte")), NodePattern.N.directlyAfter(NodePattern.N.form("das|de[smn]|([mds]ein|ihr|unser|eue?r)(e[ms]?)?").andNot(npWithAusStart)).directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("case"), NodePattern.N.withHeadRelation("advmod"), NodePattern.N.pos("PRO:POS:GEN.*").withHead("det(:poss)?", NodePattern.N.lemma("Mannschaft"))))).andNot(NodePattern.N.withHead("compound:prt", NodePattern.N.lemma("sehen"))).andNot(NodePattern.N.directlyAfterHead().withHead("fixed", NodePattern.N.withDependent("case", NodePattern.N.form("vo[nm]")))), NodePattern.N.lemma("dritte").withDependent("amod", NodePattern.N.lemma("lachend")), NodePattern.N.inFormSequence(1, "an", "dritte"), NodePattern.N.inFormSequence(1, "Rechte", "dritter"), NodePattern.N.lemma("dritte").withDependent("det", NodePattern.N.form("der")).withHead("nsubj", NodePattern.N.lemma("freuen")), NodePattern.or(NodePattern.N.lemma("letzte|einzig"), ordinalToTwelve).and(CommonPatterns.skipConjUp(NodePattern.or(NodePattern.or(NodePattern.N.withHeadRelation("nsubj"), NodePattern.ROOT.withDependent("cop").withDependent("nsubj", NodePattern.N.noDependents("det(:poss)?"))).withDependent("det", NodePattern.N.pos(".*DEF.*")).withDependent("acl").noDependents("nmod"), NodePattern.N.withHeadRelation("xcomp").noDependents(), NodePattern.N.form(".+en").withDependent("case", NodePattern.N.form("am"))))), NodePattern.N.inFormSequence(0, 2, "lug", "und", "trug"), NodePattern.N.inFormSequence(0, "hin", "und", "her").withDependent("det|amod"), NodePattern.N.inFormSequence(2, "hin", "und", "her").withHead("conj", NodePattern.N.withDependent("det|amod")), NodePattern.N.form("std").withDependent("nummod").directlyBefore(CommonPatterns.dot.noSpaceBefore()), NodePattern.N.inFormSequence(0, "auf", "und", "ab").and(afterArticlePronomenOrAdj), NodePattern.N.inFormSequence(2, "auf", "und", "ab").withHead("conj", afterArticlePronomenOrAdj), NodePattern.N.inFormSequence(0, "ein", "und", "alles").withNeighbor(2, NodePattern.N.markAs("Conj")).withDependent("conj", NodePattern.N.alreadyMarkedAs("Conj")), NodePattern.N.inFormSequence(2, "ein", "und", "alles").withNeighbor(-2, NodePattern.N.markAs("Head")).withHead("conj", NodePattern.N.alreadyMarkedAs("Head")), NodePattern.N.form("bescheid").withHead("compound:prt|obj", NodePattern.N.lemma("wissen|sagen|geben|erhalten|tun")), NodePattern.N.inFormSequence(0, 2, "h\u00f6ren", "und", "sehen").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")))).and(CommonPatterns.capitalize()).message(CAPITALIZATION_MSG);
    }

    private static NodePattern capitalizeSie() {
        NodePattern capitalizedSie = NodePattern.N.formCaseSensitive("Sie").andNot(CommonPatterns.firstToken);
        return NodePattern.N.form("sie").markAs("Sie").andOr(NodePattern.N.withHead("nsubj.*", NodePattern.or(NodePattern.ROOT, NodePattern.N.withHead("conj", NodePattern.N.withDependent("nsubj", capitalizedSie))).andOr(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.withHeadRelation("discourse|punct|cc"), NodePattern.N.form("so").withHead(NodePattern.N.withPhraseEnd(NodePattern.N.form("[!?]"))), NodePattern.N.withHeadRelation("advcl|parataxis").withDependent("nsubj", capitalizedSie))).andOr(NodePattern.N.noDependents("punct", NodePattern.N.form("\\?")), NodePattern.markedNodeMatches("Sie", NodePattern.N.directlyBefore(CommonPatterns.lastToken.form("\\?")))), NodePattern.N.withDependent("aux", GermanTreePatterns.firstInPhraseAfterCommasOrConj.form("(k\u00f6nnt|m\u00f6cht|h\u00e4tt|w\u00fcrd)en"))).pos("VER:INF.*").noForm("haben|sind|werden").noHeadRelation("advcl").andNot(NodePattern.N.withDependent("obj", NodePattern.N.pos("PRO:IND.*NOM.*"))).noDependents("conj", NodePattern.N.noDependents("nsubj", capitalizedSie))), NodePattern.N.withHead(NodePattern.N.withHeadRelation("discourse"))).and(CommonPatterns.capitalize()).message("Die Anrede \u201eSie\u201c wird gro\u00dfgeschrieben");
    }

    private static NodePattern capitalizeIhnen() {
        return NodePattern.N.inFormSequence(2, "darf|d\u00fcrfte|kann|k\u00f6nnte", "ich", "ihnen").withHead(NodePattern.ROOT.pos(".*INF.*").withDependent("aux", NodePattern.or(CommonPatterns.firstWord, NodePattern.N.directlyAfter(CommonPatterns.firstWord.and(GermanTreePatterns.whPhrase)))).directlyBefore(CommonPatterns.lastToken.form("\\?"))).and(CommonPatterns.capitalize()).message("Die Anrede \u201eIhnen\u201c wird hier gro\u00dfgeschrieben");
    }

    private static NodePattern capitalizePaar() {
        return NodePattern.N.form("paar").andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nummod")), NodePattern.N.withDependent("amod").withDependent("det", NodePattern.N.pos(".*IND.*")), NodePattern.N.withHead("det|nmod", NodePattern.N.lemma(".*(schuh|socke|strumpf|stiefel|sandale)"))).and(CommonPatterns.capitalize()).message("\u201ePaar\u201c wird gro\u00dfgeschrieben, wenn es um genau zwei Dinge oder Personen geht");
    }

    private static NodePattern lowercasedAcceptedBySpeller() {
        return NodePattern.custom(n -> {
            TreeSupport support = n.tree().treeSupport();
            return support.isAcceptedBySpellchecker(n.lowForm()) || !support.isAcceptedBySpellchecker(n.form());
        });
    }

    private static NodePattern decapitalization() {
        return canBeLowercased.andOr(NodePattern.or(Capitalization.decapitalizeVerb(), Capitalization.decapitalizeAdj(), Capitalization.decapitalizeConjunction(), Capitalization.decapitalizedCardinalNumbers(), NodePattern.or(Capitalization.decapitalizeAdverb(), Capitalization.decapitalizePreposition(), Capitalization.decapitalizePronoun()).andNot(NodePattern.N.label(".*").noForm("((\u00fcber)?morgen|heute|(vor)?gestern)").andOr(NodePattern.N.directlyAfter(NodePattern.N.noLabel(".*")), NodePattern.custom(node -> {
            Node prevNode = node.prevNode();
            return prevNode == null || node.nerLabel() != prevNode.nerLabel();
        })))).andOr(Capitalization.lowercasedAcceptedBySpeller(), GermanTreePatterns.englishWord, NodePattern.N.withDependent("conj")), Capitalization.decapitalizeSpecificPhrases()).andNot(Capitalization.capitalizeSpecificPhrases()).andNot(NodePattern.custom(node -> ((StreamEx)node.back().skip(1L)).allMatch(n -> NodePattern.PUNCT.matches((Node)n)))).andNot(CommonPatterns.insideQuotes.andOr(NodePattern.N.directlyAfter(NodePattern.or(GermanTreePatterns.anyQuotation, NodePattern.N.form(","))), NodePattern.N.label(".*"))).and((compoundPrefix, match) -> {
            Node head = match.findMarkedNode("NominalHead");
            Node possibleCompoundAdj = match.findMarkedNode("possibleCompoundAdj");
            if (GermanTreePatterns.englishWord.matches(compoundPrefix) && GermanTreePatterns.englishWord.matches(head)) {
                return null;
            }
            NodeCorrector decapitalizeCompoundPrefix = NodeCorrector.rawReplace(compoundPrefix.textRange(), compoundPrefix.lowForm());
            if (possibleCompoundAdj != null) {
                CompoundAdjKind adjKind = Capitalization.seemsCompoundAdj(compoundPrefix, possibleCompoundAdj);
                if (adjKind == CompoundAdjKind.withLinkingElement) {
                    return match.withCorrector(decapitalizeCompoundPrefix.join(NodeCorrector.rawReplace(possibleCompoundAdj.textRange(), possibleCompoundAdj.lowForm())));
                }
                if (adjKind == CompoundAdjKind.pure) {
                    return match.withCorrector(decapitalizeCompoundPrefix);
                }
                return null;
            }
            return match.withCorrector(decapitalizeCompoundPrefix);
        });
    }

    @Nullable
    private static CompoundAdjKind seemsCompoundAdj(Node compoundPrefix, Node possibleCompoundAdj) {
        String adj = possibleCompoundAdj.lowForm();
        TreeSupport support = compoundPrefix.tree().treeSupport();
        for (int i = 2; i < adj.length() - 2; ++i) {
            String newAdj;
            String substring = adj.substring(0, i);
            String capitalizedSubstring = StringTools.uppercaseFirstChar((String)substring);
            if (!support.tagToken(capitalizedSubstring).hasPos("(SUB|ADJ|VER).*")) continue;
            String secondPart = adj.substring(substring.length());
            String newCompound = compoundPrefix.lowForm() + secondPart;
            if (secondPart.matches("(e|s|ens?|er|es).*") && support.tagToken(newAdj = secondPart.replaceFirst(linkingElement, "")).hasPos("ADJ.*")) {
                return CompoundAdjKind.withLinkingElement;
            }
            if (!support.tagToken(newCompound).hasPos("ADJ.*") && !support.isAcceptedBySpellchecker(newCompound)) continue;
            return CompoundAdjKind.pure;
        }
        return null;
    }

    private static NodePattern decapitalizeSpecificPhrases() {
        NodePattern withDativeDependent = NodePattern.N.withDependent("i?obj", NodePattern.N.pos(".*:DAT:.*"));
        NodePattern angstWithIObj = NodePattern.N.form("angst").andOr(NodePattern.N.withHead("nsubj", withDativeDependent.lemma("werden|sein")), withDativeDependent.withDependent("cop"));
        NodePattern zumEinen = NodePattern.N.inFormSequence(1, "zum", "Einen").markAs("ZumEinen").andOr(NodePattern.N.withHead("obl", NodePattern.N.noDependents("obl", NodePattern.not(NodePattern.N.alreadyMarkedAs("ZumEinen")))), NodePattern.N.withHeadRelation("amod")).noDependents(NodePattern.N.withHeadRelation("acl"));
        return NodePattern.or(angstWithIObj, WordSeparation.nullkommanichts.andNot(WordSeparation.withImBeforeHead), NodePattern.N.inFormSequence(1, "herzlich", "willkommen"), NodePattern.N.inFormSequence(1, "auf", "ewig").withHead("obl", GermanTreePatterns.clause), NodePattern.N.form("spanisch").withHead("xcomp", NodePattern.or(NodePattern.N.lemma("vorkommen"), NodePattern.N.lemma("kommen").withDependent("compound:prt", NodePattern.N.form("vor")))), NodePattern.N.form("viertel|halb").withDependent("appos", NodePattern.N.pos("ZAL").directlyAfterHead()), NodePattern.N.inFormSequence(1, "k?ein", "bi(ss|\u00df)chen"), NodePattern.N.inFormSequence(1, "in", "bar"), NodePattern.N.inFormSequence(1, "zu", "gute").directlyBefore(NodePattern.N.lemma("kommen")), NodePattern.N.inFormSequence(1, "mit", "freundlichen", "gr\u00fc(ss|\u00df)e.*"), NodePattern.N.form("willen").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("um")).andOr(NodePattern.N.withDependent("nmod", NodePattern.N.beforeHead()), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.form(".+er"))), NodePattern.N.withDependent("nmod", NodePattern.N.beforeHead().withDependent("case", NodePattern.N.form("um")))), NodePattern.N.form("englisch.+").withHead("amod", NodePattern.N.lemma("Rasen")), NodePattern.N.form("(schwarz|gr\u00fcn).+").withHead("amod", NodePattern.N.lemma("Tee")), NodePattern.N.form("(klein|gro\u00df).+").withHead("amod", NodePattern.N.lemma("Einmaleins")), NodePattern.N.form("recht.+").withHead("amod", NodePattern.N.lemma("Winkel")), NodePattern.N.form("elektrisch.+").withHead("amod", NodePattern.N.lemma("Feld(st\u00e4rke|konstante)")), NodePattern.N.form("mittler.+").withHead("amod", NodePattern.N.lemma("(Bildungs|Schul)abschluss")), NodePattern.N.form("olympisch.+").withHead("amod", NodePattern.N.lemma("Gedanke|Feuer|Eid")), NodePattern.N.form("offen.+").withHead("amod", NodePattern.N.lemma("T\u00fcr").withHead("nmod", NodePattern.N.lemma("Tag"))), NodePattern.N.form("ernst").noDependents().withHead("obj", NodePattern.N.lemma("nehmend?")), NodePattern.N.form("wohl").withHead(NodePattern.N.lemma("leben")), NodePattern.N.form("wurst").noDependents("det(:poss)?").withDependent("cop"), NodePattern.N.form("teil").noDependents().withHead(NodePattern.N.lemma("nehmen")).andNot(NodePattern.N.directlyBeforeHead()), NodePattern.N.form("kopf").noDependents().withHead(NodePattern.N.lemma("stehen")), NodePattern.N.form("freund").withDependent("cop").andOr(NodePattern.N.noDependents("det(:poss)?|[an]mod"), NodePattern.N.withDependent("det", NodePattern.N.onlyPos(".*DAT.*"))), NodePattern.N.form("preis").withHead(NodePattern.N.lemma("geben")).noDependents(".*"), NodePattern.N.form("bange").withHead("conj", angstWithIObj), NodePattern.N.form("mal").withHead(NodePattern.N.pos("VER:(INF|IMP).*").noDependents("aux(:pass)?")).withOnlyDependents(NodePattern.N.withHeadRelation("det").form("das")), SpellingRules.paarIndeclinable, NodePattern.N.form("leid").noDependents().withHead("obj", NodePattern.N.lemma("tun")).andNot(NodePattern.N.directlyBeforeHead()), NodePattern.N.formCaseSensitive("Schuld").withDependent("cop").noDependents("det.*|case|amod"), NodePattern.N.form("recht|gram").withDependent("cop").andOr(NodePattern.N.withDependent("iobj|csubj"), NodePattern.N.withDependent("det:poss|nmod", NodePattern.N.pos("PRO.*DAT.*")), NodePattern.N.withDependent("conj", NodePattern.N.pos("ADJ:PRD.*"))).noDependents("case"), NodePattern.N.form("recht").withHead("xcomp|nsubj|obj", NodePattern.N.lemma("machen|geschehen")).noDependents("case").noDependents("det.*", NodePattern.N.pos("PRO:POS.*")), NodePattern.N.form("rechten?").withHead("amod", NodePattern.N.form("zeit|ort")).directlyAfter(NodePattern.or(AdjDeclination.anyFusedPreposition, NodePattern.N.withHeadRelation("det"))), NodePattern.N.form("lachen|reden").withDependent("amod", NodePattern.N.form("gut")).withHead("obj", NodePattern.N.lemma("haben")), NodePattern.N.form("eigen").directlyAfter(NodePattern.N.form("zu").markAs("Zu")).andOr(NodePattern.N.withHead("xcomp", NodePattern.N.lemma("machen")), NodePattern.markedNodeMatches("Zu", NodePattern.N.withHead("xcomp", NodePattern.N.lemma("machen")))), NodePattern.N.form("neune").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root").withDependent("det|nmod", NodePattern.N.form("alle").directlyBeforeHead()), zumEinen.before(zumAnderen).andNot(NodePattern.N.withHead(NodePattern.N.noPos("VER.*").noDependents("cop"))), zumAnderen.after(zumEinen), NodePattern.N.label("LANGUAGE").andNot(NodePattern.N.withDependent("det(:poss)?|amod|case|nmod", NodePattern.N.noForm("als"))).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("typisch")), NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.N.lemma("Staatsangeh\u00f6rigkeit|.*Pass")), NodePattern.N.withHead(NodePattern.N.lemma("klingen")).noHeadRelation("nsubj(:pass)?"), NodePattern.N.withHead("ob[jl]", NodePattern.N.lemma("schreiben")).noDependents().andNot(NodePattern.N.directlyAfter(NodePattern.N.form("nicht"))), NodePattern.N.withHead(NodePattern.N.lemma("unterhalten").withDependent("obj|expl:pv", NodePattern.N.pos("PRO:REF.*"))), NodePattern.N.withHead("advmod", NodePattern.N.lemma("singen|vortragen|deklamieren")))).message("In solchen Kontexten wird \u201e$_\u201c kleingeschrieben");
    }

    private static NodePattern decapitalizeSonntagabends() {
        String dayOfWeek = String.join((CharSequence)"|", GermanDateChecker.INSTANCE.dayNames);
        return canBeLowercased.andOr(NodePattern.N.form("(" + dayOfWeek + "|sonnabend)s?((nach|vor)?mittag|abend|nacht|morgen)s").noDependents(), NodePattern.N.form(partsOfDayAdv).withOnlyDependents(NodePattern.N.form("(" + dayOfWeek + "|sonnabend)s").directlyBeforeHead())).message("Das Adverb \u201e$_\u201c wird kleingeschrieben").and((node, match) -> {
            Object replacement = node.lowForm();
            if (node.hasForm(".+s((nach|vor)?mittag|abend|nacht|morgen)s")) {
                String firstPart = node.lowForm().replaceAll("s((nach|vor)?mittag|abend|nacht|morgen)s", "");
                replacement = firstPart + node.lowForm().substring(firstPart.length() + 1);
            }
            return match.withCorrector(NodeCorrector.rawReplace(node.textRange(), (String)replacement));
        });
    }

    private static NodePattern decapitalizeVerb() {
        return NodePattern.or(NodePattern.or(NodePattern.N.withDependent("nsubj.*", NodePattern.not(CommonPatterns.lowercasedHasPos("ADJ:.*"))).andOr(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("nsubj")), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nsubj")), NodePattern.N.withHeadRelation("a(dv)?cl|[xc]comp|parataxis"), NodePattern.ROOT.withDependent("i?obj|obl")), NodePattern.N.pos("VER:IMP.*").withDependent("discourse"), NodePattern.N.withDependent("ob[jl]").withHeadRelation("conj"), NodePattern.N.withDependent("aux(:pass)?"), NodePattern.N.withDependent("obj", NodePattern.N.pos("VER:MOD.*").lemma("m\u00fcssen")), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()), NodePattern.N.withHead("obj", NodePattern.N.lemma("m\u00fcssen").pos("VER:MOD.*").noDependents(".*", NodePattern.N.pos("VER.*")).noDependents("mark")), NodePattern.N.withHeadRelation("aux|cop")).noDependents("case|det(:poss)?", NodePattern.not(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("nsubj.*")))).noDependents("amod", NodePattern.N.pos("ADJ.*")).noDependents("cop|nmod|appos").and(CommonPatterns.lowercasedHasPos("VER:((MOD|AUX):)?([123]|INF).*")), NodePattern.or(NodePattern.N.withDependent("case", NodePattern.N.form("zu")).noDependents("[an]mod|det").withHead(NodePattern.N.lemma("geben|bekommen")), NodePattern.N.withHead("obj", NodePattern.N.pos("VER:MOD.*").noLemma("lassen")).noDependents("[an]mod|det:poss").andOr(NodePattern.N.withHead(NodePattern.N.withDependent("iobj")), NodePattern.N.noDependents("det")), NodePattern.N.noDependents().withHead("xcomp|dep|obj", NodePattern.N.lemma("gehen"))).and(CommonPatterns.lowercasedHasPos("VER:INF.*")), NodePattern.N.withDependent("nsubj.*|obj").noDependents("det|case").and(CommonPatterns.lowercasedHasPos("VER:PA2:.*")).andNot(NodePattern.N.withHead("nmod|appos", NodePattern.N.withDependent("det(:poss)?")).beforeHead())).andNot(CommonPatterns.lowercasedHasPos("ADJ:.*").withDependent("cop")).message("Verben werden normalerweise kleingeschrieben");
    }

    private static NodePattern decapitalizeAdj() {
        NodePattern nominalHeadsLikeNode = NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root");
        return NodePattern.or(NodePattern.or(NodePattern.N.withHead("compound", nominalHeadsLikeNode.markAs("NominalHead")).noLemma("Viertel").and(beforeHyphen).withDependent("conj", NodePattern.N.markAs("possibleCompoundAdj").directlyBefore(nominalHeadsLikeNode)), NodePattern.ROOT.noPos("ART.*").and(beforeHyphen).withDependent("conj", NodePattern.N.markAs("possibleCompoundAdj").noPos("(VER|SUB).*")).withDependent("cop").noDependents("det"), NodePattern.N.withHead("conj", NodePattern.N.noLabel("EVENT|MISC").withHead("compound|amod", nominalHeadsLikeNode.andNot(etwasNichtsVielWenig).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE)).noLabel("MISC"))).and(CommonPatterns.lowercasedHasPos("ADJ.*")), NodePattern.N.noPos("SUB.*").withHead("conj", beforeHyphen.withDependent("cop").noDependents("det(:poss)?|amod")).noDependents("conj", NodePattern.N.markAs("possibleCompoundAdj").pos("SUB.*"))).noDependents("flat|amod"), NodePattern.N.form("folgend(e[rnsm]?)?").withHeadRelation("amod"), NodePattern.N.withHead("amod", NodePattern.N.withHeadRelation("vocative")), NodePattern.N.inFormSequence(1, "unter", "andere?m"), amSuperlative, NodePattern.or(NodePattern.N.markAs("Adj").andOr(NodePattern.N.withHeadRelation("compound").directlyAfter(NodePattern.N.withHeadRelation("det").form("ein.*")).noLabel("PRODUCT"), NodePattern.N.withHead("amod", NodePattern.or(NodePattern.or(NodePattern.N.noLabel(".*"), NodePattern.N.label("PRODUCT").andOr(NodePattern.N.withDependent("amod", NodePattern.N.label("PRODUCT").form(".+e[mnsr]")), NodePattern.N.noDependents("amod", NodePattern.N.label(".*")).noDependents("nmod", CommonPatterns.capitalized))).andOr(NodePattern.or(NodePattern.N.pos(".*(NOM|AKK).*"), NodePattern.N.noPos()).withHeadRelation("nsubj(:pass)?"), CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("root|i?obj|obl|appos").andNot(NodePattern.N.withHead("appos", NodePattern.N.form("bereich|thema")))), CommonPatterns.skipConjUp(NodePattern.N.withHead("nmod", NodePattern.not(SemanticRules.job).noLemma("professor|komitee|ausschuss|abteilung")))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.label(".*"))).andOr(NodePattern.N.noDependents("det"), NodePattern.N.label("PRODUCT").noDependents("amod", NodePattern.N.label(".*")), NodePattern.markedNodeMatches("Adj", NodePattern.or(NodePattern.N.label("LANGUAGE"), NodePattern.N.withDependent("compound", NodePattern.N.form("\\d+"))))).noDependents("case", AdjDeclination.anyFusedPreposition).noDependents("nmod", NodePattern.N.label(".*")), NodePattern.N.withDependent("det", NodePattern.N.form("ein.*")), SemanticRules.timeUnit.andNot(NodePattern.N.inFormSequence(1, "frei", "tag"))).andNot(etwasNichtsVielWenig).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE))).noLabel("(EVENT|MISC|ORGANIZATION|GEO_POLITICAL_ENTITY)")).andNot(GermanTreePatterns.englishWord.withHead(GermanTreePatterns.englishWord)).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).withHead(NodePattern.N.noLemma("(et)?was|.*(versammlung|komitee|ausschuss|abteilung|b\u00fcro)|hochzeit").noForm("(ober|unter)?(r\u00e4t(in|e)|rat(e?s)?|sekret\u00e4r(in|e|s)?)").noDependents("appos", NodePattern.N.noPos())).andNot(NodePattern.N.inPhrase(NodePattern.N.lemma(".*(versammlung|komitee|ausschuss|abteilung|b\u00fcro)"))).andNot(Capitalization.specialAdjCapitalization()).andNot(NodePattern.or(NodePattern.N.inFormSequence(0, "runde.*", "tisch.*"), NodePattern.N.inFormSequence(0, "klein.*", "waffenschein.*"), NodePattern.N.inFormSequence(0, "gro\u00df.*", "preis"), NodePattern.N.inFormSequence(0, "(gelb|rot)e.*", "karten?"), NodePattern.N.inFormSequence(0, "alte.*", "runen"), NodePattern.N.inFormSequence(0, "maschinelle.*", "lernen"), NodePattern.N.inFormSequence(0, "unverzeihlich.*", "fluch"))), NodePattern.N.withHead("nsubj", NodePattern.N.lemma("sein")).noDependents().andNot(NodePattern.N.form(".*es").directlyAfter(etwasNichtsVielWenig)), CommonPatterns.lowercasedHasPos("ADJ:PRD:GRU").and(CommonPatterns.skipConjUp(NodePattern.N.noDependents("det|flat(:name)?|acl").noDependents("nmod", AgreementSet.possibleGenitiveDependent).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det"))).andOr(NodePattern.or(withCopula.markAs("Adj").withDependent("nsubj", NodePattern.N.pos("PRO:.*").andOr(NodePattern.markedNodeMatches("Adj", NodePattern.N.noForm("stolz")), NodePattern.N.noForm("es|das"))), NodePattern.N.withHead("xcomp", NodePattern.N.noPos(".*AUX.*"))).andNot(withNominalDependent), NodePattern.N.withHead("obl", NodePattern.N.lemma("erkl\u00e4ren").withDependent("obj")).withDependent("case", NodePattern.N.form("f\u00fcr").directlyBeforeHead())))).andOr(NodePattern.N.withHead("conj", CommonPatterns.lowercasedHasPos("ADJ:PRD:GRU|ADV.*")), NodePattern.N.noHeadRelation("conj")), NodePattern.N.noPos().withDependent("cop").noDependents("det(:poss)?|flat").noDependents("nmod", NodePattern.N.lemma("kein")), NodePattern.N.pos("ADJ.*").noPos("SUB.*|.*(NOM|GEN|DAT|AKK).*").withHeadRelation("amod|xcomp|root|ccomp|a(dv)?cl|csubj|parataxis").noLabel(".*").noDependents("det(:poss)?|nmod").andNot(conjAfterTrueNoun)).noDependents("amod", etwasNichtsVielWenig).and(CommonPatterns.lowercasedHasPos("ADJ.*"))).andNot(NodePattern.or(SemanticRules.languageName, SemanticRules.germanDialect, NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)"), imGrossenUndGanzen)).message("Adjektive werden normalerweise kleingeschrieben");
    }

    private static NodePattern decapitalizeAdverb() {
        return NodePattern.or(NodePattern.N.withHead("advmod", NodePattern.not(CommonPatterns.capitalized.withHeadRelation("amod")).noHeadRelation("appos")).andNot(NodePattern.N.inFormSequence(1, "((\u00fcber)?morgen|heute|(vor)?gestern)", "fr\u00fch")), NodePattern.N.withHeadRelation("obl").noDependents(), NodePattern.N.inFormSequence(0, "((\u00fcber)?morgen|heute|(vor)?gestern)", "((nach|vor)?mittag|abend|nacht|morgen)"), NodePattern.N.form("((\u00fcber)?morgen|heute|(vor)?gestern)").withOnlyDependents(NodePattern.N.withHeadRelation("case").directlyBeforeHead().andNot(AdjDeclination.anyFusedPreposition)).withHeadRelation("nmod|obl|root").andNot(NodePattern.N.form("Morgen").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("gegen")), NodePattern.N.withHead(NodePattern.N.pos("VER:(.*PRT.*|PA2:NON)")), NodePattern.N.withHeadRelation("obl").withNextSibling(SpellingRules.noun.withHeadRelation("obl").withDependent("case")))), NodePattern.N.form("(sp\u00e4t|fr\u00fch)?((nach|vor)?mittag|abend|nacht|morgen)s").noDependents("det(:poss)?|amod").andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("det(:poss)?|amod"))), NodePattern.N.formCaseSensitive("Extra").and(AgreementSet.agreementIssues), NodePattern.N.form("links|rechts").andOr(NodePattern.N.withHead("obl", NodePattern.N.lemma("(ab)?(driften|fahren|rutschen)|ausscheren|biegen|blicken|drehen|gehen|gucken|kippen|kommen|laufen|orientieren|schauen|schreiben|swipen")).withDependent("case", NodePattern.N.form("nach|vo[nr]|mit")).noDependents("det(:poss)?|[an]mod"), NodePattern.N.withDependent("case", NodePattern.N.form("mit")).withHead("obl", NodePattern.N.lemma("machen|meistern")), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("abbiegen"))).noDependents("conj", NodePattern.N.pos("SUB.*"))).andNot(beforeHyphen).andNot(SemanticRules.dayOfWeek.noForm(".*s")).andNot(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)").andNot(NodePattern.N.withHead("advmod", NodePattern.N.lemma("f\u00e4rben|unterstreichen")))).and(CommonPatterns.lowercasedHasPos("ADV:.*|ADJ:PRD:GRU|KON:.*")).message("Adverbien werden normalerweise kleingeschrieben");
    }

    private static NodePattern decapitalizeConjunction() {
        return NodePattern.or(NodePattern.N.withHeadRelation("advmod|mark").andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cc|mark|advmod")), NodePattern.N.withHead(NodePattern.N.afterHead())).and(CommonPatterns.lowercasedHasPos("KON:UNT")).message("Konjunktionen werden normalerweise kleingeschrieben"), NodePattern.N.formCaseSensitive("Mal").withHead("nmod", NodePattern.or(NodePattern.N.form("\\d+"), WordSeparation.zahlOrEin)).withDependent("nummod", NodePattern.N.directlyBeforeHead()).message("In mathematischen Ausdr\u00fccken wird \u201emal\u201c kleingeschrieben"));
    }

    private static NodePattern decapitalizedCardinalNumbers() {
        NodePattern zifferOrZahlOrWert = NodePattern.N.lemma(".*(Ziffer|Zahl(wort)?|Wert)");
        NodePattern komma = NodePattern.N.form("Komma");
        NodePattern numericNull = NodePattern.N.form("null");
        NodePattern ausserAcht = NodePattern.N.form("acht").directlyAfter(NodePattern.or(NodePattern.N.form("au(\u00df|ss)er|in"), NodePattern.N.inFormSequence(2, "au", "\\?", "er"))).withHead(NodePattern.N.lemma("lassen|nehmen"));
        return cardinalNumbers.and(CommonPatterns.capitalized).markAs("Anchor").andOr(numericNull.withHeadRelation("n(um)?mod").directlyBeforeHead(), NodePattern.N.withHead(NodePattern.or(NodePattern.N.pos("VER.*"), NodePattern.N.form("Division|Teilbarkeit|konvergier(t?en|te?|t)|teilbar"))).andNot(withCopula), NodePattern.N.withDependent("det", NodePattern.N.pos("PRO:DEM.*").directlyBeforeHead()), NodePattern.ROOT.and(withCopula), NodePattern.N.withDependent("nmod", cardinalNumbers), NodePattern.N.withHead("nmod", cardinalNumbers), NodePattern.N.withHead("conj", NodePattern.N.withDependent("appos", cardinalNumbers)), NodePattern.N.directlyAfterHead().withHead("appos|flat", NodePattern.not(zifferOrZahlOrWert)), NodePattern.or(NodePattern.N.directlyAfter(komma), NodePattern.N.directlyBefore(komma)), NodePattern.N.withHead("obl", NodePattern.N.withHeadRelation("amod").onlyPos("(ADJ|PA2).*")), NodePattern.N.withHeadRelation("nmod").afterHead().noForm("null"), NodePattern.N.withDependent("advmod", NodePattern.N.form("weniger|mehr"))).noDependents("amod").andNot(NodePattern.N.form("null|elf").andNot(NodePattern.N.withHeadRelation("nummod")).andNot(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "und", "nichtig"))).andNot(NodePattern.N.withDependent("case", NodePattern.N.directlyBeforeHead()).directlyBefore(NodePattern.N.withHead("case", cardinalNumbers))).andNot(NodePattern.N.withHead("obj", NodePattern.N.lemma("sein").withDependent("nsubj", cardinalNumbers))).andNot(NodePattern.ROOT.withDependent("cop").withDependent("nsubj", NodePattern.N.beforeHead())).andNot(NodePattern.N.withHead("appos", NodePattern.not(zifferOrZahlOrWert)).directlyAfterHead()).andNot(NodePattern.N.withHeadRelation("obl").andNot(NodePattern.N.withHead(NodePattern.N.lemma("(\u00fcber)?pr\u00fcfen|testen"))).noDependents("case", NodePattern.N.form("bei"))).andNot(numericNull.noDependents().withHead("obj", NodePattern.N.withNextSibling(NodePattern.N.withDependent("obj", NodePattern.N.form("Phase").noDependents()))))).andNot(NodePattern.N.inFormSequence(0, "null", "und", "phase")).andNot(NodePattern.N.withHeadRelation("nsubj").andOr(NodePattern.N.noDependents(), NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("conj")))).andNot(NodePattern.N.inFormSequence(0, "null", "Komma", "Josef")).andNot(NodePattern.N.withHead(zifferOrZahlOrWert.withDependent(".*", cardinalNumbers.noDependents("case")))).andNot(NodePattern.N.withDependent("det", NodePattern.N.pos("ART.*").andNot(NodePattern.N.inFormSequence(1, "an", "die")))).andNot(NodePattern.or(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE), NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE))).andNot(ausserAcht).noDependents("nmod", NodePattern.not(cardinalNumbers)).andNot(NodePattern.N.withDependent("flat", GermanTreePatterns.englishWord.andNot(cardinalNumbers))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("Sauberwisch"))).noDependents("det", NodePattern.N.pos("(PRO:IND|ART:(IND|DEF)).*").andNot(NodePattern.N.inFormSequence(1, "an", "die"))).message("Zahlw\u00f6rter werden normalerweise kleingeschrieben");
    }

    private static NodePattern decapitalizePreposition() {
        return NodePattern.or(NodePattern.N.form("namens").withHead("case|compound", NodePattern.or(NodePattern.N.pos("EIG.*"), NodePattern.N.noPos())).directlyBeforeHead(), NodePattern.N.withHead("case", NodePattern.not(NodePattern.N.withHead("nmod", NodePattern.or(NodePattern.N.withHeadRelation("appos"), NodePattern.N.form("Stra(ss|\u00df)e"))).afterHead())), NodePattern.N.withHeadRelation("nmod|mark"), NodePattern.N.inFormSequence(2, "an", "eides", "statt"), NodePattern.N.inFormSequence(0, "samt", "und", "sonders"), NodePattern.N.form("kraft|zeit").withHeadRelation("obl").noDependents("case").withOnlyDependents(NodePattern.N.afterHead()).andNot(NodePattern.N.noDependents())).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).noDependents("amod|det(:poss)?|nmod:poss|case|nummod").andOr(CommonPatterns.lowercasedHasPos("PRP:.*"), NodePattern.N.form("namens")).message("Pr\u00e4positionen werden normalerweise kleingeschrieben");
    }

    private static NodePattern decapitalizePronoun() {
        NodePattern looksLike3PLVerb = NodePattern.or(NodePattern.N.form(".*[eh']n|ham"), CommonPatterns.lowercasedHasPos("VER(:(MOD|AUX))?:3:PLU.*"));
        return NodePattern.or(NodePattern.or(NodePattern.N.form("(mein|unse?r)(e[mnsr]?)?").withHeadRelation("det:poss"), NodePattern.N.form("jedermanns?|einiges"), NodePattern.or(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root|appos|det|advmod|amod|nmod:poss|dep")).noDependents("det").noDependents("case", AdjDeclination.anyFusedPreposition).andNot(NodePattern.N.inFormSequence(0, "Selbst", "Achtung").directlyAfter(NodePattern.or(NodePattern.N.pos("PRO:IND.*"), NodePattern.N.withHeadRelation("det(:poss)?")))), NodePattern.N.form("bi(ss|\u00df)chen").withDependent("det", NodePattern.N.form("(ei|.*')?n"))).andOr(NodePattern.N.form("ich|mi(r|ch)|wir|uns").andNot(withNominalDependent), NodePattern.N.form("sich"), NodePattern.or(NodePattern.N.noPos(), NodePattern.N.pos("(PRO|SUB):.*")).and(CommonPatterns.lowercasedHasPos("PRO:[^(PER|POS)].*"))).andNot(NodePattern.N.form("man").andOr(NodePattern.not(NodePattern.N.withHeadRelation("nsubj.*")), NodePattern.N.withDependent(".*"))).andNot(NodePattern.N.inFormSequence(1, "partei", "die", "linke")).andNot(NodePattern.N.inFormSequence(0, 2, "ein", "und", "alles")).andNot(NodePattern.N.inFormSequence(0, "den", "haag")).andNot(NodePattern.N.inFormSequence(0, "selber", "w(\u00f6|oe)lfen?")).andNot(NodePattern.N.inFormSequence(0, "Selbst", "Check", "in")).noForm("du|di(ch|r)|dein(e[rsmn]?)?|deinesgleichen|deinerseits|deinetwegen")).andOr(NodePattern.or(CommonPatterns.lowercasedHasPos("PRO:IND.*").withHeadRelation("amod"), CommonPatterns.lowercasedHasPos("ART:DEF.*").withHeadRelation("det")).message("Artikel und Zahlw\u00f6rter werden normalerweise kleingeschrieben"), NodePattern.N.message("Pronomina werden normalerweise kleingeschrieben")), NodePattern.N.form("sie").andOr(CommonPatterns.skipConjUp(NodePattern.N.withHead("obj", Case.mayHaveArg("A:Inanim").noLemma("f\u00fchren|kosten").andNot(NodePattern.N.lemma("sagen").withDependent("ccomp")))), NodePattern.not(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("obj|dep|parataxis")))).andNot(NodePattern.ROOT).noDependents("case|mark").andNot(NodePattern.N.withHead("nsubj.*", NodePattern.or(CommonPatterns.severalDependents("csubj|nsubj"), trueNoun.noDependents("aux(:pass)?|cop"), looksLike3PLVerb.noDependents("aux(:pass)?|cop"), NodePattern.N.withDependent("aux(:pass)?|cop|conj", looksLike3PLVerb).noDependents("aux(:pass)?|cop", NodePattern.not(looksLike3PLVerb).pos("VER.*:[123].*")), NodePattern.N.withHeadRelation("xcomp|discourse")))).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root"))).message(DECAPITALIZATION_SIE_MSG)).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("case|aux.*|expl"))).noHeadRelation("flat.*").andNot(NodePattern.N.withHead("appos", NodePattern.N.noPos("PRO:PER.*"))).noDependents("appos|flat.*");
    }

    private static enum DuStyle {
        low,
        upper;

    }

    private static enum CompoundAdjKind {
        pure,
        withLinkingElement;

    }
}

