/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.common.KnownPhrases;
import ai.grazie.rules.common.MultiWordSpelling;
import ai.grazie.rules.common.ProperNames;
import ai.grazie.rules.common.PunctuationTypos;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Articles;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.DigraphNormalization;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GrammarRules;
import ai.grazie.rules.de.LemmaChanges;
import ai.grazie.rules.de.OldSpelling;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SemCompatibility;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.TreeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

class SpellingRules {
    static final NodePattern to = NodePattern.N.form("to");
    private static final String USE_OF_CONVENTIONAL_FORM_MSG = "M\u00f6chten Sie eine konventionelle Form der Standardsprache verwenden?";
    private static final String ALWAYS_ADVERB_MSG = "ist immer ein Adverb und kann sich nicht auf Sachen oder Personen beziehen";
    static final NodePattern reflexiveProEndsWithEs = NodePattern.N.form("([md]ir|euch|sich)s");
    static final NodePattern lehr = NodePattern.N.form("lehr(en?)?");
    static final NodePattern noun = NodePattern.N.pos("SUB.*");
    static final NodePattern beforeNounHasAux = NodePattern.ROOT.directlyBefore(noun).withDependent("aux").noDependents("obj");
    private static final NodePattern withReflexivePronoun = NodePattern.N.withDependent("obj", ReflexivePronouns.accReflexivPronomen.markAs("Refl"));
    private static final NodePattern withDaran = NodePattern.N.withDependent("advmod|dep", NodePattern.N.form("daran"));
    private static final NodePattern withOblWithCaseAn = NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("an")));
    private static final NodePattern gewohntGewoehnt = NodePattern.or(NodePattern.N.lemma("gewohn(en?|s?t)").and(withReflexivePronoun).andOr(NodePattern.N.withDependent("compound:prt", NodePattern.N.form("ein|a[bn]|aus|um")), withOblWithCaseAn, withDaran).and(SpellingRules.typoRegexReplacement("gewohn(.*)", "gew\u00f6hn$1")), NodePattern.N.form("gew\u00f6hnt").andOr(NodePattern.N.noDependents("xcomp", NodePattern.N.withDependent("mark", NodePattern.N.form("zu"))).andNot(withOblWithCaseAn).andNot(withDaran).andNot(withReflexivePronoun).and(SpellingRules.typoReplacement("gewohnt")), withReflexivePronoun.withDependent("aux(:pass)?", NodePattern.N.lemma("sein").and((node, match) -> {
        Node refl = match.getMarkedNode("Refl");
        return match.withCorrector(NodeCorrector.removeNode(refl)).withCorrector(LemmaChanges.changeOwnVerbLemma("haben").corrector(node));
    })).message("Wenn ein Zustand gemeint ist, entfernen Sie \u201e$Refl\u201c; bei einem Prozess wird \u201ehaben\u201c verwendet")));
    static final NodePattern comparisonNotNounHead = NodePattern.N.form("als|wie").withHead(NodePattern.N.withHead(NodePattern.N.noPos("SUB.*")));
    private static final NodePattern bankStorageCompound = NodePattern.N.form(".*(Daten|(Zentr|Nation)al|(Information|Gesch\u00e4ft|Genossenschaft)s|Kredit|Depot|[KC]ommerz|Reiffeisen|Filial|Noten|Gen|Immobilien|Direkt|Investment|Blut|Gewebe|Organ|Sprach)b\u00e4nken?");
    private static final NodePattern bankSeatCompound = NodePattern.N.form(".*(Sitz|Fenster|Park|Wald|Garten|Baum|Sonnen|Ruhe|Bier|Schul|Werk|Umkleide|Hocker|Trainer|Spieler|Zuschauer|Mitfahrer|Klapp|Holz|Metall)banken?");
    private static final NodePattern bankStorageVsSeat = NodePattern.or(bankStorageCompound.message("Im Sinne von \u201eSpeicherort\u201c lautet der Plural \u201eBanken\u201c; bei Sitzm\u00f6beln dagegen \u201eB\u00e4nke\u201c").correct(NodeCorrector.regexReplace("(.*)b\u00e4nken?", "$1banken")), NodePattern.or(bankSeatCompound.message("Im Sinne von \u201eSitzm\u00f6bel\u201c lautet der Plural \u201eB\u00e4nke\u201c; bei Speicherort dagegen \u201eBanken\u201c"), NodePattern.N.form(".*(Sand|Kies|Schotter)banken?").message("Im Sinne von \u201eAblagerungen im Wasser\u201c lautet der Plural \u201eB\u00e4nke\u201c")).correct(NodeCorrector.regexReplace("(.*)banke(.*)", "$1b\u00e4nke$2")));
    private static final NodePattern geniessen = NodePattern.N.lemma("genie(\u00df|ss)en");
    private static final NodePattern cafeKaffee = NodePattern.N.form("[ck]af(\u00e9|f?ee?)");
    static final NodePattern unlikelyCafeKaffee = cafeKaffee.andOr(NodePattern.N.withHead("obj|nsubj", NodePattern.N.markAs("Predicate")), NodePattern.N.withDependent("amod", NodePattern.N.markAs("Predicate")), NodePattern.N.withDependent("case", NodePattern.N.form("i(ns?|m)")).and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("obl").withHead(NodePattern.N.noDependents("obj").markAs("Predicate"))))).and((node, match) -> SemCompatibility.getCompatibility(node, match.getMarkedNode("Predicate")) == SemCompatibility.Unlikely ? match : null);
    private static final NodePattern aLaPreposition = NodePattern.N.inFormSequence(0, "a", "la").withNeighbor(1, NodePattern.N.markAs("La")).reportEverythingTouched().andNot(NodePattern.N.withHead("flat", NodePattern.N.withDependent("flat", NodePattern.N.label("PERSON")))).andOr(NodePattern.N.withDependent("flat", CommonPatterns.capitalized.label("LANGUAGE").directlyAfter(NodePattern.N.alreadyMarkedAs("La")).includeIntoReport().and((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.textRange(), node.lowForm()).join(NodeCorrector.replace(node.neighbor(-2), "\u00e0"))))), NodePattern.N.correct(NodeCorrector.replace("\u00e0")));
    private static final NodePattern sichAusdruecken = NodePattern.or(NodePattern.N.lemma("ausdrucken"), NodePattern.N.lemma("drucken").withDependent("compound:prt", NodePattern.N.form("aus"))).withDependent("obj|expl.*", NodePattern.or(ReflexivePronouns.accReflexivPronomen, NodePattern.N.lemma("Gef\u00fchl"))).message("Meinten Sie \u201esich ausdr\u00fccken\u201c?").andOr(NodePattern.N.pos("VER:EIZ.*").correct(NodeCorrector.replace("auszudr\u00fccken")), NodePattern.N.pos("VER:PA2.*").correct(NodeCorrector.replace("ausgedr\u00fcckt")), NodePattern.N.correct(NodeCorrector.regexReplace("dru(.*)", "dr\u00fc$1")));
    private static final NodePattern looksLikeNameTitle = NodePattern.or(NodePattern.N.withDependent("flat.*"), NodePattern.N.directlyBefore(NodePattern.N.pos("EIG.*")));
    static final NodePattern withNominalDependents = NodePattern.N.withDependent("det.*|[an]mod");
    private static final NodePattern secondPlSubj = NodePattern.or(NodePattern.N.form("ihr[^\\p{L}]*"), NodePattern.N.withDependent(".*", NodePattern.N.form("ihr")), NodePattern.N.form("du").withDependent("conj"), NodePattern.N.withDependent("conj", NodePattern.N.form("du")));
    static final NodePattern secondPlRoot = NodePattern.or(NodePattern.N.withDependent("nsubj.*", secondPlSubj), NodePattern.or(NodePattern.ROOT, NodePattern.N.withHead(NodePattern.or(NodePattern.N.withDependent("nsubj.*", secondPlSubj), NodePattern.N.noDependents("nsubj.*").pos("VER:2:PLU.*")))).noDependents("nsubj"));
    static final NodePattern paarIndeclinable = NodePattern.N.form("paar").withHead(SemanticRules.timeUnit).beforeHead().directlyAfter(NodePattern.N.form("eine[mnsr]?").noDependents("case").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("case"))));
    static final NodePattern ordinalAfterTwelve = NodePattern.N.form(".+((z|\u00df|ss)igs|zehn)te.*");
    static final NodePattern zal = NodePattern.N.pos("ZAL");
    static final NodePattern numbers = NodePattern.or(zal, Capitalization.ordinalToTwelve, ordinalAfterTwelve);
    static final NodePattern isPrep = NodePattern.N.withHeadRelation("case");
    static final NodePattern zu = NodePattern.N.form("zu");
    private static final String[] ordinalStems0_12 = new String[]{"nullt", "erst", "zweit", "dritt", "viert", "f\u00fcnft", "sechst", "siebt", "acht", "neunt", "zehnt", "elft", "zw\u00f6lft"};
    private static final String[] compoundPartNumbers0_12 = new String[]{"null", "ein", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun", "zehn", "elf", "zw\u00f6lf"};

    SpellingRules() {
    }

    static List<Rule> rules() {
        return List.of(OldSpelling.rule(), new Rule.PatternRule("Spelling.LATIN_CYRILLIC_CONFUSION", "Verwechslung lateinischer und kyrillischer Buchstaben", "Ein Buchstabe geh\u00f6rt zu einem anderen Alphabet.", null, () -> CommonPatterns.latinCyrillicConfusion("Lateinischer", "Kyrillischer", " Buchstabe \u201e%s\u201c in \u201e%s\u201c", "[\u0430-\u044f\u0451\u0456\u0457]", null), new Example("<b>I\u0441h</b> habe Hunger.", "<b>Ich</b> habe Hunger.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.MISPLACED_SPACE", "Falsch gesetztes Leerzeichen", "Ein Leerzeichen ist unn\u00f6tig oder an der falschen Stelle.", null, () -> CommonPatterns.misplacedSpace("Meinten Sie \u201e%s\u201c?", NodePattern.or(GermanTreePatterns.englishWord.andOr(NodePattern.N.form(".{4,}"), NodePattern.N.withNextSibling(GermanTreePatterns.englishWord.withNextSibling(GermanTreePatterns.englishWord))), GermanTreePatterns.nonLatinLetterWord, CommonPatterns.lowercasedHasPos(".*"), WordSeparation.zigfach)), new Example("Auf dem Flughafen <b>wa res</b> warm.", "Auf dem Flughafen <b>war es</b> warm.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.SIMILAR_WORD_CONFUSION", "Leicht verwechselbare W\u00f6rter", "Laut- bzw. schriftbild\u00e4hnliche W\u00f6rter werden leicht verwechselt.", null, () -> SpellingRules.similarWordConfusion(), new Example("Er ist <b>seid</b> letzte Woche bei uns.", "Er ist <b>seit</b> letzte Woche bei uns.")), new DigraphNormalization(), new Rule.PatternRule("Spelling.CONTRACTION_ES", "Auslassen von Buchstaben", "Standardsprachlich gilt die Form mit Apostroph oder die vollst\u00e4ndige Form.", null, () -> SpellingRules.contractionEs(), new Example("Hier <b>gehts</b> zur Bewerbung.", "Hier <b>geht\u2019s</b> zur Bewerbung.", "Hier <b>geht es</b> zur Bewerbung.")), new Rule.PatternRule("Spelling.MISSING_DIACRITICS", "Diakritische Zeichen in Fremdw\u00f6rtern", "Einige Fremdw\u00f6rter behalten im Deutschen ein diakritisches Zeichen.", null, () -> SpellingRules.wordsWithDiacritics(), new Example("Wir gehen ins <b>Cafe</b> an der Ecke.", "Wir gehen ins <b>Caf\u00e9</b> an der Ecke.")), new Rule.PatternRule("Spelling.COMMON_TYPOS", "H\u00e4ufige Tippfehler", "Verwechslung von Buchstaben mit anderen Symbolen, die auf der Tastatur nahe beieinander liegen.", null, () -> NodePattern.or(PunctuationTypos.findCommonTypos("Meinten Sie \u201e%s\u201c?", Map.of("+", "\u00fc", "?", "\u00df", "#", "\u00e4", ",", "m"), "de"), SpellingRules.eszettVsBeta(), SpellingRules.questionMarkInCompounds()), new Example("Sie m\u00fcssen nicht <b>au?er</b> Acht gelassen werden.", "Sie m\u00fcssen nicht <b>au\u00dfer</b> Acht gelassen werden.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.PROPER_NAMES", "Rechtschreibung von Eigennamen", "Gro\u00dfschreibung- und Tippfehler in Eigennamen.", null, () -> SpellingRules.properNames(), new Example("Welche <b>MarkDown</b>-Variante verwenden Sie?", "Welche <b>Markdown</b>-Variante verwenden Sie?"), new Example("Die <b>Kantorsche</b> Paarungsfunktion", "Die <b>Cantorsche</b> Paarungsfunktion")).enableInFlatTrees(), WordSeparation.rule(), new Rule.PatternRule("Spelling.MULTI_WORD", "Rechtschreibung bei mehreren W\u00f6rtern", "Gro\u00dfschreibung- und Tippfehler in verschiedenen Ausdr\u00fccken, die aus mehreren W\u00f6rtern bestehen.", null, () -> new MultiWordSpelling(KnownPhrases.forLanguage(Language.GERMAN)).skipTypoFixes(MultiWordSpelling.DEFAULT_SKIP_TYPO_FIXES.noForm("Beginns|Kantor|Theresas?|Till|Winkel|M\u00fchlheim|Roth?enburg|Stil|Uhrzeiten|Koma|allgemein|zu[mr]?|(halb|g\u00fctlich|friedlich)en|f\u00fcr|wieder|B\u00e4rbock|Trainer|Adams|Stie?l?le|weite[mn]|Muse|Capuccino").noFormCaseSensitive("Fick").andNot(NodePattern.N.form("Ressourcen").withDependent("compound|amod", NodePattern.N.form("Human"))).andNot(NodePattern.N.form("i(m|ns?)").andNot(NodePattern.N.directlyAfter(NodePattern.N.label(".+"))))).pattern("Meinten Sie \u201e%s\u201c?", "Die Standardschreibweise ist \u201e%s\u201c").andNot(NodePattern.N.formCaseSensitive("Cappuccio").label("PERSON")).andNot(NodePattern.N.formCaseSensitive("au").directlyBefore(NodePattern.N.formCaseSensitive("pair"))).andNot(NodePattern.N.formCaseSensitive("Apple").directlyBefore(NodePattern.N.formCaseSensitive("Daily"))).noForm("pods?").andNot(NodePattern.N.formCaseSensitive("Macs|Phone|Watches|[mM]acros")).andNot(NodePattern.N.inFormSequence(0, 1, "einmal", "in|eine?")), new Example("Ich wohne in <b>Garmisch Partenkirchen</b>.", "Ich wohne in <b>Garmisch-Partenkirchen</b>.")), new Rule.PatternRule("Spelling.NUMBERS_AS_COMPOUND_PART", "Ausschreibung von Zahlen in Komposita", "Zahlen in Komposita ausschreiben.", null, () -> NodePattern.or(SpellingRules.spellOutNumbersEinhalb(), SpellingRules.spellOutOrdinalKlaessler()), new Example("Meine sind jetzt <b>20einhalb</b> Wochen alt.", "Meine sind jetzt <b>20,5</b> Wochen alt."), new Example("Die <b>1.</b> Kl\u00e4ssler lernen viel.", "Die <b>Erstkl\u00e4ssler</b> lernen viel.")));
    }

    private static NodePattern eszettVsBeta() {
        NodePattern upperCaseWithBeta = NodePattern.N.formCaseSensitive("\\p{Lu}+\u03b2\\p{Lu}*");
        return NodePattern.N.form("[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]+\u03b2[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\u03b2\\w]*").withSubstringHint("\u03b2").noPos().and((node, match) -> {
            String replacement = node.form().replaceAll("\u03b2", "\u00df");
            Object message = "Der griechische Buchstabe \u201e\u03b2\u201c anstelle von ";
            if (!node.tree().treeSupport().isAcceptedBySpellchecker(replacement)) {
                replacement = node.form().replaceAll("\u03b2", "ss");
                message = (String)message + "\u201ess\u201c";
                if (!node.tree().treeSupport().isAcceptedBySpellchecker(replacement)) {
                    return null;
                }
            } else if (upperCaseWithBeta.matches(node)) {
                replacement = node.form().replaceAll("\u03b2", "SS");
                message = (String)message + "\u201eSS\u201c";
                if (!node.tree().treeSupport().isAcceptedBySpellchecker(replacement)) {
                    return null;
                }
            } else {
                message = (String)message + "\u201e\u00df\u201c";
            }
            return match.withCorrector(NodeCorrector.replace(node, replacement).batchCapable("eszettVsBeta")).enableAutoFix().withMessage((String)message);
        });
    }

    private static NodePattern questionMarkInCompounds() {
        return NodePattern.N.form("\\?").noSpaceAround().directlyAfter(NodePattern.or(NodePattern.N.pos("(SUB|ADJ).*"), GermanTreePatterns.englishWord, WordSeparation.abbrAsPartOfCompound)).directlyBefore(CommonPatterns.letterWord).reportEverythingTouched().andOr(NodePattern.custom((node, match) -> {
            String compound = node.neighbor(-1).form() + "ss" + node.neighbor(1).form();
            if (node.tree().treeSupport().isAcceptedBySpellchecker(compound)) {
                return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node.neighbor(1), compound)).withMessage("Meinten Sie \u201e" + compound + "\u201c?");
            }
            return null;
        }), NodePattern.or(NodePattern.N.directlyBefore(CommonPatterns.lowerCase), NodePattern.N.directlyAfterHead().directlyAfter(NodePattern.or(NodePattern.N.withHead("compound", NodePattern.N.markAs("End")), NodePattern.N.withDependent("flat", NodePattern.N.markAs("End")))).directlyBefore(NodePattern.N.alreadyMarkedAs("End"))).and(SpellingRules.typoReplacement("-")));
    }

    private static NodePattern properNames() {
        NodePattern famousScientists = NodePattern.or(NodePattern.or(NodePattern.N.lemma("kantor").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("mathematikers?")), NodePattern.N.directlyBefore(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.lemma("medaille")))), NodePattern.N.form("kantorsche[mnsr]?").directlyBefore(NodePattern.N.lemma("antinomie|diagonal(verfahren|argument)|diskontinuum|.*funktion|menge(nlehre)?|paradoxie"))).and(SpellingRules.typoRegexReplacement("k(.+)", "C$1")), NodePattern.N.form("leibnitz").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("philosoph(en)?")), NodePattern.N.directlyBefore(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.lemma(".*keks")))).and(SpellingRules.typoReplacement("Leibniz")), NodePattern.N.form("leibnitzsche[mnsr]?").and(SpellingRules.typoRegexReplacement("leibnitzsch(.+)", "Leibnizsch$1")), NodePattern.N.form("lentz").withHead("nmod", NodePattern.N.lemma("regel|gesetz")).and(SpellingRules.typoReplacement("lentz", "Lenz")), NodePattern.N.form("lentz['`\u00b4\u2019]?sche[mnsr]?").withHead("amod", NodePattern.N.lemma("regel|gesetz")).and(SpellingRules.typoRegexReplacement("lent(.+)", "Len$1")), NodePattern.N.form("ru(sell|ssel)sche[mnsr]?").withHead("amod", NodePattern.N.form("antinomie|paradoxon|analyse|typ(hierachie|entheorie)|klasse")).and(SpellingRules.typoRegexReplacement("russ?ell?(.+)", "Russell$1")));
        NodePattern toponyms = NodePattern.or(NodePattern.N.form("Sue?d").withHead("compound", NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root").markAs("Head")).directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceAround().directlyBefore(NodePattern.N.alreadyMarkedAs("Head"))).andOr(NodePattern.N.withNeighbor(2, NodePattern.N.pos("EIG.*COU").message("Meinten Sie \u201eS\u00fcd-\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), n -> List.of("S\u00fcd" + n.anchor().lowForm())))), SpellingRules.typoReplacement("S\u00fcd")), NodePattern.N.form("Mexicos?").label("GEO_POLITICAL_ENTITY").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|appos").noDependents("flat(:name)?|appos|compound").and(SpellingRules.typoRegexReplacement("Mexico(.*)", "Mexiko$1")), NodePattern.N.form("Bulgarias?").label("GEO_POLITICAL_ENTITY").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andNot(CommonPatterns.quotedWord).andNot(NodePattern.N.withDependent("flat|appos|compound", NodePattern.N.noPos())).andNot(NodePattern.N.withHead("nmod", GermanTreePatterns.englishWord.noPos())).and(SpellingRules.typoRegexReplacement("Bulgaria(.*)", "Bulgarien$1")), NodePattern.N.inFormSequence(0, "m\u00fchlheim", "/", "ruhr").and(SpellingRules.typoReplacement("M\u00fclheim")), NodePattern.N.form("rothenburg").withDependent("appos", NodePattern.N.form("w\u00fcmme")).and(SpellingRules.typoReplacement("Rotenburg")), NodePattern.N.form("Lybi(ens?|sch(e[rnms]?)?|er([sn]|in(nen)?)?)").and(SpellingRules.typoRegexReplacement("Lybi(.*)", "Liby$1")), NodePattern.N.form("Meissenern?").andNot(GermanParameters.VARIANT.withValue("CH")).inCloudTree().noHeadRelation("amod").and(SpellingRules.typoRegexReplacement("Meissener(.*)", "Mei\u00dfener$1")), NodePattern.N.inFormSequence(0, "West|Ost", "Berlins?").and((node, match) -> {
            String withHyphen = node.form() + "-" + node.neighbor(1).form();
            String jointSpelling = node.form() + node.neighbor(1).lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), jointSpelling, withHyphen)).withMessage("Meinten Sie \u201e" + jointSpelling + "\u201c?");
        }));
        NodePattern politicians = NodePattern.N.inFormSequence(1, "Manuel", "macrons?").message("Meinten Sie \u201eEmmanuel Macron\u201c?").correct(NodeCorrector.regexReplace("macron(.*)", "Emmanuel Macron$1").join(NodeCorrector.replace(NodePointer.neighbor(-1), "")));
        NodePattern artists = NodePattern.N.inFormSequence(1, "Sofia", "Lorens?").message("Meinten Sie \u201eSophia Loren\u201c?").correct(NodeCorrector.regexReplace("Loren(.*)", "Sophia Loren$1").join(NodeCorrector.replace(NodePointer.neighbor(-1), "")));
        NodePattern companies = NodePattern.N.inFormSequence(0, "J?unit[iy]", "Media").message("Meinten Sie \u201eUnitymedia\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "Unitymedia"));
        NodePattern fritzbox = ProperNames.fixFritzProducts.message("Die Produkte der Marke FRITZ! werden mit einem Ausrufezeichen geschrieben");
        NodePattern openAi = ProperNames.openAI.message("Meinen Sie das Unternehmen \u201eOpenAI\u201c?");
        NodePattern multiWord = NodePattern.or(famousScientists, toponyms, politicians, artists, companies, fritzbox, openAi);
        NodePattern singleWord = NodePattern.or(NodePattern.N.form("J\u00fcchen").and(SpellingRules.typoReplacement("J\u00fclich")), NodePattern.N.form("Feldherrenhalle").and(SpellingRules.typoReplacement("Feldherrnhalle")), NodePattern.N.formCaseSensitive("mark[Dd]own|MarkDown").and(SpellingRules.typoReplacement("Markdown")), NodePattern.N.formCaseSensitive("\\.Net").and(SpellingRules.typoReplacement(" .NET")), CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")).andOr(NodePattern.N.form("html|haml|xml|xsl|css|scss").andNot(NodePattern.N.directlyAfter(CommonPatterns.slash)).andNot(NodePattern.N.directlyBefore(CommonPatterns.slash)).and(SpellingRules.ensureUppercase()), NodePattern.N.formCaseSensitive("[Gg]ifs?").and(SpellingRules.typoRegexReplacement("gif(s)?", "GIF$1")), NodePattern.N.form("jade|slim|sass|less|stylus").withHead("conj", NodePattern.N.form("html|haml|xml|xsl|css|scss")).and(SpellingRules.ensureCapitalized())), NodePattern.N.form("i").directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE.directlyBefore(NodePattern.N.form("p[oa]ds?"))).and((node, match) -> {
            String replacement = "iP" + node.neighbor(2).lowForm().substring(1);
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), replacement)).withMessage("Meinten Sie \u201e" + replacement + "\u201c?");
        }), CommonPatterns.spaceX.message("Meinten Sie das Unternehmen \u201eSpaceX\u201c?"), NodePattern.N.form(".+sch(e|en)?sprache").label("LANGUAGE").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andOptionally(NodePattern.N.directlyBeforeHead().withHead("compound", NodePattern.N.pos("SUB.*").markAs("HeadOfCompound"))).andOptionally(NodePattern.N.withDependent("det", NodePattern.N.markAs("Article"))).and((node, match) -> {
            Node article = match.findMarkedNode("Article");
            Node headOfCompound = match.findMarkedNode("HeadOfCompound");
            String firstPart = node.form().replaceAll("(.+)[Ss]prache", "$1");
            String replacement = firstPart.endsWith("sch") ? firstPart : StringTools.lowercaseFirstChar((String)firstPart) + " Sprache";
            NodeCorrector toNounOrNounPhrase = NodeCorrector.rawReplace(node.textRange(), replacement);
            if (headOfCompound != null) {
                String possibleCompound = firstPart + headOfCompound.lowForm();
                if (!node.tree().treeSupport().tagToken(possibleCompound).hasPos("SUB.*")) {
                    return null;
                }
                match = match.withCorrector(NodeCorrector.replaceNodes(node, headOfCompound, possibleCompound));
            } else {
                match = article != null && firstPart.endsWith("sch") ? match.withCorrector(toNounOrNounPhrase.join(NodeCorrector.removeNode(article))) : match.withCorrector(toNounOrNounPhrase);
            }
            return match.withMessage("Meinten Sie \u201e" + replacement + "\u201c?");
        }));
        return NodePattern.or(multiWord, singleWord);
    }

    private static NodePattern contractionEs() {
        NodePattern noNsubjDasOrEs = NodePattern.N.withDependent("nsubj|expl", NodePattern.N.form("(da|e)s"));
        return NodePattern.N.form(".+s").andOr(NodePattern.not(GermanTreePatterns.englishWord), NodePattern.N.form("(mag|weil|war|mach|sag)s")).andOr(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("ccomp|root|cop").withOptionalDependent("punct", NodePattern.N.form("\\?.*").markAs("QuestionMark"))).noPos().andNot(CommonPatterns.lowercasedHasPos(".*")).andOr(NodePattern.N.noDependents("nsubj"), NodePattern.N.noDependents("obj", NodePattern.N.noForm("uns|euch")).noDependents("xcomp|ccomp").andOptionally(NodePattern.N.withDependent("nsubj", NodePattern.N.pos("PRO:PER:NOM:SIN.*").markAs("Ich")))).noDependents("cop").andNot(noNsubjDasOrEs).andNot(NodePattern.N.withHead("cop", noNsubjDasOrEs)), NodePattern.N.form("(wo(her|hin)?|warum|wer|wem|wenn?|wie)s").withHeadRelation("mark|advmod").markAs("WhWord"), NodePattern.N.form("weils").withHeadRelation("mark"), reflexiveProEndsWithEs.withHeadRelation("i?obj"), NodePattern.N.form("(kann|will|soll|darf)s").withHead("aux", NodePattern.N.noDependents("nsubj", NodePattern.N.pos("PRO:PER:NOM:SIN.*:2.*")))).andNot(CommonPatterns.quotedWord).noForm(".+ss").noDependents("amod|det(:poss)?").and((node, match) -> {
            boolean gibInInterrogativeSentence;
            Node ich = match.findMarkedNode("Ich");
            Node questionMark = match.findMarkedNode("QuestionMark");
            TreeSupport support = node.tree().treeSupport();
            String word = node.lowForm().substring(0, node.form().length() - 1);
            if (match.findMarkedNode("WhWord") == null && !support.tagToken(word).hasPos("(VER|ADV|KON|PRO:REF).*")) {
                return null;
            }
            String possibleVerbFirstSg = word + "e";
            boolean bl = gibInInterrogativeSentence = word.equals("gib") && questionMark != null;
            if (word.endsWith("et") && support.tagToken(word).hasPos(".*KJ1.*")) {
                word = word.replaceFirst("(.+)et", "$1t");
            }
            String verbForm = ich != null && support.tagToken(possibleVerbFirstSg).hasPos("VER:1:SIN.*") || word.contains("w\u00e4r") ? possibleVerbFirstSg : (gibInInterrogativeSentence ? "gibt" : word);
            String toFullForm = support.tagToken(word).hasPos("PRO:REF.*") ? " es " + verbForm : verbForm + " es";
            Object toContractedForm = gibInInterrogativeSentence ? "gibt\u2019s" : word + "\u2019s";
            return match.withCorrector(NodeCorrector.replace(node, new String[]{toContractedForm})).withCorrector(NodeCorrector.replace(node, toFullForm));
        }).message(USE_OF_CONVENTIONAL_FORM_MSG);
    }

    static NodePattern typoReplacement(String ... replacements) {
        return NodePattern.custom((node, match) -> {
            Object message = "";
            ArrayList<NodeCorrector> correctors = new ArrayList<NodeCorrector>();
            for (String replacement : replacements) {
                correctors.add(NodeCorrector.replace(node, replacement));
                message = (String)message + (((String)message).isEmpty() ? "Meinten Sie \u201e" + replacement + "\u201c" : " oder \u201e" + replacement + "\u201c");
            }
            return match.withCorrectors(correctors).withMessage((String)message + "?");
        });
    }

    static NodePattern typoRegexReplacement(String regexp, String replacementRegexp) {
        Pattern pattern = Pattern.compile(regexp, 2);
        return NodePattern.custom((node, match) -> {
            String text = node.form();
            String replacement = pattern.matcher(text).replaceAll(replacementRegexp);
            if (CommonPatterns.capitalized.matches(node)) {
                replacement = StringTools.uppercaseFirstChar((String)replacement.toLowerCase(Locale.ROOT));
            }
            return match.withCorrector(NodeCorrector.replace(node, replacement)).withMessage("Meinten Sie \u201e" + replacement + "\u201c?");
        });
    }

    private static NodePattern ensureCapitalized() {
        return NodePattern.not(CommonPatterns.capitalized).and((node, match) -> {
            String replacement = StringTools.uppercaseFirstChar((String)node.lowForm());
            return match.withCorrector(NodeCorrector.replace(node, replacement)).withMessage("\u201e" + replacement + "\u201c wird gro\u00dfgeschrieben");
        });
    }

    private static NodePattern ensureUppercase() {
        return NodePattern.not(CommonPatterns.upperCase).and((node, match) -> {
            String replacement = node.form().toUpperCase(Locale.ROOT);
            return match.withCorrector(NodeCorrector.replace(node, replacement)).withMessage("\u201e" + replacement + "\u201c wird in Gro\u00dfbuchstaben geschrieben");
        });
    }

    private static NodePattern geminateIssues() {
        NodePattern hasAgreementIssue = NodePattern.custom(node -> {
            AgreementSet set = AgreementSet.createRelaxed(node);
            return set != null && (set.hasGovernmentIssue() || set.hasAgreementIssue());
        });
        return NodePattern.or(NodePattern.N.form("genant.*").withDependent("obj|xcomp").andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.withHead("xcomp", NodePattern.N.lemma("werden"))).and(SpellingRules.typoRegexReplacement("genant(.*)", "genannt$1")), NodePattern.N.form("(durch)?lie(\u00df|ss)t").and(SpellingRules.typoRegexReplacement("(durch)?.+", "$1liest")), NodePattern.N.form("sol").andOr(NodePattern.N.withHeadRelation("aux"), NodePattern.ROOT.noDependents("cop")).and(SpellingRules.typoReplacement("soll")), NodePattern.N.form("wesen").withHeadRelation("amod|det").and(SpellingRules.typoReplacement("wessen")), NodePattern.N.form("wessen").andOr(NodePattern.N.withDependent("det(:poss)?"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition)).withDependent("nmod").and(SpellingRules.typoReplacement("Wesen")), NodePattern.N.form("gebetet").withDependent("obl", NodePattern.N.form("ruhe").withDependent("case", NodePattern.N.form("zur"))).and(SpellingRules.typoReplacement("gebettet")), NodePattern.or(NodePattern.N.inFormSequence(2, "auf", "die", "Wage"), NodePattern.N.inFormSequence(3, "Z\u00fcnglein", "a(n|uf)", "der", "Wage")).and(SpellingRules.typoReplacement("Waage")), NodePattern.N.form("komma").withDependent("case", NodePattern.N.form("i(m|ns)")).and(SpellingRules.typoReplacement("Koma")), NodePattern.N.form("sonnst").withHeadRelation("advmod").and(SpellingRules.typoReplacement("sonst")), looksLikeNameTitle.form("her").and(SpellingRules.typoReplacement("herr")), NodePattern.N.form("we[nm]").andOr(NodePattern.N.withHeadRelation("cc|mark|advmod"), GermanTreePatterns.firstInPhraseAfterCommasOrConj.andOr(NodePattern.N.withHead("i?obj", NodePattern.or(CommonPatterns.severalDependents("obj"), NodePattern.N.withHeadRelation("ccomp").beforeHead()).noDependents("punct", CommonPatterns.questionMark)), NodePattern.N.form("wen").withHead("iobj", NodePattern.N.beforeHead().noDependents("punct", CommonPatterns.questionMark))).noDependents().andNot(NodePattern.N.withHead("i?obj", NodePattern.N.withHeadRelation("csubj")))).and(SpellingRules.typoReplacement("wenn")), NodePattern.N.form("wenn").withHeadRelation("ob[lj]").andNot(GrammarRules.directlyAfterImmer).and(SpellingRules.typoReplacement("wen")), NodePattern.N.form("den").andOr(NodePattern.N.inFormSequence(2, "es", "sei", ".*"), CommonPatterns.firstToken.directlyBefore(NodePattern.N.pos("ART:.*")).noDependents("acl").noHeadRelation("det"), NodePattern.N.withHeadRelation("advmod|discourse|cc|case|fixed"), NodePattern.N.markAs("Den").noDependents().withHead(NodePattern.N.withDependent("obj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Den")))), NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.N.pos("PRO:.*"), NodePattern.N.pos("VER:AUX:.*").directlyAfter(GermanTreePatterns.whPhrase))).andOr(NodePattern.not(NodePattern.N.withHeadRelation("det")), NodePattern.N.withHead(hasAgreementIssue), NodePattern.N.withHead("det", NodePattern.N.withHeadRelation("advmod")))).and(SpellingRules.typoReplacement("denn")), NodePattern.N.form("denn").andOr(NodePattern.N.withHead("i?obj|obl", Case.definitelyTransitive.noDependents("obj|acl")), NodePattern.N.withHead("det", NodePattern.not(hasAgreementIssue)), GermanTreePatterns.firstInPhraseAfterCommasOrConj.noHeadRelation("cc").andOr(NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.withHeadRelation("root|parataxis")), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("aux"))).withHead(Case.definitelyTransitive.noDependents("obj"))).and(SpellingRules.typoReplacement("den")), NodePattern.N.form("fasst").withHeadRelation("advmod").and(SpellingRules.typoReplacement("fast")), NodePattern.N.form("biss").andOr(NodePattern.N.withHeadRelation("case"), NodePattern.N.directlyBefore(NodePattern.N.form("bald|jetzt|nachher|sp\u00e4ter")), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obl").withDependent("amod", NodePattern.N.form("n\u00e4chst.*")))).and(SpellingRules.typoReplacement("bis")), NodePattern.N.inFormSequence(2, "Damen?", "und", "Heerr?ee?n?|Heree?n?|Herreen?").and(SpellingRules.typoReplacement("Herren")), NodePattern.N.form("((\u00fc|ue)ber|ver)?lasen").andOr(NodePattern.N.withDependent("aux(:pass)?"), NodePattern.N.withHeadRelation("xcomp"), NodePattern.N.withDependent("nsubj", NodePattern.N.form("sie").directlyAfterHead()).withDependent("xcomp")).and(SpellingRules.typoRegexReplacement("(.+)?lasen", "$1lassen")).andOptionally(NodePattern.N.form("verlasen").correct(NodeCorrector.replace("verlesen"))), NodePattern.N.form("mann").withHead("nsubj(:pass)?", NodePattern.N.pos("VER:INF.*").withDependent("aux")).withOnlyDependents(NodePattern.N.withHeadRelation("advmod")).and(SpellingRules.typoReplacement("man")), NodePattern.N.form("kamm").noDependents("xcomp|csubj|case|[an]mod|det").andOr(NodePattern.N.withDependent("iobj").and(SpellingRules.typoReplacement("kam")), NodePattern.N.noDependents().and(SpellingRules.typoReplacement("kann")), NodePattern.N.noDependents("xcomp|csubj").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound").and(SpellingRules.typoReplacement("kam", "kann"))), NodePattern.N.form("heer").andOr(NodePattern.N.withHeadRelation("vocative"), NodePattern.N.withHead("compound", NodePattern.or(NodePattern.N.label("PERSON"), NodePattern.N.withHeadRelation("vocative"))), NodePattern.N.directlyAfter(NodePattern.N.form("geehrter"))).and(SpellingRules.typoReplacement("Herr")), NodePattern.N.formCaseSensitive("Ide").withDependent("det(:poss)?").and(SpellingRules.typoReplacement("Idee")), NodePattern.N.form("wei\u00dft").andOr(NodePattern.N.withDependent("compound:prt", NodePattern.N.form("auf")), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("auf")))).and(SpellingRules.typoReplacement("weist")));
    }

    private static NodePattern umlautIssues() {
        NodePattern schwuelSubst = NodePattern.N.lemma(".*(tag|nacht|morgen|abend|luft|wetter|hitze|duft|atmosph\u00e4re|pathos)");
        return NodePattern.or(NodePattern.N.form("spat").withHeadRelation("advmod").and(SpellingRules.typoReplacement("sp\u00e4t")), NodePattern.N.form("wehrend|w\u00e4hren").withHeadRelation("case").and(SpellingRules.typoReplacement("w\u00e4hrend")), NodePattern.N.form("w\u00e4hren").withDependent("obj|expl:pv", ReflexivePronouns.accReflexivPronomen).and(SpellingRules.typoReplacement("wehren")), NodePattern.N.form("schon(en?)?").andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.withHeadRelation("advmod").withDependent("advmod", NodePattern.N.form("ganz|wirklich")), NodePattern.ROOT.withDependent("cop"), NodePattern.N.markAs("Schon").withHead("advmod", NodePattern.N.lemma("sein").noDependents("advmod", NodePattern.not(NodePattern.N.alreadyMarkedAs("Schon"))).noDependents("compound:prt").noDependents("ob[lj]")).noDependents()).and(SpellingRules.typoRegexReplacement("schon(.*)", "sch\u00f6n$1")), NodePattern.N.form("sch\u00f6n(en?)?").withHeadRelation("advmod").directlyBefore(NodePattern.N.form("sehr|recht")).and(SpellingRules.typoRegexReplacement("sch\u00f6n(.*)", "schon$1")), NodePattern.N.form("nahe").inFormSequence(2, "in", "der", ".*").and(SpellingRules.typoReplacement("N\u00e4he")), gewohntGewoehnt, NodePattern.N.form("Hohl(en?)?").andOr(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").and(SpellingRules.typoRegexReplacement("ho(.*)", "h\u00f6$1")), NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noDependents("cop").and(SpellingRules.typoRegexReplacement("hoh(.*)", "ho$1"))).andNot(CommonPatterns.insideQuotes), NodePattern.not(secondPlRoot).form("lauft").and(SpellingRules.typoReplacement("l\u00e4uft")), NodePattern.N.form("mohren?").andOr(NodePattern.N.withHead("obj|nsubj:pass", NodePattern.N.lemma("essen|knabbern|kochen|raspeln|rieben|schneiden|schnippeln|sch\u00e4len|verziehen|waschen")), NodePattern.N.withDependent("amod", NodePattern.N.form("(roh|knackig|ge(raspelt|rieben|schabt|schnitten|kocht|waschen)).+"))).and(SpellingRules.typoRegexReplacement("mohre(n?)", "M\u00f6hre$1")), NodePattern.or(NodePattern.N.form("(alternativ|dauer|end|ersatz|gesamt|ideal|interims|komplett|kompromiss|konflikt|not|null|problem|schein|sicherheits|system|teil|zweistaaten|zwischen|\u00fcbergangs)losung(en)?").and(SpellingRules.typoRegexReplacement("(.*)losung(en)?", "$1l\u00f6sung$2")), NodePattern.N.form("losung").andOr(NodePattern.N.withDependent("amod", NodePattern.N.lemma("alternativ|einfach|elegant|falsch|gl\u00fccklich|gut|konkret|optimal|richtig|sauer|schnell|vern\u00fcnftig")), NodePattern.N.withDependent("nmod", NodePattern.N.lemma(".*(problem|r\u00e4tsel|frage|aufgabe|konflikt|krise|gleichung)")), NodePattern.N.withHead("obj", NodePattern.N.lemma("an(bieten|setzen|streben|wenden)|(aus|er)arbeiten|ausgeben|finden|erreichen|suchen|vorlegen|herbeif\u00fchren"))).and(SpellingRules.typoReplacement("L\u00f6sung"))), NodePattern.N.form("schwul(e[rmns]?)?").andOr(NodePattern.N.withDependent("nsubj", schwuelSubst), NodePattern.N.withHead("amod", schwuelSubst)).and(SpellingRules.typoRegexReplacement("schwul(.*)", "schw\u00fcl$1")), NodePattern.N.form("bewehr(en|t)").withDependent("expl:pv", NodePattern.N.form("sich")).and(SpellingRules.typoRegexReplacement("bewehr(.+)", "bew\u00e4hr$1")), NodePattern.N.form("fur").withHeadRelation("case").and(SpellingRules.typoReplacement("f\u00fcr")), NodePattern.N.lemma("auslosen").withDependent("obj|nsubj(:pass)?", NodePattern.N.lemma(".*alarm")).and(SpellingRules.typoRegexReplacement("(.+)los(.+)", "$1l\u00f6s$2")), NodePattern.N.form("Gr\u00f6\u00dfe").withHeadRelation("amod|compound").and(SpellingRules.typoReplacement("gro\u00dfe")));
    }

    private static NodePattern wiesWieEs() {
        return NodePattern.N.form("wies").directlyBefore(NodePattern.N.pos("VER:.*")).and(SpellingRules.typoReplacement("wie es"));
    }

    private static NodePattern mirMit() {
        NodePattern withMitNearby = NodePattern.or(NodePattern.N.directlyBefore(CommonPatterns.skipForward(NodePattern.N.form("es"), NodePattern.N.alreadyMarkedAs("Mit"))), NodePattern.N.directlyAfter(GermanTreePatterns.firstInPhraseAfterCommasOrConj.alreadyMarkedAs("Mit")));
        return NodePattern.or(NodePattern.N.form("mir").andOr(NodePattern.N.withHeadRelation("case"), NodePattern.N.withNextSibling(NodePattern.or(NodePattern.N.withHeadRelation("iobj|obl").noDependents("case").withDependent("amod|det.*", NodePattern.N.pos(".*:DAT:.*")), NodePattern.N.pos("PRO:RIN:DAT.*"), NodePattern.N.withHeadRelation("amod|det.*").pos(".*:DAT:.*"))), NodePattern.N.directlyAfter(NodePattern.N.form("de[mn]")), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("det.*").onlyPos(".*:(DAT|GEN):.*")).withHead(NodePattern.not(Case.mayHaveArg("A"))), NodePattern.N.directlyBefore(NodePattern.N.lemma("einrechnen"))).andNot(NodePattern.N.withHead("i?obj", NodePattern.or(NodePattern.N.lemma("lassen|geben"), NodePattern.N.form("bewusst"), NodePattern.N.withDependent("compound:prt", NodePattern.N.form("mit"))))).noDependents("case").and(SpellingRules.typoReplacement("mit")), NodePattern.N.form("mit").markAs("Mit").withHead("i?obj|advmod|compound:prt", NodePattern.or(Case.mayMissArgInContext("D"), Case.mayMissArgInContext("DRefl"), NodePattern.N.lemma("gefallen")).noDependents("iobj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Mit"))).andOr(NodePattern.N.noDependents("aux").and(withMitNearby), NodePattern.N.withDependent("aux", withMitNearby))).and(SpellingRules.typoReplacement("mir")));
    }

    private static NodePattern wieWir() {
        NodePattern wirCondition = NodePattern.or(NodePattern.N.withHead("nsubj.*", NodePattern.N.pos("VER.*").noPos("VER:AUX.*").noDependents("cop", NodePattern.N.noForm("sind|ware?n"))), NodePattern.N.withHeadRelation("obl").withDependent("case", NodePattern.N.form("wie|als")), NodePattern.N.directlyBefore(GermanTreePatterns.closingQuotation).directlyAfter(GermanTreePatterns.openingQuotation), NodePattern.N.withHead("dep", NodePattern.N.withDependent("cop").noDependents("nsubj")));
        NodePattern wieCondition = NodePattern.or(NodePattern.N.withDependent("cop").noDependents("nsubj.*", NodePattern.N.form("wir")), CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("advmod|mark|case")), NodePattern.N.inFormSequence(1, "nach", ".*", "vor"), NodePattern.N.withDependent("advmod", NodePattern.N.pos("ADV:(TMP|LOK)").afterHead()), NodePattern.N.withHead("nsubj", NodePattern.N.form("besprochen").noDependents("obj").noDependents("ccomp", NodePattern.N.withDependent("mark"))));
        return NodePattern.or(wirCondition.form("wie|wird").and(SpellingRules.typoReplacement("wir")), wieCondition.form("wir").and(SpellingRules.typoReplacement("wie")));
    }

    private static NodePattern seidSeinSeit() {
        NodePattern seidCondition = NodePattern.or(NodePattern.N.withHead("cop|aux.*", secondPlRoot), secondPlRoot);
        return NodePattern.or(seidCondition.form("seit").and(SpellingRules.typoReplacement("seid")), NodePattern.not(seidCondition).andNot(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).andOr(NodePattern.N.form("seid"), NodePattern.N.form("sein").directlyBefore(NodePattern.N.form("(sekund|minut|stund|tag|woch|monat|jahr(zent|hundert)?)en"))).and(SpellingRules.typoReplacement("seit"))).noDependents("dep");
    }

    private static NodePattern sylvesterSilvester() {
        NodePattern withDependentRomanNum = NodePattern.N.withDependent("appos", NodePattern.or(CommonPatterns.romanNumeral, NodePattern.N.form("I.")).directlyAfterHead());
        return NodePattern.N.form("Sylvester(s|[a-z]{4,})?").andOr(NodePattern.N.label("EVENT"), NodePattern.N.withDependent("det"), NodePattern.N.withDependent("nsubj", NodePattern.N.lemma(".*(Tag|Feier|Fest|Tradition|Brauch|Jahreswechsel|Anlass|Nacht|Ereignis|Zeit|Party|Abend|Waldmann|Papst|Bischof)")), NodePattern.N.form("Sylvester[a-z]{4,}"), NodePattern.N.withDependent("compound", NodePattern.N.lemma("Bischof|Papst")), withDependentRomanNum, NodePattern.N.withHead(NodePattern.N.lemma("sein").withDependent(".*", NodePattern.N.form("Neujahr|Weihnachten")))).noDependents("flat(:name)?|compound").noHeadRelation("flat(:name)?|compound").andOr(NodePattern.or(NodePattern.N.withDependent("amod", NodePattern.N.lemma("heilig")), withDependentRomanNum).message("Meinten Sie den Papst \u201eSilvester\u201c?"), NodePattern.N.message("Meinten Sie die Feier am 31.\u00a0Dezember, \u201eSilvester\u201c?")).correct(NodeCorrector.regexReplace("Sy(.*)", "Si$1"));
    }

    private static NodePattern adjectiveToAdverb() {
        return NodePattern.N.form("((bis|vor|seit)her|sofort|jetz|ob|jeweil|sonst|einst|etwa)ig").message("Verwenden Sie ein Adverb, um Verben, Adjektive oder andere Adverbien n\u00e4her zu bestimmen").andOptionally(NodePattern.N.form("etwaig").correct(NodeCorrector.replace("eventuell"))).andOr(NodePattern.N.form("jetzig").correct(NodeCorrector.replace("jetzt")), NodePattern.N.form("obig").correct(NodeCorrector.replace("oben")), NodePattern.N.form("jeweilig").correct(NodeCorrector.replace("jeweils")), NodePattern.N.correct(NodeCorrector.regexReplace("(.*)ig", "$1"))).andOptionally(NodePattern.N.form("sofortig").correct(NodeCorrector.replace("unmittelbar")));
    }

    private static NodePattern vW() {
        return NodePattern.N.form("wage").andOr(NodePattern.N.withHead("advmod", NodePattern.N.lemma("erinnern")), NodePattern.N.withHeadRelation("amod")).and(SpellingRules.typoReplacement("vage"));
    }

    private static NodePattern eiIe() {
        return NodePattern.or(NodePattern.N.form("Wien").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("(halb)?(flasche|schoppen)|glas")), NodePattern.N.withHead("obj", NodePattern.N.lemma("trinken|gie\u00dfen")), NodePattern.N.withDependent("amod", NodePattern.N.lemma("wei(\u00df|ss)|rot|s\u00fc(\u00df|ss)|lieblich|trocken|herb|spritzig|s\u00fcffig|schwer|(.*deutsch|(alt)?irisch|.*(alban|amhar|arab|aserbaidschan|bask|belarus|bengal|bulgar|chines|d(\u00e4|ae)n|engl|estn|finn|franz(\u00f6|oe)s|f(\u00e4|ae)r(\u00f6|oe)|galic|georg|griech|g(\u00e4|ae)l|haitian|hebr(\u00e4|ae)|holl(\u00e4|ae)nd|indones|isl(\u00e4|ae)nd|italien|japan|javan|jidd|katalan|kirgis|korean|kreol|kurd|lett|litau|luxembourg|malai|maltes|mazedon|mongol|niederl(\u00e4|ae)nd|norweg|paschtun|pers|poln|portugies|rum\u00e4n|russ|serb|singhales|slowak|slowen|span|tadschik|tamil|thail(\u00e4|ae)nd|tschech|turkmen|t(\u00fc|ue)rk|uigur|ukrain|ungar|vietnames|walis)isch)"))).and(SpellingRules.typoReplacement("Wein")), NodePattern.N.form("Vertreibe?").withDependent("det(:poss)?").and(SpellingRules.typoRegexReplacement(".+eib(e[ns]?|s)?", "Vertrieb$1")), NodePattern.N.form("schient").withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").withDependent("xcomp").and(SpellingRules.typoReplacement("scheint")), NodePattern.N.formSuffix("schrieben").andNot(NodePattern.N.formSuffix("geschrieben")).withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()).and(SpellingRules.typoRegexReplacement("(.*)schrieben", "$1schreiben")), NodePattern.not(secondPlRoot).form("schriebt").and(SpellingRules.typoReplacement("schreibt")), NodePattern.N.withDependent("case").withHeadRelation("obl").form("schrieben").and(SpellingRules.typoReplacement("Schreiben")), NodePattern.or(NodePattern.N.form("leibe[rmns]?").andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.withDependent("flat", NodePattern.N.pos("EIG.*"))), NodePattern.N.form("leibe").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").noDependents("case").noDependents("det(:poss)?", NodePattern.N.pos(".*DAT.*"))).and(SpellingRules.typoRegexReplacement("([l])eibe(.*)", "$1iebe$2")), NodePattern.N.form("lieb").andOr(withNominalDependents, NodePattern.N.withDependent("conj", NodePattern.N.pos("SUB:.*"))).noDependents("cop").and(SpellingRules.typoReplacement("leib")), NodePattern.N.form("(bogen|elfmeter|penalty|sport|(eis)?stock|tor(e|wand))schei(\u00df|ss)ens?").and(SpellingRules.typoRegexReplacement("(.+)schei(\u00df|ss)en(s?)", "$1schie$2en$3")), NodePattern.N.form("schei\u00df(en?|t)").andOr(NodePattern.N.withDependent("obl", NodePattern.N.form("pilze").withDependent("case", NodePattern.N.form("wie"))), NodePattern.N.withDependent("obj|nsubj", NodePattern.N.lemma("(eigen)?tor"))).and(SpellingRules.typoRegexReplacement("schei(.+)", "schie$1")), NodePattern.N.form("Schie\u00dfe").withDependent("cop").noDependents("det(:poss)?").and(SpellingRules.typoReplacement("Schei\u00dfe")), NodePattern.N.form("dien(en?)?").andOr(NodePattern.N.withHeadRelation("det.*|amod"), NodePattern.N.withHead(NodePattern.N.pos("SUB:.*")).directlyBeforeHead(), NodePattern.N.withHeadRelation("xcomp|dep").pos("VER.*").withDependent("obj", NodePattern.N.directlyAfterHead())).and(SpellingRules.typoRegexReplacement("die(.*)", "dei$1")), NodePattern.N.form(".*prie?se").andOr(NodePattern.N.withDependent("amod", NodePattern.N.lemma("steigend|fallend|hoch|niedrig|moderat")), NodePattern.N.withHead("nsubj", NodePattern.N.lemma("steigend?|fallend?|hoch|niedrig|moderat"))).and(SpellingRules.typoRegexReplacement("(.*p)rie?se", "$1reise")));
    }

    private static NodePattern fixCollocations() {
        return NodePattern.or(NodePattern.N.form("ff").withDependent("case", NodePattern.N.form("aus")).withDependent("det", NodePattern.N.directlyBeforeHead()).and(SpellingRules.typoReplacement("Effeff")), NodePattern.N.form("verr?enn?t").withDependent("nsubj", NodePattern.N.form("zeit")).and(SpellingRules.typoReplacement("verrinnt")), NodePattern.N.inFormSequence(1, "kein", ".+er", "als").and(CommonPatterns.lowercasedHasPos("ADJ:PRD:KOM")).and(SpellingRules.typoRegexReplacement("(.+)$", "$1er")), NodePattern.N.form("berieten").withDependent("obj", NodePattern.N.form("freude")).and(SpellingRules.typoReplacement("bereiten")), NodePattern.N.form("dieb").noDependents().withHead("obj", NodePattern.N.lemma("machen").withDependent("nsubj", NodePattern.N.form("gelegenheit"))).and(SpellingRules.typoReplacement("Diebe")), NodePattern.N.form("Herze?").withOnlyDependents(NodePattern.N.withHeadRelation("case|det")).withHead("obl", NodePattern.N.lemma("liegen")).markAs("Herzen").withDependent("case", NodePattern.N.form("a[nm]").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("Herzen"), "am Herzen"))).message("Meinten Sie den Ausdruck \u201eam Herzen liegen\u201c?"), NodePattern.N.inFormSequence(1, "aufs", "Trapez").withHead("obl", NodePattern.N.lemma("bringen")).and(SpellingRules.typoReplacement("Tapet")), NodePattern.N.form("pferd").noDependents("det(:poss)?").withHead("obj", NodePattern.N.lemma("stehlen")).and(SpellingRules.typoReplacement("Pferde")), NodePattern.N.form("lernen").withDependent("obj", NodePattern.N.inFormSequence(1, "das", "F\u00fcrchten")).and(SpellingRules.typoReplacement("lehren")), NodePattern.N.form("(an|hinter|\u00fcber|unter|vor)s").directlyBefore(NodePattern.N.formCaseSensitive("s?ich")).and((node, match) -> {
            String form = node.form().substring(0, node.form().length() - 1);
            Node next = node.neighbor(1);
            return match.withCorrector(NodeCorrector.replaceNodes(node, next, form + " sich")).withCorrector(NodeCorrector.replaceNodes(node, next, node.form() + " Ich")).withMessage("Meinten Sie \u201e" + form + " sich\u201c oder \u201e" + node.form() + " Ich\u201c?");
        }), NodePattern.N.form("den").withHead("det", NodePattern.N.inFormSequence(2, "auf", "den", "laufenden").withHead("obl", NodePattern.N.lemma("halten|bleiben"))).and(SpellingRules.typoReplacement("dem")), NodePattern.N.lemma("(\u00f6kolog|\u00f6konom)isch").withHead("amod", NodePattern.N.lemma("abendmahl|andacht|.*gebet|.*gottesdienst|kirche|kirchentag|konzil|pilgerweg|taufe|theologie|trauerfeier|trauung|vesper")).and(SpellingRules.typoRegexReplacement("(\u00f6kolog|\u00f6konom)(.+)", "\u00f6kumen$2")), NodePattern.N.form("eine[mnsr]?").directlyBefore(paarIndeclinable).and(SpellingRules.typoReplacement("ein")), NodePattern.N.form("landen").withDependent("case", NodePattern.or(Case.accDatPreposition, Case.datPreposition)).withDependent("amod").and(SpellingRules.typoReplacement("L\u00e4ndern")), NodePattern.N.form("lange|l\u00e4ngere|kurze").withDependent("case", NodePattern.N.form("seit").directlyBeforeHead()).and(SpellingRules.typoRegexReplacement("(.+)", "$1m")), NodePattern.N.formCaseSensitive("ABC").withDependent("det").and((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.startOffset(), node.endOffset(), "Abc"))).message("Die Bezeichnung \u201eAbc\u201c f\u00fcr das Alphabet wird nicht in Gro\u00dfbuchstaben geschrieben"));
    }

    private static NodePattern fixMisshapedNoun() {
        return NodePattern.or(NodePattern.N.form("fachen").withDependent("det", NodePattern.N.lemma("manch|viel|meist")).and(SpellingRules.typoReplacement("F\u00e4chern")), NodePattern.N.form(".+ungs").withDependent("det(:poss)?", NodePattern.N.form("(d|[mds]ein|ihr)es").markAs("Det")).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).and((node, match) -> {
            String noun = node.form().substring(0, node.form().length() - 1);
            if (node.tree().treeSupport().tagToken(noun).posReadings().stream().anyMatch(pos -> !pos.contains("FEM"))) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replace(node, noun).join(NodeCorrector.regexReplace(match.getMarkedNode("Det"), "(d|[mds]ein|ihr)es", "$1er"))).withMessage("Das Substantiv \u201e" + noun + "\u201c ist feminin");
        }), NodePattern.N.form("(hinweis|namens|verkehrs|verbots|warn)schilden?").and(SpellingRules.typoRegexReplacement("(.+schilde)(n?)", "$1r$2")), NodePattern.N.form("(abfang|abwehr|schutz)schildern?").and(SpellingRules.typoRegexReplacement("(.+schilde)r(n?)", "$1$2")), NodePattern.N.form("jahrhunde?s?").andOr(NodePattern.N.inFormSequence(3, "(d|[mds]ein|ihr|unser|eue?r)es", "\\d\\d?", ".", ".+").and(SpellingRules.typoReplacement("Jahrhunderts")), NodePattern.N.inFormSequence(2, "(d|[mds]ein|ihr|unser|eue?r)es", "\\d\\d?", ".+").and(SpellingRules.typoReplacement("Jahrhunderts")), SpellingRules.typoReplacement("Jahrhundert")));
    }

    private static NodePattern fixMisshapedPtcp() {
        return NodePattern.N.noPos().andNot(CommonPatterns.lowercasedHasPos(".*")).withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").withDependent("aux(:pass)?", NodePattern.N.lemma("haben|werden|sein")).andOr(NodePattern.N.form(".+en").and(node -> node.tree().treeSupport().tagToken(node.form().replaceAll("(.+)en", "$1t")).hasPos(".*PA2:PRD.*")).and(SpellingRules.typoRegexReplacement("(.+)en", "$1t")), NodePattern.N.form(".+t").and(node -> node.tree().treeSupport().tagToken(node.form().replaceAll("(.+)t", "$1en")).hasPos(".*PA2:PRD.*")).and(SpellingRules.typoRegexReplacement("(.+)t", "$1en")), NodePattern.N.form("ge.+").and((node, match) -> {
            String base;
            TreeSupport support = node.tree().treeSupport();
            String infinitive = base = node.form().substring(2);
            if (!support.tagToken(base).hasPos("VER.*INF.*") && (infinitive = SpellingRules.restoreInfinitive(base, support)) == null) {
                return null;
            }
            List<String> newPtcp = support.synthesize(base, infinitive, "VER.*", "VER.*PA2.*");
            if (newPtcp.isEmpty()) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replace(node, newPtcp.get(0))).withMessage("Meinten Sie \u201e" + newPtcp.get(0) + "\u201c?");
        }));
    }

    @Nullable
    private static String restoreInfinitive(String base, TreeSupport support) {
        String stem = base.replaceFirst("(t|en)", "");
        if (stem.equals(base) || !stem.contains("a") || stem.equals("mark")) {
            return null;
        }
        String candidate = stem.replaceFirst("a", "e") + "en";
        if (!support.tagToken(candidate).hasPos("VER.*INF.*")) {
            return null;
        }
        return candidate;
    }

    private static NodePattern fixMisshapedDet() {
        return NodePattern.N.form("all").markAs("All").andOr(NodePattern.N.withHead("det", NodePattern.N.pos("SUB.*").withHeadRelation("obj|nsubj(:pass)?").noDependents("det", NodePattern.not(NodePattern.N.alreadyMarkedAs("All")))), NodePattern.N.withHeadRelation("nsubj|obj").noDependents(), NodePattern.N.withHeadRelation("obl").withDependent("case", Case.accPreposition.andNot(AdjDeclination.anyFusedPreposition)).withOnlyDependents(NodePattern.N.withHeadRelation("case"))).andNot(NodePattern.N.directlyBefore(GermanTreePatterns.englishWord.noPos())).and(SpellingRules.typoReplacement("alle"));
    }

    private static NodePattern fixMisshapedAdj() {
        return CommonPatterns.letterWord.spaceBefore().spaceAfter().markAs("Adj").noPos().andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE).noSpaceAfter()).noLabel(".*").and(node -> {
            String form;
            TreeSupport support = node.tree().treeSupport();
            return !support.isAcceptedBySpellchecker(form = node.lowForm()) && support.isAcceptedBySpellchecker(form + "en") || form.matches("Strassenverkehr|best");
        }).andOr(NodePattern.N.withHead("amod", NodePattern.N.markAs("Head").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root").andOptionally(NodePattern.N.withDependent("det(:poss)?", NodePattern.N.markAs("Det")))).andOr(NodePattern.markedNodeMatches("Det", NodePattern.N.form("[mds]?ein")).andOr(NodePattern.markedNodeMatches("Head", NodePattern.N.onlyPos(".*NEU.*")).and(SpellingRules.typoRegexReplacement("(.+)", "$1es")), NodePattern.markedNodeMatches("Head", NodePattern.N.onlyPos(".*MAS.*")).and(SpellingRules.typoRegexReplacement("(.+)", "$1er"))), NodePattern.markedNodeMatches("Head", NodePattern.N.withDependent("case")).and(NodePattern.markedNodeMatches("Det", NodePattern.N.noForm("das|dieses"))).and(SpellingRules.typoRegexReplacement("(.+)", "$1en")), SpellingRules.typoRegexReplacement("(.+)", "$1e").and(NodePattern.markedNodeMatches("Det", NodePattern.N)), NodePattern.markedNodeMatches("Head", NodePattern.N.onlyPos(".*SIN:FEM.*").noDependents(NodePattern.N.alreadyMarkedAs("Det"))).andOr(NodePattern.markedNodeMatches("Head", NodePattern.N.withDependent("case", Case.datPreposition)).and(SpellingRules.typoRegexReplacement("(.+)", "$1er")), NodePattern.markedNodeMatches("Head", NodePattern.N.withDependent("case", Case.accPreposition)).and(SpellingRules.typoRegexReplacement("(.+)", "$1e"))), NodePattern.markedNodeMatches("Head", NodePattern.N.noDependents(NodePattern.N.alreadyMarkedAs("Det"))).andOr(NodePattern.markedNodeMatches("Head", NodePattern.N.onlyPos(".*SIN:(MAS|NEU).*").withDependent("case", Case.datPreposition)).and(SpellingRules.typoRegexReplacement("(.+)", "$1em")), NodePattern.markedNodeMatches("Head", NodePattern.N.onlyPos(".*SIN:MAS.*").withDependent("case", Case.accPreposition)).and(SpellingRules.typoRegexReplacement("(.+)", "$1en")))), NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").withDependent("cop").withDependent("nsubj").withDependent("det", NodePattern.N.form("das|die|der")).noDependents("case").and(SpellingRules.typoRegexReplacement("(.+)", "$1e")));
    }

    private static NodePattern restoreGreeting(Case caze) {
        return NodePattern.custom((node, match) -> {
            Object nounText;
            Node adj = match.getMarkedNode("Adj");
            String adjEnding = caze == Case.DAT ? "en" : "e";
            String adjText = adj.form().replaceFirst("^(.+)(e[mnrs]?)$", "$1") + adjEnding;
            String value = GermanParameters.VARIANT.getValue(node.tree());
            Object object = value.equals("DE") || value.equals("AT") || node.hasForm("Gr\u00fc\u00df(es)?|Gru\u00dfen?") ? "Gr\u00fc\u00dfe" : (nounText = value.equals("CH") || node.hasForm("Gr\u00fcss(es)?|Grussen?") ? "Gr\u00fcsse" : StringTools.uppercaseFirstChar((String)node.form()));
            if (caze == Case.DAT && !((String)nounText).endsWith("n")) {
                nounText = (String)nounText + "n";
            }
            if (((String)nounText).equals(node.form()) && adjText.equals(adj.form())) {
                return null;
            }
            NodeCorrector corrector = NodeCorrector.replace(node, new String[]{nounText});
            Object msgText = nounText;
            if (!adjText.equals(adj.form()) && node.tree().treeSupport().isAcceptedBySpellchecker(adjText)) {
                corrector = corrector.join(NodeCorrector.replace(adj, adjText));
                msgText = adjText + " " + (String)msgText;
            }
            return match.withCorrector(corrector).withMessage("Meinten Sie \u201e" + (String)msgText + "\u201c?");
        });
    }

    private static NodePattern adverbOnly() {
        NodePattern sofortigNounsLaw = NodePattern.or(NodePattern.N.lemma("Voll(zug|zieh(ung|barkeit)|streckung)|Freilassung"), NodePattern.N.form("Einklagung(en)?"));
        NodeCorrector.Relative toSofortig = NodeCorrector.regexReplace("sogleich(.+)", "sofortig$1");
        return NodePattern.or(NodePattern.N.form("sogleich.+(e[rnsm]?)?").withHeadRelation("amod").andOptionally(NodePattern.N.withHead(SpellingRules.canBeSofortigNouns().andNot(NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("wie"))))).correct(toSofortig)).andOr(NodePattern.N.withHead(sofortigNounsLaw).correct(toSofortig), NodePattern.N.correct(NodeCorrector.regexReplace("so(gleich.+)", "so $1"))).message("\u201eSogleich\u201c ist immer ein Adverb und kann sich nicht auf Sachen oder Personen beziehen"), NodePattern.N.form("bislang.+(e[rnsm]?)?").withHeadRelation("amod").message("\u201eBislang\u201c ist immer ein Adverb und kann sich nicht auf Sachen oder Personen beziehen").correct(NodeCorrector.regexReplace("bislang(.+)", "bisherig$1")), NodePattern.N.form("neulich.+(e[rnsm]?)?").withHeadRelation("amod").andOr(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("amod")).message("\u201eNeulich\u201c ist immer ein Adverb und kann sich nicht auf Sachen oder Personen beziehen").correct(NodeCorrector.replace("neulich")), NodePattern.or(NodePattern.N.form("neulichere[snmr]?").correct(NodeCorrector.regexReplace("neulicher(.+)", "aktuell$1")), NodePattern.N.form("neulichste[snmr]?").correct(NodeCorrector.regexReplace("neulichst(.+)", "aktuell$1")), NodePattern.N.correct(NodeCorrector.regexReplace("neulich(.+)", "aktuell$1"))).message("\u201eNeulich\u201c ist immer ein Adverb; erg\u00e4nzen Sie ein Adjektiv (z.\u202fB. neulich stattgefunden) oder verwenden Sie direkt ein Adjektiv")));
    }

    private static NodePattern adjectiveOnly() {
        return NodePattern.N.form("(noch|aber)malig").withHeadRelation("advmod").message("\u201e$_\u201c kann sich nur auf Sachen beziehen").correct(NodeCorrector.regexReplace("(.+)malig", "$1mals"));
    }

    private static NodePattern similarWordConfusion() {
        NodePattern trotz = NodePattern.N.form("trotz.+");
        NodePattern waerenWaehrend = NodePattern.N.lemma("w(\u00e4|ae)hren").noPos("PA2.*").andOr(NodePattern.N.withHeadRelation("aux|cop").and(SpellingRules.typoRegexReplacement("(.*)h(.+)", "w\u00e4$2")), NodePattern.N.form(".+ren").withHeadRelation("case|mark").and(SpellingRules.typoReplacement("w\u00e4hrend")));
        NodePattern froheFreue = NodePattern.N.form("froh?.*").withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").withDependent("nsubj", NodePattern.N).withDependent("obj", NodePattern.N.pos("PRO:REF.*")).and(node -> node.tree().treeSupport().tagToken(node.form().replaceAll("froh?(.*)", "freu$1")).hasPos("VER.*")).and(SpellingRules.typoRegexReplacement("froh?(.*)", "freu$1"));
        NodePattern befindetMan = NodePattern.N.form("be(findet|fand)").withDependent("nsubj", NodePattern.N.form("man")).withDependent("obj").noDependents("xcomp", NodePattern.or(NodePattern.N.pos("(ADJ|PA2):PRD:GRU.*"), NodePattern.N.form("als").withDependent(".*", NodePattern.N.pos("(ADJ|PA2):PRD:GRU.*")))).noDependents("obl", NodePattern.N.pos("(ADJ|PA2):PRD:GRU.*").withDependent("case", NodePattern.N.form("f\u00fcr"))).and(SpellingRules.typoRegexReplacement("be(.*)", "$1"));
        NodePattern often = NodePattern.N.form("often").and(SpellingRules.typoReplacement("oft"));
        NodePattern relaxed = NodePattern.N.form("relaxed(est)?e[rsmn]?").and(SpellingRules.typoRegexReplacement("(.+)xed(.+)", "$1xt$2"));
        NodePattern dessenWords = NodePattern.or(NodePattern.N.form("(trotz|w\u00e4hrend)dessen").andOr(NodePattern.or(NodePattern.N.withHeadRelation("advmod").directlyBefore(noun.withHeadRelation("obj").markAs("Noun")), NodePattern.N.withHead("case", noun.markAs("Noun"))).and((node, match) -> {
            Node noun = match.getMarkedNode("Noun");
            String pronomen = noun.hasPos(".*SIN:(MAS|NEU)") ? "seines" : "seiner";
            String prep = node.hasForm("trotz.+") ? "trotz" : "w\u00e4hrend";
            return match.withCorrector(NodeCorrector.replace(node, prep + " " + pronomen)).withMessage("Verwenden Sie die Pr\u00e4position \u201e" + prep + "\u201c und das Possessivpronomen anstelle von \u201e" + node.form() + "\u201c");
        }), trotz.and(SpellingRules.typoReplacement("trotzdem"))), NodePattern.N.form("w\u00e4hrend").withHead("case", NodePattern.N.form("dessen").andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("acl")))).directlyBeforeHead().message("Meinten Sie \u201ew\u00e4hrenddessen\u201c?").and(WordSeparation.joinWithNextNode()));
        NodePattern keinKann = NodePattern.N.form("kein").anyPos().noHeadRelation("det|[na]mod|root").andNot(NodePattern.N.withHead("dep", NodePattern.or(NodePattern.N.withHeadRelation("ob[jl]|nsubj.*"), NodePattern.ROOT.onlyPos("SUB.*")))).andNot(NodePattern.N.withHead("obj", NodePattern.N.pos("VER:[123].*"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("[:/]").noSpaceAfter())).andNot(CommonPatterns.quotedWord).and(SpellingRules.typoReplacement("kann"));
        NodePattern beiVon = NodePattern.N.form("bei").withHead(NodePattern.N.label("PERSON").withHead("obl", NodePattern.N.form("ge(schrieben|dreht|malt)|verfasst|erschaffen|komponiert").withDependent("nsubj:pass", noun).withDependent("aux:pass", NodePattern.N.form("wurden?")))).directlyBeforeHead().and(SpellingRules.typoReplacement("von"));
        NodePattern passport = NodePattern.N.form("Passport(s|en?)?").andOr(NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.label("NATIONALITY_OR_GROUP"), NodePattern.N.lemma("g\u00fcltig|amtlich|zugelassen|vorl\u00e4ufig|gef\u00e4lscht|neu|aktuell|alt|herk\u00f6mmlich|national|ausl\u00e4ndisch|biometrisch|digital|elektronisch"))), NodePattern.N.withHead(NodePattern.or(NodePattern.N.lemma("verl\u00e4ngern|beantragen|erneuern|besitzen|ablaufen"), NodePattern.N.lemma("laufen").withDependent("compound:prt", NodePattern.N.form("ab"))))).noDependents("compound|flat|appos").noLabel(".*").andOr(NodePattern.N.form("Passport").withOnlyDependents(NodePattern.N.withHeadRelation("det(:poss)?")).withHead(NodePattern.N.lemma("(ab)?laufen|erneuen")).correct(NodeCorrector.replace("Pass", "Passwort")), NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replace(node, node.hasForm("Passport") ? "Pass" : (node.hasForm("Passports") ? "Passes" : (node.hasForm("Passporte") ? "P\u00e4sse" : "P\u00e4ssen")))))).message("Meinten Sie \u201ePass\u201c?");
        NodePattern nextNaechst = NodePattern.N.form("next.*").withHeadRelation("amod").noLabel(".*").andNot(GermanTreePatterns.englishWord.noDependents("det(:poss)?")).and(SpellingRules.typoRegexReplacement("next(.*)", "n\u00e4chst$1"));
        NodePattern anschliessend = NodePattern.N.form("anschlie(\u00df|ss)lich").andOr(GermanParameters.VARIANT.withValue("CH").and(SpellingRules.typoReplacement("anschliessend", "schliesslich")), SpellingRules.typoReplacement("anschlie\u00dfend", "schlie\u00dflich"));
        NodePattern insgesamt = NodePattern.N.inFormSequence(1, "in", "gesamt").withHead("advmod", NodePattern.N.pos("ART.*")).directlyBeforeHead().message("Meinten Sie das Adjektiv \u201einsgesamt\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "insgesamt"));
        NodePattern totTod = NodePattern.or(NodePattern.N.form("tot").and(WordSeparation.withDependentsDetCaseAmod).message("Meinten Sie das Substantiv \u201eTod\u201c?").correct(NodeCorrector.replace("Tod")), NodePattern.N.form("Tod").andOr(NodePattern.N.withHeadRelation("csubj|root").withDependent("cop"), NodePattern.N.withHead("conj", NodePattern.N.pos("ADJ.*|PA2:PRD:GRU:VER").withDependent("cop")), NodePattern.N.withHead("iobj", NodePattern.N.lemma("stellen").withDependent("obj|expl:pv", NodePattern.N.pos("PRO:REF.*")))).andNot(WordSeparation.withDependentsDetCaseAmod).message("Meinten Sie das Adjektiv \u201etot\u201c?").correct(NodeCorrector.replace("tot")), NodePattern.N.form("tod(bei(ss|\u00df)en|stellen|ge(bissen|stellt))").message("Dieses Wort wird mit der Vorsilbe \u201etot-\u201c gebildet").correct(NodeCorrector.regexReplace("tod(.*)", "tot$1")));
        NodePattern stetsStehtEs = NodePattern.or(NodePattern.N.form("stets").andOr(NodePattern.not(NodePattern.N.withHeadRelation("advmod")), NodePattern.N.directlyAfter(NodePattern.N.form("wie"))).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("xcomp"))).and(SpellingRules.typoReplacement("steht es")), NodePattern.N.form("stehts").withHeadRelation("advmod").and(SpellingRules.typoReplacement("stets")));
        NodePattern verb2sg = NodePattern.N.onlyPos("VER:.*2:SIN.*");
        NodePattern dieDu = NodePattern.N.form("die").andOr(NodePattern.N.withHead("nsubj.*", verb2sg).andNot(NodePattern.N.directlyBefore(noun)), NodePattern.N.directlyBefore(NodePattern.N.pos("ART:IND.*")).withHead("det", NodePattern.N.withHead(verb2sg.noDependents("nsubj.*")))).and(SpellingRules.typoReplacement("du"));
        NodePattern wahrWar = NodePattern.or(NodePattern.N.form("wahr(en|s?t)?").andOr(NodePattern.N.withHeadRelation("aux.*|cop"), CommonPatterns.firstToken.withHead(NodePattern.N.noPos("VER.*")), NodePattern.ROOT.withDependent(".*", GermanTreePatterns.whPhrase).noDependents("cop")).and(SpellingRules.typoRegexReplacement("wahr(.*)", "war$1")), NodePattern.N.form("war").andOr(NodePattern.N.inFormSequence(1, "nicht", ".*", "\\?"), NodePattern.N.withDependent(".*", NodePattern.N.lemma("sein|werden").noHeadRelation("parataxis|csubj|ccomp|acl|advcl|conj")).noHeadRelation("dep"), NodePattern.N.withHead(NodePattern.N.lemma("werden").noPos(".*PA2.*")), NodePattern.N.withHead(NodePattern.N.lemma("nehmen")).withNextSibling(NodePattern.or(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"), NodePattern.PUNCT, NodePattern.not(NodePattern.N))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("aux(:pass)?|cop|root"))).noDependents(NodePattern.N.afterHead())).and(SpellingRules.typoReplacement("wahr")));
        NodePattern advmodToAdj = NodePattern.N.withHead("advmod", NodePattern.N.pos("ADJ.*"));
        NodePattern dasSeine = NodePattern.N.form("seine").withDependent("det", NodePattern.N.form("das"));
        NodePattern wrongLetter = NodePattern.or(NodePattern.or(NodePattern.N.form("Beckerei(en)?"), NodePattern.N.form("Becker[sn]?").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andOr(NodePattern.N.withDependent("det"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition), NodePattern.N.withHead(NodePattern.N.lemma(".*(Schule|Ausbildung|Studium|Lehre|Arbeit)")))).and(SpellingRules.typoRegexReplacement("Be(.*)", "B\u00e4$1")), NodePattern.N.form("Juli?e").noLabel("ORGANIZATION").andOr(NodePattern.N.withDependent("(num|a)mod|case", NodePattern.or(ordinalAfterTwelve, Capitalization.ordinalToTwelve, NodePattern.N.inFormSequence(1, "\\d+", "\\."), NodePattern.N.form("im|ab|seit").directlyBeforeHead())), NodePattern.N.withHead("appos", NodePattern.N.form("Monat"))).and(SpellingRules.typoReplacement("Juli")), sichAusdruecken, NodePattern.N.form("Ihnen").andOr(NodePattern.N.withDependent("flat|appos", noun.directlyAfterHead()), NodePattern.N.withHead("compound", noun).directlyBeforeHead()).message("Meinten Sie \u201eInnen-\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), m -> List.of("Innen" + m.anchor().neighbor(1).lowForm()))), NodePattern.N.form("einender").withHeadRelation("obj").noDependents().and(SpellingRules.typoReplacement("einander")), lehr.andOr(NodePattern.ROOT.withDependent("cop").noPos("SUB.*"), NodePattern.N.withHeadRelation("amod|nummod"), beforeNounHasAux).and(SpellingRules.typoRegexReplacement("lehr(.*)", "leer$1")), NodePattern.or(NodePattern.N.form("ausb\u00fcchst?(e(n|s?t)?|t)"), NodePattern.N.form("b\u00fcchst?(e(n|s?t)?|t)").withDependent("compound:prt", NodePattern.N.form("aus"))).and(SpellingRules.typoRegexReplacement("(.*)b\u00fcchs(.*)", "$1b\u00fcx$2")), NodePattern.or(NodePattern.N.lemma("aufz\u00e4unen"), NodePattern.N.lemma("z\u00e4unen").withDependent("compound:prt", NodePattern.N.form("auf"))).and(SpellingRules.typoRegexReplacement("(.*)z\u00e4un(.*)", "$1z\u00e4um$2")), NodePattern.N.form("(ai?|e)ndruck").withDependent("ccomp", NodePattern.N.withDependent("mark", NodePattern.N.form("dass"))).and(SpellingRules.typoReplacement("Eindruck")), NodePattern.N.form(".+zig").noPos().withHeadRelation("advmod").and(CommonPatterns.replacementProduces("(.+)zig", "$1tig", "(ADV|ADJ:PRD).*")).and(SpellingRules.typoRegexReplacement("(.+)zig", "$1tig")), NodePattern.N.formCaseSensitive("ee").withHeadRelation("expl|nsubj|dep").and(SpellingRules.typoReplacement("es")), NodePattern.N.form("anfach").withHeadRelation("advmod").and(SpellingRules.typoReplacement("einfach")), NodePattern.N.form("gur").withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").withDependent("cop").and(SpellingRules.typoReplacement("gut")), NodePattern.N.form("ein").withHeadRelation("case").beforeHead().and(SpellingRules.typoReplacement("in", "an")), NodePattern.N.form("wart").withHead("aux(:pass)?", NodePattern.N.inFormSequence(2, "nicht", "mehr", "gesehen").noDependents("nsubj(:pass)?", NodePattern.N.form("ihr"))).and(SpellingRules.typoReplacement("ward")), NodePattern.or(GermanTreePatterns.firstInPhraseAfterCommasOrConj, NodePattern.ROOT, NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).inFormSequence(0, "war", "f(\u00fc|ue)r", "eine?").and(SpellingRules.typoReplacement("was")), NodePattern.N.form("jede[rn]?").andOr(NodePattern.N.withDependent("appos", dasSeine), NodePattern.N.withHead(dasSeine)).and(SpellingRules.typoReplacement("jedem")), NodePattern.N.form("sag").and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj", NodePattern.N.noForm("ich|du")))).withDependent("obj", NodePattern.N.form("[mds]ich")).and(SpellingRules.typoReplacement("sah")), NodePattern.N.form("mai").formCaseSensitive(".+I").and(SpellingRules.typoReplacement("Mal")), bankStorageVsSeat, NodePattern.N.form("sich").andOr(NodePattern.N.withHeadRelation("aux(:pass)?|cop"), NodePattern.N.withHeadRelation("dep").withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.PUNCT)).withDependent("mark")).noDependents("aux(:pass)?|cop").and(SpellingRules.typoReplacement("sind")), NodePattern.N.form("gebeben").withDependent("obj").and(SpellingRules.typoReplacement("gegeben")), NodePattern.N.form("F\u00fcssen").andOr(NodePattern.N.withDependent("det(:poss)?|amod", NodePattern.N.pos(".*DAT:PLU.*")), NodePattern.N.withHead("obl", NodePattern.N.lemma("treten"))).and(SpellingRules.typoReplacement("F\u00fc\u00dfen")), NodePattern.N.form("wichen?").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").and(SpellingRules.typoRegexReplacement("wi(.+)", "Wo$1")), NodePattern.N.form("cer").noDependents().markAs("Cer").andOr(NodePattern.N.withHead("de[pt]", NodePattern.N.noDependents("det", NodePattern.not(NodePattern.N.alreadyMarkedAs("Cer")))), NodePattern.N.withHeadRelation("nsubj")).and(SpellingRules.typoReplacement("der")), NodePattern.N.form("auf").withHead("case", NodePattern.N.pos("SUB.*").noForm("Weise|Stelle").withHead("obl", NodePattern.N.lemma("entfernen").noDependents("expl:pv", ReflexivePronouns.accReflexivPronomen))).and(SpellingRules.typoReplacement("aus")), NodePattern.N.form("haute").withHeadRelation("advmod").and(SpellingRules.typoReplacement("heute")), NodePattern.N.form("entgegen").andOr(NodePattern.N.withDependent("aux", NodePattern.N.lemma("lassen")), NodePattern.N.withHead("compound:prt", NodePattern.N.lemma("lassen"))).and(SpellingRules.typoReplacement("entgehen")), NodePattern.N.form("keim").andOr(NodePattern.N.withHeadRelation("nmod|det").noDependents().beforeHead(), NodePattern.N.withDependent("appos", NodePattern.N.directlyAfterHead().pos("SUB:(NOM:SIN:(NEU|MAS)|AKK:SIN:NEU)"))).and(SpellingRules.typoReplacement("kein")), NodePattern.N.inFormSequence(0, "leben", "und", "tot").andNot(NodePattern.N.withDependent("conj", NodePattern.N.form("tot").withDependent("cop"))).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), "Leben und Tod")).withMessage("Meinten Sie \u201eLeben und Tod\u201c?")), NodePattern.N.form("bein").withHeadRelation("case|dep").withNextSibling(NodePattern.N.withHeadRelation("amod").form(".+en")).and(SpellingRules.typoReplacement("beim")), CommonPatterns.firstChildPhrase.form("ja").directlyBefore(NodePattern.or(NodePattern.N.pos("ADJ:PRD:KOM"), NodePattern.N.form("mehr"))).and(SpellingRules.typoReplacement("je")), NodePattern.N.form(".+[^st]s").andOr(NodePattern.N.noPos(), NodePattern.N.form("meins")).andNot(CommonPatterns.upperCase).andOr(NodePattern.N.withHead("aux(:pass)?", NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.N.form("er"))), NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noDependents("aux(:pass)?|cop").withDependent("nsubj", NodePattern.N.form("er"))).and(SpellingRules.typoRegexReplacement("(.+)s", "$1t")), NodePattern.N.form("nach").withNextSibling(NodePattern.N.lemma("Tag|Nacht|Monat|Jahr.*").withDependent("case", NodePattern.N.form("am|in|im")).withDependent("det|amod", NodePattern.N.form("(de[mrn])?selben"))).and(SpellingRules.typoReplacement("noch")), NodePattern.N.form("et").andOr(NodePattern.N.withHeadRelation("nsubj(:pass)?|expl"), NodePattern.N.withHead("cc", NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noDependents("nsubj(:pass)?|expl")).andNot(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "al|seqq?|pass", "\\.")))).and(SpellingRules.typoReplacement("er", "es")), NodePattern.N.form("m?ach").andOr(isPrep, NodePattern.N.inFormSequence(2, "viele", "gr(\u00fc|ue)(\u00df|ss)e", ".+"), NodePattern.N.directlyBefore(NodePattern.N.label("GEO_POLITICAL_ENTITY")).directlyAfter(NodePattern.N.label("GEO_POLITICAL_ENTITY").withDependent("case", NodePattern.N.form("von"))), NodePattern.N.directlyBefore(NodePattern.N.pos("ADV:LOK")).directlyAfter(NodePattern.N.pos("ADV:LOK").withDependent("case", NodePattern.N.form("von")))).and(SpellingRules.typoReplacement("nach")), NodePattern.N.form("dir").directlyAfter(NodePattern.N.form("mir")).directlyBefore(NodePattern.or(NodePattern.N.pos("SUB.*SIN:FEM"), NodePattern.N.pos("SUB.*PLU.*"))).andNot(NodePattern.N.withHead("iobj", NodePattern.N.withHeadRelation("csubj").withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()))).and(SpellingRules.typoReplacement("die")), NodePattern.N.form("(.*(kontrabass(es)?|bratsche|cellos?|harfen?|geigen?|gitarren?|violas?|violinen?)|klavier)seiten?").and(SpellingRules.typoRegexReplacement("(.+)seite(n?)", "$1saite$2")), NodePattern.N.form(".*(buchs?|lekt\u00fcre)saiten?").and(SpellingRules.typoRegexReplacement("(.+)saite(n?)", "$1seite$2")), NodePattern.N.form("such").noDependents().andOr(NodePattern.N.withHeadRelation("expl:pv"), NodePattern.N.directlyAfter(NodePattern.N.lemma("lassen"))).and(SpellingRules.typoReplacement("sich")), NodePattern.N.form("sehr").andOr(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj", NodePattern.N.form("ihr"))), NodePattern.N.directlyAfter(NodePattern.N.form("ihr")), NodePattern.N.withHead("advmod", NodePattern.N.onlyPos("(SUB|EIG|PRO).*").noDependents("cop").and(CommonPatterns.possiblyConj(NodePattern.N.withHead("obj", NodePattern.N.withDependent("nsubj", NodePattern.N.form("ihr"))))))).andNot(advmodToAdj).and(SpellingRules.typoReplacement("seht")), NodePattern.or(advmodToAdj, NodePattern.or(CommonPatterns.lastChildPhrase, NodePattern.N.withNextSibling(NodePattern.PUNCT.and(CommonPatterns.lastChildPhrase))).withHeadRelation("dep")).form("seht?").and(SpellingRules.typoReplacement("sehr")), NodePattern.N.form("Reflektion(en)?").and(SpellingRules.typoRegexReplacement("reflektion(en)?", "Reflexion$1")), NodePattern.N.form("veganisch(e[rnsm]?)?").message("H\u00e4ufiger Fehler: Die korrekte Schreibweise ist \u201evegan\u201c").correct(NodeCorrector.regexReplace("(vegan)isch(.*)", "$1$2")), NodePattern.or(NodePattern.N.form("t\u00e4tig.*").withDependent("nummod", NodePattern.N.beforeHead().markAs("Number")), NodePattern.N.form("\\d+t\u00e4tig.*").markAs("Number")).and((word, match) -> {
            Node number = match.getMarkedNode("Number");
            String numPart = number.lowForm().contains("t\u00e4tig") ? number.lowForm().replaceAll("(.+)t\u00e4tig.*", "$1") : number.lowForm();
            String wordPart = word.lowForm().replaceAll(".*t\u00e4tig(.*)", "t\u00e4gig$1");
            String replacement = numPart + "-" + wordPart;
            return match.withCorrector(NodeCorrector.rawReplace(number.startOffset(), word.endOffset(), replacement)).withMessage("Meinten Sie \u201e" + replacement + "\u201c?");
        }), NodePattern.N.form("ausklinken").withHead("xcomp", NodePattern.N.lemma("lassen").withDependent("obj", NodePattern.N.form(".*(abend|tag)|urlaub|sommer|fr\u00fchling"))).and(SpellingRules.typoReplacement("ausklingen")), NodePattern.N.form("ausklingst").and(SpellingRules.typoReplacement("ausklinkst", "ausklingt")), NodePattern.N.form("Sichtweise").withDependent("case", NodePattern.N.form("in|au(ss|\u00df)er")).and(SpellingRules.typoReplacement("Sichtweite")), NodePattern.N.form("Sichtweite").withDependent("amod", NodePattern.N.lemma("subjektiv")).and(SpellingRules.typoReplacement("Sichtweise")), NodePattern.N.lemma("bedenken").withDependent("obj", ReflexivePronouns.accReflexivPronomen).and(SpellingRules.typoRegexReplacement("bedenk(.*)", "bedank$1")), NodePattern.N.form("versengt(en?)?").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.or(NodePattern.N.lemma(".*(schiff|boot|bohrinsel|see|k\u00fcste|flotte)|armada|dampfer|flugzeugtr\u00e4ger|fluss|fregatte|kreuzer|(kriegs)?marine|meer|ozean|(s\u00fcd|nord)?atlantik|pazifik|zerst\u00f6rer"), NodePattern.N.form("\u00f6lplattform(en)?"))).and(SpellingRules.typoRegexReplacement("versengt(en?)?", "versenkt$1")), NodePattern.N.form("doller").andOr(NodePattern.N.withDependent("nummod"), NodePattern.N.directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.form("US")))).and(SpellingRules.typoReplacement("Dollar")), NodePattern.N.form("merz").andOr(NodePattern.N.noLabel("PERSON"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition), NodePattern.N.withDependent("flat", GermanDateChecker.monthName), NodePattern.N.withHead("flat", GermanDateChecker.monthName)).and(SpellingRules.typoReplacement("M\u00e4rz")), NodePattern.N.form("modale?").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").and(SpellingRules.typoRegexReplacement(".+l(e)?", "Modul$1")), NodePattern.or(NodePattern.N.form("got(en?)?").withHeadRelation("amod").beforeHead().and(SpellingRules.typoRegexReplacement("got(.*)", "gut$1")), NodePattern.N.form("got(en?)?|gut(en)?").andOr(NodePattern.N.withHead("amod|appos", NodePattern.N.form("alles")).directlyAfterHead().and(SpellingRules.typoReplacement("Gute")), CommonPatterns.capitalized.withDependent("nsubj", NodePattern.N.form("alles").directlyBeforeHead()).and(SpellingRules.typoReplacement("gut", "Gute")))), looksLikeNameTitle.form("freu").and(SpellingRules.typoReplacement("frau")), NodePattern.N.form("danks").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("(d|ein)es"))).and(SpellingRules.typoReplacement("danke")), NodePattern.N.form("fiele?").noDependents("nsubj|csubj|ccomp|i?obj|a(dv)?cl").andOr(NodePattern.N.noDependents("cc|punct", NodePattern.N.beforeHead()), NodePattern.N.withHead("conj", NodePattern.N.noDependents("nsubj(:pass)?|csubj"))).and(SpellingRules.typoRegexReplacement("f(.*)", "v$1")), NodePattern.N.form("und").andOr(NodePattern.N.withHeadRelation("ob[jl]"), NodePattern.N.withHead("dep", NodePattern.or(Case.mayHaveArg("refl"), Case.mayHaveArg("DRefl"))).directlyAfterHead(), NodePattern.N.markAs("Und").directlyAfter(NodePattern.N.lemma("sagen").withDependent("obj|conj", NodePattern.N.form("Bescheid").after("Und")))).and(SpellingRules.typoReplacement("uns")), NodePattern.N.form("kamm").andOr(NodePattern.N.withDependent("xcomp", NodePattern.N.pos("VER:INF.*")), NodePattern.N.withDependent("csubj")).and(SpellingRules.typoReplacement("kann")), NodePattern.N.form("lies").markAs("Lies").withDependent("nsubj", NodePattern.N.noPos(".*PLU.*").andOr(NodePattern.N.form("du").and(NodePattern.markedNodeMatches("Lies", NodePattern.N.noDependents("xcomp").correct(NodeCorrector.replace("liest")))).message("Meinten Sie eine Form von \u201elesen\u201c?"), NodePattern.N.form("ich").and(NodePattern.markedNodeMatches("Lies", NodePattern.N.correct(NodeCorrector.replace("lie\u00df")))).message("Meinten Sie eine Form von \u201elassen\u201c?"), NodePattern.markedNodeMatches("Lies", NodePattern.N.correct(NodeCorrector.replace("lie\u00df")).andOr(NodePattern.N.noDependents("xcomp").correct(NodeCorrector.replace("liest")).message("Meinten Sie eine Form von \u201elassen\u201c oder \u201elesen\u201c?"), NodePattern.N.message("Meinten Sie eine Form von \u201elassen\u201c?"))))), NodePattern.N.inFormSequence(0, "im", "bezug", "auf").message("H\u00e4ufiger Fehler: Die Redewendung lautet korrekt \u201ein Bezug auf\u201c").correct(NodeCorrector.replace("in")), NodePattern.N.inFormSequence(1, "in", "(alle|de)[mns]", "Regel").and(SpellingRules.typoRegexReplacement("(alle|de).", "$1r")), NodePattern.N.inFormSequence(0, "letzte[msr]", "endes").and(SpellingRules.typoReplacement("letzten")), NodePattern.N.inFormSequence(1, "rote", "arme[^e]?", "fraktion").and(SpellingRules.typoReplacement("armee")));
        NodePattern copula = NodePattern.N.withHeadRelation("cop");
        NodePattern extraLetter = NodePattern.or(NodePattern.N.form("abgekartert(e[mnsr]?)?").and(SpellingRules.typoRegexReplacement("abgekarter(.+)", "abgekarte$1")), NodePattern.N.form("Gesetzte?").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").and(SpellingRules.typoRegexReplacement("(.+)t(e?)", "$1$2")), NodePattern.N.form("gr\u00f6\u00dfter").withDependent("cop").and(SpellingRules.typoReplacement("gr\u00f6\u00dfer")), NodePattern.N.form("bitter").withHead("advmod", NodePattern.N.withDependent("aux", NodePattern.N.form("k\u00f6nnt?en|kannst"))).and(SpellingRules.typoReplacement("bitte")), NodePattern.N.inFormSequence(2, "in|aus|zu", "der", "zweit").and(SpellingRules.typoReplacement("Zeit")), NodePattern.N.form("des").withHead("nsubj(:pass)?|expl", NodePattern.N.noHeadRelation("appos")).andOr(NodePattern.N.withHead(NodePattern.N.withHead("acl", NodePattern.N.pos(".*MAS.*"))).and(SpellingRules.typoReplacement("der")), SpellingRules.typoReplacement("es")), NodePattern.N.form("besonderes").andOr(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.withHead("amod", NodePattern.N.withHeadRelation("xcomp").onlyPos("AD[JV].*"))).and(SpellingRules.typoReplacement("besonders")), NodePattern.N.inFormSequence(1, "zu", "seien").andOr(NodePattern.N.withHeadRelation("det:poss").and(SpellingRules.typoReplacement("seinen")), copula.and(SpellingRules.typoReplacement("sein"))), NodePattern.N.form("Freunde").withDependent("det(:poss)?", NodePattern.N.form("[msd]?eine|ihre|unsere|eue?re")).withDependent("amod", NodePattern.N.form("gro(\u00df|ss)e|riesige|(klitze)?kleine|mega")).and(SpellingRules.typoReplacement("Freude")), NodePattern.N.form("gilbt").withDependent("expl", NodePattern.N.form("es")).and(SpellingRules.typoReplacement("gibt", "gilt")), NodePattern.N.form("f\u00fchr").withHeadRelation("case").and(SpellingRules.typoReplacement("f\u00fcr")), NodePattern.N.form("Entsetzten").withDependent("case", NodePattern.N.form("mit|zu")).and(SpellingRules.typoReplacement("Entsetzen")), NodePattern.N.form("Besch\u00e4ftigen").withDependent("det:poss|nummod").and(SpellingRules.typoReplacement("Besch\u00e4ftigten")), NodePattern.N.form("bis?t").andOr(NodePattern.N.withHeadRelation("case|advmod"), NodePattern.N.inFormSequence(2, "von", "\\d+", ".+", "\\d+")).and(SpellingRules.typoReplacement("bis")), NodePattern.N.form("ideen").withDependent("nmod", GermanDateChecker.monthName).and(SpellingRules.typoReplacement("Iden")), NodePattern.N.lemma("a[bn]hacken").andOr(NodePattern.N.withDependent("iobj|obl", NodePattern.N.lemma(".*liste")), NodePattern.N.directlyAfter(NodePattern.N.form(".*liste"))).and(SpellingRules.typoRegexReplacement("(.+)hack(.+)", "$1hak$2")), NodePattern.N.form("Hacken").withDependent("det", NodePattern.N.form("eine[mn]")).and(SpellingRules.typoReplacement("Haken")), NodePattern.or(NodePattern.N.form("H\u00e4ckchen").and(SpellingRules.typoReplacement("H\u00e4kchen")), NodePattern.N.form("Hacken").and(SpellingRules.typoReplacement("Haken"))).andOr(NodePattern.N.withHead("obj", NodePattern.N.lemma("setzen")), NodePattern.N.withDependent("amod", NodePattern.N.lemma("gesetzt"))), NodePattern.N.inFormSequence(1, "jetzt", "erste").noHeadRelation("amod").and(SpellingRules.typoReplacement("erst")), NodePattern.N.form("Stiel").andOr(NodePattern.N.withDependent("advmod", NodePattern.N.form("nicht")).withDependent("cop"), NodePattern.N.withDependent("amod", NodePattern.N.lemma("gut|schlecht")), NodePattern.N.withDependent("case", NodePattern.N.form("i[nm]")).withDependent("amod", NodePattern.N.lemma("gro\u00df"))).and(SpellingRules.typoReplacement("Stil")), NodePattern.N.form("etwas").withHead("advmod", NodePattern.or(NodePattern.N.withHeadRelation("det").lemma("ein"), NodePattern.N.withHead("nummod", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root")))).and(SpellingRules.typoReplacement("etwa")), NodePattern.N.form("(vor|nach)nahmen?").andOr(NodePattern.N.withHead("obl", NodePattern.N.lemma("hei\u00dfen")), NodePattern.N.withHead("nmod", NodePattern.N.pos("EIG.*").withHead("xcomp", NodePattern.N.lemma("hei\u00dfen"))), NodePattern.N.withDependent("det(:poss)?")).and(SpellingRules.typoRegexReplacement("(.+)nahme(n)?", "$1name$2")), NodePattern.N.form("nachnamen?").withDependent("case", NodePattern.N.form("per")).and(SpellingRules.typoRegexReplacement("(.+)name(n)?", "$1nahme$2")), withNominalDependents.form("sich").noDependents("nsubj.*").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("au(\u00df|ss)er"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("selbst"))).andNot(NodePattern.N.withHead("obj", ReflexivePronouns.reflexiveVerb)).and(SpellingRules.typoReplacement("Sicht")), NodePattern.N.form("Halbachtstellung").and(SpellingRules.typoReplacement("Habachtstellung")), NodePattern.N.form("meistern").withHeadRelation("amod").and(SpellingRules.typoReplacement("meisten")), NodePattern.N.form("interessante").andNot(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("amod|dep"))).noDependents("amod|det.*").and((n, match) -> match.withCorrector(NodeCorrector.rawReplace(n.textRange(), "interessant"))).message("Meinten Sie \u201einteressant\u201c?"), NodePattern.N.inFormSequence(2, "auf", "jeden", "Fall(e|e?s)").withDependent("det", NodePattern.N.directlyBeforeHead()).and(SpellingRules.typoReplacement("Fall")), NodePattern.N.inFormSequence(2, "in", "aller|der", "Regeln").withDependent("det", NodePattern.N.directlyBeforeHead()).and(SpellingRules.typoReplacement("Regel")), NodePattern.N.inFormSequence(1, "zum", "vorschein.+").withHead(NodePattern.N.lemma("kommen|bringen")).and(SpellingRules.typoReplacement("Vorschein")), NodePattern.N.form("im").directlyBefore(NodePattern.N.form("es|mich|dich|sich|euch|sie|ihn").withHead("ob[lj]", Case.mayHaveArg("umA"))).and(SpellingRules.typoReplacement("um")), SpellingRules.wiederWiderX());
        NodePattern linksRechtsAdv = NodePattern.N.form("hinten|unten|oben|vorne|mehr|weiter|nach|(ein)?mal|also|etwas|dort|da|hier");
        NodePattern numUhr = NodePattern.N.form("Uhr").withDependent("nummod", NodePattern.N.directlyBeforeHead());
        NodePattern missingLetter = NodePattern.or(NodePattern.N.form("fr\u00fche").withDependent("case", comparisonNotNounHead).message("Meinten Sie \u201efr\u00fcher\u201c?").and((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.textRange(), "fr\u00fcher"))), NodePattern.N.form("mach(e[rnsm]?)?").withHeadRelation("det|amod").and(SpellingRules.typoRegexReplacement("ma(.+)", "man$1")), NodePattern.N.form("sportartig(e[rnsm]?)?").noHeadRelation("advmod").and(SpellingRules.typoRegexReplacement("sportartig(.*)", "sportlich$1")), NodePattern.N.form("doppel").withHeadRelation("advmod").and(SpellingRules.typoReplacement("doppelt")), NodePattern.N.form("Phasen?").withDependent("amod", NodePattern.N.form("(hohl|abgedroschen)e[mnsr]?")).and(SpellingRules.typoRegexReplacement("Ph(.+)", "Phr$1")), NodePattern.N.form("hole[mnsr]?").withHeadRelation("amod").and(SpellingRules.typoRegexReplacement("ho(.+)", "hoh$1")), NodePattern.or(NodePattern.N.form("ic|ch"), NodePattern.N.form("i").directlyBefore(CommonPatterns.letterWord).and(CommonPatterns.highlightWithTrailingSpace())).noLabel(".*").noDependents().and(CommonPatterns.possiblySkipUp("conj", NodePattern.N.withHeadRelation("nsubj"))).andOr(CommonPatterns.firstWord.and(SpellingRules.typoReplacement("Ich")), SpellingRules.typoReplacement("ich")), NodePattern.N.form("Herzen").withDependent("amod", NodePattern.N.form("schweren").directlyBeforeHead()).noDependents("case").and(SpellingRules.typoReplacement("Herzens")), NodePattern.N.form("beenden").withDependent("advmod", NodePattern.N.form("dabei")).withHead("xcomp", NodePattern.N.lemma("lassen")).and(SpellingRules.typoReplacement("bewenden")), NodePattern.N.form("auslad").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").and(SpellingRules.typoReplacement("Ausland")), NodePattern.N.form("un").andOr(NodePattern.N.withHead("mark|cc", NodePattern.N.pos(".*INF.*").andOr(NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()), NodePattern.N.pos(".*EIZ.*"))).and(SpellingRules.typoReplacement("um")), NodePattern.not(NodePattern.N.directlyBefore(GermanTreePatterns.apos.noSpaceBefore())).withHead("cc", NodePattern.N.anyPos().andNot(numUhr)).noLabel(".*").and(SpellingRules.typoReplacement("und")), NodePattern.N.withHead("case|cc", numUhr).and(SpellingRules.typoReplacement("um"))), NodePattern.N.form("is").andNot(NodePattern.N.directlyBefore(GermanTreePatterns.apos.noSpaceBefore())).withHead("cop", NodePattern.not(GermanTreePatterns.englishWord).pos(".*")).and(SpellingRules.typoReplacement("ist")), NodePattern.N.form("auto").withHead("nsubj", SemanticRules.directSpeechVerb).withDependent("det", NodePattern.N.pos(".*NOM:SIN:MAS.*")).and(SpellingRules.typoReplacement("Autor")), NodePattern.N.form("(arbeits|((ausland|bundestag)s|mehrpersonen)?wahl|bibel|(bl\u00fcten|staub)blatt|dickschichtschalt|drehstrom|fach(arbeits)?|gleichspannungs|gro(\u00df|ss)|halb|himmels|h\u00f6llen|innen|korn|land|polar|regel|sammler|schalt|schl\u00fcssel|senats|stein|viertel|wechselstrom|widerstands|wissenschaftler)krisen?").and(SpellingRules.typoRegexReplacement("(.+)krise(n?)", "$1kreise$2")), NodePattern.N.form("B(\u00fc|ue)cken?").withHead("obj", NodePattern.N.lemma("abbrechen|bauen|schlagen|sperren|\u00fcberqueren")).and(SpellingRules.typoRegexReplacement("B(\u00fc|ue)(.+)", "Br\u00fc$2")), NodePattern.N.form("osten").withDependent("case|amod", NodePattern.N.form("an|frohe|fr\u00f6hliche|gesegnete|sch\u00f6ne|(be)?vor|zu")).and(SpellingRules.typoReplacement("Ostern")), NodePattern.N.form("bis(s|ch)en").andOr(NodePattern.N.withDependent("det", NodePattern.N.form("ein")).and(SpellingRules.typoReplacement("bisschen")), NodePattern.or(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("xcomp"))).and(SpellingRules.typoReplacement("ein bisschen"))), NodePattern.N.inFormSequence(0, "lieben", "gerne?").and(SpellingRules.typoReplacement("liebend")), NodePattern.N.form("feien?").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("i(m|ns?)").andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.withHead(NodePattern.N.inFormSequence(0, ".+", "und", "Hansestadt")))), NodePattern.N.withHeadRelation("amod")).and(SpellingRules.typoRegexReplacement("f(.+)", "Fr$1")), NodePattern.N.form("wenigsten").withHeadRelation("advmod").noDependents().and(SpellingRules.typoReplacement("wenigstens", "zumindest")), NodePattern.N.form("sonder").withHead("cc", NodePattern.N.noForm("Zweifel|Tadel")).and(SpellingRules.typoReplacement("sondern")), NodePattern.N.form("(bei|binde|code|droh|(m\u00e4nner)?ehren|eigenschafts|eingabe|erb|fach|frage|fremd|gegensatz|geleit|gru(nd|\u00df|ss)|hilfs|inhalts|kenn|koffer|kurz|leit|l\u00f6sungs|macht|merk|misch|mundart|(zufalls)?pass|schlag|.*schl\u00fcssel|schluss|stamm|stich|zahl|zeit)orte?s?").and(SpellingRules.typoRegexReplacement("(.+)ort(e?s?)", "$1wort$2")), NodePattern.N.form("ab(e|en|t)?|ast|at").andOr(NodePattern.N.withHeadRelation("aux"), NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").withDependent("obj|nsubj")).and(SpellingRules.typoRegexReplacement("(.+)", "h$1")), NodePattern.N.form("gesichte").withDependent("det(:poss)?").andOr(NodePattern.N.withDependent("det(:poss)?", NodePattern.N.form("(unser|eue?r|ihr)e")).and(SpellingRules.typoReplacement("Gesichter")), SpellingRules.typoReplacement("Geschichte")), NodePattern.N.form("teilname").and(SpellingRules.typoReplacement("Teilnahme")), NodePattern.or(NodePattern.N.inFormSequence(1, "keine", "wall?"), NodePattern.N.inFormSequence(2, "qual", "der", "wall?")).and(SpellingRules.typoReplacement("Wahl")), NodePattern.N.form("bereit").withHead("advmod", NodePattern.N.lemma("bestehend")).and(SpellingRules.typoReplacement("bereits")), NodePattern.N.form("au").spaceAfter().withHeadRelation("case").and(SpellingRules.typoReplacement("aus", "auf")), NodePattern.N.form("dm").directlyAfter(NodePattern.or(Case.datPreposition, Case.accDatPreposition, Case.genDatPreposition).andNot(AdjDeclination.anyFusedPreposition)).directlyBefore(NodePattern.N.pos("SUB:DAT:SIN:(MAS|NEU).*")).and(SpellingRules.typoReplacement("dem")), NodePattern.N.form("wir").withHeadRelation("cop").and(SpellingRules.typoReplacement("wird")), NodePattern.N.form("wicht").withDependent("advmod", NodePattern.N.directlyBeforeHead()).and(SpellingRules.typoReplacement("wichtig")), NodePattern.N.form("er").withHeadRelation("det").andNot(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.form(":"))).and(SpellingRules.typoReplacement("der")), NodePattern.N.form("dan").withDependent("amod", NodePattern.N.form("(viel|herzlich|best|liebst)en").directlyBeforeHead()).and(SpellingRules.typoReplacement("Dank")), NodePattern.N.form("sprach").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("case|det(:poss)?|amod").andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andOr(NodePattern.N.withDependent("amod|det", AgreementSet.detWithPlural).and(SpellingRules.typoReplacement("Sprachen")), SpellingRules.typoReplacement("Sprache")), NodePattern.N.form("sich").withDependent("cop").and(SpellingRules.typoReplacement("sicher")), NodePattern.N.form(".+[^st]s").andOr(NodePattern.N.noPos(), NodePattern.N.form("meins|bis")).andNot(CommonPatterns.upperCase).andOr(NodePattern.N.withHead("aux(:pass)?", NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.N.form("du"))), NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noDependents("aux(:pass)?|cop").withDependent("nsubj", NodePattern.N.form("du"))).and(SpellingRules.typoRegexReplacement("(.+s)", "$1t")), NodePattern.N.form("ich").directlyAfter(CommonPatterns.possiblySkipUp("aux", Case.mayHaveArg("refl")).directlyAfter(NodePattern.N.form("ich"))).and(SpellingRules.typoReplacement("mich")), NodePattern.N.form("gen\u00fcgen").withHead("advmod", NodePattern.N.lemma("geben").withDependent("nsubj|expl", NodePattern.N.form("es"))).and(SpellingRules.typoReplacement("gen\u00fcgend")), NodePattern.N.form("schuss").andOr(NodePattern.N.withDependent("cop", NodePattern.N.form("sein")).withDependent("aux", NodePattern.N.lemma("m\u00fcssen")), NodePattern.N.withHead("nsubj", NodePattern.N.form("sein").withDependent("aux", NodePattern.N.lemma("m\u00fcssen")))).and(SpellingRules.typoReplacement("Schluss")), NodePattern.N.form("geragt").andOr(NodePattern.N.withDependent("obj|aux:pass"), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("nach|um")))).and(SpellingRules.typoReplacement("gefragt")), NodePattern.N.form("brachs?t").andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj", NodePattern.N.form("ihr")))).andOr(NodePattern.N.withDependent("xcomp").and(SpellingRules.typoRegexReplacement(".+(chs?t)", "brau$1")), NodePattern.N.withDependent("obj").andOr(NodePattern.N.noDependents("iobj|compound:prt").and(SpellingRules.typoReplacement("braucht", "brachte")), SpellingRules.typoReplacement("brachte"))), NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl").withDependent("det(:poss)?").andOr(NodePattern.N.form("Plante?").and(SpellingRules.typoReplacement("Planet")), NodePattern.N.form("Planten").and(SpellingRules.typoReplacement("Planeten"))), NodePattern.N.form("da").andOr(NodePattern.or(NodePattern.N.withHeadRelation("det"), NodePattern.N.directlyAfter(NodePattern.N.withHead("case", NodePattern.N.pos(".*(NOM|AKK):SIN:NEU.*").markAs("Head"))).directlyBefore(CommonPatterns.skipUp("advmod", NodePattern.N.withHead("amod", NodePattern.N.alreadyMarkedAs("Head"))))).message("Meinten Sie \u201edas\u201c?"), GermanTreePatterns.firstInPhraseAfterCommasOrConj.noDependents().withHead("advmod", CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root")).withDependent("cop").noHeadRelation("xcomp").noDependents("[cn]subj(:pass)?|expl")).andOr(NodePattern.N.directlyBefore(copula.correct(NodeCorrector.insertAfter(" es"))), NodePattern.N.directlyAfter(copula.correct(NodeCorrector.insertBefore("es ")))).message("Fehlt \u201ees\u201c oder meinten Sie \u201edas\u201c?")).correct(NodeCorrector.replace("das")), NodePattern.N.form("breit").withHead("xcomp|advmod", NodePattern.N.lemma("erkl\u00e4ren|zeigen")).and(SpellingRules.typoReplacement("bereit")), NodePattern.N.form("bereit").inFormSequence(2, "lang|weit", "und", ".+").and(SpellingRules.typoReplacement("breit")), NodePattern.N.form("iden").withDependent("det:poss").and(SpellingRules.typoReplacement("Ideen")), NodePattern.N.form("entscheiden").withDependent("cop").noDependents("mark").and(SpellingRules.typoReplacement("entscheidend", "entschieden")), NodePattern.N.form("les|lie\u00df").withDependent("iobj", NodePattern.N.form("dir")).and(SpellingRules.typoReplacement("lies")), NodePattern.N.form("verendet").withDependent("aux(:pass)?", NodePattern.N.form("w[eou]rden?|wird")).and(SpellingRules.typoReplacement("versendet", "verwendet")), NodePattern.N.form("geendet").withDependent("aux(:pass)?", NodePattern.N.form("w[eou]rden?|wird")).and(SpellingRules.typoReplacement("gesendet", "gewendet")), NodePattern.N.form("kaffe|caff?[\u00e8\u00e9\u00eae]").withHead("obj", NodePattern.N.lemma("trinken|machen|m\u00f6gen")).andNot(CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("appos|flat"))).and(SpellingRules.typoReplacement("Kaffee")), NodePattern.N.form("punk").andOr(NodePattern.N.withDependent("amod", NodePattern.N.form("(dunkl|springend|entscheidend|h\u00f6chst|tiefst|tot|fraglich|gr\u00fcn|wichtig|strittig|schwach|wund|heikl|zentral|neuralgisch)e[mnsr]?")), NodePattern.N.withDependent("case", NodePattern.N.form("in")).withDependent("det").directlyBefore(NodePattern.not(CommonPatterns.HYPHEN_LIKE_NODE)), NodePattern.N.inFormSequence(0, ".+", "und|,", "komma")).and(SpellingRules.typoReplacement("Punkt")), NodePattern.N.form("Harz").directlyBefore(NodePattern.N.form("4|IV")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "Hartz IV")).message("Meinten Sie \u201eHartz IV\u201c?"), NodePattern.N.form("Hartz").andOr(NodePattern.N.withDependent("det"), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition)).withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.PUNCT)).and(SpellingRules.typoReplacement("Harz")), NodePattern.N.form("rohes").withHead("amod", NodePattern.or(NodePattern.N.form("schaffen|.*fest|weihnachten|wiedersehe?n|beisammensein|miteinander|einleben|neues"), NodePattern.N.form("jahr"))).and(SpellingRules.typoReplacement("frohes")), NodePattern.N.form("erden?").andOr(NodePattern.N.withHeadRelation("aux(:pass)?"), NodePattern.N.directlyAfter(NodePattern.N.withHead("nsubj", NodePattern.N.pos(".*(PA2|INF).*")))).and(SpellingRules.typoRegexReplacement("(.+)", "w$1")), NodePattern.N.form("(link|recht)").withOnlyDependents(NodePattern.N.withHeadRelation("case|conj|advmod|punct")).andOr(NodePattern.N.withDependent("advmod", linksRechtsAdv), NodePattern.N.withHead("advmod", linksRechtsAdv), NodePattern.N.withDependent("case", NodePattern.N.form("nach"))).and(SpellingRules.typoRegexReplacement("(.+[kt])", "$1s")).andOptionally(NodePattern.N.withHead("obj", NodePattern.N.lemma("sehen|\u00f6ffnen|klicken")).noDependents("det(:poss)?").correct(NodeCorrector.replace("den Link"))), NodePattern.N.form("urzeit").andOr(NodePattern.N.withDependent("conj", NodePattern.N.form("datum|(wochen)?tag")), NodePattern.N.withHead("conj", NodePattern.N.form("datum|(wochen)?tag")), NodePattern.N.withDependent("amod", NodePattern.N.lemma("genau|exakt|dasselbe")), NodePattern.N.withDependent("case", NodePattern.N.form("um|zu")).withDependent("det")).and(SpellingRules.typoReplacement("Uhrzeit")), NodePattern.N.form("eigne[mnsr]?").withHeadRelation("amod").and(SpellingRules.typoRegexReplacement("eigne(.?)", "eigene$1")), NodePattern.N.form(".*impflicht.*").and(SpellingRules.typoRegexReplacement("(.*)mpflicht(.*)", "$1mpfpflicht$2")), NodePattern.N.form("im").andNot(isPrep).noDependents(NodePattern.not(isPrep)).andNot(NodePattern.N.directlyBefore(isPrep)).withHead(NodePattern.N.pos("VER:.*")).and(SpellingRules.typoReplacement("ihm")), NodePattern.N.lemma("leben").withDependent("obj", NodePattern.N.pos("PRO:PER.*").noPos("ART.*")).noDependents("compound:prt").correct(ChangeLemma.to("lieben")).message("Meinten Sie eine Form von \u201elieben\u201c?"), NodePattern.N.form("kein(e[mnrs]?)?").andOr(NodePattern.N.markAs("Kein").withHead("nmod|det(:poss)?", NodePattern.N.withDependent("det(:poss)?", NodePattern.N.before("Kein"))), NodePattern.N.inFormSequence(2, "ein", "paar", ".*")).and(SpellingRules.typoRegexReplacement("kein(.*)", "klein$1")), NodePattern.N.form("leide").withHeadRelation("advmod").and(SpellingRules.typoReplacement("leider")), NodePattern.or(NodePattern.N.lemma("schie(\u00df|ss)en").correct(ChangeLemma.to("schlie\u00dfen")).message("Meinten Sie eine Form von \u201eschlie\u00dfen\u201c?"), NodePattern.N.lemma("abschie(\u00df|ss)en").correct(ChangeLemma.to("abschlie\u00dfen")).message("Meinten Sie eine Form von \u201eabschlie\u00dfen\u201c?"), NodePattern.N.lemma("verschie(\u00df|ss)en").correct(ChangeLemma.to("verschlie\u00dfen")).message("Meinten Sie eine Form von \u201everschlie\u00dfen\u201c?")).andOr(NodePattern.N.withDependent("obj|nsubj:pass", NodePattern.N.lemma("Akte|Betrieb|Gesch\u00e4ft|Fenster|Frieden|L\u00fccke|Pforte|(.*t|T)\u00fcr|Vertrag")), NodePattern.N.withDependent("advmod", NodePattern.N.form("luftdicht")), NodePattern.N.withDependent("compound:prt", NodePattern.N.form("zusammen")), NodePattern.N.withDependent("obj", NodePattern.N.form("sich"))), NodePattern.N.lemma("zusammenschie(\u00df|ss)en").correct(ChangeLemma.to("zusammenschlie\u00dfen")).message("Meinten Sie eine Form von \u201ezusammenschlie\u00dfen\u201c?"), NodePattern.N.lemma("anschie(\u00df|ss)end").correct(ChangeLemma.to("anschlie\u00dfen")).message("Meinten Sie eine Form von \u201eanschlie\u00dfen\u201c?"), NodePattern.N.lemma("verscho(\u00df|ss)en").withHead("amod", NodePattern.N.lemma("T\u00fcr|Brief(umschlag)?|Dose|Sack|Treppenaufgang|Zimmer|Truhe|Mund|Giftschrank|Herz(kranzgef\u00e4(\u00df|ss))?|Beh\u00e4lter")).correct(ChangeLemma.to("verschlossen")).message("Meinten Sie eine Form von \u201everschlossen\u201c?"), NodePattern.or(NodePattern.N.form("gr\u00fc\u00df(es)?|gru\u00dfen?"), NodePattern.N.form("gr\u00fcss(en?)?|grussen?").andNot(GermanParameters.VARIANT.withValue("CH"))).withDependent("amod", NodePattern.N.directlyBeforeHead().markAs("Adj")).andOr(NodePattern.N.noDependents("case").and(SpellingRules.restoreGreeting(Case.AKK)), NodePattern.N.withDependent("case", NodePattern.N.form("mit")).and(SpellingRules.restoreGreeting(Case.DAT))), NodePattern.N.form("w(ue?|\u00fc)nsc?h").withDependent("obj", NodePattern.N.form("gl(\u00fc|ue?)c?k").directlyBeforeHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "Gl\u00fcckwunsch")).message("Meinten Sie \u201eGl\u00fcckwunsch\u201c?"), NodePattern.N.form("viel|best").noDependents().withHead("amod|det|dep", NodePattern.N.onlyPos(".*PLU.*").noDependents("case")).correct(NodeCorrector.insertAfter("e")).message("Falsche Adjektivendung?"), NodePattern.N.form("machen").andOr(NodePattern.N.withHeadRelation("det|[na]mod"), NodePattern.N.directlyAfter(isPrep).withHead(NodePattern.N.pos("SUB.*"))).and(SpellingRules.typoReplacement("manchen")), NodePattern.N.form("de").andOr(NodePattern.N.withHead("det", NodePattern.N.markAs("Head")), NodePattern.N.withHead("nmod", NodePattern.N.markAs("Head")).withPrevSibling(isPrep), NodePattern.N.withDependent("appos", NodePattern.N.markAs("Head").directlyAfterHead())).noLabel("PERSON").and((art, match) -> {
            Node head = match.getMarkedNode("Head");
            AgreementSet headAgrSet = AgreementSet.create(head);
            if (headAgrSet == null) {
                return null;
            }
            AgreementSet.Gender gender = head.hasPos(".*FEM.*") ? AgreementSet.Gender.FEM : (head.hasPos(".*MAS.*") ? AgreementSet.Gender.MAS : (head.hasPos(".*NEU.*") ? AgreementSet.Gender.NEU : AgreementSet.Gender.ALG));
            AgreementSet.Number number = head.hasPos(".*SIN.*") ? AgreementSet.Number.SIN : AgreementSet.Number.PLU;
            FeatureRestriction<Case> cazeList = AgreementSet.calcPossibleCases(head);
            ArrayList<String> articleVariants = new ArrayList<String>();
            for (Case caze : cazeList.allowed()) {
                String variant = Articles.getDefArticleForm(art, caze, number, gender);
                if (variant == null) {
                    return match;
                }
                articleVariants.add(variant);
            }
            return match.withCorrector(NodeCorrector.replace(art, articleVariants));
        }).message("Meinten Sie einen bestimmten Artikel?"), NodePattern.N.withHeadRelation("amod").beforeHead().noDependents().andOr(NodePattern.N.form(".*[^t]en?").onlyPos("VER.*").andNot(NodePattern.N.pos("VER:IMP.*").withHead(NodePattern.ROOT)).and(node -> node.tree().treeSupport().tagToken(node.form().replaceAll("^(.*[^t])(en?)$", "$1t$2")).hasPos(".*PA2.*")).and(SpellingRules.typoRegexReplacement("(.*[^t])(en?)", "$1t$2")), NodePattern.N.form(".*test").onlyPos("VER.*").and(SpellingRules.typoRegexReplacement("(.*tes)t", "$1"))), NodePattern.N.inFormSequence(1, "letzten", "enden?").and(SpellingRules.typoReplacement("endes")), NodePattern.N.form("zu[nsr]?").withHead("case", NodePattern.N.form("vorschein").withHead(NodePattern.N.lemma("kommen|bringen"))).directlyBeforeHead().and(SpellingRules.typoReplacement("zum")), NodePattern.N.form("bis").withHeadRelation("aux(:pass)?|cop").and(SpellingRules.typoReplacement("bist")), NodePattern.N.form("gegen").andOr(NodePattern.N.directlyBefore(NodePattern.N.lemma("haben|werden")), NodePattern.N.withHead(NodePattern.N.lemma("haben|werden")).andNot(NodePattern.N.withNextSibling(NodePattern.not(NodePattern.PUNCT)))).and(SpellingRules.typoReplacement("gegeben")), NodePattern.N.form("n\u00e4chten?").andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.withDependent("appos")).and(SpellingRules.typoRegexReplacement("(n\u00e4ch)(.+)", "$1s$2")), CommonPatterns.lowerCase.form(".+e").pos("ADJ.*").markAs("Adj").andOr(NodePattern.or(NodePattern.ROOT, NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).withDependent("cop").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("als").directlyAfter("Adj"))), NodePattern.N.withHeadRelation("advmod").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("als").directlyAfter("Adj")))).and(SpellingRules.typoRegexReplacement("(.+)", "$1r")), NodePattern.N.form("gets?").and(CommonPatterns.possiblyConj(NodePattern.ROOT)).andOr(NodePattern.N.form("gets").and(SpellingRules.typoReplacement("geht\u2019s", "geht es")), NodePattern.or(NodePattern.N.withDependent("nsubj"), NodePattern.N.withDependent("obj", NodePattern.N.form("es")).noDependents("nsubj")).and(SpellingRules.typoReplacement("geht"))).andNot(NodePattern.N.withPhraseStart(GermanTreePatterns.openingQuotation)));
        NodePattern withPrefix = NodePattern.N.withDependent("compound:prt");
        NodePattern wrongLetterOrder = NodePattern.or(NodePattern.or(NodePattern.N.form("zweifel").andOr(NodePattern.N.withDependent("compound:prt", NodePattern.N.form("an")), NodePattern.N.withDependent("conj", NodePattern.N.onlyPos("VER.*")), CommonPatterns.firstWord.withDependent("advmod", NodePattern.N.pos("ADJ:PRD:GRU|NEG").afterHead())), NodePattern.N.form("(ver|be)zweifel")).noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andNot(withNominalDependents).noDependents("cop").and(SpellingRules.typoRegexReplacement("(.*)zweifel", "$1zweifle")), NodePattern.or(NodePattern.N.form("aufgewaschen").and(SpellingRules.typoReplacement("aufgewachsen")), NodePattern.N.form("wusch").and(SpellingRules.typoReplacement("wuchs"))).withDependent("nmod|obl", NodePattern.N.label("GEO_POLITICAL_ENTITY").withDependent("case", NodePattern.N.form("in"))), Case.esGehtArg.form("hinnen").and(SpellingRules.typoReplacement("Ihnen")), NodePattern.N.form("gewaschen").withDependent("obl", NodePattern.N.inFormSequence(1, "ans", "Herz")).and(SpellingRules.typoReplacement("gewachsen")), NodePattern.N.form("du").withHead("nsubj", NodePattern.N.form(".+ts").noPos().and(SpellingRules.typoRegexReplacement("(.+)ts", "$1st"))), NodePattern.N.form("sei").withHeadRelation("nsubj(:pass)?").and(SpellingRules.typoReplacement("sie")), NodePattern.N.form("bereist").andOr(NodePattern.N.withHeadRelation("advmod"), withPrefix).and(SpellingRules.typoReplacement("bereits")), NodePattern.N.form("verwandet").and(SpellingRules.typoReplacement("verwandte")).andOptionally(NodePattern.N.noDependents("det.*|amod").and(SpellingRules.typoReplacement("verwandelt"))), NodePattern.N.inFormSequence(1, "wie", "(geh|l\u00e4uf)st").andOr(NodePattern.N.withDependent("ob[lj]", NodePattern.N.form("dir")), NodePattern.N.withDependent("obl", NodePattern.N.inFormSequence(1, "bei", "dir|euch"))).andOr(NodePattern.N.noDependents("nsubj|expl", NodePattern.N.form("es").directlyAfterHead()).and(SpellingRules.typoRegexReplacement("(.+)st", "$1t es")), SpellingRules.typoRegexReplacement("(.+)st", "$1t")), NodePattern.N.form("singel.*").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root"))).noPos(".*").noLabel(".*").and(SpellingRules.typoRegexReplacement("singel(.*)", "single$1")));
        NodePattern englishSpellingPlural = NodePattern.or(NodePattern.N.form(".+ies").noPos().and(GermanTreePatterns.englishWord).and(CommonPatterns.capitalized).and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root"))).andNot(NodePattern.N.withDependent("compound|flat", GermanTreePatterns.englishWord.andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.directlyAfterHead()))).andNot(NodePattern.N.label(".*").noForm("(Derb|Husk)ies")).noForm("(Cadd|Girl)ies").andNot(NodePattern.N.inFormSequence(2, "grand", "old", "ladies")).message("Die korrekte eingedeutschte Pluralform wird mit \u201e-ys\u201c geschrieben").and((node, match) -> {
            String germanWord = node.form().substring(0, node.form().length() - 3) + "ys";
            if (node.tree().treeSupport().tagToken(germanWord).hasPos("SUB.*")) {
                return match.withCorrector(NodeCorrector.replace(node, germanWord));
            }
            return null;
        }), NodePattern.or(NodePattern.N.form("agendas").and(SpellingRules.typoReplacement("Agenden")), NodePattern.N.form("albatross").and(SpellingRules.typoReplacement("Albatros"))).withDependent("det.*|[an]mod", NodePattern.N.anyPos()));
        NodePattern beschwerdenBeschwerde = NodePattern.N.form("beschwerd(en?)?").andOr(NodePattern.N.withDependent("nsubj"), NodePattern.N.withDependent("obj", ReflexivePronouns.accReflexivPronomen)).andOr(NodePattern.N.form("beschwerd").and(SpellingRules.typoReplacement("beschwert")), NodePattern.N.withDependent("aux", NodePattern.N.pos("VER:MOD.*")).and(SpellingRules.typoReplacement("beschweren")), SpellingRules.typoRegexReplacement("beschwerd(.*)", "beschwer$1"));
        NodePattern XXerJahre = NodePattern.or(NodePattern.N.form("(1\\d|20)?[23456789]0g?e[mns]?").and(SpellingRules.typoRegexReplacement("(.+)0g?e[mns]?", "$10er")), NodePattern.N.form("(1\\d|20)?[23456789]0gern?").and(SpellingRules.typoRegexReplacement("(.+)0ger(n?)", "$10er$2"))).andOr(NodePattern.N.withHead("amod", NodePattern.N.form("jahren?")), NodePattern.N.withDependent("det(:poss)?"));
        NodePattern XXster = NodePattern.N.form("[1-9]\\d+(zi)?gste[mnsr]").withHeadRelation("amod").correct(NodeCorrector.regexReplace("(\\d+)[^\\d]+(e[mnsr])", "$1st$2")).correct(NodeCorrector.regexReplace("(\\d+)[^\\d]+(e[mnsr])", "$1.")).message("Verwenden Sie eine der korrekten Schreibweisen");
        NodePattern markedHead = noun.markAs("Head");
        NodePattern ordinalNumbers = NodePattern.or(Capitalization.cardinal, NodePattern.N.form("(.+zig|.+zehn|eins)")).and(zal).andOr(NodePattern.N.withHead("amod", markedHead).beforeHead(), NodePattern.N.withHead("conj|dep", NodePattern.or(numbers.withHead("amod", markedHead), markedHead.withDependent("amod", numbers)))).and((node, match) -> {
            Node head = match.getMarkedNode("Head");
            String basicForm = node.hasForm(".+zig") ? node.form() + "st" : (node.hasForm("eins") ? "erst" : (node.hasForm("drei") ? "dritt" : (node.hasForm("sieben") ? "siebt" : (node.hasForm("acht") ? "acht" : node.form() + "t"))));
            List<String> newAdj = StyleRules.getAdjLikeForm(basicForm, head);
            return match.withCorrector(NodeCorrector.replace(node, newAdj)).withMessage("Meinten Sie \u201e" + newAdj.get(0) + "\u201c?");
        });
        NodePattern nounWithHeadHaben = NodePattern.N.withHead("obl", NodePattern.N.lemma("haben"));
        String replacement = "zur Folge";
        NodePattern zurFolge = NodePattern.or(NodePattern.N.inFormSequence(0, "zu", "folge").withNeighbor(1, nounWithHeadHaben).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("dem"))).message("Meinten Sie \u201e" + replacement + "\u201c?").correct(NodeCorrector.replace(replacement).join(NodeCorrector.replace(NodePointer.neighbor(1), ""))), NodePattern.N.form("zufolge").withHead("case", nounWithHeadHaben).and(SpellingRules.typoReplacement(replacement)));
        NodePattern beletage = NodePattern.N.inFormSequence(1, "Belle", "Etagen?").message("Meinten Sie \u201eBeletage\u201c?").correct(NodeCorrector.regexReplace("e(tage.*)", "Bele$1").join(NodeCorrector.replace(NodePointer.neighbor(-1), "")));
        NodePattern toZuInfinitive = to.withHead("mark", NodePattern.N.pos("VER:INF.*")).directlyBeforeHead().message("Meinten Sie \u201ezu\u201c?").correct(NodeCorrector.replace("zu"));
        NodePattern zurVerfuegung = NodePattern.or(NodePattern.N.inFormSequence(1, "zur?", "Verfugung").noDependents("nmod|appos|flat", NodePattern.N.afterHead()).andOr(NodePattern.N.withHead(NodePattern.or(NodePattern.N.lemma("(ste(h|ll)|hab|geb)end?").andNot(withPrefix), NodePattern.N.withHead("obj", NodePattern.N.lemma("ste(h|ll)en|haben|geben").andNot(withPrefix)))), NodePattern.N.withDependent("cop")).message("Meinten Sie \u201ezur Verf\u00fcgung\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "zur Verf\u00fcgung")), NodePattern.N.lemma("verfugen").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("\u00fcber"))).and(SpellingRules.typoRegexReplacement("verfu(.*)", "verf\u00fc$1")));
        return NodePattern.or(NodePattern.or(SpellingRules.mehrMehrereMeer(), SpellingRules.sylvesterSilvester(), SpellingRules.adjectiveToAdverb(), toZuInfinitive, zurVerfuegung, SpellingRules.seidSeinSeit(), SpellingRules.mirMit(), befindetMan, often, relaxed, SpellingRules.adverbOnly(), SpellingRules.adjectiveOnly(), dessenWords, froheFreue, waerenWaehrend, keinKann, beiVon, passport, nextNaechst, anschliessend, insgesamt, totTod, stetsStehtEs, SpellingRules.wieWir(), SpellingRules.wiesWieEs(), wahrWar, dieDu, SpellingRules.eiIe(), SpellingRules.vW(), SpellingRules.geminateIssues(), wrongLetter, extraLetter, wrongLetterOrder, missingLetter, SpellingRules.weisenWissen(), SpellingRules.fixCollocations(), SpellingRules.noNr(), SpellingRules.liegenLegen(), SpellingRules.fuehlenFuellen(), SpellingRules.inklusiveInclusive(), SpellingRules.sitzenSetzen(), englishSpellingPlural, SpellingRules.englishWords()).andNot(NodePattern.N.withDependent("punct", GermanTreePatterns.anyQuotation.beforeHead().markAs("LeftQ")).withDependent("punct", GermanTreePatterns.anyQuotation.afterHead().markAs("RightQ")).noDependents(NodePattern.N.between("LeftQ", "RightQ").andOr(NodePattern.N.spaceBefore(), NodePattern.N.spaceAfter()))), SpellingRules.fixMisshapedAdj(), SpellingRules.fixMisshapedNoun(), SpellingRules.fixMisshapedDet(), SpellingRules.fixMisshapedPtcp(), beschwerdenBeschwerde, SpellingRules.unlikelyCafeKaffee(), zurFolge, beletage, XXerJahre, XXster, ordinalNumbers, SpellingRules.umlautIssues());
    }

    private static NodePattern unlikelyCafeKaffee() {
        NodeCorrector.Relative toCafe = NodeCorrector.replace("Caf\u00e9");
        NodeCorrector.Relative toKaffee = NodeCorrector.replace("Kaffee");
        return NodePattern.or(cafeKaffee.withHead("obj", geniessen).andOr(NodePattern.N.form("caf.+").withDependent("det", NodePattern.N.pos("ART:IND.*SIN:MAS.*").correct(NodeCorrector.replace("ein"))).correct(toKaffee), NodePattern.N.form("kaf.+").withDependent("det", NodePattern.N.pos("ART:IND.*SIN:NEU.*").correct(NodeCorrector.replace("einen"))).correct(toCafe)).message("Meinten Sie den Ort \u201eCaf\u00e9\u201c oder das Getr\u00e4nk \u201eKaffee\u201c?"), unlikelyCafeKaffee.andOr(NodePattern.N.form("caf.+").and((node, match) -> SemCompatibility.getCompatibility(node.copyWithForm("Kaffee"), match.getMarkedNode("Predicate")) == SemCompatibility.Likely ? match : null).message("Meinten Sie das Getr\u00e4nk \u201eKaffee\u201c?").correct(toKaffee), NodePattern.custom((node, match) -> SemCompatibility.getCompatibility(node.copyWithForm("Caf\u00e9"), match.getMarkedNode("Predicate")) == SemCompatibility.Likely ? match : null).message("Meinten Sie den Ort \u201eCaf\u00e9\u201c?").correct(toCafe))).noDependents("flat|appos");
    }

    private static NodePattern canBeSofortigNouns() {
        return NodePattern.N.lemma(".*(Zahlung|Ma(\u00df|ss)nahme|Wirk(ung|samkeit)|Sanktion|Ende|R\u00fcck(kehr|tritt)|Freigabe|Stopp|Schutz|Bedarf|Reaktion|Beschwerde|Trennung|Handeln|Hilfe|Erledigung)");
    }

    private static NodePattern wiederWiderX() {
        NodePattern widerX = NodePattern.N.withHead("advmod", NodePattern.N.form("(will|erwart)en|wissens?").noDependents("nsubj(:pass)?|i?obj|obl"));
        return NodePattern.or(NodePattern.or(NodePattern.N.form("wieder").andOr(widerX, NodePattern.N.inFormSequence(0, ".+", "bessere[ns]", "wissens?")), NodePattern.N.form("wiederwill(e|ig.*)")).and(SpellingRules.typoRegexReplacement("wieder(.*)", "wider$1")), NodePattern.N.form("wider").withHeadRelation("advmod|mark").andNot(widerX).and(SpellingRules.typoReplacement("wieder")));
    }

    private static NodePattern mehrMehrereMeer() {
        NodePattern toMehrere = SpellingRules.typoReplacement("mehrere");
        return NodePattern.N.form("mehre[msrn]?").andOr(NodePattern.N.withHead("det|amod", NodePattern.N.pos("SUB.*")).andOr(NodePattern.N.form("mehren").and(SpellingRules.typoReplacement("mehreren")), NodePattern.or(NodePattern.N.withHeadRelation("amod").withHead(NodePattern.N.pos(".*PLU.*")), NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "Seiten", "lang(e[rnsm]?)?")), NodePattern.N.directlyBeforeHead().withHead(NodePattern.or(SemanticRules.units, SemanticRules.timeUnit.withHead(NodePattern.N.withHeadRelation("advmod")).directlyBeforeHead())), NodePattern.N.withHead(NodePattern.N.withDependent("nummod", NodePattern.N.beforeHead()))).and(toMehrere), NodePattern.N.andOptionally(NodePattern.N.form("mehre").withHead(NodePattern.N.pos(".*PLU.*")).correct(NodeCorrector.replace("mehrere"))).and(SpellingRules.typoReplacement("mehr"))), NodePattern.N.form(".*Mehre").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andOr(NodePattern.N.noDependents(NodePattern.N.beforeHead()).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("davon")), NodePattern.N.withDependent("nmod", NodePattern.or(NodePattern.N.onlyPos("SUB:GEN.*"), NodePattern.N.withDependent("case", NodePattern.N.form("von"))))).and(toMehrere), NodePattern.N.withDependent("det(:poss)?").and(SpellingRules.typoReplacement("Meere"))));
    }

    private static NodePattern weisenWissen() {
        NodePattern werden = NodePattern.N.lemma("werden");
        NodePattern es = NodePattern.N.form("es");
        return NodePattern.N.form("weis[ts]?|we?isen").noPos("EIG:.*").noLabel("PERSON").noDependents("compound:prt").andNot(CommonPatterns.upperCase).noDependents("ob[lj]", NodePattern.N.withDependent("case", NodePattern.N.form("hin").afterHead().andOr(CommonPatterns.lastWord, NodePattern.N.directlyBefore(CommonPatterns.comma)))).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("auf|von"))).noDependents("obj", NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("von")))).andOr(NodePattern.N.form("wisen").withDependent("amod|det(:poss)?", NodePattern.N.onlyPos(".*SIN.*")).and(SpellingRules.typoReplacement("Wissen")), NodePattern.N.form("we?isen").noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|amod").andOr(NodePattern.N.withDependent("aux|ccomp"), NodePattern.N.withDependent("mark", zu), NodePattern.N.withDependent("obj", es).noDependents(werden)).andNot(NodePattern.N.withDependent("obl", NodePattern.N.inFormSequence(2, "in", "die", "Schranken"))).andNot(NodePattern.N.withDependent("obj", es).withDependent("aux", werden)).and(SpellingRules.typoReplacement("wissen")), NodePattern.N.form("weist?").withDependent("nsubj", NodePattern.N.form("du")).andOr(GermanParameters.VARIANT.withValue("CH").and(SpellingRules.typoReplacement("weisst")), SpellingRules.typoReplacement("wei\u00dft")), NodePattern.N.form("weis").andOr(GermanParameters.VARIANT.withValue("CH").and(SpellingRules.typoReplacement("weiss")), SpellingRules.typoReplacement("wei\u00df")), NodePattern.N.noForm("we?isen").andNot(GermanParameters.VARIANT.withValue("CH")).and(SpellingRules.typoReplacement("wei\u00df")));
    }

    private static NodePattern noNr() {
        return NodePattern.N.form("no").andOr(NodePattern.N.directlyBefore(CommonPatterns.dot.directlyBefore(CommonPatterns.withNumberLikeForm).markAs("End")), NodePattern.N.directlyBefore(CommonPatterns.withNumberLikeForm).markAs("End")).and((no, match) -> match.withCorrector(NodeCorrector.rawReplace(no.startOffset(), match.getMarkedNode("End").endOffset(), "Nr."))).message("Meinten Sie die Abk\u00fcrzung f\u00fcr \u201eNummer\u201c?");
    }

    private static NodePattern liegenLegen() {
        return NodePattern.or(NodePattern.N.lemma("liegen").andOr(NodePattern.N.withDependent("obj", NodePattern.N.pos("SUB:AKK.*")), NodePattern.N.withDependent("obj", NodePattern.N.pos("PRO:REF:AKK.*")).noDependents("obl", NodePattern.N.lemma("Herz"))).noDependents("compound:prt", NodePattern.N.form("zugrunde")).noDependents("advmod", NodePattern.N.form("daran")).correct(LemmaChanges.changeOwnVerbLemma("legen").from("liegen")), NodePattern.N.lemma("legen").withDependent("obl", NodePattern.or(NodePattern.N.pos("SUB:DAT.*").noPos(".*AKK.*").noDependents("case", NodePattern.N.form("zu")), NodePattern.N.pos("PRO.*").withDependent("case"))).noDependents("obj|compound:prt|expl:pv|aux:pass").noDependents(NodePattern.N.label("PERSON").withDependent("case", NodePattern.N.form("auf"))).correct(LemmaChanges.changeOwnVerbLemma("liegen").from("legen"))).message("Verwenden Sie \u201eliegen\u201c zur Beschreibung eines Zustands und \u201elegen\u201c zur Beschreibung einer aktiven Handlung");
    }

    private static NodePattern fuehlenFuellen() {
        return NodePattern.or(NodePattern.N.lemma("f\u00fcllen").andOr(NodePattern.N.withDependent("obj", NodePattern.or(NodePattern.N.pos("PRO:REF.*"), Articles.abstractNouns.lemmaPattern)).andOr(NodePattern.N.withDependent("nsubj(:pass)?", SemanticRules.animate), NodePattern.N.withHead("csubj", NodePattern.N.withDependent("iobj", SemanticRules.animate))), NodePattern.N.withDependent("obl", SemanticRules.animate.withDependent("case", NodePattern.N.form("mit"))).noDependents("obj"), NodePattern.N.noDependents("ob[jl]|advmod").withDependent("compound:prt")).and(SpellingRules.typoRegexReplacement("f\u00fcl(.*)", "f\u00fch$1")), NodePattern.N.lemma("f\u00fchlen").andOr(NodePattern.N.withDependent("obj", NodePattern.N.pos("SUB.*").andNot(Articles.abstractNouns.lemmaPattern)).withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("in|mit")).andNot(SemanticRules.animate).noLabel(".*")), NodePattern.N.withDependent("obj", NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("mit"))).andNot(Articles.abstractNouns.lemmaPattern))).and(SpellingRules.typoRegexReplacement("f\u00fch(.*)", "f\u00fcl$1")));
    }

    private static NodePattern inklusiveInclusive() {
        NodePattern flat = NodePattern.N.withHead("flat", NodePattern.N.alreadyMarkedAs("Head"));
        NodePattern makeHyphenatedCompound = NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.marked("Head"), NodePointer.anchor(), m -> {
            String upperCasedForm = StringTools.uppercaseFirstChar((String)m.anchor().form());
            return List.of("All-inclusive-" + upperCasedForm, "Alles-inklusive-" + upperCasedForm);
        }));
        return NodePattern.or(NodePattern.N.form("inklusiv").andOr(NodePattern.N.withHeadRelation("case").beforeHead().andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("amod").pos("PA[12]:.*:VER"))), NodePattern.N.withHeadRelation("advmod").directlyAfterHead().andNot(NodePattern.N.directlyAfter(NodePattern.N.form("all")))).message("Meinten Sie die Pr\u00e4position \u201einklusive\u201c (im Sinne von \u201eeinschlie\u00dflich\u201c oder \u201emit eingeschlossen\u201c)?").correct(NodeCorrector.replace("inklusive")), NodePattern.N.inFormSequence(0, "all", "inklusive?").markAs("Head").andOr(WordSeparation.withDependentsDetCaseAmod.withNeighbor(1, NodePattern.N.withHeadRelation("advmod").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "All-inclusive"))), NodePattern.N.withNeighbor(1, flat).withNeighbor(2, flat.and(makeHyphenatedCompound)), NodePattern.N.withNeighbor(2, NodePattern.N.withDependent("compound", NodePattern.N.alreadyMarkedAs("Head")).and(makeHyphenatedCompound)), NodePattern.N.withNeighbor(1, NodePattern.N.correct(NodeCorrector.replace("inclusive")))).message("Meinten Sie \u201eall inclusive\u201c?"));
    }

    private static NodePattern sitzenSetzen() {
        NodePattern posAcc = NodePattern.N.pos(".*AKK.*");
        return NodePattern.or(NodePattern.N.lemma("sitzen"), NodePattern.N.form("gesitzt")).andOr(NodePattern.N.withDependent("obj", NodePattern.N.pos("PRO:(PER|REF).*").markAs("Obj")), NodePattern.N.withDependent("obj", posAcc).withDependent("obl", posAcc)).noDependents("mark", NodePattern.N.form("gegen\u00fcber")).noDependents("obl", NodePattern.N.pos(".*DAT.*")).message("Verwenden Sie \u201esetzen\u201c, wenn es um eine Bewegung oder Handlung geht").andOr(NodePattern.N.form("gesitzt").correct(NodeCorrector.replace("gesetzt")), NodePattern.N.form("sitz").correct(NodeCorrector.replace("setz")), NodePattern.N.andOptionally(NodePattern.N.withDependent("advmod", NodePattern.N.form("nebeneinander")).and(NodePattern.markedNodeMatches("Obj", NodePattern.N.correct(NodeCorrector.replace(""))))).correct(LemmaChanges.changeOwnVerbLemma("setzen").from("sitzen")));
    }

    private static NodePattern makeThreeWordCompound(String word1, String word2regex, String compoundPrefix, String nounReplacement) {
        NodeCorrector.Relative toRegexNounReplacement = NodeCorrector.regexReplace(NodePointer.marked("End"), word2regex, nounReplacement);
        return NodePattern.N.form(word1).and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form(word2regex).markAs("End"))).andOr(NodePattern.markedNodeMatches("End", NodePattern.N.directlyBefore(NodePattern.N.pos("SUB.*"))).and((node, match) -> {
            Node end = match.getMarkedNode("End");
            return match.withCorrector(NodeCorrector.replaceNodes(node, end.neighbor(1), compoundPrefix + end.neighbor(1).form()));
        }), NodePattern.N.correct(toRegexNounReplacement.join(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor("End", -1), ""))));
    }

    private static NodePattern wordsWithDiacritics() {
        return NodePattern.or(NodePattern.N.form(".*cafes?").noDependents("flat|appos").correct(NodeCorrector.regexReplace("(.*c)afe(s)?", "$1af\u00e9$2")), NodePattern.N.lemma("Dekolletes?").correct(LemmaChanges.changeSameGenderNounLemma("Dekollet\u00e9")).correct(LemmaChanges.changeSameGenderNounLemma("Dekolletee")), NodePattern.N.form("Resumes?").noDependents("flat", GermanTreePatterns.englishWord).andNot(NodePattern.N.withHead("conj", GermanTreePatterns.englishWord)).correct(NodeCorrector.regexReplace("Resume(s)?", "R\u00e9sum\u00e9$1")).correct(NodeCorrector.regexReplace("Resume(s)?", "Res\u00fcmee$1")), NodePattern.N.form("Exposes?").correct(NodeCorrector.regexReplace("Expose(s)?", "Expos\u00e9$1")).correct(NodeCorrector.regexReplace("Expose(s)?", "Exposee$1")), NodePattern.N.form(".*negliges?").andOr(GermanParameters.VARIANT.withValue("CH").correct(NodeCorrector.regexReplace("(.*n)eglige(s)?", "$1\u00e9glig\u00e9$2")), NodePattern.N.correct(NodeCorrector.regexReplace("(.*n)eglige(s)?", "$1eglig\u00e9$2"))), NodePattern.N.form(".*crepes?").noForm("Tenso.*").correct(NodeCorrector.regexReplace("(.*c)repe(s)?", "$1r\u00eape$2")), NodePattern.N.form(".*creperie([sn])?").correct(NodeCorrector.regexReplace("(.*c)reperie([sn])?", "$1r\u00eaperie$2")), NodePattern.N.form(".*(canapee?s?)").correct(NodeCorrector.regexReplace("(.*)canapee?(s)?", "$1kanapee$2")).correct(NodeCorrector.regexReplace("(.*)canapee?(s)?", "$1canap\u00e9$2")), NodePattern.N.form("Charite").label("ORGANIZATION").correct(NodeCorrector.replace("Charit\u00e9")), NodePattern.N.form(".*attaches?").noDependents("obj").andNot(NodePattern.N.withHead(NodePattern.N.lemma("(an|bei|hinzu|ein)(h\u00e4ngen|f\u00fcg(ung|en))|(ver)s[ae]nd(en)?|beig[ae]ben?|\u00fcbertrag(ung|en)|beil[ae]gen?|(up|down)load(en)?|anlage|import(ieren)|(drauf|an)klicken|\u00f6ffnen|ausw\u00e4hlen"))).correct(NodeCorrector.regexReplace("(.*a)ttache(s)?", "$1ttach\u00e9$2")), NodePattern.N.form(".*proteges?").correct(NodeCorrector.regexReplace("(.*p)rotege(s)?", "$1roteg\u00e9$2")), NodePattern.N.form("Marinieren?").noPos("VER.*").correct(NodeCorrector.regexReplace("Mariniere(n)?", "Marini\u00e8re$1")), aLaPreposition, NodePattern.N.form("t[\u00eae]te").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("a").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("t[\u00eae]tes?").markAs("End"))))).reportEverythingTouched().andOr(WordSeparation.withDependentsDetCaseAmod.and((node, match) -> {
            Node end = match.getMarkedNode("End");
            return match.withCorrector(NodeCorrector.replaceNodes(node, end, "T\u00eate-\u00e0-" + (end.hasForm(".+s") ? "T\u00eates" : "T\u00eate")));
        }), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "t\u00eate-\u00e0-t\u00eate"))), NodePattern.N.form("Frappes?").correct(NodeCorrector.regexReplace("Frappe(s)?", "Frapp\u00e9$1")).correct(NodeCorrector.regexReplace("Frappe(s)?", "Frappee$1")), NodePattern.N.form("Boucles?").correct(NodeCorrector.regexReplace("Boucle(s)?", "Boucl\u00e9$1")).correct(NodeCorrector.regexReplace("Boucle(s)?", "Bouclee$1")), NodePattern.N.form("Bouchees?").correct(NodeCorrector.regexReplace("Bouchee(s)?", "Bouch\u00e9e$1")), SpellingRules.makeThreeWordCompound("Deja", "vu(s)?", "D\u00e9j\u00e0-vu-", "D\u00e9j\u00e0-vu$1"), SpellingRules.makeThreeWordCompound("Apres?", "ski", "Apr\u00e8s-Ski-", "Apr\u00e8s-Ski"), NodePattern.N.form("Dejavu(s)?").andOr(NodePattern.N.withNeighbor(1, NodePattern.N.pos("SUB.*")).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), "D\u00e9j\u00e0-vu-" + node.neighbor(1).form()))), NodePattern.N.correct(NodeCorrector.regexReplace("Dejavu(s)?", "D\u00e9j\u00e0-vu$1"))), NodePattern.N.form("rose").andOr(NodePattern.N.withDependent("det", NodePattern.N.pos(".*SIN:MAS.*")), NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma("Wein")))).andOr(NodePattern.N.directlyBefore(NodePattern.N.lemma("Wein")).andOr(NodePattern.N.spaceBefore().and((rose, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(rose, " Ros\u00e9-"))), NodePattern.N.noSpaceBefore().and((rose, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(rose, "Ros\u00e9-")))), NodePattern.N.correct(NodeCorrector.replace("Ros\u00e9")))).message("Dieses Wort wird mit einem diakritischen Zeichen geschrieben");
    }

    private static NodePattern englishWords() {
        return NodePattern.or(NodePattern.N.form("Risks?").and(SpellingRules.typoRegexReplacement("Risk(s?)", "Risiko$1")), NodePattern.N.form("Garden").and(SpellingRules.typoReplacement("Garten")), NodePattern.N.form("Gardens").and(SpellingRules.typoReplacement("G\u00e4rten")));
    }

    private static NodePattern spellOutNumbersEinhalb() {
        return NodePattern.N.form("([1-9]|[1-9][0-9]|100)einhalb").andOr(NodePattern.N.form("([1-9]|10)einhalb").message("Schreiben Sie die Zahl aus oder in Dezimalform").and((node, match) -> {
            String number = node.form().substring(0, node.form().indexOf("einhalb"));
            String spelledNumber = Objects.requireNonNull(SpellingRules.spellOut(Integer.parseInt(number)));
            return match.withCorrector(NodeCorrector.replace(node, spelledNumber + "einhalb"));
        }), NodePattern.N.message("Wandeln Sie das ganze Wort in Dezimalzahl um")).correct(NodeCorrector.regexReplace("(.*)einhalb", "$1,5"));
    }

    private static NodePattern spellOutOrdinalKlaessler() {
        return NodePattern.N.inFormSequence(0, "[1-9]|1[012]", "\\.", "Kl\u00e4ssler[sn]?").withNeighbor(1, NodePattern.N.markAs("Punct")).reportRangeTo("Punct").message("Schreiben Sie die Zahl aus").and((node, match) -> {
            String spelledNumber = Objects.requireNonNull(SpellingRules.spellOutOrdinalNumbers(Integer.parseInt(node.form())));
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), StringTools.uppercaseFirstChar((String)spelledNumber) + node.neighbor(2).lowForm()));
        });
    }

    @Nullable
    static String spellOut(int number) {
        if (number < 13 && number >= 0) {
            return compoundPartNumbers0_12[number];
        }
        return null;
    }

    @Nullable
    static String spellOutOrdinalNumbers(int number) {
        if (number < 13 && number > 0) {
            return ordinalStems0_12[number];
        }
        return null;
    }
}

