/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.SentenceCapitalizationRule;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.Gender;
import ai.grazie.rules.de.GermanMetadata;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.LemmaChanges;
import ai.grazie.rules.de.Redundancy;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.document.Metadata;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.TreeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.languagetool.tools.StringTools;

class StyleRules {
    private static final String MULTI_EXCLAMATION = "Verwenden Sie ein einzelnes Ausrufezeichen";
    private static final String MULTI_PUNCTUATION = "Verwenden Sie ein einzelnes Satzzeichen";
    private static final String EXCLAMATION_MARK = "Verwenden Sie beim formellen Schreiben keine Ausrufezeichen";
    private static final String SMILEY_USE_MSG = "Entfernen Sie das Smiley, um den Text formeller zu gestalten";
    private static final String EMOJI_USE_MSG = "Entfernen Sie das Emoji, um den Text formeller zu gestalten";
    private static final String SINN_MACHEN_MSG = "\u201eSinn machen\u201c kommt aus dem Englischen und gilt im Deutschen als umgangssprachlich";
    private static final String COLLOQUIAL_SPEECH_MSG = "Verwenden Sie beim formellen Schreiben keine umgangssprachlichen W\u00f6rter und Ausdr\u00fccke";
    public static final String CONTRACTION_MSG = "Vermeiden Sie Kurzformen im formellen Stil";
    public static final String RACIST_TERMS_MSG = "Verwenden Sie keine rassistischen W\u00f6rter und Ausdr\u00fccke";
    public static final String ANONYMER_NAME_MSG = "Personen bleiben anonym, wenn sie ihren Namen verschweigen, nicht die Namen selbst";
    private static final String OFFICE_BUERO_MSG = "\u201eOffice\u201c k\u00f6nnte als Stilbruch oder unn\u00f6tiger Fremdwortgebrauch gelten";
    private static final String PASSIV_MSG = "\u00dcberlegen Sie sich eine aktive Sprache zu benutzen, um den Satz klarer, dynamischer und pers\u00f6nlicher zu gestalten";
    private static final String GUCKEN_TO_NEUTRAL_VERB_MSG = "\u201e$_\u201c ist umgangssprachlich, stilistisch neutraler sind \u201eschauen\u201c oder \u201esehen\u201c";
    private static final Map<String, String> replacements = Map.of("mir", "meinetwegen", "dir", "deinetwegen", "ihr", "ihretwegen", "ihm", "seinetwegen", "Ihnen", "Ihretwegen", "ihnen", "ihretwegen", "denen", "derentwegen", "uns", "unseretwegen", "euch", "euretwegen");
    private static final NodePattern mergedPreposition = NodePattern.N.form("au[fs]m|aufn|(hinter|\u00fcber|unter|vor)[smn]");
    private static final String SENT_START_MSG = "Das erste Wort im Satz wird gro\u00dfgeschrieben";
    private static final Metadata.Key<Integer> key = new Metadata.Key<Integer>(GermanMetadata.sentenceCapitalization){

        @Override
        protected void serialize(DataOutput out, Integer value) throws IOException {
            out.writeVInt(value.intValue());
        }

        @Override
        protected Integer deserialize(DataInput in) throws IOException {
            return in.readVInt();
        }

        @Override
        protected int fingerprint() {
            return 0;
        }
    };
    private static final NodePattern wordsOnGraph = NodePattern.N.form("(un)?((fluoreszenz)?angio|.*bi(bli)?o|(bau|geb\u00e4ude|infrarot)?thermo|(bio|human|wirtschafts)?geo|(kampf|tanz)?choreo|(computer|koh\u00e4renz|kernspin|magnetresonanz|positronenemissions|volumen)?tomo|demo|disko|(doppler|duplex|endo|mamma)?sono|echokardio|elasto|elektro(enzephalo|kardio|myo|neuro|thermo)|ethno|(farb|foto|chromo|stereo)?litho|(gaschro|[kc]ine|chro)mato|.*porno|hagio|historio|holo|hydro|ikono|kalli|kardio(toko)?|karto|(knochen|myokard|schilddr\u00fcsen|skelett)?szinti|kosmo|kristallo|(quanten)?krypto|(landes)?topo|lexiko|(lo|mam|fil)mo|medio|metallo|(mikro)?typo|(werk)?mono|(morse)?tele|ortho|ozeano|pa(l\u00e4o|ra)|phlebo|poly(somno)?|psycho|radio|repro|se(ismo|ri)|sozio(demo)?|ste(ga)?no|stiefo|strati|szeno|video|xero|(foto)?zinko)graph(en|ie.*|in(nen)?|isch(e[srmn]?)?)?");
    private static final NodePattern wordsOnPhon = NodePattern.N.form("(a(dia)?|(ae|quad)ro|(ang|xy)lo|audi|anti|(bab|pol)y|dikta|echo|(i|ra)dio|(g|ster)eo|homo|kathodo|marimba|mega|merzi|.*mikro|mono|ortho|oto|.*saxo|sousa|vibra)phon.*");
    private static final NodePattern photoWords = NodePattern.N.form("Photo(chemi(e|grafi(e|sch)|sch)|element|effekt|elektr(isch|on|izit\u00e4t)|gramm(etri(e|sch))?|lyse|mechanisch|met(er|ri(e|sch))|(bio|physio)logi(e|sch)|kopie(ren)?|rezeptor|ph(il|ob(ie)?)|psie|periodismus|chrom|trop(isch|ie|ismus)?|satz|sensibilisierung|sph\u00e4re|synthe(se(leistung|rate)?|tisch)|ta(ktisch|xis)|therapie|typie|zelle|zinkografie).*");

    StyleRules() {
    }

    static StreamEx<Rule.PatternRule> rules() {
        NodePattern emotiveExpressions = NodePattern.or(NodePattern.N.form("Congrat(ulations?|s)|Gl(\u00fc|ue)ckw(unsch|w\u00fcnsche)|Gratul(iere|ation)"), NodePattern.or(NodePattern.N.form("Chapeau|Respekt"), NodePattern.N.form("Gefahr|Vorsicht|Achtung"), NodePattern.N.form("Wahnsinn|Spitze|Top"), NodePattern.N.form("bravo|super|klasse|toll|Hurra|Juhu")).withHeadRelation("root"), NodePattern.N.inFormSequence(1, "Hut", "ab"), NodePattern.N.inFormSequence(2, "toi", "toi", "toi"));
        return StreamEx.of((Object[])new Rule.PatternRule[]{StyleRules.normalizeSentenceStart(), new Rule.PatternRule("Style.SEHR_RULE", "Anwendung von \u201esehr + Adjektiv\u201c", "Verwenden Sie pr\u00e4gnantere W\u00f6rter anstelle von \u201esehr + Adjektiv\u201c.", "https://storyanalyse.de/blog/macht-der-worte/stumme-woerter/#a5", () -> StyleRules.sehrRule(), new Example("Auf dem Flughafen war es <b>sehr warm</b>.", "Auf dem Flughafen war es <b>hei\u00df</b>."))}).append(Gender.rules()).append((Object[])new Rule.PatternRule[]{new Rule.PatternRule("Style.EXCLAMATION_MARK", "Verwendung von Ausrufezeichen", "Verwenden Sie beim formellen Schreiben keine Ausrufezeichen.", "https://www.studysmarter.de/schule/deutsch/rechtschreibregeln/ausrufezeichen/", () -> CommonPatterns.exclamationMark(EXCLAMATION_MARK, NodePattern.N.withHead("punct", NodePattern.ROOT.and(GermanTreePatterns.whPhrase))).noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").noDependents().andNot(NodePattern.N.inFormSequence(1, "Fritz", "!", "(Box(en)?|Fons?|Powerline|WLAN|DECT|Repeater|App)")).andNot(NodePattern.N.directlyAfter(emotiveExpressions)), new Example("Rufen Sie mich bitte <b>an!</b>", "Rufen Sie mich bitte an<b>.</b>")).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.EXPRESSIVE_PUNCTUATION", "Mehrere Satzzeichen", "Verwenden Sie ein einzelnes Satzzeichen.", "https://everyday-courtesy.com/de/ist-es-unhoflich-mehrere-fragezeichen-zu-verwenden/", CommonPatterns.expressivePunctuation(MULTI_EXCLAMATION, "Verwenden Sie ein einzelnes Fragezeichen", MULTI_PUNCTUATION), new Example("Viel <b>Spa\u00df!!</b>", "Viel Spa\u00df<b>!</b>"), new Example("Wo ist der <b>Anspitzer?!?</b>", "Wo ist der Anspitzer<b>?</b>")).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.SMILEY_OR_EMOJI_USE", "Verwendung von Emoticons oder Emojis", "Emoticons und Emojis werden \u00fcblicherweise mit informeller Kommunikation in Verbindung gebracht. Vermeiden Sie sie in formellen Texten.", "https://karrierebibel.de/smileys/", () -> NodePattern.or(CommonPatterns.smileyUse(SMILEY_USE_MSG), CommonPatterns.emojiUse(EMOJI_USE_MSG)), new Example("Wir freuen uns sehr darauf <b>:)</b>", "Wir freuen uns sehr <b>darauf</b>"), new Example("Danke f\u00fcr das Update, hier ist alles in Ordnung<b>\ud83d\udc4d</b>", "Danke f\u00fcr das Update, hier ist alles in <b>Ordnung</b>")).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.CONTRACTIONS", "Auslassung", "Beim formellen Schreiben sind Auslassungen am Wort zu vermeiden.", "https://www.duden.de/sprachwissen/rechtschreibregeln/apostroph", () -> StyleRules.contractionVerb(), new Example("Ich <b>trink'</b> meinen Kaffee.", "Ich <b>trinke</b> meinen Kaffee.")).styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.COLLOQUIAL_SPEECH", "Umgangssprachliche W\u00f6rter und Ausdr\u00fccke", "Beim formellen Schreiben sind umgangssprachliche W\u00f6rter und Ausdr\u00fccke zu vermeiden.", null, () -> NodePattern.or(StyleRules.erstmal(), StyleRules.eben(), StyleRules.rVerbsOrAdverbs(), StyleRules.mergedPrepositions(), StyleRules.vorbeikommen(), StyleRules.mergedVerbs(), StyleRules.informalEndings(), StyleRules.wegenMir(), StyleRules.prepWas(), StyleRules.einPaar(), StyleRules.colloquialVerbs()), new Example("<b>Erstmal</b> werden keine Mitarbeiter entlassen.", "<b>Zun\u00e4chst</b> werden keine Mitarbeiter entlassen.", "<b>Vorerst</b> werden keine Mitarbeiter entlassen.")).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.VERB_FORMATION_COLLOQUIALISMS", "Umgangssprachliche Verbbildung", "Beim formellen Schreiben sind umgangssprachliche Verbbildungsmuster zu vermeiden.", "https://deutsch-coach.com/wuerde-und-waere/", () -> StyleRules.wuerdeAuxInf(), new Example("Auch sie <b>w\u00fcrde froh sein</b>.", "Auch sie <b>w\u00e4re froh</b>.")).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.DISCRIMINATORY_LANGUAGE", "Diskriminierende oder rassistische W\u00f6rter und Redewendungen", "Diskriminierende oder rassistische W\u00f6rter und Redewendungen sind zu vermeiden.", "https://www.wien.gv.at/verwaltung/antidiskriminierung/sprache.html", () -> StyleRules.offensiveTerms(), new Example("Kann der <b>Behinderte</b> in der Werkstatt mitarbeiten?", "Kann der <b>Mensch mit Behinderung</b> in der Werkstatt mitarbeiten?")).styleFlavor(StyleFlavor.Inclusivity).disableByDefault(), new Rule.PatternRule("Style.NAZI_ASSOCIATIONS", "Negative Konnotationen aufgrund der NS-Zeit-Assoziationen", "NS-Zeit-Assoziationen sind zu vermeiden.", "https://renk-magazin.de/ns-wortschatz-sprechen-wir-wie-nazis/", () -> StyleRules.naziAssociations(), new Example("Zu der Schule geh\u00f6rte auch ein <b>Brausebad</b>.", "Zu der Schule geh\u00f6rte auch ein <b>Duschbad</b>.")).styleFlavor(StyleFlavor.Inclusivity), new Rule.PatternRule("Style.OXYMORON", "Verwendung von gegens\u00e4tzlichen oder widerspr\u00fcchlichen Begriffen", "Vermeiden Sie gegens\u00e4tzliche oder widerspr\u00fcchliche Begriffe.", "https://www.scribbr.de/wissenschaftliches-schreiben/oxymoron/", () -> StyleRules.anonymerName(), new Example("Er war <b>unter anonymem Namen</b> unterwegs.", "Er war <b>anonym</b> unterwegs.")).styleFlavor(StyleFlavor.Readability), new Rule.PatternRule("Style.ANGLICISMS", "Verwendung von Anglizismen", "Verwenden Sie einen passenden deutschen Ausdruck anstelle des Anglizismus.", "https://blog.content.de/2014/09/12/die-deutsche-sprache-im-wandel-verfall-oder-relaunch/", () -> NodePattern.or(StyleRules.officeToBuero(), StyleRules.sinnMachen()), new Example("Kurz nach dem Mittagessen wurden wir ins <b>Office</b> gerufen.", "Kurz nach dem Mittagessen wurden wir ins <b>B\u00fcro</b> gerufen."), new Example("<b>Macht</b> es <b>Sinn</b>, dass wir das schon heute erledigen?", "<b>Ergibt</b> es Sinn, dass wir das schon heute erledigen?", "<b>Ist</b> es <b>sinnvoll</b>, dass wir das schon heute erledigen?")).styleFlavor(StyleFlavor.Readability), new Rule.PatternRule("Style.FILLER_WORDS", "F\u00fcllw\u00f6rter und -phrasen", "Vermeiden Sie F\u00fcllw\u00f6rter und -phrasen, die keine konkreten Informationen liefern.", "https://www.stil.de/kommunikations-knigge/sprachunwoerter-die-sie-nicht-mehr-verwenden-sollten-der-gegebene-anlass/", () -> StyleRules.ausGegebenemAnlass(), new Example("<b>Aus gegebenem Anlass</b> rate ich von nicht\u00e4rztlichen IPL-Enthaarungen ab.", new String[0])), new Rule.PatternRule("Style.PASSIVE_VOICE", "Passivs\u00e4tze mit erkennbaren Handelnden", "Verwenden Sie eine aktive Sprache anstelle des Passivs, um den Satz klarer und direkter zu gestalten.", "https://www.duden.de/sprachwissen/sprachratgeber/Das-Passiv", () -> StyleRules.passive(), new Example("Freitags <b>wird gearbeitet</b>.", new String[0])).disableByDefault().styleFlavor(StyleFlavor.Readability), new Rule.PatternRule("Style.UNLIKELY_FORMS", "Unerwartete grammatische Formen", "Einige grammatische Formen sind in manchen Texten unwahrscheinlich.", "https://www.duden.de/sprachwissen/sprachratgeber/konjunktiv-1-oder-2", () -> NodePattern.or(StyleRules.prohibitKonjunktiv(), StyleRules.archaicDatSg()), new Example("Im <b>Unterschiede</b> dazu <b>gehe</b> es hier um andere Sachen.", "Im <b>Unterschied</b> dazu <b>geht</b> es hier um andere Sachen.")), new Rule.PatternRule("Style.RECOMMENDED_SPELLING", "Empfohlene Schreibweisen", "Verwenden Sie die vom Duden empfohlene Schreibweise.", "https://www.duden.de/sprachwissen/sprachratgeber/beispiele-zur-neuen-rechtschreibung", () -> NodePattern.or(StyleRules.recommendedSeparation(), StyleRules.recommendedPhToF()), new Example("<b>Sowas</b> kann doch jedem passieren", "<b>So was</b> kann doch jedem passieren"), new Example("Wilhelm besch\u00e4ftigt sich mit der <b>Radiographie</b>", "Wilhelm besch\u00e4ftigt sich mit der <b>Radiografie</b>"), new Example("Eine nat\u00fcrliche Form der <b>Phototherapie</b> wird bei einer Kur am Toten Meer angewandt", "Eine nat\u00fcrliche Form der <b>Fototherapie</b> wird bei einer Kur am Toten Meer angewandt"))}).append(Redundancy.rules());
    }

    private static NodePattern archaicDatSg() {
        return AgreementSet.looksLikeArchaicDatSg.withSubstringHint("e").andNot(NodePattern.N.inFormSequence(1, "zu|nach", "Hause")).andNot(NodePattern.N.form("(zug|weg|sinn|lauf|grund)e").withDependent("case", NodePattern.N.form("im"))).and(node -> {
            AgreementSet set = AgreementSet.createRelaxed(node);
            if (set == null) {
                return false;
            }
            Set<Case> cases = set.possibleCases.allowed();
            return cases.equals(Set.of(Case.DAT)) && (set.numberRestriction == null || !set.numberRestriction.equals((Object)AgreementSet.Number.PLU));
        }).and(SpellingRules.typoRegexReplacement("(.+)e", "$1"));
    }

    static NodePattern prohibitKonjunktiv() {
        return NodePattern.N.onlyPos(".*(KJ1|IMP|1:SIN:PR\u00c4).*").pos(".*KJ1.*").form(".+e(s?t)?").and(CommonPatterns.possiblyConj(CommonPatterns.skipUp("aux", NodePattern.N.withDependent("nsubj", NodePattern.N.noForm("ich|ihr").pos(".*SIN.*").noDependents("conj").markAs("NSubj"))))).andNot(NodePattern.ROOT.withDependent(".*", NodePattern.N.directlyBeforeHead().withPrevSibling(NodePattern.N.alreadyMarkedAs("NSubj")))).andOr(NodePattern.not(CommonPatterns.skipUp("aux", NodePattern.N.withHeadRelation("ccomp"))), NodePattern.not(CommonPatterns.skipUp("aux", NodePattern.N.withDependent("nsubj", NodePattern.N.form("ihr|du"))))).andNot(NodePattern.ROOT.directlyAfter(CommonPatterns.comma.withHead("punct", NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))).directlyBefore(NodePattern.N.noForm("man"))).andNot(CommonPatterns.skipUp("aux", NodePattern.N.withHead("conj", NodePattern.or(NodePattern.N.withDependent("nsubj", NodePattern.N.form("ihr|du")), NodePattern.N.pos(".*IMP.*"))))).andNot(NodePattern.N.noHeadRelation("aux").withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.withHeadRelation("punct|conj")))).andNot(CommonPatterns.skipUp("aux", NodePattern.N.noDependents("nsubj").withHead("conj", NodePattern.N.withDependent("cop")))).noDependents("aux(:pass)?|cop|det(:poss)?").noDependents("nsubj", NodePattern.N.form("ich|ihr")).andNot(GermanTreePatterns.firstPlaceClauseConstituent.lemma("sein|m\u00f6gen").withHeadRelation("aux").before(NodePattern.N.alreadyMarkedAs("NSubj"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("als")).and(CommonPatterns.skipConjUp(CommonPatterns.skipUp("aux", NodePattern.N.withHeadRelation("advcl"))))).andOr(NodePattern.N.pos("VER.*:2:SIN:KJ1.*").correct(NodeCorrector.inflect("VER.*:2:SIN:PR\u00c4.*")), NodePattern.N.pos("VER.*:2:PLU:KJ1.*").correct(NodeCorrector.inflect("VER.*:3:SIN:PR\u00c4.*")), NodePattern.N.pos("VER.*:3:SIN:KJ1.*").correct(NodeCorrector.inflect("VER.*:3:SIN:PR\u00c4.*"))).message("Eine Konjunktivform ist hier unwahrscheinlich");
    }

    private static NodePattern prepWas() {
        return GermanTreePatterns.firstInPhraseAfterCommasOrConj.form("was").withDependent("case", NodePattern.N.form("au[fs]|an|bei|durch|in|f\u00fcr|mit|nach|neben|um|vo[nr]|zu|\u00fcber").directlyBeforeHead().andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation).withNeighbor(2, GermanTreePatterns.closingQuotation)).and((prep, match) -> {
            String replacement = prep.lowForm().matches("[aiu\u00fc].+") ? "wor" + prep.lowForm() : "wo" + prep.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(prep, prep.neighbor(1), replacement));
        })).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(CommonPatterns.upperCase).withOnlyDependents(NodePattern.N.beforeHead()).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("obl").pos("ADJ.*"))).andNot(NodePattern.N.withHead("xcomp|ob[lj]", NodePattern.N.withHeadRelation("acl"))).message("Der Gebrauch des Pronomens \u201ewas\u201c nach Pr\u00e4positionen ist in der Standardsprache zu vermeiden");
    }

    private static NodePattern wegenMir() {
        return NodePattern.N.inFormSequence(0, "wegen", "[md]ir|ih[rm]|(ihn|den)en|uns|euch").andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withDependent("appos|conj"))).and((node, match) -> {
            String nextForm = node.neighbor(1).form();
            if (replacements.containsKey(nextForm)) {
                String replacement = replacements.get(nextForm);
                return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), replacement)).withMessage("In formeller Sprache ist \u201e" + replacement + "\u201c zu bevorzugen");
            }
            return null;
        });
    }

    static AgreementSet.Gender pickGender(Node node) {
        return node.hasPos(".*MAS.*") ? AgreementSet.Gender.MAS : (node.hasPos(".*FEM.*") ? AgreementSet.Gender.FEM : (node.hasPos(".*NEU.*") ? AgreementSet.Gender.NEU : AgreementSet.Gender.MAS));
    }

    static AgreementSet.Number pickNumber(Node node, AgreementSet nodeSet) {
        AgreementSet.Number num = nodeSet.numberRestriction;
        return num != null ? num : (Gender.isReallyPlural.matches(node) ? AgreementSet.Number.PLU : AgreementSet.Number.SIN);
    }

    static List<String> getAdjLikeForm(String newAdj, Node node) {
        ArrayList<String> result = new ArrayList<String>();
        AgreementSet nodeSet = AgreementSet.createRelaxed(node);
        if (nodeSet == null) {
            return result;
        }
        AdjDeclination adjDecl = AdjDeclination.fromNPHead(node);
        for (Case caze : nodeSet.possibleCasesRestrictedByArticle()) {
            result.addAll(node.tree().treeSupport().synthesize("gut", "gut", "ADJ(:...){3}(.*)(IND|DEF|SOL)(.*)", "ADJ:" + caze.name() + ":" + String.valueOf((Object)StyleRules.pickNumber(node, nodeSet)) + ":" + String.valueOf((Object)StyleRules.pickGender(node)) + ":GRU:" + String.valueOf(adjDecl == null ? ".*" : adjDecl)).stream().map(adj -> newAdj + adj.substring(3)).toList());
        }
        return result;
    }

    private static NodePattern changeLemmaToAdjLikeNoun(String newLemma) {
        return NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replace(node, StyleRules.getAdjLikeForm(newLemma, node).stream().map(str -> StringTools.uppercaseFirstChar((String)str)).toList())));
    }

    private static NodePattern changeLemmaToAdj(String oldLemma, String newLemma) {
        return NodePattern.N.correct(NodeCorrector.regexReplace(oldLemma + "(.*)", newLemma + "$1"));
    }

    private static List<NodeCorrector> getNounReplacements(String newLemma, Node node) {
        ArrayList<NodeCorrector> result = new ArrayList<NodeCorrector>();
        AgreementSet nodeSet = AgreementSet.createRelaxed(node);
        if (nodeSet == null) {
            return result;
        }
        for (Case caze : nodeSet.possibleCases.allowed()) {
            List<String> nounFormList = node.tree().treeSupport().synthesize(newLemma, newLemma, "SUB:NOM:SIN:.*", "SUB:" + caze.name() + ":" + String.valueOf((Object)StyleRules.pickNumber(node, nodeSet)) + ":" + String.valueOf((Object)StyleRules.pickGender(node)));
            String nounForm = !nounFormList.isEmpty() ? nounFormList.get(0) : newLemma;
            result.add(NodeCorrector.replace(node, nounForm));
        }
        return result;
    }

    private static NodePattern replaceWithAdjNounNP(String adjLemma, String nounLemma) {
        return NodePattern.custom((node, match) -> {
            ArrayList<NodeCorrector> result = new ArrayList<NodeCorrector>();
            AgreementSet nodeSet = AgreementSet.createRelaxed(node);
            if (nodeSet == null) {
                return null;
            }
            AdjDeclination adjDecl = AdjDeclination.fromNPHead(node);
            AgreementSet.Number number = StyleRules.pickNumber(node, nodeSet);
            AgreementSet.Gender gender = StyleRules.pickGender(node);
            for (Case caze : nodeSet.possibleCases.allowed()) {
                String adjForm = node.tree().treeSupport().synthesize("gut", "gut", "ADJ(:...){3}(.*)(IND|DEF|SOL)(.*)", "ADJ:" + caze.name() + ":" + String.valueOf((Object)number) + ":" + String.valueOf((Object)gender) + ":GRU:" + String.valueOf(adjDecl == null ? ".*" : adjDecl)).stream().map(adj -> adjLemma + adj.substring(3)).toList().get(0);
                List<String> nounFormList = node.tree().treeSupport().synthesize(nounLemma, nounLemma, "SUB:NOM:SIN:" + String.valueOf((Object)gender), "SUB:" + caze.name() + ":" + String.valueOf((Object)number) + ":" + String.valueOf((Object)gender));
                String nounForm = !nounFormList.isEmpty() ? nounFormList.get(0) : nounLemma;
                result.add(NodeCorrector.replace(node, nounForm).join(NodeCorrector.insertBefore(node, adjForm + " ")));
            }
            return match.withCorrectors(result);
        });
    }

    private static NodePattern replaceWithNounPrepPhrase(String nounLemma, String prepPhrase) {
        return NodePattern.custom((node, match) -> match.withCorrectors(StyleRules.getNounReplacements(nounLemma, node).stream().map(corrector -> corrector.join(NodeCorrector.insertAfter(node, " " + prepPhrase))).toList()));
    }

    private static NodePattern offensiveTerms() {
        return NodePattern.or(NodePattern.or(NodePattern.N.lemma("(Neger|Nigger|Mohr)(in)?|Farbiger?").noLabel("PERSON").and(StyleRules.changeLemmaToAdjLikeNoun("schwarz")), NodePattern.N.lemma("Schwarzmarkt").and(StyleRules.replaceWithAdjNounNP("illegal", "Handelsplatz")), NodePattern.N.form("mohrenschwarz.*").correct(NodeCorrector.regexReplace("mohren(.*)", "$1")), NodePattern.N.form("schwarzafrikas?").correct(NodeCorrector.regexReplace("schwarza(.*)", "Subsahara-A$1")), NodePattern.N.form("wei(\u00df|ss)afrikas?").correct(NodeCorrector.regexReplace("wei(\u00df|ss)(.*)", "Nord$2")), NodePattern.or(NodePattern.N.form("schwarz").correct(NodeCorrector.replace("Subsahara")), NodePattern.N.form("wei(\u00df|ss)").correct(NodeCorrector.replace("Nord"))).noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE).withDependent("conj", NodePattern.N.form(".+afrikas?")), NodePattern.N.lemmaCaseSensitive("schwarzfahren").correct(NodeCorrector.regexReplace("schwarzzu(.+)", "zu $1").join(NodeCorrector.insertBefore("ohne g\u00fcltige Fahrkarte "))).correct(NodeCorrector.regexReplace("schwarz((ge)?f.+)", "$1").join(NodeCorrector.insertBefore("ohne g\u00fcltige Fahrkarte "))), NodePattern.N.lemma("Schwarzfahren").and(StyleRules.replaceWithNounPrepPhrase("Fahren", "ohne g\u00fcltige Fahrkarte")), NodePattern.N.lemma("Schwarzfahrer(in)?").and(NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replace(node, StyleRules.getAdjLikeForm("reisend", node).stream().map(str -> StringTools.uppercaseFirstChar((String)str)).toList()).join(NodeCorrector.insertAfter(node, " ohne g\u00fcltige Fahrkarte"))))), NodePattern.N.lemmaCaseSensitive("fahren").withDependent("compound:prt|advmod", NodePattern.N.form("schwarz").correct(NodeCorrector.replace("ohne g\u00fcltige Fahrkarte"))), NodePattern.N.form("Kanake").correct(NodeCorrector.replace("Mensch mit Migrationshintergrund", "Mensch t\u00fcrkischer Herkunft")), NodePattern.N.form("Kanaken").correct(NodeCorrector.replace("Menschen mit Migrationshintergrund", "Menschen t\u00fcrkischer Herkunft")), NodePattern.N.form("Nafri").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).andOptionally(NodePattern.N.noDependents("flat").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "nordafrikanischer Herkunft")).and(StyleRules.replaceWithNounPrepPhrase("Mensch", "aus Nordafrika"))), NodePattern.N.form("Nafris").correct(NodeCorrector.replace("Menschen nordafrikanischer Herkunft", "Menschen aus Nordafrika"))).message(RACIST_TERMS_MSG), NodePattern.or(NodePattern.N.lemma("Behinderter?|Invalide").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "mit Behinderung")), NodePattern.N.lemma("Schwerbehinderter?").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "mit schwerer Behinderung")), NodePattern.N.form("seh(gesch\u00e4digt|schwach)(e[mnsr]?)?").and(StyleRules.changeLemmaToAdj("sehgesch\u00e4digt", "sehbeeintr\u00e4chtigt")).and(StyleRules.changeLemmaToAdj("sehschwach", "sehbeeintr\u00e4chtigt")), NodePattern.N.lemma("Blinde").and(StyleRules.replaceWithAdjNounNP("blind", "Mensch")), NodePattern.N.lemma("Autist").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "mit Autismus")), NodePattern.N.lemma("Autistin").and(StyleRules.replaceWithNounPrepPhrase("Frau", "mit Autismus")), NodePattern.N.lemma("Epileptiker").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "mit Epilepsie")), NodePattern.N.lemma("Epileptikerin").and(StyleRules.replaceWithNounPrepPhrase("Frau", "mit Epilepsie")), NodePattern.N.lemma("Diabetiker").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "mit Diabetes")), NodePattern.N.lemma("Diabetikerin").and(StyleRules.replaceWithNounPrepPhrase("Frau", "mit Diabetes")), NodePattern.N.form("Diabeteseinstellung").correct(NodeCorrector.replace("Diabetesmanagement")), NodePattern.N.lemma("Liliputaner|Zwerg").and(StyleRules.replaceWithAdjNounNP("kleinw\u00fcchsig", "Mensch")), NodePattern.N.lemma("(Liliputaner|Zwerg)in").and(StyleRules.replaceWithAdjNounNP("kleinw\u00fcchsig", "Frau")), NodePattern.N.form("Mongolismus").correct(NodeCorrector.replace("Down-Syndrom")), NodePattern.N.form("Downie").andNot(NodePattern.N.noDependents("det(:poss)?").label("PERSON")).and(StyleRules.replaceWithNounPrepPhrase("Mensch", "mit Down-Syndrom")), NodePattern.or(NodePattern.N.lemma("Fl\u00fcchtling").and(StyleRules.changeLemmaToAdjLikeNoun("gefl\u00fcchtet")), NodePattern.N.form("Fl\u00fcchtlings.+").andNot(NodePattern.N.lemma(".*lager")).and(NodePattern.custom((node, match) -> {
            String migrationLemma = node.lemmaReadings().get(0).replaceFirst("Fl\u00fcchtling", "Migration");
            String asylLemma = node.lemmaReadings().get(0).replaceFirst("Fl\u00fcchtlings", "Asyl");
            return match.withCorrector(ChangeLemma.to(migrationLemma).corrector(node)).withCorrector(ChangeLemma.to(asylLemma).corrector(node));
        }))).noLabel("ORGANIZATION").andNot(NodePattern.N.withHead("flat|appos", NodePattern.N.label("ORGANIZATION"))).noDependents(NodePattern.N.inFormSequence(0, "e", "\\.", "V", "\\.")), NodePattern.N.lemma("Migrant").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "mit Migrationshintergrund")), NodePattern.N.lemma("Migrantin").and(StyleRules.replaceWithNounPrepPhrase("Frau", "mit Migrationshintergrund")), NodePattern.N.lemma("Asylant(in)?").and(StyleRules.changeLemmaToAdjLikeNoun("asylsuchend")), NodePattern.N.formCaseSensitive("Eingeborene[mnsr]").and(StyleRules.changeLemmaToAdjLikeNoun("indigen")), NodePattern.N.lemma("Zigeuner(in)?").correct(NodeCorrector.replace("Sinti", "Roma")).andOptionally(Gender.isReallyPlural.correct(NodeCorrector.replace("Sinti und Roma", "Roma und Sinti"))), NodePattern.N.lemma("Ausl\u00e4nder").and(StyleRules.replaceWithAdjNounNP("ausl\u00e4ndisch", "B\u00fcrger")), NodePattern.N.lemma("Ausl\u00e4nderin").and(StyleRules.replaceWithAdjNounNP("ausl\u00e4ndisch", "B\u00fcrgerin")), NodePattern.N.lemma("Afrikaner").and(StyleRules.replaceWithNounPrepPhrase("Mensch", "aus Afrika")), NodePattern.N.lemma("Afrikanerin").and(StyleRules.replaceWithNounPrepPhrase("Frau", "aus Afrika")), NodePattern.N.lemma("taubstumm|h\u00f6rgesch\u00e4digt").correct(ChangeLemma.to("geh\u00f6rlos")), NodePattern.N.lemma("Taubstummer|H\u00f6rgesch\u00e4digter").and(StyleRules.changeLemmaToAdjLikeNoun("geh\u00f6rlos")), NodePattern.N.form("karamellfarben.*").withHead("amod", NodePattern.N.lemma("Haut")).and(StyleRules.changeLemmaToAdj("karamellfarben", "mittelbraun")).and(StyleRules.changeLemmaToAdj("karamellfarben", "hellbraun")), NodePattern.N.form("schokoladenfarben.*").withHead("amod", NodePattern.N.lemma("Haut")).and(StyleRules.changeLemmaToAdj("schokoladenfarben", "dunkelbraun")), NodePattern.N.lemma("schokoladenh\u00e4utig").and(StyleRules.changeLemmaToAdj("schokoladenh\u00e4utig", "dunkelbraunh\u00e4utig")), NodePattern.N.form("trotz").withHead("case", NodePattern.N.lemma("Behinderung|Krankheit")).correct(NodeCorrector.replace("mit")), NodePattern.N.lemma("merzen").withDependent("compound:prt", NodePattern.N.form("aus").markAs("Particle")).correct(ChangeLemma.to("entfernen").join(NodeCorrector.replace(NodePointer.marked("Particle"), ""))), NodePattern.N.lemma("Entwicklungsland").and(StyleRules.replaceWithNounPrepPhrase("Land", "des globalen S\u00fcdens")), NodePattern.N.lemma("asozial").correct(ChangeLemma.to("unsozial")), NodePattern.N.formCaseSensitive("Asoziale[rnsm]").and(StyleRules.replaceWithAdjNounNP("unsozial", "Mensch")), NodePattern.N.formCaseSensitive("assi").correct(NodeCorrector.replace("unsozial")), NodePattern.N.form("Assi").and(StyleRules.replaceWithAdjNounNP("unsozial", "Mensch")), NodePattern.N.lemma("Kanaille").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("Don"))), NodePattern.N.lemma("Gutmensch").correct(LemmaChanges.changeSameGenderNounLemma("Weltverbesserer")).correct(LemmaChanges.changeSameGenderNounLemma("Wohlt\u00e4ter"))).message("Das Wort \u201e$_\u201c kann als negativ empfunden werden"), NodePattern.N.lemma("Welt").withDependent("amod", NodePattern.N.form("dritt.+")).reportEverythingTouched().message("Dieser Ausdruck kann als negativ empfunden werden. Ersetzen Sie ihn durch \u201eGlobaler S\u00fcden\u201c."), NodePattern.N.lemma("Abendland").message("Das Wort \u201e$_\u201c kann als negativ empfunden werden. Ersetzen Sie es durch \u201eWesten\u201c oder \u201eGlobaler Norden\u201c."), NodePattern.N.lemma("Morgenland").message("Das Wort \u201e$_\u201c kann als negativ empfunden werden. Ersetzen Sie es durch \u201eOsten\u201c oder \u201eOrient\u201c."), NodePattern.N.lemma("Fernost(en)?").message("Das Wort \u201e$_\u201c kann als negativ empfunden werden. Ersetzen Sie es durch \u201eOstasien\u201c oder \u201eS\u00fcdasien\u201c."), NodePattern.N.lemma("Ost(en)?").withDependent("amod", NodePattern.N.form("fern.+")).reportEverythingTouched().message("Dieser Ausdruck kann als negativ empfunden werden. Ersetzen Sie ihn durch \u201eOstasien\u201c oder \u201eS\u00fcdasien\u201c."), NodePattern.N.form("peter").withDependent("amod", NodePattern.N.form("schwarz.+")).withHead(NodePattern.N.lemma("zus(chieben|pielen)")).reportEverythingTouched().message("Dieser Ausdruck kann als rassistisch empfunden werden. Ersetzen Sie ihn durch \u201ejemanden verantwortlich machen\u201c oder \u201edie Verantwortung f\u00fcr etwas/die Schuld an etwas jemand anderem zuweisen\u201c."), NodePattern.N.lemma("Indianer").message("Das Wort \u201e$_\u201c kann als negativ empfunden werden. Ersetzen Sie es durch \u201edie indigene Bev\u00f6lkerung Amerikas\u201c oder \u201eFirst Nations\u201c."), NodePattern.N.lemma("Eskimo").message("Das Wort \u201e$_\u201c kann als negativ empfunden werden. Ersetzen Sie es durch einen spezifischeren Namen (bzw. \u201eInuit\u201c, \u201eYupik\u201c, usw.)."), NodePattern.N.form("Almans?").message("Das Wort \u201e$_\u201c kann als negativ empfunden werden. Ersetzen Sie es durch \u201estereotypisch Deutsch\u201c."), NodePattern.N.lemma("leiden").withDependent("obl|iobj", NodePattern.N.lemma("Behinderung|Diabetes|Epilepsie|Autismus").withDependent("case", NodePattern.N.form("an|unter"))).message("Dieser Ausdruck kann als negativ empfunden werden. Ersetzen Sie ihn durch \u201emit einer Behinderung leben\u201c."), NodePattern.N.lemma("\u00dcberfremdung").message("Dieser Ausdruck kann als rassistisch empfunden werden. Ersetzen Sie ihn z.\u00a0B. durch \u201eEinflussnahme auf\u201c, \u201ekulturelle Ver\u00e4nderung\u201c, \u201eDiversit\u00e4tszuwachs\u201c."), NodePattern.N.lemma("\u00fcberfremden").message("Dieser Ausdruck kann als rassistisch empfunden werden. Ersetzen Sie ihn z.\u00a0B. durch \u201eeine starke Zunahme an Vielfalt erfahren\u201c"), NodePattern.N.lemma("Menschenmasse").markAs("Noun").withDependent("amod", NodePattern.N.lemma("fremd")).message("Verwenden Sie keine rassistischen Ausdr\u00fccke. Verwenden Sie stattdessen z.\u00a0B. \u201eGruppe von Zuwanderern\u201c oder \u201eneue Bev\u00f6lkerungsgruppen\u201c"), NodePattern.N.form("ver(neger|kanaker)(e|st|t|(e)?n|ung)").message("Verwenden Sie keine rassistischen Ausdr\u00fccke. Verwenden Sie stattdessen z.\u00a0B. \u201ezu einer vielf\u00e4ltigeren und inklusiveren Gesellschaft werden\u201c"));
    }

    private static NodePattern rVerbsOrAdverbs() {
        return NodePattern.or(NodePattern.N.form("r(auf|aus|ein|(\u00fc|ue)ber|an|um|unter).+").andOr(NodePattern.N.pos("(VER.*|SUB.*INF)"), CommonPatterns.upperCase.and(CommonPatterns.lowercasedHasPos("VER.*"))).noLemma("r(aufen|auschen|\u00fcberkippen|einreden|einigen|ausschl\u00fcpfen|ausgucken)").noLemmaCaseSensitive("r(angehen|anh\u00e4ngen|anklotzen|andalieren|angeln|angieren|anken|anzen|ennen|ingen|innen|umoren|umpeln|umsen|umpfheben|unterhauen|unterholen|anmachen)|Ran[gd].+").and((node, match) -> {
            String verbWithoutR = node.lowForm().substring(1);
            if (!node.tree().treeSupport().tagToken(verbWithoutR).hasPos("VER.*")) {
                return null;
            }
            Object hinVerb = "hin" + verbWithoutR;
            Object herVerb = "her" + verbWithoutR;
            TreeSupport support = node.tree().treeSupport();
            boolean isNoun = node.hasPos("SUB.*INF.*");
            if (support.isAcceptedBySpellchecker((String)herVerb)) {
                herVerb = isNoun ? StringTools.uppercaseFirstChar((String)herVerb) : herVerb;
                match = match.withCorrector(NodeCorrector.replace(node, new String[]{herVerb}));
            }
            if (node.hasLemma("r(einfallen|aus(gehen|schieben|schauen|bekommen)|\u00fcberbringen)") || !support.isAcceptedBySpellchecker((String)herVerb) && support.isAcceptedBySpellchecker((String)hinVerb)) {
                hinVerb = isNoun ? StringTools.uppercaseFirstChar((String)hinVerb) : hinVerb;
                match = match.withCorrector(NodeCorrector.replace(node, new String[]{hinVerb}));
            }
            return match;
        }), NodePattern.N.form("rum").withHeadRelation("advmod|compound:prt").correct(NodeCorrector.replace("herum")), NodePattern.N.lemma("runterhauen").directlyAfter(NodePattern.N.form("eine").markAs("Eine")).correct(LemmaChanges.changeOwnVerbLemma("ohrfeigen").join(NodeCorrector.replace(NodePointer.marked("Eine"), ""))), NodePattern.N.lemma("r\u00fcberkippen").correct(LemmaChanges.changeOwnVerbLemma("versch\u00fctten")), NodePattern.N.lemma("reinreden").andOptionally(NodePattern.N.withDependent("aux", NodePattern.N.lemma("haben").markAs("HabenAux"))).and((node, match) -> {
            NodeCorrector corrector = LemmaChanges.changeOwnVerbLemma("fallen").corrector(node);
            Node habenAux = match.findMarkedNode("HabenAux");
            if (habenAux != null) {
                corrector = corrector.join(LemmaChanges.changeOwnVerbLemma("sein").corrector(habenAux));
            }
            return match.withCorrector(corrector.join(NodeCorrector.insertBefore(node, "ins Wort ")));
        })).andNot(CommonPatterns.quotedWord).andNot(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.or(GermanTreePatterns.apos, CommonPatterns.HYPHEN_LIKE_NODE))).andNot(NodePattern.N.withPhraseStart(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceBefore())).noLabel(".*").message("\u201e$_\u201c ist stark umgangssprachlich. F\u00fcr neutralen oder formellen Stil erw\u00e4gen Sie ein Synonym");
    }

    private static NodePattern erstmal() {
        return NodePattern.or(NodePattern.N.form("erstmal").andNot(CommonPatterns.quotedWord).markAs("LastNode"), NodePattern.N.form("erst").directlyBefore(NodePattern.N.form("mal").noDependents("det(:poss)?").markAs("LastNode")).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation).withNeighbor(2, GermanTreePatterns.closingQuotation))).withHeadRelation("advmod").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("LastNode"), m -> List.of("zun\u00e4chst", "vorerst"))).message(COLLOQUIAL_SPEECH_MSG);
    }

    private static NodePattern eben() {
        return NodePattern.N.form("eben[dt]").andNot(CommonPatterns.quotedWord).message("\u201e$_\u201c ist eine umgangssprachliche Variante von \u201eeben\u201c").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("so")).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("advmod"))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "soeben")), NodePattern.N.correct(NodeCorrector.replace(NodePointer.anchor(), "eben")));
    }

    private static NodePattern vorbeikommen() {
        NodeCorrector.Relative insertZuBesuch = NodeCorrector.insertBefore("zu Besuch ");
        NodeCorrector.Relative vorbeikommenToKommen = NodeCorrector.regexReplace("vorbei(.*)", "$1");
        NodeCorrector.Relative beiToZu = NodeCorrector.regexReplace(NodePointer.marked("Bei"), "bei(m?)", "zu$1");
        NodeCorrector.Relative vorbeiToZuBesuchOrRemove = NodeCorrector.replace(NodePointer.marked("Vorbei"), "zu Besuch", "");
        NodePattern vorbei = NodePattern.N.form("vorbei.*");
        String object = "i?obj|obl|nmod";
        return NodePattern.or(NodePattern.N.lemma("vorbeikommen").andNot(CommonPatterns.quotedWord), NodePattern.N.lemma("kommen").withDependent("compound:prt", NodePattern.N.form("vorbei").markAs("Vorbei"))).andOr(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("case", NodePattern.N.form("beim?").markAs("Bei"))).and(NodePattern.N.noDependents(object, NodePattern.N.withDependent("case", NodePattern.N.pos(".*AKK")))).andOr(vorbei.correct(insertZuBesuch.join(vorbeikommenToKommen).join(beiToZu)).correct(vorbeikommenToKommen.join(beiToZu)), NodePattern.N.correct(vorbeiToZuBesuchOrRemove.join(beiToZu))), NodePattern.N.noDependents(object).andOr(vorbei.correct(insertZuBesuch.join(vorbeikommenToKommen)).correct(vorbeikommenToKommen), NodePattern.N.correct(vorbeiToZuBesuchOrRemove))).noDependents("advmod", NodePattern.N.form("da|dort|hier")).message(COLLOQUIAL_SPEECH_MSG);
    }

    private static NodePattern wuerdeAuxInf() {
        String clause = "ccomp|csubj|a(dv)?cl|parataxis";
        NodePattern needInversion = NodePattern.N.withHead(NodePattern.N.withHeadRelation(clause).and(CommonPatterns.severalDependents("aux(:pass)?"))).directlyBeforeHead();
        NodePattern futureInThePastIndicator = NodePattern.or(NodePattern.N.lemma(".*verlauf"), NodePattern.N.lemma("drohen").pos("VER:.*:PRT.*"));
        return NodePattern.N.form("w\u00fcrde.*").withHead("aux", NodePattern.or(NodePattern.N.form("sein|haben|k\u00f6nnen|werden|m\u00fcssen|wollen").markAs("Verb"), NodePattern.N.withDependent("cop|aux(:pass)?", NodePattern.N.form("sein|haben|k\u00f6nnen|werden|m\u00fcssen|wollen").markAs("Verb"))).andNot(GermanTreePatterns.headInQuotes)).andNot(GermanTreePatterns.firstInPhraseAfterCommasOrConj).andNot(NodePattern.N.withHead(NodePattern.ROOT.noDependents(clause).noPos("ADJ.*"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("advmod", NodePattern.N.form("bald|nie|je|dann")))).andNot(NodePattern.N.inSentenceWith(futureInThePastIndicator)).and((node, match) -> {
            Node verb = match.getMarkedNode("Verb");
            String newLemma = verb.lemmaReadings().get(0);
            String replacement = newLemma.equals("sein") ? "w\u00e4re" : (newLemma.equals("haben") ? "h\u00e4tte" : (newLemma.equals("k\u00f6nnen") ? "k\u00f6nnte" : (newLemma.equals("werden") ? "w\u00fcrde" : (newLemma.equals("m\u00fcssen") ? "m\u00fcsste" : "wollte"))));
            String newVerb = node.form().replaceFirst("w\u00fcrde(.*)", replacement + "$1");
            String message = "Es ist bevorzugt, \u201e" + replacement + "\u201c anstelle von \u201ew\u00fcrde " + verb.lowForm() + "\u201c zu verwenden";
            NodeCorrector corrector = needInversion.matches(node) ? NodeCorrector.replace(node, "").join(NodeCorrector.replace(verb, newVerb)) : NodeCorrector.replace(node, newVerb).join(NodeCorrector.replace(verb, ""));
            return match.withCorrector(corrector).withMessage(message);
        });
    }

    private static NodePattern sehrRule() {
        Map<String, List<String>> map = WordSet.multiValueMap(WordSet.loadLines("de/sehr_rule.txt"));
        return NodePattern.N.form("sehr").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("nicht"))).directlyBeforeHead().withHead("advmod", NodePattern.N.pos("AD[JV].*").andNot(NodePattern.N.onlyPos(".*KOM.*")).markAs("Adj").andNot(NodePattern.N.withHead("amod", NodePattern.N.lemma(".*kenntnis"))).andNot(NodePattern.N.form("gut").and(NodePattern.ROOT.noDependents("cop"))).andNot(NodePattern.N.withHead("advmod", NodePattern.N.lemma("verstehen|passen")))).andNot(NodePattern.N.after(GermanTreePatterns.openingQuotation).withNeighbor(2, GermanTreePatterns.closingQuotation)).message("Anstelle von \u201esehr $Adj\u201c k\u00f6nnte ein spezifischeres Wort verwendet werden").and((sehr, match) -> {
            Node adj = match.getMarkedNode("Adj");
            String noLemmaChars = adj.lowForm().replace(adj.lemmaReadings().get(0), "");
            String end = noLemmaChars.length() <= 2 ? noLemmaChars : adj.lowForm().replaceFirst(".+?(e[mnsr]?)?$", "$1");
            List suggestions = (List)map.get(adj.lemmaReadings().get(0));
            if (suggestions == null) {
                return null;
            }
            boolean swiss = "CH".equals(GermanParameters.VARIANT.getValue(adj.tree()));
            List correctors = StreamEx.of((Collection)suggestions).map(s -> swiss ? s.replaceAll("\u00df", "ss") : s).map(s -> NodeCorrector.replaceNodes(sehr, adj, s + end)).toList();
            return match.withCorrectors(correctors).withActions(ActionSuggestion.REPHRASE);
        });
    }

    private static NodePattern directBeforeAposReplace(String replace) {
        return NodePattern.N.directlyBefore(GermanTreePatterns.apos.noSpaceBefore().includeIntoReport().correct(NodeCorrector.replace(replace)));
    }

    private static NodePattern contractionVerb() {
        NodePattern sameForm13SgPraes = NodePattern.N.pos("VER(:MOD)?:1:SIN:PR\u00c4.*").pos("VER(:MOD)?:3:SIN:PR\u00c4.*");
        NodePattern anyQuotationLike = NodePattern.or(GermanTreePatterns.anyQuotation, CommonPatterns.comma.noSpaceAfter());
        NodePattern hasOpeningQuoteBehind = NodePattern.custom(n -> ((StreamEx)((StreamEx)n.back().skip(2L)).filter(i -> anyQuotationLike.matches((Node)i))).count() % 2L != 0L);
        return GermanTreePatterns.hasSubject().andOr(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("aux|cop|aux:pass|root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).andOr(NodePattern.N.pos(".*(IMP:SIN|2:PLU:PR[\u00c4T]|1:SIN:(PR\u00c4|KJ2)).*").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("ich").noDependents("conj"))), NodePattern.N.pos("VER:3:SIN:PR\u00c4.*").directlyBefore(GermanTreePatterns.apos.noSpaceBefore()).andNot(hasOpeningQuoteBehind), NodePattern.N.pos("VER:3:SIN:KJ2.*")).noForm(".*e").andNot(sameForm13SgPraes).noPos("ADJ.*").noHeadRelation("compound:prt"), NodePattern.N.form("zweifl|wechsl|bastl|handl|klingl|bettl|samml|l\u00e4chl|kribbl|tr\u00f6dl|schwindl|schaukl|b\u00fcndl|gr\u00fcbl|r\u00e4tsl|wedl|m\u00f6cht|f\u00e4nd|h\u00e4tt")).markAs("Verb").andNot(NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.between("Subj", "Verb"))).noDependents("aux(:pass)?|cop").includeIntoReport().andNot(GermanTreePatterns.afterOpeningApos).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.apos)).message(CONTRACTION_MSG).and(CommonPatterns.replacementProduces("(.+)", "$1e", "VER(:MOD)?:[13]:SIN:(PR\u00c4|KJ2).*")).andOr(CommonPatterns.upperCase.and(StyleRules.directBeforeAposReplace("E")), StyleRules.directBeforeAposReplace("e"), CommonPatterns.upperCase.correct(NodeCorrector.insertAfter("E")), NodePattern.N.correct(NodeCorrector.insertAfter("e")));
    }

    private static NodePattern sinnMachen() {
        NodePattern withWuerdeKonjunktiv = NodePattern.N.withDependent("aux", NodePattern.N.lemma("werden").pos(".*KJ.*").andNot(LemmaChanges.accidentalAuxKonjunktiv).markAs("Wuerde"));
        return NodePattern.N.form("Sinn").includeIntoReport().markAs("Sinn").withOptionalDependent("det|nmod", NodePattern.N.form("keinen").markAs("Keinen")).withOptionalDependent("det", NodePattern.N.form("einen").markAs("Einen")).withOptionalDependent("det", NodePattern.N.form("mehr").markAs("Mehr")).withOptionalDependent("amod", NodePattern.N.form("viel").markAs("Viel")).withHead("obj", NodePattern.N.pos(".*VER.*").lemma("machen").includeIntoReport().withOptionalDependent("advmod", NodePattern.N.form("nicht").markAs("Nicht")).withOptionalDependent("aux", NodePattern.N.lemma("haben").markAs("Haben")).andOptionally(withWuerdeKonjunktiv).and(NodePattern.custom((machen, match) -> {
            Node wuerde = match.findMarkedNode("Wuerde");
            if (wuerde != null) {
                Node haben = match.findMarkedNode("Haben");
                if (haben != null) {
                    return match.withCorrector(LemmaChanges.changeOwnVerbLemma("ergeben").corrector(haben).join(NodeCorrector.removeNode(machen)).join(LemmaChanges.changeOwnVerbLemma("haben").corrector(wuerde)));
                }
                match = match.withCorrector(LemmaChanges.changeOwnVerbLemma("ergeben").corrector(wuerde).join(NodeCorrector.removeNode(machen)));
            }
            return match.withCorrector(LemmaChanges.changeOwnVerbLemma("ergeben").from("machen").corrector(machen));
        })).and((machen, match) -> {
            NodeCorrector toSein;
            Node sinn = match.getMarkedNode("Sinn");
            Node keinen = match.findMarkedNode("Keinen");
            Node einen = match.findMarkedNode("Einen");
            Node mehr = match.findMarkedNode("Mehr");
            Node viel = match.findMarkedNode("Viel");
            Node haben = match.findMarkedNode("Haben");
            Node wuerde = match.findMarkedNode("Wuerde");
            Node nicht = match.findMarkedNode("Nicht");
            if (wuerde != null) {
                toSein = LemmaChanges.changeOwnVerbLemma("sein").corrector(wuerde).join(NodeCorrector.removeNode(machen));
                if (haben != null) {
                    toSein = toSein.join(NodeCorrector.replace(haben, "gewesen"));
                }
            } else {
                toSein = LemmaChanges.changeOwnVerbLemma("sein").from("machen").corrector(machen);
                if (haben != null) {
                    toSein = toSein.join(LemmaChanges.changeOwnVerbLemma("sein").from("haben").corrector(haben));
                }
            }
            NodePattern condOrQuest = NodePattern.or(NodePattern.N.withDependent("punct", NodePattern.N.form("\\?")), LemmaChanges.inConditional);
            if (keinen != null || nicht != null && nicht.nextNode() == sinn && !condOrQuest.matches(machen)) {
                NodeCorrector removeNegation = NodeCorrector.removeNode(keinen != null ? keinen : nicht);
                NodeCorrector toSinnlos = NodeCorrector.replace(sinn, "sinnlos").join(removeNegation);
                NodeCorrector toNichtSinnvoll = NodeCorrector.replace(sinn, "nicht sinnvoll").join(removeNegation);
                return match.withCorrector(toSein.join(toSinnlos)).withCorrector(toSein.join(toNichtSinnvoll));
            }
            NodeCorrector toSinnvoll = mehr != null ? NodeCorrector.replace(sinn, "sinnvoller").join(NodeCorrector.removeNode(mehr)) : NodeCorrector.replace(sinn, "sinnvoll").join(einen != null ? NodeCorrector.removeNode(einen) : null).join(viel != null ? NodeCorrector.replace(viel, "besonders") : null);
            return match.withCorrector(toSein.join(toSinnvoll));
        })).andNot(NodePattern.N.inFormSequence(0, "sinn", "machen").directlyAfter(GermanTreePatterns.openingQuotation).withNeighbor(2, GermanTreePatterns.closingQuotation)).message(SINN_MACHEN_MSG);
    }

    private static NodePattern naziAssociations() {
        NodePattern politisch = NodePattern.N.lemma("politisch");
        NodePattern compoundWithPunctBefore = NodePattern.N.withDependent("compound", NodePattern.N.directlyBefore(NodePattern.PUNCT));
        NodePattern verbNoPosEIZ = NodePattern.N.pos("VER.*").noPos(".*EIZ.*");
        return NodePattern.or(NodePattern.or(NodePattern.N.form(".*(holocaust|gestapo)").lemma(".*(holocaust|gestapo)").andOr(compoundWithPunctBefore, NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen), NodePattern.N.noLemma("Holocaust|Gestapo")).noLemma("(Lager|Bundes|Stasi|Westzonen|Heimat)gestapo"), NodePattern.N.inFormSequence(0, "Gestapo", "-", "Methoden?"), NodePattern.N.lemma("Gestapomethode"), NodePattern.N.inFormSequence(3, "wie", "in", "einem", "Konzentrationslager|KZ")).message("Vermeiden Sie unangemessene Vergleiche und NS-Zeit-Assoziationen"), NodePattern.or(NodePattern.N.lemma("Brausebad").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).correct(LemmaChanges.changeSameGenderNounLemma("Duschbad")), NodePattern.not(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).andOr(NodePattern.N.lemma("(Kinder|Erholungs)lager").andOptionally(NodePattern.N.lemma("Kinder.*").correct(LemmaChanges.changeSameGenderNounLemma("Kinderferienlager"))).correct(LemmaChanges.changeSameGenderNounLemma("Ferienlager")).correct(LemmaChanges.changeSameGenderNounLemma("Feriencamp")), NodePattern.N.lemma("Jugendlager").correct(LemmaChanges.changeSameGenderNounLemma("Jugendcamp")).and(StyleRules.replaceWithNounPrepPhrase("Ferienlager", "f\u00fcr Jugendliche")), NodePattern.N.lemma("Integrationslager").correct(LemmaChanges.changeSameGenderNounLemma("Integrationscamp")).correct(LemmaChanges.changeSameGenderNounLemma("Integrationsprogramm")).and(StyleRules.replaceWithAdjNounNP("sozial", "Integrationsprojekt")), NodePattern.N.lemma("\u00dcberlebenslager").correct(LemmaChanges.changeSameGenderNounLemma("Wildnistraining"))), NodePattern.N.lemma("Sonderbehandlung").and(StyleRules.replaceWithAdjNounNP("besonder", "Behandlung")), NodePattern.N.lemma("Endl\u00f6sung").and(StyleRules.replaceWithAdjNounNP("endg\u00fcltig", "L\u00f6sung")), NodePattern.N.lemma("Fremdarbeiter(in)?").andNot(GermanParameters.VARIANT.withValue("CH")).andOr(NodePattern.N.lemma(".*in").correct(LemmaChanges.changeSameGenderNounLemma("Gastarbeiterin")), NodePattern.N.correct(LemmaChanges.changeSameGenderNounLemma("Gastarbeiter"))), NodePattern.N.lemma("Mischehe").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).and(StyleRules.replaceWithAdjNounNP("interkonfessionell", "Partnerschaft")).and(StyleRules.replaceWithNounPrepPhrase("Partnerschaft", "aus unterschiedlichen Kulturen")), NodePattern.N.lemma("ausrott(en|ung)").andOr(NodePattern.N.lemma("Ausrottung").correct(LemmaChanges.changeSameGenderNounLemma("Dezimierung")), NodePattern.N.lemma("Ausrotten").pos("SUB.*").correct(LemmaChanges.changeSameGenderNounLemma("Dezimieren")), verbNoPosEIZ.noPos("SUB.*").correct(ChangeLemma.to("dezimieren")), NodePattern.N.pos("VER:EIZ.*").correct(NodeCorrector.replace("zu dezimieren"))), NodePattern.N.lemma("[aA]usmerzen").andOr(NodePattern.N.lemma("Ausmerzen").pos("SUB.*").correct(NodeCorrector.replace("Eliminieren", "Entfernen", "Beseitigen")), verbNoPosEIZ.noPos("SUB.*").correct(ChangeLemma.to("entfernen")), NodePattern.N.pos("VER:EIZ.*").correct(NodeCorrector.replace("zu entfernen"))), NodePattern.N.form("Ausmerzung").correct(NodeCorrector.replace("Eliminierung", "Entfernung", "Beseitigung")), NodePattern.N.lemma("artfremd").and(StyleRules.changeLemmaToAdj("artfremd", "andersartig")), NodePattern.N.form("artecht(e[rnms])?").and(StyleRules.changeLemmaToAdj("artecht", "arttypisch")).and(StyleRules.changeLemmaToAdj("artecht", "sortenrein")), NodePattern.N.lemma("entart(ung|e[tn])"), NodePattern.N.lemma("Machtergreifung|Achsenmacht|Westachse")).message("Das Wort \u201e$_\u201c birgt wegen seiner NS-Zeit-Assoziationen negative Konnotationen"), NodePattern.or(NodePattern.N.lemmaCaseSensitive("machen").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("xcomp|compound:prt", NodePattern.N.form("frei").markAs("Frei")).correct(LemmaChanges.changeOwnVerbLemma("befreien").join(NodeCorrector.replace(NodePointer.marked("Frei"), ""))).correct(LemmaChanges.changeOwnVerbLemma("schaffen").join(NodeCorrector.replace(NodePointer.marked("Frei"), "Freiheit"))), NodePattern.N.inFormSequence(2, "bis", "zu[mr]", "Vergas(en|ung)").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "unz\u00e4hlige Male", "\u00fcberm\u00e4\u00dfig oft", "bis zur Ersch\u00f6pfung")), NodePattern.N.inFormSequence(3, "durch", "den", "Rost", "fallen"), NodePattern.N.inFormSequence(0, "jedem", "das", "Seine"), NodePattern.N.form("hei\u00dft").withDependent("nsubj", NodePattern.N.form("Ehre").withDependent("det:poss|nmod")).withDependent("xcomp", NodePattern.N.form("Treue")).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)), NodePattern.N.inFormSequence(1, "die", "Festung", "Europa"), NodePattern.N.inFormSequence(0, "Achse", "der", "Willigen")).message("Die Phrase birgt wegen ihrer NS-Zeit-Assoziationen negative Konnotationen"), NodePattern.or(NodePattern.N.form("artbewusst(e[rnms])?"), NodePattern.N.lemma("Artbewusstsein"), NodePattern.N.lemma("Volksgemeinschaft").and((node, match) -> match.withCorrector(NodeCorrector.replace(node, StringTools.uppercaseFirstChar((String)node.form().substring(5))))), NodePattern.N.lemma("lebensunwert|Herrenvolk|Herrenrasse|Untermensch|Ahnenpass|Volksverr\u00e4ter(in)?|Rassenschande|Kriegsweihnachtenv\u00f6lkisch|umvolk(ung|en)|Volksgenoss(e|in)|blutrein|Gegenrasse|gro\u00dfdeutsch(land|e(r)?)?|F\u00fchrerwille|Blutschande|Geburtenschlacht|Blutfahne|Frontgau"), NodePattern.N.form("rassisch").withHead("advmod", NodePattern.N.lemma("(un)?geeignet")), NodePattern.N.form("gottgl\u00e4ubig.*").and((node, match) -> {
            if (node.hasLemma("gottgl\u00e4ubig")) {
                return match.withCorrector(NodeCorrector.replace(node, node.lowForm().substring(4)));
            }
            return match.withCorrector(NodeCorrector.replace(node, StringTools.uppercaseFirstChar((String)node.form().substring(4))));
        }), NodePattern.N.lemma("Euthanasie").correct(LemmaChanges.changeSameGenderNounLemma("Sterbehilfe")), NodePattern.N.lemma("gleich(ge)?schalt(ung|e[nt](werden)?)").andOr(NodePattern.N.lemma("Gleichschaltung").correct(LemmaChanges.changeSameGenderNounLemma("Angleichung")), NodePattern.N.pos("PA2.*").withHeadRelation("advmod").correct(NodeCorrector.replace("einheitlich")), verbNoPosEIZ.correct(ChangeLemma.to("angleichen")), NodePattern.N.pos("VER.*").noPos("PA2.*").correct(NodeCorrector.replace("anzugleichen")), NodePattern.N), NodePattern.N.lemma("F\u00fchrer").directlyAfter(NodePattern.N.pos("(PRO:POS|ART:DEF).*SIN:MAS")).noDependents("nmod"), NodePattern.N.inFormSequence(2, "mit", "deutschem", "Gru\u00df")).message("Vermeiden Sie den Begriff \u201e$_\u201c au\u00dferhalb von Fachkontexten, da es als Begriff mit NS-Pr\u00e4gung gekennzeichnet ist"), NodePattern.N.lemma("Blut").withDependent("conj", NodePattern.N.lemma("Boden").withDependent("cc", NodePattern.N.form("und"))).reportEverythingTouched().message("Vermeiden Sie den Ausdruck \u201eBlut und Boden\u201c au\u00dferhalb von Fachkontexten wegen NS-Pr\u00e4gung"), NodePattern.or(NodePattern.N.lemma("Arier|(nicht?)arisch|Rasse").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)), NodePattern.N.lemma("Rassen(anlage|bewusstsein|ehre|hass|frage|kampf|mischung|reinheit)?")).message("Der Begriff \u201e$_\u201c ist historisch belastet und ist nur in Fachkontexten akzeptabel"), NodePattern.N.lemma("Anschluss").andOr(NodePattern.N.directlyAfter(politisch), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("advmod", politisch)), CommonPatterns.possiblySkipDown("nmod", NodePattern.N.withDependent("nmod", NodePattern.N.pos("EIG.*").andOptionally(NodePattern.N.label("EVENT|LOCATION"))))).message("Vermeiden Sie \u201e$_\u201c f\u00fcr politische Unionen. Nutzen Sie stattdessen z.\u00a0B. \u201eEingliederung\u201c oder \u201eVereinigung\u201c"), NodePattern.or(NodePattern.N.lemma("(Fl\u00fcchtlings|Vertriebenen|Migranten)lager").correct(LemmaChanges.changeSameGenderNounLemma("Asylzentrum")).correct(LemmaChanges.changeSameGenderNounLemma("Aufnahmezentrum")).correct(LemmaChanges.changeSameGenderNounLemma("Aufnahmelager")), NodePattern.N.inFormSequence(0, "Lager", "f\u00fcr", "Fl\u00fcchtlinge|Vertriebene|Migranten").correct(LemmaChanges.changeSameGenderNounLemma("Asylzentrum").join(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(2), ""))).correct(LemmaChanges.changeSameGenderNounLemma("Aufnahmezentrum").join(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(2), ""))).correct(LemmaChanges.changeSameGenderNounLemma("Aufnahmelager").join(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(2), "")))).message("Der Begriff \u201e$_\u201c kann negative Assoziationen hervorrufen"));
    }

    private static NodePattern anonymerName() {
        NodePattern anonym = NodePattern.N.lemma("anonym").includeIntoReport();
        return NodePattern.or(NodePattern.N.inFormSequence(2, "unter", "anonymem", "Namen").reportEverythingTouched().correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "anonym")), NodePattern.N.lemma("Name").includeIntoReport().andOr(NodePattern.N.withDependent("amod", anonym.correct(NodeCorrector.regexReplace("anonym(.*)", "geheim$1"))), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("bleiben|sein").withDependent("xcomp", anonym.correct(NodeCorrector.replace("geheim", "unbenannt")))))).message(ANONYMER_NAME_MSG);
    }

    private static NodePattern officeToBuero() {
        return NodePattern.N.lemma("Office").noLabel("PRODUCT").includeIntoReport().andNot(NodePattern.or(NodePattern.N.withHead("flat(.*)|appos|compound", GermanTreePatterns.englishWord.andNot(NodePattern.N.lemma("Garderobe"))), NodePattern.N.withDependent("appos|flat", NodePattern.N.label("PRODUCT")), NodePattern.N.directlyBefore(NodePattern.N.label("LOCATION")), NodePattern.N.withPrevSibling(NodePattern.N.form("Home").directlyBefore(NodePattern.N.form("-"))))).message(OFFICE_BUERO_MSG).correct(LemmaChanges.changeSameGenderNounLemma("B\u00fcro"));
    }

    private static NodePattern colloquialVerbs() {
        String prefix = "(r(au[sf]|unter|ein|an))";
        return NodePattern.or(NodePattern.N.lemma(prefix + "?[gk]ucken").pos("VER.*").and((node, match) -> {
            if (node.lowForm().startsWith("r")) {
                String prefixWithoutR = node.lowForm().replaceFirst(prefix + ".*", "$1").substring(1);
                List<String> schauen = LemmaChanges.changeOwnVerbLemma("schauen").suggestions(node);
                if (schauen.isEmpty()) {
                    return match;
                }
                String herVerb = "her" + prefixWithoutR + schauen.get(0);
                String hinVerb = "hin" + prefixWithoutR + schauen.get(0);
                TreeSupport support = node.tree().treeSupport();
                if (support.isAcceptedBySpellchecker(herVerb)) {
                    match = match.withCorrector(NodeCorrector.replace(node, herVerb));
                }
                if (support.isAcceptedBySpellchecker(hinVerb)) {
                    match = match.withCorrector(NodeCorrector.replace(node, hinVerb));
                }
                return match;
            }
            return match.withCorrector(LemmaChanges.changeOwnVerbLemma("schauen").corrector(node));
        }), NodePattern.N.form(".*guckste").correct(NodeCorrector.regexReplace("(.*)guckste", "$1schaust du"))).andNot(CommonPatterns.quotedWord).andOr(NodePattern.N.form("r.+").message("\u201e$_\u201c ist umgangssprachlich, stilistisch neutraler sind \u201eschauen\u201c oder \u201esehen\u201c in Verbindung mit Pr\u00e4fixen"), NodePattern.N.message(GUCKEN_TO_NEUTRAL_VERB_MSG));
    }

    private static NodePattern ausGegebenemAnlass() {
        return NodePattern.N.lemma("Anla(ss|\u00df)").withDependent("amod", NodePattern.N.lemma("gegeben")).withDependent("case", NodePattern.N.form("aus").markAs("Aus")).noLabel("MISC").andNot(NodePattern.N.withHead("nmod", NodePattern.N.lemma("(.*)?(album|titel)"))).reportRangeTo("Aus").message("\u201eAus gegebenem Anlass\u201c ist oft \u00fcberfl\u00fcssig und sollte in professionellen Texten vermieden werden");
    }

    private static NodePattern mergedPrepositions() {
        return mergedPreposition.withHeadRelation("case").andNot(CommonPatterns.quotedWord).correct(NodeCorrector.regexReplace("(.+)([mn])$", "$1 de$2")).correct(NodeCorrector.regexReplace("(.+)s$", "$1 das")).message("Vermeiden Sie umgangssprachliche Verschmelzungsformen im formellen Stil");
    }

    private static NodePattern passive() {
        NodePattern oblWithDurchOrVon = NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("durch|vo[nm]")).noForm("alleine?|neuem")).noDependents("acl");
        NodePattern reportingVerbs = NodePattern.N.lemma("berichten|melden|informieren|verk\u00fcnden|mitteilen|bekanntgeben|offenbaren|schildern|erl\u00e4utern|erz\u00e4hlen|enth\u00fcllen|erkl\u00e4ren");
        return NodePattern.N.pos("VER:PA2.*").withDependent("aux:pass", NodePattern.N.lemma("werden")).andOptionally(NodePattern.N.withDependent("aux")).reportEverythingTouched().andOr(NodePattern.N.withDependent("nsubj:pass", NodePattern.N.noDependents("acl")), NodePattern.N.withDependent("expl"), NodePattern.N.noDependents("nsubj:pass|nsubj")).andOr(oblWithDurchOrVon.noDependents("conj", NodePattern.N.noPos("VER:PA2.*")), NodePattern.N.withDependent("ccomp").noDependents("obl"), NodePattern.N.form("geschlossen|ge\u00f6ffnet|genehmigt|abgelehnt|akzeptiert").noDependents("advcl|xcomp", NodePattern.N.withDependent("cop|aux:pass")), NodePattern.N.withDependent("nsubj:pass").withDependent("aux", NodePattern.N.pos("VER:(MOD|AUX).*").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("mark").form("als")))).andNot(NodePattern.N.withHead("ccomp", NodePattern.N.pos("VER:IMP.*"))).noDependents("advcl|xcomp"), NodePattern.N.withDependent("nsubj:pass", NodePattern.or(NodePattern.N.pos("PRO:PER.*").formCaseSensitive("Sie|Ihr|[Dd]u"), NodePattern.N.withDependent("det", NodePattern.N.pos("PRO:POS.*")))), NodePattern.N.withDependent("obl|iobj", NodePattern.N.pos("PRO:PER.*")), NodePattern.N.noDependents("nsubj:pass").andNot(NodePattern.N.withHead("conj", NodePattern.N.noDependents("nsubj:pass"))), NodePattern.N.form("pr\u00e4sentiert|dargelegt|vorgestellt|aufgezeigt|demonstriert").withDependent("nsubj:pass", NodePattern.N.lemma(".*(Ergebnis|Datum|Fakt|Befund|Erkenntnis)"))).andNot(NodePattern.N.withDependent("acl", reportingVerbs.withDependent("nsubj"))).noDependents("nsubj").noHeadRelation("acl|csubj|xcomp").andNot(NodePattern.N.withDependent("csubj:pass", NodePattern.N.withDependent("nsubj", NodePattern.N.form("man")))).andNot(NodePattern.N.noSpaceBefore()).noForm("geraten|beherrscht|gezwungen|entlassen").andNot(NodePattern.N.form("verlegt").andNot(oblWithDurchOrVon)).andNot(NodePattern.N.form("getroffen|verdunkelt|markiert").and(CommonPatterns.possiblySkipDown("obl", NodePattern.N.withDependent("case", NodePattern.N.form("mit|von|durch"))))).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("wie").beforeHead())).andNot(NodePattern.N.withHead("advcl", NodePattern.N.withDependent("nsubj"))).message(PASSIV_MSG);
    }

    private static NodePattern mergedVerbs() {
        return NodePattern.N.form(".+ste").noPos().andOr(NodePattern.not(CommonPatterns.upperCase), NodePattern.not(CommonPatterns.lowercasedHasPos(".*")), NodePattern.not(CommonPatterns.capitalizedHasPos(".*"))).noForm("guckste").andNot(CommonPatterns.quotedWord).and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root"))).andNot(node -> node.tree().treeSupport().isAcceptedBySpellchecker(node.form())).andNot(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("cop|aux(:pass)?|det(:poss)?"), NodePattern.N.withDependent("nsubj", NodePattern.or(NodePattern.N.pos("(SUB|EIG|PRO:PER).*"), NodePattern.N.label(".*")))))).and(node -> node.tree().treeSupport().isAcceptedBySpellchecker(node.form().toLowerCase(Locale.ROOT).substring(0, node.form().length() - 1))).correct(NodeCorrector.regexReplace("(?i)(.+st)e", "$1 du")).message(COLLOQUIAL_SPEECH_MSG);
    }

    private static NodePattern informalEndings() {
        return NodePattern.N.form("euer[mn]").andNot(CommonPatterns.quotedWord).correct(NodeCorrector.regexReplace("(euer)([mn])", "$1e$2")).correct(NodeCorrector.regexReplace("(euer)([mn])", "eure$2")).message(COLLOQUIAL_SPEECH_MSG);
    }

    private static Rule.PatternRule normalizeSentenceStart() {
        return new DocumentRule.PatternRule("Style.SENTENCE_CAPITALIZATION", "Gro\u00df- und Kleinschreibung am Satzanfang", "Schreiben Sie das erste Wort am Satzanfang gro\u00df, in Klammern oder im Satzverlauf klein.", "https://www.abiweb.de/deutsch-crashkurs/die-deutsche-rechtschreibung/die-gross-und-kleinschreibung/die-grossschreibung-im-deutschen.html", () -> NodePattern.or(StyleRules.capitalizeFirstWord(), StyleRules.decapitalizeFirstWordInBrackets()), new Example[]{new Example("<b>wir</b> sind im Urlaub.", "<b>Wir</b> sind im Urlaub.")}){

            @Override
            public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences) {
                ArrayList<NodeRuleMatch> matches = new ArrayList<NodeRuleMatch>();
                for (int i = 0; i < sentences.size(); ++i) {
                    Node word;
                    DocumentSentence.Analyzed sentence = sentences.get(i);
                    Integer nodeIndex = sentence.metadata.get(key);
                    if (nodeIndex == null || i != 0 && sentences.get((int)(i - 1)).text.trim().endsWith(",") || SentenceCapitalizationRule.hasUnknownExclusionsBefore(sentence, (word = sentence.treeOrThrow().nodes().get(nodeIndex)).startOffset())) continue;
                    matches.add(new NodeRuleMatch((Rule)this, NodeMatch.EMPTY.withAnchor(word).withMessage(StyleRules.SENT_START_MSG).withCorrector(CommonPatterns.capitalizeNode(word)).withSuppressableKind(NodeMatch.SuppressableKind.UPPERCASE_SENTENCE_START)));
                }
                return MatchingResult.from(matches);
            }
        };
    }

    private static NodePattern capitalizeFirstWord() {
        NodePattern looksLikeRomanNumber = NodePattern.N.form("[ivxlmcd]{1,4}").noPos();
        NodePattern looksLikeCommandParameter = NodePattern.N.directlyAfter(NodePattern.N.form("--").noSpaceAfter());
        NodePattern looksLikeFunctionCall = NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "\\(", "\\)").noSpaceAfter()).noSpaceAfter();
        NodePattern inBraces = NodePattern.N.inFormSequence(1, "\\{", ".*", "}");
        return CommonPatterns.lowerCase.andOr(CommonPatterns.firstWord.andOr(GermanTreePatterns.clause, NodePattern.N.inSentenceWith(GermanTreePatterns.clause)).and((node, match) -> match.withMetadata(key, node.index)), NodePattern.N.directlyAfter(CommonPatterns.colon.spaceAfter().markAs("Colon").andOr(NodePattern.N.inSentenceWith(NodePattern.ROOT.and(GermanTreePatterns.clause).after("Colon").withDependent("nsubj(:pass)?|expl|cop|aux(:pass)?", NodePattern.N.after("Colon"))), NodePattern.N.withHead("punct", GermanTreePatterns.clause.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").withDependent("nsubj(:pass)?|expl").withPhraseStart(NodePattern.N.alreadyMarkedAs("Colon"))).andNot(NodePattern.N.withNextSibling(NodePattern.or(NodePattern.N.withHeadRelation("mark"), NodePattern.N.form("weil|da(ss|\u00df)|denn")))), NodePattern.N.directlyBefore(GermanTreePatterns.whPhrase.withHead(NodePattern.N.withHeadRelation("appos")))).andNot(NodePattern.N.withPrevSibling(CommonPatterns.firstWord.withHeadRelation("case"))).andNot(CommonPatterns.insideQuotes.inPhrase(NodePattern.not(CommonPatterns.insideQuotes)))).and(CommonPatterns.capitalize()).message("Nach einem Doppelpunkt wird das erste Wort eines selbstst\u00e4ndigen Satzes gro\u00dfgeschrieben")).andNot(looksLikeFunctionCall).inSentenceWith(CommonPatterns.capitalized).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.ellipsis, CommonPatterns.HYPHEN_LIKE_NODE))).andNot(GermanTreePatterns.headInQuotes).andNot(NodePattern.N.label(".*").noPos()).andNot(NodePattern.N.withHeadRelation("det").directlyAfter(GermanTreePatterns.apos.noSpaceAfter())).andNot(looksLikeRomanNumber).andNot(looksLikeCommandParameter).andNot(CommonPatterns.inParentheses).andNot(inBraces);
    }

    private static NodePattern decapitalizeFirstWordInBrackets() {
        return CommonPatterns.capitalized.andOr(NodePattern.N.withHeadRelation("det(:poss)?|a(dv)?mod|case|nummod|dep"), NodePattern.N.withHeadRelation("nsubj.*").and(CommonPatterns.lowercasedHasPos("(PRO|ART).*"))).withHead(NodePattern.N.inPhrase(GermanTreePatterns.clause).noLabel(".*").andNot(GermanTreePatterns.englishWord.withDependent("flat|amod|appos", GermanTreePatterns.englishWord).noDependents("det(:poss)?"))).directlyAfter(CommonPatterns.openingParen.noSpaceAfter().directlyAfter(NodePattern.or(NodePattern.N.label("PERSON"), NodePattern.not(GermanTreePatterns.englishWord).andOr(WordSeparation.withDependentsDetCaseAmod.noLabel(".*"), NodePattern.N.withHeadRelation("det(:poss)?|amod|case")), CommonPatterns.firstWord.noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|appos|flat|root|parataxis"))).withHead(NodePattern.N.withPhraseEnd(CommonPatterns.closingParen.noSpaceBefore()))).andNot(GermanTreePatterns.englishWord.andNot(CommonPatterns.lowercasedHasPos(".*"))).noLabel(".*").message("Das erste Wort in Klammern wird kleingeschrieben").and((node, match) -> match.withCorrector(NodeCorrector.replace(node, StringTools.lowercaseFirstChar((String)node.form()))));
    }

    private static NodePattern einPaar() {
        NodePattern paar = NodePattern.N.form("paar");
        return paar.noDependents().withHead("det|amod", NodePattern.N.noDependents("det", NodePattern.not(paar)).noDependents("case", NodePattern.N.form(".+['`\u00b4\u2019]n"))).message("Im Sinne von \u201eeinige\u201c wird \u201e$_\u201c gew\u00f6hnlich in Verbindung mit \u201eein\u201c verwendet").correct(NodeCorrector.insertBefore("ein "));
    }

    private static NodePattern recommendedSeparation() {
        return NodePattern.or(NodePattern.N.form("sowas").correct(NodeCorrector.replace("so was")), NodePattern.N.form("zuhause").andOr(NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("case").noForm("von|i[nm]").andNot(mergedPreposition)), NodePattern.ROOT.noDependents("amod|det(:poss)?")).andNot(CommonPatterns.capitalized.withHead(NodePattern.N.lemma("nennen|bezeichnen"))).noLabel("MISC").correct(NodeCorrector.replace("zu Hause")), NodePattern.N.form("neubekehrt").correct(NodeCorrector.regexReplace("neu(.*)", "neu $1")), NodePattern.or(NodePattern.N.lemma("hilfe(bring|such)end"), NodePattern.N.lemma("tief((h\u00e4ng|sitz|blick|dring)end|ge(f\u00fchlt|kr\u00e4nkt)|ersch\u00fcttert|betr\u00fcbt|bewegt)"), NodePattern.N.lemma("hoch(kompliziert|ver(zinst|schuldet)|angesehen|spannend|besteuert)"), NodePattern.N.lemma("viel(ge(kauft|braucht|lobt|r\u00fchmt|nannt)|besch\u00e4ftigt|zitiert)"), NodePattern.N.lemma("frischgebacken"), NodePattern.N.lemma("freistehend")).andOr(NodePattern.N.withHeadRelation("a(dv)?mod"), NodePattern.ROOT.withDependent("cop")).and((node, match) -> {
            String form = node.form();
            String prefix = form.startsWith("hilfe") ? "Hilfe" : form.substring(0, form.startsWith("frisch") ? 6 : 4);
            return match.withCorrector(NodeCorrector.replace(node, prefix + " " + node.form().substring(prefix.length())));
        }), NodePattern.N.lemma("nichtrostend").correct(NodeCorrector.regexReplace("nicht(.*)", "nicht $1")), NodePattern.N.inFormSequence(0, "nicht", "-", "rostend(e[mnsr]?)?").reportEverythingTouched().correct(NodeCorrector.replace(NodePointer.neighbor(1), " ")), StyleRules.rotLackiert(), NodePattern.N.lemma("verlorenge[hb]en|fertigkochen|bekannt(geben|werden|machen)").noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").and((node, match) -> {
            String form = node.form();
            String prefix = form.startsWith("verloren") ? form.substring(0, 8) : (form.startsWith("bekannt") ? form.substring(0, 7) : form.substring(0, 6));
            String tail = node.form().substring(prefix.length());
            String replacement = node.hasPos("VER:EIZ.*") ? " zu " + tail.substring(2) : " " + tail;
            return match.withCorrector(NodeCorrector.replace(node, prefix + replacement));
        })).message("Die Getrenntschreibung wird empfohlen");
    }

    private static NodePattern rotLackiert() {
        return NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern).+t(e[smnr]?)").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("amod"))).and((node, match) -> {
            for (int i = 1; i <= node.form().length(); ++i) {
                String prefix = node.lowForm().substring(0, i);
                if (!node.tree().treeSupport().tagToken(prefix).hasPos("ADJ:PRD:GRU") || !"((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)".contains(prefix)) continue;
                String tail = node.lowForm().substring(prefix.length());
                if (!node.tree().treeSupport().tagToken(tail).hasPos("PA2.*VER")) {
                    return null;
                }
                return match.withCorrector(NodeCorrector.replace(node, prefix + " " + tail));
            }
            return null;
        });
    }

    private static NodePattern recommendedPhToF() {
        return NodePattern.or(NodePattern.N.form(".*(ph|f)otogra(ph|f).*").noForm(".*(fotograf|photograph).*"), wordsOnGraph, wordsOnPhon, photoWords, NodePattern.N.form(".*delfin.*").andNot(NodePattern.N.inFormSequence(2, "(in|ad)", "usum", "Delphini")), NodePattern.N.form(".*(Phantasie.*|Phantast(in(nen)?|en|(erei|ik)(en)?|isch(e[rsmn]?)?)?)"), NodePattern.N.form(".*graph(olog.*|i[kt]).*").andNot(NodePattern.N.inFormSequence(0, "Graphik", "Novels?")).andNot(NodePattern.N.formCaseSensitive("graphit").withHead(NodePattern.or(NodePattern.N.noPos(), GermanTreePatterns.englishWord)))).noLabel("ORGANIZATION").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).and((node, match) -> {
            String form = node.form();
            String newWord = form.matches("\\p{Lu}+") ? form.replaceFirst("PH", "F") : (form.startsWith("Ph") ? form.replaceFirst("Ph", "F") : form.replaceFirst("ph", "f"));
            List<String> candidates = List.of(newWord, StringTools.uppercaseFirstChar((String)newWord), newWord.toLowerCase(Locale.ROOT));
            for (String variant : candidates) {
                if (!node.tree().treeSupport().isAcceptedBySpellchecker(variant)) continue;
                return match.withCorrector(NodeCorrector.replace(node, newWord)).withMessage("Die Schreibung \u201e" + newWord + "\u201c wird empfohlen");
            }
            return null;
        });
    }
}

