/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeCache;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Commas {
    private static final TreeCache<List<CommaLicense>> licenseCache = new TreeCache<List>("licenses", tree -> ((StreamEx)StreamEx.of(tree.nodes()).map(Commas::licensedCommas).filter(Objects::nonNull)).toList());
    static final NodePattern egIeOneToken = NodePattern.N.form("i\\.e\\.|e\\.g\\.");
    static final NodePattern egIeLastDotSeparated = NodePattern.N.inFormSequence(0, "e\\.g|i\\.e", "\\.");
    static final NodePattern egIe = TreeMigration.revise("one of the options might become redundant after tokenization changes", NodePattern.or(egIeOneToken, egIeLastDotSeparated));
    static final NodePattern egIeCommaVariant = EnglishParameters.VARIANT.withValue("US");
    static final NodePattern withEven = NodePattern.N.withDependent("advmod", NodePattern.N.form("even"));
    static final NodePattern gerundCommaAdverbial = NodePattern.N.pos("VBG").withDependent(".*", NodePattern.not(NodePattern.PUNCT)).andOr(CommonPatterns.firstChildPhrase, NodePattern.N.withPrevSibling(CommonPatterns.firstChildPhrase.pos("CC")), NodePattern.N.afterHead().and(CommonPatterns.possiblySkipDown("i?obj|obl|advmod", withEven.andNot(NodePattern.N.withHeadRelation("advcl").noDependents("punct", CommonPatterns.comma).withPrevSibling(NodePattern.N.afterHead().withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.pos("VB.*")))))).noDependents("punct", CommonPatterns.comma.afterHead())).andNot(NodePattern.N.withDependent("mark|advmod", NodePattern.N.form("if|when")).withDependent("aux")).andNot(NodePattern.N.withHead("advcl", NodePattern.N.pos("VBZ").noDependents("cop|aux|aux:pass").noDependents("nsubj.*|expl", NodePattern.N.beforeHead().and(n -> SubjectVerbAgreement.subjectNumber(n, n.head()) != Number.plural)))).andNot(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.noPos().andNot(NodePattern.PUNCT))).trace("after potentially misparsed sentence boundary")).noDependents("advmod", NodePattern.N.form("only")).noDependents("mark", NodePattern.or(NodePattern.N.form("to|by|before|after|in|that"), NodePattern.N.form("because").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("of"))))).trace("gerundCommaAdverbial");
    static final NodePattern inOpinion = NodePattern.N.form("opinion").withDependent("case", NodePattern.N.form("in"));
    static final NodePattern howeverContinuationNoComma = NodePattern.or(NodePattern.N.potentialPos("JJ").andOr(NodePattern.N.withHeadRelation("acl|parataxis"), NodePattern.N.withHeadRelation("advcl|ccomp").noPos("VB.*")), NodePattern.N.inPhrase(EnglishTreePatterns.clause.markAs("FirstClause")).and(NodePattern.markedNodeMatches("FirstClause", NodePattern.N.withHeadRelation("acl|advcl.*").noPotentialPos("VB[GN]").noDependents("mark|ccomp|cop").noDependents(Questions.whWord))).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.form("however").markAs("However")).withPhraseStart(NodePattern.N.before("However"))));
    static final NodePattern adverbsToFrontWithComma = NodePattern.N.markAs("Adv").withHead("advmod|discourse", EnglishTreePatterns.clause).and(NodePattern.or(NodePattern.N.form("however").andNot(NodePattern.N.directlyBefore(NodePattern.or(howeverContinuationNoComma, NodePattern.N.markAs("Person").directlyBefore(NodePattern.N.pos("VB.").afterHead().withHead("parataxis", NodePattern.N.withDependent("nsubj", NodePattern.N.sameWordAs("Person"))).withPrevSibling(NodePattern.N.pos("VB").afterHead())), NodePattern.N.inPhrase(NodePattern.ROOT.after("Adv").noDependents("conj", NodePattern.N.withDependent("advmod", NodePattern.N.form("therefore"))).withDependent("parataxis", NodePattern.N.noDependents("advmod", NodePattern.N.form("therefore"))).noDependents("advmod", NodePattern.N.lemma("not")))))), NodePattern.N.form("therefore"), NodePattern.N.form("similarly|additionally|importantly|particularly|obviously|specifically").withHead(NodePattern.not(NodePattern.N.directlyAfter("Adv"))).andNot(NodePattern.N.directlyBefore(NodePattern.not(NodePattern.N.withHeadRelation("punct")).inPhrase(NodePattern.or(NodePattern.N.withHeadRelation("obl.*"), NodePattern.N.withDependent("cop"))))), NodePattern.N.form("undoubtedly|admittedly|nevertheless|nonetheless|secondly|subsequently|finally|consequently|conversely|moreover|furthermore|namely|alas|instead").withHead("advmod|discourse", NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl"), EnglishTreePatterns.imperativeVB)))).unmark("Adv");
    static final NodePattern anyRelcl = NodePattern.N.pos("RB").form("any.*").withDependent("acl:relcl").withNextSibling(NodePattern.N.withHeadRelation("nsubj.*").beforeHead());
    static final NodePattern properNoun = NodePattern.or(NodePattern.N.pos("NNP").noPos("NNS?|JJ").noForm("act|gulf|committee").noDependents("det", NodePattern.N.lemma("a")).andNot(CommonPatterns.firstWord.and(CommonPatterns.capitalized).potentialPos("NN")), EnglishTreePatterns.capitalizedUnknown.noForm(".+ians?")).andNot(CommonPatterns.personMentionEnd);
    static final NodePattern inTurn = NodePattern.N.form("turn").withDependent("case", NodePattern.N.form("in"));
    static final NodePattern inAddition = NodePattern.N.form("addition").withDependent("case", NodePattern.N.form("in"));
    static final NodePattern forExample = NodePattern.N.form("example").withHeadRelation("nmod|obl").directlyAfter(NodePattern.N.form("for").markAs("For")).noDependents(NodePattern.not(NodePattern.PUNCT).before("For")).noDependents(NodePattern.not(NodePattern.PUNCT).afterHead()).andNot(NodePattern.or(NodePattern.N.withNextSibling(NodePattern.N.withHead("ccomp", NodePattern.not(Semantics.saySynonym)).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")), CommonPatterns.firstChildPhrase.withNextSibling(NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withHead("ccomp", NodePattern.not(Semantics.saySynonym)))).withNeighbor(-2, NodePattern.not(NodePattern.PUNCT))).trace("misparsed relcl"));
    static final NodePattern asAResult = NodePattern.N.inFormSequence(2, "as", "a", "result").withHeadRelation("obl").withNeighbor(-2, CommonPatterns.firstChildPhrase);
    private static final NodePattern eitherOr = NodePattern.N.form("either").withHead("cc:preconj", NodePattern.N).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.verbalClause));
    static final String[] notToMention = new String[]{"not", "to", "mention"};
    private static final NodePattern nounLike = NodePattern.N.pos("VBG|NN.*|PRP");
    private static final NodePattern egIeAppos = NodePattern.N.withHeadRelation("appos").withPrevSibling(CommonPatterns.skipBack(CommonPatterns.comma, egIe));
    private static final NodePattern withAtLeast = NodePattern.N.withDependent("advmod", NodePattern.N.inFormSequence(0, "at", "least"));
    static final NodePattern accordingToX = NodePattern.N.withDependent("case", NodePattern.N.form("according")).noPos("W.*").noLemma("schedule").andNot(NodePattern.N.afterHead().withHead(CommonPatterns.possiblySkipUp("obl", NodePattern.or(NodePattern.N.potentialPos("VBN"), NodePattern.N.lemma("behave|work|grow|vary|act|scale|increase|decrease|go|categori[zs]e"))))).andNot(NodePattern.N.afterHead().withDependent("nmod:poss").withHead(NodePattern.N.withHeadRelation("advcl").pos("JJ"))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obj|obl|xcomp")));
    static final NodePattern onTheXHand = NodePattern.N.form("hand").withDependent("case", NodePattern.N.form("on")).withDependent("amod|det|nummod");
    static final NodePattern commaStartingPhrase = NodePattern.N.withPhraseStart(NodePattern.or(CommonPatterns.comma, CommonPatterns.afterSkipping(NodePattern.N.withHeadRelation("cc:preconj"), CommonPatterns.comma)));
    private static final NodePattern licenseCommaAround = NodePattern.N.markAs("Anchor").andOr(NodePattern.N.pos("PRP").noDependents().withHead("nmod:npmod", NodePattern.N.pos("PRP")), NodePattern.N.withHeadRelation("obl|nmod").withDependent("case", NodePattern.or(NodePattern.N.form("including|among|like|instead"), NodePattern.N.inFormSequence(0, "of", "all"), NodePattern.N.inFormSequence(0, "based", "on"), NodePattern.N.inFormSequence(0, "such", "as"), NodePattern.N.inFormSequence(0, "by", "the", "way"), NodePattern.N.inFormSequence(0, "off", "the", "record"))), NodePattern.N.withHeadRelation("acl").andOr(NodePattern.N.form("incorporating").withDependent("obj", CommonPatterns.severalDependents("conj")), NodePattern.N.form("including|excluding").withDependent("obj")), NodePattern.N.afterHead().withHeadRelation("amod|obl").withDependent("cc:preconj|advmod", NodePattern.or(NodePattern.N.form("both"), NodePattern.N.inFormSequence(1, "not", "least"))), NodePattern.N.afterHead().withHeadRelation("obl").andOr(NodePattern.N.withDependent("mark", NodePattern.N.form("though")), withEven), NodePattern.N.beforeHead().withHeadRelation("obl").andOr(NodePattern.N.form("time").withDependent("case", NodePattern.N.form("at")), NodePattern.N.withDependent("case", NodePattern.N.form("for"))), NodePattern.N.withHeadRelation("advcl").andOr(NodePattern.N.pos("VB[GN]").noDependents("mark"), withEven), NodePattern.N.withHeadRelation("advcl|acl:relcl").withDependent("mark|advmod", CommonPatterns.firstChildPhrase.form("as|after|before|whether|wherever|mainly|mostly|chiefly|predominantly|largely|principally|while")), NodePattern.N.withHeadRelation("acl:relcl").withDependent("mark|advmod", CommonPatterns.firstChildPhrase.form("when")), NodePattern.N.inFormSequence(2, "\\d\\d?", ",", "[123][0-9]{3}"), NodePattern.N.withHeadRelation("conj").andOr(NodePattern.N.withDependent("advmod|nmod|cc", NodePattern.N.inFormSequence(0, 2, notToMention)), commaStartingPhrase.andOr(NodePattern.N.withDependent("advmod", CommonPatterns.firstChildPhrase.form("not")), NodePattern.N.pos("RB|JJR").withDependent("cc", CommonPatterns.firstChildPhrase.form("and|or")).andNot(EnglishTreePatterns.clause), NodePattern.N.markAs("Conj2").withHead(NodePattern.N.withDependent("conj", NodePattern.N.before("Conj2").withDependent("cc")))), NodePattern.N.withHeadRelation("conj").markAs("Conj").withHead(NodePattern.N.noDependents("conj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Conj")))).noDependents("cc").withDependent("det", NodePattern.N.form("the")).withHead(NodePattern.N.withDependent("det", NodePattern.N.form("the")))), adverbsToFrontWithComma, inTurn, inAddition, forExample, eitherOr, inOpinion, asAResult.beforeHead(), NodePattern.N.inFormSequence(1, "in", "fact"), NodePattern.N.inFormSequence(0, "of", "course"), NodePattern.N.form("respectively|accordingly|namely|though|too|aside"), accordingToX, onTheXHand, NodePattern.N.inFormSequence(0, "regardless", "of").withDependent("advcl"), NodePattern.N.form("however").directlyAfterHead().withHead("advmod", NodePattern.N.pos("VBG")), NodePattern.N.withHeadRelation("parataxis").andOr(nounLike.withHead(nounLike), NodePattern.N.pos("VB.*")), NodePattern.N.withHeadRelation("vocative|acl|list|appos").andNot(egIeAppos).andNot(CommonPatterns.parenthesizedPhrase).andNot(NodePattern.N.withHead("acl", NodePattern.not(NodePattern.ROOT)).pos("VBG")), NodePattern.N.withHeadRelation("discourse").form("yes|no"), NodePattern.N.withHeadRelation("ccomp").noDependents("mark", NodePattern.N.form("that|if").beforeHead()), Commas.properNonRestrictiveRelClause(), NodePattern.N.withHead("acl:relcl", NodePattern.not(properNoun)).withDependent("nsubj.*|obl|nmod", CommonPatterns.firstChildPhrase.andOr(NodePattern.N.form("which|whom?|while"), NodePattern.N.withDependent("nmod:poss", NodePattern.N.form("whose")))).and(commaStartingPhrase), NodePattern.N.withHeadRelation("acl:relcl").withDependent(".*", NodePattern.N.form("where")), NodePattern.N.beforeHead().withHead("advcl", NodePattern.N.withDependent("discourse|advmod", NodePattern.N.before("Anchor"))), NodePattern.N.withDependent("case", egIe), NodePattern.N.withDependent("advmod", NodePattern.N.form("especially|particularly")), withAtLeast, NodePattern.N.withDependent("cc", NodePattern.or(NodePattern.N.inFormSequence(0, "as", "well", "as"), NodePattern.N.inFormSequence(0, "rather", "than"), NodePattern.N.form("plus|minus"))), anyRelcl, NodePattern.N.withHeadRelation("obl:tmod").withDependent("nmod", NodePattern.N.withDependent("case")), NodePattern.N.withHeadRelation("nmod:tmod").pos("NN.*"), NodePattern.N.withHeadRelation("nmod").and(commaStartingPhrase).withDependent("nmod"), CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("or")).markAs("Conj").withHead("conj|acl:relcl", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?").noDependents("cc:preconj", NodePattern.N.form("n?either")))));
    static final NodePattern basicCoordinatingConjunction = NodePattern.N.form("and|but|or");
    private static final NodePattern licenseCommaBeforePhrase = NodePattern.or(NodePattern.N.withHeadRelation("conj|parataxis").noDependents("cc"), NodePattern.N.form("but").withHead("cc", NodePattern.or(EnglishTreePatterns.imperativeVB, NodePattern.N.withHead("conj", NodePattern.N.withDependent("acl:relcl")), NodePattern.N.pos("VBZ").withHead("conj", NodePattern.N.noPos("VBZ?").withDependent("cop")))), NodePattern.N.form("for|yet|so|as|while|because"), basicCoordinatingConjunction.andOr(NodePattern.N.directlyBefore(Semantics.directSpeech.directlyBefore(CommonPatterns.comma)), NodePattern.N.withHead("cc", NodePattern.or(NodePattern.N.withPrevSibling(NodePattern.N.withDependent("acl:relcl")), NodePattern.N.withHeadRelation("conj").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.withDependent("parataxis")))), NodePattern.N.inFormSequence(0, "even", "as"), NodePattern.N.inFormSequence(0, "and|but", "then|instead"), NodePattern.N.form("the").directlyBefore(NodePattern.N.pos("JJR")), NodePattern.N.withDependent("mark", NodePattern.N.form("that")).withHead("ccomp", NodePattern.N.afterHead().withHeadRelation("advcl").withDependent("mark", NodePattern.N.form("like"))), NodePattern.N.withHead("acl:relcl", NodePattern.N.withHeadRelation("appos")), NodePattern.N.markAs("Subordinate").withHead("advcl", NodePattern.N.inPhrase(NodePattern.N.before("Subordinate").markAs("Parataxis").withHead("parataxis", NodePattern.N.before("Parataxis")))));
    private static final NodePattern licenseCommaAfterPhrase = NodePattern.or(commaStartingPhrase.andOr(NodePattern.N.withHeadRelation("nmod|advmod|amod|flat").andNot(egIe), NodePattern.N.withHeadRelation("obl").beforeHead(), NodePattern.N.withHead("obl", NodePattern.N.withHeadRelation("advmod")).afterHead(), NodePattern.N.withHeadRelation("acl:relcl").withDependent(".*", NodePattern.N.form("which"))), NodePattern.N.withHeadRelation("amod").withPhraseStart(NodePattern.N.pos("CC")).withPrevSibling(NodePattern.N.withHeadRelation("nmod").and(commaStartingPhrase)).trace("misparsed conj"), NodePattern.N.withHeadRelation("acl:relcl").withPrevSibling(NodePattern.N.withHeadRelation("appos").and(commaStartingPhrase)), NodePattern.N.withHeadRelation("flat").label("GEO_POLITICAL_ENTITY").and(CommonPatterns.afterSkipping(NodePattern.N.label("GEO_POLITICAL_ENTITY"), CommonPatterns.comma)), NodePattern.N.beforeHead().withHeadRelation("obl|nmod").withDependent("case", NodePattern.N.form("in|despite|with")), NodePattern.N.inFormSequence(0, "next", "to").withHeadRelation("advmod").beforeHead(), egIeAppos, NodePattern.N.withHeadRelation("ccomp").withDependent("mark"), NodePattern.N.withHeadRelation("conj").andOr(NodePattern.N.withPhraseStart(NodePattern.N.inFormSequence(0, ",", "and|or")), NodePattern.N.withDependent("cc", NodePattern.N.form("and")).withPrevSibling(NodePattern.N.afterHead().withPhraseStart(NodePattern.N.form("both")))), NodePattern.N.withHeadRelation("conj|advcl").withDependent("mark", NodePattern.N.form("if|when|to|by|instead|for").beforeHead()).andOr(NodePattern.N.beforeHead(), NodePattern.N.withNextSibling(NodePattern.or(NodePattern.N.withHeadRelation("ccomp").and(commaStartingPhrase), CommonPatterns.comma.withNextSibling(NodePattern.N.withHeadRelation("ccomp"))))), NodePattern.N.withHeadRelation("advcl").withDependent("mark", NodePattern.N.form("like|as").beforeHead()), NodePattern.N.withHead("obl", EnglishTreePatterns.clause).andOr(CommonPatterns.firstChildPhrase, NodePattern.N.withPrevSibling(NodePattern.or(CommonPatterns.firstChildPhrase.withHeadRelation("cc|advcl"), NodePattern.N.form("that").withHeadRelation("mark"), withAtLeast))), NodePattern.N.withHeadRelation("conj").withPrevSibling(NodePattern.N.withHeadRelation("appos")));
    private static final NodePattern licenseCommaAfterWord = NodePattern.or(NodePattern.N.label(".*").withHeadRelation("nsubj").noDependents(NodePattern.not(NodePattern.PUNCT).afterHead()), commaStartingPhrase.withHeadRelation("nummod").andNot(NodePattern.N.directlyBefore(CommonPatterns.closingParen)), egIe.andOr(egIeCommaVariant, EnglishParameters.VARIANT.withValue("")), NodePattern.N.form("maybe").withNeighbor(2, NodePattern.N.withHead("mark", CommonPatterns.skipUp("advcl", NodePattern.ROOT)).noPotentialPos("RB")));
    private static final NodePattern licenseCommaAroundNonPhrase = NodePattern.or(NodePattern.N.form("unexpectedly").withPhraseStart(NodePattern.N.markAs("Start")).andOr(NodePattern.N.directlyBefore(NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("obl").withPhraseEnd(NodePattern.N.markAs("End")))), NodePattern.N.markAs("End")), NodePattern.N.withHead("nmod:npmod", NodePattern.N.beforeHead().withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?")).withDependent("nummod", NodePattern.N.inFormSequence(1, "about", "\\d+")).withPhraseStart(NodePattern.N.markAs("Start")).directlyBefore(NodePattern.N.withHeadRelation("advmod").withPhraseEnd(NodePattern.N.markAs("End"))), NodePattern.N.withHeadRelation("nmod").withDependent("case", NodePattern.N.form("alongside")).withPhraseStart(NodePattern.N.markAs("Start")).withNextSibling(NodePattern.N.withHeadRelation("nmod").withPhraseEnd(NodePattern.N.markAs("End"))));
    static final NodePattern asClause = NodePattern.or(Semantics.directSpeech, NodePattern.N.lemma("know|have"), NodePattern.N.withDependent("cop|aux:pass")).withDependent("mark", NodePattern.N.form("as").andNot(NodePattern.N.inFormSequence(2, "same", "time", "as"))).noDependents("advmod", NodePattern.N.form("even")).trace("asClause");
    static final NodePattern commaAdverbial = NodePattern.N.markAs("Adverbial").and(NodePattern.or(adverbsToFrontWithComma.and(CommonPatterns.firstChildPhrase).and(NodePattern.or(NodePattern.N.form("however|therefore"), CommonPatterns.firstPhrase)), gerundCommaAdverbial.withHead("advcl", EnglishTreePatterns.clause.withDependent("expl|nsubj.*")), NodePattern.N.withHead("advcl", EnglishTreePatterns.clause.after("Adverbial")).and(NodePattern.or(asClause.noDependents("ccomp"), NodePattern.N.withDependent("mark", NodePattern.N.form("besides")).and(NodePattern.or(NodePattern.N.pos("VBG"), NodePattern.N.withDependent("aux", NodePattern.N.pos("VBG")))), NodePattern.N.inFormSequence(0, "compared", "to"))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obl|advcl").withDependent("case").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl")).trace("possibly misattached NP")).noDependents("advcl", NodePattern.N.afterHead().pos("NN.*").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").trace("NP attached too deep")), NodePattern.N.beforeHead().pos("VB").withHead("advcl", EnglishTreePatterns.clause.noDependents("nsubj|obj", NodePattern.N.before("Adverbial")).noHeadRelation("conj")).withDependent("mark", NodePattern.N.form("to")).noDependents("cop|aux|aux:pass").andNot(NodePattern.N.withNextSibling(NodePattern.N.beforeHead().withHeadRelation("advcl|obl"))).andNot(NodePattern.N.noDependents(".*", NodePattern.N.afterHead()).withHead(NodePattern.N.withDependent("conj|parataxis", NodePattern.N.noDependents("cc")))).andNot(NodePattern.N.withPrevSibling(NodePattern.or(NodePattern.N.inFormSequence(1, "in", "part"), NodePattern.N.form(".+ly").withHeadRelation("advmod")))).andNot(CommonPatterns.closestDepToHead.withHead(CommonPatterns.lastWord.potentialPos("NN").directlyAfter(NodePattern.N.pos("NN"))).trace("misparsed root NP")), NodePattern.N.withHeadRelation("obl").and(NodePattern.or(accordingToX, NodePattern.N.withDependent("case", NodePattern.N.form("compared")).withHead(NodePattern.N.after("Adverbial")), onTheXHand, inOpinion.andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHead("obj", NodePattern.N.lemma("seek")))), CommonPatterns.firstChildPhrase.form("default").and(EnglishTreePatterns.byPP), inTurn, asAResult.and(CommonPatterns.firstPhrase).withNextSibling(NodePattern.N.withHeadRelation("nsubj.*").beforeHead()), inAddition.and(CommonPatterns.firstChildPhrase))), forExample, anyRelcl));

    Commas() {
    }

    static NodePattern properNonRestrictiveRelClause() {
        NodePattern hasAnotherSimilarNode = NodePattern.custom(anchor -> anchor.tree().nodes().stream().anyMatch(n -> n != anchor && n.form().equals(anchor.form()) && n.hasDependent("acl.*|nmod")));
        NodePattern hostPattern = properNoun.noForm(".+ers").noDependents("det", NodePattern.N.form("an?|the")).noDependents("cop").noHeadRelation("appos").andNot(hasAnotherSimilarNode);
        NodePattern commaSeparatedAppos = NodePattern.not(hostPattern).and(CommonPatterns.phraseStartsWithComma).withHead("amod|appos", hostPattern);
        return EnglishTreePatterns.clause.withHeadRelation("acl:relcl").withDependent(".*", Questions.whPhrase.noForm("where")).and((node, match) -> {
            Node host;
            NodeMatch result = null;
            Iterator<Node> iterator = EnglishTreePatterns.findRelativeClauseHostCandidates(node.phraseStart(), node).iterator();
            while (iterator.hasNext() && (result = hostPattern.match(host = iterator.next(), match)) != null) {
            }
            return result;
        }).andNot(NodePattern.N.withHead(commaSeparatedAppos));
    }

    @Nullable
    private static CommaLicense licensedCommas(Node node) {
        if (licenseCommaAround.matches(node)) {
            return CommaLicense.forPhrase(node, CommaLicense.NeedCommas.around);
        }
        NodeMatch match = licenseCommaAroundNonPhrase.match(node);
        if (match != null) {
            return CommaLicense.forRange(match.getMarkedNode("Start"), match.getMarkedNode("End"), CommaLicense.NeedCommas.around);
        }
        if (licenseCommaBeforePhrase.matches(node)) {
            return CommaLicense.forPhrase(node, CommaLicense.NeedCommas.before);
        }
        if (licenseCommaAfterWord.matches(node)) {
            return CommaLicense.forWord(node, CommaLicense.NeedCommas.after);
        }
        if (licenseCommaAfterPhrase.matches(node)) {
            return CommaLicense.forPhrase(node, CommaLicense.NeedCommas.after);
        }
        return null;
    }

    static List<CommaLicense> allCommaLicenses(Tree tree) {
        return tree.getCached(licenseCache);
    }

    static boolean hasLicensorsExcept(@NotNull Node comma, @NotNull Node licensorStart, @NotNull Node licensorEnd) {
        List<CommaLicense> licenses = Commas.allCommaLicenses(licensorStart.tree());
        return licenses.stream().anyMatch(l -> (l.start != licensorStart || PhraseCommaChange.findNonPunctuation(l.end.back()) != licensorEnd) && l.allows(comma));
    }
}

