/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishRules;
import ai.grazie.rules.en.EnglishSelectioner;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.PosHighlighter;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.SettingGroup;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.rules.toolkit.PosHighlighting;
import ai.grazie.rules.toolkit.Selectioner;
import ai.grazie.rules.toolkit.StructuralWrapper;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Parameter;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class EnglishToolkit
extends LanguageToolkit {
    public static final EnglishToolkit INSTANCE = new EnglishToolkit();

    private EnglishToolkit() {
        super(Language.ENGLISH);
    }

    @Override
    protected List<Rule> createRules() {
        return EnglishRules.rules();
    }

    @Override
    @Nullable
    public PosHighlighting posHighlight(Node node) {
        return PosHighlighter.posHighlight(node);
    }

    @Override
    public Selectioner selectioner() {
        return new EnglishSelectioner();
    }

    @Override
    @Nullable
    public StructuralWrapper getStructuralWrapper() {
        return new StructuralWrapper(){

            @Override
            protected boolean isPunctuation(Node node) {
                return PunctuationRules.commaLike.matches(node);
            }

            @Override
            protected boolean isClauseLike(Node node) {
                return EnglishTreePatterns.clause.matches(node) || node.hasPos("VBG");
            }
        };
    }

    @Override
    public String getRuleDescriptionLinkText() {
        return "Learn more";
    }

    @Override
    public List<SettingGroup> getSettings(RuleClient client) {
        Map map = StreamEx.of(this.publishedRules()).toMap(r -> r.id, Function.identity());
        return List.of(new SettingGroup("General", StreamEx.of((Object[])new Setting[]{client.hasImplicitVariant() ? null : EnglishParameters.VARIANT, EnglishToolkit.ruleSetting(map, "Grammar.MISSING_ARTICLE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.ENFORCE_CONTRACTION_USE", EnglishParameters.CONTRACTION_USE), EnglishToolkit.ruleSetting(map, "Style.SPELLING_OUT_NUMBERS", EnglishParameters.SPELL_OUT_NUMERALS), EnglishToolkit.ruleSetting(map, "Style.SPELLING_OUT_NUMBERS_SENT_START", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.SPELLING_OUT_LARGE_NUMBERS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.CONDESCENDING", new Parameter[0])}).nonNull().toList()), new SettingGroup("Punctuation", EnglishToolkit.ruleSetting(map, "Style.SERIAL_COMMA", EnglishParameters.SERIAL_COMMA), EnglishToolkit.ruleSetting(map, "Style.EXCLAMATION_MARK", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.EXPRESSIVE_PUNCTUATION", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.SMILEY_OR_EMOJI_USE", new Parameter[0])), new SettingGroup("Typography", EnglishToolkit.ruleSetting(map, "Typography.HYPHEN_TO_DASH", EnglishParameters.DASH_STYLE), EnglishToolkit.ruleSetting(map, "Typography.HYPHEN_IN_RANGES", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Typography.VARIANT_QUOTE_PUNCTUATION", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.NON_BREAKING_SPACES", EnglishParameters.SPACES_IN_NAME_INITIALS), EnglishToolkit.ruleSetting(map, "Spelling.MISSING_DIACRITICS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Typography.SMART_APOSTROPHE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Typography.NUMBERS_WITH_UNITS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Typography.NUMBER_FORMATTING", EnglishParameters.NUMBER_FORMATTING)), new SettingGroup("Readability", EnglishToolkit.ruleSetting(map, "Style.LESS_READABLE_PASSIVE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.PASSIVE_VOICE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.VERY_ABUSE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.TAUTOLOGY", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.REDUNDANT_OF", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.OF_CHAIN", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.SIMPLICITY", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.WORDINESS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.REDUCIBLE_RELATIVE_CLAUSE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.FAULTY_PARALLELISM", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.LONG_SENTENCE", new Parameter[0])), new SettingGroup("Formality", EnglishToolkit.ruleSetting(map, "Style.COLLOQUIAL_SPEECH", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.INFORMAL_SHORT_FORMS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.LOOKS_LIKE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.SUBJECT_PRONOUNS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.OR_SUBJECT_AGREEMENT", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.SPELL_OUT_AND_SYMBOLS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.PRONOUN_FIRST_PERSON_SG", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.PRONOUN_FIRST_PERSON_PL", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.PRONOUN_SECOND_PERSON", new Parameter[0])), new SettingGroup("Inclusivity", EnglishToolkit.ruleSetting(map, "Style.PRONOUN_GENDER_BIAS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.NOUN_VERB_GENDER_BIAS", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.HONORIFIC", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.DISCRIMINATORY_LANGUAGE", new Parameter[0]), EnglishToolkit.ruleSetting(map, "Style.NONVIOLENT_LANGUAGE", new Parameter[0])));
    }
}

