/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.ClausalComplements;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.QuantifierNounCompatibility;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.en.WordOrder;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SubjectVerbAgreement {
    private static final NodePattern modifiedPronoun = NodePattern.N.pos("PRP").andOr(NodePattern.N.withDependent("det|amod", NodePattern.N.beforeHead()), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("det|amod")));
    private static final NodePattern ifThough = NodePattern.N.lemma("if|though");
    private static final NodePattern irrealisVP = CommonPatterns.possiblyConj(NodePattern.or(NodePattern.or(NodePattern.N.withDependent("mark", ifThough), NodePattern.N.withDependent("advmod", NodePattern.N.form("only").withDependent("mark", ifThough)), NodePattern.N.withDependent("mark", NodePattern.N.form("as").withDependent("fixed", ifThough)), NodePattern.N.withDependent("nsubj", NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(ifThough)))).and(NodePattern.or(NodePattern.N.form("were"), NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.form("were")))).andNot(NodePattern.N.withHead(NodePattern.N.lemma("check|see"))), NodePattern.N.withHead("ccomp", NodePattern.N.pos("VB.*").lemma("wish"))));
    private static final NodePattern xAndYConj = NodePattern.N.withDependent("conj", NodePattern.N.markAs("Second").withDependent("cc", NodePattern.N.form("and"))).noDependents("conj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Second")));
    private static final NodePattern xAndYSingular = NodePattern.or(NodePattern.N.form("who|what").withDependent("conj"), NodePattern.N.inFormSequence(0, ".*", "-", "and", "-"), SubjectVerbAgreement.xAndY("fish", "chips"), SubjectVerbAgreement.xAndY("sausage", "mash"), SubjectVerbAgreement.xAndY("bread", "butter"), SubjectVerbAgreement.xAndY("day", "night"), SubjectVerbAgreement.xAndY("night", "day"), SubjectVerbAgreement.xAndY("doom", "gloom"), SubjectVerbAgreement.xAndY("nook", "cranny"), SubjectVerbAgreement.xAndY("mover", "shaker"), SubjectVerbAgreement.xAndY("sweat", "tears"), SubjectVerbAgreement.xAndY("part", "parcel"), SubjectVerbAgreement.xAndY("heart", "soul"), SubjectVerbAgreement.xAndY("carrot", "stick"), SubjectVerbAgreement.xAndY("ball", "chain"), SubjectVerbAgreement.xAndY("cut", "thrust"), SubjectVerbAgreement.xAndY("hustle", "bustle"), SubjectVerbAgreement.xAndY("spit", "polish"), SubjectVerbAgreement.xAndY("food", "drink"), SubjectVerbAgreement.xAndY("plug", "play"), SubjectVerbAgreement.xAndY("rock", "roll"), SubjectVerbAgreement.xAndY("wear", "tear"), SubjectVerbAgreement.xAndY("show", "tell"), SubjectVerbAgreement.xAndY("drag", "drop"));
    private static final Map<String, List<String>> xToYAmbiguous = SubjectVerbAgreement.XAndYAmbList();
    private static final NodePattern subjectAfterBe = NodePattern.or(EnglishTreePatterns.withSyntacticExpletive(), NodePattern.N.markAs("Predicate").withDependent("cop", NodePattern.N.after("Predicate")));
    private static final NodePattern notVerb = NodePattern.N.potentialPos("NNS").andOr(NodePattern.ROOT.withOnlyDependents(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?")), NodePattern.N.withHeadRelation("acl:relcl").withDependent("nsubj", NodePattern.N.pos("NNS").directlyBeforeHead()).directlyBefore(NodePattern.N.withHeadRelation("acl|advcl|xcomp").withDependent("obl", EnglishTreePatterns.byPP)));
    private static final NodePattern possibleCsubj = NodePattern.N.withDependent("acl", NodePattern.N.potentialPos("VBG").beforeHead().andNot(EnglishValences.definitelyIntransitive));
    static final NodePattern misparsedId = NodePattern.N.inFormSequence(0, "i", "\\p{L}+").noSpaceAfter();
    private static final NodePattern misparsedAdjCopula = NodePattern.N.pos("VB").potentialPos("JJ").withDependent("nsubj", NodePattern.N.form("s?he|it").noDependents("conj|appos").andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cop|aux|aux:pass")))).andNot(Semantics.attributiveOnlyAdj).andNot(Semantics.unlikelyToBeAdj).noDependents("compound:prt|xcomp|cop|aux|aux:pass");
    private static final NodePattern shouldConcede = NodePattern.N.pos("VBP?").andOr(misparsedAdjCopula, NodePattern.N.withDependent("obl.*", EnglishTreePatterns.byPP.and(CommonPatterns.closestDepToHead)));
    static final NodePattern possiblyMisattachedNP = NodePattern.N.beforeHead().andOr(NodePattern.N.markAs("CouldBeObj").noForm("I|s?he|we").andNot(Questions.whPhrase).withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.pos("VB.*").andOr(NodePattern.N.withHeadRelation("acl.*|advcl|[cx]comp"), NodePattern.ROOT.withDependent(".*", Questions.whPhrase), NodePattern.ROOT.and(ClausalComplements.verb_NPToInf_Gerund).noDependents("obj")).andNot(NodePattern.N.withDependent(".*", NodePattern.N.form("it")).and(NodePattern.markedNodeMatches("CouldBeObj", NodePattern.N.form("it")))))), NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.pos("IN").directlyAfter(NodePattern.N.pos("NN.*")))), NodePattern.N.markAs("Subj").withDependent("det", NodePattern.N.form("a|an").beforeHead()).withDependent("amod", NodePattern.N.beforeHead()).withHead("nsubj", EnglishTreePatterns.imperativePossible.withHeadRelation("root").markAs("ROOT")).withDependent("punct", CommonPatterns.comma.between("Subj", "ROOT")));
    private static final NodePattern singularCopulaAllowed = NodePattern.N.withDependent("cop", NodePattern.N.form("is")).andOr(NodePattern.N.pos("NN.*").withDependent("det|nmod:poss"), NodePattern.N.pos("JJ.*").withDependent("nsubj", NodePattern.N.withDependent("amod", NodePattern.N.pos("JJR"))), NodePattern.N.pos("DT")).noDependents("nsubj", NodePattern.N.form("these|I|you|s?he|we|they"));
    private static final NodePattern couldBeNnsVb = NodePattern.N.potentialPos("NNS").noForm("eats|collects").withDependent("advmod|obj", NodePattern.N.directlyAfterHead().potentialPos("VB"));
    private static final NodePattern theseIs = NodePattern.N.inFormSequence(0, "these", "is");
    private static final NodePattern leadingTheseDays = NodePattern.or(Semantics.timeUnits, NodePattern.N.lemma("time")).withDependent("det|amod", CommonPatterns.firstChildPhrase.directlyBeforeHead());
    private static final NodePattern realRelCl = NodePattern.N.withHead("acl:relcl", NodePattern.N.pos("NN.*").noHeadRelation("advmod")).andNot(NodePattern.N.withHead(NodePattern.ROOT.and(leadingTheseDays))).andNot(NodePattern.N.inPhrase(NodePattern.ROOT.withDependent("mark", NodePattern.N.form("when"))));
    private static final NodePattern modConjAmbiguity = NodePattern.N.withDependent("nmod|nummod", NodePattern.N.afterHead().markAs("Nmod")).withDependent("conj", NodePattern.N.after("Nmod"));
    private static final NodePattern likelyVocative = NodePattern.N.directlyAfter(CommonPatterns.firstWord.form("dear"));
    private static final NodePattern possiblyVocative = NodePattern.or(CommonPatterns.firstWord.andOr(NodePattern.N.pos("NNP"), EnglishTreePatterns.someAnyEveryNoAnimate.noForm("no.*"), StyleRules.informalAddressing), likelyVocative).markAs("Subj").withHead("nsubj|vocative", NodePattern.N.pos("VBP?").noMatchUntil("Subj", NodePattern.N.noHeadRelation("advmod")).andNot(Semantics.neverImperative));
    private static final NodePattern unitingNmod = NodePattern.N.withDependent("nmod|obl", NodePattern.N.after("Conj").withDependent("case", NodePattern.N.form("of|from|for")));
    private static final NodePattern possiblyUnitingSharedArgument = NodePattern.N.pos("NNP?|VBG").withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("and")).markAs("Conj")).andOr(unitingNmod, NodePattern.markedNodeMatches("Conj", unitingNmod), CommonPatterns.capitalized.and(NodePattern.markedNodeMatches("Conj", NodePattern.not(CommonPatterns.capitalized).withDependent("compound|nmod:poss", CommonPatterns.capitalized))), NodePattern.N.withDependent("det", NodePattern.N.form("this|that").beforeHead()).withOnlyDependents(NodePattern.N.withHeadRelation("conj|det")).and(NodePattern.markedNodeMatches("Conj", NodePattern.N.pos("NN"))), NodePattern.N.withDependent("nmod:poss|amod").noDependents("nummod").andOr(Semantics.anyGroup, NodePattern.custom(n -> {
        Semantics.Animacy animacy = Semantics.animacy(n);
        return animacy != Semantics.Animacy.humanLike && animacy != Semantics.Animacy.animal;
    })));
    private static final NodePattern possiblySingleUnit = NodePattern.or(Semantics.currencyPattern, Semantics.timeUnits, Semantics.uomPattern).pos("NNS").withDependent("nummod").beforeHead();
    private static final NodePattern copXcompEllipsis = NodePattern.N.potentialPos("JJ.*").noDependents("cop|aux|aux:pass").markAs("AdjConj").withHead("conj", CommonPatterns.possiblySkipDown("xcomp", NodePattern.N.before("AdjConj").potentialPos("JJ.*|VBG"))).trace("copXcompEllipsis");
    private static final NodePattern addCommaBeforeWhich = NodePattern.N.form("which").directlyAfter(NodePattern.not(NodePattern.PUNCT)).withHead("nsubj", PunctuationRules.possiblySententialRelativeBasicPattern.and(CommonPatterns.possiblySkipDown("cop|aux|aux:pass", NodePattern.N.pos("VBZ"))));
    private static final NodePattern namedEntityLike = NodePattern.or(Semantics.needsCapitalization, NodePattern.N.label("PRODUCT"));
    private static final NodePattern auxEllipsis = NodePattern.N.pos("VB").noDependents("cop|aux|aux:pass").withHead("conj", NodePattern.N.withDependent("aux", EnglishTreePatterns.baseAux.noLemma("do").andNot(EnglishTreePatterns.startsWithApostrophe).markAs("ElidedAux")).andNot(EnglishTreePatterns.negated));
    static final NodePattern orInCompoundSubject = NodePattern.N.form("n?or|/").withHead("cc", NodePattern.N.withHead("conj", NodePattern.N.withHead("nsubj(:pass)?", NodePattern.N.markAs("Predicate")).noDependents("amod").markAs("Subj")).andOr(NodePattern.N.withDependent("flat", NodePattern.N.directlyAfterHead().markAs("LastConj")), NodePattern.N.markAs("LastConj")).noDependents("conj", NodePattern.N.after("LastConj")));
    private static final NodePattern findPotentialNmodHead = NodePattern.N.pos("NN.*").and(CommonPatterns.afterSkipping(NodePattern.N.withHeadRelation("amod"), NodePattern.N.potentialPos("NN.*").markAs("NmodHead")));
    private static final NodePattern rootMisparsedAsRelativeSubClause = NodePattern.N.withDependent("mark", NodePattern.N.form("since")).inPhrase(NodePattern.N.withHead("acl:relcl", NodePattern.ROOT.andNot(EnglishTreePatterns.clause)));
    private static final NodePattern sententialThatClause = NodePattern.N.inFormSequence(1, "that", "entails|means|implies").withHeadRelation("acl:relcl").noDependents(NodePattern.N.afterHead());
    private static final NodePattern imperativeWithQuotedObject = NodePattern.N.noDependents().spaceAfter().directlyBefore(EnglishTreePatterns.aposOrQuote.noSpaceAfter().directlyBefore(NodePattern.N.pos("VB.*"))).potentialPos("VB");
    private static final NodePattern typoApostropheS = NodePattern.N.pos("VB.*").directlyBefore(EnglishTreePatterns.apostropheS.noSpaceBefore());
    private static final NodePattern looksLikeCode = NodePattern.N.directlyAfter(NodePattern.N.form("=")).trace("looksLikeCode");
    private static final NodePattern noVerbAgreementCheck = NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.N.pos("NNS?").andNot(NodePattern.custom(node -> node.tree().treeSupport().isAcceptedBySpellchecker(node.form()))), NodePattern.N.form("I|dear"), NodePattern.N.potentialPos("VBZ").form("controls|checks").noDependents("det", NodePattern.N.onlyPos("DT")), imperativeWithQuotedObject)), NodePattern.N.withHeadRelation("csubj|acl:relcl|advcl:relcl").withDependent("cop", CommonPatterns.firstChildPhrase).trace("misattached cop"), NodePattern.N.withDependent("csubj:pass", NodePattern.N.afterHead()), sententialThatClause, WordOrder.topLevelInvertedQuestion, Questions.questionWithOmittedAux.withDependent("nsubj|obj", NodePattern.N.form("any(one|body|thing)")), EnglishTreePatterns.unlikelyToBeVerb.noDependents("cop"), NodePattern.N.pos("NN.*").withDependent("nsubj", NodePattern.or(Semantics.timePoints, Semantics.timeUnits.noDependents("det|nmod:poss"))).withDependent("cop", NodePattern.custom(cop -> !Number.verbNumber(cop).conflictsWith(SubjectVerbAgreement.subjectNumber(cop.head(), cop)))), NodePattern.N.inFormSequence(2, "as", "it", "were"), NodePattern.N.withDependent("advmod", EnglishTreePatterns.negation.noSpaceBefore().directlyAfter(CommonPatterns.letterWord.noPos())), NodePattern.N.withDependent("cop", NodePattern.N.markAs("Cop")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.after("Cop")).withDependent("advcl:relcl", NodePattern.N.before("Cop")).trace("csubj:outer misparsed as advcl:relcl"), NodePattern.N.inFormSequence(1, "batch", "changes?").trace("batch changes?"), irrealisVP, copXcompEllipsis, looksLikeCode, NodePattern.N.withDependent("mark", NodePattern.N.form("with")), rootMisparsedAsRelativeSubClause, EnglishTreePatterns.letS, typoApostropheS, CommonPatterns.severalDependents("aux:pass").trace("several aux:pass"), NodePattern.N.withDependent("mark", NodePattern.N.form("than")).withHead("advcl", NodePattern.N.pos("VBG").noDependents("cop|aux|aux:pass")).trace("misparsed 'anyone going faster than you is a maniac'"));
    private static final NodePattern introSeparator = NodePattern.or(EnglishTreePatterns.dashes.andNot(CommonPatterns.noSpaceHyphen), NodePattern.N.form("[,()]"));
    private static final NodePattern closingBracket = CommonPatterns.closingParen.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("nmod"), NodePattern.N.withHead("amod", NodePattern.N.withHeadRelation("nmod"))));
    private static final NodePattern misparsedSubjectlessSentence = NodePattern.or(NodePattern.N.withDependent("amod", CommonPatterns.firstWord.potentialPos("VB[DG]")), CommonPatterns.firstWord.and(EnglishTreePatterns.unlikelyToBeNoun)).withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.potentialPos("NN.*").andNot(EnglishTreePatterns.unlikelyToBeNoun));
    private static final NodePattern nnpConjCompound = NodePattern.N.pos("NNP").withHead(NodePattern.N.pos("NNP").withHead("compound", NodePattern.N.noPos("NNP")));
    private static final NodePattern possiblyMisparsedSubject = NodePattern.or(NodePattern.N.form("auto").directlyBeforeHead().noDependents(), NodePattern.N.withDependent("case", EnglishTreePatterns.caseAfterUnknown.directlyAfter(NodePattern.N.withDependent("cop"))), NodePattern.N.withDependent("nmod|compound", NodePattern.N.withDependent("conj", NodePattern.not(nnpConjCompound))), NodePattern.N.withDependent("conj", NodePattern.N.withDependent("cc").withDependent("compound").noDependents("cop")), misparsedSubjectlessSentence, NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("after|before"))), NodePattern.N.withDependent("amod", NodePattern.N.inFormSequence(2, "re", "-", ".*ing")).directlyBeforeHead(), NodePattern.N.inPhrase(NodePattern.N.inFormSequence(1, "typing", "assists?")), NodePattern.N.directlyBefore(CommonPatterns.openingParen.before(closingBracket)), NodePattern.N.lemma(EnglishTreePatterns.adjectiveUnlikelyToBeNounLemmas));
    private static final NodePattern quotedSubject = NodePattern.or(NodePattern.N.withPhraseStart(EnglishTreePatterns.aposOrQuote.noSpaceAfter()), NodePattern.N.withPhraseEnd(EnglishTreePatterns.aposOrQuote.noSpaceBefore()), NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(EnglishTreePatterns.aposOrQuote.noSpaceAfter())).withPhraseEnd(NodePattern.N.directlyBefore(EnglishTreePatterns.aposOrQuote.noSpaceBefore())), NodePattern.N.withDependent("punct", EnglishTreePatterns.aposOrQuote));
    private static final NodePattern oneOfMy = NodePattern.N.withHeadRelation("nmod").withDependent("nmod:poss", NodePattern.or(Semantics.Animacy.humanLike.pattern, Semantics.Animacy.animal.pattern));
    static final NodePattern errorPattern = NodePattern.or(NodePattern.or(EnglishTreePatterns.subject, possiblyVocative).and((subj, match) -> SubjectVerbAgreement.checkAgreement(subj.head(), match, subj)).and(subj -> SubjectVerbAgreement.shouldCheckAgreement(subj.head(), subj)), SubjectVerbAgreement.iDisagreement()).message("Subject-verb agreement seems to be violated");
    private static final NodePattern brokenSubj = NodePattern.or(NodePattern.N.withHeadRelation("csubj").pos("VB"), NodePattern.N.withHeadRelation("nsubj").andOr(NodePattern.N.pos("NN.*").withHead(NodePattern.N.withHead("ccomp", EnglishTreePatterns.possiblyImperativeVB.noDependents("obj")).noDependents("mark")), NodePattern.N.beforeHead().withDependent("amod", EnglishTreePatterns.possiblyImperativeVB).withHead(NodePattern.N.potentialPos("NN.*")).andNot(NodePattern.N.withNextSibling(NodePattern.N.beforeHead())), NodePattern.N.withHead(NodePattern.ROOT.withDependent("case").noDependents("cop|aux|aux:pass").potentialPos("NN.*")).trace("nmod misparsed as a root clause"), NodePattern.N.directlyAfterHead().withHead(NodePattern.N.pos("VB.*").withHeadRelation("conj").noDependents("expl").noLemma("be")).trace("misparsed obj in 'and helps you do something'"), NodePattern.N.withDependent("acl", NodePattern.N.pos("VBG").withDependent("mark", NodePattern.N.form("for")).noDependents(NodePattern.N.afterHead())).message("oversplit 'option for sorting include directives'"), NodePattern.N.withPrevSibling(NodePattern.N.form("part|half|third|quarter").withHeadRelation("obl"))), NodePattern.N.withHeadRelation("nsubj(:pass)?").andOr(NodePattern.N.withPrevSibling(NodePattern.N.form("hey")).trace("misparsed vocative"), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cc")).markAs("Subj").andOr(NodePattern.N.withNeighbor(-2, NodePattern.N.pos("VBG").withDependent("case", NodePattern.N.form("before|after|since|until"))).noDependents(NodePattern.N.beforeHead()), NodePattern.N.withHead(NodePattern.N.withHead("conj|parataxis", NodePattern.ROOT.withDependent("conj", NodePattern.N.before("Subj")))))), NodePattern.N.withDependent("dep"));
    private static final NodePattern couldBe_vb_compound_obj = CommonPatterns.firstWord.potentialPos("VB.*").withNeighbor(1, NodePattern.ROOT.pos("VB").potentialPos("NN").directlyBefore(NodePattern.N.pos("NN.*"))).withNeighbor(2, NodePattern.N.pos("NN.*"));
    private static final NodePattern compoundMisparsedAsClause = NodePattern.or(NodePattern.N.pos("NN").withDependent("mark", NodePattern.N.pos("IN")).directlyAfter(NodePattern.N.directlyBeforeHead().withHeadRelation("nsubj").potentialPos("NN.*")), NodePattern.N.directlyAfterHead().withHead("obj", NodePattern.N.pos("NN|VBG").withHeadRelation("csubj")).trace("modernizing development"));
    private static final NodePattern gerundObjMisparsedAsCompound = NodePattern.N.beforeHead().andOr(NodePattern.N.withDependent("amod", CommonPatterns.firstChildPhrase.potentialPos("VBG")).trace("following redirects"), NodePattern.N.withDependent("compound", CommonPatterns.firstChildPhrase.withDependent("compound", CommonPatterns.firstChildPhrase.pos("VBG"))).trace("Debugging method chains"));
    private static final NodePattern misparsedGenitiveWhich = NodePattern.N.form("which").directlyBeforeHead().directlyBefore(NodePattern.N.potentialPos("NN.*").withDependent("obj", NodePattern.N.pos("NN.*").directlyAfterHead().and(CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("acl:relcl")))));
    private static final NodePattern definitelyRelativizer = NodePattern.or(NodePattern.N.form("who"), NodePattern.N.form("which|that").andNot(misparsedGenitiveWhich).andNot(NodePattern.N.directlyAfter(CommonPatterns.comma))).noDependents();
    static final NodePattern hasClauseCompoundAmbiguity = NodePattern.or(NodePattern.N.potentialPos("VB").directlyBefore(CommonPatterns.capitalized.directlyBefore(CommonPatterns.capitalized)).trace("Search Include Patterns"), couldBe_vb_compound_obj.trace("could be verb + compound obj"), NodePattern.N.withHeadRelation("csubj").andOr(NodePattern.N.withDependent("det"), NodePattern.N.noDependents("mark").withHead(NodePattern.N.pos("VBP?")).withDependent("obj", NodePattern.N.pos("NNS").withDependent("compound").noDependents("det|amod"))).trace("csubj clause compound ambiguity"), NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen).withNeighbor(2, NodePattern.N.markAs("Next")).withHead("nsubj", NodePattern.N.alreadyMarkedAs("Next")).trace("auto-update parsed as subject+predicate"), NodePattern.N.directlyBeforeHead().directlyBefore(NodePattern.or(couldBeNnsVb.trace("couldBeNnsVb"), NodePattern.N.inFormSequence(1, "space", "cloud"), NodePattern.N.inFormSequence(1, "octopus", "deploy"), Semantics.dockerCompose, Semantics.composeForX, NodePattern.N.inFormSequence(0, "start", "offset"), NodePattern.N.inFormSequence(1, "pull", "request"), NodePattern.N.inFormSequence(0, "return", "type"), NodePattern.N.inFormSequence(0, "focus", "border"), NodePattern.N.inFormSequence(0, "foreground|background", "color"), NodePattern.N.inFormSequence(0, "query", "language"), NodePattern.N.inFormSequence(0, "build|compose", "artifacts?"), NodePattern.N.form("ready|instance|bar"))).trace("subj directly before verb-compound ambiguity"), NodePattern.N.directlyAfter(NodePattern.N.directlyBeforeHead().withHeadRelation("compound").pos("NNS")).pos("NN").potentialPos("VBN").trace("misparsed VBN"), NodePattern.N.directlyBeforeHead().withHead("nsubj", NodePattern.N.potentialPos("NNS?")).withNextSiblingIncludingOtherSide(NodePattern.N.withHeadRelation("obl").withNextSibling(NodePattern.N.withHeadRelation("advcl").withPhraseStart(NodePattern.N.form("as").directlyAfter(NodePattern.N.pos("NNS?"))))).trace("'[Compound Subj Nmod as Nmod] Verb' misparsed as 'Subj Verb Obl [as Subj Verb]'"), NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.ROOT.pos("NN").markAs("MisattachedCompound"))).withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withHead("conj", NodePattern.N.alreadyMarkedAs("MisattachedCompound"))).trace("'Root X and Y are OK' misparsed as ROOT + 'X and Y are OK' conj clause"), compoundMisparsedAsClause.trace("compoundMisparsedAsClause"), NodePattern.N.inFormSequence(0, "git", "push|pull|reset|add|commit|log|clean|clone|fetch|merge|rebase|revert").directlyBeforeHead().trace("git command"), gerundObjMisparsedAsCompound, NodePattern.N.withHead("nsubj", NodePattern.N.potentialPos("NN").markAs("Noun").withDependent("xcomp", NodePattern.N.pos("NN.*").and(CommonPatterns.closestDepToHead))).withDependent("nmod", NodePattern.N.directlyBefore("Noun")).trace("misparsed missing verb: increase of X number (is) something"), NodePattern.N.beforeHead().markAs("Subj").withHead("nsubj.*", NodePattern.ROOT.andOr(NodePattern.N.potentialPos("NN.*").directlyAfter(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Subj"))).andOr(CommonPatterns.lastWord, NodePattern.N.directlyBefore(CommonPatterns.lastWord.pos("NN.*")), NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.N.withHeadRelation("punct|advcl")))), NodePattern.N.pos("VB").directlyBefore(EnglishTreePatterns.verbAsCompoundToleratingHead).directlyAfter(NodePattern.N.pos("VB.*")), NodePattern.N.inFormSequence(1, "stack", "trace")).noDependents("obj", NodePattern.N.before("Subj")).trace("misparsed root NP")));
    private static final NodePattern singularCsubj = NodePattern.N.withHead("csubj.*", NodePattern.N.noDependents("cop").noHeadRelation("conj")).andNot(CommonPatterns.possiblySkipDown("i?obj|obl", NodePattern.N.withDependent("conj"))).andNot(hasClauseCompoundAmbiguity);

    SubjectVerbAgreement() {
    }

    private static NodePattern xAndY(String x, String y) {
        return xAndYConj.form(x).withNeighbor(2, NodePattern.N.form(y));
    }

    private static Map<String, List<String>> XAndYAmbList() {
        LinkedHashMap<String, List<String>> x2y = new LinkedHashMap<String, List<String>>();
        for (String str : WordSet.loadLines("en/x_and_y_ambiguous.txt")) {
            String[] parts;
            if (str.isBlank() || (parts = str.toLowerCase(Locale.ROOT).split(" and ")).length != 2) continue;
            x2y.computeIfAbsent(parts[0], __ -> new ArrayList()).add(parts[1]);
        }
        return x2y;
    }

    static NodePattern orAgreement() {
        return orInCompoundSubject.and(NodePattern.custom((or, match) -> {
            Node predicate;
            Node subject = match.getMarkedNode("Subj");
            Node closest = subject.isAfter(EnglishTreePatterns.findFiniteVerb(predicate = match.getMarkedNode("Predicate"))) ? subject : match.getMarkedNode("LastConj");
            match = SubjectVerbAgreement.checkAgreement(predicate, match, closest);
            return match == null || errorPattern.matches(subject) ? null : match;
        })).message("In formal writing, verbs usually agree with the closest nouns in compound subjects joined by '$_'");
    }

    @Nullable
    private static NodeMatch checkAgreement(Node predicate, NodeMatch match, Node subject) {
        Node finite = EnglishTreePatterns.findFiniteVerb(predicate);
        Number verbNumber = Number.verbNumber(finite);
        if (verbNumber == Number.ambiguous) {
            return null;
        }
        Number subjectNumber = SubjectVerbAgreement.subjectNumber(subject, predicate);
        Node neighbor = SubjectVerbAgreement.findDuplicateNeighbor(finite);
        if (neighbor != null) {
            if (CommonPatterns.haveSamePos(neighbor, finite)) {
                return null;
            }
            if (subjectNumber.conflictsWith(Number.verbNumber(neighbor))) {
                return match.withCorrector(NodeCorrector.replace(neighbor, ""));
            }
            if (subjectNumber.conflictsWith(verbNumber)) {
                return match.withCorrector(NodeCorrector.replace(finite, ""));
            }
        }
        if (subjectNumber.conflictsWith(verbNumber)) {
            Node elidedAux;
            PhraseCommaChange change;
            NodeCorrector addVocativeComma;
            List<Node> candidates;
            match = match.withTouchedNodes(finite, predicate, subject, Number.findOfNmod(subject));
            boolean relativizer = SubjectVerbAgreement.isRelativizer(subject, predicate);
            Node relHost = null;
            if (relativizer && (candidates = EnglishTreePatterns.findRelativeClauseHostCandidates(subject, predicate)).size() == 1) {
                relHost = candidates.get(0);
            }
            Node subjEnd = subject.phraseEnd();
            NodeCorrector nodeCorrector = addVocativeComma = possiblyVocative.matches(subject) ? NodeCorrector.insertAfter(subjEnd, ",") : null;
            if (likelyVocative.matches(subject)) {
                match = match.withCorrector(addVocativeComma);
            }
            if (theseIs.matches(subject)) {
                match = match.withCorrector(NodeCorrector.replace(subject, "there"));
            }
            if (subject.nextNode() == predicate) {
                match = SubjectVerbAgreement.suggestMissingPrepositions(predicate, subject, verbNumber, match);
            }
            Node npHead = relHost != null ? relHost : subject;
            Node npPredicate = relHost == null ? predicate : AgreementSet.subjectHead(npHead);
            match = new AgreementSet(npHead, subjectNumber, npPredicate).changeNumber(match);
            if (!relativizer || relHost != null) {
                match = new AgreementSet(npHead, verbNumber, npPredicate).changeNumber(match);
            }
            if (addVocativeComma != null) {
                match = match.withCorrector(addVocativeComma).withReportedNode(subjEnd);
            }
            if (addCommaBeforeWhich.matches(subject) && (change = PunctuationRules.addCommasQuoteAware(predicate, CommaLicense.NeedCommas.around)) != null) {
                match = match.withCorrector(change.correct()).withReportedNode(subject);
            }
            Node negation1 = StreamEx.of(predicate.findDependents("advmod")).findFirst(EnglishTreePatterns.contractedNot::matches).orElse(null);
            match = match.withReportedNodes(negation1, finite);
            if (relativizer) {
                match = match.withTouchedNodes((Iterable<Node>)subject.hierarchy());
            }
            if ((elidedAux = SubjectVerbAgreement.findElidedAux(predicate)) != null) {
                match = match.withCorrector(NodeCorrector.insertAfter(subjEnd, " " + elidedAux.lowForm()));
            }
            if (subjectNumber == Number.plural && notVerb.matches(predicate)) {
                return null;
            }
            if (verbNumber == Number.singular && possibleCsubj.matches(subject)) {
                return null;
            }
            if (verbNumber == Number.plural && misparsedAdjCopula.matches(predicate)) {
                match = match.withReportedNode(subject).withCorrector(NodeCorrector.insertAfter(subject, " is"));
            }
            if (shouldConcede.matches(predicate)) {
                match = match.concedingToOtherGrammarCheckers();
            }
            return SubjectVerbAgreement.touchSuspiciousSentenceBounds(match, predicate.tree());
        }
        return null;
    }

    @Nullable
    private static Node findDuplicateNeighbor(Node finite) {
        Node prev = finite.prevNode();
        if (prev != null && CommonPatterns.haveSameLemma(prev, finite) && (EnglishTreePatterns.duplicateVerbParsedAsSubj.matches(prev) || prev.hasHeadRelation("dep"))) {
            return prev;
        }
        Node next = finite.nextNode();
        if (next != null && CommonPatterns.haveSameLemma(next, finite) && SubjectVerbAgreement.checkNextVerbDuplication(finite, next)) {
            return next;
        }
        return null;
    }

    private static boolean checkNextVerbDuplication(Node finite, Node next) {
        if (finite.head() == next) {
            return finite.hasHeadRelation("dep");
        }
        return finite.hasHeadRelation("cop|aux|aux:pass") ? next.hasHeadRelation(finite.headRelation()) : next.hasHeadRelation("[xc]comp");
    }

    private static NodeMatch suggestMissingPrepositions(Node predicate, Node subject, Number verbNumber, NodeMatch match) {
        List prepositions;
        NodeMatch found = findPotentialNmodHead.match(subject);
        if (found == null) {
            return match;
        }
        Node prev = found.getMarkedNode("NmodHead");
        if (!verbNumber.conflictsWith(SubjectVerbAgreement.subjectNumber(prev, predicate)) && !(prepositions = ((StreamEx)((StreamEx)StreamEx.of(EnglishValences.potentialValences(prev)).flatCollection(a -> a.arguments).distinct()).select(EnglishValences.NominalArgument.class).map(a -> a.preposition).filter(p -> p != null && !p.equals("of") && SemCompatibility.isPrepositionApplicable(p, subject))).toList()).isEmpty()) {
            return match.withReportedNode(prev).withCorrectors(prepositions.stream().map(p -> NodeCorrector.insertAfter(prev, " " + p)).toList());
        }
        return match;
    }

    private static boolean shouldCheckAgreement(Node predicate, Node subject) {
        return !noVerbAgreementCheck.matches(predicate) && !SubjectVerbAgreement.maybeIntroMisclassifiedAsSubject(subject, predicate) && !WordConfusion.wheyThey.matches(subject) && !WordConfusion.inIt.matches(subject) && !WordConfusion.myMayTypo.matches(predicate.prevNode()) && !possiblyMisattachedNP.matches(subject);
    }

    private static NodeMatch touchSuspiciousSentenceBounds(NodeMatch match, Tree tree) {
        Node lastNode = tree.nodes().get(tree.nodes().size() - 1);
        if (!lastNode.hasForm("[.?!]")) {
            match = match.withTouchedNode(lastNode);
        }
        return match;
    }

    private static boolean maybeIntroMisclassifiedAsSubject(Node subject, Node predicate) {
        return ((StreamEx)subject.nextUntil(predicate).filter(introSeparator::matches)).count() == 1L;
    }

    @NotNull
    static Number subjectNumber(Node subject, @Nullable Node predicate) {
        Number coordinated;
        if (brokenSubj.matches(subject)) {
            return Number.ambiguous;
        }
        if (predicate != null && quotedSubject.matches(subject)) {
            return Number.ambiguous;
        }
        if (subject.headRelation().startsWith("csubj")) {
            return singularCsubj.matches(subject) ? Number.singular : Number.ambiguous;
        }
        List<Node> conjs = subject.findDependents("conj");
        if (!conjs.isEmpty() && (coordinated = SubjectVerbAgreement.getConjNumber(subject, predicate, conjs)) != null) {
            return coordinated;
        }
        List<Node> appositives = subject.findDependents("appos");
        if (appositives.size() > 1) {
            return Number.ambiguous;
        }
        if (appositives.size() == 1 && appositives.get(0).prevNode() == subject && appositives.get(0).hasPos("NNS?")) {
            return Number.ambiguous;
        }
        if (possiblyMisparsedSubject.matches(subject) || CommonPatterns.beforeSlashOrParenth.matches(subject)) {
            return Number.ambiguous;
        }
        if (singularCopulaAllowed.matches(predicate)) {
            return Number.ambiguous;
        }
        if (predicate != null && SubjectVerbAgreement.isRelativizer(subject, predicate)) {
            List<Node> hosts = EnglishTreePatterns.findRelativeClauseHostCandidates(subject, predicate);
            if (hosts.stream().anyMatch(n -> n.findDependents("conj").stream().anyMatch(c -> c.isBefore(subject)) || n.hasHeadRelation("conj") || oneOfMy.matches((Node)n) || possiblyMisparsedSubject.matches((Node)n) || errorPattern.matches((Node)n) || quotedSubject.matches((Node)n) || CommonPatterns.beforeSlashOrParenth.matches((Node)n))) {
                return Number.ambiguous;
            }
            Set possibilities = StreamEx.of(hosts).map(n -> SubjectVerbAgreement.npNumberWithoutConjuncts(n)).toSet();
            return possibilities.size() == 1 ? (Number)((Object)possibilities.iterator().next()) : Number.ambiguous;
        }
        Number number = SubjectVerbAgreement.npNumberWithoutConjuncts(subject);
        if (number == Number.singular && (!conjs.isEmpty() || predicate != null && SubjectVerbAgreement.hasPossibleConjAmbiguityBetween(subject, predicate))) {
            return Number.ambiguous;
        }
        return number;
    }

    @Nullable
    private static Number getConjNumber(Node subject, @Nullable Node predicate, List<Node> conjs) {
        block19: {
            block18: {
                if (possiblyUnitingSharedArgument.matches(subject) || Number.theAdjCoordination.matches(subject) || gerundObjMisparsedAsCompound.matches(subject)) {
                    return Number.ambiguous;
                }
                if (xAndYConj.matches(subject) && xToYAmbiguous.getOrDefault(subject.lowForm(), List.of()).contains(subject.neighbor(2).lowForm())) {
                    return Number.ambiguous;
                }
                if (xAndYSingular.matches(subject)) {
                    return Number.singular;
                }
                if (subject.nextUntil(conjs.get(0)).anyMatch(n -> n.hasForm("\\("))) {
                    return Number.ambiguous;
                }
                if (modConjAmbiguity.matches(subject)) break block18;
                if (!conjs.stream().anyMatch(EnglishTreePatterns.clause::matches)) break block19;
            }
            return Number.ambiguous;
        }
        List allConjs = StreamEx.of((Object)subject).append(conjs).toList();
        if (Semantics.canDescribeSameEntity(allConjs)) {
            return Number.ambiguous;
        }
        if (allConjs.size() == 2 && Semantics.areSimilarOpposites((Node)allConjs.get(0), (Node)allConjs.get(1))) {
            return Number.ambiguous;
        }
        Node finite = predicate == null ? null : EnglishTreePatterns.findFiniteVerb(predicate);
        Node last = conjs.get(conjs.size() - 1);
        Node cc = last.findSingleDependent("cc");
        if (orInCompoundSubject.matches(cc) && finite != null) {
            if (finite.isAfter(subject)) {
                return SubjectVerbAgreement.conjunctNumber(subject) == Number.plural && SubjectVerbAgreement.conjunctNumber(last) == Number.plural ? Number.plural : Number.ambiguous;
            }
            if (CommonPatterns.firstWord.matches(finite)) {
                return SubjectVerbAgreement.conjunctNumber(subject) == Number.singular && SubjectVerbAgreement.conjunctNumber(last) == Number.singular ? Number.singular : Number.ambiguous;
            }
        }
        if (cc != null && cc.hasForm("and")) {
            if (allConjs.size() == 2 && (CommonPatterns.comma.matches(((Node)allConjs.get(1)).phraseStart()) || CommonPatterns.HYPHEN_LIKE_NODE.matches(((Node)allConjs.get(1)).phraseStart()))) {
                return Number.ambiguous;
            }
            if (!NodePattern.N.withDependent("det", NodePattern.N.lemma("no|each|every")).matches(subject) && !subject.hasDependent("appos")) {
                if (!(allConjs.stream().allMatch(CommonPatterns.capitalized::matches) || subjectAfterBe.matches(predicate) || cc.isAfter(subject) && cc.nextNode() != null && cc.nextNode().hasForm("not"))) {
                    return Number.plural;
                }
            }
            if (allConjs.stream().allMatch(namedEntityLike::matches) && !SubjectVerbAgreement.isSingleNamedEntity((Node)allConjs.get(0), (Node)allConjs.get(allConjs.size() - 1))) {
                if (allConjs.size() > 2 && subject.hasDependent("appos")) {
                    return Number.ambiguous;
                }
                return Number.plural;
            }
        }
        return null;
    }

    private static Number conjunctNumber(Node conjunct) {
        return conjunct.hasForm("I") ? Number.plural : SubjectVerbAgreement.npNumberWithoutConjuncts(conjunct);
    }

    private static boolean isSingleNamedEntity(Node node1, Node node2) {
        if (Semantics.customsAndBorderProtection.matches(node1) && node2 == node1.neighbor(3)) {
            return true;
        }
        SentenceWithNERAnnotations.Annotation ner1 = node1.nerAnnotation();
        return ner1 != null && ner1.equals((Object)node2.nerAnnotation());
    }

    private static boolean hasPossibleConjAmbiguityBetween(Node start, @NotNull Node end) {
        return start.nextUntil(end).anyMatch(cc -> cc.hasForm("and") && start.nextUntil((Node)cc).noneMatch(n -> n.hasForm("between")));
    }

    private static boolean isRelativizer(Node subject, Node predicate) {
        return realRelCl.matches(predicate) && definitelyRelativizer.matches(subject);
    }

    @NotNull
    private static Number npNumberWithoutConjuncts(Node noun) {
        if (noun.hasLemma("some|the|that|none")) {
            return Number.ambiguous;
        }
        if (possiblySingleUnit.matches(noun)) {
            return Number.ambiguous;
        }
        if (noun.hasForm("we|they|you")) {
            return modifiedPronoun.matches(noun) ? Number.ambiguous : Number.plural;
        }
        if (noun.hasForm("s?he|it|one|I")) {
            return Number.singular;
        }
        if (hasClauseCompoundAmbiguity.matches(noun) || QuantifierNounCompatibility.groupNumberIssue.matches(noun)) {
            return Number.ambiguous;
        }
        HashSet<Number> numbers = new HashSet<Number>();
        List<Node> specifiers = SubjectVerbAgreement.getSpecifiers(noun);
        for (Node det : specifiers) {
            Number number = Number.specifierNumber(det);
            if (number == null) continue;
            numbers.add(number);
        }
        numbers.add(Number.npNumberGroupAware(noun));
        if (numbers.contains((Object)Number.singular) == numbers.contains((Object)Number.plural)) {
            return Number.ambiguous;
        }
        return numbers.contains((Object)Number.singular) ? Number.singular : Number.plural;
    }

    private static List<Node> getSpecifiers(Node noun) {
        Node head = noun.head();
        List<Node> specifiers = noun.findDependents("det|amod");
        if (!specifiers.isEmpty() && specifiers.get(0).hasForm("that") && head != null && head.hasHeadRelation("ccomp|xcomp")) {
            return specifiers.subList(1, specifiers.size());
        }
        return specifiers;
    }

    private static NodePattern iDisagreement() {
        NodePattern disagreement1Sg = NodePattern.or(NodePattern.N.form("were").correct(NodeCorrector.replace("was")), NodePattern.N.form("are").andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("not"))).correct(NodeCorrector.replace("am", "ate")), NodePattern.N.lemma("be").noForm("am|['\u2019`\u2018][ms]|was|ai").andNot(NodePattern.N.inFormSequence(0, "are", EnglishTreePatterns.contractedNot.getFormRegex(), "I")).and((node, match) -> {
            Node next = node.nextNode();
            boolean negated = next != null && next.hasLemma("not");
            boolean contracted = EnglishTreePatterns.startsWithApostrophe.matches(node);
            String replacement = (contracted ? " " : "") + "am" + (negated ? " not" : "");
            if (contracted) {
                match = match.withReportedNode(node.prevNode());
            }
            return match.withCorrector(NodeCorrector.replaceNodes(node, negated ? next : node, replacement));
        }), NodePattern.N.form("does").correct(NodeCorrector.replace("do")), NodePattern.N.pos("VBZ").andNot(EnglishTreePatterns.apostropheS).correct(NodeCorrector.inflect("VBP")));
        return NodePattern.N.form("I").lemma("I").withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.N.noDependents("cop|aux|aux:pass").markAs("Verb"), NodePattern.N.pos("JJ|VB[NDP]?|NN.*").withDependent("cop|aux|aux:pass", NodePattern.N.markAs("Verb")).andNot(CommonPatterns.severalDependents("cop|aux|aux:pass"))).andNot(CommonPatterns.possiblyConj(irrealisVP)).and(NodePattern.markedNodeMatches("Verb", disagreement1Sg.includeIntoReport())).withOptionalDependent("advmod", EnglishTreePatterns.contractedNot.includeIntoReport()).andNot(EnglishTreePatterns.severalSubjects).noDependents("advmod", NodePattern.N.lemma("rather"))).andNot(misparsedId).noDependents("conj|nummod").andNot(possiblyMisattachedNP).andNot(quotedSubject).andNot(modifiedPronoun);
    }

    static NodePattern secondaryAux() {
        Pattern pattern = Pattern.compile("cop|aux|aux:pass");
        return NodePattern.custom(node -> {
            if (pattern.matcher(node.headRelation()).matches()) {
                Node firstAux = EnglishTreePatterns.findFirstCopAux(Objects.requireNonNull(node.head()));
                return firstAux != null && firstAux.isBefore((Node)node);
            }
            return false;
        });
    }

    @Nullable
    static Node findElidedAux(Node predicate) {
        NodeMatch match = auxEllipsis.match(predicate);
        return match == null ? null : match.getMarkedNode("ElidedAux");
    }
}

