/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import java.util.List;

class Tautology {
    private static final String ALSO_OR_AS_WELL = "Use either 'also' or 'as well'";
    private static final String SEEMS_REDUNDANT_WITH = "seems redundant with";
    private static final NodePattern withAlthough = NodePattern.N.withDependent("mark", NodePattern.N.form("although").includeIntoReport(ReportingKind.Hover));
    static final NodePattern withAbbreviatedCompound = NodePattern.or(Tautology.withCaseSensitiveCompound("number", "PIN|VIN|ISBN|IBAN"), Tautology.withCaseSensitiveCompound("disk", "CD|DVD"), Tautology.withCaseSensitiveCompound("machine", "ATM"), Tautology.withCaseSensitiveCompound("virus", "HIV"), Tautology.withCaseSensitiveCompound("display", "LCD"), Tautology.withCaseSensitiveCompound("memory", "RAM"), Tautology.withCaseSensitiveCompound("code", "UPC"), Tautology.withCaseSensitiveCompound("system", "CMS"));

    Tautology() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.TAUTOLOGY", "Avoid tautology", "Statements that repeat the same idea in different words can result in unnecessary and verbose repetition.", "https://www.yourdictionary.com/articles/examples-tautology-meaning", () -> NodePattern.or(Tautology.general(), Tautology.redundantAdverb(), Tautology.redundantNominalModifier(), Tautology.redundantNominalHead()), new Example("We\u2019ve <b>also</b> implemented code support on the server side <b>as well</b>.", "We\u2019ve implemented code support on the server side <b>as well</b>.", "We\u2019ve <b>also</b> implemented code support on the server side."), new Example("You get <b>complimentary</b> <i>bonuses</i>!", "You get <b>bonuses</b>!")).styleFlavor(StyleFlavor.Readability));
    }

    private static NodePattern redundantAdverb() {
        return NodePattern.or(EnglishTreePatterns.adverbRel("adequate", NodePattern.N.form("enough").correct(NodeCorrector.replace(""))).includeIntoReport(ReportingKind.Hover).message("'adequate' is already enough"), NodePattern.N.inFormSequence(0, "back", "and", "forth").withHead("advmod", NodePattern.N.lemma("commute").includeIntoReport(ReportingKind.Hover)).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "")).message("'commute' is always 'back and forth"), EnglishTreePatterns.adverbRel("personally|individually", NodePattern.N.lemma("think").includeIntoReport(ReportingKind.Hover)).and((node, match) -> EnglishTreePatterns.removeWithSurroundingPunctuation(node, node, match)).message("'$_' seems redundant with '$MainWord'"), NodePattern.or(NodePattern.N.lemma("exaggerate").includeIntoReport(ReportingKind.Hover).withDependent("mark|advmod", NodePattern.N.beforeHead().form("over").markAs("Over")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Over"), NodePointer.neighbor(-1), "")).message("'over' seems redundant with '$_'"), NodePattern.N.lemma("overexaggerate").correct(EnglishTreePatterns.changeVerbLemma("exaggerate")).message("'over-' seems redundant")), NodePattern.N.inFormSequence(0, "until", "now").withHead("case", NodePattern.N.withHead("obl", NodePattern.N.withDependent("obl", NodePattern.or(DateChecker.year, EnglishDateChecker.dayOfMonth, EnglishDateChecker.slashDateNode).markAs("SinceAnchor").withDependent("case", NodePattern.N.form("since").includeIntoReport(ReportingKind.Hover))))).noMatchUntil("SinceAnchor", EnglishTreePatterns.sentenceBoundary).correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1))).message("'until now' seems redundant with 'since'"), NodePattern.N.lemma("postpone").includeIntoReport(ReportingKind.Hover).withDependent("obl", NodePattern.N.inFormSequence(1, "until", "later").noDependents("obl", NodePattern.N.afterHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), ""))).message("'until later' seems redundant with 'postpone'"), NodePattern.N.lemma("return").withDependent("advmod", CommonPatterns.possiblySkipDown("advmod", NodePattern.N.form("back").markAs("Back").includeIntoReport(ReportingKind.Hover).andNot(NodePattern.N.inFormSequence(0, "back", "to", "front")))).andOr(NodePattern.N.withDependent("obj", NodePattern.or(NodePattern.N.pos("NNP"), NodePattern.N.form("me|us|you|him|her"))).correct(EnglishTreePatterns.changeVerbLemma("bring")).correct(EnglishTreePatterns.changeVerbLemma("take")).message("'return back' seems redundant; consider using some other verb"), NodePattern.N.includeIntoReport(ReportingKind.Hover).correct(NodeCorrector.replace(NodePointer.marked("Back"), "")).message("'return back' seems redundant")), NodePattern.or(EnglishTreePatterns.adverbRel("together", NodePattern.N.lemma("combine|merge|blend|assemble|attach|cooperate|collaborate|connect|gather|integrate|mix")).afterHead(), EnglishTreePatterns.adverbRel("again", NodePattern.N.lemma("repeat|reconsider")), EnglishTreePatterns.adverbRel("back", CommonPatterns.skipUp("advmod", NodePattern.N.lemma("reply|retreat|revert"))), EnglishTreePatterns.adverbRel("down", NodePattern.or(CommonPatterns.skipUp("obl", NodePattern.N.lemma("descend")), NodePattern.N.lemma("dive"))), EnglishTreePatterns.adverbRel("originally|initially", NodePattern.N.form("born").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("in")))), EnglishTreePatterns.adverbRel("completely", NodePattern.N.lemma("fill|finish|annihilate|eliminate|surround")).noDependents()).withHead(NodePattern.N.includeIntoReport(ReportingKind.Hover)).correct(NodeCorrector.replace("")).message("'$_' seems redundant with '$MainWord'"));
    }

    private static NodePattern adjectiveRel(String adj, NodePattern node) {
        return NodePattern.N.form(adj).directlyBeforeHead().noDependents().withHead("amod|compound", node.markAs("MainWord"));
    }

    private static NodePattern redundantNominalModifier() {
        return NodePattern.or(NodePattern.or(Tautology.adjectiveRel("actual", NodePattern.N.lemma("fact|experience")), Tautology.adjectiveRel("added", NodePattern.N.lemma("bonus")), Tautology.adjectiveRel("advance", NodePattern.N.lemma("planning|reservation|warning|notice")), Tautology.adjectiveRel("armed", NodePattern.N.lemma("gunman")), Tautology.adjectiveRel("basic", NodePattern.N.form("fundamentals|essentials")).andNot(CommonPatterns.capitalized), Tautology.adjectiveRel("close", NodePattern.or(NodePattern.N.form("scrutiny"), NodePattern.N.form("proximity").noDependents("case", NodePattern.N.form("(with)?in")))), Tautology.adjectiveRel("definite", NodePattern.N.lemma("decision")), Tautology.adjectiveRel("difficult", NodePattern.N.lemma("dilemma")), Tautology.adjectiveRel("direct", NodePattern.N.lemma("confrontation")), Tautology.adjectiveRel("end", NodePattern.N.lemma("result")), Tautology.adjectiveRel("final", NodePattern.N.lemma("outcome|conclusion")), Tautology.adjectiveRel("first", NodePattern.N.lemma("priority")), Tautology.adjectiveRel("foreign", NodePattern.N.form("imports")), Tautology.adjectiveRel("former", NodePattern.N.form("alumnus|alumna|alumni|alumnae|alums?")), Tautology.adjectiveRel("free|complimentary", NodePattern.N.lemma("gift|present|giveaway|bonus")), Tautology.adjectiveRel("frozen", NodePattern.N.lemma("ice")), Tautology.adjectiveRel("future", NodePattern.N.lemma("plan|prospect")), Tautology.adjectiveRel("general", NodePattern.N.lemma("consensus")), Tautology.adjectiveRel("inadvertent", NodePattern.N.lemma("error")), Tautology.adjectiveRel("joint", NodePattern.N.lemma("cooperation|collaboration")), Tautology.adjectiveRel("major", NodePattern.N.form("breakthrough")), Tautology.adjectiveRel("natural", NodePattern.N.lemma("instinct")), Tautology.adjectiveRel("new", NodePattern.N.lemma("innovation")), Tautology.adjectiveRel("past", NodePattern.or(NodePattern.N.lemma("memory|record"), NodePattern.N.form("history|experience"))), Tautology.adjectiveRel("regular", NodePattern.N.lemma("routine")), Tautology.adjectiveRel("rough", NodePattern.N.lemma("estimation|estimate")), Tautology.adjectiveRel("sum", NodePattern.N.lemma("total")), Tautology.adjectiveRel("sworn", NodePattern.N.lemma("affidavit")), Tautology.adjectiveRel("therapeutic", NodePattern.N.lemma("treatment")), Tautology.adjectiveRel("true", NodePattern.N.lemma("fact")), Tautology.adjectiveRel("unexpected", NodePattern.N.lemma("surprise")), Tautology.adjectiveRel("unintentional|unintended", NodePattern.N.form("mistake")), Tautology.adjectiveRel("usual", NodePattern.N.form("custom"))).spaceAfter().withHead(NodePattern.N.includeIntoReport(ReportingKind.Hover)).andNot(NodePattern.N.withHead(NodePattern.N.withHead("conj", NodePattern.N.pos("JJ")))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.sameWordAs("MainWord")))).and((node, match) -> match.withCorrector(Articles.removeAndFixArticle(node))).message("'$_' seems redundant with '$MainWord'"), Tautology.adjectiveRel("general", NodePattern.N.form("public")).withHead(NodePattern.N.includeIntoReport(ReportingKind.Hover)).correct(NodeCorrector.replace("broader")).correct(NodeCorrector.replace("")).correct(NodeCorrector.replace(NodePointer.neighbor(1), "audience")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "community")).message("'general' seems redundant with 'public'"), NodePattern.N.form("bivouac").includeIntoReport(ReportingKind.Hover).andOr(CommonPatterns.skipUp("compound", NodePattern.N.withDependent("amod", NodePattern.N.form("temporary").correct(NodeCorrector.replace("")))).message("A bivouac is always temporary"), NodePattern.N.withHead("compound", NodePattern.N.form("camp").correct(NodeCorrector.replace(""))).message("A bivouac is a camp by definition")), NodePattern.N.form("price").andOr(NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.pos("JJ.*").markAs("Adj")), NodePattern.N.withDependent("amod", NodePattern.N.pos("JJ.*").markAs("Adj"))).and(NodePattern.markedNodeMatches("Adj", NodePattern.or(NodePattern.N.lemma("cheap").correct(ChangeLemma.to("low")), NodePattern.N.lemma("expensive").andOr(NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.N.form("more").correct(NodeCorrector.replace("").join(NodeCorrector.replace(NodePointer.marked("Adj"), "higher"))), NodePattern.N.form("most").correct(NodeCorrector.replace("").join(NodeCorrector.replace(NodePointer.marked("Adj"), "highest"))))), StyleRules.replaceFixArticle(List.of("high")))))).message("'$Adj' is not used with 'price'"), NodePattern.N.inFormSequence(0, "(auto)?biography", "of", "a|his|her|their|my|our|your", "life").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(3), "")).correct(NodeCorrector.replace("story")).message("A biography is always about a life"), NodePattern.N.inFormSequence(0, "consensus", "of", "opinion").includeIntoReport(ReportingKind.Hover).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(2), "")).message("'of opinion' seems redundant"));
    }

    private static NodePattern withCaseSensitiveCompound(String node, String compound) {
        return NodePattern.N.lemma(node).withDependent("compound", NodePattern.N.formCaseSensitive(compound).markAs("Compound"));
    }

    private static NodePattern redundantNominalHead() {
        return NodePattern.or(Tautology.adjectiveRel("alternative", NodePattern.N.form("choice").correct(NodeCorrector.replace(""))).includeIntoReport(ReportingKind.Hover).message("'choice' seems redundant"), withAbbreviatedCompound.andOr(NodePattern.N.directlyAfter("Compound"), NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen.markAs("Hyphen").directlyAfter("Compound"))).and(NodePattern.custom((node, match) -> {
            Node hyphen = match.findMarkedNode("Hyphen");
            Node compound = match.getMarkedNode("Compound");
            boolean plural = node.hasPos("NNS");
            return match.withCorrector(NodeCorrector.replaceNodes(hyphen != null ? hyphen : node, node, "").join(plural ? NodeCorrector.insertAfter(compound, "s") : null));
        })).reportRangeTo("Compound").message("The abbreviation '$Compound' already contains the word '$_'"));
    }

    private static NodePattern general() {
        return NodePattern.or(NodePattern.N.form("but").markAs("But").withHead("cc", NodePattern.or(NodePattern.N.withHead("conj", withAlthough), NodePattern.N.withDependent("advcl", withAlthough.before("But")))).message("In a sentence with 'although', 'but' is unnecessary").correct(NodeCorrector.replace("")), NodePattern.N.form("%").withHead("compound", EnglishTreePatterns.anyPercent.noForm("%").correct(NodeCorrector.replace(""))).message("Do not use both 'percent' and '%'").correct(NodeCorrector.replace("")), NodePattern.N.inFormSequence(0, "as", "well").reportEverythingTouched().withHead("advmod", EnglishTreePatterns.clause.withDependent("advmod", NodePattern.N.form("also").markAs("Also").correct(NodeCorrector.replace("")).includeIntoReport())).correct(NodeCorrector.replaceNodes(NodeMatch::anchor, NodePointer.neighbor(1), "")).message(ALSO_OR_AS_WELL), NodePattern.N.inFormSequence(0, "bald", "-", "headed").reportEverythingTouched().correct(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(2), "")).message("'bald' is always about a head"), NodePattern.N.lemma("big|brief|red|few|round|bitter").includeIntoReport(ReportingKind.Hover).withDependent("obl", NodePattern.N.inFormSequence(1, "in", "size|duration|color|number|shape|taste").noDependents(NodePattern.N.afterHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "")).message("Redundant quality specification?")), NodePattern.N.inFormSequence(1, "the", "question").markAs("Question").reportEverythingTouched().withHead("obj", NodePattern.N.lemma("ask").includeIntoReport(ReportingKind.Hover).andOr(NodePattern.N.withDependent("ccomp"), NodePattern.N.withDependent("obj", NodePattern.N.alreadyMarkedAs("Question").withDependent("ccomp")))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "")).message("'ask' is already enough"), NodePattern.N.form("individual|separate|specific").withHeadRelation("amod").directlyAfter(NodePattern.N.form("each|every").includeIntoReport(ReportingKind.Hover).markAs("Word")).correct(NodeCorrector.replace("")).message("'$_' seems redundant with '$Word'"));
    }
}

