/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.AdverbAdjectiveConfusion;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.AuxMainVerbForm;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishTreeSupport;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.tools.StringTools;

class UnexpectedVerb {
    static final Map<String, List<String>> predicativeOnlyAdjectives = WordSet.multiValueMap(WordSet.loadLines("en/words/adj_predicative.txt"));
    private static final NodePattern subjectOfSingularClause = NodePattern.N.withHead("nsubj.*", NodePattern.custom(n -> Number.verbNumber(EnglishTreePatterns.findFiniteVerb(n)) == Number.singular));
    static final Map<String, List<String>> verbsToNouns = WordSet.multiValueMap(WordSet.loadLines("en/words/verbs_to_nouns.txt"));

    UnexpectedVerb() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Grammar.UNEXPECTED_VERB", "Unexpected verb", "Report verbs in positions where verbs can\u2019t occur, e.g., after articles.", null, () -> NodePattern.or(UnexpectedVerb.afterDetLike(), UnexpectedVerb.adnominalClause()), new Example("Rewrite the tagger for more <b>optimize</b> working", "Rewrite the tagger for more <b>optimized</b> working", "Rewrite the tagger for more <b>optimizing</b> working", "Rewrite the tagger for more <b>optimizer</b> working"), new Example("When the <b>install</b> is complete.", "When the <b>installation</b> is complete."));
    }

    private static NodePattern adnominalClause() {
        NodePattern definitelyFinite = CommonPatterns.possiblySkipDown("cop|aux|aux:pass", NodePattern.N.pos("VBZ|MD"));
        NodePattern definitelyGerund = NodePattern.N.pos("VBG").noDependents("cop|aux|aux:pass");
        NodePattern considerAdj = CommonPatterns.replacementProduces("(.+)s$", "$1", "JJ").noDependents("i?obj").noDependents("conj", definitelyFinite);
        NodePattern considerVbn = CommonPatterns.replacementProduces("(.+)s$", "$1d", "JJ");
        return NodePattern.N.directlyAfterHead().pos("VBZ").withHead("acl", NodePattern.N.pos("NN").noDependents("nsubj", NodePattern.N.inFormSequence(0, "it", EnglishTreePatterns.apostropheS.getFormRegex()))).includeIntoReport().and(CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("obl|i?obj"))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj"))).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.inFormSequence(1, "function", "calls?")).and((acl, match) -> {
            if (considerAdj.matches(acl)) {
                return match.withCorrector(NodeCorrector.regexReplace(acl, "(.+)s$", "$1")).withMessage("Did you mean an adjective?");
            }
            if (considerVbn.matches(acl)) {
                return match.withCorrector(NodeCorrector.inflect(acl, "VBZ", "VBN")).withMessage("Did you mean a participle?");
            }
            List<Node> conjs = acl.findDependents("conj");
            boolean suggestGerund = conjs.stream().noneMatch(definitelyFinite::matches);
            boolean suggestFinite = conjs.stream().noneMatch(definitelyGerund::matches);
            if (suggestGerund) {
                match = match.withCorrector(NodeCorrector.inflect(acl, "VBZ", "VBG"));
            }
            if (suggestFinite) {
                Node head = acl.head();
                String pronoun = Semantics.animacy(head) == Semantics.Animacy.humanLike ? "who" : "that";
                match = match.withCorrector(NodeCorrector.insertBefore(acl, pronoun + " ")).withReportedNode(head);
            }
            return match.withMessage(suggestGerund ? "Did you mean an '-ing' form?" : "Missing pronoun?");
        }).withHead(NodePattern.not(NodePattern.N.withDependent("det", NodePattern.N.pos("WDT").trace("whatever work has Y"))).andNot(NodePattern.ROOT.and(CommonPatterns.capitalizedMiddle).trace("misparsed root clause with a proper name subject")));
    }

    private static NodePattern afterDetLike() {
        NodePattern feature = NodePattern.N.form("feature");
        NodePattern afterMore = NodePattern.N.directlyAfter(NodePattern.N.form("more").beforeHead().withHeadRelation("amod|advmod").markAs("Det")).withHeadRelation("amod|root|nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound");
        NodePattern suggestVbn = NodePattern.or(Semantics.lemmasDenotingGroupsAsPastParticiple, NodePattern.N.withHeadRelation("amod|compound"), afterMore, NodePattern.N.directlyAfter(NodePattern.N.directlyBeforeHead().withHeadRelation("compound")));
        NodePattern suggestOnlyVbn = NodePattern.N.lemma("attach|bless").withHeadRelation("compound|amod").beforeHead();
        NodePattern lonePostfixParticiple = NodePattern.N.pos("VBN").directlyAfterHead().noDependents().withHead("acl", NodePattern.N.beforeHead().noDependents("det").withDependent("case", NodePattern.N.directlyBeforeHead().form("on|after|before").markAs("Det")).withPhraseStart(NodePattern.N.alreadyMarkedAs("Det")));
        NodePattern iseNoun = NodePattern.N.form("practises?|advises?|devises?").withDependent("det|nmod:poss|amod", NodePattern.N.markAs("Det"));
        NodePattern definitelyVerb = NodePattern.or(NodePattern.N.potentialPos("VB[DPZ]?").noPotentialPos("NN.*|JJ.*|VBN").andNot(EnglishTreePatterns.startsWithApostrophe).noForm("am|attaches"), NodePattern.N.form("responds?|reroutes?|homeschools?|bodypaints?"), NodePattern.N.form("attaches").withHead(Articles.textActions));
        NodePattern misparsedClause = NodePattern.N.pos("VB").andOr(NodePattern.N.withDependent("compound|amod", NodePattern.N.pos("NN.*")).withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.form("how"))), NodePattern.N.withHeadRelation("nmod").withDependent("amod", NodePattern.N.beforeHead().directlyAfter(NodePattern.N.form("the"))).withDependent("case"));
        NodePattern adjPreModifier = NodePattern.N.beforeHead().withHead("obl:npmod|compound", NodePattern.N.withHead("amod", NodePattern.N.withDependent("case", NodePattern.N.markAs("Det"))));
        NodePattern possiblyMissingHyphen = EnglishTreePatterns.compound.andOr(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("amod").withPhraseStart(NodePattern.not(NodePattern.PUNCT).directlyBefore(CommonPatterns.HYPHEN_NODE))), NodePattern.N.withHead(adjPreModifier.directlyBefore(CommonPatterns.HYPHEN_NODE)));
        HashMap<String, List<String>> verbsToNouns = new HashMap<String, List<String>>(UnexpectedVerb.verbsToNouns);
        verbsToNouns.put("excel", List.of("Excel"));
        verbsToNouns.put("languish", List.of("language"));
        verbsToNouns.put("write", List.of("writing", "writer"));
        NodePattern mightBeCommand = NodePattern.N.pos("VB").withDependent("case", NodePattern.N.form("with")).withDependent("compound", NodePattern.N.beforeHead()).noDependents(NodePattern.N.afterHead());
        return NodePattern.or(definitelyVerb.andOr(NodePattern.N.beforeHead().markAs("Compound").and(CommonPatterns.skipUp("advmod", NodePattern.N.withHead("compound|amod", CommonPatterns.possiblySkipUp("amod", NodePattern.N.anyPos().withDependent("det|nmod:poss", NodePattern.N.markAs("Det")).noDependents("compound", NodePattern.N.between("Det", "Compound")))))).andNot(NodePattern.N.withHeadRelation("amod").withNextSibling(EnglishTreePatterns.compound)).noDependents("compound", NodePattern.N.after("Det")).noDependents("obj|obl").trace("verb as compound with det"), NodePattern.N.directlyBeforeHead().withHead("compound", NodePattern.N.directlyBeforeHead().withHead("compound", NodePattern.N.withDependent("det|nmod:poss", NodePattern.N.markAs("Det")))).trace("compound on compound"), NodePattern.N.withDependent("det|mark", NodePattern.or(NodePattern.N.pos("DT|WP").noForm("that|no").noDependents(), NodePattern.N.form("that").noHeadRelation("mark").directlyBeforeHead()).markAs("Det")).noHeadRelation("advcl").noDependents("dep").noDependents("punct", NodePattern.not(CommonPatterns.noSpaceHyphen).beforeHead().after("Det")).andOptionally(NodePattern.N.withHeadRelation("xcomp").withDependent("mark", NodePattern.N.form("to")).and(NodePattern.markedNodeMatches("Det", NodePattern.N.correct(NodeCorrector.replace(""))))).trace("with det"), NodePattern.N.withDependent("nsubj", NodePattern.or(NodePattern.N.form("the").markAs("Det").andOr(NodePattern.N.withHead(NodePattern.N.pos("VBZ")).correct(NodeCorrector.replace("that")), NodePattern.N.withHead(NodePattern.N.pos("VB[PD]").andOr(NodePattern.N.withHeadRelation("xcomp").correct(NodeCorrector.replace(NodePointer.marked("Det"), "them")), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Det"), "they"))))), NodePattern.N.formCaseSensitive("an?").markAs("Det").andNot(NodePattern.N.inFormSequence(1, "uppercase|lowercase", "a"))).directlyBeforeHead()), afterMore, NodePattern.N.withDependent("amod", NodePattern.N.form("many").markAs("Det")), NodePattern.N.withDependent("nummod", NodePattern.N.pos("CD").markAs("Det").noDependents("punct")).noDependents("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|punct", NodePattern.N.beforeHead()), NodePattern.N.directlyAfterHead().withHead("obj", NodePattern.not(Semantics.actionWithButtonAsObj).markAs("Det")).noDependents("flat"), NodePattern.N.withDependent("case", NodePattern.N.potentialPos("IN|DT").noForm("to|as").markAs("Det").directlyBefore(NodePattern.not(NodePattern.PUNCT))).noDependents(".*", NodePattern.N.beforeHead().after("Det").noHeadRelation("amod|det|compound|nmod:poss")).andNot(mightBeCommand).trace("with dependent case"), NodePattern.N.markAs("Verb").withHead("amod|compound", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").withDependent("case", NodePattern.N.markAs("Det").directlyBefore("Verb"))).trace("prep directly before amod|compound"), NodePattern.N.withDependent("nmod:poss", NodePattern.N.markAs("Det").andNot(NodePattern.N.pos("PRP\\$").directlyBeforeHead().directlyAfter(NodePattern.N.lemma("have"))).andNot(NodePattern.N.pos("PRP\\$_P.+").withHead(CommonPatterns.skipConjUp(NodePattern.ROOT)))), NodePattern.N.afterHead().withHead("nsubj", NodePattern.N.lemma("be").markAs("Det"))), lonePostfixParticiple, NodePattern.N.potentialPos("VB").andOr(NodePattern.N.beforeHead().markAs("Compound").noDependents().withHead("compound", NodePattern.or(NodePattern.N.withDependent("amod", NodePattern.N.beforeHead().after("Compound").withDependent(".*").noDependents("cc").andNot(NodePattern.N.pos("VBN").andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)))).withDependent("case", NodePattern.N.markAs("Det")).noDependents("det").trace("compound before amod"), adjPreModifier.trace("adjPreModifier"))), NodePattern.N.withHeadRelation("nmod").withDependent("obj").withDependent("nmod").withDependent("case", NodePattern.N.markAs("Det")).trace("nmod with case, obj, and nmod")).markAs("ProhibitVerbs"), iseNoun).andNot(CommonPatterns.capitalized.andNot(NodePattern.custom(n -> StringTools.isAllUppercase((String)n.tree().text())))).andNot(CommonPatterns.hashtag).andNot(NodePattern.markedNodeMatches("Det", NodePattern.N.directlyBefore(EnglishTreePatterns.quotations))).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.DASH_NODE, EnglishTreePatterns.quotations.noSpaceAfter()))).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations.noSpaceBefore())).andNot(misparsedClause).noDependents("nmod", EnglishTreePatterns.nmodWithoutCase.pos("NN.*")).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.contractedNot)).andNot(NodePattern.N.pos("VB").directlyAfter(NodePattern.N.form("to"))).includeIntoReport().and((node, match) -> {
            boolean compoundLike;
            Node det = match.getMarkedNode("Det");
            if (det.isAfter(node)) {
                return null;
            }
            NodeCorrector fixCompound = null;
            Node prev = node.prevNode();
            if (lonePostfixParticiple.matches(node) && Objects.requireNonNull(prev).hasPos("NNS")) {
                fixCompound = NodeCorrector.inflect(prev, "NNS", "NN");
            }
            if (suggestOnlyVbn.matches(node)) {
                return match.withCorrector(NodeCorrector.inflect(node, "VB.*", "VBN"));
            }
            if (det.hasForm("more") && node.hasHeadRelation("root")) {
                Node obj = node.findSingleDependent("obj");
                Node anchor = obj != null ? obj.phraseEnd() : node;
                match = match.withCorrector(NodeCorrector.replace(node.neighbor(-1), "").join(NodeCorrector.insertAfter(anchor, " more")));
                if (node.hasDependent("cop|aux.*|nsubj.*")) {
                    return match;
                }
            }
            if (node.hasHeadRelation("amod|compound")) {
                match = match.withCorrectors(AuxMainVerbForm.replaceByMap(node, AuxMainVerbForm.verbsToAdjectives));
            }
            for (String key : ((StreamEx)StreamEx.of((Object)node.lowForm()).append(node.lemmaReadings()).distinct()).toList()) {
                List replacements = (List)verbsToNouns.get(key);
                if (replacements == null || node.hasHeadRelation("amod")) continue;
                if (node.tagIndependentlyLowForm().hasPos("VBZ") && !key.equals(node.lowForm())) {
                    replacements = StreamEx.of((Collection)replacements).toFlatList(r -> Semantics.isDefinitelyUncountableNoun.test((String)r) ? List.of(r) : node.tree().treeSupport().synthesize((String)r, (String)r, "NN", "NNS"));
                }
                return match.withCorrector(NodeCorrector.replace(node, replacements).join(fixCompound));
            }
            boolean an = det.hasForm("an?");
            if (node.hasForm("is") && node.hasDependent("case")) {
                return match.withCorrector(NodeCorrector.replace(node, "it"));
            }
            if (node.hasForm("scissor") && an && det == prev) {
                return match.withCorrector(NodeCorrector.replaceNodes(det, node, "scissors", "a pair of scissors"));
            }
            if (node.nextNode() != null && node.nextNode().hasLemma("button")) {
                return match.withCorrector(CommonPatterns.capitalizeNode(node));
            }
            if (det.hasForm("like")) {
                Pair<Character, Character> quotes = EnglishTreePatterns.primaryQuotes(node);
                match = match.withCorrector(NodeCorrector.replace(node, String.valueOf(quotes.getFirst()) + node.form() + String.valueOf(quotes.getSecond())));
            }
            if (possiblyMissingHyphen.matches(node)) {
                match = match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1)));
            }
            if (suggestVbn.matches(node)) {
                match = match.withCorrector(NodeCorrector.inflect(node, "VB.*", "VBN"));
            }
            if (!(node.hasHeadRelation("compound") && an || NodePattern.N.withDependent("advmod", AdverbAdjectiveConfusion.clauseAdjAdverb).matches(node) || node.hasForm("headquarter"))) {
                match = match.withCorrector(NodeCorrector.inflect(node, "VB.*", "VBG").join(fixCompound));
            }
            if ((compoundLike = node.hasHeadRelation("compound|nmod")) && node.hasPos("NN.*")) {
                match = match.withCorrector(NodeCorrector.insertAfter(node, " of"));
            }
            boolean prohibitVerbs = match.findMarkedNode("ProhibitVerbs") != null;
            boolean needSingular = an || compoundLike || subjectOfSingularClause.matches(node);
            return match.withCorrector(NodeCorrector.replace(node, ((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)node.similarWordsOfPos(needSingular ? "JJ.*|NN" : "JJ.*|NNS?").filter(StringUtils::isAllLowerCase)).filter(s -> !an || (det.nextNode() != node || det.form().equalsIgnoreCase(Articles.getIndefiniteArticle(s))) && !Semantics.isDefinitelyUncountableNoun.test((String)s))).filter(s -> !prohibitVerbs || !node.tree().treeSupport().tagToken((String)s).hasPos("VB"))).filter(s -> !predicativeOnlyAdjectives.containsKey(s))).filter(s -> ((EnglishTreeSupport)node.tree().treeSupport()).hasFrequencyAtLeast((String)s, 66))).limit(3L)).toList()).join(fixCompound));
        }).andNot(EnglishTreePatterns.verbsMissingNounPosTags).andNot(NodePattern.N.withHead("compound|amod", CommonPatterns.possiblySkipUp("compound", EnglishTreePatterns.verbAsCompoundToleratingHead))).andNot(EnglishTreePatterns.compound.withNextSibling(EnglishTreePatterns.verbAsCompoundToleratingHead.withHeadRelation("compound"))).andNot(NodePattern.N.withDependent("conj|obj", EnglishTreePatterns.verbAsCompoundToleratingHead)).andNot(NodePattern.N.withDependent("conj", NodePattern.N.withDependent("obj", EnglishTreePatterns.verbAsCompoundToleratingHead))).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHead("cc", NodePattern.N.directlyBefore(EnglishTreePatterns.verbAsCompoundToleratingHead)))).andNot(NodePattern.N.form("spend").noDependents("compound").noHeadRelation("compound")).andNot(NodePattern.N.inFormSequence(1, "the", "hots")).andNot(NodePattern.N.inFormSequence(0, 1, "write", "protect")).andNot(NodePattern.N.inFormSequence(0, "bring", "your", "own")).andNot(NodePattern.N.inFormSequence(0, "be", "all")).andNot(NodePattern.N.inFormSequence(0, "compile", "time")).andNot(NodePattern.N.inFormSequence(0, "infect", "deck")).andNot(NodePattern.N.inFormSequence(0, "grow", "room")).andNot(NodePattern.N.inFormSequence(0, "(un)?install", "logs?")).andNot(NodePattern.N.inFormSequence(0, "refinance", "rates?")).andNot(NodePattern.N.inFormSequence(0, "read|write", "(usage|lock|scope)s?|(mutex|access)(es)?")).andNot(NodePattern.N.inFormSequence(0, "ignore", "lists?")).andNot(NodePattern.N.inFormSequence(0, "include|exclude", "filters?")).andNot(NodePattern.N.inFormSequence(0, "forget", "gates?")).noForm("writes").andNot(NodePattern.N.inFormSequence(2, "pre|post", "-", "submit").withHeadRelation("compound")).noDependents("nmod", feature).andNot(NodePattern.N.withNextSibling(NodePattern.or(feature, NodePattern.N.withHeadRelation("compound:prt")))).andNot(NodePattern.N.withHead("nmod|obl", Semantics.composeForX)).andNot(Semantics.dockerCompose).andNot(NodePattern.N.withDependent("compound").withDependent("case", NodePattern.N.form("until|for"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.noSpaceBefore())).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter().andNot(NodePattern.N.directlyAfter(NodePattern.or(WordSeparation.hyphPref.spaceBefore(), NodePattern.N.form("re")))))).andNot(CommonPatterns.beforeSlashOrParenth).andOr(NodePattern.markedNodeMatches("Det", NodePattern.N.noPos("PRP.*").withHeadRelation("nmod:poss")).message("The verb '$_' doesn\u2019t seem to fit here"), NodePattern.N.message("The verb '$_' doesn\u2019t seem to fit after '$Det'"));
    }
}

