/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.QuantifierNounCompatibility;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum VerbInflectionNumber {
    I,
    singular,
    plural;

    private static final NodePattern commaOnlyEnumeration;
    private static final NodePattern theNationality;
    private static final NodePattern preferPlural;
    private static final NodePattern preferSingular;

    static VerbInflectionNumber from(@NotNull Node predicate, @Nullable Node agent) {
        return Objects.requireNonNullElse(VerbInflectionNumber.fromLikely(predicate, agent), plural);
    }

    @Nullable
    static VerbInflectionNumber fromLikely(@NotNull Node predicate, @Nullable Node agent) {
        if (agent == null || agent.hasForm("s?he|him|her|it")) {
            return singular;
        }
        if (agent.hasForm("I|me")) {
            return I;
        }
        if (agent.hasForm("you|we|us|they|them")) {
            return plural;
        }
        if (agent.headRelation().startsWith("csubj") || agent.hasForm("that") && predicate.head() == null) {
            return singular;
        }
        Number agentNumber = SubjectVerbAgreement.subjectNumber(agent, predicate);
        if (agentNumber == Number.ambiguous) {
            if (preferPlural.matches(agent)) {
                return plural;
            }
            if (preferSingular.matches(agent)) {
                return singular;
            }
            return null;
        }
        return agentNumber == Number.singular ? singular : plural;
    }

    static String inflectDo(@NotNull Node verb, @Nullable Node subject) {
        return VerbInflectionNumber.from(verb, subject).sameTense(verb).inflectDo();
    }

    static String inflectHave(@NotNull Node verb, @Nullable Node subject) {
        return VerbInflectionNumber.from(verb, subject).past(false).inflectHave();
    }

    Inflector past(boolean past) {
        return new Inflector(this, past);
    }

    Inflector sameTense(Node verb) {
        return this.past(verb.hasPos("VB[DN]"));
    }

    static {
        commaOnlyEnumeration = NodePattern.or(CommonPatterns.severalDependents("conj").withOnlyDependents(NodePattern.or(NodePattern.N.noHeadRelation("conj"), NodePattern.N.noDependents("cc").and(Commas.commaStartingPhrase))), CommonPatterns.severalDependents("appos"));
        theNationality = NodePattern.N.pos("NNP").inFormSequence(1, "the", ".+ish");
        preferPlural = NodePattern.or(EnglishTreePatterns.anyPercent.withDependent("nummod", NodePattern.N.beforeHead()), commaOnlyEnumeration, NodePattern.N.withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("and").directlyAfter(NodePattern.not(CommonPatterns.comma)))).noDependents("nmod").andNot(CommonPatterns.severalDependents("conj")), theNationality, Number.withEtAl, NodePattern.N.potentialPos("NNP?S").withDependent("nummod", QuantifierNounCompatibility.pluralNummod.markAs("Num")).noDependents("compound", NodePattern.N.before("Num")), NodePattern.N.pos("NNP?S"), NodePattern.N.potentialPos("CD"));
        preferSingular = NodePattern.or(NodePattern.N.pos("NNP?|VBG|PRP\\$"), NodePattern.N.pos("WP").withHead(NodePattern.N.noHeadRelation("acl:relcl")));
    }

    record Inflector(VerbInflectionNumber number, boolean past) {
        private static final NodePattern suggestWereInConditional = NodePattern.N.noForm("were").and(CommonPatterns.skipUp("cop|aux|aux:pass", NodePattern.N.withDependent("mark", NodePattern.N.form("if"))));

        static Inflector like(Node finiteVerb) {
            VerbInflectionNumber number = finiteVerb.hasPos("VBZ") ? singular : plural;
            return number.sameTense(finiteVerb);
        }

        String inflectBe() {
            return switch (this.number.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> {
                    if (this.past) {
                        yield "was";
                    }
                    yield "am";
                }
                case 1 -> {
                    if (this.past) {
                        yield "was";
                    }
                    yield "is";
                }
                case 2 -> this.past ? "were" : "are";
            };
        }

        String inflectDo() {
            return this.past ? "did" : (this.number == singular ? "does" : "do");
        }

        String inflectHave() {
            return this.past ? "had" : (this.number == singular ? "has" : "have");
        }

        @Nullable(value="when the verb already is correctly inflected")
        @Nullable(value="when the verb already is correctly inflected") NodeCorrector inflectFinite(Node verb) {
            if (verb.hasLemma("be")) {
                String be = this.inflectBe();
                if (be.substring(1).equals(verb.lowForm().substring(1))) {
                    return null;
                }
                if ("was".equals(be) && suggestWereInConditional.matches(verb)) {
                    return NodeCorrector.replace(verb, "were");
                }
                return NodeCorrector.replace(verb, be);
            }
            String targetPos = this.past ? "VBD" : (this.number == singular ? "VBZ" : "VBP");
            return verb.tagIndependently().hasPos(targetPos) ? null : NodeCorrector.inflect(verb, "VB.*", targetPos);
        }
    }
}

