/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.common.FeatureUtil;
import ai.grazie.rules.common.MessageUtil;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.uk.Case;
import ai.grazie.rules.uk.StyleRules;
import ai.grazie.rules.uk.UkrainianTreePatterns;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AgreementSet {
    private static final NodePattern needsDav = NodePattern.N.pos("noun:anim.*").withHead("obj", NodePattern.N.lemma("(\u0432\u0438|\u043f\u0440\u043e)\u0431\u0430\u0447[\u0430\u0438]\u0442\u0438"));
    private static final NodePattern needsRod = NodePattern.or(NodePattern.N.pos("(noun|adj):.*").withHead("obj", NodePattern.N.form("\u043d\u0435\u043c\u0430\u0454").noDependents("xcomp")), NodePattern.N.pos("(noun|adj):.*v_dav.*").noPos("noun.*v_zna.*").withHead("i?obj|nmod|advmod", NodePattern.N.lemma("(\u043d\u0430)?[\u0432\u0443]\u0447[\u0430\u0438]\u0442\u0438")).afterHead(), NodePattern.N.pos("(noun|adj):.*v_dav.*").withHead("i?obj|nmod|advmod", NodePattern.N.lemma("(\u043d\u0430)?[\u0432\u0443]\u0447[\u0430\u0438]\u0442\u0438(\u0441\u044f|\u0441\u044c)")).afterHead(), NodePattern.N.pos("noun:.*v_dav.*").noDependents("case").withHead("i?obj|nmod", NodePattern.N.lemma("\u043d\u0430\u0432\u0447\u0430\u043d\u043d\u044f")));
    private static final String exc234 = "\u043e\u043a\u043e|\u043f\u043b\u0435\u0447\u0435|\u043f\u043b\u0435\u043c'\u044f|\u0442\u0435\u043b\u044f|.*[\u0430\u044f]\u043d\u0438\u043d";
    private static final String money = "\u0433\u0440\u0438\u0432\u043d\u044f|\u0437\u043b\u043e\u0442\u0438\u0439|\u0434\u043e\u043b\u0430\u0440|\u0454\u0432\u0440\u043e|\u0440\u0443\u0431\u043b\u044c|\u0434\u0440\u0430\u043c|\u0444\u0443\u043d\u0442|\u044e\u0430\u043d\u044c";
    private static final String falseFraction = "[0-9].*[,.]([0-9][0-9][0-9])";
    private static final NodePattern rangeOrConj = NodePattern.N.withDependent("flat:range|conj|nmod", NodePattern.or(NodePattern.N.pos("numr.*|number"), NodePattern.N.withDependent("nummod")));
    private static final NodePattern iBilshe = NodePattern.N.withDependent("conj", NodePattern.N.form("\u0431\u0456\u043b\u044c\u0448\u0435"));
    private static final NodePattern commonFraction = NodePattern.N.pos("numr:p:v_naz").directlyBefore(NodePattern.N.pos("adj:p:v_rod:&numr"));
    private static final NodePattern n234 = NodePattern.N.form("(\u043e\u0431\u0438)?\u0434\u0432[\u0430\u0456]|\u0442\u0440\u0438|\u0447\u043e\u0442\u0438\u0440\u0438").andNot(commonFraction).andNot(iBilshe);
    private static final NodePattern n5Plus = NodePattern.or(NodePattern.N.form("\u043f'\u044f\u0442\u044c|\u0448\u0456\u0441\u0442\u044c|\u0441\u0456\u043c|\u0432\u0456\u0441\u0456\u043c|\u0434\u0435\u0432'\u044f\u0442\u044c|\u0441\u043e\u0440\u043e\u043a|(\u0434\u0435\u0432'\u044f\u043d\u043e)?\u0441\u0442\u043e|\u0434\u0432\u0456\u0441\u0442\u0456|\u0442\u0440\u0438\u0441\u0442\u0430|\u0447\u043e\u0442\u0438\u0440\u0438\u0441\u0442\u0430|\u0442\u0438\u0441\u044f\u0447([\u0430\u0456])?|\u043c\u0456\u043b\u044c\u0439\u043e\u043d(\u0438|\u0456\u0432)?|\u043c\u0456\u043b\u044c\u044f\u0440\u0434(\u0438|\u0456\u0432)?"), NodePattern.N.form(".*\u0434\u0446\u044f\u0442\u044c|.*\u0434\u0435\u0441\u044f\u0442\u044c?|.+\u0441\u043e\u0442|")).andNot(commonFraction);
    private static final NodePattern nFraction = NodePattern.N.form("\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430|\u0442\u0440\u0435\u0442\u0438\u043d\u0430|\u0447\u0432\u0435\u0440\u0442\u044c|\u043f\u0456\u0432\u0442\u043e\u0440[\u0430\u0438]|-?[0-9].*[,.]([0-9].+|[012346789])|0[.,]5").noForm("[0-9].*[,.]([0-9][0-9][0-9])").andNot(iBilshe);
    private static final NodePattern with234 = AgreementSet.withNummod(n234).noLemma("\u043e\u043a\u043e|\u043f\u043b\u0435\u0447\u0435|\u043f\u043b\u0435\u043c'\u044f|\u0442\u0435\u043b\u044f|.*[\u0430\u044f]\u043d\u0438\u043d");
    private static final NodePattern with234Ex = NodePattern.N.lemma("\u043e\u043a\u043e|\u043f\u043b\u0435\u0447\u0435|\u043f\u043b\u0435\u043c'\u044f|\u0442\u0435\u043b\u044f|.*[\u0430\u044f]\u043d\u0438\u043d").and(AgreementSet.withNummod(n234));
    private static final NodePattern withBilshe5 = AgreementSet.withNummod(n5Plus);
    private static final NodePattern withFraction = AgreementSet.withNummod(nFraction).noLemma("\u0433\u0440\u0438\u0432\u043d\u044f|\u0437\u043b\u043e\u0442\u0438\u0439|\u0434\u043e\u043b\u0430\u0440|\u0454\u0432\u0440\u043e|\u0440\u0443\u0431\u043b\u044c|\u0434\u0440\u0430\u043c|\u0444\u0443\u043d\u0442|\u044e\u0430\u043d\u044c");
    private static final NodePattern withGenNummod = NodePattern.or(withBilshe5, with234Ex, withFraction);
    private static final NodePattern withFractionNoGen = withFraction.noPos(".*p:v_rod.*");
    static final NodePattern nonMain = NodePattern.or(NodePattern.N.withDependent("(det:)?num(mod|gov).*", NodePattern.N.noForm("\u0431\u0430\u0433\u0430\u0442\u044c\u043e\u043c")).andNot(with234).andNot(withGenNummod), NodePattern.N.pos(".*numr").withDependent("nummod.*", nFraction), CommonPatterns.capitalizedMiddle, NodePattern.N.withDependent(".*", NodePattern.N.directlyBefore(UkrainianTreePatterns.openingQuotations)), NodePattern.N.directlyAfter(UkrainianTreePatterns.openingQuotations), NodePattern.N.withDependent("case", NodePattern.N.form("[\u0432\u0443]").directlyBefore(NodePattern.N.pos("number").withHeadRelation("amod"))), NodePattern.N.withDependent("case", NodePattern.N.form("\u0437\u0430")).andOr(NodePattern.N.withDependent("det|mark|discourse", NodePattern.N.form("\u0449\u043e")), NodePattern.N.withHead("nsubj", NodePattern.N.form("\u0449\u043e"))), NodePattern.N.withDependent("case", NodePattern.N.inFormSequence(0, "[\u0432\u0443]", "\u0442\u043e\u043c\u0443", "\u0447\u0438\u0441\u043b\u0456")), NodePattern.N.pos("adv.*").noPos("adj.*"), NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE), CommonPatterns.possiblySkipDown("amod", NodePattern.N.withDependent("punct|amod", CommonPatterns.dot.andNot(CommonPatterns.lastWord))), NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter().directlyAfter(CommonPatterns.capitalizedMiddle.noSpaceAfter())), NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u0431\u0456\u0441|\u0432\u0438\u043f\u043b\u0430\u0442"), NodePattern.N.inFormSequence(0, "\u0441\u0432\u044f\u0442(\u0430\u044f?|\u0435)", "\u0441\u0432\u044f\u0442\u0438\u0445"), NodePattern.N.form("\u044f|\u043d\u0443\u043b\u044c"), NodePattern.N.inFormSequence(1, "\u043f\u043e\u043d\u0430\u0434", "\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430|\u0442\u0440\u0435\u0442\u0438\u043d\u0430|\u0441\u043e\u0442\u043d\u044f"), NodePattern.N.pos(".*v_naz.*numr").directlyAfter(NodePattern.N.form("\u043f\u043e\u043d\u0430\u0434")), NodePattern.N.form("\u0442\u0438\u0441|\u0440\u0443\u0431").directlyBefore(CommonPatterns.dot), NodePattern.N.form("\u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u0443|\u0441\u043a\u043b\u0430\u0434\u0443"), NodePattern.N.lemma("\u0434\u0435\u0441\u044f\u0442\u043a\u0430|\u0441\u043e\u0442\u043d\u044f"), NodePattern.N.pos("numr:.*").withHeadRelation("nmod"), StyleRules.naManir);
    private static final NodePattern takeAdjective = NodePattern.N.directlyBefore(NodePattern.not(NodePattern.or(NodePattern.N.withHeadRelation("nummod.*"), CommonPatterns.HYPHEN_NODE))).andNot(NodePattern.N.withHeadRelation("det|amod").afterHead().andOr(NodePattern.N.directlyAfter(CommonPatterns.comma), NodePattern.N.directlyBefore(CommonPatterns.comma))).andNot(NodePattern.N.withHeadRelation("det").withNextSibling(NodePattern.or(n5Plus, NodePattern.N.withNextSibling(n5Plus))));
    private final Node main;
    private final List<Node> adjectives = new ArrayList<Node>();
    private final Map<Node, LinkedHashSet<InflectedForm>> node2Features = new LinkedHashMap<Node, LinkedHashSet<InflectedForm>>();
    private final FeatureRestriction<Case> possibleCases;
    private final Number numberRestriction;

    private static NodePattern withNummod(NodePattern nummod) {
        return NodePattern.N.withDependent("nummod.*", NodePattern.or(nummod.andNot(rangeOrConj), NodePattern.N.withDependent("flat:range|conj|nmod", nummod.afterHead())).noDependents("nmod", NodePattern.N.noForm("\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u043e\u044e")).markAs("Num"));
    }

    private AgreementSet(Node main, List<InflectedForm> onMain, List<Node> adjectives) {
        this.main = main;
        this.node2Features.put(main, new LinkedHashSet<InflectedForm>(onMain));
        for (Node adj : adjectives) {
            if ((adj = this.initForms(adj)) == null) continue;
            this.adjectives.add(adj);
        }
        this.possibleCases = AgreementSet.calcPossibleCases(main);
        this.numberRestriction = AgreementSet.calcNumberRestriction(main);
    }

    @Nullable
    private Node initForms(Node node) {
        List<InflectedForm> forms = InflectedForm.fromPosTags(node);
        if (forms.isEmpty()) {
            return null;
        }
        this.node2Features.put(node, new LinkedHashSet<InflectedForm>(forms));
        return node;
    }

    @Nullable
    static AgreementSet create(Node main) {
        if (nonMain.matches(main)) {
            return null;
        }
        List<InflectedForm> onMain = InflectedForm.fromNPHead(main);
        if (onMain.isEmpty()) {
            return null;
        }
        List adjectives = ((StreamEx)((StreamEx)StreamEx.of(main.findDependents("det.*|amod")).filter(takeAdjective::matches)).flatMap(n -> StreamEx.of((Object)n).append(n.findDependents("det|amod|conj"))).filter(takeAdjective::matches)).toList();
        return new AgreementSet(main, onMain, adjectives);
    }

    @Nullable
    NodeMatch check(NodeMatch match) {
        if (StreamEx.of(this.adjectives).append((Object)this.main).anyMatch(node -> this.filterCaseAndNumber((Collection<InflectedForm>)this.node2Features.get(node)).isEmpty())) {
            return this.fixCaseAndNumber(match);
        }
        return null;
    }

    private NodeMatch fixCaseAndNumber(NodeMatch match) {
        match = this.suggestCasesAndNumbers(match, new ArrayList<Case>(this.possibleCases.allowed()));
        List caseNames = ((StreamEx)((StreamEx)StreamEx.of(this.possibleCases.allowed()).sorted()).map(c -> c.presentableGen).distinct()).toList();
        return match.withTouchedNodes(this.node2Features.keySet()).withMessage(this.possibleCases.reason() + " \u0432\u0438\u043c\u0430\u0433\u0430\u0454 " + MessageUtil.coordinate(caseNames, " \u0447\u0438 ", " \u0447\u0438 ") + " \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0430" + (String)(this.numberRestriction != null ? " " + this.numberRestriction.presentableGen : ""));
    }

    private NodeMatch suggestCasesAndNumbers(NodeMatch match, List<Case> possibleCases) {
        List<InflectedForm> toTry = this.possibleInflections(possibleCases);
        for (InflectedForm form : toTry) {
            Map<Node, NodeCorrector> correctors = this.imposeFeatures(form);
            match = match.withCorrector(NodeCorrector.joinAll(correctors.values())).withReportedNodes(correctors.keySet());
        }
        return match;
    }

    private List<InflectedForm> possibleInflections(Collection<Case> possibleCases) {
        LinkedHashSet<InflectedForm> onMain = this.node2Features.get(this.main);
        ArrayList availableFeatures = Lists.newArrayList((Iterable)Iterables.concat(this.node2Features.values()));
        List<Gender> genders = AgreementSet.possibleFeatures(onMain, f -> f.gender);
        if (genders.isEmpty()) {
            Collections.addAll(genders, Gender.values());
            genders.add(null);
        }
        List<Number> numbers = this.numberRestriction != null ? List.of(this.numberRestriction) : AgreementSet.possibleFeatures(availableFeatures, f -> f.number);
        ArrayList<InflectedForm> result = new ArrayList<InflectedForm>();
        for (Case caze : possibleCases) {
            if (numbers.contains((Object)Number.s)) {
                for (Gender gender : genders) {
                    result.add(new InflectedForm(caze, gender, Number.s));
                }
            }
            InflectedForm plural = new InflectedForm(caze, null, Number.p);
            if (!numbers.contains((Object)Number.p)) continue;
            result.add(plural);
        }
        return result;
    }

    private static <T> List<T> possibleFeatures(Collection<InflectedForm> forms, Function<InflectedForm, T> extractor) {
        return ((StreamEx)((StreamEx)StreamEx.of(forms).map(extractor).filter(Objects::nonNull)).distinct()).toList();
    }

    private Set<InflectedForm> filterCaseAndNumber(Collection<InflectedForm> forms) {
        return ((StreamEx)StreamEx.of(forms).filter(f -> f.matchesCase(this.possibleCases.allowed()) && f.matchesNumber(this.numberRestriction))).toSet();
    }

    static FeatureRestriction<Case> calcPossibleCases(Node node) {
        Node head = node.head();
        if (head != null && needsDav.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{Case.v_dav});
        }
        NodeMatch match = with234.match(node, NodeMatch.EMPTY);
        if (match != null) {
            return FeatureRestriction.restricted((Node)match.getMarkedNode("Num"), (Enum[])new Case[]{Case.v_naz});
        }
        if (head != null && needsRod.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{Case.v_rod});
        }
        match = withGenNummod.match(node, NodeMatch.EMPTY);
        if (match != null) {
            return FeatureRestriction.restricted((Node)match.getMarkedNode("Num"), (Enum[])new Case[]{Case.v_rod});
        }
        Node prep = AgreementSet.findPreposition(node);
        if (Case.genHyphenatedPrep.matches(prep)) {
            String complexPrep = prep.lowForm() + "-" + prep.neighbor(2).lowForm();
            return FeatureRestriction.restricted((String)prep.tree().treeSupport().quote(complexPrep), (Enum[])new Case[]{Case.v_rod});
        }
        return prep != null && prep.isBefore(node) ? Case.calcPrepositionCases(prep) : Case.allCases;
    }

    private static Number calcNumberRestriction(Node node) {
        if (with234.matches(node) || withBilshe5.matches(node)) {
            return Number.p;
        }
        if (with234Ex.matches(node) || withFractionNoGen.matches(node)) {
            return Number.s;
        }
        if (needsRod.matches(node) && node.hasPos(".*p:v_dav.*")) {
            return Number.p;
        }
        return null;
    }

    @Nullable
    static Node findPreposition(Node node) {
        return node.findSingleDependent("case");
    }

    private Map<Node, NodeCorrector> imposeFeatures(@NotNull InflectedForm form) {
        LinkedHashMap<Node, NodeCorrector> result = new LinkedHashMap<Node, NodeCorrector>();
        for (Map.Entry<Node, LinkedHashSet<InflectedForm>> entry : this.node2Features.entrySet()) {
            Node target = entry.getKey();
            if (entry.getValue().stream().anyMatch(f -> f.unify(form) != null)) continue;
            NodeCorrector correctors = form.inflect(target);
            if (correctors == null) {
                return Collections.emptyMap();
            }
            result.put(target, correctors);
        }
        return result;
    }

    public String toString() {
        return "AgreementSet{main=" + String.valueOf(this.main) + ", possibleCases=" + String.valueOf(this.possibleCases) + "}";
    }

    private static enum Number {
        s("\u043e\u0434\u043d\u0438\u043d\u0438"),
        p("\u043c\u043d\u043e\u0436\u0438\u043d\u0438");

        private final String presentableGen;

        private Number(String presentableGen) {
            this.presentableGen = presentableGen;
        }
    }

    record InflectedForm(Case caze, Gender gender, Number number) {
        private static final Pattern supportedPosTags = Pattern.compile("noun.*|adj.*|numr.*");

        @Nullable
        InflectedForm unify(InflectedForm another) {
            if (!FeatureUtil.areCompatible(this.caze, another.caze)) {
                return null;
            }
            if (!FeatureUtil.areCompatible(this.gender, another.gender)) {
                return null;
            }
            if (!FeatureUtil.areCompatible(this.number, another.number)) {
                return null;
            }
            return new InflectedForm(FeatureUtil.unifyValues(this.caze, another.caze), FeatureUtil.unifyValues(this.gender, another.gender), FeatureUtil.unifyValues(this.number, another.number));
        }

        boolean matchesCase(Set<Case> possibleCases) {
            return this.caze == null || possibleCases.contains((Object)this.caze);
        }

        boolean matchesNumber(Number numberRestriction) {
            return numberRestriction == null || this.number == numberRestriction;
        }

        private NodeCorrector inflect(Node target) {
            assert (this.caze != null);
            if (target.hasPos("adj.*") && target.hasHeadRelation("amod")) {
                return this.inflectNounLike(target, "adj");
            }
            if (target.hasPos("noun.*") && !target.hasHeadRelation("det")) {
                return this.inflectNounLike(target, "noun");
            }
            if (target.hasPos("adj.*")) {
                return this.inflectNounLike(target, "adj");
            }
            if (target.hasPos("numr.*")) {
                return this.inflectNounLike(target, "numr");
            }
            return null;
        }

        private NodeCorrector inflectNounLike(Node target, String pos) {
            String genderNumberRegexp = this.gender != null ? this.gender.toString() : (this.number != null ? this.number.toString() : "[mfnsp]");
            return NodeCorrector.inflect(target, pos + "(:.*)?(:[mfnsp]):(v_...)(.*)", pos + "$1:" + genderNumberRegexp + ":" + String.valueOf((Object)this.caze) + "(:rinanim)?$4(:&predic)?");
        }

        static List<InflectedForm> fromPosTags(Node node) {
            return InflectedForm.fromPosTags(node.tagIndependently().posReadings());
        }

        static List<InflectedForm> fromPosTags(List<String> posReadings) {
            LinkedHashSet<InflectedForm> result = new LinkedHashSet<InflectedForm>();
            for (String pos : posReadings) {
                InflectedForm features;
                if (!supportedPosTags.matcher(pos).matches() || (features = InflectedForm.fromPos(pos)) == null) continue;
                result.add(features);
            }
            return new ArrayList<InflectedForm>(result);
        }

        private static InflectedForm fromPos(String pos) {
            Set<String> sections = Set.of(StringUtils.split((String)pos, (char)':'));
            Case caze = FeatureUtil.findEnumConstant(sections, Case.values());
            Gender gender = FeatureUtil.findEnumConstant(sections, Gender.values());
            Number number = FeatureUtil.findEnumConstant(sections, Number.values());
            return caze == null && gender == null && number == null ? null : new InflectedForm(caze, gender, gender != null ? Number.s : number);
        }

        static List<InflectedForm> fromNPHead(Node main) {
            return InflectedForm.fromPosTags(main);
        }
    }

    private static enum Gender {
        m,
        f,
        n;

    }
}

