/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.ExpressionInfoFactory;
import com.intellij.javascript.debugger.JSDebuggerSupportUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugAwareBase;", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugAware;", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "<init>", "(Lcom/intellij/openapi/fileTypes/LanguageFileType;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getEvaluationInfo", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "expressionInfoFactory", "Lcom/intellij/javascript/debugger/ExpressionInfoFactory;", "intellij.javascript.debugger.backend"})
public abstract class JavaScriptDebugAwareBase
extends JavaScriptDebugAware {
    @NotNull
    private final LanguageFileType fileType;

    public JavaScriptDebugAwareBase(@NotNull LanguageFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.fileType = fileType;
    }

    @NotNull
    protected final LanguageFileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final Promise<ExpressionInfo> getEvaluationInfo(@NotNull PsiElement element, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)expressionInfoFactory, (String)"expressionInfoFactory");
        Promise<ExpressionInfo> promise = JSDebuggerSupportUtils.getEvaluationInfo(element, document, expressionInfoFactory);
        Intrinsics.checkNotNullExpressionValue(promise, (String)"getEvaluationInfo(...)");
        return promise;
    }
}

