/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceColumnNumberWithNameIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "getRefExpr", "Lcom/intellij/sql/psi/impl/SqlPositionalReference;", "getRefName", "expr", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlReplaceColumnNumberWithNameIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlReplaceColumnNumberWithNameIntention.kt\ncom/intellij/sql/intentions/SqlReplaceColumnNumberWithNameIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class SqlReplaceColumnNumberWithNameIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.column.number.with.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getRefName(element) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlPositionalReference sqlPositionalReference = this.getRefExpr(element);
        if (sqlPositionalReference == null) {
            return;
        }
        SqlPositionalReference refExpr = sqlPositionalReference;
        String string = this.getRefName(refExpr);
        if (string == null) {
            return;
        }
        String name = string;
        PsiFile file = element.getContainingFile();
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)file));
        PsiElement psiElement = refExpr.resolve();
        DasObject dasObject = psiElement instanceof DasObject ? (DasObject)psiElement : null;
        if (dasObject != null) {
            DasObject it = dasObject;
            boolean bl2 = false;
            bl = DbSqlUtil.isQuoted((DasObject)it);
        } else {
            bl = false;
        }
        boolean forceQuoting = bl;
        String refText = dialect.getDatabaseDialect().catToScript(name, refExpr.getKind(), forceQuoting, false, Casing.EXACT);
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText((String)refText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (SqlReferenceElementType)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (PsiElement)((PsiElement)file));
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression newRefExpr = sqlReferenceExpression;
        refExpr.replace((PsiElement)newRefExpr);
    }

    private final SqlPositionalReference getRefExpr(PsiElement element) {
        PsiElement psiElement = element.getParent();
        return psiElement instanceof SqlPositionalReference ? (SqlPositionalReference)psiElement : null;
    }

    private final String getRefName(PsiElement element) {
        String string;
        SqlPositionalReference sqlPositionalReference = this.getRefExpr(element);
        if (sqlPositionalReference != null) {
            SqlPositionalReference it = sqlPositionalReference;
            boolean bl = false;
            string = this.getRefName(it);
        } else {
            string = null;
        }
        return string;
    }

    private final String getRefName(SqlPositionalReference expr) {
        PsiElement source = expr.getReference().resolveImmediate();
        return source instanceof SqlColumnSymbol ? (((SqlColumnSymbol)source).getTargetDefinition() instanceof PsiNamedElement ? ((SqlColumnSymbol)source).getName() : null) : (source instanceof PsiNamedElement ? ((PsiNamedElement)source).getName() : null);
    }
}

