/*
 * Decompiled with CFR 0.152.
 */
package andel.intervals;

import andel.editor.AnchorId;
import andel.editor.RangeMarkerId;
import andel.intervals.AnchorsQuery;
import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.intervals.IntervalsUtilKt;
import andel.intervals.impl.AnchorStorageSerializer;
import andel.operation.NewOffsetProvider;
import andel.operation.NewOffsetProviderKt;
import andel.operation.Operation;
import andel.operation.Sticky;
import andel.text.Text;
import andel.text.TextRange;
import fleet.util.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=AnchorStorageSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 72\u00020\u0001:\u00017B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J.\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0012J\u001e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020$J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J8\u0010'\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100)J\u0015\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010/\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u00100\u001a\u00020\u001b2\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u000206H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00068"}, d2={"Landel/intervals/AnchorStorage;", "Landel/intervals/AnchorsQuery;", "intervals", "Landel/intervals/Intervals;", "Lfleet/util/UID;", "", "<init>", "(Landel/intervals/Intervals;)V", "getIntervals", "()Landel/intervals/Intervals;", "resolveAnchor", "", "anchorId", "Landel/editor/AnchorId;", "(Landel/editor/AnchorId;)Ljava/lang/Long;", "resolveRangeMarker", "Landel/text/TextRange;", "markerId", "Landel/editor/RangeMarkerId;", "addAnchor", "offset", "sticky", "Landel/operation/Sticky;", "addRangeMarker", "from", "to", "closedLeft", "", "closedRight", "removeAnchor", "removeRangeMarker", "rangeMarkerId", "edit", "before", "Landel/text/Text;", "after", "Landel/operation/Operation;", "newOffsetProvider", "Landel/operation/NewOffsetProvider;", "batchUpdate", "anchorIds", "", "anchorOffsets", "", "rangeIds", "ranges", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nAnchorStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchorStorage.kt\nandel/intervals/AnchorStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1563#3:85\n1634#3,3:86\n1573#3:89\n1604#3,4:90\n1573#3:94\n1604#3,4:95\n*S KotlinDebug\n*F\n+ 1 AnchorStorage.kt\nandel/intervals/AnchorStorage\n*L\n77#1:85\n77#1:86,3\n79#1:89\n79#1:90,4\n80#1:94\n80#1:95,4\n*E\n"})
public final class AnchorStorage
implements AnchorsQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Intervals<UID, Unit> intervals;

    public AnchorStorage(@NotNull Intervals<UID, Unit> intervals) {
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        this.intervals = intervals;
    }

    @NotNull
    public final Intervals<UID, Unit> getIntervals() {
        return this.intervals;
    }

    @Override
    @Nullable
    public Long resolveAnchor(@NotNull AnchorId anchorId) {
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        Interval interval = this.intervals.findById(anchorId.getId());
        if (interval == null) {
            return null;
        }
        if (!(interval.from == interval.to)) {
            boolean bl2 = false;
            String string2 = "nonempty interval found for anchor " + anchorId;
            throw new IllegalArgumentException(string2.toString());
        }
        return interval.from;
    }

    @Override
    @Nullable
    public TextRange resolveRangeMarker(@NotNull RangeMarkerId markerId) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)markerId, (String)"markerId");
        Interval interval = this.intervals.findById(markerId.getId());
        if (interval != null) {
            Interval it = interval;
            boolean bl2 = false;
            textRange = new TextRange(it.from, it.to);
        } else {
            textRange = null;
        }
        return textRange;
    }

    @NotNull
    public final AnchorStorage addAnchor(@NotNull AnchorId anchorId, long offset, @NotNull Sticky sticky) {
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        Intrinsics.checkNotNullParameter((Object)((Object)sticky), (String)"sticky");
        Interval<UID, Unit> intervalToAdd = new Interval<UID, Unit>(anchorId.getId(), offset, offset, sticky == Sticky.LEFT, sticky == Sticky.RIGHT, Unit.INSTANCE);
        return this.copy(this.intervals.addIntervals(CollectionsKt.listOf(intervalToAdd)));
    }

    @NotNull
    public final AnchorStorage addRangeMarker(@NotNull RangeMarkerId markerId, long from, long to, boolean closedLeft, boolean closedRight) {
        Intrinsics.checkNotNullParameter((Object)markerId, (String)"markerId");
        Interval<UID, Unit> intervalToAdd = new Interval<UID, Unit>(markerId.getId(), from, to, closedLeft, closedRight, Unit.INSTANCE);
        return this.copy(this.intervals.addIntervals(CollectionsKt.listOf(intervalToAdd)));
    }

    @NotNull
    public final AnchorStorage removeAnchor(@NotNull AnchorId anchorId) {
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        return this.copy(this.intervals.removeByIds(CollectionsKt.listOf((Object)anchorId.getId())));
    }

    @NotNull
    public final AnchorStorage removeRangeMarker(@NotNull RangeMarkerId rangeMarkerId) {
        Intrinsics.checkNotNullParameter((Object)rangeMarkerId, (String)"rangeMarkerId");
        return this.copy(this.intervals.removeByIds(CollectionsKt.listOf((Object)rangeMarkerId.getId())));
    }

    @NotNull
    public final AnchorStorage edit(@NotNull Text before, @NotNull Text after, @NotNull Operation edit) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
        return this.copy(this.intervals.edit(edit));
    }

    @NotNull
    public final AnchorStorage edit(@NotNull NewOffsetProvider newOffsetProvider) {
        Intrinsics.checkNotNullParameter((Object)newOffsetProvider, (String)"newOffsetProvider");
        return this.copy(NewOffsetProviderKt.edit(this.intervals, newOffsetProvider));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnchorStorage batchUpdate(@NotNull List<AnchorId> anchorIds, @NotNull long[] anchorOffsets, @NotNull List<RangeMarkerId> rangeIds, @NotNull List<TextRange> ranges) {
        int i2;
        RangeMarkerId anchorId;
        int n2;
        Iterable $this$mapIndexedTo$iv$iv;
        Collection collection;
        RangeMarkerId it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(anchorIds, (String)"anchorIds");
        Intrinsics.checkNotNullParameter((Object)anchorOffsets, (String)"anchorOffsets");
        Intrinsics.checkNotNullParameter(rangeIds, (String)"rangeIds");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Iterable $this$map$iv = anchorIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator iterator2 = (AnchorId)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(((AnchorId)((Object)it)).getId());
        }
        $this$map$iv = rangeIds;
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RangeMarkerId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getId());
        }
        List idsToRemove = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        Iterable $this$mapIndexed$iv = anchorIds;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AnchorId anchorId2 = (AnchorId)item$iv$iv;
            int n3 = n2;
            collection2 = destination$iv$iv2;
            boolean bl4 = false;
            collection2.add(new Interval<UID, Unit>(((AnchorId)((Object)anchorId)).getId(), anchorOffsets[i2], anchorOffsets[i2], true, false, Unit.INSTANCE));
        }
        $this$mapIndexed$iv = rangeIds;
        collection2 = (List)destination$iv$iv2;
        $i$f$mapIndexed = false;
        $this$mapIndexedTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        $i$f$mapIndexedTo = false;
        index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void rangeId;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            anchorId = (RangeMarkerId)item$iv$iv;
            i2 = n2;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            collection.add(new Interval<UID, Unit>(rangeId.getId(), ranges.get(i2).getStart(), ranges.get(i2).getEnd(), false, false, Unit.INSTANCE));
        }
        List intervalsToAdd = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv2));
        return this.copy(this.intervals.removeByIds(idsToRemove).addIntervals(intervalsToAdd));
    }

    @NotNull
    public final Intervals<UID, Unit> component1() {
        return this.intervals;
    }

    @NotNull
    public final AnchorStorage copy(@NotNull Intervals<UID, Unit> intervals) {
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        return new AnchorStorage(intervals);
    }

    public static /* synthetic */ AnchorStorage copy$default(AnchorStorage anchorStorage, Intervals intervals, int n2, Object object) {
        if ((n2 & 1) != 0) {
            intervals = anchorStorage.intervals;
        }
        return anchorStorage.copy(intervals);
    }

    @NotNull
    public String toString() {
        return "AnchorStorage(intervals=" + this.intervals + ")";
    }

    public int hashCode() {
        return this.intervals.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnchorStorage)) {
            return false;
        }
        AnchorStorage anchorStorage = (AnchorStorage)other;
        return Intrinsics.areEqual(this.intervals, anchorStorage.intervals);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a8\u0006\b"}, d2={"Landel/intervals/AnchorStorage$Companion;", "", "<init>", "()V", "empty", "Landel/intervals/AnchorStorage;", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.andel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnchorStorage empty() {
            return new AnchorStorage(IntervalsUtilKt.keyed(Intervals.Companion.keepingCollapsed()).empty());
        }

        @NotNull
        public final KSerializer<AnchorStorage> serializer() {
            return AnchorStorageSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

