/*
 * Decompiled with CFR 0.152.
 */
package andel.text;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.MutableDocument;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import fleet.codepoints.Codepoint;
import fleet.codepoints.CodepointClass;
import fleet.codepoints.CodepointClassKt;
import fleet.codepoints.CodepointKt;
import fleet.codepoints.Direction;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a0\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a(\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0001\u001a0\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0001\u001a\u001e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0001\u001a \u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\u0019"}, d2={"stopOnCodepointClass", "", "before", "Lfleet/codepoints/CodepointClass;", "after", "direction", "Lfleet/codepoints/Direction;", "honorCamelHumps", "stopAfterSpace", "textRight", "", "offset", "text", "Landel/text/TextView;", "range", "Landel/text/TextRange;", "textLeft", "textAround", "requireWordAtCaret", "caret", "Landel/editor/CaretPosition;", "document", "Landel/editor/MutableDocument;", "textAroundOrNull", "Landel/editor/Caret;", "fleet.andel"})
public final class NavigationKt {
    private static final boolean stopOnCodepointClass(CodepointClass before, CodepointClass after, Direction direction, boolean honorCamelHumps, boolean stopAfterSpace) {
        boolean upDownSwitchCase = before == CodepointClass.UPPERCASE && after == CodepointClass.LOWERCASE;
        boolean downUpSwitchCase = before == CodepointClass.LOWERCASE && after == CodepointClass.UPPERCASE;
        boolean underscoreIsPrev = before == CodepointClass.UNDERSCORE && after != CodepointClass.UNDERSCORE;
        boolean underscoreIsNext = before != CodepointClass.UNDERSCORE && after == CodepointClass.UNDERSCORE;
        return before == CodepointClass.CARET ? false : (before == after ? false : (before == CodepointClass.SPACE ? stopAfterSpace : (before == CodepointClass.SEPARATOR ? true : (after == CodepointClass.SEPARATOR ? true : (after == CodepointClass.NEWLINE ? true : (after == CodepointClass.SPACE ? true : (underscoreIsPrev || underscoreIsNext ? honorCamelHumps : (downUpSwitchCase ? direction == Direction.FORWARD && honorCamelHumps : (upDownSwitchCase ? direction == Direction.BACKWARD && honorCamelHumps : true)))))))));
    }

    public static final long textRight(long offset, @NotNull TextView text, @NotNull TextRange range, boolean honorCamelHumps, boolean stopAfterSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (offset == range.getEnd()) {
            return offset;
        }
        Iterator<Codepoint> cursor = CodepointKt.codepoints(TextViewExtKt.charSequence(text), (int)offset, Direction.FORWARD);
        CodepointClass classBefore = CodepointClass.CARET;
        long charOffset = offset;
        Iterator<Codepoint> iterator2 = cursor;
        while (iterator2.hasNext()) {
            int codepoint = iterator2.next().unbox-impl();
            CodepointClass classAfter = CodepointClassKt.codepointClass(codepoint);
            if (NavigationKt.stopOnCodepointClass(classBefore, classAfter, Direction.FORWARD, honorCamelHumps, stopAfterSpace) || charOffset >= range.getEnd()) {
                return charOffset;
            }
            charOffset += (long)Codepoint.getCharCount-impl(codepoint);
            classBefore = classAfter;
        }
        return charOffset;
    }

    public static final long textRight(long offset, @NotNull TextView text, boolean honorCamelHumps, boolean stopAfterSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return NavigationKt.textRight(offset, text, new TextRange(0L, (long)text.getCharCount()), honorCamelHumps, stopAfterSpace);
    }

    private static final long textLeft(long offset, TextView text, TextRange range, boolean honorCamelHumps, boolean stopAfterSpace) {
        if (offset == range.getStart()) {
            return offset;
        }
        Iterator<Codepoint> cursor = CodepointKt.codepoints(TextViewExtKt.charSequence(text), (int)offset, Direction.BACKWARD);
        CodepointClass classBefore = CodepointClass.CARET;
        long charOffset = offset;
        Iterator<Codepoint> iterator2 = cursor;
        while (iterator2.hasNext()) {
            int codepoint = iterator2.next().unbox-impl();
            CodepointClass classAfter = CodepointClassKt.codepointClass(codepoint);
            if (NavigationKt.stopOnCodepointClass(classBefore, classAfter, Direction.BACKWARD, honorCamelHumps, stopAfterSpace)) {
                return charOffset;
            }
            charOffset -= (long)Codepoint.getCharCount-impl(codepoint);
            classBefore = classAfter;
        }
        return charOffset;
    }

    public static final long textLeft(long offset, @NotNull TextView text, boolean honorCamelHumps, boolean stopAfterSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return NavigationKt.textLeft(offset, text, new TextRange(0L, (long)text.getCharCount()), honorCamelHumps, stopAfterSpace);
    }

    @NotNull
    public static final TextRange textAround(long offset, @NotNull TextView text, boolean honorCamelHumps, boolean requireWordAtCaret) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return NavigationKt.textAround(offset, text, new TextRange(0L, (long)text.getCharCount()), honorCamelHumps, requireWordAtCaret);
    }

    public static /* synthetic */ TextRange textAround$default(long l2, TextView textView, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        return NavigationKt.textAround(l2, textView, bl2, bl3);
    }

    @NotNull
    public static final TextRange textAround(long offset, @NotNull TextView text, @NotNull TextRange range, boolean honorCamelHumps, boolean requireWordAtCaret) {
        TextRange textRange;
        CodepointClass codepointClass;
        CodepointClass codepointClass2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        CodepointClass[] codepointClassArray = new CodepointClass[]{CodepointClass.LOWERCASE, CodepointClass.UPPERCASE, CodepointClass.UNDERSCORE};
        Set validCodepoints = SetsKt.setOf((Object[])codepointClassArray);
        boolean bl2 = false;
        Iterator<Codepoint> cursor = CodepointKt.codepoints(TextViewExtKt.charSequence(text), (int)offset, Direction.FORWARD);
        if (cursor.hasNext()) {
            int next2 = cursor.next().unbox-impl();
            codepointClass2 = CodepointClassKt.codepointClass(next2);
        } else {
            codepointClass2 = null;
        }
        CodepointClass rightCodepoint = codepointClass2;
        boolean bl3 = false;
        Iterator<Codepoint> cursor2 = CodepointKt.codepoints(TextViewExtKt.charSequence(text), (int)offset, Direction.BACKWARD);
        if (cursor2.hasNext()) {
            int prev = cursor2.next().unbox-impl();
            codepointClass = CodepointClassKt.codepointClass(prev);
        } else {
            codepointClass = null;
        }
        CodepointClass leftCodepoint = codepointClass;
        boolean isWordOnTheRight = CollectionsKt.contains((Iterable)validCodepoints, (Object)((Object)rightCodepoint));
        boolean isWordOnTheLeft = CollectionsKt.contains((Iterable)validCodepoints, (Object)((Object)leftCodepoint));
        if (!isWordOnTheRight && !isWordOnTheLeft && requireWordAtCaret) {
            return new TextRange(offset, offset);
        }
        if (isWordOnTheRight) {
            long end = NavigationKt.textRight(offset, text, range, honorCamelHumps, false);
            long start = NavigationKt.textLeft(end, text, range, honorCamelHumps, false);
            textRange = new TextRange(start, end);
        } else {
            long start = NavigationKt.textLeft(offset, text, range, honorCamelHumps, false);
            long end = NavigationKt.textRight(start, text, range, honorCamelHumps, false);
            textRange = new TextRange(start, end);
        }
        return textRange;
    }

    public static /* synthetic */ TextRange textAround$default(long l2, TextView textView, TextRange textRange, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl3 = true;
        }
        return NavigationKt.textAround(l2, textView, textRange, bl2, bl3);
    }

    @NotNull
    public static final TextRange textAround(@NotNull CaretPosition caret, @NotNull MutableDocument document2, boolean honorCamelHumps) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        return NavigationKt.textAround$default(caret.getOffset(), document2.getText().view(), honorCamelHumps, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final TextRange textAroundOrNull(@NotNull Caret caret, @NotNull TextView text, boolean honorCamelHumps) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextRange result2 = NavigationKt.textAround$default(caret.getOffset(), text, honorCamelHumps, false, 8, null);
        if (result2.getStart() >= result2.getEnd()) return null;
        long l2 = result2.getStart();
        long l3 = result2.getEnd();
        long l4 = caret.getOffset();
        if (l2 > l4) return null;
        if (l4 > l3) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        TextRange textRange = result2;
        return textRange;
    }
}

