/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIILocationInformation;
import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Objects;

public final class ASCIIPropertyListParser {
    public static final char WHITESPACE_SPACE = ' ';
    public static final char WHITESPACE_TAB = '\t';
    public static final char WHITESPACE_NEWLINE = '\n';
    public static final char WHITESPACE_CARRIAGE_RETURN = '\r';
    public static final char ARRAY_BEGIN_TOKEN = '(';
    public static final char ARRAY_END_TOKEN = ')';
    public static final char ARRAY_ITEM_DELIMITER_TOKEN = ',';
    public static final char DICTIONARY_BEGIN_TOKEN = '{';
    public static final char DICTIONARY_END_TOKEN = '}';
    public static final char DICTIONARY_ASSIGN_TOKEN = '=';
    public static final char DICTIONARY_ITEM_DELIMITER_TOKEN = ';';
    public static final char QUOTEDSTRING_BEGIN_TOKEN = '\"';
    public static final char QUOTEDSTRING_END_TOKEN = '\"';
    public static final char QUOTEDSTRING_ESCAPE_TOKEN = '\\';
    public static final char DATA_BEGIN_TOKEN = '<';
    public static final char DATA_END_TOKEN = '>';
    public static final char DATA_BASE64_BEGIN_TOKEN = '[';
    public static final char DATA_BASE64_END_TOKEN = ']';
    public static final char DATA_GSOBJECT_BEGIN_TOKEN = '*';
    public static final char DATA_GSDATE_BEGIN_TOKEN = 'D';
    public static final char DATA_GSBOOL_BEGIN_TOKEN = 'B';
    public static final char DATA_GSBOOL_TRUE_TOKEN = 'Y';
    public static final char DATA_GSBOOL_FALSE_TOKEN = 'N';
    public static final char DATA_GSINT_BEGIN_TOKEN = 'I';
    public static final char DATA_GSREAL_BEGIN_TOKEN = 'R';
    public static final char DATE_DATE_FIELD_DELIMITER = '-';
    public static final char DATE_TIME_FIELD_DELIMITER = ':';
    public static final char DATE_GS_DATE_TIME_DELIMITER = ' ';
    public static final char DATE_APPLE_DATE_TIME_DELIMITER = 'T';
    public static final char DATE_APPLE_END_TOKEN = 'Z';
    public static final char COMMENT_BEGIN_TOKEN = '/';
    public static final char MULTILINE_COMMENT_SECOND_TOKEN = '*';
    public static final char SINGLELINE_COMMENT_SECOND_TOKEN = '/';
    public static final char MULTILINE_COMMENT_END_TOKEN = '/';
    private final char[] data;
    private int index;
    private int lineNo = 1;
    private int lineBeginning = -1;

    private ASCIIPropertyListParser(byte[] propertyListContent, String encoding) throws UnsupportedEncodingException {
        this(new String(propertyListContent, encoding).toCharArray());
    }

    private ASCIIPropertyListParser(char[] propertyListContent) {
        this.data = propertyListContent;
    }

    public static NSObject parse(File f2) throws IOException, ParseException {
        return ASCIIPropertyListParser.parse(f2.toPath());
    }

    public static NSObject parse(File f2, String encoding) throws IOException, ParseException {
        return ASCIIPropertyListParser.parse(f2.toPath(), encoding);
    }

    public static NSObject parse(Path path, String encoding) throws IOException, ParseException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = ASCIIPropertyListParser.parse(fileInputStream, encoding);
            return nSObject;
        }
    }

    public static NSObject parse(Path path) throws IOException, ParseException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = ASCIIPropertyListParser.parse(fileInputStream);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream in) throws ParseException, IOException {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(in));
    }

    public static NSObject parse(InputStream in, String encoding) throws ParseException, IOException {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(in), encoding);
    }

    public static NSObject parse(Reader reader) throws ParseException, IOException {
        int read;
        Objects.requireNonNull(reader, "The specified reader is null");
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((read = reader.read(buf)) >= 0) {
            charArrayWriter.write(buf, 0, read);
        }
        ASCIIPropertyListParser parser2 = new ASCIIPropertyListParser(charArrayWriter.toCharArray());
        return parser2.parse();
    }

    public static NSObject parse(String plistData) throws ParseException {
        ASCIIPropertyListParser parser2 = new ASCIIPropertyListParser(plistData.toCharArray());
        return parser2.parse();
    }

    public static NSObject parse(byte[] bytes) throws ParseException {
        String charset = ByteOrderMarkReader.detect(bytes);
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            return ASCIIPropertyListParser.parse(bytes, charset);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("Unsupported property list encoding (" + charset + "): " + e2.getMessage());
        }
    }

    public static NSObject parse(byte[] bytes, String encoding) throws ParseException, UnsupportedEncodingException {
        ASCIIPropertyListParser parser2 = new ASCIIPropertyListParser(bytes, encoding);
        return parser2.parse();
    }

    private boolean acceptSequence(char ... sequence2) {
        if (this.index + sequence2.length > this.data.length) {
            return false;
        }
        for (int i2 = 0; i2 < sequence2.length; ++i2) {
            if (this.data[this.index + i2] == sequence2[i2]) continue;
            return false;
        }
        return true;
    }

    private boolean accept(char ... acceptableSymbols) {
        boolean symbolPresent = false;
        if (this.index < this.data.length) {
            for (char c2 : acceptableSymbols) {
                if (this.data[this.index] != c2) continue;
                symbolPresent = true;
                break;
            }
        }
        return symbolPresent;
    }

    private boolean accept(char acceptableSymbol) {
        return this.index < this.data.length && this.data[this.index] == acceptableSymbol;
    }

    private void expect(char ... expectedSymbols) throws ParseException {
        if (!this.accept(expectedSymbols)) {
            StringBuilder excString = new StringBuilder();
            excString.append("Expected '").append(expectedSymbols[0]).append("'");
            for (int i2 = 1; i2 < expectedSymbols.length; ++i2) {
                excString.append(" or '").append(expectedSymbols[i2]).append("'");
            }
            if (this.index < this.data.length) {
                excString.append(" but found '").append(this.data[this.index]).append("'");
            } else {
                excString.append(" but reached end of input");
            }
            throw this.createParseException(excString.toString(), this.index);
        }
    }

    private void expect(char expectedSymbol) throws ParseException {
        if (!this.accept(expectedSymbol)) {
            throw this.createParseException(this.index < this.data.length ? "Expected '" + expectedSymbol + "' but found '" + this.data[this.index] + "'" : "Expected '" + expectedSymbol + "' but reached end of input", this.index);
        }
    }

    private void read(char symbol) throws ParseException {
        this.expect(symbol);
        ++this.index;
    }

    private void skip() {
        ++this.index;
    }

    private void skip(int numSymbols) {
        this.index += numSymbols;
    }

    private void trackLineBreak() {
        if (this.data[this.index] == '\n') {
            ++this.lineNo;
            this.lineBeginning = this.index;
        }
        if (this.data[this.index] == '\r' && (this.index + 1 >= this.data.length || this.data[this.index + 1] != '\n')) {
            ++this.lineNo;
            this.lineBeginning = this.index;
        }
    }

    private void skipWhitespacesAndComments() {
        boolean commentSkipped;
        do {
            commentSkipped = false;
            while (this.accept('\r', '\n', ' ', '\t')) {
                this.trackLineBreak();
                this.skip();
            }
            if (this.acceptSequence('/', '/')) {
                this.skip(2);
                this.readInputUntil('\r', '\n');
                commentSkipped = true;
                continue;
            }
            if (!this.acceptSequence('/', '*')) continue;
            this.skip(2);
            while (this.index < this.data.length) {
                if (this.acceptSequence('*', '/')) {
                    this.skip(2);
                    break;
                }
                this.trackLineBreak();
                this.skip();
            }
            commentSkipped = true;
        } while (commentSkipped);
    }

    private String readInputUntil(char ... symbols) {
        StringBuilder strBuf = new StringBuilder();
        while (this.index < this.data.length && !this.accept(symbols)) {
            strBuf.append(this.data[this.index]);
            this.skip();
        }
        return strBuf.toString();
    }

    private String readInputUntil(char symbol) {
        StringBuilder strBuf = new StringBuilder();
        while (this.index < this.data.length && !this.accept(symbol)) {
            strBuf.append(this.data[this.index]);
            this.trackLineBreak();
            this.skip();
        }
        return strBuf.toString();
    }

    public NSObject parse() throws ParseException {
        this.index = 0;
        if (this.data.length == 0) {
            throw new ParseException("The property list is empty.", 0);
        }
        if (this.data[0] == '\ufeff') {
            this.skip(1);
        }
        this.skipWhitespacesAndComments();
        this.expect('{', '(', '/');
        try {
            return this.parseObject();
        }
        catch (ArrayIndexOutOfBoundsException ex2) {
            throw this.createParseException("Reached end of input unexpectedly.", this.index);
        }
    }

    private NSObject parseObject() throws ParseException {
        NSObject result2;
        ASCIILocationInformation loc = new ASCIILocationInformation(this.index, this.lineNo, this.index - this.lineBeginning);
        switch (this.data[this.index]) {
            case '(': {
                result2 = this.parseArray();
                break;
            }
            case '{': {
                result2 = this.parseDictionary();
                break;
            }
            case '<': {
                result2 = this.parseData();
                break;
            }
            case '\"': {
                String quotedString = this.parseQuotedString();
                if (quotedString.length() == 20 && quotedString.charAt(4) == '-') {
                    try {
                        result2 = new NSDate(quotedString);
                    }
                    catch (Exception ex2) {
                        result2 = new NSString(quotedString);
                    }
                    break;
                }
                result2 = new NSString(quotedString);
                break;
            }
            default: {
                result2 = this.data[this.index] >= '0' && this.data[this.index] <= '9' ? this.parseDateString() : new NSString(this.parseString());
            }
        }
        if (result2 != null) {
            result2.setLocationInformation(loc);
        }
        return result2;
    }

    private NSArray parseArray() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        LinkedList<NSObject> objects = new LinkedList<NSObject>();
        while (!this.accept(')')) {
            objects.add(this.parseObject());
            this.skipWhitespacesAndComments();
            if (!this.accept(',')) break;
            this.skip();
            this.skipWhitespacesAndComments();
        }
        this.read(')');
        return new NSArray(objects.toArray(new NSObject[0]));
    }

    private NSDictionary parseDictionary() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        NSDictionary dict = new NSDictionary();
        while (!this.accept('}')) {
            String keyString = this.accept('\"') ? this.parseQuotedString() : this.parseString();
            this.skipWhitespacesAndComments();
            this.read('=');
            this.skipWhitespacesAndComments();
            NSObject object = this.parseObject();
            dict.put(keyString, object);
            this.skipWhitespacesAndComments();
            this.read(';');
            this.skipWhitespacesAndComments();
        }
        this.skip();
        return dict;
    }

    private NSObject parseData() throws ParseException {
        int dataStartIndex = this.index;
        NSObject obj = null;
        this.skip();
        if (this.accept('*')) {
            this.skip();
            this.expect('B', 'D', 'I', 'R');
            if (this.accept('B')) {
                this.skip();
                this.expect('Y', 'N');
                obj = this.accept('Y') ? new NSNumber(true) : new NSNumber(false);
                this.skip();
            } else if (this.accept('D')) {
                this.skip();
                String dateString = this.readInputUntil('>');
                obj = new NSDate(dateString);
            } else if (this.accept('I', 'R')) {
                this.skip();
                String numberString = this.readInputUntil('>');
                try {
                    obj = new NSNumber(numberString);
                }
                catch (IllegalArgumentException ex2) {
                    throw this.createParseException("The NSNumber object has an invalid format.", dataStartIndex);
                }
            }
            this.read('>');
        } else if (this.accept('[')) {
            this.skip();
            String dataString = this.readInputUntil(']');
            try {
                obj = new NSData(dataString);
            }
            catch (IOException e2) {
                throw this.createParseException("The NSData object could be parsed.", dataStartIndex);
            }
            this.skip();
            this.read('>');
        } else {
            String dataString = this.readInputUntil('>');
            dataString = dataString.replaceAll("\\s+", "");
            int numBytes = dataString.length() / 2;
            byte[] bytes = new byte[numBytes];
            int bi2 = 0;
            int ci2 = 0;
            while (bi2 < bytes.length) {
                int nibble1 = Character.digit(dataString.charAt(ci2), 16);
                int nibble2 = Character.digit(dataString.charAt(ci2 + 1), 16);
                if (nibble1 == -1 || nibble2 == -1) {
                    throw this.createParseException("The NSData object contains non-hexadecimal characters.", dataStartIndex);
                }
                bytes[bi2] = (byte)(nibble1 << 4 | nibble2);
                ++bi2;
                ci2 += 2;
            }
            obj = new NSData(bytes);
            this.skip();
        }
        return obj;
    }

    private NSObject parseDateString() {
        String numericalString = this.parseString();
        if (numericalString.length() > 4 && numericalString.charAt(4) == '-') {
            try {
                return new NSDate(numericalString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NSString(numericalString);
    }

    private String parseString() {
        return this.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
    }

    private String parseQuotedString() throws ParseException {
        int startIndex = this.index;
        this.skip();
        StringBuilder stringBuilder = new StringBuilder();
        boolean unescapedBackslash = true;
        EscapeSequenceHandler escapeSequenceHandler = null;
        while (this.data[this.index] != '\"' || escapeSequenceHandler != null) {
            char c2 = this.data[this.index];
            if (escapeSequenceHandler != null) {
                if (escapeSequenceHandler.handleNextChar(c2)) {
                    escapeSequenceHandler = null;
                }
            } else if (c2 == '\\') {
                escapeSequenceHandler = new EscapeSequenceHandler(stringBuilder);
            } else {
                stringBuilder.append(c2);
            }
            this.trackLineBreak();
            this.skip();
        }
        if (escapeSequenceHandler != null) {
            escapeSequenceHandler.handleEndOfString();
        }
        this.skip();
        return stringBuilder.toString();
    }

    private ParseException createParseException(String message) {
        return this.createParseException(message, this.index);
    }

    private ParseException createParseException(String message, int index) {
        return new ParseException(message + " (" + this.lineNo + ":" + (index - this.lineBeginning) + ")", index);
    }

    private class EscapeSequenceHandler {
        private final int startIndex;
        private final StringBuilder stringBuilder;
        private int unicodeReferenceRadix = 0;
        private StringBuilder unicodeReference;

        public EscapeSequenceHandler(StringBuilder stringBuilder) {
            this.startIndex = ASCIIPropertyListParser.this.index;
            this.stringBuilder = stringBuilder;
        }

        public boolean handleNextChar(char c2) throws ParseException {
            switch (this.unicodeReferenceRadix) {
                case 8: {
                    return this.handleNextCharOfOctalEscapeSequence(c2);
                }
                case 16: {
                    return this.handleNextCharOfHexEscapeSequence(c2);
                }
            }
            return this.handleFirstChar(c2);
        }

        public void handleEndOfString() throws ParseException {
            String sequence2 = new String(ASCIIPropertyListParser.this.data, this.startIndex, ASCIIPropertyListParser.this.index - this.startIndex + 1);
            throw ASCIIPropertyListParser.this.createParseException("The property list contains a string with an incomplete escape sequence: " + sequence2, this.startIndex);
        }

        private boolean handleFirstChar(char c2) throws ParseException {
            switch (c2) {
                case '\"': 
                case '\'': 
                case '\\': {
                    this.stringBuilder.append(c2);
                    return true;
                }
                case 'b': {
                    this.stringBuilder.append('\b');
                    return true;
                }
                case 'n': {
                    this.stringBuilder.append('\n');
                    return true;
                }
                case 'r': {
                    this.stringBuilder.append('\r');
                    return true;
                }
                case 't': {
                    this.stringBuilder.append('\t');
                    return true;
                }
                case 'U': 
                case 'u': {
                    this.unicodeReferenceRadix = 16;
                    this.unicodeReference = new StringBuilder(4);
                    return false;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    this.unicodeReferenceRadix = 8;
                    this.unicodeReference = new StringBuilder(3);
                    this.unicodeReference.append(c2);
                    return false;
                }
            }
            throw ASCIIPropertyListParser.this.createParseException("The property list contains an invalid escape sequence: \\" + c2, this.startIndex);
        }

        private boolean handleNextCharOfHexEscapeSequence(char c2) throws ParseException {
            if (Character.digit(c2, 16) == -1) {
                String sequence2 = new String(ASCIIPropertyListParser.this.data, this.startIndex, ASCIIPropertyListParser.this.index - this.startIndex + 1);
                throw ASCIIPropertyListParser.this.createParseException("The property list contains a string with an invalid escape sequence: " + sequence2, this.startIndex);
            }
            this.unicodeReference.append(c2);
            if (this.unicodeReference.length() == 4) {
                char escapedChar = (char)Integer.parseInt(this.unicodeReference.toString(), 16);
                this.stringBuilder.append(escapedChar);
                return true;
            }
            return false;
        }

        private boolean handleNextCharOfOctalEscapeSequence(char c2) throws ParseException {
            if (Character.digit(c2, 8) == -1) {
                String sequence2 = new String(ASCIIPropertyListParser.this.data, this.startIndex, ASCIIPropertyListParser.this.index - this.startIndex + 1);
                throw ASCIIPropertyListParser.this.createParseException("The property list contains a string with an invalid escape sequence: " + sequence2, this.startIndex);
            }
            this.unicodeReference.append(c2);
            if (this.unicodeReference.length() == 3) {
                char escapedChar = (char)Integer.parseInt(this.unicodeReference.toString(), 8);
                this.stringBuilder.append(escapedChar);
                return true;
            }
            return false;
        }
    }
}

