/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNull;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class NSArray
extends NSObject {
    private NSObject[] array;

    public NSArray(int length) {
        this.array = new NSObject[length];
    }

    public NSArray(NSObject ... a2) {
        this.array = a2;
    }

    public NSObject objectAtIndex(int i2) {
        return this.array[i2];
    }

    public void remove(int i2) {
        if (i2 >= this.array.length || i2 < 0) {
            throw new ArrayIndexOutOfBoundsException("invalid index:" + i2 + ";the array length is " + this.array.length);
        }
        NSObject[] newArray = new NSObject[this.array.length - 1];
        System.arraycopy(this.array, 0, newArray, 0, i2);
        System.arraycopy(this.array, i2 + 1, newArray, i2, this.array.length - i2 - 1);
        this.array = newArray;
    }

    public void setValue(int key, Object value) {
        this.array[key] = NSObject.fromJavaObject(value);
    }

    public NSObject[] getArray() {
        return this.array;
    }

    public int count() {
        return this.array.length;
    }

    public boolean containsObject(Object obj) {
        NSObject nso = NSObject.fromJavaObject(obj);
        for (NSObject elem : this.array) {
            if (!(elem == null ? obj == null : elem.equals(nso))) continue;
            return true;
        }
        return false;
    }

    public int indexOfObject(Object obj) {
        NSObject nso = NSObject.fromJavaObject(obj);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (!this.array[i2].equals(nso)) continue;
            return i2;
        }
        return -1;
    }

    public int indexOfIdenticalObject(Object obj) {
        NSObject nso = NSObject.fromJavaObject(obj);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (this.array[i2] != nso) continue;
            return i2;
        }
        return -1;
    }

    public NSObject lastObject() {
        return this.array[this.array.length - 1];
    }

    public NSObject[] objectsAtIndexes(int ... indexes) {
        NSObject[] result2 = new NSObject[indexes.length];
        Arrays.sort(indexes);
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            result2[i2] = this.array[indexes[i2]];
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)obj).getArray(), this.array);
        }
        NSObject nso = NSObject.fromJavaObject(obj);
        if (nso.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)nso).getArray(), this.array);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Arrays.deepHashCode(this.array);
        return hash;
    }

    @Override
    public NSArray clone() {
        NSObject[] clonedArray = new NSObject[this.array.length];
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            clonedArray[i2] = this.array[i2] != null ? this.array[i2].clone() : null;
        }
        return new NSArray(clonedArray);
    }

    @Override
    public Object toJavaObject() {
        Object[] clonedArray = new Object[this.array.length];
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            clonedArray[i2] = this.array[i2] == null ? null : this.array[i2].toJavaObject();
        }
        return clonedArray;
    }

    @Override
    public int compareTo(NSObject o2) {
        Objects.requireNonNull(o2);
        if (o2 == this) {
            return 0;
        }
        if (o2 instanceof NSArray) {
            NSArray other = (NSArray)o2;
            if (other.count() != this.count()) {
                return Integer.compare(this.count(), other.count());
            }
            for (int i2 = 0; i2 < this.array.length; ++i2) {
                int itemDiff = NSNull.wrap(this.array[i2]).compareTo(NSNull.wrap(other.array[i2]));
                if (itemDiff == 0) continue;
                return itemDiff;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(o2.getClass().getName());
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<array>");
        xml.append(NSObject.NEWLINE);
        for (NSObject o2 : this.array) {
            NSNull.wrap(o2).toXML(xml, level + 1);
            xml.append(NSObject.NEWLINE);
        }
        this.indent(xml, level);
        xml.append("</array>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter out) {
        super.assignIDs(out);
        for (NSObject obj : this.array) {
            obj.assignIDs(out);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.writeIntHeader(10, this.array.length);
        for (NSObject obj : this.array) {
            out.writeID(out.getID(obj));
        }
    }

    public String toASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCII(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    public String toGnuStepASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCIIGnuStep(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.toASCII(ascii, level, false);
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.toASCII(ascii, level, true);
    }

    private void toASCII(StringBuilder ascii, int level, boolean gnustep) {
        this.indent(ascii, level);
        ascii.append('(');
        int indexOfLastNewLine = ascii.lastIndexOf(NEWLINE);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            NSObject entry = NSNull.wrap(this.array[i2]);
            Class<?> objClass = entry.getClass();
            if ((objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) && indexOfLastNewLine != ascii.length()) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
                if (gnustep) {
                    entry.toASCIIGnuStep(ascii, level + 1);
                } else {
                    entry.toASCII(ascii, level + 1);
                }
            } else {
                if (i2 != 0) {
                    ascii.append(' ');
                }
                if (gnustep) {
                    entry.toASCIIGnuStep(ascii, 0);
                } else {
                    entry.toASCII(ascii, 0);
                }
            }
            if (i2 != this.array.length - 1) {
                ascii.append(',');
            }
            if (ascii.length() - indexOfLastNewLine <= 80) continue;
            ascii.append(NEWLINE);
            indexOfLastNewLine = ascii.length();
        }
        ascii.append(')');
    }
}

